---
title: "ReactEurope Round-up"
layout: post
author: matthewjohnston4
---

Last month, the first React.js European conference took place in the city of Paris, at ReactEurope. Attendees were treated to a range of talks covering React, React Native, Flux, Relay, and GraphQL. Big thanks to everyone involved with organizing the conference, to all the attendees, and everyone who gave their time to speak - it wouldn't have been possible without the help and support of the React community.

[Christopher Chedeau](https://github.com/vjeux) gave the opening keynote to the conference:

<iframe width="100%" height="366" src="//www.youtube.com/embed/PAA9O4E1IM4" frameborder="0" allowfullscreen></iframe>

[Spencer Ahrens](https://github.com/sahrens) walks through building an advanced gestural UI leveraging the unique power of the React Native layout and animation systems to build a complex and fluid experience:

<iframe width="100%" height="366" src="//www.youtube.com/embed/xDlfrcM6YBk" frameborder="0" allowfullscreen></iframe>

[Lee Byron](https://github.com/leebyron) explores GraphQL, its core principles, how it works, and what makes it a powerful tool:

<iframe width="100%" height="366" src="//www.youtube.com/embed/WQLzZf34FJ8" frameborder="0" allowfullscreen></iframe>

[Joseph Savona](https://github.com/josephsavona) explores the problems Relay solves, its architecture and the query lifecycle, and how can you use Relay to build more scalable apps. There are examples of how Relay powers applications as complex as the Facebook News Feed:

<iframe width="100%" height="366" src="//www.youtube.com/embed/IrgHurBjQbg" frameborder="0" allowfullscreen></iframe>

[Nick Schrock](https://github.com/schrockn) and [Dan Schafer](https://github.com/dschafer) take a deeper dive into putting GraphQL to work. How can we build a GraphQL API to work with an existing REST API or server-side data model? What are best practices when building a GraphQL API, and how do they differ from traditional REST best practices? How does Facebook use GraphQL? Most importantly, what does a complete and coherent GraphQL API looks like, and how can we get started building one?

<iframe width="100%" height="366" src="//www.youtube.com/embed/gY48GW87Feo" frameborder="0" allowfullscreen></iframe>

[Sebastian Markbåge](https://github.com/sebmarkbage) talks about why the DOM is flawed and how it is becoming a second-class citizen in the land of React apps:

<iframe width="100%" height="366" src="//www.youtube.com/embed/Zemce4Y1Y-A" frameborder="0" allowfullscreen></iframe>

[Sebastian McKenzie](https://github.com/sebmck) goes over how existing JSX build pipeline infrastructure can be further utilised to perform even more significant code transformations such as transpilation, optimisation, profiling and more, reducing bugs, making your code faster and you as a developer more productive and happy:

<iframe width="100%" height="366" src="//www.youtube.com/embed/OFuDvqZmUrE" frameborder="0" allowfullscreen></iframe>

[Cheng Lou](https://github.com/chenglou) gives a talk on the past, the present and the future of animation, and the place React can potentially take in this:

<iframe width="100%" height="366" src="//www.youtube.com/embed/1tavDv5hXpo" frameborder="0" allowfullscreen></iframe>

And there was a Q&A session with the whole team covering a range of React topics:

<iframe width="100%" height="366" src="//www.youtube.com/embed/CRJZBZ_-6hQ" frameborder="0" allowfullscreen></iframe>

And there were lots of great talks from the React community:

* [Michael Chan](https://www.youtube.com/watch?v=ERB1TJBn32c&list=PLCC436JpVnK0Phxld2dD4tM4xPMxJCiRD&index=2) looks at how to solve problems like CSS theming and media queries with contexts and plain old JavaScript. He also looks at the role of container-components and when it's better to "just use CSS.".
* [Elie Rotenberg](https://www.youtube.com/watch?v=JSjhhUvB9DY&index=3&list=PLCC436JpVnK0Phxld2dD4tM4xPMxJCiRD) talks about Flux over the Wire, building isomorphic, real-time React apps using a novel interpretation of Flux.
* [Ryan Florence](https://www.youtube.com/watch?v=BF58ZJ1ZQxY&list=PLCC436JpVnK0Phxld2dD4tM4xPMxJCiRD&index=6) says “Your front and back ends are already successfully in production but you don't have to miss out on the productivity that React brings. Forget the rewrites, this is brownfield!”.
* [Dan Abramov](https://www.youtube.com/watch?v=xsSnOQynTHs&index=7&list=PLCC436JpVnK0Phxld2dD4tM4xPMxJCiRD) demonstrates how React can be used together with webpack Hot Module Replacement to create a live editing environment with time travel that supercharges your debugging experience and transforms the way you work on real apps every day.
* [Mikhail Davydov](https://www.youtube.com/watch?v=ee_U2t-8L48&index=10&list=PLCC436JpVnK0Phxld2dD4tM4xPMxJCiRD) shows you how to ask the browser layout engine for help, how to avoid slavery of DSL, and build declarative Text UI using only web-technologies like HTML, JS, CSS and React.
* [Kevin Robinson](https://www.youtube.com/watch?v=EOz4D_714R8&list=PLCC436JpVnK3HvUSAHpt-LRJkIK8pQG6R&index=3) shares how user experience choices are a primary influence on how Twitter design the data layer, especially for teams developing new products with full-stack capabilities.
* [Jed Watson](https://www.youtube.com/watch?v=ctwmd5L1U_Q&list=PLCC436JpVnK3HvUSAHpt-LRJkIK8pQG6R&index=4) shares what Thinkmill have learned about React and mobile app development, and how they've approached the unique challenges of mobile web apps - with tools that are useful to all developers building touch interfaces with React, as well as a walkthrough of their development process and framework.
* [Michael Jackson](https://www.youtube.com/watch?v=Q6Kczrgw6ic&list=PLCC436JpVnK3HvUSAHpt-LRJkIK8pQG6R&index=5) discusses how your users can benefit from the many tools that React Router provides including server-side rendering, real URLs on native devices, and much, much more.
* [Michael Ridgway](https://www.youtube.com/watch?v=MrozpFEBEBE&index=7&list=PLCC436JpVnK3HvUSAHpt-LRJkIK8pQG6R) walks you through an isomorphic Flux architecture to give you the holy grail of frontend development.
* [Aria Buckles](https://www.youtube.com/watch?v=2Qu-Ulrsfl8&index=8&list=PLCC436JpVnK3HvUSAHpt-LRJkIK8pQG6R) covers Khan Academy's techniques and patterns to make dealing with large pure components simpler, as well as current open questions.
* [Evan Morikawa and Ben Gotow](https://www.youtube.com/watch?v=Uu4Yz2HmCgE&index=9&list=PLCC436JpVnK3HvUSAHpt-LRJkIK8pQG6R) talk about specific features of React & Flux, React CSS, programming design patterns, and custom libraries, which can turn a static application into a dynamic platform that an ecosystem of developers can build on top of.
* [Zalando](https://www.youtube.com/watch?v=3EQhkquvVmY&list=PLCC436JpVnK0Phxld2dD4tM4xPMxJCiRD&index=9), [Rangle.io](https://www.youtube.com/watch?v=nAWKR1bBDsU&index=12&list=PLCC436JpVnK0Phxld2dD4tM4xPMxJCiRD), [Automattic](https://www.youtube.com/watch?v=hjhyrBbDp6U&index=13&list=PLCC436JpVnK0Phxld2dD4tM4xPMxJCiRD), [Thinkmill](https://www.youtube.com/watch?v=ApoCktYaRxk&list=PLCC436JpVnK0Phxld2dD4tM4xPMxJCiRD&index=14), and [Red Badger](https://www.youtube.com/watch?v=hdKidiwR8DM&list=PLCC436JpVnK0Phxld2dD4tM4xPMxJCiRD&index=15) provided lots of insight into how larger companies are using React.

There was also a [great series of Lightning talks](https://www.youtube.com/playlist?list=PLCC436JpVnK3xnOZ727t0vd3nbb5ZqCyo) from [Joshua Sierles](https://github.com/jsierles), [Ovidiu Cherecheș](https://github.com/skidding), [Mike Grabowski](https://github.com/grabbou), [Dave Brotherstone](https://github.com/bruderstein), [Sunil Pai](https://github.com/threepointone), [Andreas Savvides](https://github.com/AnSavvides), and [Petr Bela](https://github.com/petrbela).

You can view the full list of talks on [the ReactEurope YouTube channel](https://www.youtube.com/channel/UCorlLn2oZfgOJ-FUcF2eZ1A).
