---
id: videos
title: Videos
layout: community
sectionid: community
permalink: community/videos.html
redirect_from: "docs/videos.html"
---

### Introduction to React

[Tom Occhino](http://tomocchino.com/) and [Jordan Walke](https://github.com/jordwalke) introduce React at Facebook Seattle.

<iframe width="100%" height="366" src="https://www.youtube-nocookie.com/embed/XxVg_s8xAms" frameborder="0" allowfullscreen></iframe>

### Introducing React Native

[Tom Occhino](https://twitter.com/tomocchino) reviews the past and present of React in 2015, and teases where it's going next.

<iframe width="100%" height="366" src="https://www.youtube-nocookie.com/embed/KVZ-P-ZI6W4?list=PLb0IAmt7-GS1cbw4qonlQztYV1TAW0sCr" frameborder="0" allowfullscreen></iframe>

### Rethinking Web App Development at Facebook

Delivering reliable, high-performance web experiences at Facebook's scale has required us to challenge some long-held assumptions about software development. Watch this Facebook F8 2014 talk to learn how we abandoned the traditional MVC paradigm in favor of a more functional application architecture.

<iframe width="100%" height="366" src="https://www.youtube-nocookie.com/embed/nYkdrAPrdcw" frameborder="0" allowfullscreen></iframe>

### Secrets of the Virtual DOM

[Pete Hunt](http://www.petehunt.net/) at Mountain West JavaScript 2014 discusses why a virtual DOM was built for React, how it compares to other systems, and its relevance to the future of browser technologies.

<iframe width="100%" height="366" src="https://www.youtube-nocookie.com/embed/h3KksH8gfcQ" frameborder="0" allowfullscreen></iframe>

### Rethinking Best Practices

[Pete Hunt](http://www.petehunt.net/)'s talk at JSConf EU 2013 covers three topics: throwing out the notion of templates and building views with JavaScript, “re-rendering” your entire application when your data changes, and a lightweight implementation of the DOM and events.

<iframe width="100%" height="366" src="https://www.youtube-nocookie.com/embed/x7cQ3mrcKaY" frameborder="0" allowfullscreen></iframe>


### High performance functional DOM programming

Tech Talk by [Pete Hunt](http://www.petehunt.net/) at Meteor DevShop 11.

<iframe width="100%" height="366" src="https://www.youtube-nocookie.com/embed/qqVbr_LaCIo" frameborder="0" allowfullscreen></iframe>


### Developing User Interfaces With React

[Steven Luscher](https://github.com/steveluscher) at Super VanJS 2013.

<iframe width="100%" height="366" src="https://www.youtube-nocookie.com/embed/1OeXsL5mr4g" frameborder="0" allowfullscreen></iframe>


### Introduction to React

[Stoyan Stefanov](http://www.phpied.com/) at LAWebSpeed meetup.

<iframe width="100%" height="366" src="https://www.youtube-nocookie.com/embed/SMMRJif5QW0" frameborder="0" allowfullscreen></iframe>

### Going big with React

Areeb Malik investigates how React performs in a high stress situation, and how it helped his team build safe code on a massive scale.

[![](https://i.vimeocdn.com/video/481670116_650.jpg)](https://skillsmatter.com/skillscasts/5429-going-big-with-react#video)

### Backbone + React + Middleman Screencast

This screencast shows how to integrate Backbone with React using [Backbone-React-Component](https://github.com/magalhas/backbone-react-component).

<iframe width="100%" height="488" src="https://www.youtube-nocookie.com/embed/iul1fWHVU6A" frameborder="0" allowfullscreen></iframe>

### React, or how to make life simpler

Tech talk by [Alexander Solovyov](http://solovyov.net/) at FrontEnd Dev Conf '14 (Russian).

<iframe width="100%" height="366" src="https://www.youtube-nocookie.com/embed/YJNUK0EA_Jo" frameborder="0" allowfullscreen></iframe>


### React and Flux: Building Applications with a Unidirectional Data Flow

Facebook engineers [Bill Fisher](https://twitter.com/fisherwebdev) and [Jing Chen](https://twitter.com/jingc) talk about Flux and React at Forward JS 2014, and how using an application architecture with a unidirectional data flow cleans up a lot of their code.

<iframe width="100%" height="366" src="https://www.youtube-nocookie.com/embed/i__969noyAM" frameborder="0" allowfullscreen></iframe>

> [Slides and sample code](https://github.com/zertosh/ssr-demo-kit)

### CodeWinds Podcast

[Pete Hunt](http://www.petehunt.net/) talked with [Jeff Barczewski](http://jeff.barczewski.com/) about React in [CodeWinds Episode 4](http://codewinds.com/podcast/004.html).
<figure>[![](/react/img/docs/codewinds-004.png)](http://codewinds.com/4)</figure>

<table width="100%">
<tr>
<th>02:08</th><td>What is React and why use it?</td>
<th>27:17</th><td>Rendering HTML on the server with Node.js. Rendering backends</td>
</tr>
<tr>
<th>03:08</th><td>The symbiotic relationship of ClojureScript and React</td>
<th>29:20</th><td>React evolved through survival of the fittest at Facebook</td>
</tr>
<tr>
<th>04:54</th><td>The history of React and why it was created</td>
<th>30:15</th><td>Ideas for having state on server and client, using web sockets.</td>
</tr>
<tr>
<th>09:43</th><td>Updating web page with React without using data binding</td>
<th>32:05</th><td>React-multiuser - distributed shared mutable state using Firebase</td>
</tr>
<tr>
<th>13:11</th><td>Using the virtual DOM to change the browser DOM</td>
<th>33:03</th><td>Better debugging with React using the state transitions, replaying events</td>
</tr>
<tr>
<th>13:57</th><td>Programming with React, render targets HTML, canvas, other</td>
<th>34:08</th><td>Differences from Web Components</td>
</tr>
<tr>
<th>16:45</th><td>Working with designers. Contrasted with Ember and AngularJS</td>
<th>34:25</th><td>Notable companies using React</td>
</tr>
<tr>
<th>21:45</th><td>JSX Compiler bridging HTML and React javascript</td>
<th>35:16</th><td>Could a React backend plugin be created to target PDF?</td>
</tr>
<tr>
<th>23:50</th><td>Autobuilding JSX and in browser tools for React</td>
<th>36:30</th><td>Future of React, what's next?</td>
</tr>
<tr>
<th>24:50</th><td>Tips and tricks to working with React, getting started</td>
<th>39:38</th><td>Contributing and getting help</td>
</tr>
</table>

### JavaScript Jabber Podcast

[Pete Hunt](http://www.petehunt.net/) and [Jordan Walke](https://github.com/jordwalke) talked about React in [JavaScript Jabber 73](https://devchat.tv/js-jabber/073-jsj-react-with-pete-hunt-and-jordan-walke).
<figure>[![](/react/img/docs/javascript-jabber.png)](http://javascriptjabber.com/073-jsj-react-with-pete-hunt-and-jordan-walke/#content)</figure>

<table width="100%">
  <tr>
    <th>01:34</th><td>Pete Hunt Introduction</td>
    <th>23:06</th><td>Supporting Node.js</td>
  </tr>
  <tr>
    <th>02:45</th><td>Jordan Walke Introduction</td>
    <th>24:03</th><td>rendr</td>
  </tr>
  <tr>
    <th>04:15</th><td>React</td>
    <th>26:02</th><td>JSX</td>
  </tr>
  <tr>
    <th>06:38</th><td>60 Frames Per Second</td>
    <th>30:31</th><td>requestAnimationFrame</td>
  </tr>
  <tr>
    <th>09:34</th><td>Data Binding</td>
    <th>34:15</th><td>React and Applications</td>
  </tr>
  <tr>
    <th>12:31</th><td>Performance</td>
    <th>38:12</th><td>React Users Khan Academy</td>
  </tr>
  <tr>
    <th>17:39</th><td>Diffing Algorithm</td>
    <th>39:53</th><td>Making it work</td>
  </tr>
  <tr>
    <th>19:36</th><td>DOM Manipulation</td>
    <th></th><td></td>
  </tr>
</table>
