The error code system substitutes React's invariant error messages with error IDs to provide a better debugging support in production. Check out the blog post [here](https://facebook.github.io/react/blog/2016/07/11/introducing-reacts-error-code-system.html).

## Note for cutting a new React release
1. For each release, we run `gulp react:extract-errors` to update the error codes before calling `npm run build`. The build process uses `codes.json` for a production (minified) build; there should be no warning like `Error message "foo" cannot be found` for a successful release.
2. The updated `codes.json` file should be synced back to the master branch. The error decoder page in our documentation site uses `codes.json` from master; if the json file has been updated, the docs site should also be rebuilt (`rake copy_error_codes` is included in the default `rake release` task).
3. It's not recommended to run `gulp react:extract-errors` directly in master since it may contain commits that are not cherry-picked to a release branch. These error messages might be changed/removed before cutting a new release, and we don't want to add intermediate/temporary error messages to `codes.json`. However, if a PR changes an existing error message and there's a specific production test (which is rare), it's ok to update `codes.json` for that. Please use `gulp react:extract-errors` and don't edit the file manually.

## Structure
The error code system consists of 5 parts:
- [`codes.json`](https://github.com/facebook/react/blob/master/scripts/error-codes/codes.json) contains the mapping from IDs to error messages. This file is generated by the Gulp plugin and is used by both the Babel plugin and the error decoder page in our documentation. This file is append-only, which means an existing code in the file will never be changed/removed.
- [`gulp-extract-errors.js`](https://github.com/facebook/react/blob/master/scripts/error-codes/gulp-extract-errors.js) is a gulp plugin that traverses our codebase and updates `codes.json`. Use it by calling `gulp react:extract-errors`.
- [`dev-expression-with-codes.js`](https://github.com/facebook/react/blob/master/scripts/error-codes/dev-expression-with-codes.js) is a Babel pass that rewrites error messages to IDs for a production (minified) build. Notice that this plugin is not in `.babelrc`; it's being used in the [`gulpfile.js`](https://github.com/facebook/react/blob/master/gulpfile.js#L21) and it has to be run before [`rewrite-modules`](https://github.com/facebook/fbjs/blob/master/packages/babel-preset-fbjs/plugins/rewrite-modules.js) since we search for `require('invariant')` but not `require('./invariant')`.
- [`reactProdInvariant.js`](https://github.com/facebook/react/blob/master/src/shared/utils/reactProdInvariant.js) is the replacement for `invariant` in production. This file gets imported by the Babel plugin and should _not_ be used manually.
- [`ErrorDecoderComponent`](https://github.com/facebook/react/blob/master/docs/_js/ErrorDecoderComponent.js) is a React component that lives at https://facebook.github.io/react/docs/error-decoder.html. This page takes parameters like `?invariant=109&args[]=Foo` and displays a corresponding error message. Our documentation site's [`Rakefile`](https://github.com/facebook/react/blob/master/docs/Rakefile#L64-L69) has a task (`bundle exec rake copy_error_codes`) for adding the latest `codes.json` to the error decoder page. This task is included in the default `bundle exec rake release` task.
