/**
 * Copyright 2014-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule ReactTypes
 * @flow
 */

'use strict';

import type {ReactCoroutine, ReactYield} from 'ReactCoroutine';

export type ReactNode =
  | ReactElement<any>
  | ReactCoroutine
  | ReactYield
  | ReactText
  | ReactFragment;

export type ReactFragment = ReactEmpty | Iterable<ReactNode>;

export type ReactNodeList = ReactEmpty | ReactNode;

export type ReactText = string | number;

export type ReactEmpty = null | void | boolean;
