---
layout: page
title: Contributing to Alpaca
description: Get involved, write some code, build something awesome!
keywords: alpaca,forms,jquery,bootstrap
sitemap:
  priority: 1.5
---
{% include JB/setup %}

Alpaca is truly a community project; we welcome your involvement!

When contributing, please attempt to match the code style already in the codebase.
Note that we use four spaces per indentation stop.

For more thoughts on code style, see https://github.com/rwldrn/idiomatic.js/.


# Best Practices

As a best practice, leave space in your code so as to make things more human-readable.  The goal with any code
contributions is to have them be useful and consumable by others.  A good strategy therefore is to make things as
easy to understand as possible.  We don't like concise code simply for the sake of being concise.  Keep it nice
and readable.

When fixing bugs and adding features, when appropriate please also:

- Provide inline comments so that others can understand what your code is doing
- Updated related doc comments (we use JSDoc 3)
- Add/update any related unit tests (if applicable)
- Add/update any documentation pages


# Getting Started

If you're new to the project, check out our
<a href="https://github.com/gitana/alpaca/labels/good%20first%20contribution" target="_blank">good first contribution</a>
issues for some places to dip your toe in the water.

If you're new to open source in general, check out
<a href="https://guides.github.com/activities/contributing-to-open-source/index.html" target="_blank">GitHub's open source intro guide</a>.

Once you're ready, submit a pull request!  The core team will work with you to review your request and merge your feature in.

