/**
 * A dictionary of symbols for each key, when pressed with the alt and shift key also
 * held. Used for combinations that involve the shift and alt key and one or more
 * others (e.g. shift+alt+a)
 */
const AltShiftedKeysDictionary = {
  '`': ['`'],
  '1': ['⁄'],
  '2': ['€'],
  '3': ['‹'],
  '4': ['›'],
  '5': ['ﬁ'],
  '6': ['ﬂ'],
  '7': ['‡'],
  '8': ['°'],
  '9': ['·'],
  '0': ['‚'],
  '-': ['—'],
  '=': ['±'],
  'a': ['Å'],
  'b': ['ı'],
  'c': ['Ç'],
  'd': ['Î'],
  'e': ['´'],
  'f': ['Ï'],
  'g': ['˝'],
  'h': ['Ó'],
  'i': ['ˆ'],
  'j': ['Ô'],
  'k': [''],
  'l': ['Ò'],
  'm': ['Â'],
  'n': ['˜'],
  'o': ['Ø'],
  'p': ['π'],
  'q': ['Œ'],
  'r': ['‰'],
  's': ['Í'],
  't': ['Î'],
  'u': ['¨'],
  'v': ['◊'],
  'w': ['„'],
  'x': ['˛'],
  'y': ['Á'],
  'z': ['¸'],
  '[': ['”'],
  ']': ['’'],
  "\\": ['»'],
  "'": ['Æ'],
  ';': ['Ú'],
  ',': ['¯'],
  '.': ['˘'],
};

export default AltShiftedKeysDictionary;
