---
sidebar: auto
---

# Справочник API

## Расширение прототипа Vue

### Опции конструктора Vue

#### i18n

* **Тип:** `I18nOptions`

Опция локализации на основе компонентов.

* **См. также:** Опции конструктора класса `VueI18n`

### Внедряемые методы

#### $t

* **Аргументы:**

  * `{Path} key`: обязательный
  * `{Locale} locale`: опционально
  * `{Array | Object} values`: опционально

* **Возвращает:** `TranslateResult`

Получение переведённого сообщения по ключу `key`. Сообщения локализации в компоненте имеют приоритет над глобальными сообщениями. Если сообщений локализации в компоненте нет, то локализация осуществляется с помощью глобальных сообщений локализации. Если указана `locale`, то используются сообщения локализации из `locale`. Если был указан `key` именованного формата / формата списков сообщений локализации, то необходимо указывать также `values`. Подробнее про значения `values` можно изучить в разделе [Формат сообщений локализации](../guide/formatting.md).

:::danger Совет
Обратите внимание, что в хуках жизненного цикла контекст должен быть экземпляром компонента (например в опции `data`, `const $t = this.$t.bind(this)`).
:::

#### $tc

* **Аргументы:**

  * `{Path} key`: обязательный
  * `{number} choice`: опционально, по умолчанию `1`
  * `{Locale} locale`: опционально
  * `{string | Array | Object} values`: опционально

* **Возвращает:** `TranslateResult`

Получение переведённого сообщения по ключу `key` с использованием плюрализации. Сообщения локализации компонента имеют приоритет над глобальными сообщениями. Если сообщений локализации в компоненте нет, то локализация осуществляется с помощью глобальных сообщений локализации. Если указана `locale`, то используются сообщения локализации из `locale`. Если указано строковое значение для `values`, то локализация выполняется для этого значения. Если указано значение Array или Object в `values`, то необходимо указывать с `values` из $t.

Если вам не подходит реализация плюрализации по умолчанию, смотрите [pluralization rules в опциях конструктора](#pluralizationrules) и [пользовательскую плюрализацию](../guide/pluralization.md).

:::danger Совет
Обратите внимание, что в хуках жизненного цикла контекст должен быть экземпляром компонента (например в опции `data`, `const $tc = this.$tc.bind(this)`).
:::

#### $te

* **Аргументы:**

  * `{Path} key`: обязательный
  * `{Locale} locale`: опционально

* **Возвращает:** `boolean`

Проверяет существует ли перевод для ключа в сообщениях локализации. Если нет сообщений локализации в компоненте, то проверяет в глобальных сообщениях локализации. Если указана `locale`, то проверяется наличие в сообщениях локализации `locale`.

:::danger Совет
Обратите внимание, что в хуках жизненного цикла контекст должен быть экземпляром компонента (например в опции `data`, `const $te = this.$te.bind(this)`).
:::

#### $d

> :new: Добавлено в версии 7.0+

* **Аргументы:**

  * `{number | Date} value`: обязательный
  * `{Path | Object} key`: опционально
  * `{Locale | Object} locale`: опционально

* **Возвращает:** `DateTimeFormatResult`

Локализация даты из `value` по указанному формату даты из `key`. Формат указанный в `key` должен быть зарегистрирован в опции `dateTimeFormats` класса `VueI18n`, и зависит от опции `locale` конструктора `VueI18n`. Если указать аргумент `locale`, то он будет иметь приоритет над опцией `locale` конструктора `VueI18n`.

Если формата даты для `key` нет в опции `dateTimeFormats`, то будет использован запасной формат, основываясь на опции `fallbackLocale` конструктора `VueI18n`.

:::danger Совет
Обратите внимание, что в хуках жизненного цикла контекст должен быть экземпляром компонента (например в опции `data`, `const $d = this.$d.bind(this)`).
:::

#### $n

> :new: Добавлено в версии 7.0+

* **Аргументы:**

  * `{number} value`: обязательный
  * `{Path | Object} format`: опционально
  * `{Locale} locale`: опционально

* **Возвращает:** `NumberFormatResult`

Локализация числа `value` с помощью формата чисел `format`. Числовой формат из `format` должен быть зарегистрирован в опции `numberFormats` класса `VueI18n`, и зависит от опции `locale` конструктора `VueI18n`. Если указать аргумент `locale`, то он будет иметь приоритет над опцией `locale` конструктора `VueI18n`.

Если формат чисел для `format` не указан в опции `numberFormats`, будет использован запасной формат, основываясь на опции `fallbackLocale` конструктора `VueI18n`.

Если второй аргумент `format` указан объектом, то в нём должны быть следующие свойства:

* `key {Path}`: опционально, форматируемое число
* `locale {Locale}`: опционально, локализация
* `compactDisplay {string}`: опционально, опция форматирования чисел
* `currency {string}`: опционально, опция форматирования чисел
* `currencyDisplay {string}`: опционально, опция форматирования чисел
* `currencySign {string}`: опционально, опция форматирования чисел
* `localeMatcher {string}`: опционально, опция форматирования чисел
* `notation {string}`: опционально, опция форматирования чисел
* `numberingSystem {string}`: опционально, опция форматирования чисел
* `signDisplay {string}`: опционально, опция форматирования чисел
* `style {string}`: опционально, опция форматирования чисел
* `unit {string}`: опционально, опция форматирования чисел
* `unitDisplay {string}`: опционально, опция форматирования чисел
* `useGrouping {string}`: опционально, опция форматирования чисел
* `minimumIntegerDigits {string}`: опционально, опция форматирования чисел
* `minimumFractionDigits {string}`: опционально, опция форматирования чисел
* `maximumFractionDigits {string}`: опционально, опция форматирования чисел
* `minimumSignificantDigits {string}`: опционально, опция форматирования чисел
* `maximumSignificantDigits {string}`: опционально, опция форматирования чисел

Любые указанные опции форматирования числа будут иметь приоритет над значениями `numberFormats` из конструктора `VueI18n`.

:::danger Совет
Обратите внимание, что в хуках жизненного цикла контекст должен быть экземпляром компонента (например в опции `data`, `const $n = this.$n.bind(this)`).
:::

### Внедряемые свойства

#### $i18n

* **Тип:** `I18n`

* **Только для чтения**

Получение экземпляра `VueI18n`, если был определён.

Если в компоненте указана опция `i18n`, то получение экземпляра `VueI18n` компонента. В противном случае, получение корневого экземпляра `VueI18n`.

## Класс `VueI18n`

Класс `VueI18n` реализует интерфейс `I18n` из [определений flowtype](https://github.com/kazupon/vue-i18n/blob/dev/decls/i18n.js)

### Статические свойства

#### version

* **Тип:** `string`

Версия `vue-i18n`.

#### availabilities

> :new: Добавлено в версии 7.0+

* **Тип:** `IntlAvailability`

Проверка доступности следующих возможностей интернационализации:

* `{boolean} dateTimeFormat`: форматирование дат для локалей

* `{boolean} numberFormat`: форматирование чисел для локалей

Указанные выше возможности интернационализации зависят от [окружения браузера](http://kangax.github.io/compat-table/esintl/), в котором реализован ECMAScript Internationalization API (ECMA-402).

### Опции конструктора

Можно указывать некоторые опции конструктора `I18nOptions`, основываясь на [определениях flowtype](https://github.com/kazupon/vue-i18n/blob/dev/decls/i18n.js)

#### locale

* **Тип:** `Locale`

* **По умолчанию:** `'en-US'`

Локаль используемая для локализации. Если локаль содержит территорию и диалект, то эта локаль явно определяет запасную локализацию.

#### fallbackLocale

* **Тип:** `FallbackLocale`

* **По умолчанию:** `false`

Запасная локаль для локализации. Подробнее в разделе [Запасная локализация](../guide/fallback.md).

#### messages

* **Тип:** `LocaleMessages`

* **По умолчанию:** `{}`

Сообщения локализации для локали.

#### dateTimeFormats

> :new: Добавлено в версии 7.0+

* **Тип:** `DateTimeFormats`

* **По умолчанию:** `{}`

Форматы дат для локализации.

* **См. также:** тип `DateTimeFormats` в [определениях flowtype](https://github.com/kazupon/vue-i18n/blob/dev/decls/i18n.js)

#### numberFormats

> :new: Добавлено в версии 7.0+

* **Тип:** `NumberFormats`

* **По умолчанию:** `{}`

Форматы чисел для локализации.

* **См. также:** тип `NumberFormats` в [определениях flowtype](https://github.com/kazupon/vue-i18n/blob/dev/decls/i18n.js)

#### availableLocales

> :new: Добавлено в версии 8.9.0+

* **Тип:** `Locale[]`

* **По умолчанию:** `[]`

* **Примеры:** `["en", "ru"]`

Список доступных локалей в `messages` в лексическом порядке.

#### formatter

* **Тип:** `Formatter`

* **По умолчанию:** Встроенный formatter

Метод форматирования, реализующий интерфейс `Formatter`.

#### modifiers

> :new: Добавлено в версии 8.15.0+

* **Тип:** `Modifiers`

* **По умолчанию:** модификаторы `lower` и `upper`

Функции модификаторов для связанных сообщений

#### missing

* **Тип:** `MissingHandler`

* **По умолчанию:** `null`

Обработчик для отсутствующих сообщений локализации. Обработчик будет вызван с локалью, ключом сообщения локализации и значениями values.

Если указан этот обработчик и произойдёт попытка доступа к отсутствующему сообщению локализации, то предупреждения в консоли не будет.

#### fallbackRoot

* **Тип:** `Boolean`

* **По умолчанию:** `true`

При использовании локализации в компонентах определяет обращаться ли к локализации корневого уровня (глобальной) при неудаче.

При значении `false` будет выбрасываться предупреждение и возвращаться ключ.

#### sync

* **Тип:** `Boolean`

* **По умолчанию:** `true`

Синхронизировать ли локализацию корневого уровня с локализацией компонента.

При значении `false`, независимо от локали определённой на корневом уровне, будет использоваться локаль установленная в компоненте.

#### silentTranslationWarn

> 6.1+, :up: 8.13

* **Тип:** `Boolean | RegExp`

* **По умолчанию:** `false`

Отключение предупреждений, отображаемых при неудаче локализации.

При значении `true`, отключаются предупреждения об ошибках локализации. Если использовать регулярное выражение, то можно отключать предупреждения об ошибках, которые будут соответствовать `key` (например, `$t`).

#### silentFallbackWarn

> :new: Добавлено в версии 8.8+, :up: 8.13

* **Тип:** `Boolean | RegExp`

* **По умолчанию:** `false`

Отключение предупреждений при использовании запасной локали из `fallbackLocale` или `root`.

При значении `true` предупреждения будут генерироваться только если недоступна локализация вообще, а не для случаев использования запасной локали. При использовании регулярного выражения можно отключать предупреждения которые будут соответствовать `key` (например, `$t`).

#### pluralizationRules

> 8.5+

  * **Тип:** `PluralizationRules`

  * **По умолчанию:** `{}`

  Набор правил для плюрализации в следующем формате:
  ```js
    {
      // Ключ - локаль для которой будет применяться правило.
      // Value - функция для получения индекса варианта плюрализации от текущего числа и заданного количества вариантов. (См. функцию getChoiceIndex)
      'pt': function(choice, choiceIndex) => Number/* index of the plural word */;
      'ru': function(choice, choiceIndex) => Number/* index of the plural word */;
      'en': function(choice, choiceIndex) => Number/* index of the plural word */;
      'jp': function(choice, choiceIndex) => Number/* index of the plural word */;
    }
  ```

#### preserveDirectiveContent

> Добавлено в версии 8.7+

* **Тип:** `Boolean`

* **По умолчанию:** `false`

Определяет должен ли элемент директивы `v-t` сохранять `textContent` после того как директива будет снята с элемента.

#### warnHtmlInMessage

> Добавлено в версии 8.11+

* **Тип:** `WarnHtmlInMessageLevel`

* **По умолчанию:** `off`

Разрешить ли использование HTML-форматирования в сообщениях локализации. См. также свойство `warnHtmlInMessage`.

:::danger Внимание!
Со следующей мажорной версии значение по умолчанию `warnHtmlInMessage` будет `warn`.
:::

#### sharedMessages

> Добавлено в версии 8.12+

* **Тип:** `LocaleMessages`

* **По умолчанию:** `undefined`

Общие сообщения локализации при локализации в компонентах. Подробнее в разделе [Локализация на основе компонентов](../guide/component.md#локаnизация-на-основе-компонентов).

#### postTranslation

> Добавлено в версии 8.16+

* **Тип:** `PostTranslationHandler`

* **По умолчанию:** `null`

Пост-обработчик локализации. Выполняется после вызова `$t`, `t`, `$tc` и `tc`.

Может пригодиться при необходимости дополнительно обработать итоговый текст перевода, например избавиться от висящих пробелов.

#### componentInstanceCreatedListener

> Добавлено в версии 8.18+

* **Тип:** `ComponentInstanceCreatedListener`

* **По умолчанию:** `null`

Обработчик получения уведомления о создании локального экземпляра компонента. Вызывается с новым и старым (корневыми) экземплярами VueI18n.

Обработчик может потребоваться при расширении корневого экземпляра VueI18n и необходимости ожидания для применения этих расширений к локальному экземпляру компонента.

#### escapeParameterHtml

> Добавлено в версии 8.22+

  * **Тип:** `Boolean`

  * **По умолчанию:** `false`

Если `escapeParameterHtml` установлен в значение `true`, то параметры интерполяции будут экранированы перед переводом сообщения. Это полезно, когда результат перевода используется в `v-html` и текст для перевода содержит HTML-разметку (например, `<b>` вокруг предоставленного пользователем значения). Этот шаблон в основном предназначен для случаев, когда передаются предварительно скомпилированные текстовые строки в компоненты UI.

Процесс экранирования включает в себя замену следующих символов на соответствующие HTML-сущности: `<`, `>`, `"`, `'`.

Установка `escapeParameterHtml` в значение `true` не должна нарушать существующую функциональность, а предоставит защиту от векторов атаки типа XSS.

### Свойства

#### locale

* **Тип:** `Locale`

* **Чтение/Запись**

Локаль используемая для локализации. Если локаль содержит территорию и диалект, то эта локаль неявно указывает на запасные варианты.

#### fallbackLocale

* **Тип:** `FallbackLocale`

* **Чтение/Запись**

Локаль используемая для запасной локализации. Способы определения и переключения на запасную локализацию можно изучить в разделе [Запасная локализация](../guide/fallback.md).

#### messages

* **Тип:** `LocaleMessages`

* **Только для чтения**

Переведённые сообщения используемые для локализации.

#### dateTimeFormats

> :new: Добавлено в версии 7.0+

* **Тип:** `DateTimeFormats`

* **Только для чтения**

Форматы форматирования дат для локализации.

#### numberFormats

> :new: Добавлено в версии 7.0+

* **Тип:** `NumberFormats`

* **Только для чтения**

Форматы форматирования чисел для локализации.

#### missing

* **Тип:** `MissingHandler`

* **Чтение/Запись**

Обработчик для отсутствующих ключей локализаций.

#### formatter

* **Тип:** `Formatter`

* **Чтение/Запись**

Метод форматирования, который реализует интерфейс `Formatter`.

#### silentTranslationWarn

> 6.1+, :up: 8.13

* **Тип:** `Boolean | RegExp`

* **Чтение/Запись**

Отключение предупреждений выводимых при ошибке локализации.

#### silentFallbackWarn

> :new: Добавлено в версии 8.8+, :up: 8.13

* **Тип:** `Boolean | RegExp`

* **Чтение/Запись**

Отключение предупреждений выводимых при ошибке использования запасной локализации.

#### pluralizationRules

> 8.5+

* **Тип:** `PluralizationRules`

* **Чтение/Запись**

Набор зависимых от локали правил плюрализации.

#### preserveDirectiveContent

> Добавлено в версии 8.7+

* **Тип:** `Boolean`

* **Чтение/Запись**

Должен ли элемент директивы `v-t` сохранять `textContent` после того как директива снята с элемента.

#### warnHtmlInMessage

> Добавлено в версии 8.11+

* **Тип:** `WarnHtmlInMessageLevel`

* **Чтение/Запись**

Разрешить ли использование HTML-форматирования в сообщениях локализации.


При установке `warn` или `error` проверяются сообщения локализации экземпляра VueI18n.

При установке `warn` выводятся предупреждения в консоль.

При установке `error` генерируется Error.

В качестве значения по умолчанию в экземпляре VueI18n установлено `off`.

#### postTranslation

> Добавлено в версии 8.16+

* **Тип:** `PostTranslationHandler`

* **Чтение/Запись**

Обработчик для пост-обработки перевода.

### Методы

#### getChoiceIndex

* **Аргументы:**

  * `{number} choice`
  * `{number} choicesLength`

* **Возвращает:** `finalChoice {number}`

Получение индекса для плюрализации текущего числа и заданного количества вариантов. Реализация может быть переопределена через изменение прототипа:

```js
VueI18n.prototype.getChoiceIndex = /* пользовательская реализация */
```

Однако в большинстве случаев достаточно передать нужную функцию в [pluralizationRules опцию конструктора](#pluralizationrules).

#### getLocaleMessage( locale )

* **Аргументы:**

  * `{Locale} locale`

* **Возвращает:** `LocaleMessageObject`

Получение сообщений локализации для локали.

#### setLocaleMessage( locale, message )

* **Аргументы:**

  * `{Locale} locale`
  * `{LocaleMessageObject} message`

Установка сообщений локализации для локали.

:::tip ПРИМЕЧАНИЕ

> Добавлено в версии 8.11+

При использовании `warn` или `error` в свойстве `warnHtmlInMessage`, при выполнении этого метода будет проверено используется ли HTML-форматирование для сообщения локализации.
:::

#### mergeLocaleMessage( locale, message )

> 6.1+

* **Аргументы:**

  * `{Locale} locale`
  * `{LocaleMessageObject} message`

Объединение указанных сообщений локализации с сообщениями локализации локали.

:::tip ПРИМЕЧАНИЕ

> Добавлено в версии 8.11+

При использовании `warn` или `error` в свойстве `warnHtmlInMessage`, при выполнении этого метода будет проверено используется ли HTML-форматирование для сообщения локализации.
:::

#### t( key, [locale], [values] )

* **Аргументы:**

  * `{Path} key`: обязательный
  * `{Locale} locale`: опционально
  * `{Array | Object} values`: опционально

* **Возвращает:** : `TranslateResult`

Аналогично функции возвращаемой методом `$t`. Подробнее см. [$t](#t).

#### tc( key, [choice], [values] )

* **Аргументы:**

  * `{Path} key`: обязательный
  * `{number} choice`: опционально, по умолчанию `1`
  * `{string | Array | Object} values`: опционально

* **Возвращает:** `TranslateResult`

Аналогично функции возвращаемой методом `$tc`. Подробнее см. [$tc](#tc).

#### te( key, [locale] )

* **Аргументы:**

  * `{string} key`: обязательный
  * `{Locale} locale`: опционально

* **Возвращает:** `boolean`

Проверяет существует ли указанный ключ в глобальных сообщениях локализации. Если указать `locale`, проверка будет осуществляться в сообщениях локализации `locale`.

#### getDateTimeFormat ( locale )

> :new: Добавлено в версии 7.0+

* **Аргументы:**

  * `{Locale} locale`

* **Возвращает:** `DateTimeFormat`

Получение форматов форматирования дат локализации.

#### setDateTimeFormat ( locale, format )

> :new: Добавлено в версии 7.0+

* **Аргументы:**

  * `{Locale} locale`
  * `{DateTimeFormat} format`

Установка форматов форматирования дат для локализации.

#### mergeDateTimeFormat ( locale, format )

> :new: Добавлено в версии 7.0+

* **Аргументы:**

  * `{Locale} locale`
  * `{DateTimeFormat} format`

Объединение указанных форматов форматирования дат с форматами локализации.

#### d( value, [key], [locale] )

> :new: Добавлено в версии 7.0+

* **Аргументы:**

  * `{number | Date} value`: обязательный
  * `{Path | Object} key`: опционально
  * `{Locale | Object} locale`: опционально

* **Возвращает:** `DateTimeFormatResult`

Аналогично функции возвращаемой методом `$d`. Подробнее см. [$d](#d).

#### getNumberFormat ( locale )

> :new: Добавлено в версии 7.0+

* **Аргументы:**

  * `{Locale} locale`

* **Возвращает:** `NumberFormat`

Получение форматов форматирования чисел для локализации.

#### setNumberFormat ( locale, format )

> :new: Добавлено в версии 7.0+

* **Аргументы:**

  * `{Locale} locale`
  * `{NumberFormat} format`

Установка форматов форматирования чисел для локализации.

#### mergeNumberFormat ( locale, format )

> :new: Добавлено в версии 7.0+

* **Аргументы:**

  * `{Locale} locale`
  * `{NumberFormat} format`

Объединение указанных форматов форматирования чисел с форматами локализации.

#### n( value, [format], [locale] )

> :new: Добавлено в версии 7.0+

* **Аргументы:**

  * `{number} value`: обязательный
  * `{Path | Object} format`: опционально
  * `{Locale} locale`: опционально

* **Возвращает:** `NumberFormatResult`

Аналогично функции возвращаемой методом `$n`. Подробнее см. [$n](#n).

## Директивы

> :new: Добавлено в версии 7.3+

### v-t

* **Ожидает:** `string | Object`

* **Модификаторы:**

  * `.preserve`: (8.7.0+) сохраняет `textContent` элемента при снятии директивы с элемента.

* **Подробности:**

Обновление `textContent` элемента, который был переведён с помощью сообщений локализации. Можно использовать строковый или объектный синтаксис. Строковый синтаксис может быть задан в качестве пути к сообщению локализации. При использовании объектного синтаксиса необходимо указать следующие свойства:

  * `path`: обязательный, ключ сообщения локализации
  * `locale`: опционально, локализация
  * `args`: опционально, для списка или именованного форматирования

:::tip ПРИМЕЧАНИЕ
По умолчанию значение `textContent` элемента удаляется при снятии директивы `v-t`. Это может быть нежелательной ситуацией например при [анимировании списков](https://ru.vuejs.org/v2/guide/transitions.html). Для сохранения данных `textContent` после снятия директивы следует использовать модификатор `.preserve` или глобальную опцию [`preserveDirectiveContent`](#preservedirectivecontent).
:::

* **Примеры:**

```html
<!-- строковый синтаксис: литерал -->
<p v-t="'foo.bar'"></p>

<!-- строковый синтаксис: привязка к данным -->
<p v-t="msg"></p>

<!-- объектный синтаксис: литерал -->
<p v-t="{ path: 'hi', локализация: 'ru', args: { name: 'kazupon' } }"></p>

<!-- объектный синтаксис: привязка к данным -->
<p v-t="{ path: greeting, args: { name: fullName } }"></p>

<!-- с модификатором preserve -->
<p v-t.preserve="'foo.bar'"></p>
```

* **См. также:** [Пользовательская директива для локализации](../guide/directive.md)

## Компоненты

### Функциональный компонент i18n

> :new: Добавлено в версии 7.0+

#### Входные параметры:

* `path {Path}`: обязательный, путь к сообщению локализации
* `locale {Locale}`: опционально, локализация
* `tag {string | boolean | Object}`: опционально, по умолчанию `'span'`
* `places {Array | Object}`: опционально (7.2+)

:::danger Внимание!
Со следующей мажорной версии опция `places` будет удалена. Используйте синтаксис слотов.
:::

#### Использование:

```html
<div id="app">
  <!-- ... -->
  <i18n path="term" tag="label" for="tos">
    <a :href="url" target="_blank">{{ $t('tos') }}</a>
  </i18n>
  <!-- ... -->
</div>
```

```js
const messages = {
  en: {
    tos: 'Term of Service',
    term: 'I accept xxx {0}.'
  },
  ru: {
    tos: 'Условия обслуживания',
    term: 'Я соглашаюсь с xxx {0}.'
  }
}

const i18n = new VueI18n({
  locale: 'en',
  messages
})
new Vue({
  i18n,
  data: {
    url: '/term'
  }
}).$mount('#app')
```

#### См. также:

[Интерполяция компонента](../guide/interpolation.md)

### Функциональный компонент i18n-n

> :new: Добавлено в версии 8.10+

#### Входные параметры:

* `value {number}`: обязательный, число для форматирования
* `format {string | NumberFormatOptions}`: опционально, форматируемое число или объект с указанными опциями форматирования
* `locale {Locale}`: опционально, локализация
* `tag {string | boolean | Object}`: опционально, по умолчанию `'span'`

#### Использование:

```html
<div id="app">
  <!-- ... -->
  <i18n-n :value="money" format="currency" tag="label">
    <span v-slot:currency="slotProps" class="font-weight: bold">
      {{ slotProps.currency }}
    <span>
  </i18n-n>
  <!-- ... -->
</div>
```

```js
var numberFormats = {
  'en-US': {
    currency: {
      style: 'currency',
      currency: 'USD'
    }
  },
  'ru-RU': {
    currency: {
      style: 'currency',
      currency: 'RUB'
    }
  }
}

const i18n = new VueI18n({
  locale: 'en-US',
  numberFormats
})

new Vue({
  i18n,
  data: {
    money: 10234
  }
}).$mount('#app')
```

#### Слоты с ограниченной областью видимости

Функциональный компонент `<i18n-n>` может принимать различные слоты с ограниченной областью видимости. Список поддерживаемых имён слотов основан на [выходных типах `Intl.NumberFormat.formatToParts()`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/NumberFormat/formatToParts):

* `currency`
* `decimal`
* `fraction`
* `group`
* `infinity`
* `integer`
* `literal`
* `minusSign`
* `nan`
* `plusSign`
* `percentSign`

Каждый из слотов предоставляет доступ к значениям трёх параметров:

* `[slotName] {FormattedNumberPartType}`: параметр с тем же именем, что и имя слота (например, `integer`)
* `index {Number}`: индекс конкретной части в массиве частей числа
* `parts {Array}`: массив со всеми отформатированными частями числа

#### См. также:

[Локализация чисел](../guide/number.md#custom-formatting)

## Специальные атрибуты

### place

> :new: Добавлено в версии 7.2+

#### Ожидает: `{number | string}`

Используется при интерполяции компонента для указания индекса при форматировании списком или ключа при именованном форматировании.

Подробнее об использовании в разделе по ссылке ниже.

#### См. также:

[Интерполяция компонента](../guide/interpolation.md)
