# Запасная локализация

*Вкратце: указывайте `fallbackLocale: '<lang>'` для определения языка, который будет использоваться, если нет перевода в выбранной локализации.*

## Неявное определение запасных локализаций при использовании локалей

Если `locale` содержит территорию и опционально диалект, то неявно будут определены автоматически запасные локали.

Например для `de-DE-bavarian` в качестве запасных будут считаться следующие:
1. `de-DE-bavarian`
2. `de-DE`
3. `de`

Для отключения автоматического определения запасных локалей укажите символ `!`, например `de-DE!`

## Явное определение одной локали запасной локализации

Иногда не все ключи сообщений переведены на другие языки. В примере ниже, сообщение для ключа `hello` доступно в английской локали, но отсутствует в русской:

```js
const messages = {
  en: {
    hello: 'Hello, world!'
  },
  ru: {
    // упс, не все переведено
  }
}
```

Если хочется использовать сообщения локализации из `en`, когда перевод отсутствует в нужной локализации, то следует указать опцию `fallbackLocale` в конструкторе VueI18n:

```js
const i18n = new VueI18n({
  locale: 'ru',
  fallbackLocale: 'en',
  messages
})
```

Шаблон:

```html
<p>{{ $t('hello') }}</p>
```

Результат:

```html
<p>Hello, world!</p>
```

По умолчанию, если использовались сообщения запасной локализации из `fallbackLocale`, то в консоли будут выведены соответствующие предупреждения:

```
[vue-i18n] Value of key 'hello' is not a string!
[vue-i18n] Fall back to translate the keypath 'hello' with 'en' locale.
```

Чтобы скрыть такие предупреждения (оставив при этом те, в случаях полного отсутствия переводов для данного ключа) установите `silentFallbackWarn: true` при инициализации экземпляра `VueI18n`.

## Явное определение запасной локали с помощью массива

Можно указать более одной запасной локализации с помощью массива. Например:

```js
fallbackLocale: ['ru', 'en'],
```

## Явное определение запасной локали с помощью объекта

Более сложный алгоритм принятия решений для определения запасной локали можно реализовать с помощью карты принятия решений в виде объекта.

Например для подобного объекта:

```js
fallbackLocale: {
  /* 1 */ 'de-CH':   ['fr', 'it'],
  /* 2 */ 'zh-Hant': ['zh-Hans'],
  /* 3 */ 'es-CL':   ['es-AR'],
  /* 4 */ 'es':      ['en-GB'],
  /* 5 */ 'pt':      ['es-AR'],
  /* 6 */ 'default': ['en', 'ru']
},
```

Будут следующие цепочки выбора запасной локали:

| Локаль      | Цепочка выбора                            |
| ----------- | ----------------------------------------- |
| `'de-CH'`   | de-CH > fr > it > en > ru                 |
| `'de'`      | de > en > ru                              |
| `'zh-Hant'` | zh-Hant > zh-Hans > zh > en > ru          |
| `'es-SP'`   | es-SP > es > en-GB > en > ru              |
| `'es-SP!'`  | es-SP > en > ru                           |
| `'fr'`      | fr > en > ru                              |
| `'pt-BR'`   | pt-BR > pt > es-AR > es > en-GB > en > ru |
| `'es-CL'`   | es-CL > es-AR > es > en-GB > en > ru      |

## Резервная интерполяция

_Вкратце: установите `formatFallbackMessages: true` чтобы выполнять интерполяции шаблона по ключам перевода, когда в выбранном языке отсутствует данный ключ для перевода._

Так как ключи переводов являются строками, то можно использовать само сообщение в качестве ключа (для определённого языка). Например:

```js
const messages = {
  ru: {
    'Hello, world!': 'Привет мир!'
  }
}
```

Это может быть полезным, потому что не нужно будет указывать перевод для строки "Hello, world!" в английской локализации.

Фактически, можно указывать даже параметры в ключе. Вместе с `formatFallbackMessages: true` это позволит опустить создание шаблонов для «базового» языка; потому что его ключи _уже находятся_ в шаблоне.

```js
const messages = {
  ru: {
    'Hello {name}': 'Здравствуйте {name}'
  }
}

const i18n = new VueI18n({
  locale: 'ru',
  fallbackLocale: 'en',
  formatFallbackMessages: true,
  messages
})
```

Шаблон:

```html
<p>{{ $t('Hello {name}', { name: 'John' }}) }}</p>
<p>{{ $t('The weather today is {condition}!', { condition: 'sunny' }) }}</p>
```

Результат:

```html
<p>Здравствуйте, John</p>
<p>The weather today is sunny!</p>
```
