---
sidebarDepth: 2
---
# wujie-polyfill

## WUJIE微前端框架
微前端是一种前端架构的演进，旨在通过将大型单体前端应用程序拆分为多个独立的、可独立部署的小型前端应用程序来解决前端架构的问题。

WUJIE是一个开源的微前端框架，旨在提供一个可扩展的架构，以支持将大型前端应用程序拆分为多个独立的小型前端应用程序。WUJIE微前端框架采用插件形式，并提供了一系列配置，以便对WUJIE进行能力增强。

详细介绍以及文档详见 [wujie](https://wujie-micro.github.io/doc/)

## WUJIE Polyfill

WUJIE Polyfill是一种通过插件增强的方式，去模拟原生HTML、CSS和JavaScript在wujie微前端框架中正常运行的第三方插件库。提供了丰富的插件种类，来修正wujie在各种场景中的表现，使WUJIE框架能够在更复杂的浏览器环境中运行。

### 特点
- 能力增强：通过插件形式，可以对wujie的能力进行增强，提高开发效率。
- 兼容性：对于许多浏览器不支持的功能，polyfill提供了解决方案，确保应用程序在更多的场景下正常工作。
- 灵活配置：可以根据项目需求，自定义polyfill的功能，灵活配置需要的功能。

### 接入方式

目前只提供了npm的安装方式，具体方式可以前往[快速开始](./start.md)查看。


## 使用场景

在以下几种情况下可以尝试使用该polyfill：

1. 兼容性：不同的浏览器对新特性的支持程度不一致，wujie中使用到了诸多新特性进行框架实现，某些场景表现不一致
2. 能力增强：wujie在框架设计时考虑的是大多数的业务场景，在实际业务对接中，子应用可能需要更强大的能力支持与主应用配合，进行业务交互逻辑的实现
3. 错误修正：在某些场景下，子应用可以正常独立运行，但在微前端中受限于能力覆盖或方案实现短板，导致无法正常运行的。
   

### 使用原则

**1. 不推荐全部引入**

由于某些插件是不符合常规的实现方案，但是能够修复某些场景问题而诞生的。全部引入可能会导致插件在某些场景下运作时，产生新的副作用，影响系统正常运行，按需引入更为合适。


**2. 根据具体场景使用**

某些插件是有一定的场景限制的，如`LocationReloadPlugin`, 就无法再ESM模式(vite)下, 很好的工作。根据自身的场景，选取对应的实现方式会更加合适。
