// @flow

import { MiddlewareRegistry } from '../base/redux';
import { CONFERENCE_JOINED } from '../base/conference';

import { statsEmitter } from './index';

/**
 * Implements the middleware of the feature connection-indicator.
 *
 * @param {Store} store - The redux store.
 * @returns {Function}
 */
// eslint-disable-next-line no-unused-vars
MiddlewareRegistry.register(store => next => action => {
    switch (action.type) {
    case CONFERENCE_JOINED: {
        statsEmitter.startListeningForStats(action.conference);
        break;
    }
    }

    return next(action);
});

