<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function compareNatural

Compare two values of any type in a deterministic, natural way.

For numeric values, the function works the same as `math.compare`.
For types of values that can't be compared mathematically,
the function compares in a natural way.

For numeric values, x and y are considered equal when the relative
difference between x and y is smaller than the configured epsilon.
The function cannot be used to compare values smaller than
approximately 2.22e-16.

For Complex numbers, first the real parts are compared. If equal,
the imaginary parts are compared.

Strings are compared with a natural sorting algorithm, which
orders strings in a "logic" way following some heuristics.
This differs from the function `compare`, which converts the string
into a numeric value and compares that. The function `compareText`
on the other hand compares text lexically.

Arrays and Matrices are compared value by value until there is an
unequal pair of values encountered. Objects are compared by sorted
keys until the keys or their values are unequal.


## Syntax

```js
math.compareNatural(x, y)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | * | First value to compare
`y` | * | Second value to compare

### Returns

Type | Description
---- | -----------
number | Returns the result of the comparison: 1 when x > y, -1 when x < y, and 0 when x == y.


## Examples

```js
math.compareNatural(6, 1);              // returns 1
math.compareNatural(2, 3);              // returns -1
math.compareNatural(7, 7);              // returns 0

math.compareNatural('10', '2');         // returns 1
math.compareText('10', '2');            // returns -1
math.compare('10', '2');                // returns 1

math.compareNatural('Answer: 10', 'Answer: 2'); // returns 1
math.compareText('Answer: 10', 'Answer: 2');    // returns -1
math.compare('Answer: 10', 'Answer: 2');
    // Error: Cannot convert "Answer: 10" to a number

var a = math.unit('5 cm');
var b = math.unit('40 mm');
math.compareNatural(a, b);              // returns 1

var c = math.complex('2 + 3i');
var d = math.complex('2 + 4i');
math.compareNatural(c, d);              // returns -1

math.compareNatural([1, 2, 4], [1, 2, 3]); // returns 1
math.compareNatural([1, 2, 3], [1, 2]);    // returns 1
math.compareNatural([1, 5], [1, 2, 3]);    // returns 1
math.compareNatural([1, 2], [1, 2]);       // returns 0

math.compareNatural({a: 2}, {a: 4});       // returns -1
```


## See also

[compare](compare.md),
[compareText](compareText.md)
