<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function erf

Compute the erf function of a value using a rational Chebyshev
approximations for different intervals of x.

This is a translation of W. J. Cody's Fortran implementation from 1987
( http://www.netlib.org/specfun/erf ). See the AMS publication
"Rational Chebyshev Approximations for the Error Function" by W. J. Cody
for an explanation of this process.

For matrices, the function is evaluated element wise.


## Syntax

```js
math.erf(x)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | number &#124; Array &#124; Matrix | A real number

### Returns

Type | Description
---- | -----------
number &#124; Array &#124; Matrix | The erf of `x`


## Examples

```js
math.erf(0.2);    // returns 0.22270258921047847
math.erf(-0.5);   // returns -0.5204998778130465
math.erf(4);      // returns 0.9999999845827421
```


