<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function exp

Calculate the exponent of a value.
For matrices, the function is evaluated element wise.


## Syntax

```js
math.exp(x)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | number &#124; BigNumber &#124; Complex &#124; Array &#124; Matrix | A number or matrix to exponentiate

### Returns

Type | Description
---- | -----------
number &#124; BigNumber &#124; Complex &#124; Array &#124; Matrix | Exponent of `x`


## Examples

```js
math.exp(2);                  // returns number 7.3890560989306495
math.pow(math.e, 2);          // returns number 7.3890560989306495
math.log(math.exp(2));        // returns number 2

math.exp([1, 2, 3]);
// returns Array [
//   2.718281828459045,
//   7.3890560989306495,
//   20.085536923187668
// ]
```


## See also

[expm1](expm1.md),
[log](log.md),
[pow](pow.md)
