<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function isPrime

Test whether a value is prime: has no divisors other than itself and one.
The function supports type `number`, `bignumber`.

The function is evaluated element-wise in case of Array or Matrix input.


## Syntax

```js
math.isPrime(x)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | number &#124; BigNumber &#124; Array &#124; Matrix | Value to be tested

### Returns

Type | Description
---- | -----------
boolean | Returns true when `x` is larger than zero. Throws an error in case of an unknown data type.


## Examples

```js
math.isPrime(3);                     // returns true
math.isPrime(-2);                    // returns false
math.isPrime(0);                     // returns false
math.isPrime(-0);                    // returns false
math.isPrime(0.5);                   // returns false
math.isPrime('2');                   // returns true
math.isPrime([2, 17, 100]);           // returns [true, true, false]
```


## See also

[isNumeric](isNumeric.md),
[isZero](isZero.md),
[isNegative](isNegative.md),
[isInteger](isInteger.md)
