<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function lusolve

Solves the linear system `A * x = b` where `A` is an [n x n] matrix and `b` is a [n] column vector.


## Syntax

```js
math.lusolve(A, b)     // returns column vector with the solution to the linear system A * x = b
math.lusolve(lup, b)   // returns column vector with the solution to the linear system A * x = b, lup = math.lup(A)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`A` | Matrix &#124; Array &#124; Object | Invertible Matrix or the Matrix LU decomposition
`b` | Matrix &#124; Array | Column Vector
`order` | number | The Symbolic Ordering and Analysis order, see slu for details. Matrix must be a SparseMatrix
`threshold` | Number | Partial pivoting threshold (1 for partial pivoting), see slu for details. Matrix must be a SparseMatrix.

### Returns

Type | Description
---- | -----------
DenseMatrix &#124; Array | Column vector with the solution to the linear system A * x = b


## Examples

```js
var m = [[1, 0, 0, 0], [0, 2, 0, 0], [0, 0, 3, 0], [0, 0, 0, 4]];

var x = math.lusolve(m, [-1, -1, -1, -1]);        // x = [[-1], [-0.5], [-1/3], [-0.25]]

var f = math.lup(m);
var x1 = math.lusolve(f, [-1, -1, -1, -1]);       // x1 = [[-1], [-0.5], [-1/3], [-0.25]]
var x2 = math.lusolve(f, [1, 2, 1, -1]);          // x2 = [[1], [1], [1/3], [-0.25]]

var a = [[-2, 3], [2, 1]];
var b = [11, 9];
var x = math.lusolve(a, b);  // [[2], [5]]
```


## See also

[lup](lup.md),
[slu](slu.md),
[lsolve](lsolve.md),
[usolve](usolve.md)
