---
id: version-2.1.0-overview
title: JSONata Documentation
sidebar_label: Overview
original_id: overview
---

## Introduction

JSONata is a lightweight query and transformation language for JSON data. Inspired by the 'location path' semantics of XPath 3.1, it allows sophisticated queries to be expressed in a compact and intuitive notation.  A rich complement of built in operators and functions is provided for manipulating and combining extracted data, and the results of queries can be formatted into any JSON output structure using familiar JSON object and array syntax. Coupled with the facility to create user defined functions, advanced expressions can be built to tackle any JSON query and transformation task.

<p><iframe width="400" height="300" src="https://www.youtube.com/embed/ZBaK40rtIBM" frameborder="0" allowfullscreen></iframe></p>

## Get JSONata

* Try it out at [try.jsonata.org](http://try.jsonata.org/)
* Install the module from [NPM](https://www.npmjs.com/package/jsonata)
* Fork the repo on [GitHub](https://github.com/jsonata-js/jsonata)

## Implementations of JSONata

The following are known implementations of JSONata in addition to the primary implementation in JavaScript in the above repo.

|Language|Link|Notes|JSONata version|
|---|---|---|---|
|C|https://github.com/qlyoung/jsonata-c|Runs JSONata in embedded JS engine|1.8.3|
|Go|https://github.com/blues/jsonata-go|Native implementation|1.5.4|
|Go|https://github.com/yxuco/gojsonata|Native implementation| |
|Java|https://github.com/IBM/JSONata4Java|Native implementation| |
|Java|https://github.com/dashjoin/jsonata-java|Native port of reference|2.0.5|
|.NET|https://github.com/mikhail-barg/jsonata.net.native|Native implementation|1.8.5|
|Python|https://github.com/qlyoung/pyjsonata|API bindings based on C bindings|1.8.3|
|Python|https://github.com/rayokota/jsonata-python|Native port of reference|2.0.5|
|Rust|https://github.com/johanventer/jsonata-rust|Implementation work in progress| |
|Rust|https://github.com/Stedi/jsonata-rs|Actively-developed fork of jsonata-rust| |

## Find out more

* Introduction at [London Node User Group meetup](https://www.youtube.com/watch?v=TDWf6R8aqDo)
