{unbox,KeyManager} = require '../..'

zaher_keys = [
  """-----BEGIN PGP PUBLIC KEY BLOCK-----
Comment: GPGTools - https://gpgtools.org
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=OzOK
-----END PGP PUBLIC KEY BLOCK-----""",
  """-----BEGIN PGP PUBLIC KEY BLOCK-----
Version: Keybase OpenPGP v2.0.8
Comment: https://keybase.io/crypto
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=qTqP
-----END PGP PUBLIC KEY BLOCK-----""",
  """-----BEGIN PGP PUBLIC KEY BLOCK-----
Version: Keybase OpenPGP v2.0.20
Comment: https://keybase.io/crypto
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=An1N
-----END PGP PUBLIC KEY BLOCK-----""",
  """-----BEGIN PGP PUBLIC KEY BLOCK-----
Comment: GPGTools - https://gpgtools.org
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=a/WF
-----END PGP PUBLIC KEY BLOCK-----""",
  """-----BEGIN PGP PUBLIC KEY BLOCK-----
Comment: GPGTools - https://gpgtools.org
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=OzOK
-----END PGP PUBLIC KEY BLOCK-----"""
]

#=================================================================

exports.import_and_merge_zaher = (T, cb) ->
  sponge = null
  for k in zaher_keys
    await KeyManager.import_from_armored_pgp { armored : k }, T.esc(defer(km), cb)
    if sponge?
      sponge.merge_all_subkeys_omitting_revokes km
    else
      sponge = km
  all_key_ids = sponge.get_all_pgp_key_ids()
  T.equal all_key_ids.length, 7, "right number of sponge subkey IDs"
  T.assert ("4c74440dfbf902f7" in (i.toString('hex') for i in all_key_ids)), "needed subkey is there"
  cb()

#=================================================================

max_keys = [
  """-----BEGIN PGP PUBLIC KEY BLOCK-----
Version: Keybase OpenPGP JS 0.0.1
Comment: https://keybase.io/crypto
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=ei3Q
-----END PGP PUBLIC KEY BLOCK-----""",
  """-----BEGIN PGP PUBLIC KEY BLOCK-----
Version: GnuPG/MacGPG2 v2.0.22 (Darwin)
Comment: GPGTools - https://gpgtools.org
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=97ae
-----END PGP PUBLIC KEY BLOCK-----""",
  """-----BEGIN PGP PUBLIC KEY BLOCK-----
Version: GnuPG/MacGPG2 v2.0.22 (Darwin)
Comment: GPGTools - https://gpgtools.org

mQINBFLyu3wBEAC1zq7+3kmHy1hF9aCr47PCPBkkbADzNAEp5KB0/9p4DOmTcDnW
5AQW/rh9wH8ilDhZKPPH/xOqlKa0XSn7JscT/KpigweYu9WvpnB2nnPpX2j7tBD/
x8/jtoroJxrni+s5grZo0Md3q5MsePOwFdJCrr8ezQHaBAVVg8LNVMcY37H3+UbN
/NzC8iUYl5+VNA3eap/bHRi6gWK2RFADL/ECSxcxcvoTBCwo/f2UXs8VGy229lHG
Yc4K7VWcIUOdSdUVJ2MA/5HizgEUte9GLBfDpRKm599OMwiQTbo4IRleUPYT6/0a
klsh9mtPzneNWXa1qEJ5ei+Wk7ZiXt0ujAL9Ynk5DGo6qCBWU7hMv7KOeEjhHr01
JVof+i3g286KUQYk0N6do4E9hE5jRwJQp+50sj9E5yLj0+pEWQ0x/+2C3uuf9otr
vRWYk6XC799ZvI3C+0tPEDsTakgTQJm6ceUtUXGtK/TPAen7hwAM4x9VXjQc7dCZ
BZijo8GR1iMaktQpysva0N9ewN86+FiddXtyad6K4WelZQQRrj5tizehjLTm18G1
Gv/R4BCMIFgbE8naBBB+1fcLDc7SiK5wUWv00YDRilX8zjh/3/0dBZwY7Alz9jtw
XRA1Tbjlr5FSc5x5woCrSX5cyCwWfMrODN+uoTSn4Awt8T01pioSgHVp1wARAQAB
tChrZXliYXNlLmlvL21heCAodjAuMC4xKSA8bWF4QGtleWJhc2UuaW8+iQI2BBAB
CgAgAhsvBQkSzAMAAwsJBwMVCggCHgECF4AFAlMjPAICGQEACgkQYFKyrTGmYxwQ
NhAAjetKZUC2wPQPAMRGz2ROE1CX2Z2Smndyp7fSijhG2GsD4OP5w8Mj5lUoOyOX
B8Bo3rlMwL+rH2eHgyP6D0an5qj8GbGRuiqSngIpfxvtkfiiZYMYy2+6H7pK58ly
y9qgTjx6sHuryWOkvxE7PpavUlFdJXqV9bbnRDoOSNWjCI16nd4V0VErdlLsJCcn
9KMOXz9T1nLjpX/Lg0xiuGNu4IXH9AaJtWTqs7E8kJIbnxux8SB4pQzBcgYybKgg
VWebqJQNMgUNnzKlgH3RV0PzulCt39eKfT2k1eangCzotk50bhViJWcHpuWSArKE
EFUdTiv9s3w1QZCtXWF6enIyxHo4z3bkmN+ddsraXCkboFeT/vwNHzkNxWv1ELmN
x5UzsmNURo3Iegs1tal7kRuFLHL+Z0Kh7ag7z+MTIXFCwZhn1pSWQwKVgEsgVvAR
AFArXOr3PRkkDfx9cd6qq2I7kwJl4bMzYusOSMqRZu86l9vktAcb11HZkPaFvpZS
7vvhuuYLW95CMA01bDCxhriERjpZqw19e2DktFPnQ5DpKzmLjB1eAmJQ1h9atsCw
UV37IA4hFz8xSySqdRRZ0D9QPZ6AmHsLS8qXzbARlPQx5k+jSPTtFBaSm8uoTN44
P0L1UfztgFPEJqKnk1deG3daFXhtUjax4vq/KhC32tOQgMe0IE1heHdlbGwgS3Jv
aG4gPHRoZW1heEBnbWFpbC5jb20+iQI9BBMBCgAnBQJTIzvgAhsvBQkSzAMABQsJ
CAcDBRUKCQgLBRYCAwEAAh4BAheAAAoJEGBSsq0xpmMcaCoP+wTS5G4zUI8BotXi
16CR9ELGkMJbnVmWVLBTFqdnv63BzFQ0HruBE1qr/b5xPQsEFvAgjQ9F9TbajaLH
7qpTxjlPgdAl0Sb3lwycMZ9pe/04xRcCJwY3RdMPIv2ByW/3k0GJ5/c3rebLk/8d
0UqFYwZ3ZVnuGGP5vltuk8aPoXnLs4LJdCDESTFj99TEq1+0VzDfkQJf5WpCbzJZ
02g/v/JgaMKlia44EdVihbVh45Bj9Rwd4MPV0gE4PdQXKvijIva8NL30KGqJjswu
rQDpMmTO92fkv7G7DgxhP/BeDytmEBAPMz4SubHzKQj2gjRdlWqDIGe8yg4zHY9X
Efyj+9oj9d+6ezmSRplV/8HVNOsR5DxUHQMc2vRDxXqMD0AK8/k7VtA40JVpNOYH
Hih6rmM3EskLZNAwUoudGOTud8BM2JCMtMgRj3Yrc7BfoWcZ6Ck8eNZkj4AW4+FZ
ETu77LoU3s1wVbCcAb/ip+hQcdb1colUO/vYIivTuz72NbxxwPxWFgbFhXxmtuR2
ChuO250hF1JrjpqpqiOCN2wVIuxU5hOIJhCHKTTHhJRVMrA1zHJndRxkp0PKQjnC
bKUKELF4NebuejOMJXIGw7EYNZGxukeDCwFmF49nFXkeRxalpilsEGBGEng2Cuzj
Qz6yn/VoBxH0/o78PXCNxh+b+uP6tBxNYXh3ZWxsIEtyb2huIDxtYXhAbWF4ay5v
cmc+iQI9BBMBCgAnBQJTIzv6AhsvBQkSzAMABQsJCAcDBRUKCQgLBRYCAwEAAh4B
AheAAAoJEGBSsq0xpmMcPk0P/i0Dax4AuTswj0MxvYBjTAncNjHdNEnJmYy1PNPK
WjtQRS9LyRQ9MpZadQpEsWeb5FjQcxoSgJ1DGa6NTrAXmhKxOlWBLLJ1IuqFS8kl
pM5ybFSGEBdgwPgWIACpxXQuVGkzR+8lCncnQ9+tOY2mfcXLkiGaBYEl6FCaZZso
f6JWStCOEp5GCyMg1k1P78V+52E878UPcYohGJycZPwGfAg1F2ogfqj5C8QR4FVF
6EMUOmLu9+qEcaVYIMBYhbvURjZn8nfHSzru4FmOmGoRIhr4s/2VmISeNjxmwl6F
WC+415x/4pXzOgZ+TPeDXiWHQULtKrklRUHlo6x466aK0oLZIsZfGcDdj/56wlOH
qi4QBhVHNVimcAIYScRihly5U/jhzA+xlkf2GdwAOEq1EIzK9Oo14Yrzmbv4tCzB
3G/w+e6SQXzrdWEQMZjuovpk6vAWxcnbQld+RclBXYSRw4z4rSnzgng7UpCvk6Kp
xf2/mBxKB1ukKpEAlUIbu3K9By4SJYFq/2OnMSAMQYkVorFVz/R593WI9t//Htnt
LN0LShkhLOcQpP0mXNYRJs0Jti7LnPUuAS3xjPm6Nwz062BBO7eXjKq/KnkExV+H
oyXp1Kii6bsE4AX9WjuXF86/KrO5it7LjiXnvxH3MYqelrcAEZt0uN/MvYxZc+4b
c3rztB1NYXh3ZWxsIEtyb2huIDxrcm9obkBtaXQuZWR1PokCPQQTAQoAJwUCUzBx
VwIbLwUJEswDAAULCQgHAwUVCgkICwUWAgMBAAIeAQIXgAAKCRBgUrKtMaZjHImA
EACVkhpJbAC0r26HndJQ/m9CiKLxAJhqZPbonGTIzxQU8ZvBnyvYwI2MMD4foTyM
eJvDvIdFEArV2eV7t+nvewezrsNFMTisoGS9omtQFVp8Y00h5/vm3f+RsG0Tkx3L
yn6iPFDxQUm73va62dev6E8eyr+4nAHSulLj4HZJgTQzsHdyZLzPvoGLV0RSKj4e
9zHU8e2DTqZWaYlZCm/Rv6w7m+CWFzp6XNC1ujEblCRaZ7X4D7G7ssxm7MCuTZXE
f6OEpSn206lP73LtYXlj/Xi78NRsacrIn8fnxc6Elk7LjeUuqFAAf9yN0N6TdV6w
18ra0mAddk6qtVmfG7Pn7nFMJh0G5mu8iECNI0tv18RCigyZd93YCmwIYQViJ1A+
HrCZ7Y72b3Yq3ERs10F704JLH0VqTEMfQAhsaaGaL81orvLJR7K7/icvoFedLrM9
qiakOQLyL4Ngr5VqVy6bV8/CYUV5MvBtJpdmLi/wlK6Nw7cEO4OFAYIvP47zgKEf
mRdpAlOj5bZtGGy6H+eJJxcH60YXQ+QApOAAXnUW+elsmwq/XeFv9cop8DNJLn5h
PC9emD/tF0VAveIz/J1NIt8c3uOr4hHL5g3fZopNXI1lo3OkJlQO8+cS4hSMDGpF
Wn4j8ACdLx5nNzLiPOBH4DrEDPujog8OtnSk5DxBcl8ytrQmTWF4d2VsbCBLcm9o
biA8a3JvaG5AcG9zdC5oYXJ2YXJkLmVkdT6JAj0EEwEKACcFAlMwcXQCGy8FCRLM
AwAFCwkIBwMFFQoJCAsFFgIDAQACHgECF4AACgkQYFKyrTGmYxxG6g/9HvzgQFXJ
RdcjMdRKKDewgBRjqbPhxEUmBOHGLMKbDCfIXWXWV7DmkGc9aeVprgwszYbaH+fo
0HcT+g+MhK1dPGtWq+G3E6L/LhMBhHBa5AqW3FWaN0fWiZjCqHnD5DtGkXLBxcju
SMZ08rSnPEAoqv+20vepp2yECiuNGo+3SYIGJWRmmNxS56wTDImXnIA8+hNrTAeL
UWMcwqXpgo8lPRHHkDqBsJUo/1sfFBT8qbsVfisAXAeoFN1U0sZK2jRB8b/O7fEy
var/W9mT7pz5DEVfTXpbVONPAb1TMsRb4LvGJvMRc3Yy1KMAz2vRwpEph3AOu2Mr
N+T1hGJddeJ4Goc4K7lGeWYwxlmOqVD2BVL4j29IinBt2GXaitA4YStx4H7WJEyd
rF992iGCoEhtQCgXnXJE30g9dkn+CPIlZ2jth1gkwUJrkdpRZ8zlMZE6yx4nTmIh
MfzZ+YAszqumcnEZH0Iz5BFbXGJJ+OfG1r4zWI8zzU6pZXmK9pSRR+OhB16WQUX/
a1hxTmbe3MPrpFksdXzT3URm6vZ3DFhG/2gnoQCGj83bW1szv7jrCIZnFHz0VPQy
DkMGZf/O58xoZO1ETHQERspau0H74542V7wWA7y9W7DAQHrylqGCHf8Sw2vc5tUd
khx5LolObkVS3ElxNnvBX9EYgu1rJjLDRMG5AQ0EUvK7fAEIAMw3F9CU/IaCeOne
MAiHAUlsrkMgmBk50KH8h23I+zLK+jxLWKtohsmGn0jnczn0p4uiEdhqRE464T/e
mSFHEbAQd8r9bgcJE033hKJ3FXrm1HnAeCeFwVNxiS2cWRgnUP6w17YXk2Zdq2X9
uDPyKUhp2pRKlic/FkhEpz1makzKvm6lUUptq9/xUzYpXUDo2xqqT4fAf0Dwv0h4
um5jd87irXZ1Txc0QMBeFyWWuKvmnL5bdCGWedLyTp3ULCXexuu7Gd7AdDUU5icD
LSe/Hpyst/Ss9Us4vTZu6hiKsLBnrR/O/4VREnnmEAmJMmx1pZvYFSVoXDzWBirG
4LhMcAsAEQEAAYkDRAQYAQoADwUCUvK7fAUJAeEzgAIbLgEpCRBgUrKtMaZjHMBd
IAQZAQoABgUCUvK7fAAKCRCYCj8NAf4E34z7B/9Xj+EEWbn01l2cvPMMmnsH5vFY
qHkbvk9T8CXE/QeJuyMgldPj0LKGHCcAP7pUlUxLlAMNAJE8Nd+evzXaNsTqjF3a
kidZnqjKX/URoj1dlRVHet7u01sAjzNYiMa3ysWRB6FDrQsp36iz1kR+lGVpieZN
n8gC+ylQz09SVHFTrZux6XHHJe23GrFZOmjyJniTDfQ/qNtnoAOK/T1lHXgec6lx
B9rcah1ggBKhier/+s19dLUnwwTG16z9f5dtGD7k4vL+IYSkZkRLTNW3eKiIRJd7
fthHRsVOPDhOCAzP2b82p7KiR7EtrMDFiHpXxKcBQVjeOscss7oUurX7lhKFp/gP
/0B+mdvSPXF5axkrITrwmjkW760yJgs24qKmudnUqisNBQtkWYeNUW+/ws3zL2uH
/1xwKQpRjRdtxDhKaREZSzIUGxKVW1ztuwnZyUHDBDitzSSqXjRf0Y46zsTaK6Vx
pvH2DQrXkM7sDmqeHLGe0mEHrzrhm731ZTaAFEp9+hUWOdnUHGjMX4LjWVwR44qW
9gaZkJEpWJpCtEhCguz/LvVoQcX0zbx9ke8SmREyNydwvVFrX8v8LTYOFUjpZDMm
aaV/KF9E/5EL5m0YKYR3pXrRykJnJVeRqomhpz1vdP8tsYqK8+kPSJCFDn5bhqlB
nFLtJWaFAKAsesFC6/C1DUKuHhGH9eKRDEOhLjNX2Fc7D5t+Oni9AVyJ16Qku3si
go3E8IynXobEgYxgxdzDAKKugxnXx+jHE04zt0WWoxZJ99GVyRuZwBoJ0tVxWEaI
40Tz0zqcqgFw1f195yQY9MysQh2Pr/Zlec4Y3dvW4+wMJKnijwKoCFHRr9FbQogv
PnyKAFX1xYMxrS9v1eWTQ9DN7bsS86d2BvqoOIX+Th7/7oBWvDXOJK0NGjQ8m4uL
2B5a3CTdABlYdKb6h/fESNPk3DN7y8horMo6LbCytKzttBKcPZzjVoqrlM+TJLEl
pe/iG4ReyMzfHwBxM3ORWFncu87+HH//p4VSw0MfvjIz
=xYpp
-----END PGP PUBLIC KEY BLOCK-----""",
  """-----BEGIN PGP PUBLIC KEY BLOCK-----
Version: GnuPG/MacGPG2 v2.0.22 (Darwin)
Comment: GPGTools - https://gpgtools.org

mQINBFLyu3wBEAC1zq7+3kmHy1hF9aCr47PCPBkkbADzNAEp5KB0/9p4DOmTcDnW
5AQW/rh9wH8ilDhZKPPH/xOqlKa0XSn7JscT/KpigweYu9WvpnB2nnPpX2j7tBD/
x8/jtoroJxrni+s5grZo0Md3q5MsePOwFdJCrr8ezQHaBAVVg8LNVMcY37H3+UbN
/NzC8iUYl5+VNA3eap/bHRi6gWK2RFADL/ECSxcxcvoTBCwo/f2UXs8VGy229lHG
Yc4K7VWcIUOdSdUVJ2MA/5HizgEUte9GLBfDpRKm599OMwiQTbo4IRleUPYT6/0a
klsh9mtPzneNWXa1qEJ5ei+Wk7ZiXt0ujAL9Ynk5DGo6qCBWU7hMv7KOeEjhHr01
JVof+i3g286KUQYk0N6do4E9hE5jRwJQp+50sj9E5yLj0+pEWQ0x/+2C3uuf9otr
vRWYk6XC799ZvI3C+0tPEDsTakgTQJm6ceUtUXGtK/TPAen7hwAM4x9VXjQc7dCZ
BZijo8GR1iMaktQpysva0N9ewN86+FiddXtyad6K4WelZQQRrj5tizehjLTm18G1
Gv/R4BCMIFgbE8naBBB+1fcLDc7SiK5wUWv00YDRilX8zjh/3/0dBZwY7Alz9jtw
XRA1Tbjlr5FSc5x5woCrSX5cyCwWfMrODN+uoTSn4Awt8T01pioSgHVp1wARAQAB
tChrZXliYXNlLmlvL21heCAodjAuMC4xKSA8bWF4QGtleWJhc2UuaW8+iQI2BBAB
CgAgAhsvBQkSzAMAAwsJBwMVCggCHgECF4AFAlMjPAICGQEACgkQYFKyrTGmYxwQ
NhAAjetKZUC2wPQPAMRGz2ROE1CX2Z2Smndyp7fSijhG2GsD4OP5w8Mj5lUoOyOX
B8Bo3rlMwL+rH2eHgyP6D0an5qj8GbGRuiqSngIpfxvtkfiiZYMYy2+6H7pK58ly
y9qgTjx6sHuryWOkvxE7PpavUlFdJXqV9bbnRDoOSNWjCI16nd4V0VErdlLsJCcn
9KMOXz9T1nLjpX/Lg0xiuGNu4IXH9AaJtWTqs7E8kJIbnxux8SB4pQzBcgYybKgg
VWebqJQNMgUNnzKlgH3RV0PzulCt39eKfT2k1eangCzotk50bhViJWcHpuWSArKE
EFUdTiv9s3w1QZCtXWF6enIyxHo4z3bkmN+ddsraXCkboFeT/vwNHzkNxWv1ELmN
x5UzsmNURo3Iegs1tal7kRuFLHL+Z0Kh7ag7z+MTIXFCwZhn1pSWQwKVgEsgVvAR
AFArXOr3PRkkDfx9cd6qq2I7kwJl4bMzYusOSMqRZu86l9vktAcb11HZkPaFvpZS
7vvhuuYLW95CMA01bDCxhriERjpZqw19e2DktFPnQ5DpKzmLjB1eAmJQ1h9atsCw
UV37IA4hFz8xSySqdRRZ0D9QPZ6AmHsLS8qXzbARlPQx5k+jSPTtFBaSm8uoTN44
P0L1UfztgFPEJqKnk1deG3daFXhtUjax4vq/KhC32tOQgMe0IE1heHdlbGwgS3Jv
aG4gPHRoZW1heEBnbWFpbC5jb20+iQI9BBMBCgAnBQJTIzvgAhsvBQkSzAMABQsJ
CAcDBRUKCQgLBRYCAwEAAh4BAheAAAoJEGBSsq0xpmMcaCoP+wTS5G4zUI8BotXi
16CR9ELGkMJbnVmWVLBTFqdnv63BzFQ0HruBE1qr/b5xPQsEFvAgjQ9F9TbajaLH
7qpTxjlPgdAl0Sb3lwycMZ9pe/04xRcCJwY3RdMPIv2ByW/3k0GJ5/c3rebLk/8d
0UqFYwZ3ZVnuGGP5vltuk8aPoXnLs4LJdCDESTFj99TEq1+0VzDfkQJf5WpCbzJZ
02g/v/JgaMKlia44EdVihbVh45Bj9Rwd4MPV0gE4PdQXKvijIva8NL30KGqJjswu
rQDpMmTO92fkv7G7DgxhP/BeDytmEBAPMz4SubHzKQj2gjRdlWqDIGe8yg4zHY9X
Efyj+9oj9d+6ezmSRplV/8HVNOsR5DxUHQMc2vRDxXqMD0AK8/k7VtA40JVpNOYH
Hih6rmM3EskLZNAwUoudGOTud8BM2JCMtMgRj3Yrc7BfoWcZ6Ck8eNZkj4AW4+FZ
ETu77LoU3s1wVbCcAb/ip+hQcdb1colUO/vYIivTuz72NbxxwPxWFgbFhXxmtuR2
ChuO250hF1JrjpqpqiOCN2wVIuxU5hOIJhCHKTTHhJRVMrA1zHJndRxkp0PKQjnC
bKUKELF4NebuejOMJXIGw7EYNZGxukeDCwFmF49nFXkeRxalpilsEGBGEng2Cuzj
Qz6yn/VoBxH0/o78PXCNxh+b+uP6tBxNYXh3ZWxsIEtyb2huIDxtYXhAbWF4ay5v
cmc+iQI9BBMBCgAnBQJTIzv6AhsvBQkSzAMABQsJCAcDBRUKCQgLBRYCAwEAAh4B
AheAAAoJEGBSsq0xpmMcPk0P/i0Dax4AuTswj0MxvYBjTAncNjHdNEnJmYy1PNPK
WjtQRS9LyRQ9MpZadQpEsWeb5FjQcxoSgJ1DGa6NTrAXmhKxOlWBLLJ1IuqFS8kl
pM5ybFSGEBdgwPgWIACpxXQuVGkzR+8lCncnQ9+tOY2mfcXLkiGaBYEl6FCaZZso
f6JWStCOEp5GCyMg1k1P78V+52E878UPcYohGJycZPwGfAg1F2ogfqj5C8QR4FVF
6EMUOmLu9+qEcaVYIMBYhbvURjZn8nfHSzru4FmOmGoRIhr4s/2VmISeNjxmwl6F
WC+415x/4pXzOgZ+TPeDXiWHQULtKrklRUHlo6x466aK0oLZIsZfGcDdj/56wlOH
qi4QBhVHNVimcAIYScRihly5U/jhzA+xlkf2GdwAOEq1EIzK9Oo14Yrzmbv4tCzB
3G/w+e6SQXzrdWEQMZjuovpk6vAWxcnbQld+RclBXYSRw4z4rSnzgng7UpCvk6Kp
xf2/mBxKB1ukKpEAlUIbu3K9By4SJYFq/2OnMSAMQYkVorFVz/R593WI9t//Htnt
LN0LShkhLOcQpP0mXNYRJs0Jti7LnPUuAS3xjPm6Nwz062BBO7eXjKq/KnkExV+H
oyXp1Kii6bsE4AX9WjuXF86/KrO5it7LjiXnvxH3MYqelrcAEZt0uN/MvYxZc+4b
c3rztB1NYXh3ZWxsIEtyb2huIDxrcm9obkBtaXQuZWR1PokCPQQTAQoAJwUCUzBx
VwIbLwUJEswDAAULCQgHAwUVCgkICwUWAgMBAAIeAQIXgAAKCRBgUrKtMaZjHImA
EACVkhpJbAC0r26HndJQ/m9CiKLxAJhqZPbonGTIzxQU8ZvBnyvYwI2MMD4foTyM
eJvDvIdFEArV2eV7t+nvewezrsNFMTisoGS9omtQFVp8Y00h5/vm3f+RsG0Tkx3L
yn6iPFDxQUm73va62dev6E8eyr+4nAHSulLj4HZJgTQzsHdyZLzPvoGLV0RSKj4e
9zHU8e2DTqZWaYlZCm/Rv6w7m+CWFzp6XNC1ujEblCRaZ7X4D7G7ssxm7MCuTZXE
f6OEpSn206lP73LtYXlj/Xi78NRsacrIn8fnxc6Elk7LjeUuqFAAf9yN0N6TdV6w
18ra0mAddk6qtVmfG7Pn7nFMJh0G5mu8iECNI0tv18RCigyZd93YCmwIYQViJ1A+
HrCZ7Y72b3Yq3ERs10F704JLH0VqTEMfQAhsaaGaL81orvLJR7K7/icvoFedLrM9
qiakOQLyL4Ngr5VqVy6bV8/CYUV5MvBtJpdmLi/wlK6Nw7cEO4OFAYIvP47zgKEf
mRdpAlOj5bZtGGy6H+eJJxcH60YXQ+QApOAAXnUW+elsmwq/XeFv9cop8DNJLn5h
PC9emD/tF0VAveIz/J1NIt8c3uOr4hHL5g3fZopNXI1lo3OkJlQO8+cS4hSMDGpF
Wn4j8ACdLx5nNzLiPOBH4DrEDPujog8OtnSk5DxBcl8ytrQmTWF4d2VsbCBLcm9o
biA8a3JvaG5AcG9zdC5oYXJ2YXJkLmVkdT6JAj0EEwEKACcFAlMwcXQCGy8FCRLM
AwAFCwkIBwMFFQoJCAsFFgIDAQACHgECF4AACgkQYFKyrTGmYxxG6g/9HvzgQFXJ
RdcjMdRKKDewgBRjqbPhxEUmBOHGLMKbDCfIXWXWV7DmkGc9aeVprgwszYbaH+fo
0HcT+g+MhK1dPGtWq+G3E6L/LhMBhHBa5AqW3FWaN0fWiZjCqHnD5DtGkXLBxcju
SMZ08rSnPEAoqv+20vepp2yECiuNGo+3SYIGJWRmmNxS56wTDImXnIA8+hNrTAeL
UWMcwqXpgo8lPRHHkDqBsJUo/1sfFBT8qbsVfisAXAeoFN1U0sZK2jRB8b/O7fEy
var/W9mT7pz5DEVfTXpbVONPAb1TMsRb4LvGJvMRc3Yy1KMAz2vRwpEph3AOu2Mr
N+T1hGJddeJ4Goc4K7lGeWYwxlmOqVD2BVL4j29IinBt2GXaitA4YStx4H7WJEyd
rF992iGCoEhtQCgXnXJE30g9dkn+CPIlZ2jth1gkwUJrkdpRZ8zlMZE6yx4nTmIh
MfzZ+YAszqumcnEZH0Iz5BFbXGJJ+OfG1r4zWI8zzU6pZXmK9pSRR+OhB16WQUX/
a1hxTmbe3MPrpFksdXzT3URm6vZ3DFhG/2gnoQCGj83bW1szv7jrCIZnFHz0VPQy
DkMGZf/O58xoZO1ETHQERspau0H74542V7wWA7y9W7DAQHrylqGCHf8Sw2vc5tUd
khx5LolObkVS3ElxNnvBX9EYgu1rJjLDRMG0Ik1heHdlbGwgS3JvaG4gPGtyb2hu
QGFsdW0ubWl0LmVkdT6JAj0EEwEKACcFAlMwcbsCGy8FCRLMAwAFCwkIBwMFFQoJ
CAsFFgIDAQACHgECF4AACgkQYFKyrTGmYxzhaRAAitV34CP2hSEAm/EtQalqzu7o
TuMDiuLAxhJ0UMh9TdhJpZ8b9/eA1I219GWQfAyggkorPVB+L6sN8s4gTmSmOXVb
tmbo/TbuOSYARriPc6yx4nai5EMjuXJrD2L5956dYrd6cyvMO9eIZroaPBc7sIMF
3YkMiAJP5wNuH1eWcMB8f+GZWGkynBiYP2AE+pOXXJkgyu2wnuJmWmpiYsoyW1ul
fGrSt8wFoDoLQZ+wIPhckGrBfa/TZvuxE9lz+tS2MLMLbyCEdn3s8qSAwi++7GMG
SXHiUeopzs6hto9Egwhv5934+kCkgL3PWdSCNu1mg1aNTsauomzG5QsDM4tNTZQ8
ItsfksMVOhgVdAXtQlHPewVZ6liabyaQTYQPzUU29HM3u7WkxNvImImVz+bR6Ru5
CU2toDKs/OtxQwMat1p3a8yENn4T8030EFAUi5/hL4zvu27YEyJQc28o3a3rd30+
tihjJ86UguBvk1AJXKnmy/fr5tFuw1Izy7zfjznyyh4mhb7uA4hZElz9rR68c6aT
eAyK/kjXVIhfteKe0El3rLJRDY7W56fv/NIxF4ozKqliarLhclP4WArIo8WVO6m1
tglyulpRppQpvFOaDXmYZufVKNMMOtQlSyLEMBk02EhzFf7MxupsOHsuxS1zZ17k
xrSUvn7r//I6BOvdXQO5AQ0EUvK7fAEIAMw3F9CU/IaCeOneMAiHAUlsrkMgmBk5
0KH8h23I+zLK+jxLWKtohsmGn0jnczn0p4uiEdhqRE464T/emSFHEbAQd8r9bgcJ
E033hKJ3FXrm1HnAeCeFwVNxiS2cWRgnUP6w17YXk2Zdq2X9uDPyKUhp2pRKlic/
FkhEpz1makzKvm6lUUptq9/xUzYpXUDo2xqqT4fAf0Dwv0h4um5jd87irXZ1Txc0
QMBeFyWWuKvmnL5bdCGWedLyTp3ULCXexuu7Gd7AdDUU5icDLSe/Hpyst/Ss9Us4
vTZu6hiKsLBnrR/O/4VREnnmEAmJMmx1pZvYFSVoXDzWBirG4LhMcAsAEQEAAYkD
RAQYAQoADwUCUvK7fAUJAeEzgAIbLgEpCRBgUrKtMaZjHMBdIAQZAQoABgUCUvK7
fAAKCRCYCj8NAf4E34z7B/9Xj+EEWbn01l2cvPMMmnsH5vFYqHkbvk9T8CXE/QeJ
uyMgldPj0LKGHCcAP7pUlUxLlAMNAJE8Nd+evzXaNsTqjF3akidZnqjKX/URoj1d
lRVHet7u01sAjzNYiMa3ysWRB6FDrQsp36iz1kR+lGVpieZNn8gC+ylQz09SVHFT
rZux6XHHJe23GrFZOmjyJniTDfQ/qNtnoAOK/T1lHXgec6lxB9rcah1ggBKhier/
+s19dLUnwwTG16z9f5dtGD7k4vL+IYSkZkRLTNW3eKiIRJd7fthHRsVOPDhOCAzP
2b82p7KiR7EtrMDFiHpXxKcBQVjeOscss7oUurX7lhKFp/gP/0B+mdvSPXF5axkr
ITrwmjkW760yJgs24qKmudnUqisNBQtkWYeNUW+/ws3zL2uH/1xwKQpRjRdtxDhK
aREZSzIUGxKVW1ztuwnZyUHDBDitzSSqXjRf0Y46zsTaK6VxpvH2DQrXkM7sDmqe
HLGe0mEHrzrhm731ZTaAFEp9+hUWOdnUHGjMX4LjWVwR44qW9gaZkJEpWJpCtEhC
guz/LvVoQcX0zbx9ke8SmREyNydwvVFrX8v8LTYOFUjpZDMmaaV/KF9E/5EL5m0Y
KYR3pXrRykJnJVeRqomhpz1vdP8tsYqK8+kPSJCFDn5bhqlBnFLtJWaFAKAsesFC
6/C1DUKuHhGH9eKRDEOhLjNX2Fc7D5t+Oni9AVyJ16Qku3sigo3E8IynXobEgYxg
xdzDAKKugxnXx+jHE04zt0WWoxZJ99GVyRuZwBoJ0tVxWEaI40Tz0zqcqgFw1f19
5yQY9MysQh2Pr/Zlec4Y3dvW4+wMJKnijwKoCFHRr9FbQogvPnyKAFX1xYMxrS9v
1eWTQ9DN7bsS86d2BvqoOIX+Th7/7oBWvDXOJK0NGjQ8m4uL2B5a3CTdABlYdKb6
h/fESNPk3DN7y8horMo6LbCytKzttBKcPZzjVoqrlM+TJLElpe/iG4ReyMzfHwBx
M3ORWFncu87+HH//p4VSw0MfvjIz
=lhzE
-----END PGP PUBLIC KEY BLOCK-----""",
  """-----BEGIN PGP PUBLIC KEY BLOCK-----
Comment: GPGTools - https://gpgtools.org
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=icYF
-----END PGP PUBLIC KEY BLOCK-----""",
  """-----BEGIN PGP PUBLIC KEY BLOCK-----
Comment: GPGTools - https://gpgtools.org
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=icYF
-----END PGP PUBLIC KEY BLOCK-----""" ]

signed_by_max = """-----BEGIN PGP MESSAGE-----
Comment: GPGTools - http://gpgtools.org

owEBTgGx/pANAwAIAZgKPw0B/gTfAcseYgBVqv0Zc21hbGwgYXV0aGVudGljIG1l
c3NhZ2UKiQEcBAABCAAGBQJVqv0ZAAoJEJgKPw0B/gTfxpEIAIrV7fk6HuBO/kMt
wN7kBrerwPAWPdTdTbZG4juFomy6vDsrG4zaF8eCfd80ZOehPnLYyO+zIUKt70yp
vwexVNoX9aETyKcvs/hlZV2QrIF3+aA4GugZURYtjXxp1r6LMETHTmcxHhF3Sjwo
GKgHtfvuN2e6bX5790RAvQofdqT+p6mDikMDPHHnH0CTmd60vxTE12NjUicUASP3
rt/OA9azSK+CCsW8xG+B/l5KKLBBfioFYICQuPBecmvInOjIRRxCksEw8ZLJxiyH
cHRMB5uXYp5rz4YqSD4q3K8fjFokAAWV2KJKCjL6rHnpmUWTB0qctHv+N3Co2/c9
sYrYsAo=
=Euem
-----END PGP MESSAGE-----
"""

#=================================================================

# Max's sequence of keys posted to keybase have earlier bundles
# for which subkeys have expired, and later bundles for which the subkeys
# have extended life.  So we'll merge the subkeys in both directions and
# check that in both cases, the subkey with the longer expiration is taken.
exports.import_and_merge_max = (T, cb) ->
  sponge = null
  check = (cb) ->
    for k in max_keys
      await KeyManager.import_from_armored_pgp { armored : k, opts : { time_travel : true } }, T.esc(defer(km), cb)
      if sponge?
        sponge.merge_all_subkeys_omitting_revokes km
      else
        sponge = km
    now = 1486842837 - 100
    await unbox { keyfetch : sponge, armored : signed_by_max, now }, defer err, literals
    T.no_error err
    T.equal "small authentic message\n", literals[0].data.toString('utf8'), "right message"
    T.equal "8efbe2e4dd56b35273634e8f6052b2ad31a6631c", literals[0].get_data_signer().get_key_manager().get_pgp_fingerprint().toString("hex"), "right fingerprint"
    cb()
  await check defer()
  max_keys.reverse()
  await check defer()
  cb()

#=================================================================

kian_keys = [
  """-----BEGIN PGP PUBLIC KEY BLOCK-----
Version: GnuPG v1

mQGiBEswb1sRBAC4lJZV3cdJHgwkmwWiCtrlTQn91OyT9PIWoEcS1HZHJueJNnxi
9UgjNw9Wl4GNaR+uza05Oq231/Pv6MTUJzIU+Zhdqi/OL36HpFC6tg1c7b14wCXE
mnMr8VFDEDKIoR1NzjXCgbuOeNQ0ee30cSGs9lP3xzc8DWQGbaQK5HUPewCgodDT
FNNo8igX6qfQ2dN2aiGcRREEAJHe8lO73jjbLITG4Z1pwtsTFekTbjFedz54YsI7
TbCVGS9bQCWq7n0K4UdJF/rDQPZ3fYjLNtlAuFGJmtysDICzqPYQU1DiKT2Ty+G0
7X0JTvQlFKOvZmK9gGoVvqPsdggHNOFTtFHkyfTPZI8hvI3hIm3PcDB1Ssy/KFFu
xGY3A/4kj522COGLP0osmqpiVXJXrwITNJRFMH4uQvqKkThLHc3jf7BmWTRepH3O
bgPWy+uJ4hLp1fHymmDbh+7BII8OxfEfbov1rk54qRRUzxVOcAU0KySEtrtVCNw3
4rdfeEHe0UO+uUBt6oIx5Wbj/iRHZcpFax6+RoFpMK2hkqPckrQoS2lhbiBNb2hh
Z2VyaSA8a2lhbi5tb2hhZ2VyaUBwYXBlcmcuY29tPohmBBMRAgAmBQJLMG9bAhsj
BQkJZgGABgsJCAcDAgQVAggDBBYCAwECHgECF4AACgkQaN2dJHyOqQzgnACcCWen
InfAL7vrXeYfA8ftCsONuroAnjeDccsboB2BfpoNDC4kc0W3C/+nuQINBEswb1sQ
CACU7S48T9CuVT5zAuH1uT6NxmRrCcXcDp5fUn740ebVx5CL/spv6Qg57AhgVykN
e1cAU4euQHzHIMHn+A6z8IcuV7id/elsgqpUdsA0Z6CoW4DKEprSAUyqIkERkw6k
s5EfYFdix8LaBUta7qcmXMtGkQGscNZk+WUClacP1nPIuuQjZygp5U0btLV9P80p
1gvVKnHuOjYOPD2Qnmd5zOlpPfK1W3lD9bgPrWth10a9GFnI1EB07D62ON04MfNU
bSAY/Lf1JWIJ86kY9o7950O80mv5w5wrkprgIQkxz3gmIn/HTtpNMEtUoAHVlzyz
TTgtBZ9ksF4MmmwrYCYJqJmLAAMFB/9h6EDTb4fornoW12AJdkpcBDPnWrrRfAEq
r7nn/uDPtXPyz3mE3h9vGk6MbWOdDbxtZKcqje5QeZNFHWl8fpFneufchFbyapyd
z93aB+YdCiG3PH5k5rZux87M2904zcF5UCAdqni2cSKdFlIoTuK+cL50Vbb4yNba
a0DhfnjOjZj77s0+mqyx4uHGFPfE3wcxMQAKeSWwLDxCryKbxaiwmd4ucVlnVFnu
rYFf9XkS6Y+RK2wQYV4+4YoCNPesQbnx1qWqoiIDB69R/RuI3H+JnQWa0CHM9Zmn
r7TgQSMqbYP6YsM6F8hHfPB9tsW7xMB1YVQbr9mZuacFfOnxM6oKiE8EGBECAA8F
Akswb1sCGwwFCQlmAYAACgkQaN2dJHyOqQzYcwCfR5rLZJ4TyyCsNhJVPbQB9ZzF
CiMAn03e4htAqd9pNE1c3oewqlx9LMJm
=cUlP
-----END PGP PUBLIC KEY BLOCK-----""",
  """-----BEGIN PGP PUBLIC KEY BLOCK-----
Version: GnuPG v2

mQGiBEswb1sRBAC4lJZV3cdJHgwkmwWiCtrlTQn91OyT9PIWoEcS1HZHJueJNnxi
9UgjNw9Wl4GNaR+uza05Oq231/Pv6MTUJzIU+Zhdqi/OL36HpFC6tg1c7b14wCXE
mnMr8VFDEDKIoR1NzjXCgbuOeNQ0ee30cSGs9lP3xzc8DWQGbaQK5HUPewCgodDT
FNNo8igX6qfQ2dN2aiGcRREEAJHe8lO73jjbLITG4Z1pwtsTFekTbjFedz54YsI7
TbCVGS9bQCWq7n0K4UdJF/rDQPZ3fYjLNtlAuFGJmtysDICzqPYQU1DiKT2Ty+G0
7X0JTvQlFKOvZmK9gGoVvqPsdggHNOFTtFHkyfTPZI8hvI3hIm3PcDB1Ssy/KFFu
xGY3A/4kj522COGLP0osmqpiVXJXrwITNJRFMH4uQvqKkThLHc3jf7BmWTRepH3O
bgPWy+uJ4hLp1fHymmDbh+7BII8OxfEfbov1rk54qRRUzxVOcAU0KySEtrtVCNw3
4rdfeEHe0UO+uUBt6oIx5Wbj/iRHZcpFax6+RoFpMK2hkqPckrQoS2lhbiBNb2hh
Z2VyaSA8a2lhbi5tb2hhZ2VyaUBwYXBlcmcuY29tPohmBBMRAgAmBQJLMG9bAhsj
BQkJZgGABgsJCAcDAgQVAggDBBYCAwECHgECF4AACgkQaN2dJHyOqQzgnACcCWen
InfAL7vrXeYfA8ftCsONuroAnjeDccsboB2BfpoNDC4kc0W3C/+niGYEExECACYC
GyMGCwkIBwMCBBUCCAMEFgIDAQIeAQIXgAUCVHTmBgUJDQbdngAKCRBo3Z0kfI6p
DCAiAKCJGMMbkdfMhPxRK66PQ5sZFk5Z/QCfcaDP/3Em3RrBZvtksASFEnMLDDSJ
AhwEEwECAAYFAlHMv7EACgkQu4EYnuLzQcd+nQ//dG65NHIrq98dve0UDioKXBUQ
sYDrpSHmvBM07i08hQl+3095rXY4Ao39Ss6SPFy5aKmaMo7C9wHwRCCgTwJdMmzC
OzSCeaT7JytRPI86g3Ylp6vVELRE6hAVs3gawW2lTl9HuQ7VtBcvV4ni4+Yoaad7
yqAGbJdUiHimMBWDiQlqPwHcarsceVp7hUBSnl0r4sfS/u3eL2xjNVULSWkO+5L5
2KgWv7m2IVaWq2YnDRqCzEbk/nVMmr06Ej35sGXXihxD7S5gq1sHMkopfUGeu4fk
ZX8iQaFwLuYqxcXxdtGb4W3QZu+GqWY1TAbqHStak0VwrAkyJX9HDJI7rApMPKm+
a6AM5aanwDQDsLYClcdcq2V+ZnjI7g+buX9ZVH7hqg50It6pCg0RNQH+/px3rEGs
J8S6J0HS9Lnl3IWd0kDqiH45Y1ulYkDsuhzMtJv9R+ebMRtcDKKUGufA3u171S9Z
NOypL31zRVNGLKunBJvWbcZKMygU77Dj37Ojj26O/DXtSm4e0QEIDGfDEyxhSMNs
Jscmu5a48oCT/glr0b6x7XIrdb7g9Lf2jvJccJ55a02ihiyOBBNKct80eMXgYStS
3HuPY623Fem2sT73pHmqHccn9DMY0jqNnhoUADmZfVu2sqUrf9Jng1W95r1M8o5r
Xwk0B8NFpigYt7N9XIi5Ag0ESzBvWxAIAJTtLjxP0K5VPnMC4fW5Po3GZGsJxdwO
nl9SfvjR5tXHkIv+ym/pCDnsCGBXKQ17VwBTh65AfMcgwef4DrPwhy5XuJ396WyC
qlR2wDRnoKhbgMoSmtIBTKoiQRGTDqSzkR9gV2LHwtoFS1rupyZcy0aRAaxw1mT5
ZQKVpw/Wc8i65CNnKCnlTRu0tX0/zSnWC9Uqce46Ng48PZCeZ3nM6Wk98rVbeUP1
uA+ta2HXRr0YWcjUQHTsPrY43Tgx81RtIBj8t/UlYgnzqRj2jv3nQ7zSa/nDnCuS
muAhCTHPeCYif8dO2k0wS1SgAdWXPLNNOC0Fn2SwXgyabCtgJgmomYsAAwUH/2Ho
QNNvh+iuehbXYAl2SlwEM+dautF8ASqvuef+4M+1c/LPeYTeH28aToxtY50NvG1k
pyqN7lB5k0UdaXx+kWd659yEVvJqnJ3P3doH5h0KIbc8fmTmtm7Hzszb3TjNwXlQ
IB2qeLZxIp0WUihO4r5wvnRVtvjI1tprQOF+eM6NmPvuzT6arLHi4cYU98TfBzEx
AAp5JbAsPEKvIpvFqLCZ3i5xWWdUWe6tgV/1eRLpj5ErbBBhXj7higI096xBufHW
paqiIgMHr1H9G4jcf4mdBZrQIcz1maevtOBBIyptg/piwzoXyEd88H22xbvEwHVh
VBuv2Zm5pwV86fEzqgqITwQYEQIADwUCSzBvWwIbDAUJCWYBgAAKCRBo3Z0kfI6p
DNhzAJ9HmstknhPLIKw2ElU9tAH1nMUKIwCfTd7iG0Cp32k0TVzeh7CqXH0swmaI
TwQYEQIADwIbDAUCVHTmLQUJDQbdzAAKCRBo3Z0kfI6pDCWHAJ9kaTkHEqnplP73
dspbtAkzTNRD/gCdHtsR49TPzmvUPeia8Tq9GDFJoeU=
=9Ge2
-----END PGP PUBLIC KEY BLOCK-----""",
  """-----BEGIN PGP PUBLIC KEY BLOCK-----
Version: GnuPG v2
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=9Ge2
-----END PGP PUBLIC KEY BLOCK-----"""
]

#=================================================================

# Max's sequence of keys posted to keybase have earlier bundles
# for which subkeys have expired, and later bundles for which the subkeys
# have extended life.  So we'll merge the subkeys in both directions and
# check that in both cases, the subkey with the longer expiration is taken.
exports.import_and_merge_kian = (T, cb) ->
  sponge = null
  check = (cb) ->
    for k,i in kian_keys
      await KeyManager.import_from_armored_pgp { armored : k, opts : { time_travel : true } }, T.esc(defer(km), cb)
      if sponge?
        sponge.merge_public_omitting_revokes km
      else
        sponge = km
    T.equal sponge.primary.lifespan.expire_in, 218553758, "right expire_in"
    T.equal sponge.primary.lifespan.generated, 1261465435, "right generate"
    cb()
  await check defer()
  kian_keys.reverse()
  await check defer()
  cb()

#=================================================================

example_key_with_valid_subkey = """
-----BEGIN PGP PUBLIC KEY BLOCK-----
Version: GnuPG v2

mI0EVblb1AEEAMLAK6bung86DQEkvFkDblpRBEkrUufDf354BcMserty088JIFI2
3j+YP8EDaf8gJnKAbHnYQP640f+I7+9Ul65PUtuuHXRkDMps7GYaJGlhPx26xGnx
/JL+ItgtYM/cLLmKSg0h/aVdYfW7Pc13PFSyXR0lkawleC926ifBUrqPABEBAAG0
B2V4YW1wbGWIuQQTAQIAIwUCVblb1AIbAwcLCQgHAwIBBhUIAgkKCwQWAgMBAh4B
AheAAAoJENBEjHHUvXzP124D/1p0MDoMJFiy7EiMEEkmZLY2qYFe7uAV7ZnhcKyr
WHKVSGOtS97ePMyckKPzVh31Itx5F65xydJm6xUdYCY0ySWvBvnWOzSZVRFSAONe
tpn9RG0009VL7SIAus6AbpE09Wu8Xp4Bo0mJZU5kU9ff1+x72PDQvbN7NpbCOtau
PCoFuI0EVblfXwEEAKx4dZbYXfoyJumCAW9YV+sEJFH0ylP9z3nNOojqHlEs3Tbk
R2UmI1triprzxPK+t8p008+ODSh9AXpgPRTDbJmmw/JgCNeLqVZ5NjMfV/DDfKYl
AtAnc4SZYtIgEgtaXOCj2eBmizJ17uQ6mIjxrhltr4uaW48K+3hlY8VP0n6bABEB
AAGJAUMEGAECAA8FAlW5X18CGwIFCQAJOoAAqAkQ0ESMcdS9fM+dIAQZAQIABgUC
VblfXwAKCRDQ92kTekiF8q59BACixtqqEST8xS+DG8fimLr3qaO0clXuNUJksGGI
5MwfGF0uPnn8T9Usm5toKvkNnzgX+8ag8gksRAdts+/OyeFOWjCAfKQJ4bN14Amx
PfGo8uldOmJM4ManNnGzs+Mk8IrXp3nIsj+FmRnHKOOs2KE9byL2rF3ebYC8vNqG
705Ibnn6A/9kaz5Qd46nnA0EThnoCXCeShNkU56A4Yv5T87Xt/SGm65vxjotxlx4
+ewbK8LJOPbMaN4xRcDGgpYELtOd42cCLU4V1qSRWWPAt1tHw3QTcaQOkEvbqoNQ
31ADXeDoaoOTP1mvbLaw0uMWZAFGHRQDTcGCMJN1nopkHI3QrjQPdQ==
=FY/b
-----END PGP PUBLIC KEY BLOCK-----
"""

example_key_with_revoked_subkey = """
-----BEGIN PGP PUBLIC KEY BLOCK-----
Version: GnuPG v2

mI0EVblb1AEEAMLAK6bung86DQEkvFkDblpRBEkrUufDf354BcMserty088JIFI2
3j+YP8EDaf8gJnKAbHnYQP640f+I7+9Ul65PUtuuHXRkDMps7GYaJGlhPx26xGnx
/JL+ItgtYM/cLLmKSg0h/aVdYfW7Pc13PFSyXR0lkawleC926ifBUrqPABEBAAG0
B2V4YW1wbGWIuQQTAQIAIwUCVblb1AIbAwcLCQgHAwIBBhUIAgkKCwQWAgMBAh4B
AheAAAoJENBEjHHUvXzP124D/1p0MDoMJFiy7EiMEEkmZLY2qYFe7uAV7ZnhcKyr
WHKVSGOtS97ePMyckKPzVh31Itx5F65xydJm6xUdYCY0ySWvBvnWOzSZVRFSAONe
tpn9RG0009VL7SIAus6AbpE09Wu8Xp4Bo0mJZU5kU9ff1+x72PDQvbN7NpbCOtau
PCoFuI0EVblfXwEEAKx4dZbYXfoyJumCAW9YV+sEJFH0ylP9z3nNOojqHlEs3Tbk
R2UmI1triprzxPK+t8p008+ODSh9AXpgPRTDbJmmw/JgCNeLqVZ5NjMfV/DDfKYl
AtAnc4SZYtIgEgtaXOCj2eBmizJ17uQ6mIjxrhltr4uaW48K+3hlY8VP0n6bABEB
AAGIqgQoAQIAFAUCVblgWg0dAmZvciB0ZXN0aW5nAAoJENBEjHHUvXzP4T8D/1bZ
7cxJZBOhI5QrW4I9uMq7e+LHwE0DeixpJX46gNCFfxfnF5NxSFXfw5qjWFuQ9Vwt
pS9uQk6PNjRQSxHFWccFuhh/XY/h8kmDmSCJ9KtJZwOHOr+si1rJpI3OR2LcI88c
cKsf/e7C+0M6iYVteQX3GV+Z72NusHd5wizDqkbuiQFDBBgBAgAPAhsCBQJVuWAH
BQkAEnWoAKidIAQZAQIABgUCVblfXwAKCRDQ92kTekiF8q59BACixtqqEST8xS+D
G8fimLr3qaO0clXuNUJksGGI5MwfGF0uPnn8T9Usm5toKvkNnzgX+8ag8gksRAdt
s+/OyeFOWjCAfKQJ4bN14AmxPfGo8uldOmJM4ManNnGzs+Mk8IrXp3nIsj+FmRnH
KOOs2KE9byL2rF3ebYC8vNqG705IbgkQ0ESMcdS9fM+juwP/atlBwLYq1G+dMwn4
DbuDHTHHdZ8yoPQbdhuxPJ9Um9v41BoW3x6CQyzlwC3zD9NhoxbKpScGlYH8lYYA
yxzDFpNad+71DQjdMEve87SRrL2tEWuipFLxA3pHrb2bZm/aRsrwHqhvxPsPq8Xh
RXNGyTofkYFS+v+QmW6eDXIIjSA=
=rzxF
-----END PGP PUBLIC KEY BLOCK-----
"""

#=================================================================

# Check that merge_public_omitting_revokes() actually does omit revokes. That
# is, if the key manager we're merging in contains subkeys with a later
# expiration time, but which are revoked, the merge should skip them.
exports.check_merge_omits_revokes = (T, cb) ->
  await KeyManager.import_from_armored_pgp {
    armored: example_key_with_valid_subkey
    opts: { time_travel: true }
  }, T.esc defer valid_km
  await KeyManager.import_from_armored_pgp {
    armored: example_key_with_revoked_subkey
    opts: { time_travel: true }
  }, T.esc defer invalid_km
  valid_km.merge_public_omitting_revokes invalid_km
  # Make sure none of the resulting subkeys are revoked.
  for subkey in valid_km.subkeys
    T.assert not subkey._pgp.is_revoked(), "merged key contains revocations!"
  cb()

# As above, but backwards. That is, if we start with a revoked subkey, the
# merge should overwrite it with an unrevoked version of the same subkey *even*
# if the expiration date is earlier.
exports.check_merge_omits_revokes_in_reverse = (T, cb) ->
  await KeyManager.import_from_armored_pgp {
    armored: example_key_with_valid_subkey
    opts: { time_travel: true }
  }, T.esc defer valid_km
  await KeyManager.import_from_armored_pgp {
    armored: example_key_with_revoked_subkey
    opts: { time_travel: true }
  }, T.esc defer invalid_km
  invalid_km.merge_public_omitting_revokes valid_km
  # Make sure none of the resulting subkeys are revoked.
  for subkey in invalid_km.subkeys
    T.assert not subkey._pgp.is_revoked(), "merged key contains revocations!"
  cb()

#=================================================================

example_key_with_no_keybase_userid = """
-----BEGIN PGP PUBLIC KEY BLOCK-----
Version: GnuPG v2

mI0EVcyrgQEEALgC1r+atB1FIIr+QcfiMiK82bGhDvgpt4xcSsHPXpYQ5VXPKvTr
wTQDkcjY5oSQrDnBVdhQ8XaSW14VgbNI0Kk28feCA05NFxZ2NBfk5I/VKaN1poSe
H9klxpQWJ4cjrIbYTiUr3B+5ekBJ6Dmm2vSrEMoCbb6RiAmt0PKDP09LABEBAAG0
BXN0dWZmiLkEEwECACMFAlXMq4ECGy8HCwkIBwMCAQYVCAIJCgsEFgIDAQIeAQIX
gAAKCRBCRBfPcKQfMMmVA/4g3OerIGAgbmouwQ4t4OceLMlc0FTOWDg6q4rW9zpl
Ikzn89TXMLraQPCD2Q7dkpfJN1TZXV4nzg5NLPJ3YgUAkcKZNOID1ENkN9SXY07P
5Db6K/W+hlAAiV3mCC2f321r3UluTDvjBnlC7YwqZok8zfrVI4HOkSmSlhGnSgpu
ALiNBFXMq4EBBACnOWm8+42wZLFuE+cJ2Gx4YGa6qJGLjmeJ+9b0mZ3b+X9iwsEu
5VIKQfqM6AyFKR5covSx06+P7I0e7Mb3YCqJx+JHhUxQkHALfwC6T0Ur1QHlJn6K
3uYah/GlQo3aS3pT4wCvlUY3+Kl+hfd9TdF2QDapSIroBIWabOBFKITa0wARAQAB
iQE9BBgBAgAJBQJVzKuBAhsuAKgJEEJEF89wpB8wnSAEGQECAAYFAlXMq4EACgkQ
1P64eVB8Mu3dggP9GiuVE9ePrrkOSANRjGtJV/sV2IMjM6Mh0ojC4rrq9vv1cRcP
1f3a9Ww6Gq9KyMNfrwDlGu3FK9JLiAbHP8vUlBE5x1I50/TUZoRIvdhdVgwaor7T
XhIk6yASzWEtYf/J/caTzZ8s080zGQV8CWqO8cfIMSfWdAS5rTdh74IfjYUnZAP/
Y5Ui634XRjhO48oknWe2xjLSAYQQC4EbWXS2XoZqEn30vOvckYnHI3rYHX0mSsss
dElxcMo/aDDKEG0XCOZViiVZkZRI8u8v2l8fKBE2uySl3J5QccbOONaDs9l9wG/7
aTaEo/+ooy0PrtW3qSuCcDAA/JtxqSzNYO2RAW4xp8U=
=02B3
-----END PGP PUBLIC KEY BLOCK-----
"""

example_key_with_keybase_userid_added = """
-----BEGIN PGP PUBLIC KEY BLOCK-----
Version: GnuPG v2

mI0EVcyrgQEEALgC1r+atB1FIIr+QcfiMiK82bGhDvgpt4xcSsHPXpYQ5VXPKvTr
wTQDkcjY5oSQrDnBVdhQ8XaSW14VgbNI0Kk28feCA05NFxZ2NBfk5I/VKaN1poSe
H9klxpQWJ4cjrIbYTiUr3B+5ekBJ6Dmm2vSrEMoCbb6RiAmt0PKDP09LABEBAAG0
BXN0dWZmiLkEEwECACMFAlXMq4ECGy8HCwkIBwMCAQYVCAIJCgsEFgIDAQIeAQIX
gAAKCRBCRBfPcKQfMMmVA/4g3OerIGAgbmouwQ4t4OceLMlc0FTOWDg6q4rW9zpl
Ikzn89TXMLraQPCD2Q7dkpfJN1TZXV4nzg5NLPJ3YgUAkcKZNOID1ENkN9SXY07P
5Db6K/W+hlAAiV3mCC2f321r3UluTDvjBnlC7YwqZok8zfrVI4HOkSmSlhGnSgpu
ALQfa2V5YmFzZS5pby9nMTEgPGcxMUBrZXliYXNlLmlvPoi0BBMBCgAeBQJVzKuB
AhsvAwsJBwMVCggCHgECF4ADFgIBAhkBAAoJEEJEF89wpB8wBkQEAJuZssO9yssS
+P0EDo6Ey30uWoJ2JbwctoTjlyZ3XCZKwUqAsRMsb124kkgUjJTEg7PzUGdGGaIZ
xl04TxGNYjJsYU5y/1dZswc86nPMnePK61pycJ2vIRYsX7dRN5Lx/VJ9+wHD8vRR
Uz/Q2FsOwxcLebEcgZcPrY1RJ/9gVoTSuI0EVcyrgQEEAKc5abz7jbBksW4T5wnY
bHhgZrqokYuOZ4n71vSZndv5f2LCwS7lUgpB+ozoDIUpHlyi9LHTr4/sjR7sxvdg
KonH4keFTFCQcAt/ALpPRSvVAeUmfore5hqH8aVCjdpLelPjAK+VRjf4qX6F931N
0XZANqlIiugEhZps4EUohNrTABEBAAGJAT0EGAECAAkFAlXMq4ECGy4AqAkQQkQX
z3CkHzCdIAQZAQIABgUCVcyrgQAKCRDU/rh5UHwy7d2CA/0aK5UT14+uuQ5IA1GM
a0lX+xXYgyMzoyHSiMLiuur2+/VxFw/V/dr1bDoar0rIw1+vAOUa7cUr0kuIBsc/
y9SUETnHUjnT9NRmhEi92F1WDBqivtNeEiTrIBLNYS1h/8n9xpPNnyzTzTMZBXwJ
ao7xx8gxJ9Z0BLmtN2Hvgh+NhSdkA/9jlSLrfhdGOE7jyiSdZ7bGMtIBhBALgRtZ
dLZehmoSffS869yRiccjetgdfSZKyyx0SXFwyj9oMMoQbRcI5lWKJVmRlEjy7y/a
Xx8oETa7JKXcnlBxxs441oOz2X3Ab/tpNoSj/6ijLQ+u1bepK4JwMAD8m3GpLM1g
7ZEBbjGnxQ==
=wrn9
-----END PGP PUBLIC KEY BLOCK-----
"""

#=================================================================

exports.check_merge_everything_includes_userids = (T, cb) ->
  await KeyManager.import_from_armored_pgp {
    armored: example_key_with_no_keybase_userid
    opts: { time_travel: true }
  }, T.esc defer nonkeybase_km
  T.assert(
    nonkeybase_km.get_userids_mark_primary().length == 1,
    "The first key should have one userid.")

  await KeyManager.import_from_armored_pgp {
    armored: example_key_with_keybase_userid_added
    opts: { time_travel: true }
  }, T.esc defer with_keybase_km
  T.assert(
    with_keybase_km.get_userids_mark_primary().length == 2,
    "The second key should have two userids.")

  # Merging the second key with the first should bring in the second userid.
  nonkeybase_km.merge_everything with_keybase_km
  T.assert(
    nonkeybase_km.get_userids_mark_primary().length == 2,
    "The merged key should also have two userids.")
  cb()
