# Regression tests for p3skb bundles

{KeyManager} = require '../..'

exports.import_and_unlock_expired = (T, cb) ->
  await KeyManager.import_from_p3skb { raw: expired_key_bundle }, defer err, sk
  T.assert err?
  T.equal err.message, "no valid primary key self-signature or key(s) have expired"

  cb()

exports.import_and_unlock_expired_no_check_keys = (T, cb) ->
  await KeyManager.import_from_p3skb { raw: expired_key_bundle, no_check_keys: true, time_travel: true }, T.esc(defer(sk), cb)
  await sk.unlock_p3skb { passphrase: 'okokok', no_check_keys: true, time_travel: true }, T.esc(defer(), cb)
  userids = sk.get_userids()

  T.equal userids.length, 1, "expected one userid"
  T.equal userids[0].get_email(), "zapu@keybase.io", "correct userid"

  T.assert sk.get_primary_keypair().priv?

  key_hexs = sk.get_all_pgp_key_ids().map((x) -> x.toString('hex'))
  T.assert key_hexs.indexOf('a0fb0a54643fd1b9') isnt -1
  T.assert key_hexs.indexOf('4f2fd56265d00fff') isnt -1

  cb()

expired_key_bundle = """hKRib2R5gqRwcml2g6RkYXRhxQp0HJTX3gAAAAMihVoaOL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""".replace('\n', '')
