---
title: 颜色
toc: true
---
 
# 颜色

> Layui 试图在清新与深沉之间寻求某种柔和，以不过分刺激大脑皮层的神经介质，反馈出经久耐看的微妙视图。您可以在我们精心调配的如下色系中合理搭配，减少不必要的违和感，从而使您的 Web 页面看上去尽可能融洽。

<h2 id="primary" lay-toc="">基色调</h2>

<div class="layui-row layui-col-space15 ws-docs-color">
  <div class="layui-col-sm4">
    <div class="layui-bg-green">
      <p>#16baaa</p>
      <p>蓝绿色</p>
    </div>
  </div>
  <div class="layui-col-sm4">
    <div style="background-color: #16b777;">
      <p>#16b777</p>
      <p>清新绿</p>
    </div>
  </div>
  <div class="layui-col-sm4">
    <div class="layui-bg-blue">
      <p>#1e9fff<p>
      <p>经典蓝</p>
    </div>
  </div>
</div>

Layui 选取以象征清新与包容的「蓝绿色」作为主色调，它介于蓝与绿之间，亦可称之为「青色」，所谓青者，取之于蓝而深于绿，此间包罗万象，跨越时空。这也是我们对技术创作与人生哲学之间的一点思考。


<h2 id="secondary" lay-toc="">辅色调</h2>

<div class="layui-row layui-col-space15 ws-docs-color">
  <div class="layui-col-sm3">
    <div class="layui-bg-red">
      <p>#ff5722<p>
      <p>错误 - Danger</p>
    </div>
  </div>
  <div class="layui-col-sm3">
    <div class="layui-bg-orange">
      <p>#ffb800</p>
      <p>警示 - Warning</p>
    </div>
  </div>
  
  <div class="layui-col-sm3">
    <div style="background-color: #16b777;">
      <p>#16b777</p>
      <p>成功 - Success</p>
    </div>
  </div>
  <div class="layui-col-sm3">
    <div style="background-color: #31bdec;">
      <p>#31bdec</p>
      <p>引导 - Info</p>
    </div>
  </div>
</div>

页面中同样也少不了辅助色彩的点缀，以对不同含义的内容加以区分。Layui 从暖色系（红/橙）和冷色系（绿/蓝）中，各自调取了我们认为最具代表性的颜色值，它们通常在不同的场景中发挥着不同的作用。

<h2 id="neutral" lay-toc="">中色调</h2>

<div class="layui-row ws-docs-color ws-docs-necolor">
  <div class="layui-col-md6">
    <div style="background-color: #FAFAFA;">
      <p>#fafafa<p>
    </div>
  </div>
  <div class="layui-col-md6">
    <div style="background-color: #f6f6f6;"><p>#f7f7f7</p></div>
  </div>
  <div class="layui-col-md2">
    <div style="background-color: #eeeeee;"><p>#eeeeee</p></div>
  </div>
  <div class="layui-col-md2">
    <div style="background-color: #e2e2e2;"><p>#e2e2e2</p></div>
  </div>
  <div class="layui-col-md2">
    <div style="background-color: #dddddd;"><p>#dddddd</p></div>
  </div>
  <div class="layui-col-md2">
    <div style="background-color: #d2d2d2;"><p>#d2d2d2</p></div>
  </div>
  <div class="layui-col-md2">
    <div style="background-color: #cccccc;"><p>#cccccc</p></div>
  </div>
  <div class="layui-col-md2">
    <div style="background-color: #c2c2c2;"><p>#c2c2c2</p></div>
  </div>
  <div class="layui-col-md6">
    <div class="layui-bg-black"><p>#2f363c</p></div>
  </div>
  <div class="layui-col-md6">
    <div style="background-color: #23292e; color: #fff;"><p>#23292e</p></div>
  </div>
</div>

中性的颜色是页面中的重要组成部分，也被称之为无彩色系，一般用于文本、背景和边框等。它能对由彩色进行视觉冲淡，以达到和谐自然的效果。Layui 认为恰当的灰度调配代表着极简，这是一种神奇的色系，是视觉疲劳的栖息，低调而优雅，且永不过时。

<h2 id="seven" lay-toc="">七色调</h2>

<div class="layui-row ws-docs-color ws-docs-bgcolor">
  <div class="layui-bg-red">
    #ff5722 - 红
  </div>
  <div class="layui-bg-orange">
    #ffb800 - 橙
  </div>
  <div class="layui-bg-green">
    #16baaa - 绿
  </div>
  <div class="layui-bg-blue">
    #1e9fff - 蓝
  </div>
  <div class="layui-bg-purple">
    #a233c6 - 紫
  </div>
  <div class="layui-bg-black">
    #2f363c - 深
  </div>
  <div class="layui-bg-gray">
    #fafafa - 浅
  </div>
</div>

Layui 的色调基础，除了前面提到的主辅中色之外，还建立在以上罗列的七种颜色之上。你同样也可以遵循我们提供的色调方案去扩展你的页面元素，使得能与 Layui 的主题风格无缝融合。

<br>

## 标语

> 不热衷于视觉设计的开发者不是一个好作家。 —— 贤心