---
title: 图标
toc: true
---
 
# 图标

> Layui 图标采用字体形式，取材于阿里巴巴矢量图标库 `iconfont`，因此可以把一个 `icon` 看作是一个普通的文本，直接通过 `css` 即可设定其样式。图标支持 `font-class` 或 `unicode` 两种格式。

<h2 id="examples" lay-toc="">示例</h2>

<pre class="layui-code" lay-options="{preview: true}">
  <textarea>
<i class="layui-icon layui-icon-face-smile"></i> 
<div>
  你可以去定义它的颜色或者大小，如：  
  <i class="layui-icon layui-icon-face-smile" style="font-size: 30px; color: #1E9FFF;"></i> 
</div>
  </textarea>
</pre>

通过对一个内联元素（如 `<i>`标签）添加基础类 `class="layui-icon"` 来定义一个图标，然后对元素加上图标对应的 `font-class`，即可显示出你想要的图标，如上所示。


<h2 id="list" lay-toc="{hot: true, title: '图标列表'}">图标列表（186 个）</h2>

<div class="ws-docs-icon">
  <div>
    <i class="layui-icon layui-icon-github"></i>
    <div class="docs-icon-name">Github</div>
    <div class="docs-icon-code">&amp;#xe6a7;</div>
    <div class="docs-icon-fontclass">layui-icon-github</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-moon"></i>
    <div class="docs-icon-name">月亮</div>
    <div class="docs-icon-code">&amp;#xe6c2;</div>
    <div class="docs-icon-fontclass">layui-icon-moon</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-error"></i>
    <div class="docs-icon-name">错误</div>
    <div class="docs-icon-code">&amp;#xe693;</div>
    <div class="docs-icon-fontclass">layui-icon-error</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-success"></i>
    <div class="docs-icon-name">成功</div>
    <div class="docs-icon-code">&amp;#xe697;</div>
    <div class="docs-icon-fontclass">layui-icon-success</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-question"></i>
    <div class="docs-icon-name">问号</div>
    <div class="docs-icon-code">&amp;#xe699;</div>
    <div class="docs-icon-fontclass">layui-icon-question</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-lock"></i>
    <div class="docs-icon-name">锁定</div>
    <div class="docs-icon-code">&amp;#xe69a;</div>
    <div class="docs-icon-fontclass">layui-icon-lock</div>
  </div>

  <div>
    <i class="layui-icon layui-icon-eye"></i>
    <div class="docs-icon-name">显示</div>
    <div class="docs-icon-code">&amp;#xe695;</div>
    <div class="docs-icon-fontclass">layui-icon-eye</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-eye-invisible"></i>
    <div class="docs-icon-name">隐藏</div>
    <div class="docs-icon-code">&amp;#xe696;</div>
    <div class="docs-icon-fontclass">layui-icon-eye-invisible</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-clear"></i>
    <div class="docs-icon-name">清空/删除</div>
    <div class="docs-icon-code">&amp;#xe788;</div>
    <div class="docs-icon-fontclass">layui-icon-clear</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-backspace"></i>
    <div class="docs-icon-name">退格</div>
    <div class="docs-icon-code">&amp;#xe694;</div>
    <div class="docs-icon-fontclass">layui-icon-backspace</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-disabled"></i>
    <div class="docs-icon-name">禁用</div>
    <div class="docs-icon-code">&amp;#xe6cc;</div>
    <div class="docs-icon-fontclass">layui-icon-disabled</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-tips-fill"></i>
    <div class="docs-icon-name">感叹号/提示</div>
    <div class="docs-icon-code">&amp;#xeb2e;</div>
    <div class="docs-icon-fontclass">layui-icon-tips-fill</div>
  </div>

  <div>
    <i class="layui-icon layui-icon-test"></i>
    <div class="docs-icon-name">测试/K线图</div>
    <div class="docs-icon-code">&amp;#xe692;</div>
    <div class="docs-icon-fontclass">layui-icon-test</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-music"></i>
    <div class="docs-icon-name">音乐/音符</div>
    <div class="docs-icon-code">&amp;#xe690;</div>
    <div class="docs-icon-fontclass">layui-icon-music</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-chrome"></i>
    <div class="docs-icon-name">Chrome</div>
    <div class="docs-icon-code">&amp;#xe68a;</div>
    <div class="docs-icon-fontclass">layui-icon-chrome</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-firefox"></i>
    <div class="docs-icon-name">Firefox</div>
    <div class="docs-icon-code">&amp;#xe686;</div>
    <div class="docs-icon-fontclass">layui-icon-firefox</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-edge"></i>
    <div class="docs-icon-name">Edge</div>
    <div class="docs-icon-code">&amp;#xe68b;</div>
    <div class="docs-icon-fontclass">layui-icon-edge</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-ie"></i>
    <div class="docs-icon-name">IE</div>
    <div class="docs-icon-code">&amp;#xe7bb;</div>
    <div class="docs-icon-fontclass">layui-icon-ie</div>
  </div>

  <div>
    <i class="layui-icon layui-icon-heart-fill"></i>
    <div class="docs-icon-name">实心</div>
    <div class="docs-icon-code">&amp;#xe68f;</div>
    <div class="docs-icon-fontclass">layui-icon-heart-fill</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-heart"></i>
    <div class="docs-icon-name">空心</div>
    <div class="docs-icon-code">&amp;#xe68c;</div>
    <div class="docs-icon-fontclass">layui-icon-heart</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-light"></i>
    <div class="docs-icon-name">太阳/明亮</div>
    <div class="docs-icon-code">&amp;#xe748;</div>
    <div class="docs-icon-fontclass">layui-icon-light</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-time"></i>
    <div class="docs-icon-name">时间/历史</div>
    <div class="docs-icon-code">&amp;#xe68d;</div>
    <div class="docs-icon-fontclass">layui-icon-time</div>
  </div>
  
  <div>
    <i class="layui-icon layui-icon-bluetooth"></i>
    <div class="docs-icon-name">蓝牙</div>
    <div class="docs-icon-code">&amp;#xe689;</div>
    <div class="docs-icon-fontclass">layui-icon-bluetooth</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-at"></i>
    <div class="docs-icon-name">@艾特</div>
    <div class="docs-icon-code">&amp;#xe687;</div>
    <div class="docs-icon-fontclass">layui-icon-at</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-mute"></i>
    <div class="docs-icon-name">静音</div>
    <div class="docs-icon-code">&amp;#xe685;</div>
    <div class="docs-icon-fontclass">layui-icon-mute</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-mike"></i>
    <div class="docs-icon-name">录音/麦克风</div>
    <div class="docs-icon-code">&amp;#xe6dc;</div>
    <div class="docs-icon-fontclass">layui-icon-mike</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-key"></i>
    <div class="docs-icon-name">密钥/钥匙</div>
    <div class="docs-icon-code">&amp;#xe683;</div>
    <div class="docs-icon-fontclass">layui-icon-key</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-gift"></i>
    <div class="docs-icon-name">礼物/活动</div>
    <div class="docs-icon-code">&amp;#xe627;</div>
    <div class="docs-icon-fontclass">layui-icon-gift</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-email"></i>
    <div class="docs-icon-name">邮箱</div>
    <div class="docs-icon-code">&amp;#xe618;</div>
    <div class="docs-icon-fontclass">layui-icon-email</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-rss"></i>
    <div class="docs-icon-name">RSS</div>
    <div class="docs-icon-code">&amp;#xe808;</div>
    <div class="docs-icon-fontclass">layui-icon-rss</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-wifi"></i>
    <div class="docs-icon-name">WiFi</div>
    <div class="docs-icon-code">&amp;#xe7e0;</div>
    <div class="docs-icon-fontclass">layui-icon-wifi</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-logout"></i>
    <div class="docs-icon-name">退出/注销</div>
    <div class="docs-icon-code">&amp;#xe682;</div>
    <div class="docs-icon-fontclass">layui-icon-logout</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-android"></i>
    <div class="docs-icon-name">Android 安卓</div>
    <div class="docs-icon-code">&amp;#xe684;</div>
    <div class="docs-icon-fontclass">layui-icon-android</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-ios"></i>
    <div class="docs-icon-name">Apple IOS 苹果</div>
    <div class="docs-icon-code">&amp;#xe680;</div>
    <div class="docs-icon-fontclass">layui-icon-ios</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-windows"></i>
    <div class="docs-icon-name">Windows</div>
    <div class="docs-icon-code">&amp;#xe67f;</div>
    <div class="docs-icon-fontclass">layui-icon-windows</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-transfer"></i>
    <div class="docs-icon-name">穿梭框</div>
    <div class="docs-icon-code">&amp;#xe691;</div>
    <div class="docs-icon-fontclass">layui-icon-transfer</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-service"></i>
    <div class="docs-icon-name">客服</div>
    <div class="docs-icon-code">&amp;#xe626;</div>
    <div class="docs-icon-fontclass">layui-icon-service</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-subtraction"></i>
    <div class="docs-icon-name">减</div>
    <div class="docs-icon-code">&amp;#xe67e;</div>
    <div class="docs-icon-fontclass">layui-icon-subtraction</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-addition"></i>
    <div class="docs-icon-name">加</div>
    <div class="docs-icon-code">&amp;#xe624;</div>
    <div class="docs-icon-fontclass">layui-icon-addition</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-slider"></i>
    <div class="docs-icon-name">滑块</div>
    <div class="docs-icon-code">&amp;#xe714;</div>
    <div class="docs-icon-fontclass">layui-icon-slider</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-print"></i>
    <div class="docs-icon-name">打印</div>
    <div class="docs-icon-code">&amp;#xe66d;</div>
    <div class="docs-icon-fontclass">layui-icon-print</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-export"></i>
    <div class="docs-icon-name">导出</div>
    <div class="docs-icon-code">&amp;#xe67d;</div>
    <div class="docs-icon-fontclass">layui-icon-export</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-cols"></i>
    <div class="docs-icon-name">列</div>
    <div class="docs-icon-code">&amp;#xe610;</div>
    <div class="docs-icon-fontclass">layui-icon-cols</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-screen-restore"></i>
    <div class="docs-icon-name">退出全屏</div>
    <div class="docs-icon-code">&amp;#xe758;</div>
    <div class="docs-icon-fontclass">layui-icon-screen-restore</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-screen-full"></i>
    <div class="docs-icon-name">全屏</div>
    <div class="docs-icon-code">&amp;#xe622;</div>
    <div class="docs-icon-fontclass">layui-icon-screen-full</div>
  </div>

  <div>
    <i class="layui-icon layui-icon-rate-half"></i>
    <div class="docs-icon-name">半星</div>
    <div class="docs-icon-code">&amp;#xe6c9;</div>
    <div class="docs-icon-fontclass">layui-icon-rate-half</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-rate"></i>
    <div class="docs-icon-name">星星-空心</div>
    <div class="docs-icon-code">&amp;#xe67b;</div>
    <div class="docs-icon-fontclass">layui-icon-rate</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-rate-solid"></i>
    <div class="docs-icon-name">星星-实心</div>
    <div class="docs-icon-code">&amp;#xe67a;</div>
    <div class="docs-icon-fontclass">layui-icon-rate-solid</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-cellphone"></i>
    <div class="docs-icon-name">手机</div>
    <div class="docs-icon-code">&amp;#xe678;</div>
    <div class="docs-icon-fontclass">layui-icon-cellphone</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-vercode"></i>
    <div class="docs-icon-name">验证码</div>
    <div class="docs-icon-code">&amp;#xe679;</div>
    <div class="docs-icon-fontclass">layui-icon-vercode</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-login-wechat"></i>
    <div class="docs-icon-name">微信</div>
    <div class="docs-icon-code">&amp;#xe677;</div>
    <div class="docs-icon-fontclass">layui-icon-login-wechat</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-login-qq"></i>
    <div class="docs-icon-name">QQ</div>
    <div class="docs-icon-code">&amp;#xe676;</div>
    <div class="docs-icon-fontclass">layui-icon-login-qq</div>
  </div>
  
  <div>
    <i class="layui-icon layui-icon-login-weibo"></i>
    <div class="docs-icon-name">微博</div>
    <div class="docs-icon-code">&amp;#xe675;</div>
    <div class="docs-icon-fontclass">layui-icon-login-weibo</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-password"></i>
    <div class="docs-icon-name">密码</div>
    <div class="docs-icon-code">&amp;#xe673;</div>
    <div class="docs-icon-fontclass">layui-icon-password</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-username"></i>
    <div class="docs-icon-name">用户名</div>
    <div class="docs-icon-code">&amp;#xe66f;</div>
    <div class="docs-icon-fontclass">layui-icon-username</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-refresh-3"></i>
    <div class="docs-icon-name">刷新-粗</div>
    <div class="docs-icon-code">&amp;#xe9aa;</div>
    <div class="docs-icon-fontclass">layui-icon-refresh-3</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-auz"></i>
    <div class="docs-icon-name">授权</div>
    <div class="docs-icon-code">&amp;#xe672;</div>
    <div class="docs-icon-fontclass">layui-icon-auz</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-spread-left"></i>
    <div class="docs-icon-name">左向右伸缩菜单</div>
    <div class="docs-icon-code">&amp;#xe66b;</div>
    <div class="docs-icon-fontclass">layui-icon-spread-left</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-shrink-right"></i>
    <div class="docs-icon-name">右向左伸缩菜单</div>
    <div class="docs-icon-code">&amp;#xe668;</div>
    <div class="docs-icon-fontclass">layui-icon-shrink-right</div>
  </div>
  
  <div>
    <i class="layui-icon layui-icon-snowflake"></i>
    <div class="docs-icon-name">雪花</div>
    <div class="docs-icon-code">&amp;#xe6b1;</div>
    <div class="docs-icon-fontclass">layui-icon-snowflake</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-tips"></i>
    <div class="docs-icon-name">提示说明</div>
    <div class="docs-icon-code">&amp;#xe702;</div>
    <div class="docs-icon-fontclass">layui-icon-tips</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-note"></i>
    <div class="docs-icon-name">便签</div>
    <div class="docs-icon-code">&amp;#xe66e;</div>
    <div class="docs-icon-fontclass">layui-icon-note</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-home"></i>
    <div class="docs-icon-name">主页</div>
    <div class="docs-icon-code">&amp;#xe68e;</div>
    <div class="docs-icon-fontclass">layui-icon-home</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-senior"></i>
    <div class="docs-icon-name">高级</div>
    <div class="docs-icon-code">&amp;#xe674;</div>
    <div class="docs-icon-fontclass">layui-icon-senior</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-refresh"></i>
    <div class="docs-icon-name">刷新</div>
    <div class="docs-icon-code">&amp;#xe669;</div>
    <div class="docs-icon-fontclass">layui-icon-refresh</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-refresh-1"></i>
    <div class="docs-icon-name">刷新</div>
    <div class="docs-icon-code">&amp;#xe666;</div>
    <div class="docs-icon-fontclass">layui-icon-refresh-1</div>
  </div>
  
  <div>
    <i class="layui-icon layui-icon-flag"></i>
    <div class="docs-icon-name">旗帜</div>
    <div class="docs-icon-code">&amp;#xe66c;</div>
    <div class="docs-icon-fontclass">layui-icon-flag</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-theme"></i>
    <div class="docs-icon-name">主题</div>
    <div class="docs-icon-code">&amp;#xe66a;</div>
    <div class="docs-icon-fontclass">layui-icon-theme</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-notice"></i>
    <div class="docs-icon-name">消息-通知</div>
    <div class="docs-icon-code">&amp;#xe667;</div>
    <div class="docs-icon-fontclass">layui-icon-notice</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-website"></i>
    <div class="docs-icon-name">网站</div>
    <div class="docs-icon-code">&amp;#xe7ae;</div>
    <div class="docs-icon-fontclass">layui-icon-website</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-console"></i>
    <div class="docs-icon-name">控制台</div>
    <div class="docs-icon-code">&amp;#xe665;</div>
    <div class="docs-icon-fontclass">layui-icon-console</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-face-surprised"></i>
    <div class="docs-icon-name">表情-惊讶</div>
    <div class="docs-icon-code">&amp;#xe664;</div>
    <div class="docs-icon-fontclass">layui-icon-face-surprised</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-set"></i>
    <div class="docs-icon-name">设置-空心</div>
    <div class="docs-icon-code">&amp;#xe716;</div>
    <div class="docs-icon-fontclass">layui-icon-set</div>
  </div>
  
  <div>
    <i class="layui-icon layui-icon-template-1"></i>
    <div class="docs-icon-name">模板</div>
    <div class="docs-icon-code">&amp;#xe656;</div>
    <div class="docs-icon-fontclass">layui-icon-template-1</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-app"></i>
    <div class="docs-icon-name">应用</div>
    <div class="docs-icon-code">&amp;#xe653;</div>
    <div class="docs-icon-fontclass">layui-icon-app</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-template"></i>
    <div class="docs-icon-name">模板</div>
    <div class="docs-icon-code">&amp;#xe663;</div>
    <div class="docs-icon-fontclass">layui-icon-template</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-praise"></i>
    <div class="docs-icon-name">赞</div>
    <div class="docs-icon-code">&amp;#xe6c6;</div>
    <div class="docs-icon-fontclass">layui-icon-praise</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-tread"></i>
    <div class="docs-icon-name">踩</div>
    <div class="docs-icon-code">&amp;#xe6c5;</div>
    <div class="docs-icon-fontclass">layui-icon-tread</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-male"></i>
    <div class="docs-icon-name">男</div>
    <div class="docs-icon-code">&amp;#xe662;</div>
    <div class="docs-icon-fontclass">layui-icon-male</div>
  </div>
  
  <div>
    <i class="layui-icon layui-icon-female"></i>
    <div class="docs-icon-name">女</div>
    <div class="docs-icon-code">&amp;#xe661;</div>
    <div class="docs-icon-fontclass">layui-icon-female</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-camera"></i>
    <div class="docs-icon-name">相机-空心</div>
    <div class="docs-icon-code">&amp;#xe660;</div>
    <div class="docs-icon-fontclass">layui-icon-camera</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-camera-fill"></i>
    <div class="docs-icon-name">相机-实心</div>
    <div class="docs-icon-code">&amp;#xe65d;</div>
    <div class="docs-icon-fontclass">layui-icon-camera-fill</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-more"></i>
    <div class="docs-icon-name">菜单-水平</div>
    <div class="docs-icon-code">&amp;#xe65f;</div>
    <div class="docs-icon-fontclass">layui-icon-more</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-more-vertical"></i>
    <div class="docs-icon-name">菜单-垂直</div>
    <div class="docs-icon-code">&amp;#xe671;</div>
    <div class="docs-icon-fontclass">layui-icon-more-vertical</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-rmb"></i>
    <div class="docs-icon-name">金额-人民币</div>
    <div class="docs-icon-code">&amp;#xe65e;</div>
    <div class="docs-icon-fontclass">layui-icon-rmb</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-dollar"></i>
    <div class="docs-icon-name">金额-美元</div>
    <div class="docs-icon-code">&amp;#xe659;</div>
    <div class="docs-icon-fontclass">layui-icon-dollar</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-diamond"></i>
    <div class="docs-icon-name">钻石-等级</div>
    <div class="docs-icon-code">&amp;#xe735;</div>
    <div class="docs-icon-fontclass">layui-icon-diamond</div>
  </div>
  
  <div>
    <i class="layui-icon layui-icon-fire"></i>
    <div class="docs-icon-name">火</div>
    <div class="docs-icon-code">&amp;#xe756;</div>
    <div class="docs-icon-fontclass">layui-icon-fire</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-return"></i>
    <div class="docs-icon-name">返回</div>
    <div class="docs-icon-code">&amp;#xe65c;</div>
    <div class="docs-icon-fontclass">layui-icon-return</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-location"></i>
    <div class="docs-icon-name">位置-地图</div>
    <div class="docs-icon-code">&amp;#xe715;</div>
    <div class="docs-icon-fontclass">layui-icon-location</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-read"></i>
    <div class="docs-icon-name">办公-阅读</div>
    <div class="docs-icon-code">&amp;#xe705;</div>
    <div class="docs-icon-fontclass">layui-icon-read</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-survey"></i>
    <div class="docs-icon-name">调查</div>
    <div class="docs-icon-code">&amp;#xe6b2;</div>
    <div class="docs-icon-fontclass">layui-icon-survey</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-face-smile"></i>
    <div class="docs-icon-name">表情-微笑</div>
    <div class="docs-icon-code">&amp;#xe6af;</div>
    <div class="docs-icon-fontclass">layui-icon-face-smile</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-face-cry"></i>
    <div class="docs-icon-name">表情-哭泣</div>
    <div class="docs-icon-code">&amp;#xe69c;</div>
    <div class="docs-icon-fontclass">layui-icon-face-cry</div>
  </div>
  
  <div>
    <i class="layui-icon layui-icon-cart-simple"></i>
    <div class="docs-icon-name">购物车</div>
    <div class="docs-icon-code">&amp;#xe698;</div>
    <div class="docs-icon-fontclass">layui-icon-cart-simple</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-cart"></i>
    <div class="docs-icon-name">购物车</div>
    <div class="docs-icon-code">&amp;#xe657;</div>
    <div class="docs-icon-fontclass">layui-icon-cart</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-next"></i>
    <div class="docs-icon-name">下一页</div>
    <div class="docs-icon-code">&amp;#xe65b;</div>
    <div class="docs-icon-fontclass">layui-icon-next</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-prev"></i>
    <div class="docs-icon-name">上一页</div>
    <div class="docs-icon-code">&amp;#xe65a;</div>
    <div class="docs-icon-fontclass">layui-icon-prev</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-upload-drag"></i>
    <div class="docs-icon-name">上传-空心-拖拽</div>
    <div class="docs-icon-code">&amp;#xe681;</div>
    <div class="docs-icon-fontclass">layui-icon-upload-drag</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-upload"></i>
    <div class="docs-icon-name">上传-实心</div>
    <div class="docs-icon-code">&amp;#xe67c;</div>
    <div class="docs-icon-fontclass">layui-icon-upload</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-download-circle"></i>
    <div class="docs-icon-name">下载-圆圈</div>
    <div class="docs-icon-code">&amp;#xe601;</div>
    <div class="docs-icon-fontclass">layui-icon-download-circle</div>
  </div>
  
  <div>
    <i class="layui-icon layui-icon-component"></i>
    <div class="docs-icon-name">组件</div>
    <div class="docs-icon-code">&amp;#xe857;</div>
    <div class="docs-icon-fontclass">layui-icon-component</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-file-b"></i>
    <div class="docs-icon-name">文件-粗</div>
    <div class="docs-icon-code">&amp;#xe655;</div>
    <div class="docs-icon-fontclass">layui-icon-file-b</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-user"></i>
    <div class="docs-icon-name">用户</div>
    <div class="docs-icon-code">&amp;#xe770;</div>
    <div class="docs-icon-fontclass">layui-icon-user</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-find-fill"></i>
    <div class="docs-icon-name">发现-实心</div>
    <div class="docs-icon-code">&amp;#xe670;</div>
    <div class="docs-icon-fontclass">layui-icon-find-fill</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-loading layui-anim layui-anim-rotate layui-anim-loop"></i>
    <div class="docs-icon-name">loading</div>
    <div class="docs-icon-code">&amp;#xe63d;</div>
    <div class="docs-icon-fontclass">layui-icon-loading</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-loading-1 layui-anim layui-anim-rotate layui-anim-loop"></i>
    <div class="docs-icon-name">loading</div>
    <div class="docs-icon-code">&amp;#xe63e;</div>
    <div class="docs-icon-fontclass">layui-icon-loading-1</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-add-1"></i>
    <div class="docs-icon-name">添加</div>
    <div class="docs-icon-code">&amp;#xe654;</div>
    <div class="docs-icon-fontclass">layui-icon-add-1</div>
  </div>
  
  <div>
    <i class="layui-icon layui-icon-play"></i>
    <div class="docs-icon-name">播放</div>
    <div class="docs-icon-code">&amp;#xe652;</div>
    <div class="docs-icon-fontclass">layui-icon-play</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-pause"></i>
    <div class="docs-icon-name">暂停</div>
    <div class="docs-icon-code">&amp;#xe651;</div>
    <div class="docs-icon-fontclass">layui-icon-pause</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-headset"></i>
    <div class="docs-icon-name">音频-耳机</div>
    <div class="docs-icon-code">&amp;#xe6fc;</div>
    <div class="docs-icon-fontclass">layui-icon-headset</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-video"></i>
    <div class="docs-icon-name">视频</div>
    <div class="docs-icon-code">&amp;#xe6ed;</div>
    <div class="docs-icon-fontclass">layui-icon-video</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-voice"></i>
    <div class="docs-icon-name">语音-声音</div>
    <div class="docs-icon-code">&amp;#xe688;</div>
    <div class="docs-icon-fontclass">layui-icon-voice</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-speaker"></i>
    <div class="docs-icon-name">消息-通知-喇叭</div>
    <div class="docs-icon-code">&amp;#xe645;</div>
    <div class="docs-icon-fontclass">layui-icon-speaker</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-fonts-del"></i>
    <div class="docs-icon-name">删除线</div>
    <div class="docs-icon-code">&amp;#xe64f;</div>
    <div class="docs-icon-fontclass">layui-icon-fonts-del</div>
  </div>
  
  <div>
    <i class="layui-icon layui-icon-fonts-code"></i>
    <div class="docs-icon-name">代码</div>
    <div class="docs-icon-code">&amp;#xe64e;</div>
    <div class="docs-icon-fontclass">layui-icon-fonts-code</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-fonts-html"></i>
    <div class="docs-icon-name">HTML</div>
    <div class="docs-icon-code">&amp;#xe64b;</div>
    <div class="docs-icon-fontclass">layui-icon-fonts-html</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-fonts-strong"></i>
    <div class="docs-icon-name">字体加粗</div>
    <div class="docs-icon-code">&amp;#xe62b;</div>
    <div class="docs-icon-fontclass">layui-icon-fonts-strong</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-unlink"></i>
    <div class="docs-icon-name">删除链接</div>
    <div class="docs-icon-code">&amp;#xe64d;</div>
    <div class="docs-icon-fontclass">layui-icon-unlink</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-picture"></i>
    <div class="docs-icon-name">图片</div>
    <div class="docs-icon-code">&amp;#xe64a;</div>
    <div class="docs-icon-fontclass">layui-icon-picture</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-link"></i>
    <div class="docs-icon-name">链接</div>
    <div class="docs-icon-code">&amp;#xe64c;</div>
    <div class="docs-icon-fontclass">layui-icon-link</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-face-smile-b"></i>
    <div class="docs-icon-name">表情-笑-粗</div>
    <div class="docs-icon-code">&amp;#xe650;</div>
    <div class="docs-icon-fontclass">layui-icon-face-smile-b</div>
  </div>
  
  <div>
    <i class="layui-icon layui-icon-align-left"></i>
    <div class="docs-icon-name">左对齐</div>
    <div class="docs-icon-code">&amp;#xe649;</div>
    <div class="docs-icon-fontclass">layui-icon-align-left</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-align-right"></i>
    <div class="docs-icon-name">右对齐</div>
    <div class="docs-icon-code">&amp;#xe648;</div>
    <div class="docs-icon-fontclass">layui-icon-align-right</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-align-center"></i>
    <div class="docs-icon-name">居中对齐</div>
    <div class="docs-icon-code">&amp;#xe647;</div>
    <div class="docs-icon-fontclass">layui-icon-align-center</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-fonts-u"></i>
    <div class="docs-icon-name">字体-下划线</div>
    <div class="docs-icon-code">&amp;#xe646;</div>
    <div class="docs-icon-fontclass">layui-icon-fonts-u</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-fonts-i"></i>
    <div class="docs-icon-name">字体-斜体</div>
    <div class="docs-icon-code">&amp;#xe644;</div>
    <div class="docs-icon-fontclass">layui-icon-fonts-i</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-tabs"></i>
    <div class="docs-icon-name">Tabs 选项卡</div>
    <div class="docs-icon-code">&amp;#xe62a;</div>
    <div class="docs-icon-fontclass">layui-icon-tabs</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-radio"></i>
    <div class="docs-icon-name">单选框-选中</div>
    <div class="docs-icon-code">&amp;#xe643;</div>
    <div class="docs-icon-fontclass">layui-icon-radio</div>
  </div>
  
  <div>
    <i class="layui-icon layui-icon-circle"></i>
    <div class="docs-icon-name">单选框-候选</div>
    <div class="docs-icon-code">&amp;#xe63f;</div>
    <div class="docs-icon-fontclass">layui-icon-circle</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-edit"></i>
    <div class="docs-icon-name">编辑</div>
    <div class="docs-icon-code">&amp;#xe642;</div>
    <div class="docs-icon-fontclass">layui-icon-edit</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-share"></i>
    <div class="docs-icon-name">分享</div>
    <div class="docs-icon-code">&amp;#xe641;</div>
    <div class="docs-icon-fontclass">layui-icon-share</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-delete"></i>
    <div class="docs-icon-name">删除</div>
    <div class="docs-icon-code">&amp;#xe640;</div>
    <div class="docs-icon-fontclass">layui-icon-delete</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-form"></i>
    <div class="docs-icon-name">表单</div>
    <div class="docs-icon-code">&amp;#xe63c;</div>
    <div class="docs-icon-fontclass">layui-icon-form</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-cellphone-fine"></i>
    <div class="docs-icon-name">手机-细体</div>
    <div class="docs-icon-code">&amp;#xe63b;</div>
    <div class="docs-icon-fontclass">layui-icon-cellphone-fine</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-dialogue"></i>
    <div class="docs-icon-name">聊天 对话 沟通</div>
    <div class="docs-icon-code">&amp;#xe63a;</div>
    <div class="docs-icon-fontclass">layui-icon-dialogue</div>
  </div>
  
  <div>
    <i class="layui-icon layui-icon-fonts-clear"></i>
    <div class="docs-icon-name">文字格式化</div>
    <div class="docs-icon-code">&amp;#xe639;</div>
    <div class="docs-icon-fontclass">layui-icon-fonts-clear</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-layer"></i>
    <div class="docs-icon-name">窗口</div>
    <div class="docs-icon-code">&amp;#xe638;</div>
    <div class="docs-icon-fontclass">layui-icon-layer</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-date"></i>
    <div class="docs-icon-name">日期</div>
    <div class="docs-icon-code">&amp;#xe637;</div>
    <div class="docs-icon-fontclass">layui-icon-date</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-water"></i>
    <div class="docs-icon-name">水 下雨</div>
    <div class="docs-icon-code">&amp;#xe636;</div>
    <div class="docs-icon-fontclass">layui-icon-water</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-code-circle"></i>
    <div class="docs-icon-name">代码-圆圈</div>
    <div class="docs-icon-code">&amp;#xe635;</div>
    <div class="docs-icon-fontclass">layui-icon-code-circle</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-carousel"></i>
    <div class="docs-icon-name">轮播组图</div>
    <div class="docs-icon-code">&amp;#xe634;</div>
    <div class="docs-icon-fontclass">layui-icon-carousel</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-prev-circle"></i>
    <div class="docs-icon-name">翻页</div>
    <div class="docs-icon-code">&amp;#xe633;</div>
    <div class="docs-icon-fontclass">layui-icon-prev-circle</div>
  </div>
  
  <div>
    <i class="layui-icon layui-icon-layouts"></i>
    <div class="docs-icon-name">布局</div>
    <div class="docs-icon-code">&amp;#xe632;</div>
    <div class="docs-icon-fontclass">layui-icon-layouts</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-util"></i>
    <div class="docs-icon-name">工具</div>
    <div class="docs-icon-code">&amp;#xe631;</div>
    <div class="docs-icon-fontclass">layui-icon-util</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-templeate-1"></i>
    <div class="docs-icon-name">选择模板</div>
    <div class="docs-icon-code">&amp;#xe630;</div>
    <div class="docs-icon-fontclass">layui-icon-templeate-1</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-upload-circle"></i>
    <div class="docs-icon-name">上传-圆圈</div>
    <div class="docs-icon-code">&amp;#xe62f;</div>
    <div class="docs-icon-fontclass">layui-icon-upload-circle</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-tree"></i>
    <div class="docs-icon-name">树</div>
    <div class="docs-icon-code">&amp;#xe62e;</div>
    <div class="docs-icon-fontclass">layui-icon-tree</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-table"></i>
    <div class="docs-icon-name">表格</div>
    <div class="docs-icon-code">&amp;#xe62d;</div>
    <div class="docs-icon-fontclass">layui-icon-table</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-chart"></i>
    <div class="docs-icon-name">图表</div>
    <div class="docs-icon-code">&amp;#xe62c;</div>
    <div class="docs-icon-fontclass">layui-icon-chart</div>
  </div>
  
  <div>
    <i class="layui-icon layui-icon-chart-screen"></i>
    <div class="docs-icon-name">图标 报表 屏幕</div>
    <div class="docs-icon-code">&amp;#xe629;</div>
    <div class="docs-icon-fontclass">layui-icon-chart-screen</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-engine"></i>
    <div class="docs-icon-name">引擎</div>
    <div class="docs-icon-code">&amp;#xe628;</div>
    <div class="docs-icon-fontclass">layui-icon-engine</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-triangle-d"></i>
    <div class="docs-icon-name">下三角</div>
    <div class="docs-icon-code">&amp;#xe625;</div>
    <div class="docs-icon-fontclass">layui-icon-triangle-d</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-triangle-r"></i>
    <div class="docs-icon-name">右三角</div>
    <div class="docs-icon-code">&amp;#xe623;</div>
    <div class="docs-icon-fontclass">layui-icon-triangle-r</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-file"></i>
    <div class="docs-icon-name">文件</div>
    <div class="docs-icon-code">&amp;#xe621;</div>
    <div class="docs-icon-fontclass">layui-icon-file</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-set-sm"></i>
    <div class="docs-icon-name">设置-小型</div>
    <div class="docs-icon-code">&amp;#xe620;</div>
    <div class="docs-icon-fontclass">layui-icon-set-sm</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-reduce-circle"></i>
    <div class="docs-icon-name">减少-圆圈</div>
    <div class="docs-icon-code">&amp;#xe616;</div>
    <div class="docs-icon-fontclass">layui-icon-reduce-circle</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-add-circle"></i>
    <div class="docs-icon-name">添加-圆圈</div>
    <div class="docs-icon-code">&amp;#xe61f;</div>
    <div class="docs-icon-fontclass">layui-icon-add-circle</div>
  </div>
  
  
  <div>
    <i class="layui-icon layui-icon-404"></i>
    <div class="docs-icon-name">404</div>
    <div class="docs-icon-code">&amp;#xe61c;</div>
    <div class="docs-icon-fontclass">layui-icon-404</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-about"></i>
    <div class="docs-icon-name">关于</div>
    <div class="docs-icon-code">&amp;#xe60b;</div>
    <div class="docs-icon-fontclass">layui-icon-about</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-up"></i>
    <div class="docs-icon-name">箭头 向上</div>
    <div class="docs-icon-code">&amp;#xe619;</div>
    <div class="docs-icon-fontclass">layui-icon-up</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-down"></i>
    <div class="docs-icon-name">箭头 向下</div>
    <div class="docs-icon-code">&amp;#xe61a;</div>
    <div class="docs-icon-fontclass">layui-icon-down</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-left"></i>
    <div class="docs-icon-name">箭头 向左</div>
    <div class="docs-icon-code">&amp;#xe603;</div>
    <div class="docs-icon-fontclass">layui-icon-left</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-right"></i>
    <div class="docs-icon-name">箭头 向右</div>
    <div class="docs-icon-code">&amp;#xe602;</div>
    <div class="docs-icon-fontclass">layui-icon-right</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-circle-dot"></i>
    <div class="docs-icon-name">圆点</div>
    <div class="docs-icon-code">&amp;#xe617;</div>
    <div class="docs-icon-fontclass">layui-icon-circle-dot</div>
  </div>
  
  <div>
    <i class="layui-icon layui-icon-search"></i>
    <div class="docs-icon-name">搜索</div>
    <div class="docs-icon-code">&amp;#xe615;</div>
    <div class="docs-icon-fontclass">layui-icon-search</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-set-fill"></i>
    <div class="docs-icon-name">设置-实心</div>
    <div class="docs-icon-code">&amp;#xe614;</div>
    <div class="docs-icon-fontclass">layui-icon-set-fill</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-group"></i>
    <div class="docs-icon-name">群组</div>
    <div class="docs-icon-code">&amp;#xe613;</div>
    <div class="docs-icon-fontclass">layui-icon-group</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-friends"></i>
    <div class="docs-icon-name">好友</div>
    <div class="docs-icon-code">&amp;#xe612;</div>
    <div class="docs-icon-fontclass">layui-icon-friends</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-reply-fill"></i>
    <div class="docs-icon-name">回复 评论 实心</div>
    <div class="docs-icon-code">&amp;#xe611;</div>
    <div class="docs-icon-fontclass">layui-icon-reply-fill</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-menu-fill"></i>
    <div class="docs-icon-name">菜单 隐身 实心</div>
    <div class="docs-icon-code">&amp;#xe60f;</div>
    <div class="docs-icon-fontclass">layui-icon-menu-fill</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-log"></i>
    <div class="docs-icon-name">记录</div>
    <div class="docs-icon-code">&amp;#xe60e;</div>
    <div class="docs-icon-fontclass">layui-icon-log</div>
  </div>
  
  <div>
    <i class="layui-icon layui-icon-picture-fine"></i>
    <div class="docs-icon-name">图片-细体</div>
    <div class="docs-icon-code">&amp;#xe60d;</div>
    <div class="docs-icon-fontclass">layui-icon-picture-fine</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-face-smile-fine"></i>
    <div class="docs-icon-name">表情-笑-细体</div>
    <div class="docs-icon-code">&amp;#xe60c;</div>
    <div class="docs-icon-fontclass">layui-icon-face-smile-fine</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-list"></i>
    <div class="docs-icon-name">列表</div>
    <div class="docs-icon-code">&amp;#xe60a;</div>
    <div class="docs-icon-fontclass">layui-icon-list</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-release"></i>
    <div class="docs-icon-name">发布 纸飞机</div>
    <div class="docs-icon-code">&amp;#xe609;</div>
    <div class="docs-icon-fontclass">layui-icon-release</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-ok"></i>
    <div class="docs-icon-name">对 OK</div>
    <div class="docs-icon-code">&amp;#xe605;</div>
    <div class="docs-icon-fontclass">layui-icon-ok</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-help"></i>
    <div class="docs-icon-name">帮助</div>
    <div class="docs-icon-code">&amp;#xe607;</div>
    <div class="docs-icon-fontclass">layui-icon-help</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-chat"></i>
    <div class="docs-icon-name">客服</div>
    <div class="docs-icon-code">&amp;#xe606;</div>
    <div class="docs-icon-fontclass">layui-icon-chat</div>
  </div>
  
  <div>
    <i class="layui-icon layui-icon-top"></i>
    <div class="docs-icon-name">top 置顶</div>
    <div class="docs-icon-code">&amp;#xe604;</div>
    <div class="docs-icon-fontclass">layui-icon-top</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-star"></i>
    <div class="docs-icon-name">收藏-空心</div>
    <div class="docs-icon-code">&amp;#xe600;</div>
    <div class="docs-icon-fontclass">layui-icon-star</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-star-fill"></i>
    <div class="docs-icon-name">收藏-实心</div>
    <div class="docs-icon-code">&amp;#xe658;</div>
    <div class="docs-icon-fontclass">layui-icon-star-fill</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-close-fill"></i>
    <div class="docs-icon-name">关闭-实心</div>
    <div class="docs-icon-code">&amp;#x1007;</div>
    <div class="docs-icon-fontclass">layui-icon-close-fill</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-close"></i>
    <div class="docs-icon-name">关闭-空心</div>
    <div class="docs-icon-code">&amp;#x1006;</div>
    <div class="docs-icon-fontclass">layui-icon-close</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-ok-circle"></i>
    <div class="docs-icon-name">正确</div>
    <div class="docs-icon-code">&amp;#x1005;</div>
    <div class="docs-icon-fontclass">layui-icon-ok-circle</div>
  </div>
  <div>
    <i class="layui-icon layui-icon-add-circle-fine"></i>
    <div class="docs-icon-name">添加-圆圈-细体</div>
    <div class="docs-icon-code">&amp;#xe608;</div>
    <div class="docs-icon-fontclass">layui-icon-add-circle-fine</div>
  </div>
</div>


<h2 id="cors" lay-toc="">跨域处理</h2>

由于浏览器存在同源策略，若 Layui 文件地址与你当前的页面地址*不在同一个域下*，即会出现图标跨域问题。因此，要么将 Layui 文件与网站放在同一服务器，要么对 Layui 文件所在的静态资源服务器的 `Response Headers` 添加：`Access-Control-Allow-Origin: *` 或对跨资源共享指定域名，即可解决图标跨域问题。

<style>
#ID-icon-copy{display: none;}
</style>

<pre class="layui-code" lay-options="{preview: true, layout: ['preview'], id: 'ID-icon-copy'}">
  <textarea>
<script>
  layui.use(function(){
    var $ = layui.jquery;
    var layer = layui.layer;

    $('.ws-docs-icon > div').on('click', function(){
      var iconclass = $(this).find('.docs-icon-fontclass').text();
      var copied = copy(iconclass);
      if(copied){
        layer.msg('已复制 '+ iconclass, {
          icon: 1,
          offset: '5%',
          anim: 'slideDown',
          isOutAnim: false
        });
      }
    });

    function copy(text){
      var textarea = document.createElement('textarea');
      textarea.value = text;
      textarea.style.position = 'absolute';
      textarea.style.opacity = '0';
      document.body.appendChild(textarea);
      textarea.select();
      var copied = false;
      try{
        copied = document.execCommand('copy');
      }catch(err){
        console.log('error', err);
      }
      textarea.remove();
      return copied;
    }
  });
</script>
  </textarea>
</pre>
