# Introduction

<card>

  ## Whats is Vuesax?

  Vuesax (pronounced / vjusacksː /, as view sacks) is a framework of UI components created with [Vuejs](https://vuejs.org/)  to make projects easily and with a unique and pleasant style, vuesax is created from scratch and designed for all types of developers from the frontend lover to the backend who wants to easily create their visual approach to the end-user

  We are focused on streamlining the work of the programmer by giving components created in their entirety and with independent customization and very easy to implement, so creativity is in our hands but we do not neglect that each project is different both visually and in its ecosystem

  Vuesax does not have a design line such as other component frameworks based on Material Design, we believe that there are already emaciated frameworks that look visually and in UI / UX and we don't want to be one more of the bunch, apart from that we love to create and design new experiences and surprise you with new elements or details that we can only do by being visually free.

</card>

<card>

  ## Why Vuesax?

  Vuesax is a relatively new framework with a refreshing design and in the latest trends, vuesax based on vuejs which means that we go hand in hand with one of the most popular javascript frameworks in the world and with a huge community with which you will have all the help and documentation to create and make your project

  - Vuesax, unlike many frameworks, is designed from scratch and we are not anchored to any design line, this is something great since your project is going to be unique and very different from the others

  - We are focused on the quick and easy creation of projects giving a beautiful visual line but without forgetting the personalization and independence of the developer

  - Vuesax uses native css variables for better customization and production changes such as changing to dark theme or changing the main color of the entire application with few javascript lines

  - Vuesax is a frame designed to have a great visual impact and that is always in trend with respect to design.

  - An open-source community to create, improve and correct any component or function.

  - Independent components to avoid importing unnecessary code.

  - Markdown documents for better sustainability.

  - and much more.

</card>

<card>

  ## How It Works

  Vuesax is a framework of UI components that you can use in your application or project and save you a lot of time and work in creating them yourself, the components are created to be customized and reusable so you can use them anywhere and logical.

</card>

<card>

  ## Features

  - Modular: you can use all vuesax components or just one on-demand, thus saving unnecessary code and less weight in the total framework

  - Quick creation: create web applications quickly with vuesax since all the difficult work is done for you, just by adding a component you already have a beautiful and functional element in your project

  - Easy start: you don't need to be an expert in vuejs or javascript to implement vuesax or its components in your project

  - Unique design: Is your project unique? Vuesax knows that it is and that is why it is also unique so that you are not equal to other projects and everything is the same

  - Unique components: there are components in vuesax that you will not find in other frameworks since we have a unique design and therefore freedom to create new user experiences

  - Much more

</card>
