var tape = require("tape");
var jsdom = require("./jsdom");
var deepEqualData = require("./deepEqualData");
var d3 = require("d3-selection");
var d3_graphviz = require("../");
var translatePointsAttribute = require("./svg").translatePointsAttribute;

tape("No edge is drawn when style is invis.", function(test) {
    var window = global.window = jsdom('<div id="expected-graph"></div><div id="actual-graph"></div>');
    var document = global.document = window.document;
    var expectedGraph = d3.select("#expected-graph");
    var actualGraph = d3.select("#actual-graph");
    var actualGraphviz;
    var expectedGraphviz = d3_graphviz.graphviz("#expected-graph")
        .on('initEnd', () => {
            actualGraphviz = d3_graphviz.graphviz("#actual-graph")
                .on('initEnd', startTest);
        });

    function startTest() {
        expectedGraphviz
            .zoom(false)
            .renderDot('digraph {a -> b [style="invis"]}', function () {
                actualGraphviz
                    .renderDot('digraph {}', function () {
                        const x1 = 20;
                        const y1 = -20;
                        const x2 = 40;
                        const y2 = -20;
                        actualGraphviz
                            .drawEdge(x1, y1, x2, y2, {style: 'invis', id: 'edge1'})
                            .insertDrawnEdge('a->b');

                        const expectedEdgeGroup = expectedGraph.selectAll('.edge');

                        const actualEdgeGroup = actualGraph.selectAll('.edge');

                        test.equal(expectedEdgeGroup.size(), 0, 'No edge is generated by Graphviz when style is invis');
                        test.equal(actualEdgeGroup.size(), 0, 'No edge is drawn when style is invis');

                        test.end();
                    });
            });
    }
});

tape("Updating of an edge with style invis is ignored.", function(test) {
    var window = global.window = jsdom('<div id="expected-graph"></div><div id="actual-graph"></div>');
    var document = global.document = window.document;
    var expectedGraph = d3.select("#expected-graph");
    var actualGraph = d3.select("#actual-graph");
    var actualGraphviz;
    var expectedGraphviz = d3_graphviz.graphviz("#expected-graph")
        .on('initEnd', () => {
            actualGraphviz = d3_graphviz.graphviz("#actual-graph")
                .on('initEnd', startTest);
        });

    function startTest() {
        expectedGraphviz
            .zoom(false)
            .renderDot('digraph {a -> b [style="invis"]}', function () {
                actualGraphviz
                    .renderDot('digraph {}', function () {
                        const x1 = 20;
                        const y1 = -20;
                        const x2 = 40;
                        const y2 = -20;
                        actualGraphviz
                            .drawEdge(x1, y1, x2, y2, {style: 'invis', id: 'edge1'})
                            .updateDrawnEdge(x1 + 1, y1 + 1, x2 + 1, y2 + 1, {color: 'green'})
                            .insertDrawnEdge('a->b');

                        const expectedEdgeGroup = expectedGraph.selectAll('.edge');

                        const actualEdgeGroup = actualGraph.selectAll('.edge');

                        test.equal(expectedEdgeGroup.size(), 0, 'No edge is generated by Graphviz when style is invis');
                        test.equal(actualEdgeGroup.size(), 0, 'No edge is drawn when style is invis');

                        test.end();
                    });
            });
    }
});

tape("Moving an edge with style invis is ignored.", function(test) {
    var window = global.window = jsdom('<div id="expected-graph"></div><div id="actual-graph"></div>');
    var document = global.document = window.document;
    var expectedGraph = d3.select("#expected-graph");
    var actualGraph = d3.select("#actual-graph");
    var actualGraphviz;
    var expectedGraphviz = d3_graphviz.graphviz("#expected-graph")
        .on('initEnd', () => {
            actualGraphviz = d3_graphviz.graphviz("#actual-graph")
                .on('initEnd', startTest);
        });

    function startTest() {
        expectedGraphviz
            .zoom(false)
            .renderDot('digraph {a -> b [style="invis"]}', function () {
                actualGraphviz
                    .renderDot('digraph {}', function () {
                        const x1 = 20;
                        const y1 = -20;
                        const x2 = 40;
                        const y2 = -20;
                        actualGraphviz
                            .drawEdge(x1, y1, x2, y2, {style: 'invis', id: 'edge1'})
                            .moveDrawnEdgeEndPoint(x2 + 1, y2 + 1)
                            .insertDrawnEdge('a->b');

                        const expectedEdgeGroup = expectedGraph.selectAll('.edge');

                        const actualEdgeGroup = actualGraph.selectAll('.edge');

                        test.equal(expectedEdgeGroup.size(), 0, 'No edge is generated by Graphviz when style is invis');
                        test.equal(actualEdgeGroup.size(), 0, 'No edge is drawn when style is invis');

                        test.end();
                    });
            });
    }
});

tape("Removal of an edge with style invis is allowed.", function(test) {
    var window = global.window = jsdom('<div id="expected-graph"></div><div id="actual-graph"></div>');
    var document = global.document = window.document;
    var expectedGraph = d3.select("#expected-graph");
    var actualGraph = d3.select("#actual-graph");
    var actualGraph = d3.select("#actual-graph");
    var actualGraphviz;
    var expectedGraphviz = d3_graphviz.graphviz("#expected-graph")
        .on('initEnd', () => {
            actualGraphviz = d3_graphviz.graphviz("#actual-graph")
                .on('initEnd', startTest);
        });

    function startTest() {
        expectedGraphviz
            .zoom(false)
            .renderDot('digraph {a -> b [style="invis"]}', function () {
                actualGraphviz
                    .renderDot('digraph {}', function () {
                        const x1 = 20;
                        const y1 = -20;
                        const x2 = 40;
                        const y2 = -20;
                        actualGraphviz
                            .drawEdge(x1, y1, x2, y2, {style: 'invis', id: 'edge1'})
                            .removeDrawnEdge();

                        const expectedEdgeGroup = expectedGraph.selectAll('.edge');

                        const actualEdgeGroup = actualGraph.selectAll('.edge');

                        test.equal(expectedEdgeGroup.size(), 0, 'No edge is generated by Graphviz when style is invis');
                        test.equal(actualEdgeGroup.size(), 0, 'No edge is drawn when style is invis');

                        test.end();
                    });
            });
    }
});

tape("Changing an edge with style invis to a visible edge is allowed.", function(test) {
    var window = global.window = jsdom('<div id="expected-graph"></div><div id="actual-graph"></div>');
    var document = global.document = window.document;
    var expectedGraph = d3.select("#expected-graph");
    var actualGraph = d3.select("#actual-graph");
    var actualGraphviz;
    var expectedGraphviz = d3_graphviz.graphviz("#expected-graph")
        .on('initEnd', () => {
            actualGraphviz = d3_graphviz.graphviz("#actual-graph")
                .on('initEnd', startTest);
        });

    function startTest() {
        expectedGraphviz
            .zoom(false)
            .renderDot('digraph {a -> b}', function () {
                actualGraphviz
                    .renderDot('digraph {}', function () {
                        const x1 = 20;
                        const y1 = -20;
                        const x2 = 40;
                        const y2 = -20;
                        actualGraphviz
                            .drawEdge(x1, y1, x2, y2, {style: 'invis', id: 'edge1'})
                            .updateDrawnEdge(x1, y1, x2, y2, {style: 'solid'})
                            .insertDrawnEdge('a->b');

                        const expectedEdgeGroup = expectedGraph.selectAll('.edge');

                        const actualEdgeGroup = actualGraph.selectAll('.edge');

                        test.equal(expectedEdgeGroup.size(), 1, 'An edge is generated by Graphviz when style is not invis');
                        test.equal(actualEdgeGroup.size(), 1, 'An edge is drawn when style is changed from invis');

                        const expectedEdgeTitle = expectedEdgeGroup.selectAll('title');
                        const expectedEdgeText = expectedEdgeGroup.selectAll('text');

                        const actualEdgeTitle = actualEdgeGroup.selectAll('title');

                        test.equal(actualEdgeGroup.attr("id"), expectedEdgeGroup.attr("id"), 'id of group');

                        test.equal(actualEdgeTitle.text(), expectedEdgeTitle.text(), 'text of title');

                        test.end();
                    });
            });
    }
});
