# jquery.dynatree.js  [![GitHub version](https://badge.fury.io/gh/mar10%2Fdynatree.svg)](https://github.com/mar10/dynatree/releases/latest)

> Dynatree is a JavaScript dynamic tree view plugin for jQuery with support for 
> persistence, keyboard, checkboxes, drag'n'drop, and lazy loading.

**Note:** This repository was migrated from [Google Code](https://code.google.com/p/dynatree) at 2015-03-15.

## Status

[![GitHub version](https://badge.fury.io/gh/mar10%2Fdynatree.svg)](https://github.com/mar10/dynatree/releases/latest)
See the [change log](https://github.com/mar10/dynatree/blob/master/CHANGELOG.md) 
for details.

##### Note: Fancytree 2.x is released
Dynatree 1.x will eventually be replaced by [Fancytree](https://github.com/mar10/fancytree/).<br>
I will support Dynatree for a while, but no new features will be added.

It is recommended to migrate to [Fancytree](https://github.com/mar10/fancytree/).
It's easy: see also the [migration hints](https://github.com/mar10/fancytree/wiki/WhatsNew).


## Overview

Dynatree is a [jQuery](http://jquery.com) plugin that allows to dynamically create 
html tree view controls using JavaScript.

[ ![sample](dynatree_sample.png?raw=true) ](http://wwwendt.de/tech/dynatree/doc/samples.html "Live demo")


**Main features**

  * Optimized for large dynamic trees (DOM elements are only created when really needed).
  * Programmable through a rich object oriented interface.
  * Support for lazy loading and Ajax.
  * Checkboxes and hierarchical selection.
  * Supports drag and drop.
  * Support for persistence.
  * Keyboard aware.
  * Initializes from HTML code, JSON, or JavaScript objects. 


## Documentation

Quick start
  1. Include jQuery and dynatree libraries.
  2. Add a `<div>` element where the tree should appear.
  3. Initialize the dynatree object when the page is loaded.

To learn more
  1. Check the [example page](http://wwwendt.de/tech/dynatree/doc/samples.html) and click on the `[View source code]` links.
  2. Read the [documentation](http://wwWendt.de/tech/dynatree/doc/dynatree-doc.html).
  3. [Fiddle with the samples](http://jsfiddle.net/user/mar10/fiddles/).


## Feedback and Support

  - A [discussion forum](http://groups.google.com/group/dynatree) is in place to ask questions or discuss features.
  - Check [Stack Overflow](http://stackoverflow.com/questions/tagged/dynatree) for existing questions and answers.
  - Use the [Issue Tracker](https://github.com/mar10/dynatree/issues) to get a list of known bugs, or vote for a feature.<br>Please make sure you searched the group and issue tracker, before adding a new request.
  - If you like: [Make a donation](http://wwwendt.de/freeware/donate.html).
  - Using this library in a commercial product and need some help to meet you deadline? Cont(r)act me!
