/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
//
// **NOTE**: Do not edit directly! This file is generated using `npm run import-typescript`
//


/** Contains all the lib files */
export const libFileMap: Record<string, string> = {}
libFileMap['lib.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\n/// <reference lib=\"es5\" />\n/// <reference lib=\"dom\" />\n/// <reference lib=\"webworker.importscripts\" />\n/// <reference lib=\"scripthost\" />\n";
libFileMap['lib.decorators.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\n/**\n * The decorator context types provided to class element decorators.\n */\ntype ClassMemberDecoratorContext =\n    | ClassMethodDecoratorContext\n    | ClassGetterDecoratorContext\n    | ClassSetterDecoratorContext\n    | ClassFieldDecoratorContext\n    | ClassAccessorDecoratorContext\n    ;\n\n/**\n * The decorator context types provided to any decorator.\n */\ntype DecoratorContext =\n    | ClassDecoratorContext\n    | ClassMemberDecoratorContext\n    ;\n\n/**\n * Context provided to a class decorator.\n * @template Class The type of the decorated class associated with this context.\n */\ninterface ClassDecoratorContext<\n    Class extends abstract new (...args: any) => any = abstract new (...args: any) => any,\n> {\n    /** The kind of element that was decorated. */\n    readonly kind: \"class\";\n\n    /** The name of the decorated class. */\n    readonly name: string | undefined;\n\n    /**\n     * Adds a callback to be invoked after the class definition has been finalized.\n     *\n     * @example\n     * ```ts\n     * function customElement(name: string): ClassDecoratorFunction {\n     *   return (target, context) => {\n     *     context.addInitializer(function () {\n     *       customElements.define(name, this);\n     *     });\n     *   }\n     * }\n     *\n     * @customElement(\"my-element\")\n     * class MyElement {}\n     * ```\n     */\n    addInitializer(initializer: (this: Class) => void): void;\n}\n\n/**\n * Context provided to a class method decorator.\n * @template This The type on which the class element will be defined. For a static class element, this will be\n * the type of the constructor. For a non-static class element, this will be the type of the instance.\n * @template Value The type of the decorated class method.\n */\ninterface ClassMethodDecoratorContext<\n    This = unknown,\n    Value extends (this: This, ...args: any) => any = (this: This, ...args: any) => any,\n> {\n    /** The kind of class element that was decorated. */\n    readonly kind: \"method\";\n\n    /** The name of the decorated class element. */\n    readonly name: string | symbol;\n\n    /** A value indicating whether the class element is a static (`true`) or instance (`false`) element. */\n    readonly static: boolean;\n\n    /** A value indicating whether the class element has a private name. */\n    readonly private: boolean;\n\n    /** An object that can be used to access the current value of the class element at runtime. */\n    readonly access: {\n        /**\n         * Determines whether an object has a property with the same name as the decorated element.\n         */\n        has(object: This): boolean;\n        /**\n         * Gets the current value of the method from the provided object.\n         *\n         * @example\n         * let fn = context.access.get(instance);\n         */\n        get(object: This): Value;\n    };\n\n    /**\n     * Adds a callback to be invoked either before static initializers are run (when\n     * decorating a `static` element), or before instance initializers are run (when\n     * decorating a non-`static` element).\n     *\n     * @example\n     * ```ts\n     * const bound: ClassMethodDecoratorFunction = (value, context) {\n     *   if (context.private) throw new TypeError(\"Not supported on private methods.\");\n     *   context.addInitializer(function () {\n     *     this[context.name] = this[context.name].bind(this);\n     *   });\n     * }\n     *\n     * class C {\n     *   message = \"Hello\";\n     *\n     *   @bound\n     *   m() {\n     *     console.log(this.message);\n     *   }\n     * }\n     * ```\n     */\n    addInitializer(initializer: (this: This) => void): void;\n}\n\n/**\n * Context provided to a class getter decorator.\n * @template This The type on which the class element will be defined. For a static class element, this will be\n * the type of the constructor. For a non-static class element, this will be the type of the instance.\n * @template Value The property type of the decorated class getter.\n */\ninterface ClassGetterDecoratorContext<\n    This = unknown,\n    Value = unknown,\n> {\n    /** The kind of class element that was decorated. */\n    readonly kind: \"getter\";\n\n    /** The name of the decorated class element. */\n    readonly name: string | symbol;\n\n    /** A value indicating whether the class element is a static (`true`) or instance (`false`) element. */\n    readonly static: boolean;\n\n    /** A value indicating whether the class element has a private name. */\n    readonly private: boolean;\n\n    /** An object that can be used to access the current value of the class element at runtime. */\n    readonly access: {\n        /**\n         * Determines whether an object has a property with the same name as the decorated element.\n         */\n        has(object: This): boolean;\n        /**\n         * Invokes the getter on the provided object.\n         *\n         * @example\n         * let value = context.access.get(instance);\n         */\n        get(object: This): Value;\n    };\n\n    /**\n     * Adds a callback to be invoked either before static initializers are run (when\n     * decorating a `static` element), or before instance initializers are run (when\n     * decorating a non-`static` element).\n     */\n    addInitializer(initializer: (this: This) => void): void;\n}\n\n/**\n * Context provided to a class setter decorator.\n * @template This The type on which the class element will be defined. For a static class element, this will be\n * the type of the constructor. For a non-static class element, this will be the type of the instance.\n * @template Value The type of the decorated class setter.\n */\ninterface ClassSetterDecoratorContext<\n    This = unknown,\n    Value = unknown,\n> {\n    /** The kind of class element that was decorated. */\n    readonly kind: \"setter\";\n\n    /** The name of the decorated class element. */\n    readonly name: string | symbol;\n\n    /** A value indicating whether the class element is a static (`true`) or instance (`false`) element. */\n    readonly static: boolean;\n\n    /** A value indicating whether the class element has a private name. */\n    readonly private: boolean;\n\n    /** An object that can be used to access the current value of the class element at runtime. */\n    readonly access: {\n        /**\n         * Determines whether an object has a property with the same name as the decorated element.\n         */\n        has(object: This): boolean;\n        /**\n         * Invokes the setter on the provided object.\n         *\n         * @example\n         * context.access.set(instance, value);\n         */\n        set(object: This, value: Value): void;\n    };\n\n    /**\n     * Adds a callback to be invoked either before static initializers are run (when\n     * decorating a `static` element), or before instance initializers are run (when\n     * decorating a non-`static` element).\n     */\n    addInitializer(initializer: (this: This) => void): void;\n}\n\n/**\n * Context provided to a class `accessor` field decorator.\n * @template This The type on which the class element will be defined. For a static class element, this will be\n * the type of the constructor. For a non-static class element, this will be the type of the instance.\n * @template Value The type of decorated class field.\n */\ninterface ClassAccessorDecoratorContext<\n    This = unknown,\n    Value = unknown,\n> {\n    /** The kind of class element that was decorated. */\n    readonly kind: \"accessor\";\n\n    /** The name of the decorated class element. */\n    readonly name: string | symbol;\n\n    /** A value indicating whether the class element is a static (`true`) or instance (`false`) element. */\n    readonly static: boolean;\n\n    /** A value indicating whether the class element has a private name. */\n    readonly private: boolean;\n\n    /** An object that can be used to access the current value of the class element at runtime. */\n    readonly access: {\n        /**\n         * Determines whether an object has a property with the same name as the decorated element.\n         */\n        has(object: This): boolean;\n\n        /**\n         * Invokes the getter on the provided object.\n         *\n         * @example\n         * let value = context.access.get(instance);\n         */\n        get(object: This): Value;\n\n        /**\n         * Invokes the setter on the provided object.\n         *\n         * @example\n         * context.access.set(instance, value);\n         */\n        set(object: This, value: Value): void;\n    };\n\n    /**\n     * Adds a callback to be invoked either before static initializers are run (when\n     * decorating a `static` element), or before instance initializers are run (when\n     * decorating a non-`static` element).\n     */\n    addInitializer(initializer: (this: This) => void): void;\n}\n\n/**\n * Describes the target provided to class `accessor` field decorators.\n * @template This The `this` type to which the target applies.\n * @template Value The property type for the class `accessor` field.\n */\ninterface ClassAccessorDecoratorTarget<This, Value> {\n    /**\n     * Invokes the getter that was defined prior to decorator application.\n     *\n     * @example\n     * let value = target.get.call(instance);\n     */\n    get(this: This): Value;\n\n    /**\n     * Invokes the setter that was defined prior to decorator application.\n     *\n     * @example\n     * target.set.call(instance, value);\n     */\n    set(this: This, value: Value): void;\n}\n\n/**\n * Describes the allowed return value from a class `accessor` field decorator.\n * @template This The `this` type to which the target applies.\n * @template Value The property type for the class `accessor` field.\n */\ninterface ClassAccessorDecoratorResult<This, Value> {\n    /**\n     * An optional replacement getter function. If not provided, the existing getter function is used instead.\n     */\n    get?(this: This): Value;\n\n    /**\n     * An optional replacement setter function. If not provided, the existing setter function is used instead.\n     */\n    set?(this: This, value: Value): void;\n\n    /**\n     * An optional initializer mutator that is invoked when the underlying field initializer is evaluated.\n     * @param value The incoming initializer value.\n     * @returns The replacement initializer value.\n     */\n    init?(this: This, value: Value): Value;\n}\n\n/**\n * Context provided to a class field decorator.\n * @template This The type on which the class element will be defined. For a static class element, this will be\n * the type of the constructor. For a non-static class element, this will be the type of the instance.\n * @template Value The type of the decorated class field.\n */\ninterface ClassFieldDecoratorContext<\n    This = unknown,\n    Value = unknown,\n> {\n    /** The kind of class element that was decorated. */\n    readonly kind: \"field\";\n\n    /** The name of the decorated class element. */\n    readonly name: string | symbol;\n\n    /** A value indicating whether the class element is a static (`true`) or instance (`false`) element. */\n    readonly static: boolean;\n\n    /** A value indicating whether the class element has a private name. */\n    readonly private: boolean;\n\n    /** An object that can be used to access the current value of the class element at runtime. */\n    readonly access: {\n        /**\n         * Determines whether an object has a property with the same name as the decorated element.\n         */\n        has(object: This): boolean;\n\n        /**\n         * Gets the value of the field on the provided object.\n         */\n        get(object: This): Value;\n\n        /**\n         * Sets the value of the field on the provided object.\n         */\n        set(object: This, value: Value): void;\n    };\n\n    /**\n     * Adds a callback to be invoked either before static initializers are run (when\n     * decorating a `static` element), or before instance initializers are run (when\n     * decorating a non-`static` element).\n     */\n    addInitializer(initializer: (this: This) => void): void;\n}\n";
libFileMap['lib.decorators.legacy.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\ndeclare type ClassDecorator = <TFunction extends Function>(target: TFunction) => TFunction | void;\ndeclare type PropertyDecorator = (target: Object, propertyKey: string | symbol) => void;\ndeclare type MethodDecorator = <T>(target: Object, propertyKey: string | symbol, descriptor: TypedPropertyDescriptor<T>) => TypedPropertyDescriptor<T> | void;\ndeclare type ParameterDecorator = (target: Object, propertyKey: string | symbol, parameterIndex: number) => void;\n";
libFileMap['lib.dom.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\n/////////////////////////////\n/// Window APIs\n/////////////////////////////\n\ninterface AddEventListenerOptions extends EventListenerOptions {\n    once?: boolean;\n    passive?: boolean;\n    signal?: AbortSignal;\n}\n\ninterface AesCbcParams extends Algorithm {\n    iv: BufferSource;\n}\n\ninterface AesCtrParams extends Algorithm {\n    counter: BufferSource;\n    length: number;\n}\n\ninterface AesDerivedKeyParams extends Algorithm {\n    length: number;\n}\n\ninterface AesGcmParams extends Algorithm {\n    additionalData?: BufferSource;\n    iv: BufferSource;\n    tagLength?: number;\n}\n\ninterface AesKeyAlgorithm extends KeyAlgorithm {\n    length: number;\n}\n\ninterface AesKeyGenParams extends Algorithm {\n    length: number;\n}\n\ninterface Algorithm {\n    name: string;\n}\n\ninterface AnalyserOptions extends AudioNodeOptions {\n    fftSize?: number;\n    maxDecibels?: number;\n    minDecibels?: number;\n    smoothingTimeConstant?: number;\n}\n\ninterface AnimationEventInit extends EventInit {\n    animationName?: string;\n    elapsedTime?: number;\n    pseudoElement?: string;\n}\n\ninterface AnimationPlaybackEventInit extends EventInit {\n    currentTime?: CSSNumberish | null;\n    timelineTime?: CSSNumberish | null;\n}\n\ninterface AssignedNodesOptions {\n    flatten?: boolean;\n}\n\ninterface AudioBufferOptions {\n    length: number;\n    numberOfChannels?: number;\n    sampleRate: number;\n}\n\ninterface AudioBufferSourceOptions {\n    buffer?: AudioBuffer | null;\n    detune?: number;\n    loop?: boolean;\n    loopEnd?: number;\n    loopStart?: number;\n    playbackRate?: number;\n}\n\ninterface AudioConfiguration {\n    bitrate?: number;\n    channels?: string;\n    contentType: string;\n    samplerate?: number;\n    spatialRendering?: boolean;\n}\n\ninterface AudioContextOptions {\n    latencyHint?: AudioContextLatencyCategory | number;\n    sampleRate?: number;\n}\n\ninterface AudioNodeOptions {\n    channelCount?: number;\n    channelCountMode?: ChannelCountMode;\n    channelInterpretation?: ChannelInterpretation;\n}\n\ninterface AudioProcessingEventInit extends EventInit {\n    inputBuffer: AudioBuffer;\n    outputBuffer: AudioBuffer;\n    playbackTime: number;\n}\n\ninterface AudioTimestamp {\n    contextTime?: number;\n    performanceTime?: DOMHighResTimeStamp;\n}\n\ninterface AudioWorkletNodeOptions extends AudioNodeOptions {\n    numberOfInputs?: number;\n    numberOfOutputs?: number;\n    outputChannelCount?: number[];\n    parameterData?: Record<string, number>;\n    processorOptions?: any;\n}\n\ninterface AuthenticationExtensionsClientInputs {\n    appid?: string;\n    credProps?: boolean;\n    hmacCreateSecret?: boolean;\n}\n\ninterface AuthenticationExtensionsClientOutputs {\n    appid?: boolean;\n    credProps?: CredentialPropertiesOutput;\n    hmacCreateSecret?: boolean;\n}\n\ninterface AuthenticatorSelectionCriteria {\n    authenticatorAttachment?: AuthenticatorAttachment;\n    requireResidentKey?: boolean;\n    residentKey?: ResidentKeyRequirement;\n    userVerification?: UserVerificationRequirement;\n}\n\ninterface BiquadFilterOptions extends AudioNodeOptions {\n    Q?: number;\n    detune?: number;\n    frequency?: number;\n    gain?: number;\n    type?: BiquadFilterType;\n}\n\ninterface BlobEventInit {\n    data: Blob;\n    timecode?: DOMHighResTimeStamp;\n}\n\ninterface BlobPropertyBag {\n    endings?: EndingType;\n    type?: string;\n}\n\ninterface CSSStyleSheetInit {\n    baseURL?: string;\n    disabled?: boolean;\n    media?: MediaList | string;\n}\n\ninterface CacheQueryOptions {\n    ignoreMethod?: boolean;\n    ignoreSearch?: boolean;\n    ignoreVary?: boolean;\n}\n\ninterface CanvasRenderingContext2DSettings {\n    alpha?: boolean;\n    colorSpace?: PredefinedColorSpace;\n    desynchronized?: boolean;\n    willReadFrequently?: boolean;\n}\n\ninterface ChannelMergerOptions extends AudioNodeOptions {\n    numberOfInputs?: number;\n}\n\ninterface ChannelSplitterOptions extends AudioNodeOptions {\n    numberOfOutputs?: number;\n}\n\ninterface CheckVisibilityOptions {\n    checkOpacity?: boolean;\n    checkVisibilityCSS?: boolean;\n}\n\ninterface ClientQueryOptions {\n    includeUncontrolled?: boolean;\n    type?: ClientTypes;\n}\n\ninterface ClipboardEventInit extends EventInit {\n    clipboardData?: DataTransfer | null;\n}\n\ninterface ClipboardItemOptions {\n    presentationStyle?: PresentationStyle;\n}\n\ninterface CloseEventInit extends EventInit {\n    code?: number;\n    reason?: string;\n    wasClean?: boolean;\n}\n\ninterface CompositionEventInit extends UIEventInit {\n    data?: string;\n}\n\ninterface ComputedEffectTiming extends EffectTiming {\n    activeDuration?: CSSNumberish;\n    currentIteration?: number | null;\n    endTime?: CSSNumberish;\n    localTime?: CSSNumberish | null;\n    progress?: number | null;\n    startTime?: CSSNumberish;\n}\n\ninterface ComputedKeyframe {\n    composite: CompositeOperationOrAuto;\n    computedOffset: number;\n    easing: string;\n    offset: number | null;\n    [property: string]: string | number | null | undefined;\n}\n\ninterface ConstantSourceOptions {\n    offset?: number;\n}\n\ninterface ConstrainBooleanParameters {\n    exact?: boolean;\n    ideal?: boolean;\n}\n\ninterface ConstrainDOMStringParameters {\n    exact?: string | string[];\n    ideal?: string | string[];\n}\n\ninterface ConstrainDoubleRange extends DoubleRange {\n    exact?: number;\n    ideal?: number;\n}\n\ninterface ConstrainULongRange extends ULongRange {\n    exact?: number;\n    ideal?: number;\n}\n\ninterface ConvolverOptions extends AudioNodeOptions {\n    buffer?: AudioBuffer | null;\n    disableNormalization?: boolean;\n}\n\ninterface CredentialCreationOptions {\n    publicKey?: PublicKeyCredentialCreationOptions;\n    signal?: AbortSignal;\n}\n\ninterface CredentialPropertiesOutput {\n    rk?: boolean;\n}\n\ninterface CredentialRequestOptions {\n    mediation?: CredentialMediationRequirement;\n    publicKey?: PublicKeyCredentialRequestOptions;\n    signal?: AbortSignal;\n}\n\ninterface CryptoKeyPair {\n    privateKey: CryptoKey;\n    publicKey: CryptoKey;\n}\n\ninterface CustomEventInit<T = any> extends EventInit {\n    detail?: T;\n}\n\ninterface DOMMatrix2DInit {\n    a?: number;\n    b?: number;\n    c?: number;\n    d?: number;\n    e?: number;\n    f?: number;\n    m11?: number;\n    m12?: number;\n    m21?: number;\n    m22?: number;\n    m41?: number;\n    m42?: number;\n}\n\ninterface DOMMatrixInit extends DOMMatrix2DInit {\n    is2D?: boolean;\n    m13?: number;\n    m14?: number;\n    m23?: number;\n    m24?: number;\n    m31?: number;\n    m32?: number;\n    m33?: number;\n    m34?: number;\n    m43?: number;\n    m44?: number;\n}\n\ninterface DOMPointInit {\n    w?: number;\n    x?: number;\n    y?: number;\n    z?: number;\n}\n\ninterface DOMQuadInit {\n    p1?: DOMPointInit;\n    p2?: DOMPointInit;\n    p3?: DOMPointInit;\n    p4?: DOMPointInit;\n}\n\ninterface DOMRectInit {\n    height?: number;\n    width?: number;\n    x?: number;\n    y?: number;\n}\n\ninterface DelayOptions extends AudioNodeOptions {\n    delayTime?: number;\n    maxDelayTime?: number;\n}\n\ninterface DeviceMotionEventAccelerationInit {\n    x?: number | null;\n    y?: number | null;\n    z?: number | null;\n}\n\ninterface DeviceMotionEventInit extends EventInit {\n    acceleration?: DeviceMotionEventAccelerationInit;\n    accelerationIncludingGravity?: DeviceMotionEventAccelerationInit;\n    interval?: number;\n    rotationRate?: DeviceMotionEventRotationRateInit;\n}\n\ninterface DeviceMotionEventRotationRateInit {\n    alpha?: number | null;\n    beta?: number | null;\n    gamma?: number | null;\n}\n\ninterface DeviceOrientationEventInit extends EventInit {\n    absolute?: boolean;\n    alpha?: number | null;\n    beta?: number | null;\n    gamma?: number | null;\n}\n\ninterface DisplayMediaStreamOptions {\n    audio?: boolean | MediaTrackConstraints;\n    video?: boolean | MediaTrackConstraints;\n}\n\ninterface DocumentTimelineOptions {\n    originTime?: DOMHighResTimeStamp;\n}\n\ninterface DoubleRange {\n    max?: number;\n    min?: number;\n}\n\ninterface DragEventInit extends MouseEventInit {\n    dataTransfer?: DataTransfer | null;\n}\n\ninterface DynamicsCompressorOptions extends AudioNodeOptions {\n    attack?: number;\n    knee?: number;\n    ratio?: number;\n    release?: number;\n    threshold?: number;\n}\n\ninterface EcKeyAlgorithm extends KeyAlgorithm {\n    namedCurve: NamedCurve;\n}\n\ninterface EcKeyGenParams extends Algorithm {\n    namedCurve: NamedCurve;\n}\n\ninterface EcKeyImportParams extends Algorithm {\n    namedCurve: NamedCurve;\n}\n\ninterface EcdhKeyDeriveParams extends Algorithm {\n    public: CryptoKey;\n}\n\ninterface EcdsaParams extends Algorithm {\n    hash: HashAlgorithmIdentifier;\n}\n\ninterface EffectTiming {\n    delay?: number;\n    direction?: PlaybackDirection;\n    duration?: number | string;\n    easing?: string;\n    endDelay?: number;\n    fill?: FillMode;\n    iterationStart?: number;\n    iterations?: number;\n    playbackRate?: number;\n}\n\ninterface ElementCreationOptions {\n    is?: string;\n}\n\ninterface ElementDefinitionOptions {\n    extends?: string;\n}\n\ninterface ErrorEventInit extends EventInit {\n    colno?: number;\n    error?: any;\n    filename?: string;\n    lineno?: number;\n    message?: string;\n}\n\ninterface EventInit {\n    bubbles?: boolean;\n    cancelable?: boolean;\n    composed?: boolean;\n}\n\ninterface EventListenerOptions {\n    capture?: boolean;\n}\n\ninterface EventModifierInit extends UIEventInit {\n    altKey?: boolean;\n    ctrlKey?: boolean;\n    metaKey?: boolean;\n    modifierAltGraph?: boolean;\n    modifierCapsLock?: boolean;\n    modifierFn?: boolean;\n    modifierFnLock?: boolean;\n    modifierHyper?: boolean;\n    modifierNumLock?: boolean;\n    modifierScrollLock?: boolean;\n    modifierSuper?: boolean;\n    modifierSymbol?: boolean;\n    modifierSymbolLock?: boolean;\n    shiftKey?: boolean;\n}\n\ninterface EventSourceInit {\n    withCredentials?: boolean;\n}\n\ninterface FilePropertyBag extends BlobPropertyBag {\n    lastModified?: number;\n}\n\ninterface FileSystemFlags {\n    create?: boolean;\n    exclusive?: boolean;\n}\n\ninterface FileSystemGetDirectoryOptions {\n    create?: boolean;\n}\n\ninterface FileSystemGetFileOptions {\n    create?: boolean;\n}\n\ninterface FileSystemRemoveOptions {\n    recursive?: boolean;\n}\n\ninterface FocusEventInit extends UIEventInit {\n    relatedTarget?: EventTarget | null;\n}\n\ninterface FocusOptions {\n    preventScroll?: boolean;\n}\n\ninterface FontFaceDescriptors {\n    ascentOverride?: string;\n    descentOverride?: string;\n    display?: FontDisplay;\n    featureSettings?: string;\n    lineGapOverride?: string;\n    stretch?: string;\n    style?: string;\n    unicodeRange?: string;\n    variant?: string;\n    weight?: string;\n}\n\ninterface FontFaceSetLoadEventInit extends EventInit {\n    fontfaces?: FontFace[];\n}\n\ninterface FormDataEventInit extends EventInit {\n    formData: FormData;\n}\n\ninterface FullscreenOptions {\n    navigationUI?: FullscreenNavigationUI;\n}\n\ninterface GainOptions extends AudioNodeOptions {\n    gain?: number;\n}\n\ninterface GamepadEventInit extends EventInit {\n    gamepad: Gamepad;\n}\n\ninterface GetAnimationsOptions {\n    subtree?: boolean;\n}\n\ninterface GetNotificationOptions {\n    tag?: string;\n}\n\ninterface GetRootNodeOptions {\n    composed?: boolean;\n}\n\ninterface HashChangeEventInit extends EventInit {\n    newURL?: string;\n    oldURL?: string;\n}\n\ninterface HkdfParams extends Algorithm {\n    hash: HashAlgorithmIdentifier;\n    info: BufferSource;\n    salt: BufferSource;\n}\n\ninterface HmacImportParams extends Algorithm {\n    hash: HashAlgorithmIdentifier;\n    length?: number;\n}\n\ninterface HmacKeyAlgorithm extends KeyAlgorithm {\n    hash: KeyAlgorithm;\n    length: number;\n}\n\ninterface HmacKeyGenParams extends Algorithm {\n    hash: HashAlgorithmIdentifier;\n    length?: number;\n}\n\ninterface IDBDatabaseInfo {\n    name?: string;\n    version?: number;\n}\n\ninterface IDBIndexParameters {\n    multiEntry?: boolean;\n    unique?: boolean;\n}\n\ninterface IDBObjectStoreParameters {\n    autoIncrement?: boolean;\n    keyPath?: string | string[] | null;\n}\n\ninterface IDBTransactionOptions {\n    durability?: IDBTransactionDurability;\n}\n\ninterface IDBVersionChangeEventInit extends EventInit {\n    newVersion?: number | null;\n    oldVersion?: number;\n}\n\ninterface IIRFilterOptions extends AudioNodeOptions {\n    feedback: number[];\n    feedforward: number[];\n}\n\ninterface IdleRequestOptions {\n    timeout?: number;\n}\n\ninterface ImageBitmapOptions {\n    colorSpaceConversion?: ColorSpaceConversion;\n    imageOrientation?: ImageOrientation;\n    premultiplyAlpha?: PremultiplyAlpha;\n    resizeHeight?: number;\n    resizeQuality?: ResizeQuality;\n    resizeWidth?: number;\n}\n\ninterface ImageBitmapRenderingContextSettings {\n    alpha?: boolean;\n}\n\ninterface ImageDataSettings {\n    colorSpace?: PredefinedColorSpace;\n}\n\ninterface ImageEncodeOptions {\n    quality?: number;\n    type?: string;\n}\n\ninterface ImportMeta {\n    url: string;\n}\n\ninterface InputEventInit extends UIEventInit {\n    data?: string | null;\n    dataTransfer?: DataTransfer | null;\n    inputType?: string;\n    isComposing?: boolean;\n    targetRanges?: StaticRange[];\n}\n\ninterface IntersectionObserverEntryInit {\n    boundingClientRect: DOMRectInit;\n    intersectionRatio: number;\n    intersectionRect: DOMRectInit;\n    isIntersecting: boolean;\n    rootBounds: DOMRectInit | null;\n    target: Element;\n    time: DOMHighResTimeStamp;\n}\n\ninterface IntersectionObserverInit {\n    root?: Element | Document | null;\n    rootMargin?: string;\n    threshold?: number | number[];\n}\n\ninterface JsonWebKey {\n    alg?: string;\n    crv?: string;\n    d?: string;\n    dp?: string;\n    dq?: string;\n    e?: string;\n    ext?: boolean;\n    k?: string;\n    key_ops?: string[];\n    kty?: string;\n    n?: string;\n    oth?: RsaOtherPrimesInfo[];\n    p?: string;\n    q?: string;\n    qi?: string;\n    use?: string;\n    x?: string;\n    y?: string;\n}\n\ninterface KeyAlgorithm {\n    name: string;\n}\n\ninterface KeyboardEventInit extends EventModifierInit {\n    /** @deprecated */\n    charCode?: number;\n    code?: string;\n    isComposing?: boolean;\n    key?: string;\n    /** @deprecated */\n    keyCode?: number;\n    location?: number;\n    repeat?: boolean;\n}\n\ninterface Keyframe {\n    composite?: CompositeOperationOrAuto;\n    easing?: string;\n    offset?: number | null;\n    [property: string]: string | number | null | undefined;\n}\n\ninterface KeyframeAnimationOptions extends KeyframeEffectOptions {\n    id?: string;\n}\n\ninterface KeyframeEffectOptions extends EffectTiming {\n    composite?: CompositeOperation;\n    iterationComposite?: IterationCompositeOperation;\n    pseudoElement?: string | null;\n}\n\ninterface LockInfo {\n    clientId?: string;\n    mode?: LockMode;\n    name?: string;\n}\n\ninterface LockManagerSnapshot {\n    held?: LockInfo[];\n    pending?: LockInfo[];\n}\n\ninterface LockOptions {\n    ifAvailable?: boolean;\n    mode?: LockMode;\n    signal?: AbortSignal;\n    steal?: boolean;\n}\n\ninterface MIDIConnectionEventInit extends EventInit {\n    port?: MIDIPort;\n}\n\ninterface MIDIMessageEventInit extends EventInit {\n    data?: Uint8Array;\n}\n\ninterface MIDIOptions {\n    software?: boolean;\n    sysex?: boolean;\n}\n\ninterface MediaCapabilitiesDecodingInfo extends MediaCapabilitiesInfo {\n    configuration?: MediaDecodingConfiguration;\n}\n\ninterface MediaCapabilitiesEncodingInfo extends MediaCapabilitiesInfo {\n    configuration?: MediaEncodingConfiguration;\n}\n\ninterface MediaCapabilitiesInfo {\n    powerEfficient: boolean;\n    smooth: boolean;\n    supported: boolean;\n}\n\ninterface MediaConfiguration {\n    audio?: AudioConfiguration;\n    video?: VideoConfiguration;\n}\n\ninterface MediaDecodingConfiguration extends MediaConfiguration {\n    type: MediaDecodingType;\n}\n\ninterface MediaElementAudioSourceOptions {\n    mediaElement: HTMLMediaElement;\n}\n\ninterface MediaEncodingConfiguration extends MediaConfiguration {\n    type: MediaEncodingType;\n}\n\ninterface MediaEncryptedEventInit extends EventInit {\n    initData?: ArrayBuffer | null;\n    initDataType?: string;\n}\n\ninterface MediaImage {\n    sizes?: string;\n    src: string;\n    type?: string;\n}\n\ninterface MediaKeyMessageEventInit extends EventInit {\n    message: ArrayBuffer;\n    messageType: MediaKeyMessageType;\n}\n\ninterface MediaKeySystemConfiguration {\n    audioCapabilities?: MediaKeySystemMediaCapability[];\n    distinctiveIdentifier?: MediaKeysRequirement;\n    initDataTypes?: string[];\n    label?: string;\n    persistentState?: MediaKeysRequirement;\n    sessionTypes?: string[];\n    videoCapabilities?: MediaKeySystemMediaCapability[];\n}\n\ninterface MediaKeySystemMediaCapability {\n    contentType?: string;\n    encryptionScheme?: string | null;\n    robustness?: string;\n}\n\ninterface MediaMetadataInit {\n    album?: string;\n    artist?: string;\n    artwork?: MediaImage[];\n    title?: string;\n}\n\ninterface MediaPositionState {\n    duration?: number;\n    playbackRate?: number;\n    position?: number;\n}\n\ninterface MediaQueryListEventInit extends EventInit {\n    matches?: boolean;\n    media?: string;\n}\n\ninterface MediaRecorderOptions {\n    audioBitsPerSecond?: number;\n    bitsPerSecond?: number;\n    mimeType?: string;\n    videoBitsPerSecond?: number;\n}\n\ninterface MediaSessionActionDetails {\n    action: MediaSessionAction;\n    fastSeek?: boolean;\n    seekOffset?: number;\n    seekTime?: number;\n}\n\ninterface MediaStreamAudioSourceOptions {\n    mediaStream: MediaStream;\n}\n\ninterface MediaStreamConstraints {\n    audio?: boolean | MediaTrackConstraints;\n    peerIdentity?: string;\n    preferCurrentTab?: boolean;\n    video?: boolean | MediaTrackConstraints;\n}\n\ninterface MediaStreamTrackEventInit extends EventInit {\n    track: MediaStreamTrack;\n}\n\ninterface MediaTrackCapabilities {\n    aspectRatio?: DoubleRange;\n    autoGainControl?: boolean[];\n    channelCount?: ULongRange;\n    deviceId?: string;\n    displaySurface?: string;\n    echoCancellation?: boolean[];\n    facingMode?: string[];\n    frameRate?: DoubleRange;\n    groupId?: string;\n    height?: ULongRange;\n    noiseSuppression?: boolean[];\n    sampleRate?: ULongRange;\n    sampleSize?: ULongRange;\n    width?: ULongRange;\n}\n\ninterface MediaTrackConstraintSet {\n    aspectRatio?: ConstrainDouble;\n    autoGainControl?: ConstrainBoolean;\n    channelCount?: ConstrainULong;\n    deviceId?: ConstrainDOMString;\n    displaySurface?: ConstrainDOMString;\n    echoCancellation?: ConstrainBoolean;\n    facingMode?: ConstrainDOMString;\n    frameRate?: ConstrainDouble;\n    groupId?: ConstrainDOMString;\n    height?: ConstrainULong;\n    noiseSuppression?: ConstrainBoolean;\n    sampleRate?: ConstrainULong;\n    sampleSize?: ConstrainULong;\n    width?: ConstrainULong;\n}\n\ninterface MediaTrackConstraints extends MediaTrackConstraintSet {\n    advanced?: MediaTrackConstraintSet[];\n}\n\ninterface MediaTrackSettings {\n    aspectRatio?: number;\n    autoGainControl?: boolean;\n    channelCount?: number;\n    deviceId?: string;\n    displaySurface?: string;\n    echoCancellation?: boolean;\n    facingMode?: string;\n    frameRate?: number;\n    groupId?: string;\n    height?: number;\n    noiseSuppression?: boolean;\n    sampleRate?: number;\n    sampleSize?: number;\n    width?: number;\n}\n\ninterface MediaTrackSupportedConstraints {\n    aspectRatio?: boolean;\n    autoGainControl?: boolean;\n    channelCount?: boolean;\n    deviceId?: boolean;\n    displaySurface?: boolean;\n    echoCancellation?: boolean;\n    facingMode?: boolean;\n    frameRate?: boolean;\n    groupId?: boolean;\n    height?: boolean;\n    noiseSuppression?: boolean;\n    sampleRate?: boolean;\n    sampleSize?: boolean;\n    width?: boolean;\n}\n\ninterface MessageEventInit<T = any> extends EventInit {\n    data?: T;\n    lastEventId?: string;\n    origin?: string;\n    ports?: MessagePort[];\n    source?: MessageEventSource | null;\n}\n\ninterface MouseEventInit extends EventModifierInit {\n    button?: number;\n    buttons?: number;\n    clientX?: number;\n    clientY?: number;\n    movementX?: number;\n    movementY?: number;\n    relatedTarget?: EventTarget | null;\n    screenX?: number;\n    screenY?: number;\n}\n\ninterface MultiCacheQueryOptions extends CacheQueryOptions {\n    cacheName?: string;\n}\n\ninterface MutationObserverInit {\n    /** Set to a list of attribute local names (without namespace) if not all attribute mutations need to be observed and attributes is true or omitted. */\n    attributeFilter?: string[];\n    /** Set to true if attributes is true or omitted and target's attribute value before the mutation needs to be recorded. */\n    attributeOldValue?: boolean;\n    /** Set to true if mutations to target's attributes are to be observed. Can be omitted if attributeOldValue or attributeFilter is specified. */\n    attributes?: boolean;\n    /** Set to true if mutations to target's data are to be observed. Can be omitted if characterDataOldValue is specified. */\n    characterData?: boolean;\n    /** Set to true if characterData is set to true or omitted and target's data before the mutation needs to be recorded. */\n    characterDataOldValue?: boolean;\n    /** Set to true if mutations to target's children are to be observed. */\n    childList?: boolean;\n    /** Set to true if mutations to not just target, but also target's descendants are to be observed. */\n    subtree?: boolean;\n}\n\ninterface NavigationPreloadState {\n    enabled?: boolean;\n    headerValue?: string;\n}\n\ninterface NotificationAction {\n    action: string;\n    icon?: string;\n    title: string;\n}\n\ninterface NotificationOptions {\n    actions?: NotificationAction[];\n    badge?: string;\n    body?: string;\n    data?: any;\n    dir?: NotificationDirection;\n    icon?: string;\n    image?: string;\n    lang?: string;\n    renotify?: boolean;\n    requireInteraction?: boolean;\n    silent?: boolean;\n    tag?: string;\n    timestamp?: EpochTimeStamp;\n    vibrate?: VibratePattern;\n}\n\ninterface OfflineAudioCompletionEventInit extends EventInit {\n    renderedBuffer: AudioBuffer;\n}\n\ninterface OfflineAudioContextOptions {\n    length: number;\n    numberOfChannels?: number;\n    sampleRate: number;\n}\n\ninterface OptionalEffectTiming {\n    delay?: number;\n    direction?: PlaybackDirection;\n    duration?: number | string;\n    easing?: string;\n    endDelay?: number;\n    fill?: FillMode;\n    iterationStart?: number;\n    iterations?: number;\n    playbackRate?: number;\n}\n\ninterface OscillatorOptions extends AudioNodeOptions {\n    detune?: number;\n    frequency?: number;\n    periodicWave?: PeriodicWave;\n    type?: OscillatorType;\n}\n\ninterface PageTransitionEventInit extends EventInit {\n    persisted?: boolean;\n}\n\ninterface PannerOptions extends AudioNodeOptions {\n    coneInnerAngle?: number;\n    coneOuterAngle?: number;\n    coneOuterGain?: number;\n    distanceModel?: DistanceModelType;\n    maxDistance?: number;\n    orientationX?: number;\n    orientationY?: number;\n    orientationZ?: number;\n    panningModel?: PanningModelType;\n    positionX?: number;\n    positionY?: number;\n    positionZ?: number;\n    refDistance?: number;\n    rolloffFactor?: number;\n}\n\ninterface PaymentCurrencyAmount {\n    currency: string;\n    value: string;\n}\n\ninterface PaymentDetailsBase {\n    displayItems?: PaymentItem[];\n    modifiers?: PaymentDetailsModifier[];\n}\n\ninterface PaymentDetailsInit extends PaymentDetailsBase {\n    id?: string;\n    total: PaymentItem;\n}\n\ninterface PaymentDetailsModifier {\n    additionalDisplayItems?: PaymentItem[];\n    data?: any;\n    supportedMethods: string;\n    total?: PaymentItem;\n}\n\ninterface PaymentDetailsUpdate extends PaymentDetailsBase {\n    paymentMethodErrors?: any;\n    total?: PaymentItem;\n}\n\ninterface PaymentItem {\n    amount: PaymentCurrencyAmount;\n    label: string;\n    pending?: boolean;\n}\n\ninterface PaymentMethodChangeEventInit extends PaymentRequestUpdateEventInit {\n    methodDetails?: any;\n    methodName?: string;\n}\n\ninterface PaymentMethodData {\n    data?: any;\n    supportedMethods: string;\n}\n\ninterface PaymentRequestUpdateEventInit extends EventInit {\n}\n\ninterface PaymentValidationErrors {\n    error?: string;\n    paymentMethod?: any;\n}\n\ninterface Pbkdf2Params extends Algorithm {\n    hash: HashAlgorithmIdentifier;\n    iterations: number;\n    salt: BufferSource;\n}\n\ninterface PerformanceMarkOptions {\n    detail?: any;\n    startTime?: DOMHighResTimeStamp;\n}\n\ninterface PerformanceMeasureOptions {\n    detail?: any;\n    duration?: DOMHighResTimeStamp;\n    end?: string | DOMHighResTimeStamp;\n    start?: string | DOMHighResTimeStamp;\n}\n\ninterface PerformanceObserverInit {\n    buffered?: boolean;\n    entryTypes?: string[];\n    type?: string;\n}\n\ninterface PeriodicWaveConstraints {\n    disableNormalization?: boolean;\n}\n\ninterface PeriodicWaveOptions extends PeriodicWaveConstraints {\n    imag?: number[] | Float32Array;\n    real?: number[] | Float32Array;\n}\n\ninterface PermissionDescriptor {\n    name: PermissionName;\n}\n\ninterface PictureInPictureEventInit extends EventInit {\n    pictureInPictureWindow: PictureInPictureWindow;\n}\n\ninterface PointerEventInit extends MouseEventInit {\n    coalescedEvents?: PointerEvent[];\n    height?: number;\n    isPrimary?: boolean;\n    pointerId?: number;\n    pointerType?: string;\n    predictedEvents?: PointerEvent[];\n    pressure?: number;\n    tangentialPressure?: number;\n    tiltX?: number;\n    tiltY?: number;\n    twist?: number;\n    width?: number;\n}\n\ninterface PopStateEventInit extends EventInit {\n    state?: any;\n}\n\ninterface PositionOptions {\n    enableHighAccuracy?: boolean;\n    maximumAge?: number;\n    timeout?: number;\n}\n\ninterface ProgressEventInit extends EventInit {\n    lengthComputable?: boolean;\n    loaded?: number;\n    total?: number;\n}\n\ninterface PromiseRejectionEventInit extends EventInit {\n    promise: Promise<any>;\n    reason?: any;\n}\n\ninterface PropertyIndexedKeyframes {\n    composite?: CompositeOperationOrAuto | CompositeOperationOrAuto[];\n    easing?: string | string[];\n    offset?: number | (number | null)[];\n    [property: string]: string | string[] | number | null | (number | null)[] | undefined;\n}\n\ninterface PublicKeyCredentialCreationOptions {\n    attestation?: AttestationConveyancePreference;\n    authenticatorSelection?: AuthenticatorSelectionCriteria;\n    challenge: BufferSource;\n    excludeCredentials?: PublicKeyCredentialDescriptor[];\n    extensions?: AuthenticationExtensionsClientInputs;\n    pubKeyCredParams: PublicKeyCredentialParameters[];\n    rp: PublicKeyCredentialRpEntity;\n    timeout?: number;\n    user: PublicKeyCredentialUserEntity;\n}\n\ninterface PublicKeyCredentialDescriptor {\n    id: BufferSource;\n    transports?: AuthenticatorTransport[];\n    type: PublicKeyCredentialType;\n}\n\ninterface PublicKeyCredentialEntity {\n    name: string;\n}\n\ninterface PublicKeyCredentialParameters {\n    alg: COSEAlgorithmIdentifier;\n    type: PublicKeyCredentialType;\n}\n\ninterface PublicKeyCredentialRequestOptions {\n    allowCredentials?: PublicKeyCredentialDescriptor[];\n    challenge: BufferSource;\n    extensions?: AuthenticationExtensionsClientInputs;\n    rpId?: string;\n    timeout?: number;\n    userVerification?: UserVerificationRequirement;\n}\n\ninterface PublicKeyCredentialRpEntity extends PublicKeyCredentialEntity {\n    id?: string;\n}\n\ninterface PublicKeyCredentialUserEntity extends PublicKeyCredentialEntity {\n    displayName: string;\n    id: BufferSource;\n}\n\ninterface PushSubscriptionJSON {\n    endpoint?: string;\n    expirationTime?: EpochTimeStamp | null;\n    keys?: Record<string, string>;\n}\n\ninterface PushSubscriptionOptionsInit {\n    applicationServerKey?: BufferSource | string | null;\n    userVisibleOnly?: boolean;\n}\n\ninterface QueuingStrategy<T = any> {\n    highWaterMark?: number;\n    size?: QueuingStrategySize<T>;\n}\n\ninterface QueuingStrategyInit {\n    /**\n     * Creates a new ByteLengthQueuingStrategy with the provided high water mark.\n     *\n     * Note that the provided high water mark will not be validated ahead of time. Instead, if it is negative, NaN, or not a number, the resulting ByteLengthQueuingStrategy will cause the corresponding stream constructor to throw.\n     */\n    highWaterMark: number;\n}\n\ninterface RTCAnswerOptions extends RTCOfferAnswerOptions {\n}\n\ninterface RTCCertificateExpiration {\n    expires?: number;\n}\n\ninterface RTCConfiguration {\n    bundlePolicy?: RTCBundlePolicy;\n    certificates?: RTCCertificate[];\n    iceCandidatePoolSize?: number;\n    iceServers?: RTCIceServer[];\n    iceTransportPolicy?: RTCIceTransportPolicy;\n    rtcpMuxPolicy?: RTCRtcpMuxPolicy;\n}\n\ninterface RTCDTMFToneChangeEventInit extends EventInit {\n    tone?: string;\n}\n\ninterface RTCDataChannelEventInit extends EventInit {\n    channel: RTCDataChannel;\n}\n\ninterface RTCDataChannelInit {\n    id?: number;\n    maxPacketLifeTime?: number;\n    maxRetransmits?: number;\n    negotiated?: boolean;\n    ordered?: boolean;\n    protocol?: string;\n}\n\ninterface RTCDtlsFingerprint {\n    algorithm?: string;\n    value?: string;\n}\n\ninterface RTCEncodedAudioFrameMetadata {\n    contributingSources?: number[];\n    synchronizationSource?: number;\n}\n\ninterface RTCEncodedVideoFrameMetadata {\n    contributingSources?: number[];\n    dependencies?: number[];\n    frameId?: number;\n    height?: number;\n    spatialIndex?: number;\n    synchronizationSource?: number;\n    temporalIndex?: number;\n    width?: number;\n}\n\ninterface RTCErrorEventInit extends EventInit {\n    error: RTCError;\n}\n\ninterface RTCErrorInit {\n    errorDetail: RTCErrorDetailType;\n    httpRequestStatusCode?: number;\n    receivedAlert?: number;\n    sctpCauseCode?: number;\n    sdpLineNumber?: number;\n    sentAlert?: number;\n}\n\ninterface RTCIceCandidateInit {\n    candidate?: string;\n    sdpMLineIndex?: number | null;\n    sdpMid?: string | null;\n    usernameFragment?: string | null;\n}\n\ninterface RTCIceCandidatePairStats extends RTCStats {\n    availableIncomingBitrate?: number;\n    availableOutgoingBitrate?: number;\n    bytesReceived?: number;\n    bytesSent?: number;\n    currentRoundTripTime?: number;\n    lastPacketReceivedTimestamp?: DOMHighResTimeStamp;\n    lastPacketSentTimestamp?: DOMHighResTimeStamp;\n    localCandidateId: string;\n    nominated?: boolean;\n    remoteCandidateId: string;\n    requestsReceived?: number;\n    requestsSent?: number;\n    responsesReceived?: number;\n    responsesSent?: number;\n    state: RTCStatsIceCandidatePairState;\n    totalRoundTripTime?: number;\n    transportId: string;\n}\n\ninterface RTCIceServer {\n    credential?: string;\n    urls: string | string[];\n    username?: string;\n}\n\ninterface RTCInboundRtpStreamStats extends RTCReceivedRtpStreamStats {\n    audioLevel?: number;\n    bytesReceived?: number;\n    concealedSamples?: number;\n    concealmentEvents?: number;\n    decoderImplementation?: string;\n    estimatedPlayoutTimestamp?: DOMHighResTimeStamp;\n    fecPacketsDiscarded?: number;\n    fecPacketsReceived?: number;\n    firCount?: number;\n    frameHeight?: number;\n    frameWidth?: number;\n    framesDecoded?: number;\n    framesDropped?: number;\n    framesPerSecond?: number;\n    framesReceived?: number;\n    headerBytesReceived?: number;\n    insertedSamplesForDeceleration?: number;\n    jitterBufferDelay?: number;\n    jitterBufferEmittedCount?: number;\n    keyFramesDecoded?: number;\n    kind: string;\n    lastPacketReceivedTimestamp?: DOMHighResTimeStamp;\n    nackCount?: number;\n    packetsDiscarded?: number;\n    pliCount?: number;\n    qpSum?: number;\n    remoteId?: string;\n    removedSamplesForAcceleration?: number;\n    silentConcealedSamples?: number;\n    totalAudioEnergy?: number;\n    totalDecodeTime?: number;\n    totalInterFrameDelay?: number;\n    totalProcessingDelay?: number;\n    totalSamplesDuration?: number;\n    totalSamplesReceived?: number;\n    totalSquaredInterFrameDelay?: number;\n}\n\ninterface RTCLocalSessionDescriptionInit {\n    sdp?: string;\n    type?: RTCSdpType;\n}\n\ninterface RTCOfferAnswerOptions {\n}\n\ninterface RTCOfferOptions extends RTCOfferAnswerOptions {\n    iceRestart?: boolean;\n    offerToReceiveAudio?: boolean;\n    offerToReceiveVideo?: boolean;\n}\n\ninterface RTCOutboundRtpStreamStats extends RTCSentRtpStreamStats {\n    firCount?: number;\n    frameHeight?: number;\n    frameWidth?: number;\n    framesEncoded?: number;\n    framesPerSecond?: number;\n    framesSent?: number;\n    headerBytesSent?: number;\n    hugeFramesSent?: number;\n    keyFramesEncoded?: number;\n    mediaSourceId?: string;\n    nackCount?: number;\n    pliCount?: number;\n    qpSum?: number;\n    qualityLimitationResolutionChanges?: number;\n    remoteId?: string;\n    retransmittedBytesSent?: number;\n    retransmittedPacketsSent?: number;\n    rid?: string;\n    targetBitrate?: number;\n    totalEncodeTime?: number;\n    totalEncodedBytesTarget?: number;\n    totalPacketSendDelay?: number;\n}\n\ninterface RTCPeerConnectionIceErrorEventInit extends EventInit {\n    address?: string | null;\n    errorCode: number;\n    errorText?: string;\n    port?: number | null;\n    url?: string;\n}\n\ninterface RTCPeerConnectionIceEventInit extends EventInit {\n    candidate?: RTCIceCandidate | null;\n    url?: string | null;\n}\n\ninterface RTCReceivedRtpStreamStats extends RTCRtpStreamStats {\n    jitter?: number;\n    packetsLost?: number;\n    packetsReceived?: number;\n}\n\ninterface RTCRtcpParameters {\n    cname?: string;\n    reducedSize?: boolean;\n}\n\ninterface RTCRtpCapabilities {\n    codecs: RTCRtpCodecCapability[];\n    headerExtensions: RTCRtpHeaderExtensionCapability[];\n}\n\ninterface RTCRtpCodecCapability {\n    channels?: number;\n    clockRate: number;\n    mimeType: string;\n    sdpFmtpLine?: string;\n}\n\ninterface RTCRtpCodecParameters {\n    channels?: number;\n    clockRate: number;\n    mimeType: string;\n    payloadType: number;\n    sdpFmtpLine?: string;\n}\n\ninterface RTCRtpCodingParameters {\n    rid?: string;\n}\n\ninterface RTCRtpContributingSource {\n    audioLevel?: number;\n    rtpTimestamp: number;\n    source: number;\n    timestamp: DOMHighResTimeStamp;\n}\n\ninterface RTCRtpEncodingParameters extends RTCRtpCodingParameters {\n    active?: boolean;\n    maxBitrate?: number;\n    maxFramerate?: number;\n    networkPriority?: RTCPriorityType;\n    priority?: RTCPriorityType;\n    scaleResolutionDownBy?: number;\n}\n\ninterface RTCRtpHeaderExtensionCapability {\n    uri?: string;\n}\n\ninterface RTCRtpHeaderExtensionParameters {\n    encrypted?: boolean;\n    id: number;\n    uri: string;\n}\n\ninterface RTCRtpParameters {\n    codecs: RTCRtpCodecParameters[];\n    headerExtensions: RTCRtpHeaderExtensionParameters[];\n    rtcp: RTCRtcpParameters;\n}\n\ninterface RTCRtpReceiveParameters extends RTCRtpParameters {\n}\n\ninterface RTCRtpSendParameters extends RTCRtpParameters {\n    degradationPreference?: RTCDegradationPreference;\n    encodings: RTCRtpEncodingParameters[];\n    transactionId: string;\n}\n\ninterface RTCRtpStreamStats extends RTCStats {\n    codecId?: string;\n    kind: string;\n    ssrc: number;\n    transportId?: string;\n}\n\ninterface RTCRtpSynchronizationSource extends RTCRtpContributingSource {\n}\n\ninterface RTCRtpTransceiverInit {\n    direction?: RTCRtpTransceiverDirection;\n    sendEncodings?: RTCRtpEncodingParameters[];\n    streams?: MediaStream[];\n}\n\ninterface RTCSentRtpStreamStats extends RTCRtpStreamStats {\n    bytesSent?: number;\n    packetsSent?: number;\n}\n\ninterface RTCSessionDescriptionInit {\n    sdp?: string;\n    type: RTCSdpType;\n}\n\ninterface RTCStats {\n    id: string;\n    timestamp: DOMHighResTimeStamp;\n    type: RTCStatsType;\n}\n\ninterface RTCTrackEventInit extends EventInit {\n    receiver: RTCRtpReceiver;\n    streams?: MediaStream[];\n    track: MediaStreamTrack;\n    transceiver: RTCRtpTransceiver;\n}\n\ninterface RTCTransportStats extends RTCStats {\n    bytesReceived?: number;\n    bytesSent?: number;\n    dtlsCipher?: string;\n    dtlsState: RTCDtlsTransportState;\n    localCertificateId?: string;\n    remoteCertificateId?: string;\n    selectedCandidatePairId?: string;\n    srtpCipher?: string;\n    tlsVersion?: string;\n}\n\ninterface ReadableStreamGetReaderOptions {\n    /**\n     * Creates a ReadableStreamBYOBReader and locks the stream to the new reader.\n     *\n     * This call behaves the same way as the no-argument variant, except that it only works on readable byte streams, i.e. streams which were constructed specifically with the ability to handle \"bring your own buffer\" reading. The returned BYOB reader provides the ability to directly read individual chunks from the stream via its read() method, into developer-supplied buffers, allowing more precise control over allocation.\n     */\n    mode?: ReadableStreamReaderMode;\n}\n\ninterface ReadableStreamReadDoneResult<T> {\n    done: true;\n    value?: T;\n}\n\ninterface ReadableStreamReadValueResult<T> {\n    done: false;\n    value: T;\n}\n\ninterface ReadableWritablePair<R = any, W = any> {\n    readable: ReadableStream<R>;\n    /**\n     * Provides a convenient, chainable way of piping this readable stream through a transform stream (or any other { writable, readable } pair). It simply pipes the stream into the writable side of the supplied pair, and returns the readable side for further use.\n     *\n     * Piping a stream will lock it for the duration of the pipe, preventing any other consumer from acquiring a reader.\n     */\n    writable: WritableStream<W>;\n}\n\ninterface RegistrationOptions {\n    scope?: string;\n    type?: WorkerType;\n    updateViaCache?: ServiceWorkerUpdateViaCache;\n}\n\ninterface RequestInit {\n    /** A BodyInit object or null to set request's body. */\n    body?: BodyInit | null;\n    /** A string indicating how the request will interact with the browser's cache to set request's cache. */\n    cache?: RequestCache;\n    /** A string indicating whether credentials will be sent with the request always, never, or only when sent to a same-origin URL. Sets request's credentials. */\n    credentials?: RequestCredentials;\n    /** A Headers object, an object literal, or an array of two-item arrays to set request's headers. */\n    headers?: HeadersInit;\n    /** A cryptographic hash of the resource to be fetched by request. Sets request's integrity. */\n    integrity?: string;\n    /** A boolean to set request's keepalive. */\n    keepalive?: boolean;\n    /** A string to set request's method. */\n    method?: string;\n    /** A string to indicate whether the request will use CORS, or will be restricted to same-origin URLs. Sets request's mode. */\n    mode?: RequestMode;\n    /** A string indicating whether request follows redirects, results in an error upon encountering a redirect, or returns the redirect (in an opaque fashion). Sets request's redirect. */\n    redirect?: RequestRedirect;\n    /** A string whose value is a same-origin URL, \"about:client\", or the empty string, to set request's referrer. */\n    referrer?: string;\n    /** A referrer policy to set request's referrerPolicy. */\n    referrerPolicy?: ReferrerPolicy;\n    /** An AbortSignal to set request's signal. */\n    signal?: AbortSignal | null;\n    /** Can only be null. Used to disassociate request from any Window. */\n    window?: null;\n}\n\ninterface ResizeObserverOptions {\n    box?: ResizeObserverBoxOptions;\n}\n\ninterface ResponseInit {\n    headers?: HeadersInit;\n    status?: number;\n    statusText?: string;\n}\n\ninterface RsaHashedImportParams extends Algorithm {\n    hash: HashAlgorithmIdentifier;\n}\n\ninterface RsaHashedKeyAlgorithm extends RsaKeyAlgorithm {\n    hash: KeyAlgorithm;\n}\n\ninterface RsaHashedKeyGenParams extends RsaKeyGenParams {\n    hash: HashAlgorithmIdentifier;\n}\n\ninterface RsaKeyAlgorithm extends KeyAlgorithm {\n    modulusLength: number;\n    publicExponent: BigInteger;\n}\n\ninterface RsaKeyGenParams extends Algorithm {\n    modulusLength: number;\n    publicExponent: BigInteger;\n}\n\ninterface RsaOaepParams extends Algorithm {\n    label?: BufferSource;\n}\n\ninterface RsaOtherPrimesInfo {\n    d?: string;\n    r?: string;\n    t?: string;\n}\n\ninterface RsaPssParams extends Algorithm {\n    saltLength: number;\n}\n\ninterface SVGBoundingBoxOptions {\n    clipped?: boolean;\n    fill?: boolean;\n    markers?: boolean;\n    stroke?: boolean;\n}\n\ninterface ScrollIntoViewOptions extends ScrollOptions {\n    block?: ScrollLogicalPosition;\n    inline?: ScrollLogicalPosition;\n}\n\ninterface ScrollOptions {\n    behavior?: ScrollBehavior;\n}\n\ninterface ScrollToOptions extends ScrollOptions {\n    left?: number;\n    top?: number;\n}\n\ninterface SecurityPolicyViolationEventInit extends EventInit {\n    blockedURI?: string;\n    columnNumber?: number;\n    disposition: SecurityPolicyViolationEventDisposition;\n    documentURI: string;\n    effectiveDirective: string;\n    lineNumber?: number;\n    originalPolicy: string;\n    referrer?: string;\n    sample?: string;\n    sourceFile?: string;\n    statusCode: number;\n    violatedDirective: string;\n}\n\ninterface ShadowRootInit {\n    delegatesFocus?: boolean;\n    mode: ShadowRootMode;\n    slotAssignment?: SlotAssignmentMode;\n}\n\ninterface ShareData {\n    files?: File[];\n    text?: string;\n    title?: string;\n    url?: string;\n}\n\ninterface SpeechSynthesisErrorEventInit extends SpeechSynthesisEventInit {\n    error: SpeechSynthesisErrorCode;\n}\n\ninterface SpeechSynthesisEventInit extends EventInit {\n    charIndex?: number;\n    charLength?: number;\n    elapsedTime?: number;\n    name?: string;\n    utterance: SpeechSynthesisUtterance;\n}\n\ninterface StaticRangeInit {\n    endContainer: Node;\n    endOffset: number;\n    startContainer: Node;\n    startOffset: number;\n}\n\ninterface StereoPannerOptions extends AudioNodeOptions {\n    pan?: number;\n}\n\ninterface StorageEstimate {\n    quota?: number;\n    usage?: number;\n}\n\ninterface StorageEventInit extends EventInit {\n    key?: string | null;\n    newValue?: string | null;\n    oldValue?: string | null;\n    storageArea?: Storage | null;\n    url?: string;\n}\n\ninterface StreamPipeOptions {\n    preventAbort?: boolean;\n    preventCancel?: boolean;\n    /**\n     * Pipes this readable stream to a given writable stream destination. The way in which the piping process behaves under various error conditions can be customized with a number of passed options. It returns a promise that fulfills when the piping process completes successfully, or rejects if any errors were encountered.\n     *\n     * Piping a stream will lock it for the duration of the pipe, preventing any other consumer from acquiring a reader.\n     *\n     * Errors and closures of the source and destination streams propagate as follows:\n     *\n     * An error in this source readable stream will abort destination, unless preventAbort is truthy. The returned promise will be rejected with the source's error, or with any error that occurs during aborting the destination.\n     *\n     * An error in destination will cancel this source readable stream, unless preventCancel is truthy. The returned promise will be rejected with the destination's error, or with any error that occurs during canceling the source.\n     *\n     * When this source readable stream closes, destination will be closed, unless preventClose is truthy. The returned promise will be fulfilled once this process completes, unless an error is encountered while closing the destination, in which case it will be rejected with that error.\n     *\n     * If destination starts out closed or closing, this source readable stream will be canceled, unless preventCancel is true. The returned promise will be rejected with an error indicating piping to a closed stream failed, or with any error that occurs during canceling the source.\n     *\n     * The signal option can be set to an AbortSignal to allow aborting an ongoing pipe operation via the corresponding AbortController. In this case, this source readable stream will be canceled, and destination aborted, unless the respective options preventCancel or preventAbort are set.\n     */\n    preventClose?: boolean;\n    signal?: AbortSignal;\n}\n\ninterface StructuredSerializeOptions {\n    transfer?: Transferable[];\n}\n\ninterface SubmitEventInit extends EventInit {\n    submitter?: HTMLElement | null;\n}\n\ninterface TextDecodeOptions {\n    stream?: boolean;\n}\n\ninterface TextDecoderOptions {\n    fatal?: boolean;\n    ignoreBOM?: boolean;\n}\n\ninterface TextEncoderEncodeIntoResult {\n    read?: number;\n    written?: number;\n}\n\ninterface TouchEventInit extends EventModifierInit {\n    changedTouches?: Touch[];\n    targetTouches?: Touch[];\n    touches?: Touch[];\n}\n\ninterface TouchInit {\n    altitudeAngle?: number;\n    azimuthAngle?: number;\n    clientX?: number;\n    clientY?: number;\n    force?: number;\n    identifier: number;\n    pageX?: number;\n    pageY?: number;\n    radiusX?: number;\n    radiusY?: number;\n    rotationAngle?: number;\n    screenX?: number;\n    screenY?: number;\n    target: EventTarget;\n    touchType?: TouchType;\n}\n\ninterface TrackEventInit extends EventInit {\n    track?: TextTrack | null;\n}\n\ninterface Transformer<I = any, O = any> {\n    flush?: TransformerFlushCallback<O>;\n    readableType?: undefined;\n    start?: TransformerStartCallback<O>;\n    transform?: TransformerTransformCallback<I, O>;\n    writableType?: undefined;\n}\n\ninterface TransitionEventInit extends EventInit {\n    elapsedTime?: number;\n    propertyName?: string;\n    pseudoElement?: string;\n}\n\ninterface UIEventInit extends EventInit {\n    detail?: number;\n    view?: Window | null;\n    /** @deprecated */\n    which?: number;\n}\n\ninterface ULongRange {\n    max?: number;\n    min?: number;\n}\n\ninterface UnderlyingByteSource {\n    autoAllocateChunkSize?: number;\n    cancel?: UnderlyingSourceCancelCallback;\n    pull?: (controller: ReadableByteStreamController) => void | PromiseLike<void>;\n    start?: (controller: ReadableByteStreamController) => any;\n    type: \"bytes\";\n}\n\ninterface UnderlyingDefaultSource<R = any> {\n    cancel?: UnderlyingSourceCancelCallback;\n    pull?: (controller: ReadableStreamDefaultController<R>) => void | PromiseLike<void>;\n    start?: (controller: ReadableStreamDefaultController<R>) => any;\n    type?: undefined;\n}\n\ninterface UnderlyingSink<W = any> {\n    abort?: UnderlyingSinkAbortCallback;\n    close?: UnderlyingSinkCloseCallback;\n    start?: UnderlyingSinkStartCallback;\n    type?: undefined;\n    write?: UnderlyingSinkWriteCallback<W>;\n}\n\ninterface UnderlyingSource<R = any> {\n    autoAllocateChunkSize?: number;\n    cancel?: UnderlyingSourceCancelCallback;\n    pull?: UnderlyingSourcePullCallback<R>;\n    start?: UnderlyingSourceStartCallback<R>;\n    type?: ReadableStreamType;\n}\n\ninterface ValidityStateFlags {\n    badInput?: boolean;\n    customError?: boolean;\n    patternMismatch?: boolean;\n    rangeOverflow?: boolean;\n    rangeUnderflow?: boolean;\n    stepMismatch?: boolean;\n    tooLong?: boolean;\n    tooShort?: boolean;\n    typeMismatch?: boolean;\n    valueMissing?: boolean;\n}\n\ninterface VideoColorSpaceInit {\n    fullRange?: boolean | null;\n    matrix?: VideoMatrixCoefficients | null;\n    primaries?: VideoColorPrimaries | null;\n    transfer?: VideoTransferCharacteristics | null;\n}\n\ninterface VideoConfiguration {\n    bitrate: number;\n    colorGamut?: ColorGamut;\n    contentType: string;\n    framerate: number;\n    hdrMetadataType?: HdrMetadataType;\n    height: number;\n    scalabilityMode?: string;\n    transferFunction?: TransferFunction;\n    width: number;\n}\n\ninterface VideoFrameCallbackMetadata {\n    captureTime?: DOMHighResTimeStamp;\n    expectedDisplayTime: DOMHighResTimeStamp;\n    height: number;\n    mediaTime: number;\n    presentationTime: DOMHighResTimeStamp;\n    presentedFrames: number;\n    processingDuration?: number;\n    receiveTime?: DOMHighResTimeStamp;\n    rtpTimestamp?: number;\n    width: number;\n}\n\ninterface WaveShaperOptions extends AudioNodeOptions {\n    curve?: number[] | Float32Array;\n    oversample?: OverSampleType;\n}\n\ninterface WebGLContextAttributes {\n    alpha?: boolean;\n    antialias?: boolean;\n    depth?: boolean;\n    desynchronized?: boolean;\n    failIfMajorPerformanceCaveat?: boolean;\n    powerPreference?: WebGLPowerPreference;\n    premultipliedAlpha?: boolean;\n    preserveDrawingBuffer?: boolean;\n    stencil?: boolean;\n}\n\ninterface WebGLContextEventInit extends EventInit {\n    statusMessage?: string;\n}\n\ninterface WheelEventInit extends MouseEventInit {\n    deltaMode?: number;\n    deltaX?: number;\n    deltaY?: number;\n    deltaZ?: number;\n}\n\ninterface WindowPostMessageOptions extends StructuredSerializeOptions {\n    targetOrigin?: string;\n}\n\ninterface WorkerOptions {\n    credentials?: RequestCredentials;\n    name?: string;\n    type?: WorkerType;\n}\n\ninterface WorkletOptions {\n    credentials?: RequestCredentials;\n}\n\ntype NodeFilter = ((node: Node) => number) | { acceptNode(node: Node): number; };\n\ndeclare var NodeFilter: {\n    readonly FILTER_ACCEPT: 1;\n    readonly FILTER_REJECT: 2;\n    readonly FILTER_SKIP: 3;\n    readonly SHOW_ALL: 0xFFFFFFFF;\n    readonly SHOW_ELEMENT: 0x1;\n    readonly SHOW_ATTRIBUTE: 0x2;\n    readonly SHOW_TEXT: 0x4;\n    readonly SHOW_CDATA_SECTION: 0x8;\n    readonly SHOW_ENTITY_REFERENCE: 0x10;\n    readonly SHOW_ENTITY: 0x20;\n    readonly SHOW_PROCESSING_INSTRUCTION: 0x40;\n    readonly SHOW_COMMENT: 0x80;\n    readonly SHOW_DOCUMENT: 0x100;\n    readonly SHOW_DOCUMENT_TYPE: 0x200;\n    readonly SHOW_DOCUMENT_FRAGMENT: 0x400;\n    readonly SHOW_NOTATION: 0x800;\n};\n\ntype XPathNSResolver = ((prefix: string | null) => string | null) | { lookupNamespaceURI(prefix: string | null): string | null; };\n\n/** The ANGLE_instanced_arrays extension is part of the WebGL API and allows to draw the same object, or groups of similar objects multiple times, if they share the same vertex data, primitive count and type. */\ninterface ANGLE_instanced_arrays {\n    drawArraysInstancedANGLE(mode: GLenum, first: GLint, count: GLsizei, primcount: GLsizei): void;\n    drawElementsInstancedANGLE(mode: GLenum, count: GLsizei, type: GLenum, offset: GLintptr, primcount: GLsizei): void;\n    vertexAttribDivisorANGLE(index: GLuint, divisor: GLuint): void;\n    readonly VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE: 0x88FE;\n}\n\ninterface ARIAMixin {\n    ariaAtomic: string | null;\n    ariaAutoComplete: string | null;\n    ariaBusy: string | null;\n    ariaChecked: string | null;\n    ariaColCount: string | null;\n    ariaColIndex: string | null;\n    ariaColSpan: string | null;\n    ariaCurrent: string | null;\n    ariaDisabled: string | null;\n    ariaExpanded: string | null;\n    ariaHasPopup: string | null;\n    ariaHidden: string | null;\n    ariaInvalid: string | null;\n    ariaKeyShortcuts: string | null;\n    ariaLabel: string | null;\n    ariaLevel: string | null;\n    ariaLive: string | null;\n    ariaModal: string | null;\n    ariaMultiLine: string | null;\n    ariaMultiSelectable: string | null;\n    ariaOrientation: string | null;\n    ariaPlaceholder: string | null;\n    ariaPosInSet: string | null;\n    ariaPressed: string | null;\n    ariaReadOnly: string | null;\n    ariaRequired: string | null;\n    ariaRoleDescription: string | null;\n    ariaRowCount: string | null;\n    ariaRowIndex: string | null;\n    ariaRowSpan: string | null;\n    ariaSelected: string | null;\n    ariaSetSize: string | null;\n    ariaSort: string | null;\n    ariaValueMax: string | null;\n    ariaValueMin: string | null;\n    ariaValueNow: string | null;\n    ariaValueText: string | null;\n    role: string | null;\n}\n\n/** A controller object that allows you to abort one or more DOM requests as and when desired. */\ninterface AbortController {\n    /** Returns the AbortSignal object associated with this object. */\n    readonly signal: AbortSignal;\n    /** Invoking this method will set this object's AbortSignal's aborted flag and signal to any observers that the associated activity is to be aborted. */\n    abort(reason?: any): void;\n}\n\ndeclare var AbortController: {\n    prototype: AbortController;\n    new(): AbortController;\n};\n\ninterface AbortSignalEventMap {\n    \"abort\": Event;\n}\n\n/** A signal object that allows you to communicate with a DOM request (such as a Fetch) and abort it if required via an AbortController object. */\ninterface AbortSignal extends EventTarget {\n    /** Returns true if this AbortSignal's AbortController has signaled to abort, and false otherwise. */\n    readonly aborted: boolean;\n    onabort: ((this: AbortSignal, ev: Event) => any) | null;\n    readonly reason: any;\n    throwIfAborted(): void;\n    addEventListener<K extends keyof AbortSignalEventMap>(type: K, listener: (this: AbortSignal, ev: AbortSignalEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof AbortSignalEventMap>(type: K, listener: (this: AbortSignal, ev: AbortSignalEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var AbortSignal: {\n    prototype: AbortSignal;\n    new(): AbortSignal;\n    abort(reason?: any): AbortSignal;\n    timeout(milliseconds: number): AbortSignal;\n};\n\ninterface AbstractRange {\n    /** Returns true if range is collapsed, and false otherwise. */\n    readonly collapsed: boolean;\n    /** Returns range's end node. */\n    readonly endContainer: Node;\n    /** Returns range's end offset. */\n    readonly endOffset: number;\n    /** Returns range's start node. */\n    readonly startContainer: Node;\n    /** Returns range's start offset. */\n    readonly startOffset: number;\n}\n\ndeclare var AbstractRange: {\n    prototype: AbstractRange;\n    new(): AbstractRange;\n};\n\ninterface AbstractWorkerEventMap {\n    \"error\": ErrorEvent;\n}\n\ninterface AbstractWorker {\n    onerror: ((this: AbstractWorker, ev: ErrorEvent) => any) | null;\n    addEventListener<K extends keyof AbstractWorkerEventMap>(type: K, listener: (this: AbstractWorker, ev: AbstractWorkerEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof AbstractWorkerEventMap>(type: K, listener: (this: AbstractWorker, ev: AbstractWorkerEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\n/** A node able to provide real-time frequency and time-domain analysis information. It is an AudioNode that passes the audio stream unchanged from the input to the output, but allows you to take the generated data, process it, and create audio visualizations. */\ninterface AnalyserNode extends AudioNode {\n    fftSize: number;\n    readonly frequencyBinCount: number;\n    maxDecibels: number;\n    minDecibels: number;\n    smoothingTimeConstant: number;\n    getByteFrequencyData(array: Uint8Array): void;\n    getByteTimeDomainData(array: Uint8Array): void;\n    getFloatFrequencyData(array: Float32Array): void;\n    getFloatTimeDomainData(array: Float32Array): void;\n}\n\ndeclare var AnalyserNode: {\n    prototype: AnalyserNode;\n    new(context: BaseAudioContext, options?: AnalyserOptions): AnalyserNode;\n};\n\ninterface Animatable {\n    animate(keyframes: Keyframe[] | PropertyIndexedKeyframes | null, options?: number | KeyframeAnimationOptions): Animation;\n    getAnimations(options?: GetAnimationsOptions): Animation[];\n}\n\ninterface AnimationEventMap {\n    \"cancel\": AnimationPlaybackEvent;\n    \"finish\": AnimationPlaybackEvent;\n    \"remove\": Event;\n}\n\ninterface Animation extends EventTarget {\n    currentTime: CSSNumberish | null;\n    effect: AnimationEffect | null;\n    readonly finished: Promise<Animation>;\n    id: string;\n    oncancel: ((this: Animation, ev: AnimationPlaybackEvent) => any) | null;\n    onfinish: ((this: Animation, ev: AnimationPlaybackEvent) => any) | null;\n    onremove: ((this: Animation, ev: Event) => any) | null;\n    readonly pending: boolean;\n    readonly playState: AnimationPlayState;\n    playbackRate: number;\n    readonly ready: Promise<Animation>;\n    readonly replaceState: AnimationReplaceState;\n    startTime: CSSNumberish | null;\n    timeline: AnimationTimeline | null;\n    cancel(): void;\n    commitStyles(): void;\n    finish(): void;\n    pause(): void;\n    persist(): void;\n    play(): void;\n    reverse(): void;\n    updatePlaybackRate(playbackRate: number): void;\n    addEventListener<K extends keyof AnimationEventMap>(type: K, listener: (this: Animation, ev: AnimationEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof AnimationEventMap>(type: K, listener: (this: Animation, ev: AnimationEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var Animation: {\n    prototype: Animation;\n    new(effect?: AnimationEffect | null, timeline?: AnimationTimeline | null): Animation;\n};\n\ninterface AnimationEffect {\n    getComputedTiming(): ComputedEffectTiming;\n    getTiming(): EffectTiming;\n    updateTiming(timing?: OptionalEffectTiming): void;\n}\n\ndeclare var AnimationEffect: {\n    prototype: AnimationEffect;\n    new(): AnimationEffect;\n};\n\n/** Events providing information related to animations. */\ninterface AnimationEvent extends Event {\n    readonly animationName: string;\n    readonly elapsedTime: number;\n    readonly pseudoElement: string;\n}\n\ndeclare var AnimationEvent: {\n    prototype: AnimationEvent;\n    new(type: string, animationEventInitDict?: AnimationEventInit): AnimationEvent;\n};\n\ninterface AnimationFrameProvider {\n    cancelAnimationFrame(handle: number): void;\n    requestAnimationFrame(callback: FrameRequestCallback): number;\n}\n\ninterface AnimationPlaybackEvent extends Event {\n    readonly currentTime: CSSNumberish | null;\n    readonly timelineTime: CSSNumberish | null;\n}\n\ndeclare var AnimationPlaybackEvent: {\n    prototype: AnimationPlaybackEvent;\n    new(type: string, eventInitDict?: AnimationPlaybackEventInit): AnimationPlaybackEvent;\n};\n\ninterface AnimationTimeline {\n    readonly currentTime: number | null;\n}\n\ndeclare var AnimationTimeline: {\n    prototype: AnimationTimeline;\n    new(): AnimationTimeline;\n};\n\n/** A DOM element's attribute as an object. In most DOM methods, you will probably directly retrieve the attribute as a string (e.g., Element.getAttribute(), but certain functions (e.g., Element.getAttributeNode()) or means of iterating give Attr types. */\ninterface Attr extends Node {\n    readonly localName: string;\n    readonly name: string;\n    readonly namespaceURI: string | null;\n    readonly ownerDocument: Document;\n    readonly ownerElement: Element | null;\n    readonly prefix: string | null;\n    /** @deprecated */\n    readonly specified: boolean;\n    value: string;\n}\n\ndeclare var Attr: {\n    prototype: Attr;\n    new(): Attr;\n};\n\n/** A short audio asset residing in memory, created from an audio file using the AudioContext.decodeAudioData() method, or from raw data using AudioContext.createBuffer(). Once put into an AudioBuffer, the audio can then be played by being passed into an AudioBufferSourceNode. */\ninterface AudioBuffer {\n    readonly duration: number;\n    readonly length: number;\n    readonly numberOfChannels: number;\n    readonly sampleRate: number;\n    copyFromChannel(destination: Float32Array, channelNumber: number, bufferOffset?: number): void;\n    copyToChannel(source: Float32Array, channelNumber: number, bufferOffset?: number): void;\n    getChannelData(channel: number): Float32Array;\n}\n\ndeclare var AudioBuffer: {\n    prototype: AudioBuffer;\n    new(options: AudioBufferOptions): AudioBuffer;\n};\n\n/** An AudioScheduledSourceNode which represents an audio source consisting of in-memory audio data, stored in an AudioBuffer. It's especially useful for playing back audio which has particularly stringent timing accuracy requirements, such as for sounds that must match a specific rhythm and can be kept in memory rather than being played from disk or the network. */\ninterface AudioBufferSourceNode extends AudioScheduledSourceNode {\n    buffer: AudioBuffer | null;\n    readonly detune: AudioParam;\n    loop: boolean;\n    loopEnd: number;\n    loopStart: number;\n    readonly playbackRate: AudioParam;\n    start(when?: number, offset?: number, duration?: number): void;\n    addEventListener<K extends keyof AudioScheduledSourceNodeEventMap>(type: K, listener: (this: AudioBufferSourceNode, ev: AudioScheduledSourceNodeEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof AudioScheduledSourceNodeEventMap>(type: K, listener: (this: AudioBufferSourceNode, ev: AudioScheduledSourceNodeEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var AudioBufferSourceNode: {\n    prototype: AudioBufferSourceNode;\n    new(context: BaseAudioContext, options?: AudioBufferSourceOptions): AudioBufferSourceNode;\n};\n\n/** An audio-processing graph built from audio modules linked together, each represented by an AudioNode. */\ninterface AudioContext extends BaseAudioContext {\n    readonly baseLatency: number;\n    readonly outputLatency: number;\n    close(): Promise<void>;\n    createMediaElementSource(mediaElement: HTMLMediaElement): MediaElementAudioSourceNode;\n    createMediaStreamDestination(): MediaStreamAudioDestinationNode;\n    createMediaStreamSource(mediaStream: MediaStream): MediaStreamAudioSourceNode;\n    getOutputTimestamp(): AudioTimestamp;\n    resume(): Promise<void>;\n    suspend(): Promise<void>;\n    addEventListener<K extends keyof BaseAudioContextEventMap>(type: K, listener: (this: AudioContext, ev: BaseAudioContextEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof BaseAudioContextEventMap>(type: K, listener: (this: AudioContext, ev: BaseAudioContextEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var AudioContext: {\n    prototype: AudioContext;\n    new(contextOptions?: AudioContextOptions): AudioContext;\n};\n\n/** AudioDestinationNode has no output (as it is the output, no more AudioNode can be linked after it in the audio graph) and one input. The number of channels in the input must be between 0 and the maxChannelCount value or an exception is raised. */\ninterface AudioDestinationNode extends AudioNode {\n    readonly maxChannelCount: number;\n}\n\ndeclare var AudioDestinationNode: {\n    prototype: AudioDestinationNode;\n    new(): AudioDestinationNode;\n};\n\n/** The position and orientation of the unique person listening to the audio scene, and is used in audio spatialization. All PannerNodes spatialize in relation to the AudioListener stored in the BaseAudioContext.listener attribute. */\ninterface AudioListener {\n    readonly forwardX: AudioParam;\n    readonly forwardY: AudioParam;\n    readonly forwardZ: AudioParam;\n    readonly positionX: AudioParam;\n    readonly positionY: AudioParam;\n    readonly positionZ: AudioParam;\n    readonly upX: AudioParam;\n    readonly upY: AudioParam;\n    readonly upZ: AudioParam;\n    /** @deprecated */\n    setOrientation(x: number, y: number, z: number, xUp: number, yUp: number, zUp: number): void;\n    /** @deprecated */\n    setPosition(x: number, y: number, z: number): void;\n}\n\ndeclare var AudioListener: {\n    prototype: AudioListener;\n    new(): AudioListener;\n};\n\n/** A generic interface for representing an audio processing module. Examples include: */\ninterface AudioNode extends EventTarget {\n    channelCount: number;\n    channelCountMode: ChannelCountMode;\n    channelInterpretation: ChannelInterpretation;\n    readonly context: BaseAudioContext;\n    readonly numberOfInputs: number;\n    readonly numberOfOutputs: number;\n    connect(destinationNode: AudioNode, output?: number, input?: number): AudioNode;\n    connect(destinationParam: AudioParam, output?: number): void;\n    disconnect(): void;\n    disconnect(output: number): void;\n    disconnect(destinationNode: AudioNode): void;\n    disconnect(destinationNode: AudioNode, output: number): void;\n    disconnect(destinationNode: AudioNode, output: number, input: number): void;\n    disconnect(destinationParam: AudioParam): void;\n    disconnect(destinationParam: AudioParam, output: number): void;\n}\n\ndeclare var AudioNode: {\n    prototype: AudioNode;\n    new(): AudioNode;\n};\n\n/** The Web Audio API's AudioParam interface represents an audio-related parameter, usually a parameter of an AudioNode (such as GainNode.gain). */\ninterface AudioParam {\n    automationRate: AutomationRate;\n    readonly defaultValue: number;\n    readonly maxValue: number;\n    readonly minValue: number;\n    value: number;\n    cancelAndHoldAtTime(cancelTime: number): AudioParam;\n    cancelScheduledValues(cancelTime: number): AudioParam;\n    exponentialRampToValueAtTime(value: number, endTime: number): AudioParam;\n    linearRampToValueAtTime(value: number, endTime: number): AudioParam;\n    setTargetAtTime(target: number, startTime: number, timeConstant: number): AudioParam;\n    setValueAtTime(value: number, startTime: number): AudioParam;\n    setValueCurveAtTime(values: number[] | Float32Array, startTime: number, duration: number): AudioParam;\n}\n\ndeclare var AudioParam: {\n    prototype: AudioParam;\n    new(): AudioParam;\n};\n\ninterface AudioParamMap {\n    forEach(callbackfn: (value: AudioParam, key: string, parent: AudioParamMap) => void, thisArg?: any): void;\n}\n\ndeclare var AudioParamMap: {\n    prototype: AudioParamMap;\n    new(): AudioParamMap;\n};\n\n/**\n * The Web Audio API events that occur when a ScriptProcessorNode input buffer is ready to be processed.\n * @deprecated As of the August 29 2014 Web Audio API spec publication, this feature has been marked as deprecated, and is soon to be replaced by AudioWorklet.\n */\ninterface AudioProcessingEvent extends Event {\n    /** @deprecated */\n    readonly inputBuffer: AudioBuffer;\n    /** @deprecated */\n    readonly outputBuffer: AudioBuffer;\n    /** @deprecated */\n    readonly playbackTime: number;\n}\n\n/** @deprecated */\ndeclare var AudioProcessingEvent: {\n    prototype: AudioProcessingEvent;\n    new(type: string, eventInitDict: AudioProcessingEventInit): AudioProcessingEvent;\n};\n\ninterface AudioScheduledSourceNodeEventMap {\n    \"ended\": Event;\n}\n\ninterface AudioScheduledSourceNode extends AudioNode {\n    onended: ((this: AudioScheduledSourceNode, ev: Event) => any) | null;\n    start(when?: number): void;\n    stop(when?: number): void;\n    addEventListener<K extends keyof AudioScheduledSourceNodeEventMap>(type: K, listener: (this: AudioScheduledSourceNode, ev: AudioScheduledSourceNodeEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof AudioScheduledSourceNodeEventMap>(type: K, listener: (this: AudioScheduledSourceNode, ev: AudioScheduledSourceNodeEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var AudioScheduledSourceNode: {\n    prototype: AudioScheduledSourceNode;\n    new(): AudioScheduledSourceNode;\n};\n\n/** Available only in secure contexts. */\ninterface AudioWorklet extends Worklet {\n}\n\ndeclare var AudioWorklet: {\n    prototype: AudioWorklet;\n    new(): AudioWorklet;\n};\n\ninterface AudioWorkletNodeEventMap {\n    \"processorerror\": Event;\n}\n\n/** Available only in secure contexts. */\ninterface AudioWorkletNode extends AudioNode {\n    onprocessorerror: ((this: AudioWorkletNode, ev: Event) => any) | null;\n    readonly parameters: AudioParamMap;\n    readonly port: MessagePort;\n    addEventListener<K extends keyof AudioWorkletNodeEventMap>(type: K, listener: (this: AudioWorkletNode, ev: AudioWorkletNodeEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof AudioWorkletNodeEventMap>(type: K, listener: (this: AudioWorkletNode, ev: AudioWorkletNodeEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var AudioWorkletNode: {\n    prototype: AudioWorkletNode;\n    new(context: BaseAudioContext, name: string, options?: AudioWorkletNodeOptions): AudioWorkletNode;\n};\n\n/** Available only in secure contexts. */\ninterface AuthenticatorAssertionResponse extends AuthenticatorResponse {\n    readonly authenticatorData: ArrayBuffer;\n    readonly signature: ArrayBuffer;\n    readonly userHandle: ArrayBuffer | null;\n}\n\ndeclare var AuthenticatorAssertionResponse: {\n    prototype: AuthenticatorAssertionResponse;\n    new(): AuthenticatorAssertionResponse;\n};\n\n/** Available only in secure contexts. */\ninterface AuthenticatorAttestationResponse extends AuthenticatorResponse {\n    readonly attestationObject: ArrayBuffer;\n    getAuthenticatorData(): ArrayBuffer;\n    getPublicKey(): ArrayBuffer | null;\n    getPublicKeyAlgorithm(): COSEAlgorithmIdentifier;\n    getTransports(): string[];\n}\n\ndeclare var AuthenticatorAttestationResponse: {\n    prototype: AuthenticatorAttestationResponse;\n    new(): AuthenticatorAttestationResponse;\n};\n\n/** Available only in secure contexts. */\ninterface AuthenticatorResponse {\n    readonly clientDataJSON: ArrayBuffer;\n}\n\ndeclare var AuthenticatorResponse: {\n    prototype: AuthenticatorResponse;\n    new(): AuthenticatorResponse;\n};\n\ninterface BarProp {\n    readonly visible: boolean;\n}\n\ndeclare var BarProp: {\n    prototype: BarProp;\n    new(): BarProp;\n};\n\ninterface BaseAudioContextEventMap {\n    \"statechange\": Event;\n}\n\ninterface BaseAudioContext extends EventTarget {\n    /** Available only in secure contexts. */\n    readonly audioWorklet: AudioWorklet;\n    readonly currentTime: number;\n    readonly destination: AudioDestinationNode;\n    readonly listener: AudioListener;\n    onstatechange: ((this: BaseAudioContext, ev: Event) => any) | null;\n    readonly sampleRate: number;\n    readonly state: AudioContextState;\n    createAnalyser(): AnalyserNode;\n    createBiquadFilter(): BiquadFilterNode;\n    createBuffer(numberOfChannels: number, length: number, sampleRate: number): AudioBuffer;\n    createBufferSource(): AudioBufferSourceNode;\n    createChannelMerger(numberOfInputs?: number): ChannelMergerNode;\n    createChannelSplitter(numberOfOutputs?: number): ChannelSplitterNode;\n    createConstantSource(): ConstantSourceNode;\n    createConvolver(): ConvolverNode;\n    createDelay(maxDelayTime?: number): DelayNode;\n    createDynamicsCompressor(): DynamicsCompressorNode;\n    createGain(): GainNode;\n    createIIRFilter(feedforward: number[], feedback: number[]): IIRFilterNode;\n    createOscillator(): OscillatorNode;\n    createPanner(): PannerNode;\n    createPeriodicWave(real: number[] | Float32Array, imag: number[] | Float32Array, constraints?: PeriodicWaveConstraints): PeriodicWave;\n    /** @deprecated */\n    createScriptProcessor(bufferSize?: number, numberOfInputChannels?: number, numberOfOutputChannels?: number): ScriptProcessorNode;\n    createStereoPanner(): StereoPannerNode;\n    createWaveShaper(): WaveShaperNode;\n    decodeAudioData(audioData: ArrayBuffer, successCallback?: DecodeSuccessCallback | null, errorCallback?: DecodeErrorCallback | null): Promise<AudioBuffer>;\n    addEventListener<K extends keyof BaseAudioContextEventMap>(type: K, listener: (this: BaseAudioContext, ev: BaseAudioContextEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof BaseAudioContextEventMap>(type: K, listener: (this: BaseAudioContext, ev: BaseAudioContextEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var BaseAudioContext: {\n    prototype: BaseAudioContext;\n    new(): BaseAudioContext;\n};\n\n/** The beforeunload event is fired when the window, the document and its resources are about to be unloaded. */\ninterface BeforeUnloadEvent extends Event {\n    returnValue: any;\n}\n\ndeclare var BeforeUnloadEvent: {\n    prototype: BeforeUnloadEvent;\n    new(): BeforeUnloadEvent;\n};\n\n/** A simple low-order filter, and is created using the AudioContext.createBiquadFilter() method. It is an AudioNode that can represent different kinds of filters, tone control devices, and graphic equalizers. */\ninterface BiquadFilterNode extends AudioNode {\n    readonly Q: AudioParam;\n    readonly detune: AudioParam;\n    readonly frequency: AudioParam;\n    readonly gain: AudioParam;\n    type: BiquadFilterType;\n    getFrequencyResponse(frequencyHz: Float32Array, magResponse: Float32Array, phaseResponse: Float32Array): void;\n}\n\ndeclare var BiquadFilterNode: {\n    prototype: BiquadFilterNode;\n    new(context: BaseAudioContext, options?: BiquadFilterOptions): BiquadFilterNode;\n};\n\n/** A file-like object of immutable, raw data. Blobs represent data that isn't necessarily in a JavaScript-native format. The File interface is based on Blob, inheriting blob functionality and expanding it to support files on the user's system. */\ninterface Blob {\n    readonly size: number;\n    readonly type: string;\n    arrayBuffer(): Promise<ArrayBuffer>;\n    slice(start?: number, end?: number, contentType?: string): Blob;\n    stream(): ReadableStream<Uint8Array>;\n    text(): Promise<string>;\n}\n\ndeclare var Blob: {\n    prototype: Blob;\n    new(blobParts?: BlobPart[], options?: BlobPropertyBag): Blob;\n};\n\ninterface BlobEvent extends Event {\n    readonly data: Blob;\n    readonly timecode: DOMHighResTimeStamp;\n}\n\ndeclare var BlobEvent: {\n    prototype: BlobEvent;\n    new(type: string, eventInitDict: BlobEventInit): BlobEvent;\n};\n\ninterface Body {\n    readonly body: ReadableStream<Uint8Array> | null;\n    readonly bodyUsed: boolean;\n    arrayBuffer(): Promise<ArrayBuffer>;\n    blob(): Promise<Blob>;\n    formData(): Promise<FormData>;\n    json(): Promise<any>;\n    text(): Promise<string>;\n}\n\ninterface BroadcastChannelEventMap {\n    \"message\": MessageEvent;\n    \"messageerror\": MessageEvent;\n}\n\ninterface BroadcastChannel extends EventTarget {\n    /** Returns the channel name (as passed to the constructor). */\n    readonly name: string;\n    onmessage: ((this: BroadcastChannel, ev: MessageEvent) => any) | null;\n    onmessageerror: ((this: BroadcastChannel, ev: MessageEvent) => any) | null;\n    /** Closes the BroadcastChannel object, opening it up to garbage collection. */\n    close(): void;\n    /** Sends the given message to other BroadcastChannel objects set up for this channel. Messages can be structured objects, e.g. nested objects and arrays. */\n    postMessage(message: any): void;\n    addEventListener<K extends keyof BroadcastChannelEventMap>(type: K, listener: (this: BroadcastChannel, ev: BroadcastChannelEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof BroadcastChannelEventMap>(type: K, listener: (this: BroadcastChannel, ev: BroadcastChannelEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var BroadcastChannel: {\n    prototype: BroadcastChannel;\n    new(name: string): BroadcastChannel;\n};\n\n/** This Streams API interface provides a built-in byte length queuing strategy that can be used when constructing streams. */\ninterface ByteLengthQueuingStrategy extends QueuingStrategy<ArrayBufferView> {\n    readonly highWaterMark: number;\n    readonly size: QueuingStrategySize<ArrayBufferView>;\n}\n\ndeclare var ByteLengthQueuingStrategy: {\n    prototype: ByteLengthQueuingStrategy;\n    new(init: QueuingStrategyInit): ByteLengthQueuingStrategy;\n};\n\n/** A CDATA section that can be used within XML to include extended portions of unescaped text. The symbols < and & don’t need escaping as they normally do when inside a CDATA section. */\ninterface CDATASection extends Text {\n}\n\ndeclare var CDATASection: {\n    prototype: CDATASection;\n    new(): CDATASection;\n};\n\ninterface CSSAnimation extends Animation {\n    readonly animationName: string;\n    addEventListener<K extends keyof AnimationEventMap>(type: K, listener: (this: CSSAnimation, ev: AnimationEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof AnimationEventMap>(type: K, listener: (this: CSSAnimation, ev: AnimationEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var CSSAnimation: {\n    prototype: CSSAnimation;\n    new(): CSSAnimation;\n};\n\n/** A single condition CSS at-rule, which consists of a condition and a statement block. It is a child of CSSGroupingRule. */\ninterface CSSConditionRule extends CSSGroupingRule {\n    readonly conditionText: string;\n}\n\ndeclare var CSSConditionRule: {\n    prototype: CSSConditionRule;\n    new(): CSSConditionRule;\n};\n\ninterface CSSContainerRule extends CSSConditionRule {\n}\n\ndeclare var CSSContainerRule: {\n    prototype: CSSContainerRule;\n    new(): CSSContainerRule;\n};\n\ninterface CSSCounterStyleRule extends CSSRule {\n    additiveSymbols: string;\n    fallback: string;\n    name: string;\n    negative: string;\n    pad: string;\n    prefix: string;\n    range: string;\n    speakAs: string;\n    suffix: string;\n    symbols: string;\n    system: string;\n}\n\ndeclare var CSSCounterStyleRule: {\n    prototype: CSSCounterStyleRule;\n    new(): CSSCounterStyleRule;\n};\n\ninterface CSSFontFaceRule extends CSSRule {\n    readonly style: CSSStyleDeclaration;\n}\n\ndeclare var CSSFontFaceRule: {\n    prototype: CSSFontFaceRule;\n    new(): CSSFontFaceRule;\n};\n\ninterface CSSFontFeatureValuesRule extends CSSRule {\n    fontFamily: string;\n}\n\ndeclare var CSSFontFeatureValuesRule: {\n    prototype: CSSFontFeatureValuesRule;\n    new(): CSSFontFeatureValuesRule;\n};\n\ninterface CSSFontPaletteValuesRule extends CSSRule {\n    readonly basePalette: string;\n    readonly fontFamily: string;\n    readonly name: string;\n    readonly overrideColors: string;\n}\n\ndeclare var CSSFontPaletteValuesRule: {\n    prototype: CSSFontPaletteValuesRule;\n    new(): CSSFontPaletteValuesRule;\n};\n\n/** Any CSS at-rule that contains other rules nested within it. */\ninterface CSSGroupingRule extends CSSRule {\n    readonly cssRules: CSSRuleList;\n    deleteRule(index: number): void;\n    insertRule(rule: string, index?: number): number;\n}\n\ndeclare var CSSGroupingRule: {\n    prototype: CSSGroupingRule;\n    new(): CSSGroupingRule;\n};\n\ninterface CSSImportRule extends CSSRule {\n    readonly href: string;\n    readonly layerName: string | null;\n    readonly media: MediaList;\n    readonly styleSheet: CSSStyleSheet;\n}\n\ndeclare var CSSImportRule: {\n    prototype: CSSImportRule;\n    new(): CSSImportRule;\n};\n\n/** An object representing a set of style for a given keyframe. It corresponds to the contains of a single keyframe of a @keyframes at-rule. It implements the CSSRule interface with a type value of 8 (CSSRule.KEYFRAME_RULE). */\ninterface CSSKeyframeRule extends CSSRule {\n    keyText: string;\n    readonly style: CSSStyleDeclaration;\n}\n\ndeclare var CSSKeyframeRule: {\n    prototype: CSSKeyframeRule;\n    new(): CSSKeyframeRule;\n};\n\n/** An object representing a complete set of keyframes for a CSS animation. It corresponds to the contains of a whole @keyframes at-rule. It implements the CSSRule interface with a type value of 7 (CSSRule.KEYFRAMES_RULE). */\ninterface CSSKeyframesRule extends CSSRule {\n    readonly cssRules: CSSRuleList;\n    name: string;\n    appendRule(rule: string): void;\n    deleteRule(select: string): void;\n    findRule(select: string): CSSKeyframeRule | null;\n    [index: number]: CSSKeyframeRule;\n}\n\ndeclare var CSSKeyframesRule: {\n    prototype: CSSKeyframesRule;\n    new(): CSSKeyframesRule;\n};\n\ninterface CSSLayerBlockRule extends CSSGroupingRule {\n    readonly name: string;\n}\n\ndeclare var CSSLayerBlockRule: {\n    prototype: CSSLayerBlockRule;\n    new(): CSSLayerBlockRule;\n};\n\ninterface CSSLayerStatementRule extends CSSRule {\n    readonly nameList: ReadonlyArray<string>;\n}\n\ndeclare var CSSLayerStatementRule: {\n    prototype: CSSLayerStatementRule;\n    new(): CSSLayerStatementRule;\n};\n\n/** A single CSS @media rule. It implements the CSSConditionRule interface, and therefore the CSSGroupingRule and the CSSRule interface with a type value of 4 (CSSRule.MEDIA_RULE). */\ninterface CSSMediaRule extends CSSConditionRule {\n    readonly media: MediaList;\n}\n\ndeclare var CSSMediaRule: {\n    prototype: CSSMediaRule;\n    new(): CSSMediaRule;\n};\n\n/** An object representing a single CSS @namespace at-rule. It implements the CSSRule interface, with a type value of 10 (CSSRule.NAMESPACE_RULE). */\ninterface CSSNamespaceRule extends CSSRule {\n    readonly namespaceURI: string;\n    readonly prefix: string;\n}\n\ndeclare var CSSNamespaceRule: {\n    prototype: CSSNamespaceRule;\n    new(): CSSNamespaceRule;\n};\n\n/** CSSPageRule is an interface representing a single CSS @page rule. It implements the CSSRule interface with a type value of 6 (CSSRule.PAGE_RULE). */\ninterface CSSPageRule extends CSSGroupingRule {\n    selectorText: string;\n    readonly style: CSSStyleDeclaration;\n}\n\ndeclare var CSSPageRule: {\n    prototype: CSSPageRule;\n    new(): CSSPageRule;\n};\n\n/** A single CSS rule. There are several types of rules, listed in the Type constants section below. */\ninterface CSSRule {\n    cssText: string;\n    readonly parentRule: CSSRule | null;\n    readonly parentStyleSheet: CSSStyleSheet | null;\n    /** @deprecated */\n    readonly type: number;\n    readonly STYLE_RULE: 1;\n    readonly CHARSET_RULE: 2;\n    readonly IMPORT_RULE: 3;\n    readonly MEDIA_RULE: 4;\n    readonly FONT_FACE_RULE: 5;\n    readonly PAGE_RULE: 6;\n    readonly NAMESPACE_RULE: 10;\n    readonly KEYFRAMES_RULE: 7;\n    readonly KEYFRAME_RULE: 8;\n    readonly SUPPORTS_RULE: 12;\n}\n\ndeclare var CSSRule: {\n    prototype: CSSRule;\n    new(): CSSRule;\n    readonly STYLE_RULE: 1;\n    readonly CHARSET_RULE: 2;\n    readonly IMPORT_RULE: 3;\n    readonly MEDIA_RULE: 4;\n    readonly FONT_FACE_RULE: 5;\n    readonly PAGE_RULE: 6;\n    readonly NAMESPACE_RULE: 10;\n    readonly KEYFRAMES_RULE: 7;\n    readonly KEYFRAME_RULE: 8;\n    readonly SUPPORTS_RULE: 12;\n};\n\n/** A CSSRuleList is an (indirect-modify only) array-like object containing an ordered collection of CSSRule objects. */\ninterface CSSRuleList {\n    readonly length: number;\n    item(index: number): CSSRule | null;\n    [index: number]: CSSRule;\n}\n\ndeclare var CSSRuleList: {\n    prototype: CSSRuleList;\n    new(): CSSRuleList;\n};\n\n/** An object that is a CSS declaration block, and exposes style information and various style-related methods and properties. */\ninterface CSSStyleDeclaration {\n    accentColor: string;\n    alignContent: string;\n    alignItems: string;\n    alignSelf: string;\n    alignmentBaseline: string;\n    all: string;\n    animation: string;\n    animationDelay: string;\n    animationDirection: string;\n    animationDuration: string;\n    animationFillMode: string;\n    animationIterationCount: string;\n    animationName: string;\n    animationPlayState: string;\n    animationTimingFunction: string;\n    appearance: string;\n    aspectRatio: string;\n    backdropFilter: string;\n    backfaceVisibility: string;\n    background: string;\n    backgroundAttachment: string;\n    backgroundBlendMode: string;\n    backgroundClip: string;\n    backgroundColor: string;\n    backgroundImage: string;\n    backgroundOrigin: string;\n    backgroundPosition: string;\n    backgroundPositionX: string;\n    backgroundPositionY: string;\n    backgroundRepeat: string;\n    backgroundSize: string;\n    baselineShift: string;\n    blockSize: string;\n    border: string;\n    borderBlock: string;\n    borderBlockColor: string;\n    borderBlockEnd: string;\n    borderBlockEndColor: string;\n    borderBlockEndStyle: string;\n    borderBlockEndWidth: string;\n    borderBlockStart: string;\n    borderBlockStartColor: string;\n    borderBlockStartStyle: string;\n    borderBlockStartWidth: string;\n    borderBlockStyle: string;\n    borderBlockWidth: string;\n    borderBottom: string;\n    borderBottomColor: string;\n    borderBottomLeftRadius: string;\n    borderBottomRightRadius: string;\n    borderBottomStyle: string;\n    borderBottomWidth: string;\n    borderCollapse: string;\n    borderColor: string;\n    borderEndEndRadius: string;\n    borderEndStartRadius: string;\n    borderImage: string;\n    borderImageOutset: string;\n    borderImageRepeat: string;\n    borderImageSlice: string;\n    borderImageSource: string;\n    borderImageWidth: string;\n    borderInline: string;\n    borderInlineColor: string;\n    borderInlineEnd: string;\n    borderInlineEndColor: string;\n    borderInlineEndStyle: string;\n    borderInlineEndWidth: string;\n    borderInlineStart: string;\n    borderInlineStartColor: string;\n    borderInlineStartStyle: string;\n    borderInlineStartWidth: string;\n    borderInlineStyle: string;\n    borderInlineWidth: string;\n    borderLeft: string;\n    borderLeftColor: string;\n    borderLeftStyle: string;\n    borderLeftWidth: string;\n    borderRadius: string;\n    borderRight: string;\n    borderRightColor: string;\n    borderRightStyle: string;\n    borderRightWidth: string;\n    borderSpacing: string;\n    borderStartEndRadius: string;\n    borderStartStartRadius: string;\n    borderStyle: string;\n    borderTop: string;\n    borderTopColor: string;\n    borderTopLeftRadius: string;\n    borderTopRightRadius: string;\n    borderTopStyle: string;\n    borderTopWidth: string;\n    borderWidth: string;\n    bottom: string;\n    boxShadow: string;\n    boxSizing: string;\n    breakAfter: string;\n    breakBefore: string;\n    breakInside: string;\n    captionSide: string;\n    caretColor: string;\n    clear: string;\n    /** @deprecated */\n    clip: string;\n    clipPath: string;\n    clipRule: string;\n    color: string;\n    colorInterpolation: string;\n    colorInterpolationFilters: string;\n    colorScheme: string;\n    columnCount: string;\n    columnFill: string;\n    columnGap: string;\n    columnRule: string;\n    columnRuleColor: string;\n    columnRuleStyle: string;\n    columnRuleWidth: string;\n    columnSpan: string;\n    columnWidth: string;\n    columns: string;\n    contain: string;\n    containIntrinsicBlockSize: string;\n    containIntrinsicHeight: string;\n    containIntrinsicInlineSize: string;\n    containIntrinsicSize: string;\n    containIntrinsicWidth: string;\n    container: string;\n    containerName: string;\n    containerType: string;\n    content: string;\n    contentVisibility: string;\n    counterIncrement: string;\n    counterReset: string;\n    counterSet: string;\n    cssFloat: string;\n    cssText: string;\n    cursor: string;\n    direction: string;\n    display: string;\n    dominantBaseline: string;\n    emptyCells: string;\n    fill: string;\n    fillOpacity: string;\n    fillRule: string;\n    filter: string;\n    flex: string;\n    flexBasis: string;\n    flexDirection: string;\n    flexFlow: string;\n    flexGrow: string;\n    flexShrink: string;\n    flexWrap: string;\n    float: string;\n    floodColor: string;\n    floodOpacity: string;\n    font: string;\n    fontFamily: string;\n    fontFeatureSettings: string;\n    fontKerning: string;\n    fontOpticalSizing: string;\n    fontPalette: string;\n    fontSize: string;\n    fontSizeAdjust: string;\n    fontStretch: string;\n    fontStyle: string;\n    fontSynthesis: string;\n    fontVariant: string;\n    fontVariantAlternates: string;\n    fontVariantCaps: string;\n    fontVariantEastAsian: string;\n    fontVariantLigatures: string;\n    fontVariantNumeric: string;\n    fontVariantPosition: string;\n    fontVariationSettings: string;\n    fontWeight: string;\n    gap: string;\n    grid: string;\n    gridArea: string;\n    gridAutoColumns: string;\n    gridAutoFlow: string;\n    gridAutoRows: string;\n    gridColumn: string;\n    gridColumnEnd: string;\n    /** @deprecated This is a legacy alias of `columnGap`. */\n    gridColumnGap: string;\n    gridColumnStart: string;\n    /** @deprecated This is a legacy alias of `gap`. */\n    gridGap: string;\n    gridRow: string;\n    gridRowEnd: string;\n    /** @deprecated This is a legacy alias of `rowGap`. */\n    gridRowGap: string;\n    gridRowStart: string;\n    gridTemplate: string;\n    gridTemplateAreas: string;\n    gridTemplateColumns: string;\n    gridTemplateRows: string;\n    height: string;\n    hyphenateCharacter: string;\n    hyphens: string;\n    /** @deprecated */\n    imageOrientation: string;\n    imageRendering: string;\n    inlineSize: string;\n    inset: string;\n    insetBlock: string;\n    insetBlockEnd: string;\n    insetBlockStart: string;\n    insetInline: string;\n    insetInlineEnd: string;\n    insetInlineStart: string;\n    isolation: string;\n    justifyContent: string;\n    justifyItems: string;\n    justifySelf: string;\n    left: string;\n    readonly length: number;\n    letterSpacing: string;\n    lightingColor: string;\n    lineBreak: string;\n    lineHeight: string;\n    listStyle: string;\n    listStyleImage: string;\n    listStylePosition: string;\n    listStyleType: string;\n    margin: string;\n    marginBlock: string;\n    marginBlockEnd: string;\n    marginBlockStart: string;\n    marginBottom: string;\n    marginInline: string;\n    marginInlineEnd: string;\n    marginInlineStart: string;\n    marginLeft: string;\n    marginRight: string;\n    marginTop: string;\n    marker: string;\n    markerEnd: string;\n    markerMid: string;\n    markerStart: string;\n    mask: string;\n    maskClip: string;\n    maskComposite: string;\n    maskImage: string;\n    maskMode: string;\n    maskOrigin: string;\n    maskPosition: string;\n    maskRepeat: string;\n    maskSize: string;\n    maskType: string;\n    mathStyle: string;\n    maxBlockSize: string;\n    maxHeight: string;\n    maxInlineSize: string;\n    maxWidth: string;\n    minBlockSize: string;\n    minHeight: string;\n    minInlineSize: string;\n    minWidth: string;\n    mixBlendMode: string;\n    objectFit: string;\n    objectPosition: string;\n    offset: string;\n    offsetDistance: string;\n    offsetPath: string;\n    offsetRotate: string;\n    opacity: string;\n    order: string;\n    orphans: string;\n    outline: string;\n    outlineColor: string;\n    outlineOffset: string;\n    outlineStyle: string;\n    outlineWidth: string;\n    overflow: string;\n    overflowAnchor: string;\n    overflowClipMargin: string;\n    overflowWrap: string;\n    overflowX: string;\n    overflowY: string;\n    overscrollBehavior: string;\n    overscrollBehaviorBlock: string;\n    overscrollBehaviorInline: string;\n    overscrollBehaviorX: string;\n    overscrollBehaviorY: string;\n    padding: string;\n    paddingBlock: string;\n    paddingBlockEnd: string;\n    paddingBlockStart: string;\n    paddingBottom: string;\n    paddingInline: string;\n    paddingInlineEnd: string;\n    paddingInlineStart: string;\n    paddingLeft: string;\n    paddingRight: string;\n    paddingTop: string;\n    pageBreakAfter: string;\n    pageBreakBefore: string;\n    pageBreakInside: string;\n    paintOrder: string;\n    readonly parentRule: CSSRule | null;\n    perspective: string;\n    perspectiveOrigin: string;\n    placeContent: string;\n    placeItems: string;\n    placeSelf: string;\n    pointerEvents: string;\n    position: string;\n    printColorAdjust: string;\n    quotes: string;\n    resize: string;\n    right: string;\n    rotate: string;\n    rowGap: string;\n    rubyPosition: string;\n    scale: string;\n    scrollBehavior: string;\n    scrollMargin: string;\n    scrollMarginBlock: string;\n    scrollMarginBlockEnd: string;\n    scrollMarginBlockStart: string;\n    scrollMarginBottom: string;\n    scrollMarginInline: string;\n    scrollMarginInlineEnd: string;\n    scrollMarginInlineStart: string;\n    scrollMarginLeft: string;\n    scrollMarginRight: string;\n    scrollMarginTop: string;\n    scrollPadding: string;\n    scrollPaddingBlock: string;\n    scrollPaddingBlockEnd: string;\n    scrollPaddingBlockStart: string;\n    scrollPaddingBottom: string;\n    scrollPaddingInline: string;\n    scrollPaddingInlineEnd: string;\n    scrollPaddingInlineStart: string;\n    scrollPaddingLeft: string;\n    scrollPaddingRight: string;\n    scrollPaddingTop: string;\n    scrollSnapAlign: string;\n    scrollSnapStop: string;\n    scrollSnapType: string;\n    scrollbarGutter: string;\n    shapeImageThreshold: string;\n    shapeMargin: string;\n    shapeOutside: string;\n    shapeRendering: string;\n    stopColor: string;\n    stopOpacity: string;\n    stroke: string;\n    strokeDasharray: string;\n    strokeDashoffset: string;\n    strokeLinecap: string;\n    strokeLinejoin: string;\n    strokeMiterlimit: string;\n    strokeOpacity: string;\n    strokeWidth: string;\n    tabSize: string;\n    tableLayout: string;\n    textAlign: string;\n    textAlignLast: string;\n    textAnchor: string;\n    textCombineUpright: string;\n    textDecoration: string;\n    textDecorationColor: string;\n    textDecorationLine: string;\n    textDecorationSkipInk: string;\n    textDecorationStyle: string;\n    textDecorationThickness: string;\n    textEmphasis: string;\n    textEmphasisColor: string;\n    textEmphasisPosition: string;\n    textEmphasisStyle: string;\n    textIndent: string;\n    textOrientation: string;\n    textOverflow: string;\n    textRendering: string;\n    textShadow: string;\n    textTransform: string;\n    textUnderlineOffset: string;\n    textUnderlinePosition: string;\n    top: string;\n    touchAction: string;\n    transform: string;\n    transformBox: string;\n    transformOrigin: string;\n    transformStyle: string;\n    transition: string;\n    transitionDelay: string;\n    transitionDuration: string;\n    transitionProperty: string;\n    transitionTimingFunction: string;\n    translate: string;\n    unicodeBidi: string;\n    userSelect: string;\n    verticalAlign: string;\n    visibility: string;\n    /** @deprecated This is a legacy alias of `alignContent`. */\n    webkitAlignContent: string;\n    /** @deprecated This is a legacy alias of `alignItems`. */\n    webkitAlignItems: string;\n    /** @deprecated This is a legacy alias of `alignSelf`. */\n    webkitAlignSelf: string;\n    /** @deprecated This is a legacy alias of `animation`. */\n    webkitAnimation: string;\n    /** @deprecated This is a legacy alias of `animationDelay`. */\n    webkitAnimationDelay: string;\n    /** @deprecated This is a legacy alias of `animationDirection`. */\n    webkitAnimationDirection: string;\n    /** @deprecated This is a legacy alias of `animationDuration`. */\n    webkitAnimationDuration: string;\n    /** @deprecated This is a legacy alias of `animationFillMode`. */\n    webkitAnimationFillMode: string;\n    /** @deprecated This is a legacy alias of `animationIterationCount`. */\n    webkitAnimationIterationCount: string;\n    /** @deprecated This is a legacy alias of `animationName`. */\n    webkitAnimationName: string;\n    /** @deprecated This is a legacy alias of `animationPlayState`. */\n    webkitAnimationPlayState: string;\n    /** @deprecated This is a legacy alias of `animationTimingFunction`. */\n    webkitAnimationTimingFunction: string;\n    /** @deprecated This is a legacy alias of `appearance`. */\n    webkitAppearance: string;\n    /** @deprecated This is a legacy alias of `backfaceVisibility`. */\n    webkitBackfaceVisibility: string;\n    /** @deprecated This is a legacy alias of `backgroundClip`. */\n    webkitBackgroundClip: string;\n    /** @deprecated This is a legacy alias of `backgroundOrigin`. */\n    webkitBackgroundOrigin: string;\n    /** @deprecated This is a legacy alias of `backgroundSize`. */\n    webkitBackgroundSize: string;\n    /** @deprecated This is a legacy alias of `borderBottomLeftRadius`. */\n    webkitBorderBottomLeftRadius: string;\n    /** @deprecated This is a legacy alias of `borderBottomRightRadius`. */\n    webkitBorderBottomRightRadius: string;\n    /** @deprecated This is a legacy alias of `borderRadius`. */\n    webkitBorderRadius: string;\n    /** @deprecated This is a legacy alias of `borderTopLeftRadius`. */\n    webkitBorderTopLeftRadius: string;\n    /** @deprecated This is a legacy alias of `borderTopRightRadius`. */\n    webkitBorderTopRightRadius: string;\n    /** @deprecated This is a legacy alias of `boxAlign`. */\n    webkitBoxAlign: string;\n    /** @deprecated This is a legacy alias of `boxFlex`. */\n    webkitBoxFlex: string;\n    /** @deprecated This is a legacy alias of `boxOrdinalGroup`. */\n    webkitBoxOrdinalGroup: string;\n    /** @deprecated This is a legacy alias of `boxOrient`. */\n    webkitBoxOrient: string;\n    /** @deprecated This is a legacy alias of `boxPack`. */\n    webkitBoxPack: string;\n    /** @deprecated This is a legacy alias of `boxShadow`. */\n    webkitBoxShadow: string;\n    /** @deprecated This is a legacy alias of `boxSizing`. */\n    webkitBoxSizing: string;\n    /** @deprecated This is a legacy alias of `filter`. */\n    webkitFilter: string;\n    /** @deprecated This is a legacy alias of `flex`. */\n    webkitFlex: string;\n    /** @deprecated This is a legacy alias of `flexBasis`. */\n    webkitFlexBasis: string;\n    /** @deprecated This is a legacy alias of `flexDirection`. */\n    webkitFlexDirection: string;\n    /** @deprecated This is a legacy alias of `flexFlow`. */\n    webkitFlexFlow: string;\n    /** @deprecated This is a legacy alias of `flexGrow`. */\n    webkitFlexGrow: string;\n    /** @deprecated This is a legacy alias of `flexShrink`. */\n    webkitFlexShrink: string;\n    /** @deprecated This is a legacy alias of `flexWrap`. */\n    webkitFlexWrap: string;\n    /** @deprecated This is a legacy alias of `justifyContent`. */\n    webkitJustifyContent: string;\n    webkitLineClamp: string;\n    /** @deprecated This is a legacy alias of `mask`. */\n    webkitMask: string;\n    /** @deprecated This is a legacy alias of `maskBorder`. */\n    webkitMaskBoxImage: string;\n    /** @deprecated This is a legacy alias of `maskBorderOutset`. */\n    webkitMaskBoxImageOutset: string;\n    /** @deprecated This is a legacy alias of `maskBorderRepeat`. */\n    webkitMaskBoxImageRepeat: string;\n    /** @deprecated This is a legacy alias of `maskBorderSlice`. */\n    webkitMaskBoxImageSlice: string;\n    /** @deprecated This is a legacy alias of `maskBorderSource`. */\n    webkitMaskBoxImageSource: string;\n    /** @deprecated This is a legacy alias of `maskBorderWidth`. */\n    webkitMaskBoxImageWidth: string;\n    /** @deprecated This is a legacy alias of `maskClip`. */\n    webkitMaskClip: string;\n    webkitMaskComposite: string;\n    /** @deprecated This is a legacy alias of `maskImage`. */\n    webkitMaskImage: string;\n    /** @deprecated This is a legacy alias of `maskOrigin`. */\n    webkitMaskOrigin: string;\n    /** @deprecated This is a legacy alias of `maskPosition`. */\n    webkitMaskPosition: string;\n    /** @deprecated This is a legacy alias of `maskRepeat`. */\n    webkitMaskRepeat: string;\n    /** @deprecated This is a legacy alias of `maskSize`. */\n    webkitMaskSize: string;\n    /** @deprecated This is a legacy alias of `order`. */\n    webkitOrder: string;\n    /** @deprecated This is a legacy alias of `perspective`. */\n    webkitPerspective: string;\n    /** @deprecated This is a legacy alias of `perspectiveOrigin`. */\n    webkitPerspectiveOrigin: string;\n    webkitTextFillColor: string;\n    /** @deprecated This is a legacy alias of `textSizeAdjust`. */\n    webkitTextSizeAdjust: string;\n    webkitTextStroke: string;\n    webkitTextStrokeColor: string;\n    webkitTextStrokeWidth: string;\n    /** @deprecated This is a legacy alias of `transform`. */\n    webkitTransform: string;\n    /** @deprecated This is a legacy alias of `transformOrigin`. */\n    webkitTransformOrigin: string;\n    /** @deprecated This is a legacy alias of `transformStyle`. */\n    webkitTransformStyle: string;\n    /** @deprecated This is a legacy alias of `transition`. */\n    webkitTransition: string;\n    /** @deprecated This is a legacy alias of `transitionDelay`. */\n    webkitTransitionDelay: string;\n    /** @deprecated This is a legacy alias of `transitionDuration`. */\n    webkitTransitionDuration: string;\n    /** @deprecated This is a legacy alias of `transitionProperty`. */\n    webkitTransitionProperty: string;\n    /** @deprecated This is a legacy alias of `transitionTimingFunction`. */\n    webkitTransitionTimingFunction: string;\n    /** @deprecated This is a legacy alias of `userSelect`. */\n    webkitUserSelect: string;\n    whiteSpace: string;\n    widows: string;\n    width: string;\n    willChange: string;\n    wordBreak: string;\n    wordSpacing: string;\n    /** @deprecated */\n    wordWrap: string;\n    writingMode: string;\n    zIndex: string;\n    getPropertyPriority(property: string): string;\n    getPropertyValue(property: string): string;\n    item(index: number): string;\n    removeProperty(property: string): string;\n    setProperty(property: string, value: string | null, priority?: string): void;\n    [index: number]: string;\n}\n\ndeclare var CSSStyleDeclaration: {\n    prototype: CSSStyleDeclaration;\n    new(): CSSStyleDeclaration;\n};\n\n/** CSSStyleRule represents a single CSS style rule. It implements the CSSRule interface with a type value of 1 (CSSRule.STYLE_RULE). */\ninterface CSSStyleRule extends CSSRule {\n    selectorText: string;\n    readonly style: CSSStyleDeclaration;\n}\n\ndeclare var CSSStyleRule: {\n    prototype: CSSStyleRule;\n    new(): CSSStyleRule;\n};\n\n/** A single CSS style sheet. It inherits properties and methods from its parent, StyleSheet. */\ninterface CSSStyleSheet extends StyleSheet {\n    readonly cssRules: CSSRuleList;\n    readonly ownerRule: CSSRule | null;\n    /** @deprecated */\n    readonly rules: CSSRuleList;\n    /** @deprecated */\n    addRule(selector?: string, style?: string, index?: number): number;\n    deleteRule(index: number): void;\n    insertRule(rule: string, index?: number): number;\n    /** @deprecated */\n    removeRule(index?: number): void;\n    replace(text: string): Promise<CSSStyleSheet>;\n    replaceSync(text: string): void;\n}\n\ndeclare var CSSStyleSheet: {\n    prototype: CSSStyleSheet;\n    new(options?: CSSStyleSheetInit): CSSStyleSheet;\n};\n\n/** An object representing a single CSS @supports at-rule. It implements the CSSConditionRule interface, and therefore the CSSRule and CSSGroupingRule interfaces with a type value of 12 (CSSRule.SUPPORTS_RULE). */\ninterface CSSSupportsRule extends CSSConditionRule {\n}\n\ndeclare var CSSSupportsRule: {\n    prototype: CSSSupportsRule;\n    new(): CSSSupportsRule;\n};\n\ninterface CSSTransition extends Animation {\n    readonly transitionProperty: string;\n    addEventListener<K extends keyof AnimationEventMap>(type: K, listener: (this: CSSTransition, ev: AnimationEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof AnimationEventMap>(type: K, listener: (this: CSSTransition, ev: AnimationEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var CSSTransition: {\n    prototype: CSSTransition;\n    new(): CSSTransition;\n};\n\n/**\n * Provides a storage mechanism for Request / Response object pairs that are cached, for example as part of the ServiceWorker life cycle. Note that the Cache interface is exposed to windowed scopes as well as workers. You don't have to use it in conjunction with service workers, even though it is defined in the service worker spec.\n * Available only in secure contexts.\n */\ninterface Cache {\n    add(request: RequestInfo | URL): Promise<void>;\n    addAll(requests: RequestInfo[]): Promise<void>;\n    delete(request: RequestInfo | URL, options?: CacheQueryOptions): Promise<boolean>;\n    keys(request?: RequestInfo | URL, options?: CacheQueryOptions): Promise<ReadonlyArray<Request>>;\n    match(request: RequestInfo | URL, options?: CacheQueryOptions): Promise<Response | undefined>;\n    matchAll(request?: RequestInfo | URL, options?: CacheQueryOptions): Promise<ReadonlyArray<Response>>;\n    put(request: RequestInfo | URL, response: Response): Promise<void>;\n}\n\ndeclare var Cache: {\n    prototype: Cache;\n    new(): Cache;\n};\n\n/**\n * The storage for Cache objects.\n * Available only in secure contexts.\n */\ninterface CacheStorage {\n    delete(cacheName: string): Promise<boolean>;\n    has(cacheName: string): Promise<boolean>;\n    keys(): Promise<string[]>;\n    match(request: RequestInfo | URL, options?: MultiCacheQueryOptions): Promise<Response | undefined>;\n    open(cacheName: string): Promise<Cache>;\n}\n\ndeclare var CacheStorage: {\n    prototype: CacheStorage;\n    new(): CacheStorage;\n};\n\ninterface CanvasCaptureMediaStreamTrack extends MediaStreamTrack {\n    readonly canvas: HTMLCanvasElement;\n    requestFrame(): void;\n    addEventListener<K extends keyof MediaStreamTrackEventMap>(type: K, listener: (this: CanvasCaptureMediaStreamTrack, ev: MediaStreamTrackEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof MediaStreamTrackEventMap>(type: K, listener: (this: CanvasCaptureMediaStreamTrack, ev: MediaStreamTrackEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var CanvasCaptureMediaStreamTrack: {\n    prototype: CanvasCaptureMediaStreamTrack;\n    new(): CanvasCaptureMediaStreamTrack;\n};\n\ninterface CanvasCompositing {\n    globalAlpha: number;\n    globalCompositeOperation: GlobalCompositeOperation;\n}\n\ninterface CanvasDrawImage {\n    drawImage(image: CanvasImageSource, dx: number, dy: number): void;\n    drawImage(image: CanvasImageSource, dx: number, dy: number, dw: number, dh: number): void;\n    drawImage(image: CanvasImageSource, sx: number, sy: number, sw: number, sh: number, dx: number, dy: number, dw: number, dh: number): void;\n}\n\ninterface CanvasDrawPath {\n    beginPath(): void;\n    clip(fillRule?: CanvasFillRule): void;\n    clip(path: Path2D, fillRule?: CanvasFillRule): void;\n    fill(fillRule?: CanvasFillRule): void;\n    fill(path: Path2D, fillRule?: CanvasFillRule): void;\n    isPointInPath(x: number, y: number, fillRule?: CanvasFillRule): boolean;\n    isPointInPath(path: Path2D, x: number, y: number, fillRule?: CanvasFillRule): boolean;\n    isPointInStroke(x: number, y: number): boolean;\n    isPointInStroke(path: Path2D, x: number, y: number): boolean;\n    stroke(): void;\n    stroke(path: Path2D): void;\n}\n\ninterface CanvasFillStrokeStyles {\n    fillStyle: string | CanvasGradient | CanvasPattern;\n    strokeStyle: string | CanvasGradient | CanvasPattern;\n    createConicGradient(startAngle: number, x: number, y: number): CanvasGradient;\n    createLinearGradient(x0: number, y0: number, x1: number, y1: number): CanvasGradient;\n    createPattern(image: CanvasImageSource, repetition: string | null): CanvasPattern | null;\n    createRadialGradient(x0: number, y0: number, r0: number, x1: number, y1: number, r1: number): CanvasGradient;\n}\n\ninterface CanvasFilters {\n    filter: string;\n}\n\n/** An opaque object describing a gradient. It is returned by the methods CanvasRenderingContext2D.createLinearGradient() or CanvasRenderingContext2D.createRadialGradient(). */\ninterface CanvasGradient {\n    /**\n     * Adds a color stop with the given color to the gradient at the given offset. 0.0 is the offset at one end of the gradient, 1.0 is the offset at the other end.\n     *\n     * Throws an \"IndexSizeError\" DOMException if the offset is out of range. Throws a \"SyntaxError\" DOMException if the color cannot be parsed.\n     */\n    addColorStop(offset: number, color: string): void;\n}\n\ndeclare var CanvasGradient: {\n    prototype: CanvasGradient;\n    new(): CanvasGradient;\n};\n\ninterface CanvasImageData {\n    createImageData(sw: number, sh: number, settings?: ImageDataSettings): ImageData;\n    createImageData(imagedata: ImageData): ImageData;\n    getImageData(sx: number, sy: number, sw: number, sh: number, settings?: ImageDataSettings): ImageData;\n    putImageData(imagedata: ImageData, dx: number, dy: number): void;\n    putImageData(imagedata: ImageData, dx: number, dy: number, dirtyX: number, dirtyY: number, dirtyWidth: number, dirtyHeight: number): void;\n}\n\ninterface CanvasImageSmoothing {\n    imageSmoothingEnabled: boolean;\n    imageSmoothingQuality: ImageSmoothingQuality;\n}\n\ninterface CanvasPath {\n    arc(x: number, y: number, radius: number, startAngle: number, endAngle: number, counterclockwise?: boolean): void;\n    arcTo(x1: number, y1: number, x2: number, y2: number, radius: number): void;\n    bezierCurveTo(cp1x: number, cp1y: number, cp2x: number, cp2y: number, x: number, y: number): void;\n    closePath(): void;\n    ellipse(x: number, y: number, radiusX: number, radiusY: number, rotation: number, startAngle: number, endAngle: number, counterclockwise?: boolean): void;\n    lineTo(x: number, y: number): void;\n    moveTo(x: number, y: number): void;\n    quadraticCurveTo(cpx: number, cpy: number, x: number, y: number): void;\n    rect(x: number, y: number, w: number, h: number): void;\n    roundRect(x: number, y: number, w: number, h: number, radii?: number | DOMPointInit | (number | DOMPointInit)[]): void;\n}\n\ninterface CanvasPathDrawingStyles {\n    lineCap: CanvasLineCap;\n    lineDashOffset: number;\n    lineJoin: CanvasLineJoin;\n    lineWidth: number;\n    miterLimit: number;\n    getLineDash(): number[];\n    setLineDash(segments: number[]): void;\n}\n\n/** An opaque object describing a pattern, based on an image, a canvas, or a video, created by the CanvasRenderingContext2D.createPattern() method. */\ninterface CanvasPattern {\n    /** Sets the transformation matrix that will be used when rendering the pattern during a fill or stroke painting operation. */\n    setTransform(transform?: DOMMatrix2DInit): void;\n}\n\ndeclare var CanvasPattern: {\n    prototype: CanvasPattern;\n    new(): CanvasPattern;\n};\n\ninterface CanvasRect {\n    clearRect(x: number, y: number, w: number, h: number): void;\n    fillRect(x: number, y: number, w: number, h: number): void;\n    strokeRect(x: number, y: number, w: number, h: number): void;\n}\n\n/** The CanvasRenderingContext2D interface, part of the Canvas API, provides the 2D rendering context for the drawing surface of a <canvas> element. It is used for drawing shapes, text, images, and other objects. */\ninterface CanvasRenderingContext2D extends CanvasCompositing, CanvasDrawImage, CanvasDrawPath, CanvasFillStrokeStyles, CanvasFilters, CanvasImageData, CanvasImageSmoothing, CanvasPath, CanvasPathDrawingStyles, CanvasRect, CanvasShadowStyles, CanvasState, CanvasText, CanvasTextDrawingStyles, CanvasTransform, CanvasUserInterface {\n    readonly canvas: HTMLCanvasElement;\n    getContextAttributes(): CanvasRenderingContext2DSettings;\n}\n\ndeclare var CanvasRenderingContext2D: {\n    prototype: CanvasRenderingContext2D;\n    new(): CanvasRenderingContext2D;\n};\n\ninterface CanvasShadowStyles {\n    shadowBlur: number;\n    shadowColor: string;\n    shadowOffsetX: number;\n    shadowOffsetY: number;\n}\n\ninterface CanvasState {\n    restore(): void;\n    save(): void;\n}\n\ninterface CanvasText {\n    fillText(text: string, x: number, y: number, maxWidth?: number): void;\n    measureText(text: string): TextMetrics;\n    strokeText(text: string, x: number, y: number, maxWidth?: number): void;\n}\n\ninterface CanvasTextDrawingStyles {\n    direction: CanvasDirection;\n    font: string;\n    fontKerning: CanvasFontKerning;\n    textAlign: CanvasTextAlign;\n    textBaseline: CanvasTextBaseline;\n}\n\ninterface CanvasTransform {\n    getTransform(): DOMMatrix;\n    resetTransform(): void;\n    rotate(angle: number): void;\n    scale(x: number, y: number): void;\n    setTransform(a: number, b: number, c: number, d: number, e: number, f: number): void;\n    setTransform(transform?: DOMMatrix2DInit): void;\n    transform(a: number, b: number, c: number, d: number, e: number, f: number): void;\n    translate(x: number, y: number): void;\n}\n\ninterface CanvasUserInterface {\n    drawFocusIfNeeded(element: Element): void;\n    drawFocusIfNeeded(path: Path2D, element: Element): void;\n}\n\n/** The ChannelMergerNode interface, often used in conjunction with its opposite, ChannelSplitterNode, reunites different mono inputs into a single output. Each input is used to fill a channel of the output. This is useful for accessing each channels separately, e.g. for performing channel mixing where gain must be separately controlled on each channel. */\ninterface ChannelMergerNode extends AudioNode {\n}\n\ndeclare var ChannelMergerNode: {\n    prototype: ChannelMergerNode;\n    new(context: BaseAudioContext, options?: ChannelMergerOptions): ChannelMergerNode;\n};\n\n/** The ChannelSplitterNode interface, often used in conjunction with its opposite, ChannelMergerNode, separates the different channels of an audio source into a set of mono outputs. This is useful for accessing each channel separately, e.g. for performing channel mixing where gain must be separately controlled on each channel. */\ninterface ChannelSplitterNode extends AudioNode {\n}\n\ndeclare var ChannelSplitterNode: {\n    prototype: ChannelSplitterNode;\n    new(context: BaseAudioContext, options?: ChannelSplitterOptions): ChannelSplitterNode;\n};\n\n/** The CharacterData abstract interface represents a Node object that contains characters. This is an abstract interface, meaning there aren't any object of type CharacterData: it is implemented by other interfaces, like Text, Comment, or ProcessingInstruction which aren't abstract. */\ninterface CharacterData extends Node, ChildNode, NonDocumentTypeChildNode {\n    data: string;\n    readonly length: number;\n    readonly ownerDocument: Document;\n    appendData(data: string): void;\n    deleteData(offset: number, count: number): void;\n    insertData(offset: number, data: string): void;\n    replaceData(offset: number, count: number, data: string): void;\n    substringData(offset: number, count: number): string;\n}\n\ndeclare var CharacterData: {\n    prototype: CharacterData;\n    new(): CharacterData;\n};\n\ninterface ChildNode extends Node {\n    /**\n     * Inserts nodes just after node, while replacing strings in nodes with equivalent Text nodes.\n     *\n     * Throws a \"HierarchyRequestError\" DOMException if the constraints of the node tree are violated.\n     */\n    after(...nodes: (Node | string)[]): void;\n    /**\n     * Inserts nodes just before node, while replacing strings in nodes with equivalent Text nodes.\n     *\n     * Throws a \"HierarchyRequestError\" DOMException if the constraints of the node tree are violated.\n     */\n    before(...nodes: (Node | string)[]): void;\n    /** Removes node. */\n    remove(): void;\n    /**\n     * Replaces node with nodes, while replacing strings in nodes with equivalent Text nodes.\n     *\n     * Throws a \"HierarchyRequestError\" DOMException if the constraints of the node tree are violated.\n     */\n    replaceWith(...nodes: (Node | string)[]): void;\n}\n\n/** @deprecated */\ninterface ClientRect extends DOMRect {\n}\n\n/** Available only in secure contexts. */\ninterface Clipboard extends EventTarget {\n    read(): Promise<ClipboardItems>;\n    readText(): Promise<string>;\n    write(data: ClipboardItems): Promise<void>;\n    writeText(data: string): Promise<void>;\n}\n\ndeclare var Clipboard: {\n    prototype: Clipboard;\n    new(): Clipboard;\n};\n\n/** Events providing information related to modification of the clipboard, that is cut, copy, and paste events. */\ninterface ClipboardEvent extends Event {\n    readonly clipboardData: DataTransfer | null;\n}\n\ndeclare var ClipboardEvent: {\n    prototype: ClipboardEvent;\n    new(type: string, eventInitDict?: ClipboardEventInit): ClipboardEvent;\n};\n\n/** Available only in secure contexts. */\ninterface ClipboardItem {\n    readonly presentationStyle: PresentationStyle;\n    readonly types: ReadonlyArray<string>;\n    getType(type: string): Promise<Blob>;\n}\n\ndeclare var ClipboardItem: {\n    prototype: ClipboardItem;\n    new(items: Record<string, string | Blob | PromiseLike<string | Blob>>, options?: ClipboardItemOptions): ClipboardItem;\n};\n\n/** A CloseEvent is sent to clients using WebSockets when the connection is closed. This is delivered to the listener indicated by the WebSocket object's onclose attribute. */\ninterface CloseEvent extends Event {\n    /** Returns the WebSocket connection close code provided by the server. */\n    readonly code: number;\n    /** Returns the WebSocket connection close reason provided by the server. */\n    readonly reason: string;\n    /** Returns true if the connection closed cleanly; false otherwise. */\n    readonly wasClean: boolean;\n}\n\ndeclare var CloseEvent: {\n    prototype: CloseEvent;\n    new(type: string, eventInitDict?: CloseEventInit): CloseEvent;\n};\n\n/** Textual notations within markup; although it is generally not visually shown, such comments are available to be read in the source view. */\ninterface Comment extends CharacterData {\n}\n\ndeclare var Comment: {\n    prototype: Comment;\n    new(data?: string): Comment;\n};\n\n/** The DOM CompositionEvent represents events that occur due to the user indirectly entering text. */\ninterface CompositionEvent extends UIEvent {\n    readonly data: string;\n    /** @deprecated */\n    initCompositionEvent(typeArg: string, bubblesArg?: boolean, cancelableArg?: boolean, viewArg?: WindowProxy | null, dataArg?: string): void;\n}\n\ndeclare var CompositionEvent: {\n    prototype: CompositionEvent;\n    new(type: string, eventInitDict?: CompositionEventInit): CompositionEvent;\n};\n\ninterface ConstantSourceNode extends AudioScheduledSourceNode {\n    readonly offset: AudioParam;\n    addEventListener<K extends keyof AudioScheduledSourceNodeEventMap>(type: K, listener: (this: ConstantSourceNode, ev: AudioScheduledSourceNodeEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof AudioScheduledSourceNodeEventMap>(type: K, listener: (this: ConstantSourceNode, ev: AudioScheduledSourceNodeEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var ConstantSourceNode: {\n    prototype: ConstantSourceNode;\n    new(context: BaseAudioContext, options?: ConstantSourceOptions): ConstantSourceNode;\n};\n\n/** An AudioNode that performs a Linear Convolution on a given AudioBuffer, often used to achieve a reverb effect. A ConvolverNode always has exactly one input and one output. */\ninterface ConvolverNode extends AudioNode {\n    buffer: AudioBuffer | null;\n    normalize: boolean;\n}\n\ndeclare var ConvolverNode: {\n    prototype: ConvolverNode;\n    new(context: BaseAudioContext, options?: ConvolverOptions): ConvolverNode;\n};\n\n/** This Streams API interface provides a built-in byte length queuing strategy that can be used when constructing streams. */\ninterface CountQueuingStrategy extends QueuingStrategy {\n    readonly highWaterMark: number;\n    readonly size: QueuingStrategySize;\n}\n\ndeclare var CountQueuingStrategy: {\n    prototype: CountQueuingStrategy;\n    new(init: QueuingStrategyInit): CountQueuingStrategy;\n};\n\n/** Available only in secure contexts. */\ninterface Credential {\n    readonly id: string;\n    readonly type: string;\n}\n\ndeclare var Credential: {\n    prototype: Credential;\n    new(): Credential;\n};\n\n/** Available only in secure contexts. */\ninterface CredentialsContainer {\n    create(options?: CredentialCreationOptions): Promise<Credential | null>;\n    get(options?: CredentialRequestOptions): Promise<Credential | null>;\n    preventSilentAccess(): Promise<void>;\n    store(credential: Credential): Promise<Credential>;\n}\n\ndeclare var CredentialsContainer: {\n    prototype: CredentialsContainer;\n    new(): CredentialsContainer;\n};\n\n/** Basic cryptography features available in the current context. It allows access to a cryptographically strong random number generator and to cryptographic primitives. */\ninterface Crypto {\n    /** Available only in secure contexts. */\n    readonly subtle: SubtleCrypto;\n    getRandomValues<T extends ArrayBufferView | null>(array: T): T;\n    /** Available only in secure contexts. */\n    randomUUID(): `${string}-${string}-${string}-${string}-${string}`;\n}\n\ndeclare var Crypto: {\n    prototype: Crypto;\n    new(): Crypto;\n};\n\n/**\n * The CryptoKey dictionary of the Web Crypto API represents a cryptographic key.\n * Available only in secure contexts.\n */\ninterface CryptoKey {\n    readonly algorithm: KeyAlgorithm;\n    readonly extractable: boolean;\n    readonly type: KeyType;\n    readonly usages: KeyUsage[];\n}\n\ndeclare var CryptoKey: {\n    prototype: CryptoKey;\n    new(): CryptoKey;\n};\n\ninterface CustomElementRegistry {\n    define(name: string, constructor: CustomElementConstructor, options?: ElementDefinitionOptions): void;\n    get(name: string): CustomElementConstructor | undefined;\n    upgrade(root: Node): void;\n    whenDefined(name: string): Promise<CustomElementConstructor>;\n}\n\ndeclare var CustomElementRegistry: {\n    prototype: CustomElementRegistry;\n    new(): CustomElementRegistry;\n};\n\ninterface CustomEvent<T = any> extends Event {\n    /** Returns any custom data event was created with. Typically used for synthetic events. */\n    readonly detail: T;\n    /** @deprecated */\n    initCustomEvent(type: string, bubbles?: boolean, cancelable?: boolean, detail?: T): void;\n}\n\ndeclare var CustomEvent: {\n    prototype: CustomEvent;\n    new<T>(type: string, eventInitDict?: CustomEventInit<T>): CustomEvent<T>;\n};\n\n/** An abnormal event (called an exception) which occurs as a result of calling a method or accessing a property of a web API. */\ninterface DOMException extends Error {\n    /** @deprecated */\n    readonly code: number;\n    readonly message: string;\n    readonly name: string;\n    readonly INDEX_SIZE_ERR: 1;\n    readonly DOMSTRING_SIZE_ERR: 2;\n    readonly HIERARCHY_REQUEST_ERR: 3;\n    readonly WRONG_DOCUMENT_ERR: 4;\n    readonly INVALID_CHARACTER_ERR: 5;\n    readonly NO_DATA_ALLOWED_ERR: 6;\n    readonly NO_MODIFICATION_ALLOWED_ERR: 7;\n    readonly NOT_FOUND_ERR: 8;\n    readonly NOT_SUPPORTED_ERR: 9;\n    readonly INUSE_ATTRIBUTE_ERR: 10;\n    readonly INVALID_STATE_ERR: 11;\n    readonly SYNTAX_ERR: 12;\n    readonly INVALID_MODIFICATION_ERR: 13;\n    readonly NAMESPACE_ERR: 14;\n    readonly INVALID_ACCESS_ERR: 15;\n    readonly VALIDATION_ERR: 16;\n    readonly TYPE_MISMATCH_ERR: 17;\n    readonly SECURITY_ERR: 18;\n    readonly NETWORK_ERR: 19;\n    readonly ABORT_ERR: 20;\n    readonly URL_MISMATCH_ERR: 21;\n    readonly QUOTA_EXCEEDED_ERR: 22;\n    readonly TIMEOUT_ERR: 23;\n    readonly INVALID_NODE_TYPE_ERR: 24;\n    readonly DATA_CLONE_ERR: 25;\n}\n\ndeclare var DOMException: {\n    prototype: DOMException;\n    new(message?: string, name?: string): DOMException;\n    readonly INDEX_SIZE_ERR: 1;\n    readonly DOMSTRING_SIZE_ERR: 2;\n    readonly HIERARCHY_REQUEST_ERR: 3;\n    readonly WRONG_DOCUMENT_ERR: 4;\n    readonly INVALID_CHARACTER_ERR: 5;\n    readonly NO_DATA_ALLOWED_ERR: 6;\n    readonly NO_MODIFICATION_ALLOWED_ERR: 7;\n    readonly NOT_FOUND_ERR: 8;\n    readonly NOT_SUPPORTED_ERR: 9;\n    readonly INUSE_ATTRIBUTE_ERR: 10;\n    readonly INVALID_STATE_ERR: 11;\n    readonly SYNTAX_ERR: 12;\n    readonly INVALID_MODIFICATION_ERR: 13;\n    readonly NAMESPACE_ERR: 14;\n    readonly INVALID_ACCESS_ERR: 15;\n    readonly VALIDATION_ERR: 16;\n    readonly TYPE_MISMATCH_ERR: 17;\n    readonly SECURITY_ERR: 18;\n    readonly NETWORK_ERR: 19;\n    readonly ABORT_ERR: 20;\n    readonly URL_MISMATCH_ERR: 21;\n    readonly QUOTA_EXCEEDED_ERR: 22;\n    readonly TIMEOUT_ERR: 23;\n    readonly INVALID_NODE_TYPE_ERR: 24;\n    readonly DATA_CLONE_ERR: 25;\n};\n\n/** An object providing methods which are not dependent on any particular document. Such an object is returned by the Document.implementation property. */\ninterface DOMImplementation {\n    createDocument(namespace: string | null, qualifiedName: string | null, doctype?: DocumentType | null): XMLDocument;\n    createDocumentType(qualifiedName: string, publicId: string, systemId: string): DocumentType;\n    createHTMLDocument(title?: string): Document;\n    /** @deprecated */\n    hasFeature(...args: any[]): true;\n}\n\ndeclare var DOMImplementation: {\n    prototype: DOMImplementation;\n    new(): DOMImplementation;\n};\n\ninterface DOMMatrix extends DOMMatrixReadOnly {\n    a: number;\n    b: number;\n    c: number;\n    d: number;\n    e: number;\n    f: number;\n    m11: number;\n    m12: number;\n    m13: number;\n    m14: number;\n    m21: number;\n    m22: number;\n    m23: number;\n    m24: number;\n    m31: number;\n    m32: number;\n    m33: number;\n    m34: number;\n    m41: number;\n    m42: number;\n    m43: number;\n    m44: number;\n    invertSelf(): DOMMatrix;\n    multiplySelf(other?: DOMMatrixInit): DOMMatrix;\n    preMultiplySelf(other?: DOMMatrixInit): DOMMatrix;\n    rotateAxisAngleSelf(x?: number, y?: number, z?: number, angle?: number): DOMMatrix;\n    rotateFromVectorSelf(x?: number, y?: number): DOMMatrix;\n    rotateSelf(rotX?: number, rotY?: number, rotZ?: number): DOMMatrix;\n    scale3dSelf(scale?: number, originX?: number, originY?: number, originZ?: number): DOMMatrix;\n    scaleSelf(scaleX?: number, scaleY?: number, scaleZ?: number, originX?: number, originY?: number, originZ?: number): DOMMatrix;\n    setMatrixValue(transformList: string): DOMMatrix;\n    skewXSelf(sx?: number): DOMMatrix;\n    skewYSelf(sy?: number): DOMMatrix;\n    translateSelf(tx?: number, ty?: number, tz?: number): DOMMatrix;\n}\n\ndeclare var DOMMatrix: {\n    prototype: DOMMatrix;\n    new(init?: string | number[]): DOMMatrix;\n    fromFloat32Array(array32: Float32Array): DOMMatrix;\n    fromFloat64Array(array64: Float64Array): DOMMatrix;\n    fromMatrix(other?: DOMMatrixInit): DOMMatrix;\n};\n\ntype SVGMatrix = DOMMatrix;\ndeclare var SVGMatrix: typeof DOMMatrix;\n\ntype WebKitCSSMatrix = DOMMatrix;\ndeclare var WebKitCSSMatrix: typeof DOMMatrix;\n\ninterface DOMMatrixReadOnly {\n    readonly a: number;\n    readonly b: number;\n    readonly c: number;\n    readonly d: number;\n    readonly e: number;\n    readonly f: number;\n    readonly is2D: boolean;\n    readonly isIdentity: boolean;\n    readonly m11: number;\n    readonly m12: number;\n    readonly m13: number;\n    readonly m14: number;\n    readonly m21: number;\n    readonly m22: number;\n    readonly m23: number;\n    readonly m24: number;\n    readonly m31: number;\n    readonly m32: number;\n    readonly m33: number;\n    readonly m34: number;\n    readonly m41: number;\n    readonly m42: number;\n    readonly m43: number;\n    readonly m44: number;\n    flipX(): DOMMatrix;\n    flipY(): DOMMatrix;\n    inverse(): DOMMatrix;\n    multiply(other?: DOMMatrixInit): DOMMatrix;\n    rotate(rotX?: number, rotY?: number, rotZ?: number): DOMMatrix;\n    rotateAxisAngle(x?: number, y?: number, z?: number, angle?: number): DOMMatrix;\n    rotateFromVector(x?: number, y?: number): DOMMatrix;\n    scale(scaleX?: number, scaleY?: number, scaleZ?: number, originX?: number, originY?: number, originZ?: number): DOMMatrix;\n    scale3d(scale?: number, originX?: number, originY?: number, originZ?: number): DOMMatrix;\n    /** @deprecated */\n    scaleNonUniform(scaleX?: number, scaleY?: number): DOMMatrix;\n    skewX(sx?: number): DOMMatrix;\n    skewY(sy?: number): DOMMatrix;\n    toFloat32Array(): Float32Array;\n    toFloat64Array(): Float64Array;\n    toJSON(): any;\n    transformPoint(point?: DOMPointInit): DOMPoint;\n    translate(tx?: number, ty?: number, tz?: number): DOMMatrix;\n    toString(): string;\n}\n\ndeclare var DOMMatrixReadOnly: {\n    prototype: DOMMatrixReadOnly;\n    new(init?: string | number[]): DOMMatrixReadOnly;\n    fromFloat32Array(array32: Float32Array): DOMMatrixReadOnly;\n    fromFloat64Array(array64: Float64Array): DOMMatrixReadOnly;\n    fromMatrix(other?: DOMMatrixInit): DOMMatrixReadOnly;\n    toString(): string;\n};\n\n/** Provides the ability to parse XML or HTML source code from a string into a DOM Document. */\ninterface DOMParser {\n    /**\n     * Parses string using either the HTML or XML parser, according to type, and returns the resulting Document. type can be \"text/html\" (which will invoke the HTML parser), or any of \"text/xml\", \"application/xml\", \"application/xhtml+xml\", or \"image/svg+xml\" (which will invoke the XML parser).\n     *\n     * For the XML parser, if string cannot be parsed, then the returned Document will contain elements describing the resulting error.\n     *\n     * Note that script elements are not evaluated during parsing, and the resulting document's encoding will always be UTF-8.\n     *\n     * Values other than the above for type will cause a TypeError exception to be thrown.\n     */\n    parseFromString(string: string, type: DOMParserSupportedType): Document;\n}\n\ndeclare var DOMParser: {\n    prototype: DOMParser;\n    new(): DOMParser;\n};\n\ninterface DOMPoint extends DOMPointReadOnly {\n    w: number;\n    x: number;\n    y: number;\n    z: number;\n}\n\ndeclare var DOMPoint: {\n    prototype: DOMPoint;\n    new(x?: number, y?: number, z?: number, w?: number): DOMPoint;\n    fromPoint(other?: DOMPointInit): DOMPoint;\n};\n\ntype SVGPoint = DOMPoint;\ndeclare var SVGPoint: typeof DOMPoint;\n\ninterface DOMPointReadOnly {\n    readonly w: number;\n    readonly x: number;\n    readonly y: number;\n    readonly z: number;\n    matrixTransform(matrix?: DOMMatrixInit): DOMPoint;\n    toJSON(): any;\n}\n\ndeclare var DOMPointReadOnly: {\n    prototype: DOMPointReadOnly;\n    new(x?: number, y?: number, z?: number, w?: number): DOMPointReadOnly;\n    fromPoint(other?: DOMPointInit): DOMPointReadOnly;\n};\n\ninterface DOMQuad {\n    readonly p1: DOMPoint;\n    readonly p2: DOMPoint;\n    readonly p3: DOMPoint;\n    readonly p4: DOMPoint;\n    getBounds(): DOMRect;\n    toJSON(): any;\n}\n\ndeclare var DOMQuad: {\n    prototype: DOMQuad;\n    new(p1?: DOMPointInit, p2?: DOMPointInit, p3?: DOMPointInit, p4?: DOMPointInit): DOMQuad;\n    fromQuad(other?: DOMQuadInit): DOMQuad;\n    fromRect(other?: DOMRectInit): DOMQuad;\n};\n\ninterface DOMRect extends DOMRectReadOnly {\n    height: number;\n    width: number;\n    x: number;\n    y: number;\n}\n\ndeclare var DOMRect: {\n    prototype: DOMRect;\n    new(x?: number, y?: number, width?: number, height?: number): DOMRect;\n    fromRect(other?: DOMRectInit): DOMRect;\n};\n\ntype SVGRect = DOMRect;\ndeclare var SVGRect: typeof DOMRect;\n\ninterface DOMRectList {\n    readonly length: number;\n    item(index: number): DOMRect | null;\n    [index: number]: DOMRect;\n}\n\ndeclare var DOMRectList: {\n    prototype: DOMRectList;\n    new(): DOMRectList;\n};\n\ninterface DOMRectReadOnly {\n    readonly bottom: number;\n    readonly height: number;\n    readonly left: number;\n    readonly right: number;\n    readonly top: number;\n    readonly width: number;\n    readonly x: number;\n    readonly y: number;\n    toJSON(): any;\n}\n\ndeclare var DOMRectReadOnly: {\n    prototype: DOMRectReadOnly;\n    new(x?: number, y?: number, width?: number, height?: number): DOMRectReadOnly;\n    fromRect(other?: DOMRectInit): DOMRectReadOnly;\n};\n\n/** A type returned by some APIs which contains a list of DOMString (strings). */\ninterface DOMStringList {\n    /** Returns the number of strings in strings. */\n    readonly length: number;\n    /** Returns true if strings contains string, and false otherwise. */\n    contains(string: string): boolean;\n    /** Returns the string with index index from strings. */\n    item(index: number): string | null;\n    [index: number]: string;\n}\n\ndeclare var DOMStringList: {\n    prototype: DOMStringList;\n    new(): DOMStringList;\n};\n\n/** Used by the dataset HTML attribute to represent data for custom attributes added to elements. */\ninterface DOMStringMap {\n    [name: string]: string | undefined;\n}\n\ndeclare var DOMStringMap: {\n    prototype: DOMStringMap;\n    new(): DOMStringMap;\n};\n\n/** A set of space-separated tokens. Such a set is returned by Element.classList, HTMLLinkElement.relList, HTMLAnchorElement.relList, HTMLAreaElement.relList, HTMLIframeElement.sandbox, or HTMLOutputElement.htmlFor. It is indexed beginning with 0 as with JavaScript Array objects. DOMTokenList is always case-sensitive. */\ninterface DOMTokenList {\n    /** Returns the number of tokens. */\n    readonly length: number;\n    /**\n     * Returns the associated set as string.\n     *\n     * Can be set, to change the associated attribute.\n     */\n    value: string;\n    toString(): string;\n    /**\n     * Adds all arguments passed, except those already present.\n     *\n     * Throws a \"SyntaxError\" DOMException if one of the arguments is the empty string.\n     *\n     * Throws an \"InvalidCharacterError\" DOMException if one of the arguments contains any ASCII whitespace.\n     */\n    add(...tokens: string[]): void;\n    /** Returns true if token is present, and false otherwise. */\n    contains(token: string): boolean;\n    /** Returns the token with index index. */\n    item(index: number): string | null;\n    /**\n     * Removes arguments passed, if they are present.\n     *\n     * Throws a \"SyntaxError\" DOMException if one of the arguments is the empty string.\n     *\n     * Throws an \"InvalidCharacterError\" DOMException if one of the arguments contains any ASCII whitespace.\n     */\n    remove(...tokens: string[]): void;\n    /**\n     * Replaces token with newToken.\n     *\n     * Returns true if token was replaced with newToken, and false otherwise.\n     *\n     * Throws a \"SyntaxError\" DOMException if one of the arguments is the empty string.\n     *\n     * Throws an \"InvalidCharacterError\" DOMException if one of the arguments contains any ASCII whitespace.\n     */\n    replace(token: string, newToken: string): boolean;\n    /**\n     * Returns true if token is in the associated attribute's supported tokens. Returns false otherwise.\n     *\n     * Throws a TypeError if the associated attribute has no supported tokens defined.\n     */\n    supports(token: string): boolean;\n    /**\n     * If force is not given, \"toggles\" token, removing it if it's present and adding it if it's not present. If force is true, adds token (same as add()). If force is false, removes token (same as remove()).\n     *\n     * Returns true if token is now present, and false otherwise.\n     *\n     * Throws a \"SyntaxError\" DOMException if token is empty.\n     *\n     * Throws an \"InvalidCharacterError\" DOMException if token contains any spaces.\n     */\n    toggle(token: string, force?: boolean): boolean;\n    forEach(callbackfn: (value: string, key: number, parent: DOMTokenList) => void, thisArg?: any): void;\n    [index: number]: string;\n}\n\ndeclare var DOMTokenList: {\n    prototype: DOMTokenList;\n    new(): DOMTokenList;\n};\n\n/** Used to hold the data that is being dragged during a drag and drop operation. It may hold one or more data items, each of one or more data types. For more information about drag and drop, see HTML Drag and Drop API. */\ninterface DataTransfer {\n    /**\n     * Returns the kind of operation that is currently selected. If the kind of operation isn't one of those that is allowed by the effectAllowed attribute, then the operation will fail.\n     *\n     * Can be set, to change the selected operation.\n     *\n     * The possible values are \"none\", \"copy\", \"link\", and \"move\".\n     */\n    dropEffect: \"none\" | \"copy\" | \"link\" | \"move\";\n    /**\n     * Returns the kinds of operations that are to be allowed.\n     *\n     * Can be set (during the dragstart event), to change the allowed operations.\n     *\n     * The possible values are \"none\", \"copy\", \"copyLink\", \"copyMove\", \"link\", \"linkMove\", \"move\", \"all\", and \"uninitialized\",\n     */\n    effectAllowed: \"none\" | \"copy\" | \"copyLink\" | \"copyMove\" | \"link\" | \"linkMove\" | \"move\" | \"all\" | \"uninitialized\";\n    /** Returns a FileList of the files being dragged, if any. */\n    readonly files: FileList;\n    /** Returns a DataTransferItemList object, with the drag data. */\n    readonly items: DataTransferItemList;\n    /** Returns a frozen array listing the formats that were set in the dragstart event. In addition, if any files are being dragged, then one of the types will be the string \"Files\". */\n    readonly types: ReadonlyArray<string>;\n    /** Removes the data of the specified formats. Removes all data if the argument is omitted. */\n    clearData(format?: string): void;\n    /** Returns the specified data. If there is no such data, returns the empty string. */\n    getData(format: string): string;\n    /** Adds the specified data. */\n    setData(format: string, data: string): void;\n    /** Uses the given element to update the drag feedback, replacing any previously specified feedback. */\n    setDragImage(image: Element, x: number, y: number): void;\n}\n\ndeclare var DataTransfer: {\n    prototype: DataTransfer;\n    new(): DataTransfer;\n};\n\n/** One drag data item. During a drag operation, each drag event has a dataTransfer property which contains a list of drag data items. Each item in the list is a DataTransferItem object. */\ninterface DataTransferItem {\n    /** Returns the drag data item kind, one of: \"string\", \"file\". */\n    readonly kind: string;\n    /** Returns the drag data item type string. */\n    readonly type: string;\n    /** Returns a File object, if the drag data item kind is File. */\n    getAsFile(): File | null;\n    /** Invokes the callback with the string data as the argument, if the drag data item kind is text. */\n    getAsString(callback: FunctionStringCallback | null): void;\n    webkitGetAsEntry(): FileSystemEntry | null;\n}\n\ndeclare var DataTransferItem: {\n    prototype: DataTransferItem;\n    new(): DataTransferItem;\n};\n\n/** A list of DataTransferItem objects representing items being dragged. During a drag operation, each DragEvent has a dataTransfer property and that property is a DataTransferItemList. */\ninterface DataTransferItemList {\n    /** Returns the number of items in the drag data store. */\n    readonly length: number;\n    /** Adds a new entry for the given data to the drag data store. If the data is plain text then a type string has to be provided also. */\n    add(data: string, type: string): DataTransferItem | null;\n    add(data: File): DataTransferItem | null;\n    /** Removes all the entries in the drag data store. */\n    clear(): void;\n    /** Removes the indexth entry in the drag data store. */\n    remove(index: number): void;\n    [index: number]: DataTransferItem;\n}\n\ndeclare var DataTransferItemList: {\n    prototype: DataTransferItemList;\n    new(): DataTransferItemList;\n};\n\n/** A delay-line; an AudioNode audio-processing module that causes a delay between the arrival of an input data and its propagation to the output. */\ninterface DelayNode extends AudioNode {\n    readonly delayTime: AudioParam;\n}\n\ndeclare var DelayNode: {\n    prototype: DelayNode;\n    new(context: BaseAudioContext, options?: DelayOptions): DelayNode;\n};\n\n/**\n * The DeviceMotionEvent provides web developers with information about the speed of changes for the device's position and orientation.\n * Available only in secure contexts.\n */\ninterface DeviceMotionEvent extends Event {\n    readonly acceleration: DeviceMotionEventAcceleration | null;\n    readonly accelerationIncludingGravity: DeviceMotionEventAcceleration | null;\n    readonly interval: number;\n    readonly rotationRate: DeviceMotionEventRotationRate | null;\n}\n\ndeclare var DeviceMotionEvent: {\n    prototype: DeviceMotionEvent;\n    new(type: string, eventInitDict?: DeviceMotionEventInit): DeviceMotionEvent;\n};\n\n/** Available only in secure contexts. */\ninterface DeviceMotionEventAcceleration {\n    readonly x: number | null;\n    readonly y: number | null;\n    readonly z: number | null;\n}\n\n/** Available only in secure contexts. */\ninterface DeviceMotionEventRotationRate {\n    readonly alpha: number | null;\n    readonly beta: number | null;\n    readonly gamma: number | null;\n}\n\n/**\n * The DeviceOrientationEvent provides web developers with information from the physical orientation of the device running the web page.\n * Available only in secure contexts.\n */\ninterface DeviceOrientationEvent extends Event {\n    readonly absolute: boolean;\n    readonly alpha: number | null;\n    readonly beta: number | null;\n    readonly gamma: number | null;\n}\n\ndeclare var DeviceOrientationEvent: {\n    prototype: DeviceOrientationEvent;\n    new(type: string, eventInitDict?: DeviceOrientationEventInit): DeviceOrientationEvent;\n};\n\ninterface DocumentEventMap extends GlobalEventHandlersEventMap {\n    \"DOMContentLoaded\": Event;\n    \"fullscreenchange\": Event;\n    \"fullscreenerror\": Event;\n    \"pointerlockchange\": Event;\n    \"pointerlockerror\": Event;\n    \"readystatechange\": Event;\n    \"visibilitychange\": Event;\n}\n\n/** Any web page loaded in the browser and serves as an entry point into the web page's content, which is the DOM tree. */\ninterface Document extends Node, DocumentOrShadowRoot, FontFaceSource, GlobalEventHandlers, NonElementParentNode, ParentNode, XPathEvaluatorBase {\n    /** Sets or gets the URL for the current document. */\n    readonly URL: string;\n    /**\n     * Sets or gets the color of all active links in the document.\n     * @deprecated\n     */\n    alinkColor: string;\n    /**\n     * Returns a reference to the collection of elements contained by the object.\n     * @deprecated\n     */\n    readonly all: HTMLAllCollection;\n    /**\n     * Retrieves a collection of all a objects that have a name and/or id property. Objects in this collection are in HTML source order.\n     * @deprecated\n     */\n    readonly anchors: HTMLCollectionOf<HTMLAnchorElement>;\n    /**\n     * Retrieves a collection of all applet objects in the document.\n     * @deprecated\n     */\n    readonly applets: HTMLCollection;\n    /**\n     * Deprecated. Sets or retrieves a value that indicates the background color behind the object.\n     * @deprecated\n     */\n    bgColor: string;\n    /** Specifies the beginning and end of the document body. */\n    body: HTMLElement;\n    /** Returns document's encoding. */\n    readonly characterSet: string;\n    /**\n     * Gets or sets the character set used to encode the object.\n     * @deprecated This is a legacy alias of `characterSet`.\n     */\n    readonly charset: string;\n    /** Gets a value that indicates whether standards-compliant mode is switched on for the object. */\n    readonly compatMode: string;\n    /** Returns document's content type. */\n    readonly contentType: string;\n    /**\n     * Returns the HTTP cookies that apply to the Document. If there are no cookies or cookies can't be applied to this resource, the empty string will be returned.\n     *\n     * Can be set, to add a new cookie to the element's set of HTTP cookies.\n     *\n     * If the contents are sandboxed into a unique origin (e.g. in an iframe with the sandbox attribute), a \"SecurityError\" DOMException will be thrown on getting and setting.\n     */\n    cookie: string;\n    /**\n     * Returns the script element, or the SVG script element, that is currently executing, as long as the element represents a classic script. In the case of reentrant script execution, returns the one that most recently started executing amongst those that have not yet finished executing.\n     *\n     * Returns null if the Document is not currently executing a script or SVG script element (e.g., because the running script is an event handler, or a timeout), or if the currently executing script or SVG script element represents a module script.\n     */\n    readonly currentScript: HTMLOrSVGScriptElement | null;\n    /** Returns the Window object of the active document. */\n    readonly defaultView: (WindowProxy & typeof globalThis) | null;\n    /** Sets or gets a value that indicates whether the document can be edited. */\n    designMode: string;\n    /** Sets or retrieves a value that indicates the reading order of the object. */\n    dir: string;\n    /** Gets an object representing the document type declaration associated with the current document. */\n    readonly doctype: DocumentType | null;\n    /** Gets a reference to the root node of the document. */\n    readonly documentElement: HTMLElement;\n    /** Returns document's URL. */\n    readonly documentURI: string;\n    /**\n     * Sets or gets the security domain of the document.\n     * @deprecated\n     */\n    domain: string;\n    /** Retrieves a collection of all embed objects in the document. */\n    readonly embeds: HTMLCollectionOf<HTMLEmbedElement>;\n    /**\n     * Sets or gets the foreground (text) color of the document.\n     * @deprecated\n     */\n    fgColor: string;\n    /** Retrieves a collection, in source order, of all form objects in the document. */\n    readonly forms: HTMLCollectionOf<HTMLFormElement>;\n    /** @deprecated */\n    readonly fullscreen: boolean;\n    /** Returns true if document has the ability to display elements fullscreen and fullscreen is supported, or false otherwise. */\n    readonly fullscreenEnabled: boolean;\n    /** Returns the head element. */\n    readonly head: HTMLHeadElement;\n    readonly hidden: boolean;\n    /** Retrieves a collection, in source order, of img objects in the document. */\n    readonly images: HTMLCollectionOf<HTMLImageElement>;\n    /** Gets the implementation object of the current document. */\n    readonly implementation: DOMImplementation;\n    /**\n     * Returns the character encoding used to create the webpage that is loaded into the document object.\n     * @deprecated This is a legacy alias of `characterSet`.\n     */\n    readonly inputEncoding: string;\n    /** Gets the date that the page was last modified, if the page supplies one. */\n    readonly lastModified: string;\n    /**\n     * Sets or gets the color of the document links.\n     * @deprecated\n     */\n    linkColor: string;\n    /** Retrieves a collection of all a objects that specify the href property and all area objects in the document. */\n    readonly links: HTMLCollectionOf<HTMLAnchorElement | HTMLAreaElement>;\n    /** Contains information about the current URL. */\n    get location(): Location;\n    set location(href: string | Location);\n    onfullscreenchange: ((this: Document, ev: Event) => any) | null;\n    onfullscreenerror: ((this: Document, ev: Event) => any) | null;\n    onpointerlockchange: ((this: Document, ev: Event) => any) | null;\n    onpointerlockerror: ((this: Document, ev: Event) => any) | null;\n    /**\n     * Fires when the state of the object has changed.\n     * @param ev The event\n     */\n    onreadystatechange: ((this: Document, ev: Event) => any) | null;\n    onvisibilitychange: ((this: Document, ev: Event) => any) | null;\n    readonly ownerDocument: null;\n    readonly pictureInPictureEnabled: boolean;\n    /** Return an HTMLCollection of the embed elements in the Document. */\n    readonly plugins: HTMLCollectionOf<HTMLEmbedElement>;\n    /** Retrieves a value that indicates the current state of the object. */\n    readonly readyState: DocumentReadyState;\n    /** Gets the URL of the location that referred the user to the current page. */\n    readonly referrer: string;\n    /** @deprecated */\n    readonly rootElement: SVGSVGElement | null;\n    /** Retrieves a collection of all script objects in the document. */\n    readonly scripts: HTMLCollectionOf<HTMLScriptElement>;\n    readonly scrollingElement: Element | null;\n    readonly timeline: DocumentTimeline;\n    /** Contains the title of the document. */\n    title: string;\n    readonly visibilityState: DocumentVisibilityState;\n    /**\n     * Sets or gets the color of the links that the user has visited.\n     * @deprecated\n     */\n    vlinkColor: string;\n    /**\n     * Moves node from another document and returns it.\n     *\n     * If node is a document, throws a \"NotSupportedError\" DOMException or, if node is a shadow root, throws a \"HierarchyRequestError\" DOMException.\n     */\n    adoptNode<T extends Node>(node: T): T;\n    /** @deprecated */\n    captureEvents(): void;\n    /** @deprecated */\n    caretRangeFromPoint(x: number, y: number): Range | null;\n    /** @deprecated */\n    clear(): void;\n    /** Closes an output stream and forces the sent data to display. */\n    close(): void;\n    /**\n     * Creates an attribute object with a specified name.\n     * @param name String that sets the attribute object's name.\n     */\n    createAttribute(localName: string): Attr;\n    createAttributeNS(namespace: string | null, qualifiedName: string): Attr;\n    /** Returns a CDATASection node whose data is data. */\n    createCDATASection(data: string): CDATASection;\n    /**\n     * Creates a comment object with the specified data.\n     * @param data Sets the comment object's data.\n     */\n    createComment(data: string): Comment;\n    /** Creates a new document. */\n    createDocumentFragment(): DocumentFragment;\n    /**\n     * Creates an instance of the element for the specified tag.\n     * @param tagName The name of an element.\n     */\n    createElement<K extends keyof HTMLElementTagNameMap>(tagName: K, options?: ElementCreationOptions): HTMLElementTagNameMap[K];\n    /** @deprecated */\n    createElement<K extends keyof HTMLElementDeprecatedTagNameMap>(tagName: K, options?: ElementCreationOptions): HTMLElementDeprecatedTagNameMap[K];\n    createElement(tagName: string, options?: ElementCreationOptions): HTMLElement;\n    /**\n     * Returns an element with namespace namespace. Its namespace prefix will be everything before \":\" (U+003E) in qualifiedName or null. Its local name will be everything after \":\" (U+003E) in qualifiedName or qualifiedName.\n     *\n     * If localName does not match the Name production an \"InvalidCharacterError\" DOMException will be thrown.\n     *\n     * If one of the following conditions is true a \"NamespaceError\" DOMException will be thrown:\n     *\n     * localName does not match the QName production.\n     * Namespace prefix is not null and namespace is the empty string.\n     * Namespace prefix is \"xml\" and namespace is not the XML namespace.\n     * qualifiedName or namespace prefix is \"xmlns\" and namespace is not the XMLNS namespace.\n     * namespace is the XMLNS namespace and neither qualifiedName nor namespace prefix is \"xmlns\".\n     *\n     * When supplied, options's is can be used to create a customized built-in element.\n     */\n    createElementNS(namespaceURI: \"http://www.w3.org/1999/xhtml\", qualifiedName: string): HTMLElement;\n    createElementNS<K extends keyof SVGElementTagNameMap>(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: K): SVGElementTagNameMap[K];\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: string): SVGElement;\n    createElementNS<K extends keyof MathMLElementTagNameMap>(namespaceURI: \"http://www.w3.org/1998/Math/MathML\", qualifiedName: K): MathMLElementTagNameMap[K];\n    createElementNS(namespaceURI: \"http://www.w3.org/1998/Math/MathML\", qualifiedName: string): MathMLElement;\n    createElementNS(namespaceURI: string | null, qualifiedName: string, options?: ElementCreationOptions): Element;\n    createElementNS(namespace: string | null, qualifiedName: string, options?: string | ElementCreationOptions): Element;\n    createEvent(eventInterface: \"AnimationEvent\"): AnimationEvent;\n    createEvent(eventInterface: \"AnimationPlaybackEvent\"): AnimationPlaybackEvent;\n    createEvent(eventInterface: \"AudioProcessingEvent\"): AudioProcessingEvent;\n    createEvent(eventInterface: \"BeforeUnloadEvent\"): BeforeUnloadEvent;\n    createEvent(eventInterface: \"BlobEvent\"): BlobEvent;\n    createEvent(eventInterface: \"ClipboardEvent\"): ClipboardEvent;\n    createEvent(eventInterface: \"CloseEvent\"): CloseEvent;\n    createEvent(eventInterface: \"CompositionEvent\"): CompositionEvent;\n    createEvent(eventInterface: \"CustomEvent\"): CustomEvent;\n    createEvent(eventInterface: \"DeviceMotionEvent\"): DeviceMotionEvent;\n    createEvent(eventInterface: \"DeviceOrientationEvent\"): DeviceOrientationEvent;\n    createEvent(eventInterface: \"DragEvent\"): DragEvent;\n    createEvent(eventInterface: \"ErrorEvent\"): ErrorEvent;\n    createEvent(eventInterface: \"Event\"): Event;\n    createEvent(eventInterface: \"Events\"): Event;\n    createEvent(eventInterface: \"FocusEvent\"): FocusEvent;\n    createEvent(eventInterface: \"FontFaceSetLoadEvent\"): FontFaceSetLoadEvent;\n    createEvent(eventInterface: \"FormDataEvent\"): FormDataEvent;\n    createEvent(eventInterface: \"GamepadEvent\"): GamepadEvent;\n    createEvent(eventInterface: \"HashChangeEvent\"): HashChangeEvent;\n    createEvent(eventInterface: \"IDBVersionChangeEvent\"): IDBVersionChangeEvent;\n    createEvent(eventInterface: \"InputEvent\"): InputEvent;\n    createEvent(eventInterface: \"KeyboardEvent\"): KeyboardEvent;\n    createEvent(eventInterface: \"MIDIConnectionEvent\"): MIDIConnectionEvent;\n    createEvent(eventInterface: \"MIDIMessageEvent\"): MIDIMessageEvent;\n    createEvent(eventInterface: \"MediaEncryptedEvent\"): MediaEncryptedEvent;\n    createEvent(eventInterface: \"MediaKeyMessageEvent\"): MediaKeyMessageEvent;\n    createEvent(eventInterface: \"MediaQueryListEvent\"): MediaQueryListEvent;\n    createEvent(eventInterface: \"MediaStreamTrackEvent\"): MediaStreamTrackEvent;\n    createEvent(eventInterface: \"MessageEvent\"): MessageEvent;\n    createEvent(eventInterface: \"MouseEvent\"): MouseEvent;\n    createEvent(eventInterface: \"MouseEvents\"): MouseEvent;\n    createEvent(eventInterface: \"MutationEvent\"): MutationEvent;\n    createEvent(eventInterface: \"MutationEvents\"): MutationEvent;\n    createEvent(eventInterface: \"OfflineAudioCompletionEvent\"): OfflineAudioCompletionEvent;\n    createEvent(eventInterface: \"PageTransitionEvent\"): PageTransitionEvent;\n    createEvent(eventInterface: \"PaymentMethodChangeEvent\"): PaymentMethodChangeEvent;\n    createEvent(eventInterface: \"PaymentRequestUpdateEvent\"): PaymentRequestUpdateEvent;\n    createEvent(eventInterface: \"PictureInPictureEvent\"): PictureInPictureEvent;\n    createEvent(eventInterface: \"PointerEvent\"): PointerEvent;\n    createEvent(eventInterface: \"PopStateEvent\"): PopStateEvent;\n    createEvent(eventInterface: \"ProgressEvent\"): ProgressEvent;\n    createEvent(eventInterface: \"PromiseRejectionEvent\"): PromiseRejectionEvent;\n    createEvent(eventInterface: \"RTCDTMFToneChangeEvent\"): RTCDTMFToneChangeEvent;\n    createEvent(eventInterface: \"RTCDataChannelEvent\"): RTCDataChannelEvent;\n    createEvent(eventInterface: \"RTCErrorEvent\"): RTCErrorEvent;\n    createEvent(eventInterface: \"RTCPeerConnectionIceErrorEvent\"): RTCPeerConnectionIceErrorEvent;\n    createEvent(eventInterface: \"RTCPeerConnectionIceEvent\"): RTCPeerConnectionIceEvent;\n    createEvent(eventInterface: \"RTCTrackEvent\"): RTCTrackEvent;\n    createEvent(eventInterface: \"SecurityPolicyViolationEvent\"): SecurityPolicyViolationEvent;\n    createEvent(eventInterface: \"SpeechSynthesisErrorEvent\"): SpeechSynthesisErrorEvent;\n    createEvent(eventInterface: \"SpeechSynthesisEvent\"): SpeechSynthesisEvent;\n    createEvent(eventInterface: \"StorageEvent\"): StorageEvent;\n    createEvent(eventInterface: \"SubmitEvent\"): SubmitEvent;\n    createEvent(eventInterface: \"TouchEvent\"): TouchEvent;\n    createEvent(eventInterface: \"TrackEvent\"): TrackEvent;\n    createEvent(eventInterface: \"TransitionEvent\"): TransitionEvent;\n    createEvent(eventInterface: \"UIEvent\"): UIEvent;\n    createEvent(eventInterface: \"UIEvents\"): UIEvent;\n    createEvent(eventInterface: \"WebGLContextEvent\"): WebGLContextEvent;\n    createEvent(eventInterface: \"WheelEvent\"): WheelEvent;\n    createEvent(eventInterface: string): Event;\n    /**\n     * Creates a NodeIterator object that you can use to traverse filtered lists of nodes or elements in a document.\n     * @param root The root element or node to start traversing on.\n     * @param whatToShow The type of nodes or elements to appear in the node list\n     * @param filter A custom NodeFilter function to use. For more information, see filter. Use null for no filter.\n     */\n    createNodeIterator(root: Node, whatToShow?: number, filter?: NodeFilter | null): NodeIterator;\n    /** Returns a ProcessingInstruction node whose target is target and data is data. If target does not match the Name production an \"InvalidCharacterError\" DOMException will be thrown. If data contains \"?>\" an \"InvalidCharacterError\" DOMException will be thrown. */\n    createProcessingInstruction(target: string, data: string): ProcessingInstruction;\n    /**  Returns an empty range object that has both of its boundary points positioned at the beginning of the document. */\n    createRange(): Range;\n    /**\n     * Creates a text string from the specified value.\n     * @param data String that specifies the nodeValue property of the text node.\n     */\n    createTextNode(data: string): Text;\n    /**\n     * Creates a TreeWalker object that you can use to traverse filtered lists of nodes or elements in a document.\n     * @param root The root element or node to start traversing on.\n     * @param whatToShow The type of nodes or elements to appear in the node list. For more information, see whatToShow.\n     * @param filter A custom NodeFilter function to use.\n     */\n    createTreeWalker(root: Node, whatToShow?: number, filter?: NodeFilter | null): TreeWalker;\n    /**\n     * Executes a command on the current document, current selection, or the given range.\n     * @param commandId String that specifies the command to execute. This command can be any of the command identifiers that can be executed in script.\n     * @param showUI Display the user interface, defaults to false.\n     * @param value Value to assign.\n     * @deprecated\n     */\n    execCommand(commandId: string, showUI?: boolean, value?: string): boolean;\n    /** Stops document's fullscreen element from being displayed fullscreen and resolves promise when done. */\n    exitFullscreen(): Promise<void>;\n    exitPictureInPicture(): Promise<void>;\n    exitPointerLock(): void;\n    /**\n     * Returns a reference to the first object with the specified value of the ID attribute.\n     * @param elementId String that specifies the ID value.\n     */\n    getElementById(elementId: string): HTMLElement | null;\n    /** Returns a HTMLCollection of the elements in the object on which the method was invoked (a document or an element) that have all the classes given by classNames. The classNames argument is interpreted as a space-separated list of classes. */\n    getElementsByClassName(classNames: string): HTMLCollectionOf<Element>;\n    /**\n     * Gets a collection of objects based on the value of the NAME or ID attribute.\n     * @param elementName Gets a collection of objects based on the value of the NAME or ID attribute.\n     */\n    getElementsByName(elementName: string): NodeListOf<HTMLElement>;\n    /**\n     * Retrieves a collection of objects based on the specified element name.\n     * @param name Specifies the name of an element.\n     */\n    getElementsByTagName<K extends keyof HTMLElementTagNameMap>(qualifiedName: K): HTMLCollectionOf<HTMLElementTagNameMap[K]>;\n    getElementsByTagName<K extends keyof SVGElementTagNameMap>(qualifiedName: K): HTMLCollectionOf<SVGElementTagNameMap[K]>;\n    getElementsByTagName<K extends keyof MathMLElementTagNameMap>(qualifiedName: K): HTMLCollectionOf<MathMLElementTagNameMap[K]>;\n    /** @deprecated */\n    getElementsByTagName<K extends keyof HTMLElementDeprecatedTagNameMap>(qualifiedName: K): HTMLCollectionOf<HTMLElementDeprecatedTagNameMap[K]>;\n    getElementsByTagName(qualifiedName: string): HTMLCollectionOf<Element>;\n    /**\n     * If namespace and localName are \"*\" returns a HTMLCollection of all descendant elements.\n     *\n     * If only namespace is \"*\" returns a HTMLCollection of all descendant elements whose local name is localName.\n     *\n     * If only localName is \"*\" returns a HTMLCollection of all descendant elements whose namespace is namespace.\n     *\n     * Otherwise, returns a HTMLCollection of all descendant elements whose namespace is namespace and local name is localName.\n     */\n    getElementsByTagNameNS(namespaceURI: \"http://www.w3.org/1999/xhtml\", localName: string): HTMLCollectionOf<HTMLElement>;\n    getElementsByTagNameNS(namespaceURI: \"http://www.w3.org/2000/svg\", localName: string): HTMLCollectionOf<SVGElement>;\n    getElementsByTagNameNS(namespaceURI: \"http://www.w3.org/1998/Math/MathML\", localName: string): HTMLCollectionOf<MathMLElement>;\n    getElementsByTagNameNS(namespace: string | null, localName: string): HTMLCollectionOf<Element>;\n    /** Returns an object representing the current selection of the document that is loaded into the object displaying a webpage. */\n    getSelection(): Selection | null;\n    /** Gets a value indicating whether the object currently has focus. */\n    hasFocus(): boolean;\n    hasStorageAccess(): Promise<boolean>;\n    /**\n     * Returns a copy of node. If deep is true, the copy also includes the node's descendants.\n     *\n     * If node is a document or a shadow root, throws a \"NotSupportedError\" DOMException.\n     */\n    importNode<T extends Node>(node: T, deep?: boolean): T;\n    /**\n     * Opens a new window and loads a document specified by a given URL. Also, opens a new window that uses the url parameter and the name parameter to collect the output of the write method and the writeln method.\n     * @param url Specifies a MIME type for the document.\n     * @param name Specifies the name of the window. This name is used as the value for the TARGET attribute on a form or an anchor element.\n     * @param features Contains a list of items separated by commas. Each item consists of an option and a value, separated by an equals sign (for example, \"fullscreen=yes, toolbar=yes\"). The following values are supported.\n     * @param replace Specifies whether the existing entry for the document is replaced in the history list.\n     */\n    open(unused1?: string, unused2?: string): Document;\n    open(url: string | URL, name: string, features: string): WindowProxy | null;\n    /**\n     * Returns a Boolean value that indicates whether a specified command can be successfully executed using execCommand, given the current state of the document.\n     * @param commandId Specifies a command identifier.\n     * @deprecated\n     */\n    queryCommandEnabled(commandId: string): boolean;\n    /**\n     * Returns a Boolean value that indicates whether the specified command is in the indeterminate state.\n     * @param commandId String that specifies a command identifier.\n     * @deprecated\n     */\n    queryCommandIndeterm(commandId: string): boolean;\n    /**\n     * Returns a Boolean value that indicates the current state of the command.\n     * @param commandId String that specifies a command identifier.\n     * @deprecated\n     */\n    queryCommandState(commandId: string): boolean;\n    /**\n     * Returns a Boolean value that indicates whether the current command is supported on the current range.\n     * @param commandId Specifies a command identifier.\n     * @deprecated\n     */\n    queryCommandSupported(commandId: string): boolean;\n    /**\n     * Returns the current value of the document, range, or current selection for the given command.\n     * @param commandId String that specifies a command identifier.\n     * @deprecated\n     */\n    queryCommandValue(commandId: string): string;\n    /** @deprecated */\n    releaseEvents(): void;\n    requestStorageAccess(): Promise<void>;\n    /**\n     * Writes one or more HTML expressions to a document in the specified window.\n     * @param content Specifies the text and HTML tags to write.\n     */\n    write(...text: string[]): void;\n    /**\n     * Writes one or more HTML expressions, followed by a carriage return, to a document in the specified window.\n     * @param content The text and HTML tags to write.\n     */\n    writeln(...text: string[]): void;\n    addEventListener<K extends keyof DocumentEventMap>(type: K, listener: (this: Document, ev: DocumentEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof DocumentEventMap>(type: K, listener: (this: Document, ev: DocumentEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var Document: {\n    prototype: Document;\n    new(): Document;\n};\n\n/** A minimal document object that has no parent. It is used as a lightweight version of Document that stores a segment of a document structure comprised of nodes just like a standard document. The key difference is that because the document fragment isn't part of the active document tree structure, changes made to the fragment don't affect the document, cause reflow, or incur any performance impact that can occur when changes are made. */\ninterface DocumentFragment extends Node, NonElementParentNode, ParentNode {\n    readonly ownerDocument: Document;\n    getElementById(elementId: string): HTMLElement | null;\n}\n\ndeclare var DocumentFragment: {\n    prototype: DocumentFragment;\n    new(): DocumentFragment;\n};\n\ninterface DocumentOrShadowRoot {\n    /**\n     * Returns the deepest element in the document through which or to which key events are being routed. This is, roughly speaking, the focused element in the document.\n     *\n     * For the purposes of this API, when a child browsing context is focused, its container is focused in the parent browsing context. For example, if the user moves the focus to a text control in an iframe, the iframe is the element returned by the activeElement API in the iframe's node document.\n     *\n     * Similarly, when the focused element is in a different node tree than documentOrShadowRoot, the element returned will be the host that's located in the same node tree as documentOrShadowRoot if documentOrShadowRoot is a shadow-including inclusive ancestor of the focused element, and null if not.\n     */\n    readonly activeElement: Element | null;\n    adoptedStyleSheets: CSSStyleSheet[];\n    /** Returns document's fullscreen element. */\n    readonly fullscreenElement: Element | null;\n    readonly pictureInPictureElement: Element | null;\n    readonly pointerLockElement: Element | null;\n    /** Retrieves a collection of styleSheet objects representing the style sheets that correspond to each instance of a link or style object in the document. */\n    readonly styleSheets: StyleSheetList;\n    /**\n     * Returns the element for the specified x coordinate and the specified y coordinate.\n     * @param x The x-offset\n     * @param y The y-offset\n     */\n    elementFromPoint(x: number, y: number): Element | null;\n    elementsFromPoint(x: number, y: number): Element[];\n    getAnimations(): Animation[];\n}\n\ninterface DocumentTimeline extends AnimationTimeline {\n}\n\ndeclare var DocumentTimeline: {\n    prototype: DocumentTimeline;\n    new(options?: DocumentTimelineOptions): DocumentTimeline;\n};\n\n/** A Node containing a doctype. */\ninterface DocumentType extends Node, ChildNode {\n    readonly name: string;\n    readonly ownerDocument: Document;\n    readonly publicId: string;\n    readonly systemId: string;\n}\n\ndeclare var DocumentType: {\n    prototype: DocumentType;\n    new(): DocumentType;\n};\n\n/** A DOM event that represents a drag and drop interaction. The user initiates a drag by placing a pointer device (such as a mouse) on the touch surface and then dragging the pointer to a new location (such as another DOM element). Applications are free to interpret a drag and drop interaction in an application-specific way. */\ninterface DragEvent extends MouseEvent {\n    /** Returns the DataTransfer object for the event. */\n    readonly dataTransfer: DataTransfer | null;\n}\n\ndeclare var DragEvent: {\n    prototype: DragEvent;\n    new(type: string, eventInitDict?: DragEventInit): DragEvent;\n};\n\n/** Inherits properties from its parent, AudioNode. */\ninterface DynamicsCompressorNode extends AudioNode {\n    readonly attack: AudioParam;\n    readonly knee: AudioParam;\n    readonly ratio: AudioParam;\n    readonly reduction: number;\n    readonly release: AudioParam;\n    readonly threshold: AudioParam;\n}\n\ndeclare var DynamicsCompressorNode: {\n    prototype: DynamicsCompressorNode;\n    new(context: BaseAudioContext, options?: DynamicsCompressorOptions): DynamicsCompressorNode;\n};\n\ninterface EXT_blend_minmax {\n    readonly MIN_EXT: 0x8007;\n    readonly MAX_EXT: 0x8008;\n}\n\ninterface EXT_color_buffer_float {\n}\n\ninterface EXT_color_buffer_half_float {\n    readonly RGBA16F_EXT: 0x881A;\n    readonly RGB16F_EXT: 0x881B;\n    readonly FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE_EXT: 0x8211;\n    readonly UNSIGNED_NORMALIZED_EXT: 0x8C17;\n}\n\ninterface EXT_float_blend {\n}\n\n/** The EXT_frag_depth extension is part of the WebGL API and enables to set a depth value of a fragment from within the fragment shader. */\ninterface EXT_frag_depth {\n}\n\ninterface EXT_sRGB {\n    readonly SRGB_EXT: 0x8C40;\n    readonly SRGB_ALPHA_EXT: 0x8C42;\n    readonly SRGB8_ALPHA8_EXT: 0x8C43;\n    readonly FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING_EXT: 0x8210;\n}\n\ninterface EXT_shader_texture_lod {\n}\n\ninterface EXT_texture_compression_bptc {\n    readonly COMPRESSED_RGBA_BPTC_UNORM_EXT: 0x8E8C;\n    readonly COMPRESSED_SRGB_ALPHA_BPTC_UNORM_EXT: 0x8E8D;\n    readonly COMPRESSED_RGB_BPTC_SIGNED_FLOAT_EXT: 0x8E8E;\n    readonly COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_EXT: 0x8E8F;\n}\n\ninterface EXT_texture_compression_rgtc {\n    readonly COMPRESSED_RED_RGTC1_EXT: 0x8DBB;\n    readonly COMPRESSED_SIGNED_RED_RGTC1_EXT: 0x8DBC;\n    readonly COMPRESSED_RED_GREEN_RGTC2_EXT: 0x8DBD;\n    readonly COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT: 0x8DBE;\n}\n\n/** The EXT_texture_filter_anisotropic extension is part of the WebGL API and exposes two constants for anisotropic filtering (AF). */\ninterface EXT_texture_filter_anisotropic {\n    readonly TEXTURE_MAX_ANISOTROPY_EXT: 0x84FE;\n    readonly MAX_TEXTURE_MAX_ANISOTROPY_EXT: 0x84FF;\n}\n\ninterface EXT_texture_norm16 {\n    readonly R16_EXT: 0x822A;\n    readonly RG16_EXT: 0x822C;\n    readonly RGB16_EXT: 0x8054;\n    readonly RGBA16_EXT: 0x805B;\n    readonly R16_SNORM_EXT: 0x8F98;\n    readonly RG16_SNORM_EXT: 0x8F99;\n    readonly RGB16_SNORM_EXT: 0x8F9A;\n    readonly RGBA16_SNORM_EXT: 0x8F9B;\n}\n\ninterface ElementEventMap {\n    \"fullscreenchange\": Event;\n    \"fullscreenerror\": Event;\n}\n\n/** Element is the most general base class from which all objects in a Document inherit. It only has methods and properties common to all kinds of elements. More specific classes inherit from Element. */\ninterface Element extends Node, ARIAMixin, Animatable, ChildNode, InnerHTML, NonDocumentTypeChildNode, ParentNode, Slottable {\n    readonly attributes: NamedNodeMap;\n    /** Allows for manipulation of element's class content attribute as a set of whitespace-separated tokens through a DOMTokenList object. */\n    readonly classList: DOMTokenList;\n    /** Returns the value of element's class content attribute. Can be set to change it. */\n    className: string;\n    readonly clientHeight: number;\n    readonly clientLeft: number;\n    readonly clientTop: number;\n    readonly clientWidth: number;\n    /** Returns the value of element's id content attribute. Can be set to change it. */\n    id: string;\n    /** Returns the local name. */\n    readonly localName: string;\n    /** Returns the namespace. */\n    readonly namespaceURI: string | null;\n    onfullscreenchange: ((this: Element, ev: Event) => any) | null;\n    onfullscreenerror: ((this: Element, ev: Event) => any) | null;\n    outerHTML: string;\n    readonly ownerDocument: Document;\n    readonly part: DOMTokenList;\n    /** Returns the namespace prefix. */\n    readonly prefix: string | null;\n    readonly scrollHeight: number;\n    scrollLeft: number;\n    scrollTop: number;\n    readonly scrollWidth: number;\n    /** Returns element's shadow root, if any, and if shadow root's mode is \"open\", and null otherwise. */\n    readonly shadowRoot: ShadowRoot | null;\n    /** Returns the value of element's slot content attribute. Can be set to change it. */\n    slot: string;\n    /** Returns the HTML-uppercased qualified name. */\n    readonly tagName: string;\n    /** Creates a shadow root for element and returns it. */\n    attachShadow(init: ShadowRootInit): ShadowRoot;\n    checkVisibility(options?: CheckVisibilityOptions): boolean;\n    /** Returns the first (starting at element) inclusive ancestor that matches selectors, and null otherwise. */\n    closest<K extends keyof HTMLElementTagNameMap>(selector: K): HTMLElementTagNameMap[K] | null;\n    closest<K extends keyof SVGElementTagNameMap>(selector: K): SVGElementTagNameMap[K] | null;\n    closest<K extends keyof MathMLElementTagNameMap>(selector: K): MathMLElementTagNameMap[K] | null;\n    closest<E extends Element = Element>(selectors: string): E | null;\n    /** Returns element's first attribute whose qualified name is qualifiedName, and null if there is no such attribute otherwise. */\n    getAttribute(qualifiedName: string): string | null;\n    /** Returns element's attribute whose namespace is namespace and local name is localName, and null if there is no such attribute otherwise. */\n    getAttributeNS(namespace: string | null, localName: string): string | null;\n    /** Returns the qualified names of all element's attributes. Can contain duplicates. */\n    getAttributeNames(): string[];\n    getAttributeNode(qualifiedName: string): Attr | null;\n    getAttributeNodeNS(namespace: string | null, localName: string): Attr | null;\n    getBoundingClientRect(): DOMRect;\n    getClientRects(): DOMRectList;\n    /** Returns a HTMLCollection of the elements in the object on which the method was invoked (a document or an element) that have all the classes given by classNames. The classNames argument is interpreted as a space-separated list of classes. */\n    getElementsByClassName(classNames: string): HTMLCollectionOf<Element>;\n    getElementsByTagName<K extends keyof HTMLElementTagNameMap>(qualifiedName: K): HTMLCollectionOf<HTMLElementTagNameMap[K]>;\n    getElementsByTagName<K extends keyof SVGElementTagNameMap>(qualifiedName: K): HTMLCollectionOf<SVGElementTagNameMap[K]>;\n    getElementsByTagName<K extends keyof MathMLElementTagNameMap>(qualifiedName: K): HTMLCollectionOf<MathMLElementTagNameMap[K]>;\n    /** @deprecated */\n    getElementsByTagName<K extends keyof HTMLElementDeprecatedTagNameMap>(qualifiedName: K): HTMLCollectionOf<HTMLElementDeprecatedTagNameMap[K]>;\n    getElementsByTagName(qualifiedName: string): HTMLCollectionOf<Element>;\n    getElementsByTagNameNS(namespaceURI: \"http://www.w3.org/1999/xhtml\", localName: string): HTMLCollectionOf<HTMLElement>;\n    getElementsByTagNameNS(namespaceURI: \"http://www.w3.org/2000/svg\", localName: string): HTMLCollectionOf<SVGElement>;\n    getElementsByTagNameNS(namespaceURI: \"http://www.w3.org/1998/Math/MathML\", localName: string): HTMLCollectionOf<MathMLElement>;\n    getElementsByTagNameNS(namespace: string | null, localName: string): HTMLCollectionOf<Element>;\n    /** Returns true if element has an attribute whose qualified name is qualifiedName, and false otherwise. */\n    hasAttribute(qualifiedName: string): boolean;\n    /** Returns true if element has an attribute whose namespace is namespace and local name is localName. */\n    hasAttributeNS(namespace: string | null, localName: string): boolean;\n    /** Returns true if element has attributes, and false otherwise. */\n    hasAttributes(): boolean;\n    hasPointerCapture(pointerId: number): boolean;\n    insertAdjacentElement(where: InsertPosition, element: Element): Element | null;\n    insertAdjacentHTML(position: InsertPosition, text: string): void;\n    insertAdjacentText(where: InsertPosition, data: string): void;\n    /** Returns true if matching selectors against element's root yields element, and false otherwise. */\n    matches(selectors: string): boolean;\n    releasePointerCapture(pointerId: number): void;\n    /** Removes element's first attribute whose qualified name is qualifiedName. */\n    removeAttribute(qualifiedName: string): void;\n    /** Removes element's attribute whose namespace is namespace and local name is localName. */\n    removeAttributeNS(namespace: string | null, localName: string): void;\n    removeAttributeNode(attr: Attr): Attr;\n    /**\n     * Displays element fullscreen and resolves promise when done.\n     *\n     * When supplied, options's navigationUI member indicates whether showing navigation UI while in fullscreen is preferred or not. If set to \"show\", navigation simplicity is preferred over screen space, and if set to \"hide\", more screen space is preferred. User agents are always free to honor user preference over the application's. The default value \"auto\" indicates no application preference.\n     */\n    requestFullscreen(options?: FullscreenOptions): Promise<void>;\n    requestPointerLock(): void;\n    scroll(options?: ScrollToOptions): void;\n    scroll(x: number, y: number): void;\n    scrollBy(options?: ScrollToOptions): void;\n    scrollBy(x: number, y: number): void;\n    scrollIntoView(arg?: boolean | ScrollIntoViewOptions): void;\n    scrollTo(options?: ScrollToOptions): void;\n    scrollTo(x: number, y: number): void;\n    /** Sets the value of element's first attribute whose qualified name is qualifiedName to value. */\n    setAttribute(qualifiedName: string, value: string): void;\n    /** Sets the value of element's attribute whose namespace is namespace and local name is localName to value. */\n    setAttributeNS(namespace: string | null, qualifiedName: string, value: string): void;\n    setAttributeNode(attr: Attr): Attr | null;\n    setAttributeNodeNS(attr: Attr): Attr | null;\n    setPointerCapture(pointerId: number): void;\n    /**\n     * If force is not given, \"toggles\" qualifiedName, removing it if it is present and adding it if it is not present. If force is true, adds qualifiedName. If force is false, removes qualifiedName.\n     *\n     * Returns true if qualifiedName is now present, and false otherwise.\n     */\n    toggleAttribute(qualifiedName: string, force?: boolean): boolean;\n    /** @deprecated This is a legacy alias of `matches`. */\n    webkitMatchesSelector(selectors: string): boolean;\n    addEventListener<K extends keyof ElementEventMap>(type: K, listener: (this: Element, ev: ElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof ElementEventMap>(type: K, listener: (this: Element, ev: ElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var Element: {\n    prototype: Element;\n    new(): Element;\n};\n\ninterface ElementCSSInlineStyle {\n    readonly style: CSSStyleDeclaration;\n}\n\ninterface ElementContentEditable {\n    contentEditable: string;\n    enterKeyHint: string;\n    inputMode: string;\n    readonly isContentEditable: boolean;\n}\n\ninterface ElementInternals extends ARIAMixin {\n    /** Returns the form owner of internals's target element. */\n    readonly form: HTMLFormElement | null;\n    /** Returns a NodeList of all the label elements that internals's target element is associated with. */\n    readonly labels: NodeList;\n    /** Returns the ShadowRoot for internals's target element, if the target element is a shadow host, or null otherwise. */\n    readonly shadowRoot: ShadowRoot | null;\n    /** Returns the error message that would be shown to the user if internals's target element was to be checked for validity. */\n    readonly validationMessage: string;\n    /** Returns the ValidityState object for internals's target element. */\n    readonly validity: ValidityState;\n    /** Returns true if internals's target element will be validated when the form is submitted; false otherwise. */\n    readonly willValidate: boolean;\n    /** Returns true if internals's target element has no validity problems; false otherwise. Fires an invalid event at the element in the latter case. */\n    checkValidity(): boolean;\n    /** Returns true if internals's target element has no validity problems; otherwise, returns false, fires an invalid event at the element, and (if the event isn't canceled) reports the problem to the user. */\n    reportValidity(): boolean;\n    /**\n     * Sets both the state and submission value of internals's target element to value.\n     *\n     * If value is null, the element won't participate in form submission.\n     */\n    setFormValue(value: File | string | FormData | null, state?: File | string | FormData | null): void;\n    /** Marks internals's target element as suffering from the constraints indicated by the flags argument, and sets the element's validation message to message. If anchor is specified, the user agent might use it to indicate problems with the constraints of internals's target element when the form owner is validated interactively or reportValidity() is called. */\n    setValidity(flags?: ValidityStateFlags, message?: string, anchor?: HTMLElement): void;\n}\n\ndeclare var ElementInternals: {\n    prototype: ElementInternals;\n    new(): ElementInternals;\n};\n\n/** Events providing information related to errors in scripts or in files. */\ninterface ErrorEvent extends Event {\n    readonly colno: number;\n    readonly error: any;\n    readonly filename: string;\n    readonly lineno: number;\n    readonly message: string;\n}\n\ndeclare var ErrorEvent: {\n    prototype: ErrorEvent;\n    new(type: string, eventInitDict?: ErrorEventInit): ErrorEvent;\n};\n\n/** An event which takes place in the DOM. */\ninterface Event {\n    /** Returns true or false depending on how event was initialized. True if event goes through its target's ancestors in reverse tree order, and false otherwise. */\n    readonly bubbles: boolean;\n    /** @deprecated */\n    cancelBubble: boolean;\n    /** Returns true or false depending on how event was initialized. Its return value does not always carry meaning, but true can indicate that part of the operation during which event was dispatched, can be canceled by invoking the preventDefault() method. */\n    readonly cancelable: boolean;\n    /** Returns true or false depending on how event was initialized. True if event invokes listeners past a ShadowRoot node that is the root of its target, and false otherwise. */\n    readonly composed: boolean;\n    /** Returns the object whose event listener's callback is currently being invoked. */\n    readonly currentTarget: EventTarget | null;\n    /** Returns true if preventDefault() was invoked successfully to indicate cancelation, and false otherwise. */\n    readonly defaultPrevented: boolean;\n    /** Returns the event's phase, which is one of NONE, CAPTURING_PHASE, AT_TARGET, and BUBBLING_PHASE. */\n    readonly eventPhase: number;\n    /** Returns true if event was dispatched by the user agent, and false otherwise. */\n    readonly isTrusted: boolean;\n    /** @deprecated */\n    returnValue: boolean;\n    /** @deprecated */\n    readonly srcElement: EventTarget | null;\n    /** Returns the object to which event is dispatched (its target). */\n    readonly target: EventTarget | null;\n    /** Returns the event's timestamp as the number of milliseconds measured relative to the time origin. */\n    readonly timeStamp: DOMHighResTimeStamp;\n    /** Returns the type of event, e.g. \"click\", \"hashchange\", or \"submit\". */\n    readonly type: string;\n    /** Returns the invocation target objects of event's path (objects on which listeners will be invoked), except for any nodes in shadow trees of which the shadow root's mode is \"closed\" that are not reachable from event's currentTarget. */\n    composedPath(): EventTarget[];\n    /** @deprecated */\n    initEvent(type: string, bubbles?: boolean, cancelable?: boolean): void;\n    /** If invoked when the cancelable attribute value is true, and while executing a listener for the event with passive set to false, signals to the operation that caused event to be dispatched that it needs to be canceled. */\n    preventDefault(): void;\n    /** Invoking this method prevents event from reaching any registered event listeners after the current one finishes running and, when dispatched in a tree, also prevents event from reaching any other objects. */\n    stopImmediatePropagation(): void;\n    /** When dispatched in a tree, invoking this method prevents event from reaching any objects other than the current object. */\n    stopPropagation(): void;\n    readonly NONE: 0;\n    readonly CAPTURING_PHASE: 1;\n    readonly AT_TARGET: 2;\n    readonly BUBBLING_PHASE: 3;\n}\n\ndeclare var Event: {\n    prototype: Event;\n    new(type: string, eventInitDict?: EventInit): Event;\n    readonly NONE: 0;\n    readonly CAPTURING_PHASE: 1;\n    readonly AT_TARGET: 2;\n    readonly BUBBLING_PHASE: 3;\n};\n\ninterface EventCounts {\n    forEach(callbackfn: (value: number, key: string, parent: EventCounts) => void, thisArg?: any): void;\n}\n\ndeclare var EventCounts: {\n    prototype: EventCounts;\n    new(): EventCounts;\n};\n\ninterface EventListener {\n    (evt: Event): void;\n}\n\ninterface EventListenerObject {\n    handleEvent(object: Event): void;\n}\n\ninterface EventSourceEventMap {\n    \"error\": Event;\n    \"message\": MessageEvent;\n    \"open\": Event;\n}\n\ninterface EventSource extends EventTarget {\n    onerror: ((this: EventSource, ev: Event) => any) | null;\n    onmessage: ((this: EventSource, ev: MessageEvent) => any) | null;\n    onopen: ((this: EventSource, ev: Event) => any) | null;\n    /** Returns the state of this EventSource object's connection. It can have the values described below. */\n    readonly readyState: number;\n    /** Returns the URL providing the event stream. */\n    readonly url: string;\n    /** Returns true if the credentials mode for connection requests to the URL providing the event stream is set to \"include\", and false otherwise. */\n    readonly withCredentials: boolean;\n    /** Aborts any instances of the fetch algorithm started for this EventSource object, and sets the readyState attribute to CLOSED. */\n    close(): void;\n    readonly CONNECTING: 0;\n    readonly OPEN: 1;\n    readonly CLOSED: 2;\n    addEventListener<K extends keyof EventSourceEventMap>(type: K, listener: (this: EventSource, ev: EventSourceEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: (this: EventSource, event: MessageEvent) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof EventSourceEventMap>(type: K, listener: (this: EventSource, ev: EventSourceEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: (this: EventSource, event: MessageEvent) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var EventSource: {\n    prototype: EventSource;\n    new(url: string | URL, eventSourceInitDict?: EventSourceInit): EventSource;\n    readonly CONNECTING: 0;\n    readonly OPEN: 1;\n    readonly CLOSED: 2;\n};\n\n/** EventTarget is a DOM interface implemented by objects that can receive events and may have listeners for them. */\ninterface EventTarget {\n    /**\n     * Appends an event listener for events whose type attribute value is type. The callback argument sets the callback that will be invoked when the event is dispatched.\n     *\n     * The options argument sets listener-specific options. For compatibility this can be a boolean, in which case the method behaves exactly as if the value was specified as options's capture.\n     *\n     * When set to true, options's capture prevents callback from being invoked when the event's eventPhase attribute value is BUBBLING_PHASE. When false (or not present), callback will not be invoked when event's eventPhase attribute value is CAPTURING_PHASE. Either way, callback will be invoked if event's eventPhase attribute value is AT_TARGET.\n     *\n     * When set to true, options's passive indicates that the callback will not cancel the event by invoking preventDefault(). This is used to enable performance optimizations described in § 2.8 Observing event listeners.\n     *\n     * When set to true, options's once indicates that the callback will only be invoked once after which the event listener will be removed.\n     *\n     * If an AbortSignal is passed for options's signal, then the event listener will be removed when signal is aborted.\n     *\n     * The event listener is appended to target's event listener list and is not appended if it has the same type, callback, and capture.\n     */\n    addEventListener(type: string, callback: EventListenerOrEventListenerObject | null, options?: AddEventListenerOptions | boolean): void;\n    /** Dispatches a synthetic event event to target and returns true if either event's cancelable attribute value is false or its preventDefault() method was not invoked, and false otherwise. */\n    dispatchEvent(event: Event): boolean;\n    /** Removes the event listener in target's event listener list with the same type, callback, and options. */\n    removeEventListener(type: string, callback: EventListenerOrEventListenerObject | null, options?: EventListenerOptions | boolean): void;\n}\n\ndeclare var EventTarget: {\n    prototype: EventTarget;\n    new(): EventTarget;\n};\n\n/** @deprecated */\ninterface External {\n    /** @deprecated */\n    AddSearchProvider(): void;\n    /** @deprecated */\n    IsSearchProviderInstalled(): void;\n}\n\n/** @deprecated */\ndeclare var External: {\n    prototype: External;\n    new(): External;\n};\n\n/** Provides information about files and allows JavaScript in a web page to access their content. */\ninterface File extends Blob {\n    readonly lastModified: number;\n    readonly name: string;\n    readonly webkitRelativePath: string;\n}\n\ndeclare var File: {\n    prototype: File;\n    new(fileBits: BlobPart[], fileName: string, options?: FilePropertyBag): File;\n};\n\n/** An object of this type is returned by the files property of the HTML <input> element; this lets you access the list of files selected with the <input type=\"file\"> element. It's also used for a list of files dropped into web content when using the drag and drop API; see the DataTransfer object for details on this usage. */\ninterface FileList {\n    readonly length: number;\n    item(index: number): File | null;\n    [index: number]: File;\n}\n\ndeclare var FileList: {\n    prototype: FileList;\n    new(): FileList;\n};\n\ninterface FileReaderEventMap {\n    \"abort\": ProgressEvent<FileReader>;\n    \"error\": ProgressEvent<FileReader>;\n    \"load\": ProgressEvent<FileReader>;\n    \"loadend\": ProgressEvent<FileReader>;\n    \"loadstart\": ProgressEvent<FileReader>;\n    \"progress\": ProgressEvent<FileReader>;\n}\n\n/** Lets web applications asynchronously read the contents of files (or raw data buffers) stored on the user's computer, using File or Blob objects to specify the file or data to read. */\ninterface FileReader extends EventTarget {\n    readonly error: DOMException | null;\n    onabort: ((this: FileReader, ev: ProgressEvent<FileReader>) => any) | null;\n    onerror: ((this: FileReader, ev: ProgressEvent<FileReader>) => any) | null;\n    onload: ((this: FileReader, ev: ProgressEvent<FileReader>) => any) | null;\n    onloadend: ((this: FileReader, ev: ProgressEvent<FileReader>) => any) | null;\n    onloadstart: ((this: FileReader, ev: ProgressEvent<FileReader>) => any) | null;\n    onprogress: ((this: FileReader, ev: ProgressEvent<FileReader>) => any) | null;\n    readonly readyState: typeof FileReader.EMPTY | typeof FileReader.LOADING | typeof FileReader.DONE;\n    readonly result: string | ArrayBuffer | null;\n    abort(): void;\n    readAsArrayBuffer(blob: Blob): void;\n    readAsBinaryString(blob: Blob): void;\n    readAsDataURL(blob: Blob): void;\n    readAsText(blob: Blob, encoding?: string): void;\n    readonly EMPTY: 0;\n    readonly LOADING: 1;\n    readonly DONE: 2;\n    addEventListener<K extends keyof FileReaderEventMap>(type: K, listener: (this: FileReader, ev: FileReaderEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof FileReaderEventMap>(type: K, listener: (this: FileReader, ev: FileReaderEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var FileReader: {\n    prototype: FileReader;\n    new(): FileReader;\n    readonly EMPTY: 0;\n    readonly LOADING: 1;\n    readonly DONE: 2;\n};\n\ninterface FileSystem {\n    readonly name: string;\n    readonly root: FileSystemDirectoryEntry;\n}\n\ndeclare var FileSystem: {\n    prototype: FileSystem;\n    new(): FileSystem;\n};\n\ninterface FileSystemDirectoryEntry extends FileSystemEntry {\n    createReader(): FileSystemDirectoryReader;\n    getDirectory(path?: string | null, options?: FileSystemFlags, successCallback?: FileSystemEntryCallback, errorCallback?: ErrorCallback): void;\n    getFile(path?: string | null, options?: FileSystemFlags, successCallback?: FileSystemEntryCallback, errorCallback?: ErrorCallback): void;\n}\n\ndeclare var FileSystemDirectoryEntry: {\n    prototype: FileSystemDirectoryEntry;\n    new(): FileSystemDirectoryEntry;\n};\n\n/** Available only in secure contexts. */\ninterface FileSystemDirectoryHandle extends FileSystemHandle {\n    readonly kind: \"directory\";\n    getDirectoryHandle(name: string, options?: FileSystemGetDirectoryOptions): Promise<FileSystemDirectoryHandle>;\n    getFileHandle(name: string, options?: FileSystemGetFileOptions): Promise<FileSystemFileHandle>;\n    removeEntry(name: string, options?: FileSystemRemoveOptions): Promise<void>;\n    resolve(possibleDescendant: FileSystemHandle): Promise<string[] | null>;\n}\n\ndeclare var FileSystemDirectoryHandle: {\n    prototype: FileSystemDirectoryHandle;\n    new(): FileSystemDirectoryHandle;\n};\n\ninterface FileSystemDirectoryReader {\n    readEntries(successCallback: FileSystemEntriesCallback, errorCallback?: ErrorCallback): void;\n}\n\ndeclare var FileSystemDirectoryReader: {\n    prototype: FileSystemDirectoryReader;\n    new(): FileSystemDirectoryReader;\n};\n\ninterface FileSystemEntry {\n    readonly filesystem: FileSystem;\n    readonly fullPath: string;\n    readonly isDirectory: boolean;\n    readonly isFile: boolean;\n    readonly name: string;\n    getParent(successCallback?: FileSystemEntryCallback, errorCallback?: ErrorCallback): void;\n}\n\ndeclare var FileSystemEntry: {\n    prototype: FileSystemEntry;\n    new(): FileSystemEntry;\n};\n\ninterface FileSystemFileEntry extends FileSystemEntry {\n    file(successCallback: FileCallback, errorCallback?: ErrorCallback): void;\n}\n\ndeclare var FileSystemFileEntry: {\n    prototype: FileSystemFileEntry;\n    new(): FileSystemFileEntry;\n};\n\n/** Available only in secure contexts. */\ninterface FileSystemFileHandle extends FileSystemHandle {\n    readonly kind: \"file\";\n    getFile(): Promise<File>;\n}\n\ndeclare var FileSystemFileHandle: {\n    prototype: FileSystemFileHandle;\n    new(): FileSystemFileHandle;\n};\n\n/** Available only in secure contexts. */\ninterface FileSystemHandle {\n    readonly kind: FileSystemHandleKind;\n    readonly name: string;\n    isSameEntry(other: FileSystemHandle): Promise<boolean>;\n}\n\ndeclare var FileSystemHandle: {\n    prototype: FileSystemHandle;\n    new(): FileSystemHandle;\n};\n\n/** Focus-related events like focus, blur, focusin, or focusout. */\ninterface FocusEvent extends UIEvent {\n    readonly relatedTarget: EventTarget | null;\n}\n\ndeclare var FocusEvent: {\n    prototype: FocusEvent;\n    new(type: string, eventInitDict?: FocusEventInit): FocusEvent;\n};\n\ninterface FontFace {\n    ascentOverride: string;\n    descentOverride: string;\n    display: FontDisplay;\n    family: string;\n    featureSettings: string;\n    lineGapOverride: string;\n    readonly loaded: Promise<FontFace>;\n    readonly status: FontFaceLoadStatus;\n    stretch: string;\n    style: string;\n    unicodeRange: string;\n    variant: string;\n    weight: string;\n    load(): Promise<FontFace>;\n}\n\ndeclare var FontFace: {\n    prototype: FontFace;\n    new(family: string, source: string | BinaryData, descriptors?: FontFaceDescriptors): FontFace;\n};\n\ninterface FontFaceSetEventMap {\n    \"loading\": Event;\n    \"loadingdone\": Event;\n    \"loadingerror\": Event;\n}\n\ninterface FontFaceSet extends EventTarget {\n    onloading: ((this: FontFaceSet, ev: Event) => any) | null;\n    onloadingdone: ((this: FontFaceSet, ev: Event) => any) | null;\n    onloadingerror: ((this: FontFaceSet, ev: Event) => any) | null;\n    readonly ready: Promise<FontFaceSet>;\n    readonly status: FontFaceSetLoadStatus;\n    check(font: string, text?: string): boolean;\n    load(font: string, text?: string): Promise<FontFace[]>;\n    forEach(callbackfn: (value: FontFace, key: FontFace, parent: FontFaceSet) => void, thisArg?: any): void;\n    addEventListener<K extends keyof FontFaceSetEventMap>(type: K, listener: (this: FontFaceSet, ev: FontFaceSetEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof FontFaceSetEventMap>(type: K, listener: (this: FontFaceSet, ev: FontFaceSetEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var FontFaceSet: {\n    prototype: FontFaceSet;\n    new(initialFaces: FontFace[]): FontFaceSet;\n};\n\ninterface FontFaceSetLoadEvent extends Event {\n    readonly fontfaces: ReadonlyArray<FontFace>;\n}\n\ndeclare var FontFaceSetLoadEvent: {\n    prototype: FontFaceSetLoadEvent;\n    new(type: string, eventInitDict?: FontFaceSetLoadEventInit): FontFaceSetLoadEvent;\n};\n\ninterface FontFaceSource {\n    readonly fonts: FontFaceSet;\n}\n\n/** Provides a way to easily construct a set of key/value pairs representing form fields and their values, which can then be easily sent using the XMLHttpRequest.send() method. It uses the same format a form would use if the encoding type were set to \"multipart/form-data\". */\ninterface FormData {\n    append(name: string, value: string | Blob, fileName?: string): void;\n    delete(name: string): void;\n    get(name: string): FormDataEntryValue | null;\n    getAll(name: string): FormDataEntryValue[];\n    has(name: string): boolean;\n    set(name: string, value: string | Blob, fileName?: string): void;\n    forEach(callbackfn: (value: FormDataEntryValue, key: string, parent: FormData) => void, thisArg?: any): void;\n}\n\ndeclare var FormData: {\n    prototype: FormData;\n    new(form?: HTMLFormElement): FormData;\n};\n\ninterface FormDataEvent extends Event {\n    /** Returns a FormData object representing names and values of elements associated to the target form. Operations on the FormData object will affect form data to be submitted. */\n    readonly formData: FormData;\n}\n\ndeclare var FormDataEvent: {\n    prototype: FormDataEvent;\n    new(type: string, eventInitDict: FormDataEventInit): FormDataEvent;\n};\n\n/** A change in volume. It is an AudioNode audio-processing module that causes a given gain to be applied to the input data before its propagation to the output. A GainNode always has exactly one input and one output, both with the same number of channels. */\ninterface GainNode extends AudioNode {\n    readonly gain: AudioParam;\n}\n\ndeclare var GainNode: {\n    prototype: GainNode;\n    new(context: BaseAudioContext, options?: GainOptions): GainNode;\n};\n\n/**\n * This Gamepad API interface defines an individual gamepad or other controller, allowing access to information such as button presses, axis positions, and id.\n * Available only in secure contexts.\n */\ninterface Gamepad {\n    readonly axes: ReadonlyArray<number>;\n    readonly buttons: ReadonlyArray<GamepadButton>;\n    readonly connected: boolean;\n    readonly hapticActuators: ReadonlyArray<GamepadHapticActuator>;\n    readonly id: string;\n    readonly index: number;\n    readonly mapping: GamepadMappingType;\n    readonly timestamp: DOMHighResTimeStamp;\n}\n\ndeclare var Gamepad: {\n    prototype: Gamepad;\n    new(): Gamepad;\n};\n\n/**\n * An individual button of a gamepad or other controller, allowing access to the current state of different types of buttons available on the control device.\n * Available only in secure contexts.\n */\ninterface GamepadButton {\n    readonly pressed: boolean;\n    readonly touched: boolean;\n    readonly value: number;\n}\n\ndeclare var GamepadButton: {\n    prototype: GamepadButton;\n    new(): GamepadButton;\n};\n\n/**\n * This Gamepad API interface contains references to gamepads connected to the system, which is what the gamepad events Window.gamepadconnected and Window.gamepaddisconnected are fired in response to.\n * Available only in secure contexts.\n */\ninterface GamepadEvent extends Event {\n    readonly gamepad: Gamepad;\n}\n\ndeclare var GamepadEvent: {\n    prototype: GamepadEvent;\n    new(type: string, eventInitDict: GamepadEventInit): GamepadEvent;\n};\n\n/** This Gamepad API interface represents hardware in the controller designed to provide haptic feedback to the user (if available), most commonly vibration hardware. */\ninterface GamepadHapticActuator {\n    readonly type: GamepadHapticActuatorType;\n}\n\ndeclare var GamepadHapticActuator: {\n    prototype: GamepadHapticActuator;\n    new(): GamepadHapticActuator;\n};\n\ninterface GenericTransformStream {\n    readonly readable: ReadableStream;\n    readonly writable: WritableStream;\n}\n\n/** An object able to programmatically obtain the position of the device. It gives Web content access to the location of the device. This allows a Web site or app to offer customized results based on the user's location. */\ninterface Geolocation {\n    clearWatch(watchId: number): void;\n    getCurrentPosition(successCallback: PositionCallback, errorCallback?: PositionErrorCallback | null, options?: PositionOptions): void;\n    watchPosition(successCallback: PositionCallback, errorCallback?: PositionErrorCallback | null, options?: PositionOptions): number;\n}\n\ndeclare var Geolocation: {\n    prototype: Geolocation;\n    new(): Geolocation;\n};\n\n/** Available only in secure contexts. */\ninterface GeolocationCoordinates {\n    readonly accuracy: number;\n    readonly altitude: number | null;\n    readonly altitudeAccuracy: number | null;\n    readonly heading: number | null;\n    readonly latitude: number;\n    readonly longitude: number;\n    readonly speed: number | null;\n}\n\ndeclare var GeolocationCoordinates: {\n    prototype: GeolocationCoordinates;\n    new(): GeolocationCoordinates;\n};\n\n/** Available only in secure contexts. */\ninterface GeolocationPosition {\n    readonly coords: GeolocationCoordinates;\n    readonly timestamp: EpochTimeStamp;\n}\n\ndeclare var GeolocationPosition: {\n    prototype: GeolocationPosition;\n    new(): GeolocationPosition;\n};\n\ninterface GeolocationPositionError {\n    readonly code: number;\n    readonly message: string;\n    readonly PERMISSION_DENIED: 1;\n    readonly POSITION_UNAVAILABLE: 2;\n    readonly TIMEOUT: 3;\n}\n\ndeclare var GeolocationPositionError: {\n    prototype: GeolocationPositionError;\n    new(): GeolocationPositionError;\n    readonly PERMISSION_DENIED: 1;\n    readonly POSITION_UNAVAILABLE: 2;\n    readonly TIMEOUT: 3;\n};\n\ninterface GlobalEventHandlersEventMap {\n    \"abort\": UIEvent;\n    \"animationcancel\": AnimationEvent;\n    \"animationend\": AnimationEvent;\n    \"animationiteration\": AnimationEvent;\n    \"animationstart\": AnimationEvent;\n    \"auxclick\": MouseEvent;\n    \"beforeinput\": InputEvent;\n    \"blur\": FocusEvent;\n    \"cancel\": Event;\n    \"canplay\": Event;\n    \"canplaythrough\": Event;\n    \"change\": Event;\n    \"click\": MouseEvent;\n    \"close\": Event;\n    \"compositionend\": CompositionEvent;\n    \"compositionstart\": CompositionEvent;\n    \"compositionupdate\": CompositionEvent;\n    \"contextmenu\": MouseEvent;\n    \"copy\": ClipboardEvent;\n    \"cuechange\": Event;\n    \"cut\": ClipboardEvent;\n    \"dblclick\": MouseEvent;\n    \"drag\": DragEvent;\n    \"dragend\": DragEvent;\n    \"dragenter\": DragEvent;\n    \"dragleave\": DragEvent;\n    \"dragover\": DragEvent;\n    \"dragstart\": DragEvent;\n    \"drop\": DragEvent;\n    \"durationchange\": Event;\n    \"emptied\": Event;\n    \"ended\": Event;\n    \"error\": ErrorEvent;\n    \"focus\": FocusEvent;\n    \"focusin\": FocusEvent;\n    \"focusout\": FocusEvent;\n    \"formdata\": FormDataEvent;\n    \"gotpointercapture\": PointerEvent;\n    \"input\": Event;\n    \"invalid\": Event;\n    \"keydown\": KeyboardEvent;\n    \"keypress\": KeyboardEvent;\n    \"keyup\": KeyboardEvent;\n    \"load\": Event;\n    \"loadeddata\": Event;\n    \"loadedmetadata\": Event;\n    \"loadstart\": Event;\n    \"lostpointercapture\": PointerEvent;\n    \"mousedown\": MouseEvent;\n    \"mouseenter\": MouseEvent;\n    \"mouseleave\": MouseEvent;\n    \"mousemove\": MouseEvent;\n    \"mouseout\": MouseEvent;\n    \"mouseover\": MouseEvent;\n    \"mouseup\": MouseEvent;\n    \"paste\": ClipboardEvent;\n    \"pause\": Event;\n    \"play\": Event;\n    \"playing\": Event;\n    \"pointercancel\": PointerEvent;\n    \"pointerdown\": PointerEvent;\n    \"pointerenter\": PointerEvent;\n    \"pointerleave\": PointerEvent;\n    \"pointermove\": PointerEvent;\n    \"pointerout\": PointerEvent;\n    \"pointerover\": PointerEvent;\n    \"pointerup\": PointerEvent;\n    \"progress\": ProgressEvent;\n    \"ratechange\": Event;\n    \"reset\": Event;\n    \"resize\": UIEvent;\n    \"scroll\": Event;\n    \"securitypolicyviolation\": SecurityPolicyViolationEvent;\n    \"seeked\": Event;\n    \"seeking\": Event;\n    \"select\": Event;\n    \"selectionchange\": Event;\n    \"selectstart\": Event;\n    \"slotchange\": Event;\n    \"stalled\": Event;\n    \"submit\": SubmitEvent;\n    \"suspend\": Event;\n    \"timeupdate\": Event;\n    \"toggle\": Event;\n    \"touchcancel\": TouchEvent;\n    \"touchend\": TouchEvent;\n    \"touchmove\": TouchEvent;\n    \"touchstart\": TouchEvent;\n    \"transitioncancel\": TransitionEvent;\n    \"transitionend\": TransitionEvent;\n    \"transitionrun\": TransitionEvent;\n    \"transitionstart\": TransitionEvent;\n    \"volumechange\": Event;\n    \"waiting\": Event;\n    \"webkitanimationend\": Event;\n    \"webkitanimationiteration\": Event;\n    \"webkitanimationstart\": Event;\n    \"webkittransitionend\": Event;\n    \"wheel\": WheelEvent;\n}\n\ninterface GlobalEventHandlers {\n    /**\n     * Fires when the user aborts the download.\n     * @param ev The event.\n     */\n    onabort: ((this: GlobalEventHandlers, ev: UIEvent) => any) | null;\n    onanimationcancel: ((this: GlobalEventHandlers, ev: AnimationEvent) => any) | null;\n    onanimationend: ((this: GlobalEventHandlers, ev: AnimationEvent) => any) | null;\n    onanimationiteration: ((this: GlobalEventHandlers, ev: AnimationEvent) => any) | null;\n    onanimationstart: ((this: GlobalEventHandlers, ev: AnimationEvent) => any) | null;\n    onauxclick: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;\n    onbeforeinput: ((this: GlobalEventHandlers, ev: InputEvent) => any) | null;\n    /**\n     * Fires when the object loses the input focus.\n     * @param ev The focus event.\n     */\n    onblur: ((this: GlobalEventHandlers, ev: FocusEvent) => any) | null;\n    oncancel: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Occurs when playback is possible, but would require further buffering.\n     * @param ev The event.\n     */\n    oncanplay: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    oncanplaythrough: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Fires when the contents of the object or selection have changed.\n     * @param ev The event.\n     */\n    onchange: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Fires when the user clicks the left mouse button on the object\n     * @param ev The mouse event.\n     */\n    onclick: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;\n    onclose: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Fires when the user clicks the right mouse button in the client area, opening the context menu.\n     * @param ev The mouse event.\n     */\n    oncontextmenu: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;\n    oncopy: ((this: GlobalEventHandlers, ev: ClipboardEvent) => any) | null;\n    oncuechange: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    oncut: ((this: GlobalEventHandlers, ev: ClipboardEvent) => any) | null;\n    /**\n     * Fires when the user double-clicks the object.\n     * @param ev The mouse event.\n     */\n    ondblclick: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;\n    /**\n     * Fires on the source object continuously during a drag operation.\n     * @param ev The event.\n     */\n    ondrag: ((this: GlobalEventHandlers, ev: DragEvent) => any) | null;\n    /**\n     * Fires on the source object when the user releases the mouse at the close of a drag operation.\n     * @param ev The event.\n     */\n    ondragend: ((this: GlobalEventHandlers, ev: DragEvent) => any) | null;\n    /**\n     * Fires on the target element when the user drags the object to a valid drop target.\n     * @param ev The drag event.\n     */\n    ondragenter: ((this: GlobalEventHandlers, ev: DragEvent) => any) | null;\n    /**\n     * Fires on the target object when the user moves the mouse out of a valid drop target during a drag operation.\n     * @param ev The drag event.\n     */\n    ondragleave: ((this: GlobalEventHandlers, ev: DragEvent) => any) | null;\n    /**\n     * Fires on the target element continuously while the user drags the object over a valid drop target.\n     * @param ev The event.\n     */\n    ondragover: ((this: GlobalEventHandlers, ev: DragEvent) => any) | null;\n    /**\n     * Fires on the source object when the user starts to drag a text selection or selected object.\n     * @param ev The event.\n     */\n    ondragstart: ((this: GlobalEventHandlers, ev: DragEvent) => any) | null;\n    ondrop: ((this: GlobalEventHandlers, ev: DragEvent) => any) | null;\n    /**\n     * Occurs when the duration attribute is updated.\n     * @param ev The event.\n     */\n    ondurationchange: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Occurs when the media element is reset to its initial state.\n     * @param ev The event.\n     */\n    onemptied: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Occurs when the end of playback is reached.\n     * @param ev The event\n     */\n    onended: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Fires when an error occurs during object loading.\n     * @param ev The event.\n     */\n    onerror: OnErrorEventHandler;\n    /**\n     * Fires when the object receives focus.\n     * @param ev The event.\n     */\n    onfocus: ((this: GlobalEventHandlers, ev: FocusEvent) => any) | null;\n    onformdata: ((this: GlobalEventHandlers, ev: FormDataEvent) => any) | null;\n    ongotpointercapture: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;\n    oninput: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    oninvalid: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Fires when the user presses a key.\n     * @param ev The keyboard event\n     */\n    onkeydown: ((this: GlobalEventHandlers, ev: KeyboardEvent) => any) | null;\n    /**\n     * Fires when the user presses an alphanumeric key.\n     * @param ev The event.\n     * @deprecated\n     */\n    onkeypress: ((this: GlobalEventHandlers, ev: KeyboardEvent) => any) | null;\n    /**\n     * Fires when the user releases a key.\n     * @param ev The keyboard event\n     */\n    onkeyup: ((this: GlobalEventHandlers, ev: KeyboardEvent) => any) | null;\n    /**\n     * Fires immediately after the browser loads the object.\n     * @param ev The event.\n     */\n    onload: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Occurs when media data is loaded at the current playback position.\n     * @param ev The event.\n     */\n    onloadeddata: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Occurs when the duration and dimensions of the media have been determined.\n     * @param ev The event.\n     */\n    onloadedmetadata: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Occurs when Internet Explorer begins looking for media data.\n     * @param ev The event.\n     */\n    onloadstart: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    onlostpointercapture: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;\n    /**\n     * Fires when the user clicks the object with either mouse button.\n     * @param ev The mouse event.\n     */\n    onmousedown: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;\n    onmouseenter: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;\n    onmouseleave: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;\n    /**\n     * Fires when the user moves the mouse over the object.\n     * @param ev The mouse event.\n     */\n    onmousemove: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;\n    /**\n     * Fires when the user moves the mouse pointer outside the boundaries of the object.\n     * @param ev The mouse event.\n     */\n    onmouseout: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;\n    /**\n     * Fires when the user moves the mouse pointer into the object.\n     * @param ev The mouse event.\n     */\n    onmouseover: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;\n    /**\n     * Fires when the user releases a mouse button while the mouse is over the object.\n     * @param ev The mouse event.\n     */\n    onmouseup: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;\n    onpaste: ((this: GlobalEventHandlers, ev: ClipboardEvent) => any) | null;\n    /**\n     * Occurs when playback is paused.\n     * @param ev The event.\n     */\n    onpause: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Occurs when the play method is requested.\n     * @param ev The event.\n     */\n    onplay: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Occurs when the audio or video has started playing.\n     * @param ev The event.\n     */\n    onplaying: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    onpointercancel: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;\n    onpointerdown: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;\n    onpointerenter: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;\n    onpointerleave: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;\n    onpointermove: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;\n    onpointerout: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;\n    onpointerover: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;\n    onpointerup: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;\n    /**\n     * Occurs to indicate progress while downloading media data.\n     * @param ev The event.\n     */\n    onprogress: ((this: GlobalEventHandlers, ev: ProgressEvent) => any) | null;\n    /**\n     * Occurs when the playback rate is increased or decreased.\n     * @param ev The event.\n     */\n    onratechange: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Fires when the user resets a form.\n     * @param ev The event.\n     */\n    onreset: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    onresize: ((this: GlobalEventHandlers, ev: UIEvent) => any) | null;\n    /**\n     * Fires when the user repositions the scroll box in the scroll bar on the object.\n     * @param ev The event.\n     */\n    onscroll: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    onsecuritypolicyviolation: ((this: GlobalEventHandlers, ev: SecurityPolicyViolationEvent) => any) | null;\n    /**\n     * Occurs when the seek operation ends.\n     * @param ev The event.\n     */\n    onseeked: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Occurs when the current playback position is moved.\n     * @param ev The event.\n     */\n    onseeking: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Fires when the current selection changes.\n     * @param ev The event.\n     */\n    onselect: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    onselectionchange: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    onselectstart: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    onslotchange: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Occurs when the download has stopped.\n     * @param ev The event.\n     */\n    onstalled: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    onsubmit: ((this: GlobalEventHandlers, ev: SubmitEvent) => any) | null;\n    /**\n     * Occurs if the load operation has been intentionally halted.\n     * @param ev The event.\n     */\n    onsuspend: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Occurs to indicate the current playback position.\n     * @param ev The event.\n     */\n    ontimeupdate: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    ontoggle: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    ontouchcancel?: ((this: GlobalEventHandlers, ev: TouchEvent) => any) | null | undefined;\n    ontouchend?: ((this: GlobalEventHandlers, ev: TouchEvent) => any) | null | undefined;\n    ontouchmove?: ((this: GlobalEventHandlers, ev: TouchEvent) => any) | null | undefined;\n    ontouchstart?: ((this: GlobalEventHandlers, ev: TouchEvent) => any) | null | undefined;\n    ontransitioncancel: ((this: GlobalEventHandlers, ev: TransitionEvent) => any) | null;\n    ontransitionend: ((this: GlobalEventHandlers, ev: TransitionEvent) => any) | null;\n    ontransitionrun: ((this: GlobalEventHandlers, ev: TransitionEvent) => any) | null;\n    ontransitionstart: ((this: GlobalEventHandlers, ev: TransitionEvent) => any) | null;\n    /**\n     * Occurs when the volume is changed, or playback is muted or unmuted.\n     * @param ev The event.\n     */\n    onvolumechange: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Occurs when playback stops because the next frame of a video resource is not available.\n     * @param ev The event.\n     */\n    onwaiting: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** @deprecated This is a legacy alias of `onanimationend`. */\n    onwebkitanimationend: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** @deprecated This is a legacy alias of `onanimationiteration`. */\n    onwebkitanimationiteration: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** @deprecated This is a legacy alias of `onanimationstart`. */\n    onwebkitanimationstart: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** @deprecated This is a legacy alias of `ontransitionend`. */\n    onwebkittransitionend: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    onwheel: ((this: GlobalEventHandlers, ev: WheelEvent) => any) | null;\n    addEventListener<K extends keyof GlobalEventHandlersEventMap>(type: K, listener: (this: GlobalEventHandlers, ev: GlobalEventHandlersEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof GlobalEventHandlersEventMap>(type: K, listener: (this: GlobalEventHandlers, ev: GlobalEventHandlersEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ninterface HTMLAllCollection {\n    /** Returns the number of elements in the collection. */\n    readonly length: number;\n    /** Returns the item with index index from the collection (determined by tree order). */\n    item(nameOrIndex?: string): HTMLCollection | Element | null;\n    /**\n     * Returns the item with ID or name name from the collection.\n     *\n     * If there are multiple matching items, then an HTMLCollection object containing all those elements is returned.\n     *\n     * Only button, form, iframe, input, map, meta, object, select, and textarea elements can have a name for the purpose of this method; their name is given by the value of their name attribute.\n     */\n    namedItem(name: string): HTMLCollection | Element | null;\n    [index: number]: Element;\n}\n\ndeclare var HTMLAllCollection: {\n    prototype: HTMLAllCollection;\n    new(): HTMLAllCollection;\n};\n\n/** Hyperlink elements and provides special properties and methods (beyond those of the regular HTMLElement object interface that they inherit from) for manipulating the layout and presentation of such elements. */\ninterface HTMLAnchorElement extends HTMLElement, HTMLHyperlinkElementUtils {\n    /**\n     * Sets or retrieves the character set used to encode the object.\n     * @deprecated\n     */\n    charset: string;\n    /**\n     * Sets or retrieves the coordinates of the object.\n     * @deprecated\n     */\n    coords: string;\n    download: string;\n    /** Sets or retrieves the language code of the object. */\n    hreflang: string;\n    /**\n     * Sets or retrieves the shape of the object.\n     * @deprecated\n     */\n    name: string;\n    ping: string;\n    referrerPolicy: string;\n    /** Sets or retrieves the relationship between the object and the destination of the link. */\n    rel: string;\n    readonly relList: DOMTokenList;\n    /**\n     * Sets or retrieves the relationship between the object and the destination of the link.\n     * @deprecated\n     */\n    rev: string;\n    /**\n     * Sets or retrieves the shape of the object.\n     * @deprecated\n     */\n    shape: string;\n    /** Sets or retrieves the window or frame at which to target content. */\n    target: string;\n    /** Retrieves or sets the text of the object as a string. */\n    text: string;\n    type: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLAnchorElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLAnchorElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLAnchorElement: {\n    prototype: HTMLAnchorElement;\n    new(): HTMLAnchorElement;\n};\n\n/** Provides special properties and methods (beyond those of the regular object HTMLElement interface it also has available to it by inheritance) for manipulating the layout and presentation of <area> elements. */\ninterface HTMLAreaElement extends HTMLElement, HTMLHyperlinkElementUtils {\n    /** Sets or retrieves a text alternative to the graphic. */\n    alt: string;\n    /** Sets or retrieves the coordinates of the object. */\n    coords: string;\n    download: string;\n    /**\n     * Sets or gets whether clicks in this region cause action.\n     * @deprecated\n     */\n    noHref: boolean;\n    ping: string;\n    referrerPolicy: string;\n    rel: string;\n    readonly relList: DOMTokenList;\n    /** Sets or retrieves the shape of the object. */\n    shape: string;\n    /** Sets or retrieves the window or frame at which to target content. */\n    target: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLAreaElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLAreaElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLAreaElement: {\n    prototype: HTMLAreaElement;\n    new(): HTMLAreaElement;\n};\n\n/** Provides access to the properties of <audio> elements, as well as methods to manipulate them. It derives from the HTMLMediaElement interface. */\ninterface HTMLAudioElement extends HTMLMediaElement {\n    addEventListener<K extends keyof HTMLMediaElementEventMap>(type: K, listener: (this: HTMLAudioElement, ev: HTMLMediaElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLMediaElementEventMap>(type: K, listener: (this: HTMLAudioElement, ev: HTMLMediaElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLAudioElement: {\n    prototype: HTMLAudioElement;\n    new(): HTMLAudioElement;\n};\n\n/** A HTML line break element (<br>). It inherits from HTMLElement. */\ninterface HTMLBRElement extends HTMLElement {\n    /**\n     * Sets or retrieves the side on which floating objects are not to be positioned when any IHTMLBlockElement is inserted into the document.\n     * @deprecated\n     */\n    clear: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLBRElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLBRElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLBRElement: {\n    prototype: HTMLBRElement;\n    new(): HTMLBRElement;\n};\n\n/** Contains the base URI for a document. This object inherits all of the properties and methods as described in the HTMLElement interface. */\ninterface HTMLBaseElement extends HTMLElement {\n    /** Gets or sets the baseline URL on which relative links are based. */\n    href: string;\n    /** Sets or retrieves the window or frame at which to target content. */\n    target: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLBaseElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLBaseElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLBaseElement: {\n    prototype: HTMLBaseElement;\n    new(): HTMLBaseElement;\n};\n\ninterface HTMLBodyElementEventMap extends HTMLElementEventMap, WindowEventHandlersEventMap {\n}\n\n/** Provides special properties (beyond those inherited from the regular HTMLElement interface) for manipulating <body> elements. */\ninterface HTMLBodyElement extends HTMLElement, WindowEventHandlers {\n    /** @deprecated */\n    aLink: string;\n    /** @deprecated */\n    background: string;\n    /** @deprecated */\n    bgColor: string;\n    /** @deprecated */\n    link: string;\n    /** @deprecated */\n    text: string;\n    /** @deprecated */\n    vLink: string;\n    addEventListener<K extends keyof HTMLBodyElementEventMap>(type: K, listener: (this: HTMLBodyElement, ev: HTMLBodyElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLBodyElementEventMap>(type: K, listener: (this: HTMLBodyElement, ev: HTMLBodyElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLBodyElement: {\n    prototype: HTMLBodyElement;\n    new(): HTMLBodyElement;\n};\n\n/** Provides properties and methods (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating <button> elements. */\ninterface HTMLButtonElement extends HTMLElement {\n    disabled: boolean;\n    /** Retrieves a reference to the form that the object is embedded in. */\n    readonly form: HTMLFormElement | null;\n    /** Overrides the action attribute (where the data on a form is sent) on the parent form element. */\n    formAction: string;\n    /** Used to override the encoding (formEnctype attribute) specified on the form element. */\n    formEnctype: string;\n    /** Overrides the submit method attribute previously specified on a form element. */\n    formMethod: string;\n    /** Overrides any validation or required attributes on a form or form elements to allow it to be submitted without validation. This can be used to create a \"save draft\"-type submit option. */\n    formNoValidate: boolean;\n    /** Overrides the target attribute on a form element. */\n    formTarget: string;\n    readonly labels: NodeListOf<HTMLLabelElement>;\n    /** Sets or retrieves the name of the object. */\n    name: string;\n    /** Gets the classification and default behavior of the button. */\n    type: string;\n    /** Returns the error message that would be displayed if the user submits the form, or an empty string if no error message. It also triggers the standard error message, such as \"this is a required field\". The result is that the user sees validation messages without actually submitting. */\n    readonly validationMessage: string;\n    /** Returns a  ValidityState object that represents the validity states of an element. */\n    readonly validity: ValidityState;\n    /** Sets or retrieves the default or selected value of the control. */\n    value: string;\n    /** Returns whether an element will successfully validate based on forms validation rules and constraints. */\n    readonly willValidate: boolean;\n    /** Returns whether a form will validate when it is submitted, without having to submit it. */\n    checkValidity(): boolean;\n    reportValidity(): boolean;\n    /**\n     * Sets a custom error message that is displayed when a form is submitted.\n     * @param error Sets a custom error message that is displayed when a form is submitted.\n     */\n    setCustomValidity(error: string): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLButtonElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLButtonElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLButtonElement: {\n    prototype: HTMLButtonElement;\n    new(): HTMLButtonElement;\n};\n\n/** Provides properties and methods for manipulating the layout and presentation of <canvas> elements. The HTMLCanvasElement interface also inherits the properties and methods of the HTMLElement interface. */\ninterface HTMLCanvasElement extends HTMLElement {\n    /** Gets or sets the height of a canvas element on a document. */\n    height: number;\n    /** Gets or sets the width of a canvas element on a document. */\n    width: number;\n    captureStream(frameRequestRate?: number): MediaStream;\n    /**\n     * Returns an object that provides methods and properties for drawing and manipulating images and graphics on a canvas element in a document. A context object includes information about colors, line widths, fonts, and other graphic parameters that can be drawn on a canvas.\n     * @param contextId The identifier (ID) of the type of canvas to create. Internet Explorer 9 and Internet Explorer 10 support only a 2-D context using canvas.getContext(\"2d\"); IE11 Preview also supports 3-D or WebGL context using canvas.getContext(\"experimental-webgl\");\n     */\n    getContext(contextId: \"2d\", options?: CanvasRenderingContext2DSettings): CanvasRenderingContext2D | null;\n    getContext(contextId: \"bitmaprenderer\", options?: ImageBitmapRenderingContextSettings): ImageBitmapRenderingContext | null;\n    getContext(contextId: \"webgl\", options?: WebGLContextAttributes): WebGLRenderingContext | null;\n    getContext(contextId: \"webgl2\", options?: WebGLContextAttributes): WebGL2RenderingContext | null;\n    getContext(contextId: string, options?: any): RenderingContext | null;\n    toBlob(callback: BlobCallback, type?: string, quality?: any): void;\n    /**\n     * Returns the content of the current canvas as an image that you can use as a source for another canvas or an HTML element.\n     * @param type The standard MIME type for the image format to return. If you do not specify this parameter, the default value is a PNG format image.\n     */\n    toDataURL(type?: string, quality?: any): string;\n    transferControlToOffscreen(): OffscreenCanvas;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLCanvasElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLCanvasElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLCanvasElement: {\n    prototype: HTMLCanvasElement;\n    new(): HTMLCanvasElement;\n};\n\n/** A generic collection (array-like object similar to arguments) of elements (in document order) and offers methods and properties for selecting from the list. */\ninterface HTMLCollectionBase {\n    /** Sets or retrieves the number of objects in a collection. */\n    readonly length: number;\n    /** Retrieves an object from various collections. */\n    item(index: number): Element | null;\n    [index: number]: Element;\n}\n\ninterface HTMLCollection extends HTMLCollectionBase {\n    /** Retrieves a select object or an object from an options collection. */\n    namedItem(name: string): Element | null;\n}\n\ndeclare var HTMLCollection: {\n    prototype: HTMLCollection;\n    new(): HTMLCollection;\n};\n\ninterface HTMLCollectionOf<T extends Element> extends HTMLCollectionBase {\n    item(index: number): T | null;\n    namedItem(name: string): T | null;\n    [index: number]: T;\n}\n\n/** Provides special properties (beyond those of the regular HTMLElement interface it also has available to it by inheritance) for manipulating definition list (<dl>) elements. */\ninterface HTMLDListElement extends HTMLElement {\n    /** @deprecated */\n    compact: boolean;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDListElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDListElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLDListElement: {\n    prototype: HTMLDListElement;\n    new(): HTMLDListElement;\n};\n\n/** Provides special properties (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating <data> elements. */\ninterface HTMLDataElement extends HTMLElement {\n    value: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDataElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDataElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLDataElement: {\n    prototype: HTMLDataElement;\n    new(): HTMLDataElement;\n};\n\n/** Provides special properties (beyond the HTMLElement object interface it also has available to it by inheritance) to manipulate <datalist> elements and their content. */\ninterface HTMLDataListElement extends HTMLElement {\n    /** Returns an HTMLCollection of the option elements of the datalist element. */\n    readonly options: HTMLCollectionOf<HTMLOptionElement>;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDataListElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDataListElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLDataListElement: {\n    prototype: HTMLDataListElement;\n    new(): HTMLDataListElement;\n};\n\ninterface HTMLDetailsElement extends HTMLElement {\n    open: boolean;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDetailsElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDetailsElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLDetailsElement: {\n    prototype: HTMLDetailsElement;\n    new(): HTMLDetailsElement;\n};\n\ninterface HTMLDialogElement extends HTMLElement {\n    open: boolean;\n    returnValue: string;\n    /**\n     * Closes the dialog element.\n     *\n     * The argument, if provided, provides a return value.\n     */\n    close(returnValue?: string): void;\n    /** Displays the dialog element. */\n    show(): void;\n    showModal(): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDialogElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDialogElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLDialogElement: {\n    prototype: HTMLDialogElement;\n    new(): HTMLDialogElement;\n};\n\n/** @deprecated */\ninterface HTMLDirectoryElement extends HTMLElement {\n    /** @deprecated */\n    compact: boolean;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDirectoryElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDirectoryElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\n/** @deprecated */\ndeclare var HTMLDirectoryElement: {\n    prototype: HTMLDirectoryElement;\n    new(): HTMLDirectoryElement;\n};\n\n/** Provides special properties (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating <div> elements. */\ninterface HTMLDivElement extends HTMLElement {\n    /**\n     * Sets or retrieves how the object is aligned with adjacent text.\n     * @deprecated\n     */\n    align: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDivElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDivElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLDivElement: {\n    prototype: HTMLDivElement;\n    new(): HTMLDivElement;\n};\n\n/** @deprecated use Document */\ninterface HTMLDocument extends Document {\n    addEventListener<K extends keyof DocumentEventMap>(type: K, listener: (this: HTMLDocument, ev: DocumentEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof DocumentEventMap>(type: K, listener: (this: HTMLDocument, ev: DocumentEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\n/** @deprecated */\ndeclare var HTMLDocument: {\n    prototype: HTMLDocument;\n    new(): HTMLDocument;\n};\n\ninterface HTMLElementEventMap extends ElementEventMap, GlobalEventHandlersEventMap {\n}\n\n/** Any HTML element. Some elements directly implement this interface, while others implement it via an interface that inherits it. */\ninterface HTMLElement extends Element, ElementCSSInlineStyle, ElementContentEditable, GlobalEventHandlers, HTMLOrSVGElement {\n    accessKey: string;\n    readonly accessKeyLabel: string;\n    autocapitalize: string;\n    dir: string;\n    draggable: boolean;\n    hidden: boolean;\n    inert: boolean;\n    innerText: string;\n    lang: string;\n    readonly offsetHeight: number;\n    readonly offsetLeft: number;\n    readonly offsetParent: Element | null;\n    readonly offsetTop: number;\n    readonly offsetWidth: number;\n    outerText: string;\n    spellcheck: boolean;\n    title: string;\n    translate: boolean;\n    attachInternals(): ElementInternals;\n    click(): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLElement: {\n    prototype: HTMLElement;\n    new(): HTMLElement;\n};\n\n/** Provides special properties (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating <embed> elements. */\ninterface HTMLEmbedElement extends HTMLElement {\n    /** @deprecated */\n    align: string;\n    /** Sets or retrieves the height of the object. */\n    height: string;\n    /**\n     * Sets or retrieves the name of the object.\n     * @deprecated\n     */\n    name: string;\n    /** Sets or retrieves a URL to be loaded by the object. */\n    src: string;\n    type: string;\n    /** Sets or retrieves the width of the object. */\n    width: string;\n    getSVGDocument(): Document | null;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLEmbedElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLEmbedElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLEmbedElement: {\n    prototype: HTMLEmbedElement;\n    new(): HTMLEmbedElement;\n};\n\n/** Provides special properties and methods (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating the layout and presentation of <fieldset> elements. */\ninterface HTMLFieldSetElement extends HTMLElement {\n    disabled: boolean;\n    /** Returns an HTMLCollection of the form controls in the element. */\n    readonly elements: HTMLCollection;\n    /** Retrieves a reference to the form that the object is embedded in. */\n    readonly form: HTMLFormElement | null;\n    name: string;\n    /** Returns the string \"fieldset\". */\n    readonly type: string;\n    /** Returns the error message that would be displayed if the user submits the form, or an empty string if no error message. It also triggers the standard error message, such as \"this is a required field\". The result is that the user sees validation messages without actually submitting. */\n    readonly validationMessage: string;\n    /** Returns a  ValidityState object that represents the validity states of an element. */\n    readonly validity: ValidityState;\n    /** Returns whether an element will successfully validate based on forms validation rules and constraints. */\n    readonly willValidate: boolean;\n    /** Returns whether a form will validate when it is submitted, without having to submit it. */\n    checkValidity(): boolean;\n    reportValidity(): boolean;\n    /**\n     * Sets a custom error message that is displayed when a form is submitted.\n     * @param error Sets a custom error message that is displayed when a form is submitted.\n     */\n    setCustomValidity(error: string): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLFieldSetElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLFieldSetElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLFieldSetElement: {\n    prototype: HTMLFieldSetElement;\n    new(): HTMLFieldSetElement;\n};\n\n/**\n * Implements the document object model (DOM) representation of the font element. The HTML Font Element <font> defines the font size, font face and color of text.\n * @deprecated\n */\ninterface HTMLFontElement extends HTMLElement {\n    /** @deprecated */\n    color: string;\n    /**\n     * Sets or retrieves the current typeface family.\n     * @deprecated\n     */\n    face: string;\n    /** @deprecated */\n    size: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLFontElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLFontElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\n/** @deprecated */\ndeclare var HTMLFontElement: {\n    prototype: HTMLFontElement;\n    new(): HTMLFontElement;\n};\n\n/** A collection of HTML form control elements.  */\ninterface HTMLFormControlsCollection extends HTMLCollectionBase {\n    /**\n     * Returns the item with ID or name name from the collection.\n     *\n     * If there are multiple matching items, then a RadioNodeList object containing all those elements is returned.\n     */\n    namedItem(name: string): RadioNodeList | Element | null;\n}\n\ndeclare var HTMLFormControlsCollection: {\n    prototype: HTMLFormControlsCollection;\n    new(): HTMLFormControlsCollection;\n};\n\n/** A <form> element in the DOM; it allows access to and in some cases modification of aspects of the form, as well as access to its component elements. */\ninterface HTMLFormElement extends HTMLElement {\n    /** Sets or retrieves a list of character encodings for input data that must be accepted by the server processing the form. */\n    acceptCharset: string;\n    /** Sets or retrieves the URL to which the form content is sent for processing. */\n    action: string;\n    /** Specifies whether autocomplete is applied to an editable text field. */\n    autocomplete: string;\n    /** Retrieves a collection, in source order, of all controls in a given form. */\n    readonly elements: HTMLFormControlsCollection;\n    /** Sets or retrieves the MIME encoding for the form. */\n    encoding: string;\n    /** Sets or retrieves the encoding type for the form. */\n    enctype: string;\n    /** Sets or retrieves the number of objects in a collection. */\n    readonly length: number;\n    /** Sets or retrieves how to send the form data to the server. */\n    method: string;\n    /** Sets or retrieves the name of the object. */\n    name: string;\n    /** Designates a form that is not validated when submitted. */\n    noValidate: boolean;\n    rel: string;\n    readonly relList: DOMTokenList;\n    /** Sets or retrieves the window or frame at which to target content. */\n    target: string;\n    /** Returns whether a form will validate when it is submitted, without having to submit it. */\n    checkValidity(): boolean;\n    reportValidity(): boolean;\n    requestSubmit(submitter?: HTMLElement | null): void;\n    /** Fires when the user resets a form. */\n    reset(): void;\n    /** Fires when a FORM is about to be submitted. */\n    submit(): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLFormElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLFormElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n    [index: number]: Element;\n    [name: string]: any;\n}\n\ndeclare var HTMLFormElement: {\n    prototype: HTMLFormElement;\n    new(): HTMLFormElement;\n};\n\n/** @deprecated */\ninterface HTMLFrameElement extends HTMLElement {\n    /**\n     * Retrieves the document object of the page or frame.\n     * @deprecated\n     */\n    readonly contentDocument: Document | null;\n    /**\n     * Retrieves the object of the specified.\n     * @deprecated\n     */\n    readonly contentWindow: WindowProxy | null;\n    /**\n     * Sets or retrieves whether to display a border for the frame.\n     * @deprecated\n     */\n    frameBorder: string;\n    /**\n     * Sets or retrieves a URI to a long description of the object.\n     * @deprecated\n     */\n    longDesc: string;\n    /**\n     * Sets or retrieves the top and bottom margin heights before displaying the text in a frame.\n     * @deprecated\n     */\n    marginHeight: string;\n    /**\n     * Sets or retrieves the left and right margin widths before displaying the text in a frame.\n     * @deprecated\n     */\n    marginWidth: string;\n    /**\n     * Sets or retrieves the frame name.\n     * @deprecated\n     */\n    name: string;\n    /**\n     * Sets or retrieves whether the user can resize the frame.\n     * @deprecated\n     */\n    noResize: boolean;\n    /**\n     * Sets or retrieves whether the frame can be scrolled.\n     * @deprecated\n     */\n    scrolling: string;\n    /**\n     * Sets or retrieves a URL to be loaded by the object.\n     * @deprecated\n     */\n    src: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLFrameElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLFrameElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\n/** @deprecated */\ndeclare var HTMLFrameElement: {\n    prototype: HTMLFrameElement;\n    new(): HTMLFrameElement;\n};\n\ninterface HTMLFrameSetElementEventMap extends HTMLElementEventMap, WindowEventHandlersEventMap {\n}\n\n/**\n * Provides special properties (beyond those of the regular HTMLElement interface they also inherit) for manipulating <frameset> elements.\n * @deprecated\n */\ninterface HTMLFrameSetElement extends HTMLElement, WindowEventHandlers {\n    /**\n     * Sets or retrieves the frame widths of the object.\n     * @deprecated\n     */\n    cols: string;\n    /**\n     * Sets or retrieves the frame heights of the object.\n     * @deprecated\n     */\n    rows: string;\n    addEventListener<K extends keyof HTMLFrameSetElementEventMap>(type: K, listener: (this: HTMLFrameSetElement, ev: HTMLFrameSetElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLFrameSetElementEventMap>(type: K, listener: (this: HTMLFrameSetElement, ev: HTMLFrameSetElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\n/** @deprecated */\ndeclare var HTMLFrameSetElement: {\n    prototype: HTMLFrameSetElement;\n    new(): HTMLFrameSetElement;\n};\n\n/** Provides special properties (beyond those of the HTMLElement interface it also has available to it by inheritance) for manipulating <hr> elements. */\ninterface HTMLHRElement extends HTMLElement {\n    /**\n     * Sets or retrieves how the object is aligned with adjacent text.\n     * @deprecated\n     */\n    align: string;\n    /** @deprecated */\n    color: string;\n    /**\n     * Sets or retrieves whether the horizontal rule is drawn with 3-D shading.\n     * @deprecated\n     */\n    noShade: boolean;\n    /** @deprecated */\n    size: string;\n    /**\n     * Sets or retrieves the width of the object.\n     * @deprecated\n     */\n    width: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLHRElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLHRElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLHRElement: {\n    prototype: HTMLHRElement;\n    new(): HTMLHRElement;\n};\n\n/** Contains the descriptive information, or metadata, for a document. This object inherits all of the properties and methods described in the HTMLElement interface. */\ninterface HTMLHeadElement extends HTMLElement {\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLHeadElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLHeadElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLHeadElement: {\n    prototype: HTMLHeadElement;\n    new(): HTMLHeadElement;\n};\n\n/** The different heading elements. It inherits methods and properties from the HTMLElement interface. */\ninterface HTMLHeadingElement extends HTMLElement {\n    /**\n     * Sets or retrieves a value that indicates the table alignment.\n     * @deprecated\n     */\n    align: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLHeadingElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLHeadingElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLHeadingElement: {\n    prototype: HTMLHeadingElement;\n    new(): HTMLHeadingElement;\n};\n\n/** Serves as the root node for a given HTML document. This object inherits the properties and methods described in the HTMLElement interface. */\ninterface HTMLHtmlElement extends HTMLElement {\n    /**\n     * Sets or retrieves the DTD version that governs the current document.\n     * @deprecated\n     */\n    version: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLHtmlElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLHtmlElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLHtmlElement: {\n    prototype: HTMLHtmlElement;\n    new(): HTMLHtmlElement;\n};\n\ninterface HTMLHyperlinkElementUtils {\n    /**\n     * Returns the hyperlink's URL's fragment (includes leading \"#\" if non-empty).\n     *\n     * Can be set, to change the URL's fragment (ignores leading \"#\").\n     */\n    hash: string;\n    /**\n     * Returns the hyperlink's URL's host and port (if different from the default port for the scheme).\n     *\n     * Can be set, to change the URL's host and port.\n     */\n    host: string;\n    /**\n     * Returns the hyperlink's URL's host.\n     *\n     * Can be set, to change the URL's host.\n     */\n    hostname: string;\n    /**\n     * Returns the hyperlink's URL.\n     *\n     * Can be set, to change the URL.\n     */\n    href: string;\n    toString(): string;\n    /** Returns the hyperlink's URL's origin. */\n    readonly origin: string;\n    /**\n     * Returns the hyperlink's URL's password.\n     *\n     * Can be set, to change the URL's password.\n     */\n    password: string;\n    /**\n     * Returns the hyperlink's URL's path.\n     *\n     * Can be set, to change the URL's path.\n     */\n    pathname: string;\n    /**\n     * Returns the hyperlink's URL's port.\n     *\n     * Can be set, to change the URL's port.\n     */\n    port: string;\n    /**\n     * Returns the hyperlink's URL's scheme.\n     *\n     * Can be set, to change the URL's scheme.\n     */\n    protocol: string;\n    /**\n     * Returns the hyperlink's URL's query (includes leading \"?\" if non-empty).\n     *\n     * Can be set, to change the URL's query (ignores leading \"?\").\n     */\n    search: string;\n    /**\n     * Returns the hyperlink's URL's username.\n     *\n     * Can be set, to change the URL's username.\n     */\n    username: string;\n}\n\n/** Provides special properties and methods (beyond those of the HTMLElement interface it also has available to it by inheritance) for manipulating the layout and presentation of inline frame elements. */\ninterface HTMLIFrameElement extends HTMLElement {\n    /**\n     * Sets or retrieves how the object is aligned with adjacent text.\n     * @deprecated\n     */\n    align: string;\n    allow: string;\n    allowFullscreen: boolean;\n    /** Retrieves the document object of the page or frame. */\n    readonly contentDocument: Document | null;\n    /** Retrieves the object of the specified. */\n    readonly contentWindow: WindowProxy | null;\n    /**\n     * Sets or retrieves whether to display a border for the frame.\n     * @deprecated\n     */\n    frameBorder: string;\n    /** Sets or retrieves the height of the object. */\n    height: string;\n    /**\n     * Sets or retrieves a URI to a long description of the object.\n     * @deprecated\n     */\n    longDesc: string;\n    /**\n     * Sets or retrieves the top and bottom margin heights before displaying the text in a frame.\n     * @deprecated\n     */\n    marginHeight: string;\n    /**\n     * Sets or retrieves the left and right margin widths before displaying the text in a frame.\n     * @deprecated\n     */\n    marginWidth: string;\n    /** Sets or retrieves the frame name. */\n    name: string;\n    referrerPolicy: ReferrerPolicy;\n    readonly sandbox: DOMTokenList;\n    /**\n     * Sets or retrieves whether the frame can be scrolled.\n     * @deprecated\n     */\n    scrolling: string;\n    /** Sets or retrieves a URL to be loaded by the object. */\n    src: string;\n    /** Sets or retrives the content of the page that is to contain. */\n    srcdoc: string;\n    /** Sets or retrieves the width of the object. */\n    width: string;\n    getSVGDocument(): Document | null;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLIFrameElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLIFrameElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLIFrameElement: {\n    prototype: HTMLIFrameElement;\n    new(): HTMLIFrameElement;\n};\n\n/** Provides special properties and methods for manipulating <img> elements. */\ninterface HTMLImageElement extends HTMLElement {\n    /**\n     * Sets or retrieves how the object is aligned with adjacent text.\n     * @deprecated\n     */\n    align: string;\n    /** Sets or retrieves a text alternative to the graphic. */\n    alt: string;\n    /**\n     * Specifies the properties of a border drawn around an object.\n     * @deprecated\n     */\n    border: string;\n    /** Retrieves whether the object is fully loaded. */\n    readonly complete: boolean;\n    crossOrigin: string | null;\n    readonly currentSrc: string;\n    decoding: \"async\" | \"sync\" | \"auto\";\n    /** Sets or retrieves the height of the object. */\n    height: number;\n    /**\n     * Sets or retrieves the width of the border to draw around the object.\n     * @deprecated\n     */\n    hspace: number;\n    /** Sets or retrieves whether the image is a server-side image map. */\n    isMap: boolean;\n    /** Sets or retrieves the policy for loading image elements that are outside the viewport. */\n    loading: \"eager\" | \"lazy\";\n    /**\n     * Sets or retrieves a Uniform Resource Identifier (URI) to a long description of the object.\n     * @deprecated\n     */\n    longDesc: string;\n    /** @deprecated */\n    lowsrc: string;\n    /**\n     * Sets or retrieves the name of the object.\n     * @deprecated\n     */\n    name: string;\n    /** The original height of the image resource before sizing. */\n    readonly naturalHeight: number;\n    /** The original width of the image resource before sizing. */\n    readonly naturalWidth: number;\n    referrerPolicy: string;\n    sizes: string;\n    /** The address or URL of the a media resource that is to be considered. */\n    src: string;\n    srcset: string;\n    /** Sets or retrieves the URL, often with a bookmark extension (#name), to use as a client-side image map. */\n    useMap: string;\n    /**\n     * Sets or retrieves the vertical margin for the object.\n     * @deprecated\n     */\n    vspace: number;\n    /** Sets or retrieves the width of the object. */\n    width: number;\n    readonly x: number;\n    readonly y: number;\n    decode(): Promise<void>;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLImageElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLImageElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLImageElement: {\n    prototype: HTMLImageElement;\n    new(): HTMLImageElement;\n};\n\n/** Provides special properties and methods for manipulating the options, layout, and presentation of <input> elements. */\ninterface HTMLInputElement extends HTMLElement {\n    /** Sets or retrieves a comma-separated list of content types. */\n    accept: string;\n    /**\n     * Sets or retrieves how the object is aligned with adjacent text.\n     * @deprecated\n     */\n    align: string;\n    /** Sets or retrieves a text alternative to the graphic. */\n    alt: string;\n    /** Specifies whether autocomplete is applied to an editable text field. */\n    autocomplete: string;\n    capture: string;\n    /** Sets or retrieves the state of the check box or radio button. */\n    checked: boolean;\n    /** Sets or retrieves the state of the check box or radio button. */\n    defaultChecked: boolean;\n    /** Sets or retrieves the initial contents of the object. */\n    defaultValue: string;\n    dirName: string;\n    disabled: boolean;\n    /** Returns a FileList object on a file type input object. */\n    files: FileList | null;\n    /** Retrieves a reference to the form that the object is embedded in. */\n    readonly form: HTMLFormElement | null;\n    /** Overrides the action attribute (where the data on a form is sent) on the parent form element. */\n    formAction: string;\n    /** Used to override the encoding (formEnctype attribute) specified on the form element. */\n    formEnctype: string;\n    /** Overrides the submit method attribute previously specified on a form element. */\n    formMethod: string;\n    /** Overrides any validation or required attributes on a form or form elements to allow it to be submitted without validation. This can be used to create a \"save draft\"-type submit option. */\n    formNoValidate: boolean;\n    /** Overrides the target attribute on a form element. */\n    formTarget: string;\n    /** Sets or retrieves the height of the object. */\n    height: number;\n    /** When set, overrides the rendering of checkbox controls so that the current value is not visible. */\n    indeterminate: boolean;\n    readonly labels: NodeListOf<HTMLLabelElement> | null;\n    /** Specifies the ID of a pre-defined datalist of options for an input element. */\n    readonly list: HTMLDataListElement | null;\n    /** Defines the maximum acceptable value for an input element with type=\"number\".When used with the min and step attributes, lets you control the range and increment (such as only even numbers) that the user can enter into an input field. */\n    max: string;\n    /** Sets or retrieves the maximum number of characters that the user can enter in a text control. */\n    maxLength: number;\n    /** Defines the minimum acceptable value for an input element with type=\"number\". When used with the max and step attributes, lets you control the range and increment (such as even numbers only) that the user can enter into an input field. */\n    min: string;\n    minLength: number;\n    /** Sets or retrieves the Boolean value indicating whether multiple items can be selected from a list. */\n    multiple: boolean;\n    /** Sets or retrieves the name of the object. */\n    name: string;\n    /** Gets or sets a string containing a regular expression that the user's input must match. */\n    pattern: string;\n    /** Gets or sets a text string that is displayed in an input field as a hint or prompt to users as the format or type of information they need to enter.The text appears in an input field until the user puts focus on the field. */\n    placeholder: string;\n    readOnly: boolean;\n    /** When present, marks an element that can't be submitted without a value. */\n    required: boolean;\n    selectionDirection: \"forward\" | \"backward\" | \"none\" | null;\n    /** Gets or sets the end position or offset of a text selection. */\n    selectionEnd: number | null;\n    /** Gets or sets the starting position or offset of a text selection. */\n    selectionStart: number | null;\n    size: number;\n    /** The address or URL of the a media resource that is to be considered. */\n    src: string;\n    /** Defines an increment or jump between values that you want to allow the user to enter. When used with the max and min attributes, lets you control the range and increment (for example, allow only even numbers) that the user can enter into an input field. */\n    step: string;\n    /** Returns the content type of the object. */\n    type: string;\n    /**\n     * Sets or retrieves the URL, often with a bookmark extension (#name), to use as a client-side image map.\n     * @deprecated\n     */\n    useMap: string;\n    /** Returns the error message that would be displayed if the user submits the form, or an empty string if no error message. It also triggers the standard error message, such as \"this is a required field\". The result is that the user sees validation messages without actually submitting. */\n    readonly validationMessage: string;\n    /** Returns a  ValidityState object that represents the validity states of an element. */\n    readonly validity: ValidityState;\n    /** Returns the value of the data at the cursor's current position. */\n    value: string;\n    /** Returns a Date object representing the form control's value, if applicable; otherwise, returns null. Can be set, to change the value. Throws an \"InvalidStateError\" DOMException if the control isn't date- or time-based. */\n    valueAsDate: Date | null;\n    /** Returns the input field value as a number. */\n    valueAsNumber: number;\n    readonly webkitEntries: ReadonlyArray<FileSystemEntry>;\n    webkitdirectory: boolean;\n    /** Sets or retrieves the width of the object. */\n    width: number;\n    /** Returns whether an element will successfully validate based on forms validation rules and constraints. */\n    readonly willValidate: boolean;\n    /** Returns whether a form will validate when it is submitted, without having to submit it. */\n    checkValidity(): boolean;\n    reportValidity(): boolean;\n    /** Makes the selection equal to the current object. */\n    select(): void;\n    /**\n     * Sets a custom error message that is displayed when a form is submitted.\n     * @param error Sets a custom error message that is displayed when a form is submitted.\n     */\n    setCustomValidity(error: string): void;\n    setRangeText(replacement: string): void;\n    setRangeText(replacement: string, start: number, end: number, selectionMode?: SelectionMode): void;\n    /**\n     * Sets the start and end positions of a selection in a text field.\n     * @param start The offset into the text field for the start of the selection.\n     * @param end The offset into the text field for the end of the selection.\n     * @param direction The direction in which the selection is performed.\n     */\n    setSelectionRange(start: number | null, end: number | null, direction?: \"forward\" | \"backward\" | \"none\"): void;\n    showPicker(): void;\n    /**\n     * Decrements a range input control's value by the value given by the Step attribute. If the optional parameter is used, it will decrement the input control's step value multiplied by the parameter's value.\n     * @param n Value to decrement the value by.\n     */\n    stepDown(n?: number): void;\n    /**\n     * Increments a range input control's value by the value given by the Step attribute. If the optional parameter is used, will increment the input control's value by that value.\n     * @param n Value to increment the value by.\n     */\n    stepUp(n?: number): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLInputElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLInputElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLInputElement: {\n    prototype: HTMLInputElement;\n    new(): HTMLInputElement;\n};\n\n/** Exposes specific properties and methods (beyond those defined by regular HTMLElement interface it also has available to it by inheritance) for manipulating list elements. */\ninterface HTMLLIElement extends HTMLElement {\n    /** @deprecated */\n    type: string;\n    /** Sets or retrieves the value of a list item. */\n    value: number;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLLIElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLLIElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLLIElement: {\n    prototype: HTMLLIElement;\n    new(): HTMLLIElement;\n};\n\n/** Gives access to properties specific to <label> elements. It inherits methods and properties from the base HTMLElement interface. */\ninterface HTMLLabelElement extends HTMLElement {\n    /** Returns the form control that is associated with this element. */\n    readonly control: HTMLElement | null;\n    /** Retrieves a reference to the form that the object is embedded in. */\n    readonly form: HTMLFormElement | null;\n    /** Sets or retrieves the object to which the given label object is assigned. */\n    htmlFor: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLLabelElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLLabelElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLLabelElement: {\n    prototype: HTMLLabelElement;\n    new(): HTMLLabelElement;\n};\n\n/** The HTMLLegendElement is an interface allowing to access properties of the <legend> elements. It inherits properties and methods from the HTMLElement interface. */\ninterface HTMLLegendElement extends HTMLElement {\n    /** @deprecated */\n    align: string;\n    /** Retrieves a reference to the form that the object is embedded in. */\n    readonly form: HTMLFormElement | null;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLLegendElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLLegendElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLLegendElement: {\n    prototype: HTMLLegendElement;\n    new(): HTMLLegendElement;\n};\n\n/** Reference information for external resources and the relationship of those resources to a document and vice-versa. This object inherits all of the properties and methods of the HTMLElement interface. */\ninterface HTMLLinkElement extends HTMLElement, LinkStyle {\n    as: string;\n    /**\n     * Sets or retrieves the character set used to encode the object.\n     * @deprecated\n     */\n    charset: string;\n    crossOrigin: string | null;\n    disabled: boolean;\n    /** Sets or retrieves a destination URL or an anchor point. */\n    href: string;\n    /** Sets or retrieves the language code of the object. */\n    hreflang: string;\n    imageSizes: string;\n    imageSrcset: string;\n    integrity: string;\n    /** Sets or retrieves the media type. */\n    media: string;\n    referrerPolicy: string;\n    /** Sets or retrieves the relationship between the object and the destination of the link. */\n    rel: string;\n    readonly relList: DOMTokenList;\n    /**\n     * Sets or retrieves the relationship between the object and the destination of the link.\n     * @deprecated\n     */\n    rev: string;\n    readonly sizes: DOMTokenList;\n    /**\n     * Sets or retrieves the window or frame at which to target content.\n     * @deprecated\n     */\n    target: string;\n    /** Sets or retrieves the MIME type of the object. */\n    type: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLLinkElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLLinkElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLLinkElement: {\n    prototype: HTMLLinkElement;\n    new(): HTMLLinkElement;\n};\n\n/** Provides special properties and methods (beyond those of the regular object HTMLElement interface it also has available to it by inheritance) for manipulating the layout and presentation of map elements. */\ninterface HTMLMapElement extends HTMLElement {\n    /** Retrieves a collection of the area objects defined for the given map object. */\n    readonly areas: HTMLCollection;\n    /** Sets or retrieves the name of the object. */\n    name: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMapElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMapElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLMapElement: {\n    prototype: HTMLMapElement;\n    new(): HTMLMapElement;\n};\n\n/**\n * Provides methods to manipulate <marquee> elements.\n * @deprecated\n */\ninterface HTMLMarqueeElement extends HTMLElement {\n    /** @deprecated */\n    behavior: string;\n    /** @deprecated */\n    bgColor: string;\n    /** @deprecated */\n    direction: string;\n    /** @deprecated */\n    height: string;\n    /** @deprecated */\n    hspace: number;\n    /** @deprecated */\n    loop: number;\n    /** @deprecated */\n    scrollAmount: number;\n    /** @deprecated */\n    scrollDelay: number;\n    /** @deprecated */\n    trueSpeed: boolean;\n    /** @deprecated */\n    vspace: number;\n    /** @deprecated */\n    width: string;\n    /** @deprecated */\n    start(): void;\n    /** @deprecated */\n    stop(): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMarqueeElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMarqueeElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\n/** @deprecated */\ndeclare var HTMLMarqueeElement: {\n    prototype: HTMLMarqueeElement;\n    new(): HTMLMarqueeElement;\n};\n\ninterface HTMLMediaElementEventMap extends HTMLElementEventMap {\n    \"encrypted\": MediaEncryptedEvent;\n    \"waitingforkey\": Event;\n}\n\n/** Adds to HTMLElement the properties and methods needed to support basic media-related capabilities that are common to audio and video. */\ninterface HTMLMediaElement extends HTMLElement {\n    /** Gets or sets a value that indicates whether to start playing the media automatically. */\n    autoplay: boolean;\n    /** Gets a collection of buffered time ranges. */\n    readonly buffered: TimeRanges;\n    /** Gets or sets a flag that indicates whether the client provides a set of controls for the media (in case the developer does not include controls for the player). */\n    controls: boolean;\n    crossOrigin: string | null;\n    /** Gets the address or URL of the current media resource that is selected by IHTMLMediaElement. */\n    readonly currentSrc: string;\n    /** Gets or sets the current playback position, in seconds. */\n    currentTime: number;\n    defaultMuted: boolean;\n    /** Gets or sets the default playback rate when the user is not using fast forward or reverse for a video or audio resource. */\n    defaultPlaybackRate: number;\n    disableRemotePlayback: boolean;\n    /** Returns the duration in seconds of the current media resource. A NaN value is returned if duration is not available, or Infinity if the media resource is streaming. */\n    readonly duration: number;\n    /** Gets information about whether the playback has ended or not. */\n    readonly ended: boolean;\n    /** Returns an object representing the current error state of the audio or video element. */\n    readonly error: MediaError | null;\n    /** Gets or sets a flag to specify whether playback should restart after it completes. */\n    loop: boolean;\n    /** Available only in secure contexts. */\n    readonly mediaKeys: MediaKeys | null;\n    /** Gets or sets a flag that indicates whether the audio (either audio or the audio track on video media) is muted. */\n    muted: boolean;\n    /** Gets the current network activity for the element. */\n    readonly networkState: number;\n    onencrypted: ((this: HTMLMediaElement, ev: MediaEncryptedEvent) => any) | null;\n    onwaitingforkey: ((this: HTMLMediaElement, ev: Event) => any) | null;\n    /** Gets a flag that specifies whether playback is paused. */\n    readonly paused: boolean;\n    /** Gets or sets the current rate of speed for the media resource to play. This speed is expressed as a multiple of the normal speed of the media resource. */\n    playbackRate: number;\n    /** Gets TimeRanges for the current media resource that has been played. */\n    readonly played: TimeRanges;\n    /** Gets or sets a value indicating what data should be preloaded, if any. */\n    preload: \"none\" | \"metadata\" | \"auto\" | \"\";\n    preservesPitch: boolean;\n    readonly readyState: number;\n    readonly remote: RemotePlayback;\n    /** Returns a TimeRanges object that represents the ranges of the current media resource that can be seeked. */\n    readonly seekable: TimeRanges;\n    /** Gets a flag that indicates whether the client is currently moving to a new playback position in the media resource. */\n    readonly seeking: boolean;\n    /** The address or URL of the a media resource that is to be considered. */\n    src: string;\n    srcObject: MediaProvider | null;\n    readonly textTracks: TextTrackList;\n    /** Gets or sets the volume level for audio portions of the media element. */\n    volume: number;\n    addTextTrack(kind: TextTrackKind, label?: string, language?: string): TextTrack;\n    /** Returns a string that specifies whether the client can play a given media resource type. */\n    canPlayType(type: string): CanPlayTypeResult;\n    fastSeek(time: number): void;\n    /** Resets the audio or video object and loads a new media resource. */\n    load(): void;\n    /** Pauses the current playback and sets paused to TRUE. This can be used to test whether the media is playing or paused. You can also use the pause or play events to tell whether the media is playing or not. */\n    pause(): void;\n    /** Loads and starts playback of a media resource. */\n    play(): Promise<void>;\n    /** Available only in secure contexts. */\n    setMediaKeys(mediaKeys: MediaKeys | null): Promise<void>;\n    readonly NETWORK_EMPTY: 0;\n    readonly NETWORK_IDLE: 1;\n    readonly NETWORK_LOADING: 2;\n    readonly NETWORK_NO_SOURCE: 3;\n    readonly HAVE_NOTHING: 0;\n    readonly HAVE_METADATA: 1;\n    readonly HAVE_CURRENT_DATA: 2;\n    readonly HAVE_FUTURE_DATA: 3;\n    readonly HAVE_ENOUGH_DATA: 4;\n    addEventListener<K extends keyof HTMLMediaElementEventMap>(type: K, listener: (this: HTMLMediaElement, ev: HTMLMediaElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLMediaElementEventMap>(type: K, listener: (this: HTMLMediaElement, ev: HTMLMediaElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLMediaElement: {\n    prototype: HTMLMediaElement;\n    new(): HTMLMediaElement;\n    readonly NETWORK_EMPTY: 0;\n    readonly NETWORK_IDLE: 1;\n    readonly NETWORK_LOADING: 2;\n    readonly NETWORK_NO_SOURCE: 3;\n    readonly HAVE_NOTHING: 0;\n    readonly HAVE_METADATA: 1;\n    readonly HAVE_CURRENT_DATA: 2;\n    readonly HAVE_FUTURE_DATA: 3;\n    readonly HAVE_ENOUGH_DATA: 4;\n};\n\ninterface HTMLMenuElement extends HTMLElement {\n    /** @deprecated */\n    compact: boolean;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMenuElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMenuElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLMenuElement: {\n    prototype: HTMLMenuElement;\n    new(): HTMLMenuElement;\n};\n\n/** Contains descriptive metadata about a document. It inherits all of the properties and methods described in the HTMLElement interface. */\ninterface HTMLMetaElement extends HTMLElement {\n    /** Gets or sets meta-information to associate with httpEquiv or name. */\n    content: string;\n    /** Gets or sets information used to bind the value of a content attribute of a meta element to an HTTP response header. */\n    httpEquiv: string;\n    media: string;\n    /** Sets or retrieves the value specified in the content attribute of the meta object. */\n    name: string;\n    /**\n     * Sets or retrieves a scheme to be used in interpreting the value of a property specified for the object.\n     * @deprecated\n     */\n    scheme: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMetaElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMetaElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLMetaElement: {\n    prototype: HTMLMetaElement;\n    new(): HTMLMetaElement;\n};\n\n/** The HTML <meter> elements expose the HTMLMeterElement interface, which provides special properties and methods (beyond the HTMLElement object interface they also have available to them by inheritance) for manipulating the layout and presentation of <meter> elements. */\ninterface HTMLMeterElement extends HTMLElement {\n    high: number;\n    readonly labels: NodeListOf<HTMLLabelElement>;\n    low: number;\n    max: number;\n    min: number;\n    optimum: number;\n    value: number;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMeterElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMeterElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLMeterElement: {\n    prototype: HTMLMeterElement;\n    new(): HTMLMeterElement;\n};\n\n/** Provides special properties (beyond the regular methods and properties available through the HTMLElement interface they also have available to them by inheritance) for manipulating modification elements, that is <del> and <ins>. */\ninterface HTMLModElement extends HTMLElement {\n    /** Sets or retrieves reference information about the object. */\n    cite: string;\n    /** Sets or retrieves the date and time of a modification to the object. */\n    dateTime: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLModElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLModElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLModElement: {\n    prototype: HTMLModElement;\n    new(): HTMLModElement;\n};\n\n/** Provides special properties (beyond those defined on the regular HTMLElement interface it also has available to it by inheritance) for manipulating ordered list elements. */\ninterface HTMLOListElement extends HTMLElement {\n    /** @deprecated */\n    compact: boolean;\n    reversed: boolean;\n    /** The starting number. */\n    start: number;\n    type: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLOListElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLOListElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLOListElement: {\n    prototype: HTMLOListElement;\n    new(): HTMLOListElement;\n};\n\n/** Provides special properties and methods (beyond those on the HTMLElement interface it also has available to it by inheritance) for manipulating the layout and presentation of <object> element, representing external resources. */\ninterface HTMLObjectElement extends HTMLElement {\n    /** @deprecated */\n    align: string;\n    /**\n     * Sets or retrieves a character string that can be used to implement your own archive functionality for the object.\n     * @deprecated\n     */\n    archive: string;\n    /** @deprecated */\n    border: string;\n    /**\n     * Sets or retrieves the URL of the file containing the compiled Java class.\n     * @deprecated\n     */\n    code: string;\n    /**\n     * Sets or retrieves the URL of the component.\n     * @deprecated\n     */\n    codeBase: string;\n    /**\n     * Sets or retrieves the Internet media type for the code associated with the object.\n     * @deprecated\n     */\n    codeType: string;\n    /** Retrieves the document object of the page or frame. */\n    readonly contentDocument: Document | null;\n    readonly contentWindow: WindowProxy | null;\n    /** Sets or retrieves the URL that references the data of the object. */\n    data: string;\n    /** @deprecated */\n    declare: boolean;\n    /** Retrieves a reference to the form that the object is embedded in. */\n    readonly form: HTMLFormElement | null;\n    /** Sets or retrieves the height of the object. */\n    height: string;\n    /** @deprecated */\n    hspace: number;\n    /** Sets or retrieves the name of the object. */\n    name: string;\n    /**\n     * Sets or retrieves a message to be displayed while an object is loading.\n     * @deprecated\n     */\n    standby: string;\n    /** Sets or retrieves the MIME type of the object. */\n    type: string;\n    /** Sets or retrieves the URL, often with a bookmark extension (#name), to use as a client-side image map. */\n    useMap: string;\n    /** Returns the error message that would be displayed if the user submits the form, or an empty string if no error message. It also triggers the standard error message, such as \"this is a required field\". The result is that the user sees validation messages without actually submitting. */\n    readonly validationMessage: string;\n    /** Returns a  ValidityState object that represents the validity states of an element. */\n    readonly validity: ValidityState;\n    /** @deprecated */\n    vspace: number;\n    /** Sets or retrieves the width of the object. */\n    width: string;\n    /** Returns whether an element will successfully validate based on forms validation rules and constraints. */\n    readonly willValidate: boolean;\n    /** Returns whether a form will validate when it is submitted, without having to submit it. */\n    checkValidity(): boolean;\n    getSVGDocument(): Document | null;\n    reportValidity(): boolean;\n    /**\n     * Sets a custom error message that is displayed when a form is submitted.\n     * @param error Sets a custom error message that is displayed when a form is submitted.\n     */\n    setCustomValidity(error: string): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLObjectElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLObjectElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLObjectElement: {\n    prototype: HTMLObjectElement;\n    new(): HTMLObjectElement;\n};\n\n/** Provides special properties and methods (beyond the regular HTMLElement object interface they also have available to them by inheritance) for manipulating the layout and presentation of <optgroup> elements. */\ninterface HTMLOptGroupElement extends HTMLElement {\n    disabled: boolean;\n    /** Sets or retrieves a value that you can use to implement your own label functionality for the object. */\n    label: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLOptGroupElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLOptGroupElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLOptGroupElement: {\n    prototype: HTMLOptGroupElement;\n    new(): HTMLOptGroupElement;\n};\n\n/** <option> elements and inherits all classes and methods of the HTMLElement interface. */\ninterface HTMLOptionElement extends HTMLElement {\n    /** Sets or retrieves the status of an option. */\n    defaultSelected: boolean;\n    disabled: boolean;\n    /** Retrieves a reference to the form that the object is embedded in. */\n    readonly form: HTMLFormElement | null;\n    /** Sets or retrieves the ordinal position of an option in a list box. */\n    readonly index: number;\n    /** Sets or retrieves a value that you can use to implement your own label functionality for the object. */\n    label: string;\n    /** Sets or retrieves whether the option in the list box is the default item. */\n    selected: boolean;\n    /** Sets or retrieves the text string specified by the option tag. */\n    text: string;\n    /** Sets or retrieves the value which is returned to the server when the form control is submitted. */\n    value: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLOptionElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLOptionElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLOptionElement: {\n    prototype: HTMLOptionElement;\n    new(): HTMLOptionElement;\n};\n\n/** HTMLOptionsCollection is an interface representing a collection of HTML option elements (in document order) and offers methods and properties for traversing the list as well as optionally altering its items. This type is returned solely by the \"options\" property of select. */\ninterface HTMLOptionsCollection extends HTMLCollectionOf<HTMLOptionElement> {\n    /**\n     * Returns the number of elements in the collection.\n     *\n     * When set to a smaller number, truncates the number of option elements in the corresponding container.\n     *\n     * When set to a greater number, adds new blank option elements to that container.\n     */\n    length: number;\n    /**\n     * Returns the index of the first selected item, if any, or −1 if there is no selected item.\n     *\n     * Can be set, to change the selection.\n     */\n    selectedIndex: number;\n    /**\n     * Inserts element before the node given by before.\n     *\n     * The before argument can be a number, in which case element is inserted before the item with that number, or an element from the collection, in which case element is inserted before that element.\n     *\n     * If before is omitted, null, or a number out of range, then element will be added at the end of the list.\n     *\n     * This method will throw a \"HierarchyRequestError\" DOMException if element is an ancestor of the element into which it is to be inserted.\n     */\n    add(element: HTMLOptionElement | HTMLOptGroupElement, before?: HTMLElement | number | null): void;\n    /** Removes the item with index index from the collection. */\n    remove(index: number): void;\n}\n\ndeclare var HTMLOptionsCollection: {\n    prototype: HTMLOptionsCollection;\n    new(): HTMLOptionsCollection;\n};\n\ninterface HTMLOrSVGElement {\n    autofocus: boolean;\n    readonly dataset: DOMStringMap;\n    nonce?: string;\n    tabIndex: number;\n    blur(): void;\n    focus(options?: FocusOptions): void;\n}\n\n/** Provides properties and methods (beyond those inherited from HTMLElement) for manipulating the layout and presentation of <output> elements. */\ninterface HTMLOutputElement extends HTMLElement {\n    defaultValue: string;\n    readonly form: HTMLFormElement | null;\n    readonly htmlFor: DOMTokenList;\n    readonly labels: NodeListOf<HTMLLabelElement>;\n    name: string;\n    /** Returns the string \"output\". */\n    readonly type: string;\n    readonly validationMessage: string;\n    readonly validity: ValidityState;\n    /**\n     * Returns the element's current value.\n     *\n     * Can be set, to change the value.\n     */\n    value: string;\n    readonly willValidate: boolean;\n    checkValidity(): boolean;\n    reportValidity(): boolean;\n    setCustomValidity(error: string): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLOutputElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLOutputElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLOutputElement: {\n    prototype: HTMLOutputElement;\n    new(): HTMLOutputElement;\n};\n\n/** Provides special properties (beyond those of the regular HTMLElement object interface it inherits) for manipulating <p> elements. */\ninterface HTMLParagraphElement extends HTMLElement {\n    /**\n     * Sets or retrieves how the object is aligned with adjacent text.\n     * @deprecated\n     */\n    align: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLParagraphElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLParagraphElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLParagraphElement: {\n    prototype: HTMLParagraphElement;\n    new(): HTMLParagraphElement;\n};\n\n/**\n * Provides special properties (beyond those of the regular HTMLElement object interface it inherits) for manipulating <param> elements, representing a pair of a key and a value that acts as a parameter for an <object> element.\n * @deprecated\n */\ninterface HTMLParamElement extends HTMLElement {\n    /**\n     * Sets or retrieves the name of an input parameter for an element.\n     * @deprecated\n     */\n    name: string;\n    /**\n     * Sets or retrieves the content type of the resource designated by the value attribute.\n     * @deprecated\n     */\n    type: string;\n    /**\n     * Sets or retrieves the value of an input parameter for an element.\n     * @deprecated\n     */\n    value: string;\n    /**\n     * Sets or retrieves the data type of the value attribute.\n     * @deprecated\n     */\n    valueType: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLParamElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLParamElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\n/** @deprecated */\ndeclare var HTMLParamElement: {\n    prototype: HTMLParamElement;\n    new(): HTMLParamElement;\n};\n\n/** A <picture> HTML element. It doesn't implement specific properties or methods. */\ninterface HTMLPictureElement extends HTMLElement {\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLPictureElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLPictureElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLPictureElement: {\n    prototype: HTMLPictureElement;\n    new(): HTMLPictureElement;\n};\n\n/** Exposes specific properties and methods (beyond those of the HTMLElement interface it also has available to it by inheritance) for manipulating a block of preformatted text (<pre>). */\ninterface HTMLPreElement extends HTMLElement {\n    /**\n     * Sets or gets a value that you can use to implement your own width functionality for the object.\n     * @deprecated\n     */\n    width: number;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLPreElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLPreElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLPreElement: {\n    prototype: HTMLPreElement;\n    new(): HTMLPreElement;\n};\n\n/** Provides special properties and methods (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating the layout and presentation of <progress> elements. */\ninterface HTMLProgressElement extends HTMLElement {\n    readonly labels: NodeListOf<HTMLLabelElement>;\n    /** Defines the maximum, or \"done\" value for a progress element. */\n    max: number;\n    /** Returns the quotient of value/max when the value attribute is set (determinate progress bar), or -1 when the value attribute is missing (indeterminate progress bar). */\n    readonly position: number;\n    /** Sets or gets the current value of a progress element. The value must be a non-negative number between 0 and the max value. */\n    value: number;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLProgressElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLProgressElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLProgressElement: {\n    prototype: HTMLProgressElement;\n    new(): HTMLProgressElement;\n};\n\n/** Provides special properties and methods (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating quoting elements, like <blockquote> and <q>, but not the <cite> element. */\ninterface HTMLQuoteElement extends HTMLElement {\n    /** Sets or retrieves reference information about the object. */\n    cite: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLQuoteElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLQuoteElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLQuoteElement: {\n    prototype: HTMLQuoteElement;\n    new(): HTMLQuoteElement;\n};\n\n/** HTML <script> elements expose the HTMLScriptElement interface, which provides special properties and methods for manipulating the behavior and execution of <script> elements (beyond the inherited HTMLElement interface). */\ninterface HTMLScriptElement extends HTMLElement {\n    async: boolean;\n    /**\n     * Sets or retrieves the character set used to encode the object.\n     * @deprecated\n     */\n    charset: string;\n    crossOrigin: string | null;\n    /** Sets or retrieves the status of the script. */\n    defer: boolean;\n    /**\n     * Sets or retrieves the event for which the script is written.\n     * @deprecated\n     */\n    event: string;\n    /**\n     * Sets or retrieves the object that is bound to the event script.\n     * @deprecated\n     */\n    htmlFor: string;\n    integrity: string;\n    noModule: boolean;\n    referrerPolicy: string;\n    /** Retrieves the URL to an external file that contains the source code or data. */\n    src: string;\n    /** Retrieves or sets the text of the object as a string. */\n    text: string;\n    /** Sets or retrieves the MIME type for the associated scripting engine. */\n    type: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLScriptElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLScriptElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLScriptElement: {\n    prototype: HTMLScriptElement;\n    new(): HTMLScriptElement;\n    supports(type: string): boolean;\n};\n\n/** A <select> HTML Element. These elements also share all of the properties and methods of other HTML elements via the HTMLElement interface. */\ninterface HTMLSelectElement extends HTMLElement {\n    autocomplete: string;\n    disabled: boolean;\n    /** Retrieves a reference to the form that the object is embedded in. */\n    readonly form: HTMLFormElement | null;\n    readonly labels: NodeListOf<HTMLLabelElement>;\n    /** Sets or retrieves the number of objects in a collection. */\n    length: number;\n    /** Sets or retrieves the Boolean value indicating whether multiple items can be selected from a list. */\n    multiple: boolean;\n    /** Sets or retrieves the name of the object. */\n    name: string;\n    /** Returns an HTMLOptionsCollection of the list of options. */\n    readonly options: HTMLOptionsCollection;\n    /** When present, marks an element that can't be submitted without a value. */\n    required: boolean;\n    /** Sets or retrieves the index of the selected option in a select object. */\n    selectedIndex: number;\n    readonly selectedOptions: HTMLCollectionOf<HTMLOptionElement>;\n    /** Sets or retrieves the number of rows in the list box. */\n    size: number;\n    /** Retrieves the type of select control based on the value of the MULTIPLE attribute. */\n    readonly type: string;\n    /** Returns the error message that would be displayed if the user submits the form, or an empty string if no error message. It also triggers the standard error message, such as \"this is a required field\". The result is that the user sees validation messages without actually submitting. */\n    readonly validationMessage: string;\n    /** Returns a  ValidityState object that represents the validity states of an element. */\n    readonly validity: ValidityState;\n    /** Sets or retrieves the value which is returned to the server when the form control is submitted. */\n    value: string;\n    /** Returns whether an element will successfully validate based on forms validation rules and constraints. */\n    readonly willValidate: boolean;\n    /**\n     * Adds an element to the areas, controlRange, or options collection.\n     * @param element Variant of type Number that specifies the index position in the collection where the element is placed. If no value is given, the method places the element at the end of the collection.\n     * @param before Variant of type Object that specifies an element to insert before, or null to append the object to the collection.\n     */\n    add(element: HTMLOptionElement | HTMLOptGroupElement, before?: HTMLElement | number | null): void;\n    /** Returns whether a form will validate when it is submitted, without having to submit it. */\n    checkValidity(): boolean;\n    /**\n     * Retrieves a select object or an object from an options collection.\n     * @param name Variant of type Number or String that specifies the object or collection to retrieve. If this parameter is an integer, it is the zero-based index of the object. If this parameter is a string, all objects with matching name or id properties are retrieved, and a collection is returned if more than one match is made.\n     * @param index Variant of type Number that specifies the zero-based index of the object to retrieve when a collection is returned.\n     */\n    item(index: number): HTMLOptionElement | null;\n    /**\n     * Retrieves a select object or an object from an options collection.\n     * @param namedItem A String that specifies the name or id property of the object to retrieve. A collection is returned if more than one match is made.\n     */\n    namedItem(name: string): HTMLOptionElement | null;\n    /**\n     * Removes an element from the collection.\n     * @param index Number that specifies the zero-based index of the element to remove from the collection.\n     */\n    remove(): void;\n    remove(index: number): void;\n    reportValidity(): boolean;\n    /**\n     * Sets a custom error message that is displayed when a form is submitted.\n     * @param error Sets a custom error message that is displayed when a form is submitted.\n     */\n    setCustomValidity(error: string): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLSelectElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLSelectElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n    [name: number]: HTMLOptionElement | HTMLOptGroupElement;\n}\n\ndeclare var HTMLSelectElement: {\n    prototype: HTMLSelectElement;\n    new(): HTMLSelectElement;\n};\n\ninterface HTMLSlotElement extends HTMLElement {\n    name: string;\n    assign(...nodes: (Element | Text)[]): void;\n    assignedElements(options?: AssignedNodesOptions): Element[];\n    assignedNodes(options?: AssignedNodesOptions): Node[];\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLSlotElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLSlotElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLSlotElement: {\n    prototype: HTMLSlotElement;\n    new(): HTMLSlotElement;\n};\n\n/** Provides special properties (beyond the regular HTMLElement object interface it also has available to it by inheritance) for manipulating <source> elements. */\ninterface HTMLSourceElement extends HTMLElement {\n    height: number;\n    /** Gets or sets the intended media type of the media source. */\n    media: string;\n    sizes: string;\n    /** The address or URL of the a media resource that is to be considered. */\n    src: string;\n    srcset: string;\n    /** Gets or sets the MIME type of a media resource. */\n    type: string;\n    width: number;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLSourceElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLSourceElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLSourceElement: {\n    prototype: HTMLSourceElement;\n    new(): HTMLSourceElement;\n};\n\n/** A <span> element and derives from the HTMLElement interface, but without implementing any additional properties or methods. */\ninterface HTMLSpanElement extends HTMLElement {\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLSpanElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLSpanElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLSpanElement: {\n    prototype: HTMLSpanElement;\n    new(): HTMLSpanElement;\n};\n\n/** A <style> element. It inherits properties and methods from its parent, HTMLElement, and from LinkStyle. */\ninterface HTMLStyleElement extends HTMLElement, LinkStyle {\n    /** Enables or disables the style sheet. */\n    disabled: boolean;\n    /** Sets or retrieves the media type. */\n    media: string;\n    /**\n     * Retrieves the CSS language in which the style sheet is written.\n     * @deprecated\n     */\n    type: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLStyleElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLStyleElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLStyleElement: {\n    prototype: HTMLStyleElement;\n    new(): HTMLStyleElement;\n};\n\n/** Special properties (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating table caption elements. */\ninterface HTMLTableCaptionElement extends HTMLElement {\n    /**\n     * Sets or retrieves the alignment of the caption or legend.\n     * @deprecated\n     */\n    align: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableCaptionElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableCaptionElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLTableCaptionElement: {\n    prototype: HTMLTableCaptionElement;\n    new(): HTMLTableCaptionElement;\n};\n\n/** Provides special properties and methods (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating the layout and presentation of table cells, either header or data cells, in an HTML document. */\ninterface HTMLTableCellElement extends HTMLElement {\n    /** Sets or retrieves abbreviated text for the object. */\n    abbr: string;\n    /**\n     * Sets or retrieves how the object is aligned with adjacent text.\n     * @deprecated\n     */\n    align: string;\n    /**\n     * Sets or retrieves a comma-delimited list of conceptual categories associated with the object.\n     * @deprecated\n     */\n    axis: string;\n    /** @deprecated */\n    bgColor: string;\n    /** Retrieves the position of the object in the cells collection of a row. */\n    readonly cellIndex: number;\n    /** @deprecated */\n    ch: string;\n    /** @deprecated */\n    chOff: string;\n    /** Sets or retrieves the number columns in the table that the object should span. */\n    colSpan: number;\n    /** Sets or retrieves a list of header cells that provide information for the object. */\n    headers: string;\n    /**\n     * Sets or retrieves the height of the object.\n     * @deprecated\n     */\n    height: string;\n    /**\n     * Sets or retrieves whether the browser automatically performs wordwrap.\n     * @deprecated\n     */\n    noWrap: boolean;\n    /** Sets or retrieves how many rows in a table the cell should span. */\n    rowSpan: number;\n    /** Sets or retrieves the group of cells in a table to which the object's information applies. */\n    scope: string;\n    /** @deprecated */\n    vAlign: string;\n    /**\n     * Sets or retrieves the width of the object.\n     * @deprecated\n     */\n    width: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableCellElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableCellElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLTableCellElement: {\n    prototype: HTMLTableCellElement;\n    new(): HTMLTableCellElement;\n};\n\n/** Provides special properties (beyond the HTMLElement interface it also has available to it inheritance) for manipulating single or grouped table column elements. */\ninterface HTMLTableColElement extends HTMLElement {\n    /**\n     * Sets or retrieves the alignment of the object relative to the display or table.\n     * @deprecated\n     */\n    align: string;\n    /** @deprecated */\n    ch: string;\n    /** @deprecated */\n    chOff: string;\n    /** Sets or retrieves the number of columns in the group. */\n    span: number;\n    /** @deprecated */\n    vAlign: string;\n    /**\n     * Sets or retrieves the width of the object.\n     * @deprecated\n     */\n    width: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableColElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableColElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLTableColElement: {\n    prototype: HTMLTableColElement;\n    new(): HTMLTableColElement;\n};\n\n/** @deprecated prefer HTMLTableCellElement */\ninterface HTMLTableDataCellElement extends HTMLTableCellElement {\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableDataCellElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableDataCellElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\n/** Provides special properties and methods (beyond the regular HTMLElement object interface it also has available to it by inheritance) for manipulating the layout and presentation of tables in an HTML document. */\ninterface HTMLTableElement extends HTMLElement {\n    /**\n     * Sets or retrieves a value that indicates the table alignment.\n     * @deprecated\n     */\n    align: string;\n    /** @deprecated */\n    bgColor: string;\n    /**\n     * Sets or retrieves the width of the border to draw around the object.\n     * @deprecated\n     */\n    border: string;\n    /** Retrieves the caption object of a table. */\n    caption: HTMLTableCaptionElement | null;\n    /**\n     * Sets or retrieves the amount of space between the border of the cell and the content of the cell.\n     * @deprecated\n     */\n    cellPadding: string;\n    /**\n     * Sets or retrieves the amount of space between cells in a table.\n     * @deprecated\n     */\n    cellSpacing: string;\n    /**\n     * Sets or retrieves the way the border frame around the table is displayed.\n     * @deprecated\n     */\n    frame: string;\n    /** Sets or retrieves the number of horizontal rows contained in the object. */\n    readonly rows: HTMLCollectionOf<HTMLTableRowElement>;\n    /**\n     * Sets or retrieves which dividing lines (inner borders) are displayed.\n     * @deprecated\n     */\n    rules: string;\n    /**\n     * Sets or retrieves a description and/or structure of the object.\n     * @deprecated\n     */\n    summary: string;\n    /** Retrieves a collection of all tBody objects in the table. Objects in this collection are in source order. */\n    readonly tBodies: HTMLCollectionOf<HTMLTableSectionElement>;\n    /** Retrieves the tFoot object of the table. */\n    tFoot: HTMLTableSectionElement | null;\n    /** Retrieves the tHead object of the table. */\n    tHead: HTMLTableSectionElement | null;\n    /**\n     * Sets or retrieves the width of the object.\n     * @deprecated\n     */\n    width: string;\n    /** Creates an empty caption element in the table. */\n    createCaption(): HTMLTableCaptionElement;\n    /** Creates an empty tBody element in the table. */\n    createTBody(): HTMLTableSectionElement;\n    /** Creates an empty tFoot element in the table. */\n    createTFoot(): HTMLTableSectionElement;\n    /** Returns the tHead element object if successful, or null otherwise. */\n    createTHead(): HTMLTableSectionElement;\n    /** Deletes the caption element and its contents from the table. */\n    deleteCaption(): void;\n    /**\n     * Removes the specified row (tr) from the element and from the rows collection.\n     * @param index Number that specifies the zero-based position in the rows collection of the row to remove.\n     */\n    deleteRow(index: number): void;\n    /** Deletes the tFoot element and its contents from the table. */\n    deleteTFoot(): void;\n    /** Deletes the tHead element and its contents from the table. */\n    deleteTHead(): void;\n    /**\n     * Creates a new row (tr) in the table, and adds the row to the rows collection.\n     * @param index Number that specifies where to insert the row in the rows collection. The default value is -1, which appends the new row to the end of the rows collection.\n     */\n    insertRow(index?: number): HTMLTableRowElement;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLTableElement: {\n    prototype: HTMLTableElement;\n    new(): HTMLTableElement;\n};\n\n/** @deprecated prefer HTMLTableCellElement */\ninterface HTMLTableHeaderCellElement extends HTMLTableCellElement {\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableHeaderCellElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableHeaderCellElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\n/** Provides special properties and methods (beyond the HTMLElement interface it also has available to it by inheritance) for manipulating the layout and presentation of rows in an HTML table. */\ninterface HTMLTableRowElement extends HTMLElement {\n    /**\n     * Sets or retrieves how the object is aligned with adjacent text.\n     * @deprecated\n     */\n    align: string;\n    /** @deprecated */\n    bgColor: string;\n    /** Retrieves a collection of all cells in the table row. */\n    readonly cells: HTMLCollectionOf<HTMLTableCellElement>;\n    /** @deprecated */\n    ch: string;\n    /** @deprecated */\n    chOff: string;\n    /** Retrieves the position of the object in the rows collection for the table. */\n    readonly rowIndex: number;\n    /** Retrieves the position of the object in the collection. */\n    readonly sectionRowIndex: number;\n    /** @deprecated */\n    vAlign: string;\n    /**\n     * Removes the specified cell from the table row, as well as from the cells collection.\n     * @param index Number that specifies the zero-based position of the cell to remove from the table row. If no value is provided, the last cell in the cells collection is deleted.\n     */\n    deleteCell(index: number): void;\n    /**\n     * Creates a new cell in the table row, and adds the cell to the cells collection.\n     * @param index Number that specifies where to insert the cell in the tr. The default value is -1, which appends the new cell to the end of the cells collection.\n     */\n    insertCell(index?: number): HTMLTableCellElement;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableRowElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableRowElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLTableRowElement: {\n    prototype: HTMLTableRowElement;\n    new(): HTMLTableRowElement;\n};\n\n/** Provides special properties and methods (beyond the HTMLElement interface it also has available to it by inheritance) for manipulating the layout and presentation of sections, that is headers, footers and bodies, in an HTML table. */\ninterface HTMLTableSectionElement extends HTMLElement {\n    /**\n     * Sets or retrieves a value that indicates the table alignment.\n     * @deprecated\n     */\n    align: string;\n    /** @deprecated */\n    ch: string;\n    /** @deprecated */\n    chOff: string;\n    /** Sets or retrieves the number of horizontal rows contained in the object. */\n    readonly rows: HTMLCollectionOf<HTMLTableRowElement>;\n    /** @deprecated */\n    vAlign: string;\n    /**\n     * Removes the specified row (tr) from the element and from the rows collection.\n     * @param index Number that specifies the zero-based position in the rows collection of the row to remove.\n     */\n    deleteRow(index: number): void;\n    /**\n     * Creates a new row (tr) in the table, and adds the row to the rows collection.\n     * @param index Number that specifies where to insert the row in the rows collection. The default value is -1, which appends the new row to the end of the rows collection.\n     */\n    insertRow(index?: number): HTMLTableRowElement;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableSectionElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableSectionElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLTableSectionElement: {\n    prototype: HTMLTableSectionElement;\n    new(): HTMLTableSectionElement;\n};\n\n/** Enables access to the contents of an HTML <template> element. */\ninterface HTMLTemplateElement extends HTMLElement {\n    /** Returns the template contents (a DocumentFragment). */\n    readonly content: DocumentFragment;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTemplateElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTemplateElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLTemplateElement: {\n    prototype: HTMLTemplateElement;\n    new(): HTMLTemplateElement;\n};\n\n/** Provides special properties and methods for manipulating the layout and presentation of <textarea> elements. */\ninterface HTMLTextAreaElement extends HTMLElement {\n    autocomplete: string;\n    /** Sets or retrieves the width of the object. */\n    cols: number;\n    /** Sets or retrieves the initial contents of the object. */\n    defaultValue: string;\n    dirName: string;\n    disabled: boolean;\n    /** Retrieves a reference to the form that the object is embedded in. */\n    readonly form: HTMLFormElement | null;\n    readonly labels: NodeListOf<HTMLLabelElement>;\n    /** Sets or retrieves the maximum number of characters that the user can enter in a text control. */\n    maxLength: number;\n    minLength: number;\n    /** Sets or retrieves the name of the object. */\n    name: string;\n    /** Gets or sets a text string that is displayed in an input field as a hint or prompt to users as the format or type of information they need to enter.The text appears in an input field until the user puts focus on the field. */\n    placeholder: string;\n    /** Sets or retrieves the value indicated whether the content of the object is read-only. */\n    readOnly: boolean;\n    /** When present, marks an element that can't be submitted without a value. */\n    required: boolean;\n    /** Sets or retrieves the number of horizontal rows contained in the object. */\n    rows: number;\n    selectionDirection: \"forward\" | \"backward\" | \"none\";\n    /** Gets or sets the end position or offset of a text selection. */\n    selectionEnd: number;\n    /** Gets or sets the starting position or offset of a text selection. */\n    selectionStart: number;\n    readonly textLength: number;\n    /** Retrieves the type of control. */\n    readonly type: string;\n    /** Returns the error message that would be displayed if the user submits the form, or an empty string if no error message. It also triggers the standard error message, such as \"this is a required field\". The result is that the user sees validation messages without actually submitting. */\n    readonly validationMessage: string;\n    /** Returns a  ValidityState object that represents the validity states of an element. */\n    readonly validity: ValidityState;\n    /** Retrieves or sets the text in the entry field of the textArea element. */\n    value: string;\n    /** Returns whether an element will successfully validate based on forms validation rules and constraints. */\n    readonly willValidate: boolean;\n    /** Sets or retrieves how to handle wordwrapping in the object. */\n    wrap: string;\n    /** Returns whether a form will validate when it is submitted, without having to submit it. */\n    checkValidity(): boolean;\n    reportValidity(): boolean;\n    /** Highlights the input area of a form element. */\n    select(): void;\n    /**\n     * Sets a custom error message that is displayed when a form is submitted.\n     * @param error Sets a custom error message that is displayed when a form is submitted.\n     */\n    setCustomValidity(error: string): void;\n    setRangeText(replacement: string): void;\n    setRangeText(replacement: string, start: number, end: number, selectionMode?: SelectionMode): void;\n    /**\n     * Sets the start and end positions of a selection in a text field.\n     * @param start The offset into the text field for the start of the selection.\n     * @param end The offset into the text field for the end of the selection.\n     * @param direction The direction in which the selection is performed.\n     */\n    setSelectionRange(start: number | null, end: number | null, direction?: \"forward\" | \"backward\" | \"none\"): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTextAreaElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTextAreaElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLTextAreaElement: {\n    prototype: HTMLTextAreaElement;\n    new(): HTMLTextAreaElement;\n};\n\n/** Provides special properties (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating <time> elements. */\ninterface HTMLTimeElement extends HTMLElement {\n    dateTime: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTimeElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTimeElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLTimeElement: {\n    prototype: HTMLTimeElement;\n    new(): HTMLTimeElement;\n};\n\n/** Contains the title for a document. This element inherits all of the properties and methods of the HTMLElement interface. */\ninterface HTMLTitleElement extends HTMLElement {\n    /** Retrieves or sets the text of the object as a string. */\n    text: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTitleElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTitleElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLTitleElement: {\n    prototype: HTMLTitleElement;\n    new(): HTMLTitleElement;\n};\n\n/** The HTMLTrackElement */\ninterface HTMLTrackElement extends HTMLElement {\n    default: boolean;\n    kind: string;\n    label: string;\n    readonly readyState: number;\n    src: string;\n    srclang: string;\n    /** Returns the TextTrack object corresponding to the text track of the track element. */\n    readonly track: TextTrack;\n    readonly NONE: 0;\n    readonly LOADING: 1;\n    readonly LOADED: 2;\n    readonly ERROR: 3;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTrackElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTrackElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLTrackElement: {\n    prototype: HTMLTrackElement;\n    new(): HTMLTrackElement;\n    readonly NONE: 0;\n    readonly LOADING: 1;\n    readonly LOADED: 2;\n    readonly ERROR: 3;\n};\n\n/** Provides special properties (beyond those defined on the regular HTMLElement interface it also has available to it by inheritance) for manipulating unordered list elements. */\ninterface HTMLUListElement extends HTMLElement {\n    /** @deprecated */\n    compact: boolean;\n    /** @deprecated */\n    type: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLUListElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLUListElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLUListElement: {\n    prototype: HTMLUListElement;\n    new(): HTMLUListElement;\n};\n\n/** An invalid HTML element and derives from the HTMLElement interface, but without implementing any additional properties or methods. */\ninterface HTMLUnknownElement extends HTMLElement {\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLUnknownElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLUnknownElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLUnknownElement: {\n    prototype: HTMLUnknownElement;\n    new(): HTMLUnknownElement;\n};\n\ninterface HTMLVideoElementEventMap extends HTMLMediaElementEventMap {\n    \"enterpictureinpicture\": Event;\n    \"leavepictureinpicture\": Event;\n}\n\n/** Provides special properties and methods for manipulating video objects. It also inherits properties and methods of HTMLMediaElement and HTMLElement. */\ninterface HTMLVideoElement extends HTMLMediaElement {\n    disablePictureInPicture: boolean;\n    /** Gets or sets the height of the video element. */\n    height: number;\n    onenterpictureinpicture: ((this: HTMLVideoElement, ev: Event) => any) | null;\n    onleavepictureinpicture: ((this: HTMLVideoElement, ev: Event) => any) | null;\n    /** Gets or sets the playsinline of the video element. for example, On iPhone, video elements will now be allowed to play inline, and will not automatically enter fullscreen mode when playback begins. */\n    playsInline: boolean;\n    /** Gets or sets a URL of an image to display, for example, like a movie poster. This can be a still frame from the video, or another image if no video data is available. */\n    poster: string;\n    /** Gets the intrinsic height of a video in CSS pixels, or zero if the dimensions are not known. */\n    readonly videoHeight: number;\n    /** Gets the intrinsic width of a video in CSS pixels, or zero if the dimensions are not known. */\n    readonly videoWidth: number;\n    /** Gets or sets the width of the video element. */\n    width: number;\n    cancelVideoFrameCallback(handle: number): void;\n    getVideoPlaybackQuality(): VideoPlaybackQuality;\n    requestPictureInPicture(): Promise<PictureInPictureWindow>;\n    requestVideoFrameCallback(callback: VideoFrameRequestCallback): number;\n    addEventListener<K extends keyof HTMLVideoElementEventMap>(type: K, listener: (this: HTMLVideoElement, ev: HTMLVideoElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLVideoElementEventMap>(type: K, listener: (this: HTMLVideoElement, ev: HTMLVideoElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLVideoElement: {\n    prototype: HTMLVideoElement;\n    new(): HTMLVideoElement;\n};\n\n/** Events that fire when the fragment identifier of the URL has changed. */\ninterface HashChangeEvent extends Event {\n    /** Returns the URL of the session history entry that is now current. */\n    readonly newURL: string;\n    /** Returns the URL of the session history entry that was previously current. */\n    readonly oldURL: string;\n}\n\ndeclare var HashChangeEvent: {\n    prototype: HashChangeEvent;\n    new(type: string, eventInitDict?: HashChangeEventInit): HashChangeEvent;\n};\n\n/** This Fetch API interface allows you to perform various actions on HTTP request and response headers. These actions include retrieving, setting, adding to, and removing. A Headers object has an associated header list, which is initially empty and consists of zero or more name and value pairs.  You can add to this using methods like append() (see Examples.) In all methods of this interface, header names are matched by case-insensitive byte sequence. */\ninterface Headers {\n    append(name: string, value: string): void;\n    delete(name: string): void;\n    get(name: string): string | null;\n    has(name: string): boolean;\n    set(name: string, value: string): void;\n    forEach(callbackfn: (value: string, key: string, parent: Headers) => void, thisArg?: any): void;\n}\n\ndeclare var Headers: {\n    prototype: Headers;\n    new(init?: HeadersInit): Headers;\n};\n\n/** Allows manipulation of the browser session history, that is the pages visited in the tab or frame that the current page is loaded in. */\ninterface History {\n    readonly length: number;\n    scrollRestoration: ScrollRestoration;\n    readonly state: any;\n    back(): void;\n    forward(): void;\n    go(delta?: number): void;\n    pushState(data: any, unused: string, url?: string | URL | null): void;\n    replaceState(data: any, unused: string, url?: string | URL | null): void;\n}\n\ndeclare var History: {\n    prototype: History;\n    new(): History;\n};\n\n/** This IndexedDB API interface represents a cursor for traversing or iterating over multiple records in a database. */\ninterface IDBCursor {\n    /** Returns the direction (\"next\", \"nextunique\", \"prev\" or \"prevunique\") of the cursor. */\n    readonly direction: IDBCursorDirection;\n    /** Returns the key of the cursor. Throws a \"InvalidStateError\" DOMException if the cursor is advancing or is finished. */\n    readonly key: IDBValidKey;\n    /** Returns the effective key of the cursor. Throws a \"InvalidStateError\" DOMException if the cursor is advancing or is finished. */\n    readonly primaryKey: IDBValidKey;\n    readonly request: IDBRequest;\n    /** Returns the IDBObjectStore or IDBIndex the cursor was opened from. */\n    readonly source: IDBObjectStore | IDBIndex;\n    /** Advances the cursor through the next count records in range. */\n    advance(count: number): void;\n    /** Advances the cursor to the next record in range. */\n    continue(key?: IDBValidKey): void;\n    /** Advances the cursor to the next record in range matching or after key and primaryKey. Throws an \"InvalidAccessError\" DOMException if the source is not an index. */\n    continuePrimaryKey(key: IDBValidKey, primaryKey: IDBValidKey): void;\n    /**\n     * Delete the record pointed at by the cursor with a new value.\n     *\n     * If successful, request's result will be undefined.\n     */\n    delete(): IDBRequest<undefined>;\n    /**\n     * Updated the record pointed at by the cursor with a new value.\n     *\n     * Throws a \"DataError\" DOMException if the effective object store uses in-line keys and the key would have changed.\n     *\n     * If successful, request's result will be the record's key.\n     */\n    update(value: any): IDBRequest<IDBValidKey>;\n}\n\ndeclare var IDBCursor: {\n    prototype: IDBCursor;\n    new(): IDBCursor;\n};\n\n/** This IndexedDB API interface represents a cursor for traversing or iterating over multiple records in a database. It is the same as the IDBCursor, except that it includes the value property. */\ninterface IDBCursorWithValue extends IDBCursor {\n    /** Returns the cursor's current value. */\n    readonly value: any;\n}\n\ndeclare var IDBCursorWithValue: {\n    prototype: IDBCursorWithValue;\n    new(): IDBCursorWithValue;\n};\n\ninterface IDBDatabaseEventMap {\n    \"abort\": Event;\n    \"close\": Event;\n    \"error\": Event;\n    \"versionchange\": IDBVersionChangeEvent;\n}\n\n/** This IndexedDB API interface provides a connection to a database; you can use an IDBDatabase object to open a transaction on your database then create, manipulate, and delete objects (data) in that database. The interface provides the only way to get and manage versions of the database. */\ninterface IDBDatabase extends EventTarget {\n    /** Returns the name of the database. */\n    readonly name: string;\n    /** Returns a list of the names of object stores in the database. */\n    readonly objectStoreNames: DOMStringList;\n    onabort: ((this: IDBDatabase, ev: Event) => any) | null;\n    onclose: ((this: IDBDatabase, ev: Event) => any) | null;\n    onerror: ((this: IDBDatabase, ev: Event) => any) | null;\n    onversionchange: ((this: IDBDatabase, ev: IDBVersionChangeEvent) => any) | null;\n    /** Returns the version of the database. */\n    readonly version: number;\n    /** Closes the connection once all running transactions have finished. */\n    close(): void;\n    /**\n     * Creates a new object store with the given name and options and returns a new IDBObjectStore.\n     *\n     * Throws a \"InvalidStateError\" DOMException if not called within an upgrade transaction.\n     */\n    createObjectStore(name: string, options?: IDBObjectStoreParameters): IDBObjectStore;\n    /**\n     * Deletes the object store with the given name.\n     *\n     * Throws a \"InvalidStateError\" DOMException if not called within an upgrade transaction.\n     */\n    deleteObjectStore(name: string): void;\n    /** Returns a new transaction with the given mode (\"readonly\" or \"readwrite\") and scope which can be a single object store name or an array of names. */\n    transaction(storeNames: string | string[], mode?: IDBTransactionMode, options?: IDBTransactionOptions): IDBTransaction;\n    addEventListener<K extends keyof IDBDatabaseEventMap>(type: K, listener: (this: IDBDatabase, ev: IDBDatabaseEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof IDBDatabaseEventMap>(type: K, listener: (this: IDBDatabase, ev: IDBDatabaseEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var IDBDatabase: {\n    prototype: IDBDatabase;\n    new(): IDBDatabase;\n};\n\n/** In the following code snippet, we make a request to open a database, and include handlers for the success and error cases. For a full working example, see our To-do Notifications app (view example live.) */\ninterface IDBFactory {\n    /**\n     * Compares two values as keys. Returns -1 if key1 precedes key2, 1 if key2 precedes key1, and 0 if the keys are equal.\n     *\n     * Throws a \"DataError\" DOMException if either input is not a valid key.\n     */\n    cmp(first: any, second: any): number;\n    databases(): Promise<IDBDatabaseInfo[]>;\n    /** Attempts to delete the named database. If the database already exists and there are open connections that don't close in response to a versionchange event, the request will be blocked until all they close. If the request is successful request's result will be null. */\n    deleteDatabase(name: string): IDBOpenDBRequest;\n    /** Attempts to open a connection to the named database with the current version, or 1 if it does not already exist. If the request is successful request's result will be the connection. */\n    open(name: string, version?: number): IDBOpenDBRequest;\n}\n\ndeclare var IDBFactory: {\n    prototype: IDBFactory;\n    new(): IDBFactory;\n};\n\n/** IDBIndex interface of the IndexedDB API provides asynchronous access to an index in a database. An index is a kind of object store for looking up records in another object store, called the referenced object store. You use this interface to retrieve data. */\ninterface IDBIndex {\n    readonly keyPath: string | string[];\n    readonly multiEntry: boolean;\n    /** Returns the name of the index. */\n    name: string;\n    /** Returns the IDBObjectStore the index belongs to. */\n    readonly objectStore: IDBObjectStore;\n    readonly unique: boolean;\n    /**\n     * Retrieves the number of records matching the given key or key range in query.\n     *\n     * If successful, request's result will be the count.\n     */\n    count(query?: IDBValidKey | IDBKeyRange): IDBRequest<number>;\n    /**\n     * Retrieves the value of the first record matching the given key or key range in query.\n     *\n     * If successful, request's result will be the value, or undefined if there was no matching record.\n     */\n    get(query: IDBValidKey | IDBKeyRange): IDBRequest<any>;\n    /**\n     * Retrieves the values of the records matching the given key or key range in query (up to count if given).\n     *\n     * If successful, request's result will be an Array of the values.\n     */\n    getAll(query?: IDBValidKey | IDBKeyRange | null, count?: number): IDBRequest<any[]>;\n    /**\n     * Retrieves the keys of records matching the given key or key range in query (up to count if given).\n     *\n     * If successful, request's result will be an Array of the keys.\n     */\n    getAllKeys(query?: IDBValidKey | IDBKeyRange | null, count?: number): IDBRequest<IDBValidKey[]>;\n    /**\n     * Retrieves the key of the first record matching the given key or key range in query.\n     *\n     * If successful, request's result will be the key, or undefined if there was no matching record.\n     */\n    getKey(query: IDBValidKey | IDBKeyRange): IDBRequest<IDBValidKey | undefined>;\n    /**\n     * Opens a cursor over the records matching query, ordered by direction. If query is null, all records in index are matched.\n     *\n     * If successful, request's result will be an IDBCursorWithValue, or null if there were no matching records.\n     */\n    openCursor(query?: IDBValidKey | IDBKeyRange | null, direction?: IDBCursorDirection): IDBRequest<IDBCursorWithValue | null>;\n    /**\n     * Opens a cursor with key only flag set over the records matching query, ordered by direction. If query is null, all records in index are matched.\n     *\n     * If successful, request's result will be an IDBCursor, or null if there were no matching records.\n     */\n    openKeyCursor(query?: IDBValidKey | IDBKeyRange | null, direction?: IDBCursorDirection): IDBRequest<IDBCursor | null>;\n}\n\ndeclare var IDBIndex: {\n    prototype: IDBIndex;\n    new(): IDBIndex;\n};\n\n/** A key range can be a single value or a range with upper and lower bounds or endpoints. If the key range has both upper and lower bounds, then it is bounded; if it has no bounds, it is unbounded. A bounded key range can either be open (the endpoints are excluded) or closed (the endpoints are included). To retrieve all keys within a certain range, you can use the following code constructs: */\ninterface IDBKeyRange {\n    /** Returns lower bound, or undefined if none. */\n    readonly lower: any;\n    /** Returns true if the lower open flag is set, and false otherwise. */\n    readonly lowerOpen: boolean;\n    /** Returns upper bound, or undefined if none. */\n    readonly upper: any;\n    /** Returns true if the upper open flag is set, and false otherwise. */\n    readonly upperOpen: boolean;\n    /** Returns true if key is included in the range, and false otherwise. */\n    includes(key: any): boolean;\n}\n\ndeclare var IDBKeyRange: {\n    prototype: IDBKeyRange;\n    new(): IDBKeyRange;\n    /** Returns a new IDBKeyRange spanning from lower to upper. If lowerOpen is true, lower is not included in the range. If upperOpen is true, upper is not included in the range. */\n    bound(lower: any, upper: any, lowerOpen?: boolean, upperOpen?: boolean): IDBKeyRange;\n    /** Returns a new IDBKeyRange starting at key with no upper bound. If open is true, key is not included in the range. */\n    lowerBound(lower: any, open?: boolean): IDBKeyRange;\n    /** Returns a new IDBKeyRange spanning only key. */\n    only(value: any): IDBKeyRange;\n    /** Returns a new IDBKeyRange with no lower bound and ending at key. If open is true, key is not included in the range. */\n    upperBound(upper: any, open?: boolean): IDBKeyRange;\n};\n\n/** This example shows a variety of different uses of object stores, from updating the data structure with IDBObjectStore.createIndex inside an onupgradeneeded function, to adding a new item to our object store with IDBObjectStore.add. For a full working example, see our To-do Notifications app (view example live.) */\ninterface IDBObjectStore {\n    /** Returns true if the store has a key generator, and false otherwise. */\n    readonly autoIncrement: boolean;\n    /** Returns a list of the names of indexes in the store. */\n    readonly indexNames: DOMStringList;\n    /** Returns the key path of the store, or null if none. */\n    readonly keyPath: string | string[];\n    /** Returns the name of the store. */\n    name: string;\n    /** Returns the associated transaction. */\n    readonly transaction: IDBTransaction;\n    /**\n     * Adds or updates a record in store with the given value and key.\n     *\n     * If the store uses in-line keys and key is specified a \"DataError\" DOMException will be thrown.\n     *\n     * If put() is used, any existing record with the key will be replaced. If add() is used, and if a record with the key already exists the request will fail, with request's error set to a \"ConstraintError\" DOMException.\n     *\n     * If successful, request's result will be the record's key.\n     */\n    add(value: any, key?: IDBValidKey): IDBRequest<IDBValidKey>;\n    /**\n     * Deletes all records in store.\n     *\n     * If successful, request's result will be undefined.\n     */\n    clear(): IDBRequest<undefined>;\n    /**\n     * Retrieves the number of records matching the given key or key range in query.\n     *\n     * If successful, request's result will be the count.\n     */\n    count(query?: IDBValidKey | IDBKeyRange): IDBRequest<number>;\n    /**\n     * Creates a new index in store with the given name, keyPath and options and returns a new IDBIndex. If the keyPath and options define constraints that cannot be satisfied with the data already in store the upgrade transaction will abort with a \"ConstraintError\" DOMException.\n     *\n     * Throws an \"InvalidStateError\" DOMException if not called within an upgrade transaction.\n     */\n    createIndex(name: string, keyPath: string | string[], options?: IDBIndexParameters): IDBIndex;\n    /**\n     * Deletes records in store with the given key or in the given key range in query.\n     *\n     * If successful, request's result will be undefined.\n     */\n    delete(query: IDBValidKey | IDBKeyRange): IDBRequest<undefined>;\n    /**\n     * Deletes the index in store with the given name.\n     *\n     * Throws an \"InvalidStateError\" DOMException if not called within an upgrade transaction.\n     */\n    deleteIndex(name: string): void;\n    /**\n     * Retrieves the value of the first record matching the given key or key range in query.\n     *\n     * If successful, request's result will be the value, or undefined if there was no matching record.\n     */\n    get(query: IDBValidKey | IDBKeyRange): IDBRequest<any>;\n    /**\n     * Retrieves the values of the records matching the given key or key range in query (up to count if given).\n     *\n     * If successful, request's result will be an Array of the values.\n     */\n    getAll(query?: IDBValidKey | IDBKeyRange | null, count?: number): IDBRequest<any[]>;\n    /**\n     * Retrieves the keys of records matching the given key or key range in query (up to count if given).\n     *\n     * If successful, request's result will be an Array of the keys.\n     */\n    getAllKeys(query?: IDBValidKey | IDBKeyRange | null, count?: number): IDBRequest<IDBValidKey[]>;\n    /**\n     * Retrieves the key of the first record matching the given key or key range in query.\n     *\n     * If successful, request's result will be the key, or undefined if there was no matching record.\n     */\n    getKey(query: IDBValidKey | IDBKeyRange): IDBRequest<IDBValidKey | undefined>;\n    index(name: string): IDBIndex;\n    /**\n     * Opens a cursor over the records matching query, ordered by direction. If query is null, all records in store are matched.\n     *\n     * If successful, request's result will be an IDBCursorWithValue pointing at the first matching record, or null if there were no matching records.\n     */\n    openCursor(query?: IDBValidKey | IDBKeyRange | null, direction?: IDBCursorDirection): IDBRequest<IDBCursorWithValue | null>;\n    /**\n     * Opens a cursor with key only flag set over the records matching query, ordered by direction. If query is null, all records in store are matched.\n     *\n     * If successful, request's result will be an IDBCursor pointing at the first matching record, or null if there were no matching records.\n     */\n    openKeyCursor(query?: IDBValidKey | IDBKeyRange | null, direction?: IDBCursorDirection): IDBRequest<IDBCursor | null>;\n    /**\n     * Adds or updates a record in store with the given value and key.\n     *\n     * If the store uses in-line keys and key is specified a \"DataError\" DOMException will be thrown.\n     *\n     * If put() is used, any existing record with the key will be replaced. If add() is used, and if a record with the key already exists the request will fail, with request's error set to a \"ConstraintError\" DOMException.\n     *\n     * If successful, request's result will be the record's key.\n     */\n    put(value: any, key?: IDBValidKey): IDBRequest<IDBValidKey>;\n}\n\ndeclare var IDBObjectStore: {\n    prototype: IDBObjectStore;\n    new(): IDBObjectStore;\n};\n\ninterface IDBOpenDBRequestEventMap extends IDBRequestEventMap {\n    \"blocked\": IDBVersionChangeEvent;\n    \"upgradeneeded\": IDBVersionChangeEvent;\n}\n\n/** Also inherits methods from its parents IDBRequest and EventTarget. */\ninterface IDBOpenDBRequest extends IDBRequest<IDBDatabase> {\n    onblocked: ((this: IDBOpenDBRequest, ev: IDBVersionChangeEvent) => any) | null;\n    onupgradeneeded: ((this: IDBOpenDBRequest, ev: IDBVersionChangeEvent) => any) | null;\n    addEventListener<K extends keyof IDBOpenDBRequestEventMap>(type: K, listener: (this: IDBOpenDBRequest, ev: IDBOpenDBRequestEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof IDBOpenDBRequestEventMap>(type: K, listener: (this: IDBOpenDBRequest, ev: IDBOpenDBRequestEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var IDBOpenDBRequest: {\n    prototype: IDBOpenDBRequest;\n    new(): IDBOpenDBRequest;\n};\n\ninterface IDBRequestEventMap {\n    \"error\": Event;\n    \"success\": Event;\n}\n\n/** The request object does not initially contain any information about the result of the operation, but once information becomes available, an event is fired on the request, and the information becomes available through the properties of the IDBRequest instance. */\ninterface IDBRequest<T = any> extends EventTarget {\n    /** When a request is completed, returns the error (a DOMException), or null if the request succeeded. Throws a \"InvalidStateError\" DOMException if the request is still pending. */\n    readonly error: DOMException | null;\n    onerror: ((this: IDBRequest<T>, ev: Event) => any) | null;\n    onsuccess: ((this: IDBRequest<T>, ev: Event) => any) | null;\n    /** Returns \"pending\" until a request is complete, then returns \"done\". */\n    readonly readyState: IDBRequestReadyState;\n    /** When a request is completed, returns the result, or undefined if the request failed. Throws a \"InvalidStateError\" DOMException if the request is still pending. */\n    readonly result: T;\n    /** Returns the IDBObjectStore, IDBIndex, or IDBCursor the request was made against, or null if is was an open request. */\n    readonly source: IDBObjectStore | IDBIndex | IDBCursor;\n    /** Returns the IDBTransaction the request was made within. If this as an open request, then it returns an upgrade transaction while it is running, or null otherwise. */\n    readonly transaction: IDBTransaction | null;\n    addEventListener<K extends keyof IDBRequestEventMap>(type: K, listener: (this: IDBRequest<T>, ev: IDBRequestEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof IDBRequestEventMap>(type: K, listener: (this: IDBRequest<T>, ev: IDBRequestEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var IDBRequest: {\n    prototype: IDBRequest;\n    new(): IDBRequest;\n};\n\ninterface IDBTransactionEventMap {\n    \"abort\": Event;\n    \"complete\": Event;\n    \"error\": Event;\n}\n\ninterface IDBTransaction extends EventTarget {\n    /** Returns the transaction's connection. */\n    readonly db: IDBDatabase;\n    readonly durability: IDBTransactionDurability;\n    /** If the transaction was aborted, returns the error (a DOMException) providing the reason. */\n    readonly error: DOMException | null;\n    /** Returns the mode the transaction was created with (\"readonly\" or \"readwrite\"), or \"versionchange\" for an upgrade transaction. */\n    readonly mode: IDBTransactionMode;\n    /** Returns a list of the names of object stores in the transaction's scope. For an upgrade transaction this is all object stores in the database. */\n    readonly objectStoreNames: DOMStringList;\n    onabort: ((this: IDBTransaction, ev: Event) => any) | null;\n    oncomplete: ((this: IDBTransaction, ev: Event) => any) | null;\n    onerror: ((this: IDBTransaction, ev: Event) => any) | null;\n    /** Aborts the transaction. All pending requests will fail with a \"AbortError\" DOMException and all changes made to the database will be reverted. */\n    abort(): void;\n    commit(): void;\n    /** Returns an IDBObjectStore in the transaction's scope. */\n    objectStore(name: string): IDBObjectStore;\n    addEventListener<K extends keyof IDBTransactionEventMap>(type: K, listener: (this: IDBTransaction, ev: IDBTransactionEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof IDBTransactionEventMap>(type: K, listener: (this: IDBTransaction, ev: IDBTransactionEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var IDBTransaction: {\n    prototype: IDBTransaction;\n    new(): IDBTransaction;\n};\n\n/** This IndexedDB API interface indicates that the version of the database has changed, as the result of an IDBOpenDBRequest.onupgradeneeded event handler function. */\ninterface IDBVersionChangeEvent extends Event {\n    readonly newVersion: number | null;\n    readonly oldVersion: number;\n}\n\ndeclare var IDBVersionChangeEvent: {\n    prototype: IDBVersionChangeEvent;\n    new(type: string, eventInitDict?: IDBVersionChangeEventInit): IDBVersionChangeEvent;\n};\n\n/** The IIRFilterNode interface of the Web Audio API is a AudioNode processor which implements a general infinite impulse response (IIR)  filter; this type of filter can be used to implement tone control devices and graphic equalizers as well. It lets the parameters of the filter response be specified, so that it can be tuned as needed. */\ninterface IIRFilterNode extends AudioNode {\n    getFrequencyResponse(frequencyHz: Float32Array, magResponse: Float32Array, phaseResponse: Float32Array): void;\n}\n\ndeclare var IIRFilterNode: {\n    prototype: IIRFilterNode;\n    new(context: BaseAudioContext, options: IIRFilterOptions): IIRFilterNode;\n};\n\ninterface IdleDeadline {\n    readonly didTimeout: boolean;\n    timeRemaining(): DOMHighResTimeStamp;\n}\n\ndeclare var IdleDeadline: {\n    prototype: IdleDeadline;\n    new(): IdleDeadline;\n};\n\ninterface ImageBitmap {\n    /** Returns the intrinsic height of the image, in CSS pixels. */\n    readonly height: number;\n    /** Returns the intrinsic width of the image, in CSS pixels. */\n    readonly width: number;\n    /** Releases imageBitmap's underlying bitmap data. */\n    close(): void;\n}\n\ndeclare var ImageBitmap: {\n    prototype: ImageBitmap;\n    new(): ImageBitmap;\n};\n\ninterface ImageBitmapRenderingContext {\n    /** Returns the canvas element that the context is bound to. */\n    readonly canvas: HTMLCanvasElement | OffscreenCanvas;\n    /** Transfers the underlying bitmap data from imageBitmap to context, and the bitmap becomes the contents of the canvas element to which context is bound. */\n    transferFromImageBitmap(bitmap: ImageBitmap | null): void;\n}\n\ndeclare var ImageBitmapRenderingContext: {\n    prototype: ImageBitmapRenderingContext;\n    new(): ImageBitmapRenderingContext;\n};\n\n/** The underlying pixel data of an area of a <canvas> element. It is created using the ImageData() constructor or creator methods on the CanvasRenderingContext2D object associated with a canvas: createImageData() and getImageData(). It can also be used to set a part of the canvas by using putImageData(). */\ninterface ImageData {\n    readonly colorSpace: PredefinedColorSpace;\n    /** Returns the one-dimensional array containing the data in RGBA order, as integers in the range 0 to 255. */\n    readonly data: Uint8ClampedArray;\n    /** Returns the actual dimensions of the data in the ImageData object, in pixels. */\n    readonly height: number;\n    /** Returns the actual dimensions of the data in the ImageData object, in pixels. */\n    readonly width: number;\n}\n\ndeclare var ImageData: {\n    prototype: ImageData;\n    new(sw: number, sh: number, settings?: ImageDataSettings): ImageData;\n    new(data: Uint8ClampedArray, sw: number, sh?: number, settings?: ImageDataSettings): ImageData;\n};\n\ninterface InnerHTML {\n    innerHTML: string;\n}\n\n/** Available only in secure contexts. */\ninterface InputDeviceInfo extends MediaDeviceInfo {\n}\n\ndeclare var InputDeviceInfo: {\n    prototype: InputDeviceInfo;\n    new(): InputDeviceInfo;\n};\n\ninterface InputEvent extends UIEvent {\n    readonly data: string | null;\n    readonly dataTransfer: DataTransfer | null;\n    readonly inputType: string;\n    readonly isComposing: boolean;\n    getTargetRanges(): StaticRange[];\n}\n\ndeclare var InputEvent: {\n    prototype: InputEvent;\n    new(type: string, eventInitDict?: InputEventInit): InputEvent;\n};\n\n/** provides a way to asynchronously observe changes in the intersection of a target element with an ancestor element or with a top-level document's viewport. */\ninterface IntersectionObserver {\n    readonly root: Element | Document | null;\n    readonly rootMargin: string;\n    readonly thresholds: ReadonlyArray<number>;\n    disconnect(): void;\n    observe(target: Element): void;\n    takeRecords(): IntersectionObserverEntry[];\n    unobserve(target: Element): void;\n}\n\ndeclare var IntersectionObserver: {\n    prototype: IntersectionObserver;\n    new(callback: IntersectionObserverCallback, options?: IntersectionObserverInit): IntersectionObserver;\n};\n\n/** This Intersection Observer API interface describes the intersection between the target element and its root container at a specific moment of transition. */\ninterface IntersectionObserverEntry {\n    readonly boundingClientRect: DOMRectReadOnly;\n    readonly intersectionRatio: number;\n    readonly intersectionRect: DOMRectReadOnly;\n    readonly isIntersecting: boolean;\n    readonly rootBounds: DOMRectReadOnly | null;\n    readonly target: Element;\n    readonly time: DOMHighResTimeStamp;\n}\n\ndeclare var IntersectionObserverEntry: {\n    prototype: IntersectionObserverEntry;\n    new(intersectionObserverEntryInit: IntersectionObserverEntryInit): IntersectionObserverEntry;\n};\n\ninterface KHR_parallel_shader_compile {\n    readonly COMPLETION_STATUS_KHR: 0x91B1;\n}\n\n/** KeyboardEvent objects describe a user interaction with the keyboard; each event describes a single interaction between the user and a key (or combination of a key with modifier keys) on the keyboard. */\ninterface KeyboardEvent extends UIEvent {\n    readonly altKey: boolean;\n    /** @deprecated */\n    readonly charCode: number;\n    readonly code: string;\n    readonly ctrlKey: boolean;\n    readonly isComposing: boolean;\n    readonly key: string;\n    /** @deprecated */\n    readonly keyCode: number;\n    readonly location: number;\n    readonly metaKey: boolean;\n    readonly repeat: boolean;\n    readonly shiftKey: boolean;\n    getModifierState(keyArg: string): boolean;\n    /** @deprecated */\n    initKeyboardEvent(typeArg: string, bubblesArg?: boolean, cancelableArg?: boolean, viewArg?: Window | null, keyArg?: string, locationArg?: number, ctrlKey?: boolean, altKey?: boolean, shiftKey?: boolean, metaKey?: boolean): void;\n    readonly DOM_KEY_LOCATION_STANDARD: 0x00;\n    readonly DOM_KEY_LOCATION_LEFT: 0x01;\n    readonly DOM_KEY_LOCATION_RIGHT: 0x02;\n    readonly DOM_KEY_LOCATION_NUMPAD: 0x03;\n}\n\ndeclare var KeyboardEvent: {\n    prototype: KeyboardEvent;\n    new(type: string, eventInitDict?: KeyboardEventInit): KeyboardEvent;\n    readonly DOM_KEY_LOCATION_STANDARD: 0x00;\n    readonly DOM_KEY_LOCATION_LEFT: 0x01;\n    readonly DOM_KEY_LOCATION_RIGHT: 0x02;\n    readonly DOM_KEY_LOCATION_NUMPAD: 0x03;\n};\n\ninterface KeyframeEffect extends AnimationEffect {\n    composite: CompositeOperation;\n    iterationComposite: IterationCompositeOperation;\n    pseudoElement: string | null;\n    target: Element | null;\n    getKeyframes(): ComputedKeyframe[];\n    setKeyframes(keyframes: Keyframe[] | PropertyIndexedKeyframes | null): void;\n}\n\ndeclare var KeyframeEffect: {\n    prototype: KeyframeEffect;\n    new(target: Element | null, keyframes: Keyframe[] | PropertyIndexedKeyframes | null, options?: number | KeyframeEffectOptions): KeyframeEffect;\n    new(source: KeyframeEffect): KeyframeEffect;\n};\n\ninterface LinkStyle {\n    readonly sheet: CSSStyleSheet | null;\n}\n\n/** The location (URL) of the object it is linked to. Changes done on it are reflected on the object it relates to. Both the Document and Window interface have such a linked Location, accessible via Document.location and Window.location respectively. */\ninterface Location {\n    /** Returns a DOMStringList object listing the origins of the ancestor browsing contexts, from the parent browsing context to the top-level browsing context. */\n    readonly ancestorOrigins: DOMStringList;\n    /**\n     * Returns the Location object's URL's fragment (includes leading \"#\" if non-empty).\n     *\n     * Can be set, to navigate to the same URL with a changed fragment (ignores leading \"#\").\n     */\n    hash: string;\n    /**\n     * Returns the Location object's URL's host and port (if different from the default port for the scheme).\n     *\n     * Can be set, to navigate to the same URL with a changed host and port.\n     */\n    host: string;\n    /**\n     * Returns the Location object's URL's host.\n     *\n     * Can be set, to navigate to the same URL with a changed host.\n     */\n    hostname: string;\n    /**\n     * Returns the Location object's URL.\n     *\n     * Can be set, to navigate to the given URL.\n     */\n    href: string;\n    toString(): string;\n    /** Returns the Location object's URL's origin. */\n    readonly origin: string;\n    /**\n     * Returns the Location object's URL's path.\n     *\n     * Can be set, to navigate to the same URL with a changed path.\n     */\n    pathname: string;\n    /**\n     * Returns the Location object's URL's port.\n     *\n     * Can be set, to navigate to the same URL with a changed port.\n     */\n    port: string;\n    /**\n     * Returns the Location object's URL's scheme.\n     *\n     * Can be set, to navigate to the same URL with a changed scheme.\n     */\n    protocol: string;\n    /**\n     * Returns the Location object's URL's query (includes leading \"?\" if non-empty).\n     *\n     * Can be set, to navigate to the same URL with a changed query (ignores leading \"?\").\n     */\n    search: string;\n    /** Navigates to the given URL. */\n    assign(url: string | URL): void;\n    /** Reloads the current page. */\n    reload(): void;\n    /** Removes the current page from the session history and navigates to the given URL. */\n    replace(url: string | URL): void;\n}\n\ndeclare var Location: {\n    prototype: Location;\n    new(): Location;\n};\n\n/** Available only in secure contexts. */\ninterface Lock {\n    readonly mode: LockMode;\n    readonly name: string;\n}\n\ndeclare var Lock: {\n    prototype: Lock;\n    new(): Lock;\n};\n\n/** Available only in secure contexts. */\ninterface LockManager {\n    query(): Promise<LockManagerSnapshot>;\n    request(name: string, callback: LockGrantedCallback): Promise<any>;\n    request(name: string, options: LockOptions, callback: LockGrantedCallback): Promise<any>;\n}\n\ndeclare var LockManager: {\n    prototype: LockManager;\n    new(): LockManager;\n};\n\ninterface MIDIAccessEventMap {\n    \"statechange\": Event;\n}\n\n/** Available only in secure contexts. */\ninterface MIDIAccess extends EventTarget {\n    readonly inputs: MIDIInputMap;\n    onstatechange: ((this: MIDIAccess, ev: Event) => any) | null;\n    readonly outputs: MIDIOutputMap;\n    readonly sysexEnabled: boolean;\n    addEventListener<K extends keyof MIDIAccessEventMap>(type: K, listener: (this: MIDIAccess, ev: MIDIAccessEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof MIDIAccessEventMap>(type: K, listener: (this: MIDIAccess, ev: MIDIAccessEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var MIDIAccess: {\n    prototype: MIDIAccess;\n    new(): MIDIAccess;\n};\n\n/** Available only in secure contexts. */\ninterface MIDIConnectionEvent extends Event {\n    readonly port: MIDIPort;\n}\n\ndeclare var MIDIConnectionEvent: {\n    prototype: MIDIConnectionEvent;\n    new(type: string, eventInitDict?: MIDIConnectionEventInit): MIDIConnectionEvent;\n};\n\ninterface MIDIInputEventMap extends MIDIPortEventMap {\n    \"midimessage\": Event;\n}\n\n/** Available only in secure contexts. */\ninterface MIDIInput extends MIDIPort {\n    onmidimessage: ((this: MIDIInput, ev: Event) => any) | null;\n    addEventListener<K extends keyof MIDIInputEventMap>(type: K, listener: (this: MIDIInput, ev: MIDIInputEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof MIDIInputEventMap>(type: K, listener: (this: MIDIInput, ev: MIDIInputEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var MIDIInput: {\n    prototype: MIDIInput;\n    new(): MIDIInput;\n};\n\n/** Available only in secure contexts. */\ninterface MIDIInputMap {\n    forEach(callbackfn: (value: MIDIInput, key: string, parent: MIDIInputMap) => void, thisArg?: any): void;\n}\n\ndeclare var MIDIInputMap: {\n    prototype: MIDIInputMap;\n    new(): MIDIInputMap;\n};\n\n/** Available only in secure contexts. */\ninterface MIDIMessageEvent extends Event {\n    readonly data: Uint8Array;\n}\n\ndeclare var MIDIMessageEvent: {\n    prototype: MIDIMessageEvent;\n    new(type: string, eventInitDict?: MIDIMessageEventInit): MIDIMessageEvent;\n};\n\n/** Available only in secure contexts. */\ninterface MIDIOutput extends MIDIPort {\n    send(data: number[], timestamp?: DOMHighResTimeStamp): void;\n    addEventListener<K extends keyof MIDIPortEventMap>(type: K, listener: (this: MIDIOutput, ev: MIDIPortEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof MIDIPortEventMap>(type: K, listener: (this: MIDIOutput, ev: MIDIPortEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var MIDIOutput: {\n    prototype: MIDIOutput;\n    new(): MIDIOutput;\n};\n\n/** Available only in secure contexts. */\ninterface MIDIOutputMap {\n    forEach(callbackfn: (value: MIDIOutput, key: string, parent: MIDIOutputMap) => void, thisArg?: any): void;\n}\n\ndeclare var MIDIOutputMap: {\n    prototype: MIDIOutputMap;\n    new(): MIDIOutputMap;\n};\n\ninterface MIDIPortEventMap {\n    \"statechange\": Event;\n}\n\n/** Available only in secure contexts. */\ninterface MIDIPort extends EventTarget {\n    readonly connection: MIDIPortConnectionState;\n    readonly id: string;\n    readonly manufacturer: string | null;\n    readonly name: string | null;\n    onstatechange: ((this: MIDIPort, ev: Event) => any) | null;\n    readonly state: MIDIPortDeviceState;\n    readonly type: MIDIPortType;\n    readonly version: string | null;\n    close(): Promise<MIDIPort>;\n    open(): Promise<MIDIPort>;\n    addEventListener<K extends keyof MIDIPortEventMap>(type: K, listener: (this: MIDIPort, ev: MIDIPortEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof MIDIPortEventMap>(type: K, listener: (this: MIDIPort, ev: MIDIPortEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var MIDIPort: {\n    prototype: MIDIPort;\n    new(): MIDIPort;\n};\n\ninterface MathMLElementEventMap extends ElementEventMap, GlobalEventHandlersEventMap {\n}\n\ninterface MathMLElement extends Element, ElementCSSInlineStyle, GlobalEventHandlers, HTMLOrSVGElement {\n    addEventListener<K extends keyof MathMLElementEventMap>(type: K, listener: (this: MathMLElement, ev: MathMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof MathMLElementEventMap>(type: K, listener: (this: MathMLElement, ev: MathMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var MathMLElement: {\n    prototype: MathMLElement;\n    new(): MathMLElement;\n};\n\ninterface MediaCapabilities {\n    decodingInfo(configuration: MediaDecodingConfiguration): Promise<MediaCapabilitiesDecodingInfo>;\n    encodingInfo(configuration: MediaEncodingConfiguration): Promise<MediaCapabilitiesEncodingInfo>;\n}\n\ndeclare var MediaCapabilities: {\n    prototype: MediaCapabilities;\n    new(): MediaCapabilities;\n};\n\n/**\n * The MediaDevicesInfo interface contains information that describes a single media input or output device.\n * Available only in secure contexts.\n */\ninterface MediaDeviceInfo {\n    readonly deviceId: string;\n    readonly groupId: string;\n    readonly kind: MediaDeviceKind;\n    readonly label: string;\n    toJSON(): any;\n}\n\ndeclare var MediaDeviceInfo: {\n    prototype: MediaDeviceInfo;\n    new(): MediaDeviceInfo;\n};\n\ninterface MediaDevicesEventMap {\n    \"devicechange\": Event;\n}\n\n/**\n * Provides access to connected media input devices like cameras and microphones, as well as screen sharing. In essence, it lets you obtain access to any hardware source of media data.\n * Available only in secure contexts.\n */\ninterface MediaDevices extends EventTarget {\n    ondevicechange: ((this: MediaDevices, ev: Event) => any) | null;\n    enumerateDevices(): Promise<MediaDeviceInfo[]>;\n    getDisplayMedia(options?: DisplayMediaStreamOptions): Promise<MediaStream>;\n    getSupportedConstraints(): MediaTrackSupportedConstraints;\n    getUserMedia(constraints?: MediaStreamConstraints): Promise<MediaStream>;\n    addEventListener<K extends keyof MediaDevicesEventMap>(type: K, listener: (this: MediaDevices, ev: MediaDevicesEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof MediaDevicesEventMap>(type: K, listener: (this: MediaDevices, ev: MediaDevicesEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var MediaDevices: {\n    prototype: MediaDevices;\n    new(): MediaDevices;\n};\n\n/** A MediaElementSourceNode has no inputs and exactly one output, and is created using the AudioContext.createMediaElementSource method. The amount of channels in the output equals the number of channels of the audio referenced by the HTMLMediaElement used in the creation of the node, or is 1 if the HTMLMediaElement has no audio. */\ninterface MediaElementAudioSourceNode extends AudioNode {\n    readonly mediaElement: HTMLMediaElement;\n}\n\ndeclare var MediaElementAudioSourceNode: {\n    prototype: MediaElementAudioSourceNode;\n    new(context: AudioContext, options: MediaElementAudioSourceOptions): MediaElementAudioSourceNode;\n};\n\ninterface MediaEncryptedEvent extends Event {\n    readonly initData: ArrayBuffer | null;\n    readonly initDataType: string;\n}\n\ndeclare var MediaEncryptedEvent: {\n    prototype: MediaEncryptedEvent;\n    new(type: string, eventInitDict?: MediaEncryptedEventInit): MediaEncryptedEvent;\n};\n\n/** An error which occurred while handling media in an HTML media element based on HTMLMediaElement, such as <audio> or <video>. */\ninterface MediaError {\n    readonly code: number;\n    readonly message: string;\n    readonly MEDIA_ERR_ABORTED: 1;\n    readonly MEDIA_ERR_NETWORK: 2;\n    readonly MEDIA_ERR_DECODE: 3;\n    readonly MEDIA_ERR_SRC_NOT_SUPPORTED: 4;\n}\n\ndeclare var MediaError: {\n    prototype: MediaError;\n    new(): MediaError;\n    readonly MEDIA_ERR_ABORTED: 1;\n    readonly MEDIA_ERR_NETWORK: 2;\n    readonly MEDIA_ERR_DECODE: 3;\n    readonly MEDIA_ERR_SRC_NOT_SUPPORTED: 4;\n};\n\n/**\n * This EncryptedMediaExtensions API interface contains the content and related data when the content decryption module generates a message for the session.\n * Available only in secure contexts.\n */\ninterface MediaKeyMessageEvent extends Event {\n    readonly message: ArrayBuffer;\n    readonly messageType: MediaKeyMessageType;\n}\n\ndeclare var MediaKeyMessageEvent: {\n    prototype: MediaKeyMessageEvent;\n    new(type: string, eventInitDict: MediaKeyMessageEventInit): MediaKeyMessageEvent;\n};\n\ninterface MediaKeySessionEventMap {\n    \"keystatuseschange\": Event;\n    \"message\": MediaKeyMessageEvent;\n}\n\n/**\n * This EncryptedMediaExtensions API interface represents a context for message exchange with a content decryption module (CDM).\n * Available only in secure contexts.\n */\ninterface MediaKeySession extends EventTarget {\n    readonly closed: Promise<MediaKeySessionClosedReason>;\n    readonly expiration: number;\n    readonly keyStatuses: MediaKeyStatusMap;\n    onkeystatuseschange: ((this: MediaKeySession, ev: Event) => any) | null;\n    onmessage: ((this: MediaKeySession, ev: MediaKeyMessageEvent) => any) | null;\n    readonly sessionId: string;\n    close(): Promise<void>;\n    generateRequest(initDataType: string, initData: BufferSource): Promise<void>;\n    load(sessionId: string): Promise<boolean>;\n    remove(): Promise<void>;\n    update(response: BufferSource): Promise<void>;\n    addEventListener<K extends keyof MediaKeySessionEventMap>(type: K, listener: (this: MediaKeySession, ev: MediaKeySessionEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof MediaKeySessionEventMap>(type: K, listener: (this: MediaKeySession, ev: MediaKeySessionEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var MediaKeySession: {\n    prototype: MediaKeySession;\n    new(): MediaKeySession;\n};\n\n/**\n * This EncryptedMediaExtensions API interface is a read-only map of media key statuses by key IDs.\n * Available only in secure contexts.\n */\ninterface MediaKeyStatusMap {\n    readonly size: number;\n    get(keyId: BufferSource): MediaKeyStatus | undefined;\n    has(keyId: BufferSource): boolean;\n    forEach(callbackfn: (value: MediaKeyStatus, key: BufferSource, parent: MediaKeyStatusMap) => void, thisArg?: any): void;\n}\n\ndeclare var MediaKeyStatusMap: {\n    prototype: MediaKeyStatusMap;\n    new(): MediaKeyStatusMap;\n};\n\n/**\n * This EncryptedMediaExtensions API interface provides access to a Key System for decryption and/or a content protection provider. You can request an instance of this object using the Navigator.requestMediaKeySystemAccess method.\n * Available only in secure contexts.\n */\ninterface MediaKeySystemAccess {\n    readonly keySystem: string;\n    createMediaKeys(): Promise<MediaKeys>;\n    getConfiguration(): MediaKeySystemConfiguration;\n}\n\ndeclare var MediaKeySystemAccess: {\n    prototype: MediaKeySystemAccess;\n    new(): MediaKeySystemAccess;\n};\n\n/**\n * This EncryptedMediaExtensions API interface the represents a set of keys that an associated HTMLMediaElement can use for decryption of media data during playback.\n * Available only in secure contexts.\n */\ninterface MediaKeys {\n    createSession(sessionType?: MediaKeySessionType): MediaKeySession;\n    setServerCertificate(serverCertificate: BufferSource): Promise<boolean>;\n}\n\ndeclare var MediaKeys: {\n    prototype: MediaKeys;\n    new(): MediaKeys;\n};\n\ninterface MediaList {\n    readonly length: number;\n    mediaText: string;\n    toString(): string;\n    appendMedium(medium: string): void;\n    deleteMedium(medium: string): void;\n    item(index: number): string | null;\n    [index: number]: string;\n}\n\ndeclare var MediaList: {\n    prototype: MediaList;\n    new(): MediaList;\n};\n\ninterface MediaMetadata {\n    album: string;\n    artist: string;\n    artwork: ReadonlyArray<MediaImage>;\n    title: string;\n}\n\ndeclare var MediaMetadata: {\n    prototype: MediaMetadata;\n    new(init?: MediaMetadataInit): MediaMetadata;\n};\n\ninterface MediaQueryListEventMap {\n    \"change\": MediaQueryListEvent;\n}\n\n/** Stores information on a media query applied to a document, and handles sending notifications to listeners when the media query state change (i.e. when the media query test starts or stops evaluating to true). */\ninterface MediaQueryList extends EventTarget {\n    readonly matches: boolean;\n    readonly media: string;\n    onchange: ((this: MediaQueryList, ev: MediaQueryListEvent) => any) | null;\n    /** @deprecated */\n    addListener(callback: ((this: MediaQueryList, ev: MediaQueryListEvent) => any) | null): void;\n    /** @deprecated */\n    removeListener(callback: ((this: MediaQueryList, ev: MediaQueryListEvent) => any) | null): void;\n    addEventListener<K extends keyof MediaQueryListEventMap>(type: K, listener: (this: MediaQueryList, ev: MediaQueryListEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof MediaQueryListEventMap>(type: K, listener: (this: MediaQueryList, ev: MediaQueryListEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var MediaQueryList: {\n    prototype: MediaQueryList;\n    new(): MediaQueryList;\n};\n\ninterface MediaQueryListEvent extends Event {\n    readonly matches: boolean;\n    readonly media: string;\n}\n\ndeclare var MediaQueryListEvent: {\n    prototype: MediaQueryListEvent;\n    new(type: string, eventInitDict?: MediaQueryListEventInit): MediaQueryListEvent;\n};\n\ninterface MediaRecorderEventMap {\n    \"dataavailable\": BlobEvent;\n    \"error\": Event;\n    \"pause\": Event;\n    \"resume\": Event;\n    \"start\": Event;\n    \"stop\": Event;\n}\n\ninterface MediaRecorder extends EventTarget {\n    readonly audioBitsPerSecond: number;\n    readonly mimeType: string;\n    ondataavailable: ((this: MediaRecorder, ev: BlobEvent) => any) | null;\n    onerror: ((this: MediaRecorder, ev: Event) => any) | null;\n    onpause: ((this: MediaRecorder, ev: Event) => any) | null;\n    onresume: ((this: MediaRecorder, ev: Event) => any) | null;\n    onstart: ((this: MediaRecorder, ev: Event) => any) | null;\n    onstop: ((this: MediaRecorder, ev: Event) => any) | null;\n    readonly state: RecordingState;\n    readonly stream: MediaStream;\n    readonly videoBitsPerSecond: number;\n    pause(): void;\n    requestData(): void;\n    resume(): void;\n    start(timeslice?: number): void;\n    stop(): void;\n    addEventListener<K extends keyof MediaRecorderEventMap>(type: K, listener: (this: MediaRecorder, ev: MediaRecorderEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof MediaRecorderEventMap>(type: K, listener: (this: MediaRecorder, ev: MediaRecorderEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var MediaRecorder: {\n    prototype: MediaRecorder;\n    new(stream: MediaStream, options?: MediaRecorderOptions): MediaRecorder;\n    isTypeSupported(type: string): boolean;\n};\n\ninterface MediaSession {\n    metadata: MediaMetadata | null;\n    playbackState: MediaSessionPlaybackState;\n    setActionHandler(action: MediaSessionAction, handler: MediaSessionActionHandler | null): void;\n    setPositionState(state?: MediaPositionState): void;\n}\n\ndeclare var MediaSession: {\n    prototype: MediaSession;\n    new(): MediaSession;\n};\n\ninterface MediaSourceEventMap {\n    \"sourceclose\": Event;\n    \"sourceended\": Event;\n    \"sourceopen\": Event;\n}\n\n/** This Media Source Extensions API interface represents a source of media data for an HTMLMediaElement object. A MediaSource object can be attached to a HTMLMediaElement to be played in the user agent. */\ninterface MediaSource extends EventTarget {\n    readonly activeSourceBuffers: SourceBufferList;\n    duration: number;\n    onsourceclose: ((this: MediaSource, ev: Event) => any) | null;\n    onsourceended: ((this: MediaSource, ev: Event) => any) | null;\n    onsourceopen: ((this: MediaSource, ev: Event) => any) | null;\n    readonly readyState: ReadyState;\n    readonly sourceBuffers: SourceBufferList;\n    addSourceBuffer(type: string): SourceBuffer;\n    clearLiveSeekableRange(): void;\n    endOfStream(error?: EndOfStreamError): void;\n    removeSourceBuffer(sourceBuffer: SourceBuffer): void;\n    setLiveSeekableRange(start: number, end: number): void;\n    addEventListener<K extends keyof MediaSourceEventMap>(type: K, listener: (this: MediaSource, ev: MediaSourceEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof MediaSourceEventMap>(type: K, listener: (this: MediaSource, ev: MediaSourceEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var MediaSource: {\n    prototype: MediaSource;\n    new(): MediaSource;\n    isTypeSupported(type: string): boolean;\n};\n\ninterface MediaStreamEventMap {\n    \"addtrack\": MediaStreamTrackEvent;\n    \"removetrack\": MediaStreamTrackEvent;\n}\n\n/** A stream of media content. A stream consists of several tracks such as video or audio tracks. Each track is specified as an instance of MediaStreamTrack. */\ninterface MediaStream extends EventTarget {\n    readonly active: boolean;\n    readonly id: string;\n    onaddtrack: ((this: MediaStream, ev: MediaStreamTrackEvent) => any) | null;\n    onremovetrack: ((this: MediaStream, ev: MediaStreamTrackEvent) => any) | null;\n    addTrack(track: MediaStreamTrack): void;\n    clone(): MediaStream;\n    getAudioTracks(): MediaStreamTrack[];\n    getTrackById(trackId: string): MediaStreamTrack | null;\n    getTracks(): MediaStreamTrack[];\n    getVideoTracks(): MediaStreamTrack[];\n    removeTrack(track: MediaStreamTrack): void;\n    addEventListener<K extends keyof MediaStreamEventMap>(type: K, listener: (this: MediaStream, ev: MediaStreamEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof MediaStreamEventMap>(type: K, listener: (this: MediaStream, ev: MediaStreamEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var MediaStream: {\n    prototype: MediaStream;\n    new(): MediaStream;\n    new(stream: MediaStream): MediaStream;\n    new(tracks: MediaStreamTrack[]): MediaStream;\n};\n\ninterface MediaStreamAudioDestinationNode extends AudioNode {\n    readonly stream: MediaStream;\n}\n\ndeclare var MediaStreamAudioDestinationNode: {\n    prototype: MediaStreamAudioDestinationNode;\n    new(context: AudioContext, options?: AudioNodeOptions): MediaStreamAudioDestinationNode;\n};\n\n/** A type of AudioNode which operates as an audio source whose media is received from a MediaStream obtained using the WebRTC or Media Capture and Streams APIs. */\ninterface MediaStreamAudioSourceNode extends AudioNode {\n    readonly mediaStream: MediaStream;\n}\n\ndeclare var MediaStreamAudioSourceNode: {\n    prototype: MediaStreamAudioSourceNode;\n    new(context: AudioContext, options: MediaStreamAudioSourceOptions): MediaStreamAudioSourceNode;\n};\n\ninterface MediaStreamTrackEventMap {\n    \"ended\": Event;\n    \"mute\": Event;\n    \"unmute\": Event;\n}\n\n/** A single media track within a stream; typically, these are audio or video tracks, but other track types may exist as well. */\ninterface MediaStreamTrack extends EventTarget {\n    contentHint: string;\n    enabled: boolean;\n    readonly id: string;\n    readonly kind: string;\n    readonly label: string;\n    readonly muted: boolean;\n    onended: ((this: MediaStreamTrack, ev: Event) => any) | null;\n    onmute: ((this: MediaStreamTrack, ev: Event) => any) | null;\n    onunmute: ((this: MediaStreamTrack, ev: Event) => any) | null;\n    readonly readyState: MediaStreamTrackState;\n    applyConstraints(constraints?: MediaTrackConstraints): Promise<void>;\n    clone(): MediaStreamTrack;\n    getCapabilities(): MediaTrackCapabilities;\n    getConstraints(): MediaTrackConstraints;\n    getSettings(): MediaTrackSettings;\n    stop(): void;\n    addEventListener<K extends keyof MediaStreamTrackEventMap>(type: K, listener: (this: MediaStreamTrack, ev: MediaStreamTrackEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof MediaStreamTrackEventMap>(type: K, listener: (this: MediaStreamTrack, ev: MediaStreamTrackEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var MediaStreamTrack: {\n    prototype: MediaStreamTrack;\n    new(): MediaStreamTrack;\n};\n\n/** Events which indicate that a MediaStream has had tracks added to or removed from the stream through calls to Media Stream API methods. These events are sent to the stream when these changes occur. */\ninterface MediaStreamTrackEvent extends Event {\n    readonly track: MediaStreamTrack;\n}\n\ndeclare var MediaStreamTrackEvent: {\n    prototype: MediaStreamTrackEvent;\n    new(type: string, eventInitDict: MediaStreamTrackEventInit): MediaStreamTrackEvent;\n};\n\n/** This Channel Messaging API interface allows us to create a new message channel and send data through it via its two MessagePort properties. */\ninterface MessageChannel {\n    /** Returns the first MessagePort object. */\n    readonly port1: MessagePort;\n    /** Returns the second MessagePort object. */\n    readonly port2: MessagePort;\n}\n\ndeclare var MessageChannel: {\n    prototype: MessageChannel;\n    new(): MessageChannel;\n};\n\n/** A message received by a target object. */\ninterface MessageEvent<T = any> extends Event {\n    /** Returns the data of the message. */\n    readonly data: T;\n    /** Returns the last event ID string, for server-sent events. */\n    readonly lastEventId: string;\n    /** Returns the origin of the message, for server-sent events and cross-document messaging. */\n    readonly origin: string;\n    /** Returns the MessagePort array sent with the message, for cross-document messaging and channel messaging. */\n    readonly ports: ReadonlyArray<MessagePort>;\n    /** Returns the WindowProxy of the source window, for cross-document messaging, and the MessagePort being attached, in the connect event fired at SharedWorkerGlobalScope objects. */\n    readonly source: MessageEventSource | null;\n    /** @deprecated */\n    initMessageEvent(type: string, bubbles?: boolean, cancelable?: boolean, data?: any, origin?: string, lastEventId?: string, source?: MessageEventSource | null, ports?: MessagePort[]): void;\n}\n\ndeclare var MessageEvent: {\n    prototype: MessageEvent;\n    new<T>(type: string, eventInitDict?: MessageEventInit<T>): MessageEvent<T>;\n};\n\ninterface MessagePortEventMap {\n    \"message\": MessageEvent;\n    \"messageerror\": MessageEvent;\n}\n\n/** This Channel Messaging API interface represents one of the two ports of a MessageChannel, allowing messages to be sent from one port and listening out for them arriving at the other. */\ninterface MessagePort extends EventTarget {\n    onmessage: ((this: MessagePort, ev: MessageEvent) => any) | null;\n    onmessageerror: ((this: MessagePort, ev: MessageEvent) => any) | null;\n    /** Disconnects the port, so that it is no longer active. */\n    close(): void;\n    /**\n     * Posts a message through the channel. Objects listed in transfer are transferred, not just cloned, meaning that they are no longer usable on the sending side.\n     *\n     * Throws a \"DataCloneError\" DOMException if transfer contains duplicate objects or port, or if message could not be cloned.\n     */\n    postMessage(message: any, transfer: Transferable[]): void;\n    postMessage(message: any, options?: StructuredSerializeOptions): void;\n    /** Begins dispatching messages received on the port. */\n    start(): void;\n    addEventListener<K extends keyof MessagePortEventMap>(type: K, listener: (this: MessagePort, ev: MessagePortEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof MessagePortEventMap>(type: K, listener: (this: MessagePort, ev: MessagePortEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var MessagePort: {\n    prototype: MessagePort;\n    new(): MessagePort;\n};\n\n/**\n * Provides contains information about a MIME type associated with a particular plugin. NavigatorPlugins.mimeTypes returns an array of this object.\n * @deprecated\n */\ninterface MimeType {\n    /**\n     * Returns the MIME type's description.\n     * @deprecated\n     */\n    readonly description: string;\n    /**\n     * Returns the Plugin object that implements this MIME type.\n     * @deprecated\n     */\n    readonly enabledPlugin: Plugin;\n    /**\n     * Returns the MIME type's typical file extensions, in a comma-separated list.\n     * @deprecated\n     */\n    readonly suffixes: string;\n    /**\n     * Returns the MIME type.\n     * @deprecated\n     */\n    readonly type: string;\n}\n\n/** @deprecated */\ndeclare var MimeType: {\n    prototype: MimeType;\n    new(): MimeType;\n};\n\n/**\n * Returns an array of MimeType instances, each of which contains information about a supported browser plugins. This object is returned by NavigatorPlugins.mimeTypes.\n * @deprecated\n */\ninterface MimeTypeArray {\n    /** @deprecated */\n    readonly length: number;\n    /** @deprecated */\n    item(index: number): MimeType | null;\n    /** @deprecated */\n    namedItem(name: string): MimeType | null;\n    [index: number]: MimeType;\n}\n\n/** @deprecated */\ndeclare var MimeTypeArray: {\n    prototype: MimeTypeArray;\n    new(): MimeTypeArray;\n};\n\n/** Events that occur due to the user interacting with a pointing device (such as a mouse). Common events using this interface include click, dblclick, mouseup, mousedown. */\ninterface MouseEvent extends UIEvent {\n    readonly altKey: boolean;\n    readonly button: number;\n    readonly buttons: number;\n    readonly clientX: number;\n    readonly clientY: number;\n    readonly ctrlKey: boolean;\n    readonly metaKey: boolean;\n    readonly movementX: number;\n    readonly movementY: number;\n    readonly offsetX: number;\n    readonly offsetY: number;\n    readonly pageX: number;\n    readonly pageY: number;\n    readonly relatedTarget: EventTarget | null;\n    readonly screenX: number;\n    readonly screenY: number;\n    readonly shiftKey: boolean;\n    readonly x: number;\n    readonly y: number;\n    getModifierState(keyArg: string): boolean;\n    /** @deprecated */\n    initMouseEvent(typeArg: string, canBubbleArg: boolean, cancelableArg: boolean, viewArg: Window, detailArg: number, screenXArg: number, screenYArg: number, clientXArg: number, clientYArg: number, ctrlKeyArg: boolean, altKeyArg: boolean, shiftKeyArg: boolean, metaKeyArg: boolean, buttonArg: number, relatedTargetArg: EventTarget | null): void;\n}\n\ndeclare var MouseEvent: {\n    prototype: MouseEvent;\n    new(type: string, eventInitDict?: MouseEventInit): MouseEvent;\n};\n\n/**\n * Provides event properties that are specific to modifications to the Document Object Model (DOM) hierarchy and nodes.\n * @deprecated DOM4 [DOM] provides a new mechanism using a MutationObserver interface which addresses the use cases that mutation events solve, but in a more performant manner. Thus, this specification describes mutation events for reference and completeness of legacy behavior, but deprecates the use of the MutationEvent interface.\n */\ninterface MutationEvent extends Event {\n    /** @deprecated */\n    readonly attrChange: number;\n    /** @deprecated */\n    readonly attrName: string;\n    /** @deprecated */\n    readonly newValue: string;\n    /** @deprecated */\n    readonly prevValue: string;\n    /** @deprecated */\n    readonly relatedNode: Node | null;\n    /** @deprecated */\n    initMutationEvent(typeArg: string, bubblesArg?: boolean, cancelableArg?: boolean, relatedNodeArg?: Node | null, prevValueArg?: string, newValueArg?: string, attrNameArg?: string, attrChangeArg?: number): void;\n    readonly MODIFICATION: 1;\n    readonly ADDITION: 2;\n    readonly REMOVAL: 3;\n}\n\n/** @deprecated */\ndeclare var MutationEvent: {\n    prototype: MutationEvent;\n    new(): MutationEvent;\n    readonly MODIFICATION: 1;\n    readonly ADDITION: 2;\n    readonly REMOVAL: 3;\n};\n\n/** Provides the ability to watch for changes being made to the DOM tree. It is designed as a replacement for the older Mutation Events feature which was part of the DOM3 Events specification. */\ninterface MutationObserver {\n    /** Stops observer from observing any mutations. Until the observe() method is used again, observer's callback will not be invoked. */\n    disconnect(): void;\n    /**\n     * Instructs the user agent to observe a given target (a node) and report any mutations based on the criteria given by options (an object).\n     *\n     * The options argument allows for setting mutation observation options via object members.\n     */\n    observe(target: Node, options?: MutationObserverInit): void;\n    /** Empties the record queue and returns what was in there. */\n    takeRecords(): MutationRecord[];\n}\n\ndeclare var MutationObserver: {\n    prototype: MutationObserver;\n    new(callback: MutationCallback): MutationObserver;\n};\n\n/** A MutationRecord represents an individual DOM mutation. It is the object that is passed to MutationObserver's callback. */\ninterface MutationRecord {\n    /** Return the nodes added and removed respectively. */\n    readonly addedNodes: NodeList;\n    /** Returns the local name of the changed attribute, and null otherwise. */\n    readonly attributeName: string | null;\n    /** Returns the namespace of the changed attribute, and null otherwise. */\n    readonly attributeNamespace: string | null;\n    /** Return the previous and next sibling respectively of the added or removed nodes, and null otherwise. */\n    readonly nextSibling: Node | null;\n    /** The return value depends on type. For \"attributes\", it is the value of the changed attribute before the change. For \"characterData\", it is the data of the changed node before the change. For \"childList\", it is null. */\n    readonly oldValue: string | null;\n    /** Return the previous and next sibling respectively of the added or removed nodes, and null otherwise. */\n    readonly previousSibling: Node | null;\n    /** Return the nodes added and removed respectively. */\n    readonly removedNodes: NodeList;\n    /** Returns the node the mutation affected, depending on the type. For \"attributes\", it is the element whose attribute changed. For \"characterData\", it is the CharacterData node. For \"childList\", it is the node whose children changed. */\n    readonly target: Node;\n    /** Returns \"attributes\" if it was an attribute mutation. \"characterData\" if it was a mutation to a CharacterData node. And \"childList\" if it was a mutation to the tree of nodes. */\n    readonly type: MutationRecordType;\n}\n\ndeclare var MutationRecord: {\n    prototype: MutationRecord;\n    new(): MutationRecord;\n};\n\n/** A collection of Attr objects. Objects inside a NamedNodeMap are not in any particular order, unlike NodeList, although they may be accessed by an index as in an array. */\ninterface NamedNodeMap {\n    readonly length: number;\n    getNamedItem(qualifiedName: string): Attr | null;\n    getNamedItemNS(namespace: string | null, localName: string): Attr | null;\n    item(index: number): Attr | null;\n    removeNamedItem(qualifiedName: string): Attr;\n    removeNamedItemNS(namespace: string | null, localName: string): Attr;\n    setNamedItem(attr: Attr): Attr | null;\n    setNamedItemNS(attr: Attr): Attr | null;\n    [index: number]: Attr;\n}\n\ndeclare var NamedNodeMap: {\n    prototype: NamedNodeMap;\n    new(): NamedNodeMap;\n};\n\n/** Available only in secure contexts. */\ninterface NavigationPreloadManager {\n    disable(): Promise<void>;\n    enable(): Promise<void>;\n    getState(): Promise<NavigationPreloadState>;\n    setHeaderValue(value: string): Promise<void>;\n}\n\ndeclare var NavigationPreloadManager: {\n    prototype: NavigationPreloadManager;\n    new(): NavigationPreloadManager;\n};\n\n/** The state and the identity of the user agent. It allows scripts to query it and to register themselves to carry on some activities. */\ninterface Navigator extends NavigatorAutomationInformation, NavigatorConcurrentHardware, NavigatorContentUtils, NavigatorCookies, NavigatorID, NavigatorLanguage, NavigatorLocks, NavigatorOnLine, NavigatorPlugins, NavigatorStorage {\n    /** Available only in secure contexts. */\n    readonly clipboard: Clipboard;\n    /** Available only in secure contexts. */\n    readonly credentials: CredentialsContainer;\n    readonly doNotTrack: string | null;\n    readonly geolocation: Geolocation;\n    readonly maxTouchPoints: number;\n    readonly mediaCapabilities: MediaCapabilities;\n    /** Available only in secure contexts. */\n    readonly mediaDevices: MediaDevices;\n    readonly mediaSession: MediaSession;\n    readonly permissions: Permissions;\n    /** Available only in secure contexts. */\n    readonly serviceWorker: ServiceWorkerContainer;\n    /** Available only in secure contexts. */\n    canShare(data?: ShareData): boolean;\n    getGamepads(): (Gamepad | null)[];\n    /** Available only in secure contexts. */\n    requestMIDIAccess(options?: MIDIOptions): Promise<MIDIAccess>;\n    /** Available only in secure contexts. */\n    requestMediaKeySystemAccess(keySystem: string, supportedConfigurations: MediaKeySystemConfiguration[]): Promise<MediaKeySystemAccess>;\n    sendBeacon(url: string | URL, data?: BodyInit | null): boolean;\n    /** Available only in secure contexts. */\n    share(data?: ShareData): Promise<void>;\n    vibrate(pattern: VibratePattern): boolean;\n}\n\ndeclare var Navigator: {\n    prototype: Navigator;\n    new(): Navigator;\n};\n\ninterface NavigatorAutomationInformation {\n    readonly webdriver: boolean;\n}\n\ninterface NavigatorConcurrentHardware {\n    readonly hardwareConcurrency: number;\n}\n\ninterface NavigatorContentUtils {\n    /** Available only in secure contexts. */\n    registerProtocolHandler(scheme: string, url: string | URL): void;\n}\n\ninterface NavigatorCookies {\n    readonly cookieEnabled: boolean;\n}\n\ninterface NavigatorID {\n    /** @deprecated */\n    readonly appCodeName: string;\n    /** @deprecated */\n    readonly appName: string;\n    /** @deprecated */\n    readonly appVersion: string;\n    /** @deprecated */\n    readonly platform: string;\n    /** @deprecated */\n    readonly product: string;\n    /** @deprecated */\n    readonly productSub: string;\n    readonly userAgent: string;\n    /** @deprecated */\n    readonly vendor: string;\n    /** @deprecated */\n    readonly vendorSub: string;\n}\n\ninterface NavigatorLanguage {\n    readonly language: string;\n    readonly languages: ReadonlyArray<string>;\n}\n\n/** Available only in secure contexts. */\ninterface NavigatorLocks {\n    readonly locks: LockManager;\n}\n\ninterface NavigatorOnLine {\n    readonly onLine: boolean;\n}\n\ninterface NavigatorPlugins {\n    /** @deprecated */\n    readonly mimeTypes: MimeTypeArray;\n    readonly pdfViewerEnabled: boolean;\n    /** @deprecated */\n    readonly plugins: PluginArray;\n    /** @deprecated */\n    javaEnabled(): boolean;\n}\n\n/** Available only in secure contexts. */\ninterface NavigatorStorage {\n    readonly storage: StorageManager;\n}\n\n/** Node is an interface from which a number of DOM API object types inherit. It allows those types to be treated similarly; for example, inheriting the same set of methods, or being tested in the same way. */\ninterface Node extends EventTarget {\n    /** Returns node's node document's document base URL. */\n    readonly baseURI: string;\n    /** Returns the children. */\n    readonly childNodes: NodeListOf<ChildNode>;\n    /** Returns the first child. */\n    readonly firstChild: ChildNode | null;\n    /** Returns true if node is connected and false otherwise. */\n    readonly isConnected: boolean;\n    /** Returns the last child. */\n    readonly lastChild: ChildNode | null;\n    /** Returns the next sibling. */\n    readonly nextSibling: ChildNode | null;\n    /** Returns a string appropriate for the type of node. */\n    readonly nodeName: string;\n    /** Returns the type of node. */\n    readonly nodeType: number;\n    nodeValue: string | null;\n    /** Returns the node document. Returns null for documents. */\n    readonly ownerDocument: Document | null;\n    /** Returns the parent element. */\n    readonly parentElement: HTMLElement | null;\n    /** Returns the parent. */\n    readonly parentNode: ParentNode | null;\n    /** Returns the previous sibling. */\n    readonly previousSibling: ChildNode | null;\n    textContent: string | null;\n    appendChild<T extends Node>(node: T): T;\n    /** Returns a copy of node. If deep is true, the copy also includes the node's descendants. */\n    cloneNode(deep?: boolean): Node;\n    /** Returns a bitmask indicating the position of other relative to node. */\n    compareDocumentPosition(other: Node): number;\n    /** Returns true if other is an inclusive descendant of node, and false otherwise. */\n    contains(other: Node | null): boolean;\n    /** Returns node's root. */\n    getRootNode(options?: GetRootNodeOptions): Node;\n    /** Returns whether node has children. */\n    hasChildNodes(): boolean;\n    insertBefore<T extends Node>(node: T, child: Node | null): T;\n    isDefaultNamespace(namespace: string | null): boolean;\n    /** Returns whether node and otherNode have the same properties. */\n    isEqualNode(otherNode: Node | null): boolean;\n    isSameNode(otherNode: Node | null): boolean;\n    lookupNamespaceURI(prefix: string | null): string | null;\n    lookupPrefix(namespace: string | null): string | null;\n    /** Removes empty exclusive Text nodes and concatenates the data of remaining contiguous exclusive Text nodes into the first of their nodes. */\n    normalize(): void;\n    removeChild<T extends Node>(child: T): T;\n    replaceChild<T extends Node>(node: Node, child: T): T;\n    /** node is an element. */\n    readonly ELEMENT_NODE: 1;\n    readonly ATTRIBUTE_NODE: 2;\n    /** node is a Text node. */\n    readonly TEXT_NODE: 3;\n    /** node is a CDATASection node. */\n    readonly CDATA_SECTION_NODE: 4;\n    readonly ENTITY_REFERENCE_NODE: 5;\n    readonly ENTITY_NODE: 6;\n    /** node is a ProcessingInstruction node. */\n    readonly PROCESSING_INSTRUCTION_NODE: 7;\n    /** node is a Comment node. */\n    readonly COMMENT_NODE: 8;\n    /** node is a document. */\n    readonly DOCUMENT_NODE: 9;\n    /** node is a doctype. */\n    readonly DOCUMENT_TYPE_NODE: 10;\n    /** node is a DocumentFragment node. */\n    readonly DOCUMENT_FRAGMENT_NODE: 11;\n    readonly NOTATION_NODE: 12;\n    /** Set when node and other are not in the same tree. */\n    readonly DOCUMENT_POSITION_DISCONNECTED: 0x01;\n    /** Set when other is preceding node. */\n    readonly DOCUMENT_POSITION_PRECEDING: 0x02;\n    /** Set when other is following node. */\n    readonly DOCUMENT_POSITION_FOLLOWING: 0x04;\n    /** Set when other is an ancestor of node. */\n    readonly DOCUMENT_POSITION_CONTAINS: 0x08;\n    /** Set when other is a descendant of node. */\n    readonly DOCUMENT_POSITION_CONTAINED_BY: 0x10;\n    readonly DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC: 0x20;\n}\n\ndeclare var Node: {\n    prototype: Node;\n    new(): Node;\n    /** node is an element. */\n    readonly ELEMENT_NODE: 1;\n    readonly ATTRIBUTE_NODE: 2;\n    /** node is a Text node. */\n    readonly TEXT_NODE: 3;\n    /** node is a CDATASection node. */\n    readonly CDATA_SECTION_NODE: 4;\n    readonly ENTITY_REFERENCE_NODE: 5;\n    readonly ENTITY_NODE: 6;\n    /** node is a ProcessingInstruction node. */\n    readonly PROCESSING_INSTRUCTION_NODE: 7;\n    /** node is a Comment node. */\n    readonly COMMENT_NODE: 8;\n    /** node is a document. */\n    readonly DOCUMENT_NODE: 9;\n    /** node is a doctype. */\n    readonly DOCUMENT_TYPE_NODE: 10;\n    /** node is a DocumentFragment node. */\n    readonly DOCUMENT_FRAGMENT_NODE: 11;\n    readonly NOTATION_NODE: 12;\n    /** Set when node and other are not in the same tree. */\n    readonly DOCUMENT_POSITION_DISCONNECTED: 0x01;\n    /** Set when other is preceding node. */\n    readonly DOCUMENT_POSITION_PRECEDING: 0x02;\n    /** Set when other is following node. */\n    readonly DOCUMENT_POSITION_FOLLOWING: 0x04;\n    /** Set when other is an ancestor of node. */\n    readonly DOCUMENT_POSITION_CONTAINS: 0x08;\n    /** Set when other is a descendant of node. */\n    readonly DOCUMENT_POSITION_CONTAINED_BY: 0x10;\n    readonly DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC: 0x20;\n};\n\n/** An iterator over the members of a list of the nodes in a subtree of the DOM. The nodes will be returned in document order. */\ninterface NodeIterator {\n    readonly filter: NodeFilter | null;\n    readonly pointerBeforeReferenceNode: boolean;\n    readonly referenceNode: Node;\n    readonly root: Node;\n    readonly whatToShow: number;\n    /** @deprecated */\n    detach(): void;\n    nextNode(): Node | null;\n    previousNode(): Node | null;\n}\n\ndeclare var NodeIterator: {\n    prototype: NodeIterator;\n    new(): NodeIterator;\n};\n\n/** NodeList objects are collections of nodes, usually returned by properties such as Node.childNodes and methods such as document.querySelectorAll(). */\ninterface NodeList {\n    /** Returns the number of nodes in the collection. */\n    readonly length: number;\n    /** Returns the node with index index from the collection. The nodes are sorted in tree order. */\n    item(index: number): Node | null;\n    /**\n     * Performs the specified action for each node in an list.\n     * @param callbackfn  A function that accepts up to three arguments. forEach calls the callbackfn function one time for each element in the list.\n     * @param thisArg  An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, undefined is used as the this value.\n     */\n    forEach(callbackfn: (value: Node, key: number, parent: NodeList) => void, thisArg?: any): void;\n    [index: number]: Node;\n}\n\ndeclare var NodeList: {\n    prototype: NodeList;\n    new(): NodeList;\n};\n\ninterface NodeListOf<TNode extends Node> extends NodeList {\n    item(index: number): TNode;\n    /**\n     * Performs the specified action for each node in an list.\n     * @param callbackfn  A function that accepts up to three arguments. forEach calls the callbackfn function one time for each element in the list.\n     * @param thisArg  An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, undefined is used as the this value.\n     */\n    forEach(callbackfn: (value: TNode, key: number, parent: NodeListOf<TNode>) => void, thisArg?: any): void;\n    [index: number]: TNode;\n}\n\ninterface NonDocumentTypeChildNode {\n    /** Returns the first following sibling that is an element, and null otherwise. */\n    readonly nextElementSibling: Element | null;\n    /** Returns the first preceding sibling that is an element, and null otherwise. */\n    readonly previousElementSibling: Element | null;\n}\n\ninterface NonElementParentNode {\n    /** Returns the first element within node's descendants whose ID is elementId. */\n    getElementById(elementId: string): Element | null;\n}\n\ninterface NotificationEventMap {\n    \"click\": Event;\n    \"close\": Event;\n    \"error\": Event;\n    \"show\": Event;\n}\n\n/** This Notifications API interface is used to configure and display desktop notifications to the user. */\ninterface Notification extends EventTarget {\n    readonly body: string;\n    readonly data: any;\n    readonly dir: NotificationDirection;\n    readonly icon: string;\n    readonly lang: string;\n    onclick: ((this: Notification, ev: Event) => any) | null;\n    onclose: ((this: Notification, ev: Event) => any) | null;\n    onerror: ((this: Notification, ev: Event) => any) | null;\n    onshow: ((this: Notification, ev: Event) => any) | null;\n    readonly tag: string;\n    readonly title: string;\n    close(): void;\n    addEventListener<K extends keyof NotificationEventMap>(type: K, listener: (this: Notification, ev: NotificationEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof NotificationEventMap>(type: K, listener: (this: Notification, ev: NotificationEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var Notification: {\n    prototype: Notification;\n    new(title: string, options?: NotificationOptions): Notification;\n    readonly permission: NotificationPermission;\n    requestPermission(deprecatedCallback?: NotificationPermissionCallback): Promise<NotificationPermission>;\n};\n\ninterface OES_draw_buffers_indexed {\n    blendEquationSeparateiOES(buf: GLuint, modeRGB: GLenum, modeAlpha: GLenum): void;\n    blendEquationiOES(buf: GLuint, mode: GLenum): void;\n    blendFuncSeparateiOES(buf: GLuint, srcRGB: GLenum, dstRGB: GLenum, srcAlpha: GLenum, dstAlpha: GLenum): void;\n    blendFunciOES(buf: GLuint, src: GLenum, dst: GLenum): void;\n    colorMaskiOES(buf: GLuint, r: GLboolean, g: GLboolean, b: GLboolean, a: GLboolean): void;\n    disableiOES(target: GLenum, index: GLuint): void;\n    enableiOES(target: GLenum, index: GLuint): void;\n}\n\n/** The OES_element_index_uint extension is part of the WebGL API and adds support for gl.UNSIGNED_INT types to WebGLRenderingContext.drawElements(). */\ninterface OES_element_index_uint {\n}\n\ninterface OES_fbo_render_mipmap {\n}\n\n/** The OES_standard_derivatives extension is part of the WebGL API and adds the GLSL derivative functions dFdx, dFdy, and fwidth. */\ninterface OES_standard_derivatives {\n    readonly FRAGMENT_SHADER_DERIVATIVE_HINT_OES: 0x8B8B;\n}\n\n/** The OES_texture_float extension is part of the WebGL API and exposes floating-point pixel types for textures. */\ninterface OES_texture_float {\n}\n\n/** The OES_texture_float_linear extension is part of the WebGL API and allows linear filtering with floating-point pixel types for textures. */\ninterface OES_texture_float_linear {\n}\n\n/** The OES_texture_half_float extension is part of the WebGL API and adds texture formats with 16- (aka half float) and 32-bit floating-point components. */\ninterface OES_texture_half_float {\n    readonly HALF_FLOAT_OES: 0x8D61;\n}\n\n/** The OES_texture_half_float_linear extension is part of the WebGL API and allows linear filtering with half floating-point pixel types for textures. */\ninterface OES_texture_half_float_linear {\n}\n\ninterface OES_vertex_array_object {\n    bindVertexArrayOES(arrayObject: WebGLVertexArrayObjectOES | null): void;\n    createVertexArrayOES(): WebGLVertexArrayObjectOES | null;\n    deleteVertexArrayOES(arrayObject: WebGLVertexArrayObjectOES | null): void;\n    isVertexArrayOES(arrayObject: WebGLVertexArrayObjectOES | null): GLboolean;\n    readonly VERTEX_ARRAY_BINDING_OES: 0x85B5;\n}\n\ninterface OVR_multiview2 {\n    framebufferTextureMultiviewOVR(target: GLenum, attachment: GLenum, texture: WebGLTexture | null, level: GLint, baseViewIndex: GLint, numViews: GLsizei): void;\n    readonly FRAMEBUFFER_ATTACHMENT_TEXTURE_NUM_VIEWS_OVR: 0x9630;\n    readonly FRAMEBUFFER_ATTACHMENT_TEXTURE_BASE_VIEW_INDEX_OVR: 0x9632;\n    readonly MAX_VIEWS_OVR: 0x9631;\n    readonly FRAMEBUFFER_INCOMPLETE_VIEW_TARGETS_OVR: 0x9633;\n}\n\n/** The Web Audio API OfflineAudioCompletionEvent interface represents events that occur when the processing of an OfflineAudioContext is terminated. The complete event implements this interface. */\ninterface OfflineAudioCompletionEvent extends Event {\n    readonly renderedBuffer: AudioBuffer;\n}\n\ndeclare var OfflineAudioCompletionEvent: {\n    prototype: OfflineAudioCompletionEvent;\n    new(type: string, eventInitDict: OfflineAudioCompletionEventInit): OfflineAudioCompletionEvent;\n};\n\ninterface OfflineAudioContextEventMap extends BaseAudioContextEventMap {\n    \"complete\": OfflineAudioCompletionEvent;\n}\n\n/** An AudioContext interface representing an audio-processing graph built from linked together AudioNodes. In contrast with a standard AudioContext, an OfflineAudioContext doesn't render the audio to the device hardware; instead, it generates it, as fast as it can, and outputs the result to an AudioBuffer. */\ninterface OfflineAudioContext extends BaseAudioContext {\n    readonly length: number;\n    oncomplete: ((this: OfflineAudioContext, ev: OfflineAudioCompletionEvent) => any) | null;\n    resume(): Promise<void>;\n    startRendering(): Promise<AudioBuffer>;\n    suspend(suspendTime: number): Promise<void>;\n    addEventListener<K extends keyof OfflineAudioContextEventMap>(type: K, listener: (this: OfflineAudioContext, ev: OfflineAudioContextEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof OfflineAudioContextEventMap>(type: K, listener: (this: OfflineAudioContext, ev: OfflineAudioContextEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var OfflineAudioContext: {\n    prototype: OfflineAudioContext;\n    new(contextOptions: OfflineAudioContextOptions): OfflineAudioContext;\n    new(numberOfChannels: number, length: number, sampleRate: number): OfflineAudioContext;\n};\n\ninterface OffscreenCanvasEventMap {\n    \"contextlost\": Event;\n    \"contextrestored\": Event;\n}\n\ninterface OffscreenCanvas extends EventTarget {\n    /**\n     * These attributes return the dimensions of the OffscreenCanvas object's bitmap.\n     *\n     * They can be set, to replace the bitmap with a new, transparent black bitmap of the specified dimensions (effectively resizing it).\n     */\n    height: number;\n    oncontextlost: ((this: OffscreenCanvas, ev: Event) => any) | null;\n    oncontextrestored: ((this: OffscreenCanvas, ev: Event) => any) | null;\n    /**\n     * These attributes return the dimensions of the OffscreenCanvas object's bitmap.\n     *\n     * They can be set, to replace the bitmap with a new, transparent black bitmap of the specified dimensions (effectively resizing it).\n     */\n    width: number;\n    /**\n     * Returns a promise that will fulfill with a new Blob object representing a file containing the image in the OffscreenCanvas object.\n     *\n     * The argument, if provided, is a dictionary that controls the encoding options of the image file to be created. The type field specifies the file format and has a default value of \"image/png\"; that type is also used if the requested type isn't supported. If the image format supports variable quality (such as \"image/jpeg\"), then the quality field is a number in the range 0.0 to 1.0 inclusive indicating the desired quality level for the resulting image.\n     */\n    convertToBlob(options?: ImageEncodeOptions): Promise<Blob>;\n    /**\n     * Returns an object that exposes an API for drawing on the OffscreenCanvas object. contextId specifies the desired API: \"2d\", \"bitmaprenderer\", \"webgl\", or \"webgl2\". options is handled by that API.\n     *\n     * This specification defines the \"2d\" context below, which is similar but distinct from the \"2d\" context that is created from a canvas element. The WebGL specifications define the \"webgl\" and \"webgl2\" contexts. [WEBGL]\n     *\n     * Returns null if the canvas has already been initialized with another context type (e.g., trying to get a \"2d\" context after getting a \"webgl\" context).\n     */\n    getContext(contextId: \"2d\", options?: any): OffscreenCanvasRenderingContext2D | null;\n    getContext(contextId: \"bitmaprenderer\", options?: any): ImageBitmapRenderingContext | null;\n    getContext(contextId: \"webgl\", options?: any): WebGLRenderingContext | null;\n    getContext(contextId: \"webgl2\", options?: any): WebGL2RenderingContext | null;\n    getContext(contextId: OffscreenRenderingContextId, options?: any): OffscreenRenderingContext | null;\n    /** Returns a newly created ImageBitmap object with the image in the OffscreenCanvas object. The image in the OffscreenCanvas object is replaced with a new blank image. */\n    transferToImageBitmap(): ImageBitmap;\n    addEventListener<K extends keyof OffscreenCanvasEventMap>(type: K, listener: (this: OffscreenCanvas, ev: OffscreenCanvasEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof OffscreenCanvasEventMap>(type: K, listener: (this: OffscreenCanvas, ev: OffscreenCanvasEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var OffscreenCanvas: {\n    prototype: OffscreenCanvas;\n    new(width: number, height: number): OffscreenCanvas;\n};\n\ninterface OffscreenCanvasRenderingContext2D extends CanvasCompositing, CanvasDrawImage, CanvasDrawPath, CanvasFillStrokeStyles, CanvasFilters, CanvasImageData, CanvasImageSmoothing, CanvasPath, CanvasPathDrawingStyles, CanvasRect, CanvasShadowStyles, CanvasState, CanvasText, CanvasTextDrawingStyles, CanvasTransform {\n    readonly canvas: OffscreenCanvas;\n    commit(): void;\n}\n\ndeclare var OffscreenCanvasRenderingContext2D: {\n    prototype: OffscreenCanvasRenderingContext2D;\n    new(): OffscreenCanvasRenderingContext2D;\n};\n\n/** The OscillatorNode interface represents a periodic waveform, such as a sine wave. It is an AudioScheduledSourceNode audio-processing module that causes a specified frequency of a given wave to be created—in effect, a constant tone. */\ninterface OscillatorNode extends AudioScheduledSourceNode {\n    readonly detune: AudioParam;\n    readonly frequency: AudioParam;\n    type: OscillatorType;\n    setPeriodicWave(periodicWave: PeriodicWave): void;\n    addEventListener<K extends keyof AudioScheduledSourceNodeEventMap>(type: K, listener: (this: OscillatorNode, ev: AudioScheduledSourceNodeEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof AudioScheduledSourceNodeEventMap>(type: K, listener: (this: OscillatorNode, ev: AudioScheduledSourceNodeEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var OscillatorNode: {\n    prototype: OscillatorNode;\n    new(context: BaseAudioContext, options?: OscillatorOptions): OscillatorNode;\n};\n\ninterface OverconstrainedError extends Error {\n    readonly constraint: string;\n}\n\ndeclare var OverconstrainedError: {\n    prototype: OverconstrainedError;\n    new(constraint: string, message?: string): OverconstrainedError;\n};\n\n/** The PageTransitionEvent is fired when a document is being loaded or unloaded. */\ninterface PageTransitionEvent extends Event {\n    /**\n     * For the pageshow event, returns false if the page is newly being loaded (and the load event will fire). Otherwise, returns true.\n     *\n     * For the pagehide event, returns false if the page is going away for the last time. Otherwise, returns true, meaning that (if nothing conspires to make the page unsalvageable) the page might be reused if the user navigates back to this page.\n     *\n     * Things that can cause the page to be unsalvageable include:\n     *\n     * The user agent decided to not keep the Document alive in a session history entry after unload\n     * Having iframes that are not salvageable\n     * Active WebSocket objects\n     * Aborting a Document\n     */\n    readonly persisted: boolean;\n}\n\ndeclare var PageTransitionEvent: {\n    prototype: PageTransitionEvent;\n    new(type: string, eventInitDict?: PageTransitionEventInit): PageTransitionEvent;\n};\n\n/** A PannerNode always has exactly one input and one output: the input can be mono or stereo but the output is always stereo (2 channels); you can't have panning effects without at least two audio channels! */\ninterface PannerNode extends AudioNode {\n    coneInnerAngle: number;\n    coneOuterAngle: number;\n    coneOuterGain: number;\n    distanceModel: DistanceModelType;\n    maxDistance: number;\n    readonly orientationX: AudioParam;\n    readonly orientationY: AudioParam;\n    readonly orientationZ: AudioParam;\n    panningModel: PanningModelType;\n    readonly positionX: AudioParam;\n    readonly positionY: AudioParam;\n    readonly positionZ: AudioParam;\n    refDistance: number;\n    rolloffFactor: number;\n    /** @deprecated */\n    setOrientation(x: number, y: number, z: number): void;\n    /** @deprecated */\n    setPosition(x: number, y: number, z: number): void;\n}\n\ndeclare var PannerNode: {\n    prototype: PannerNode;\n    new(context: BaseAudioContext, options?: PannerOptions): PannerNode;\n};\n\ninterface ParentNode extends Node {\n    readonly childElementCount: number;\n    /** Returns the child elements. */\n    readonly children: HTMLCollection;\n    /** Returns the first child that is an element, and null otherwise. */\n    readonly firstElementChild: Element | null;\n    /** Returns the last child that is an element, and null otherwise. */\n    readonly lastElementChild: Element | null;\n    /**\n     * Inserts nodes after the last child of node, while replacing strings in nodes with equivalent Text nodes.\n     *\n     * Throws a \"HierarchyRequestError\" DOMException if the constraints of the node tree are violated.\n     */\n    append(...nodes: (Node | string)[]): void;\n    /**\n     * Inserts nodes before the first child of node, while replacing strings in nodes with equivalent Text nodes.\n     *\n     * Throws a \"HierarchyRequestError\" DOMException if the constraints of the node tree are violated.\n     */\n    prepend(...nodes: (Node | string)[]): void;\n    /** Returns the first element that is a descendant of node that matches selectors. */\n    querySelector<K extends keyof HTMLElementTagNameMap>(selectors: K): HTMLElementTagNameMap[K] | null;\n    querySelector<K extends keyof SVGElementTagNameMap>(selectors: K): SVGElementTagNameMap[K] | null;\n    querySelector<K extends keyof MathMLElementTagNameMap>(selectors: K): MathMLElementTagNameMap[K] | null;\n    /** @deprecated */\n    querySelector<K extends keyof HTMLElementDeprecatedTagNameMap>(selectors: K): HTMLElementDeprecatedTagNameMap[K] | null;\n    querySelector<E extends Element = Element>(selectors: string): E | null;\n    /** Returns all element descendants of node that match selectors. */\n    querySelectorAll<K extends keyof HTMLElementTagNameMap>(selectors: K): NodeListOf<HTMLElementTagNameMap[K]>;\n    querySelectorAll<K extends keyof SVGElementTagNameMap>(selectors: K): NodeListOf<SVGElementTagNameMap[K]>;\n    querySelectorAll<K extends keyof MathMLElementTagNameMap>(selectors: K): NodeListOf<MathMLElementTagNameMap[K]>;\n    /** @deprecated */\n    querySelectorAll<K extends keyof HTMLElementDeprecatedTagNameMap>(selectors: K): NodeListOf<HTMLElementDeprecatedTagNameMap[K]>;\n    querySelectorAll<E extends Element = Element>(selectors: string): NodeListOf<E>;\n    /**\n     * Replace all children of node with nodes, while replacing strings in nodes with equivalent Text nodes.\n     *\n     * Throws a \"HierarchyRequestError\" DOMException if the constraints of the node tree are violated.\n     */\n    replaceChildren(...nodes: (Node | string)[]): void;\n}\n\n/** This Canvas 2D API interface is used to declare a path that can then be used on a CanvasRenderingContext2D object. The path methods of the CanvasRenderingContext2D interface are also present on this interface, which gives you the convenience of being able to retain and replay your path whenever desired. */\ninterface Path2D extends CanvasPath {\n    /** Adds to the path the path given by the argument. */\n    addPath(path: Path2D, transform?: DOMMatrix2DInit): void;\n}\n\ndeclare var Path2D: {\n    prototype: Path2D;\n    new(path?: Path2D | string): Path2D;\n};\n\n/** Available only in secure contexts. */\ninterface PaymentMethodChangeEvent extends PaymentRequestUpdateEvent {\n    readonly methodDetails: any;\n    readonly methodName: string;\n}\n\ndeclare var PaymentMethodChangeEvent: {\n    prototype: PaymentMethodChangeEvent;\n    new(type: string, eventInitDict?: PaymentMethodChangeEventInit): PaymentMethodChangeEvent;\n};\n\ninterface PaymentRequestEventMap {\n    \"paymentmethodchange\": Event;\n}\n\n/**\n * This Payment Request API interface is the primary access point into the API, and lets web content and apps accept payments from the end user.\n * Available only in secure contexts.\n */\ninterface PaymentRequest extends EventTarget {\n    readonly id: string;\n    onpaymentmethodchange: ((this: PaymentRequest, ev: Event) => any) | null;\n    abort(): Promise<void>;\n    canMakePayment(): Promise<boolean>;\n    show(detailsPromise?: PaymentDetailsUpdate | PromiseLike<PaymentDetailsUpdate>): Promise<PaymentResponse>;\n    addEventListener<K extends keyof PaymentRequestEventMap>(type: K, listener: (this: PaymentRequest, ev: PaymentRequestEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof PaymentRequestEventMap>(type: K, listener: (this: PaymentRequest, ev: PaymentRequestEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var PaymentRequest: {\n    prototype: PaymentRequest;\n    new(methodData: PaymentMethodData[], details: PaymentDetailsInit): PaymentRequest;\n};\n\n/**\n * This Payment Request API interface enables a web page to update the details of a PaymentRequest in response to a user action.\n * Available only in secure contexts.\n */\ninterface PaymentRequestUpdateEvent extends Event {\n    updateWith(detailsPromise: PaymentDetailsUpdate | PromiseLike<PaymentDetailsUpdate>): void;\n}\n\ndeclare var PaymentRequestUpdateEvent: {\n    prototype: PaymentRequestUpdateEvent;\n    new(type: string, eventInitDict?: PaymentRequestUpdateEventInit): PaymentRequestUpdateEvent;\n};\n\n/**\n * This Payment Request API interface is returned after a user selects a payment method and approves a payment request.\n * Available only in secure contexts.\n */\ninterface PaymentResponse extends EventTarget {\n    readonly details: any;\n    readonly methodName: string;\n    readonly requestId: string;\n    complete(result?: PaymentComplete): Promise<void>;\n    retry(errorFields?: PaymentValidationErrors): Promise<void>;\n    toJSON(): any;\n}\n\ndeclare var PaymentResponse: {\n    prototype: PaymentResponse;\n    new(): PaymentResponse;\n};\n\ninterface PerformanceEventMap {\n    \"resourcetimingbufferfull\": Event;\n}\n\n/** Provides access to performance-related information for the current page. It's part of the High Resolution Time API, but is enhanced by the Performance Timeline API, the Navigation Timing API, the User Timing API, and the Resource Timing API. */\ninterface Performance extends EventTarget {\n    readonly eventCounts: EventCounts;\n    /** @deprecated */\n    readonly navigation: PerformanceNavigation;\n    onresourcetimingbufferfull: ((this: Performance, ev: Event) => any) | null;\n    readonly timeOrigin: DOMHighResTimeStamp;\n    /** @deprecated */\n    readonly timing: PerformanceTiming;\n    clearMarks(markName?: string): void;\n    clearMeasures(measureName?: string): void;\n    clearResourceTimings(): void;\n    getEntries(): PerformanceEntryList;\n    getEntriesByName(name: string, type?: string): PerformanceEntryList;\n    getEntriesByType(type: string): PerformanceEntryList;\n    mark(markName: string, markOptions?: PerformanceMarkOptions): PerformanceMark;\n    measure(measureName: string, startOrMeasureOptions?: string | PerformanceMeasureOptions, endMark?: string): PerformanceMeasure;\n    now(): DOMHighResTimeStamp;\n    setResourceTimingBufferSize(maxSize: number): void;\n    toJSON(): any;\n    addEventListener<K extends keyof PerformanceEventMap>(type: K, listener: (this: Performance, ev: PerformanceEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof PerformanceEventMap>(type: K, listener: (this: Performance, ev: PerformanceEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var Performance: {\n    prototype: Performance;\n    new(): Performance;\n};\n\n/** Encapsulates a single performance metric that is part of the performance timeline. A performance entry can be directly created by making a performance mark or measure (for example by calling the mark() method) at an explicit point in an application. Performance entries are also created in indirect ways such as loading a resource (such as an image). */\ninterface PerformanceEntry {\n    readonly duration: DOMHighResTimeStamp;\n    readonly entryType: string;\n    readonly name: string;\n    readonly startTime: DOMHighResTimeStamp;\n    toJSON(): any;\n}\n\ndeclare var PerformanceEntry: {\n    prototype: PerformanceEntry;\n    new(): PerformanceEntry;\n};\n\ninterface PerformanceEventTiming extends PerformanceEntry {\n    readonly cancelable: boolean;\n    readonly processingEnd: DOMHighResTimeStamp;\n    readonly processingStart: DOMHighResTimeStamp;\n    readonly target: Node | null;\n    toJSON(): any;\n}\n\ndeclare var PerformanceEventTiming: {\n    prototype: PerformanceEventTiming;\n    new(): PerformanceEventTiming;\n};\n\n/** PerformanceMark is an abstract interface for PerformanceEntry objects with an entryType of \"mark\". Entries of this type are created by calling performance.mark() to add a named DOMHighResTimeStamp (the mark) to the browser's performance timeline. */\ninterface PerformanceMark extends PerformanceEntry {\n    readonly detail: any;\n}\n\ndeclare var PerformanceMark: {\n    prototype: PerformanceMark;\n    new(markName: string, markOptions?: PerformanceMarkOptions): PerformanceMark;\n};\n\n/** PerformanceMeasure is an abstract interface for PerformanceEntry objects with an entryType of \"measure\". Entries of this type are created by calling performance.measure() to add a named DOMHighResTimeStamp (the measure) between two marks to the browser's performance timeline. */\ninterface PerformanceMeasure extends PerformanceEntry {\n    readonly detail: any;\n}\n\ndeclare var PerformanceMeasure: {\n    prototype: PerformanceMeasure;\n    new(): PerformanceMeasure;\n};\n\n/**\n * The legacy PerformanceNavigation interface represents information about how the navigation to the current document was done.\n * @deprecated This interface is deprecated in the Navigation Timing Level 2 specification. Please use the PerformanceNavigationTiming interface instead.\n */\ninterface PerformanceNavigation {\n    /** @deprecated */\n    readonly redirectCount: number;\n    /** @deprecated */\n    readonly type: number;\n    /** @deprecated */\n    toJSON(): any;\n    readonly TYPE_NAVIGATE: 0;\n    readonly TYPE_RELOAD: 1;\n    readonly TYPE_BACK_FORWARD: 2;\n    readonly TYPE_RESERVED: 255;\n}\n\n/** @deprecated */\ndeclare var PerformanceNavigation: {\n    prototype: PerformanceNavigation;\n    new(): PerformanceNavigation;\n    readonly TYPE_NAVIGATE: 0;\n    readonly TYPE_RELOAD: 1;\n    readonly TYPE_BACK_FORWARD: 2;\n    readonly TYPE_RESERVED: 255;\n};\n\n/** Provides methods and properties to store and retrieve metrics regarding the browser's document navigation events. For example, this interface can be used to determine how much time it takes to load or unload a document. */\ninterface PerformanceNavigationTiming extends PerformanceResourceTiming {\n    readonly domComplete: DOMHighResTimeStamp;\n    readonly domContentLoadedEventEnd: DOMHighResTimeStamp;\n    readonly domContentLoadedEventStart: DOMHighResTimeStamp;\n    readonly domInteractive: DOMHighResTimeStamp;\n    readonly loadEventEnd: DOMHighResTimeStamp;\n    readonly loadEventStart: DOMHighResTimeStamp;\n    readonly redirectCount: number;\n    readonly type: NavigationTimingType;\n    readonly unloadEventEnd: DOMHighResTimeStamp;\n    readonly unloadEventStart: DOMHighResTimeStamp;\n    toJSON(): any;\n}\n\ndeclare var PerformanceNavigationTiming: {\n    prototype: PerformanceNavigationTiming;\n    new(): PerformanceNavigationTiming;\n};\n\ninterface PerformanceObserver {\n    disconnect(): void;\n    observe(options?: PerformanceObserverInit): void;\n    takeRecords(): PerformanceEntryList;\n}\n\ndeclare var PerformanceObserver: {\n    prototype: PerformanceObserver;\n    new(callback: PerformanceObserverCallback): PerformanceObserver;\n    readonly supportedEntryTypes: ReadonlyArray<string>;\n};\n\ninterface PerformanceObserverEntryList {\n    getEntries(): PerformanceEntryList;\n    getEntriesByName(name: string, type?: string): PerformanceEntryList;\n    getEntriesByType(type: string): PerformanceEntryList;\n}\n\ndeclare var PerformanceObserverEntryList: {\n    prototype: PerformanceObserverEntryList;\n    new(): PerformanceObserverEntryList;\n};\n\ninterface PerformancePaintTiming extends PerformanceEntry {\n}\n\ndeclare var PerformancePaintTiming: {\n    prototype: PerformancePaintTiming;\n    new(): PerformancePaintTiming;\n};\n\n/** Enables retrieval and analysis of detailed network timing data regarding the loading of an application's resources. An application can use the timing metrics to determine, for example, the length of time it takes to fetch a specific resource, such as an XMLHttpRequest, <SVG>, image, or script. */\ninterface PerformanceResourceTiming extends PerformanceEntry {\n    readonly connectEnd: DOMHighResTimeStamp;\n    readonly connectStart: DOMHighResTimeStamp;\n    readonly decodedBodySize: number;\n    readonly domainLookupEnd: DOMHighResTimeStamp;\n    readonly domainLookupStart: DOMHighResTimeStamp;\n    readonly encodedBodySize: number;\n    readonly fetchStart: DOMHighResTimeStamp;\n    readonly initiatorType: string;\n    readonly nextHopProtocol: string;\n    readonly redirectEnd: DOMHighResTimeStamp;\n    readonly redirectStart: DOMHighResTimeStamp;\n    readonly requestStart: DOMHighResTimeStamp;\n    readonly responseEnd: DOMHighResTimeStamp;\n    readonly responseStart: DOMHighResTimeStamp;\n    readonly secureConnectionStart: DOMHighResTimeStamp;\n    readonly serverTiming: ReadonlyArray<PerformanceServerTiming>;\n    readonly transferSize: number;\n    readonly workerStart: DOMHighResTimeStamp;\n    toJSON(): any;\n}\n\ndeclare var PerformanceResourceTiming: {\n    prototype: PerformanceResourceTiming;\n    new(): PerformanceResourceTiming;\n};\n\ninterface PerformanceServerTiming {\n    readonly description: string;\n    readonly duration: DOMHighResTimeStamp;\n    readonly name: string;\n    toJSON(): any;\n}\n\ndeclare var PerformanceServerTiming: {\n    prototype: PerformanceServerTiming;\n    new(): PerformanceServerTiming;\n};\n\n/**\n * A legacy interface kept for backwards compatibility and contains properties that offer performance timing information for various events which occur during the loading and use of the current page. You get a PerformanceTiming object describing your page using the window.performance.timing property.\n * @deprecated This interface is deprecated in the Navigation Timing Level 2 specification. Please use the PerformanceNavigationTiming interface instead.\n */\ninterface PerformanceTiming {\n    /** @deprecated */\n    readonly connectEnd: number;\n    /** @deprecated */\n    readonly connectStart: number;\n    /** @deprecated */\n    readonly domComplete: number;\n    /** @deprecated */\n    readonly domContentLoadedEventEnd: number;\n    /** @deprecated */\n    readonly domContentLoadedEventStart: number;\n    /** @deprecated */\n    readonly domInteractive: number;\n    /** @deprecated */\n    readonly domLoading: number;\n    /** @deprecated */\n    readonly domainLookupEnd: number;\n    /** @deprecated */\n    readonly domainLookupStart: number;\n    /** @deprecated */\n    readonly fetchStart: number;\n    /** @deprecated */\n    readonly loadEventEnd: number;\n    /** @deprecated */\n    readonly loadEventStart: number;\n    /** @deprecated */\n    readonly navigationStart: number;\n    /** @deprecated */\n    readonly redirectEnd: number;\n    /** @deprecated */\n    readonly redirectStart: number;\n    /** @deprecated */\n    readonly requestStart: number;\n    /** @deprecated */\n    readonly responseEnd: number;\n    /** @deprecated */\n    readonly responseStart: number;\n    /** @deprecated */\n    readonly secureConnectionStart: number;\n    /** @deprecated */\n    readonly unloadEventEnd: number;\n    /** @deprecated */\n    readonly unloadEventStart: number;\n    /** @deprecated */\n    toJSON(): any;\n}\n\n/** @deprecated */\ndeclare var PerformanceTiming: {\n    prototype: PerformanceTiming;\n    new(): PerformanceTiming;\n};\n\n/** PeriodicWave has no inputs or outputs; it is used to define custom oscillators when calling OscillatorNode.setPeriodicWave(). The PeriodicWave itself is created/returned by AudioContext.createPeriodicWave(). */\ninterface PeriodicWave {\n}\n\ndeclare var PeriodicWave: {\n    prototype: PeriodicWave;\n    new(context: BaseAudioContext, options?: PeriodicWaveOptions): PeriodicWave;\n};\n\ninterface PermissionStatusEventMap {\n    \"change\": Event;\n}\n\ninterface PermissionStatus extends EventTarget {\n    readonly name: string;\n    onchange: ((this: PermissionStatus, ev: Event) => any) | null;\n    readonly state: PermissionState;\n    addEventListener<K extends keyof PermissionStatusEventMap>(type: K, listener: (this: PermissionStatus, ev: PermissionStatusEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof PermissionStatusEventMap>(type: K, listener: (this: PermissionStatus, ev: PermissionStatusEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var PermissionStatus: {\n    prototype: PermissionStatus;\n    new(): PermissionStatus;\n};\n\ninterface Permissions {\n    query(permissionDesc: PermissionDescriptor): Promise<PermissionStatus>;\n}\n\ndeclare var Permissions: {\n    prototype: Permissions;\n    new(): Permissions;\n};\n\ninterface PictureInPictureEvent extends Event {\n    readonly pictureInPictureWindow: PictureInPictureWindow;\n}\n\ndeclare var PictureInPictureEvent: {\n    prototype: PictureInPictureEvent;\n    new(type: string, eventInitDict: PictureInPictureEventInit): PictureInPictureEvent;\n};\n\ninterface PictureInPictureWindowEventMap {\n    \"resize\": Event;\n}\n\ninterface PictureInPictureWindow extends EventTarget {\n    readonly height: number;\n    onresize: ((this: PictureInPictureWindow, ev: Event) => any) | null;\n    readonly width: number;\n    addEventListener<K extends keyof PictureInPictureWindowEventMap>(type: K, listener: (this: PictureInPictureWindow, ev: PictureInPictureWindowEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof PictureInPictureWindowEventMap>(type: K, listener: (this: PictureInPictureWindow, ev: PictureInPictureWindowEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var PictureInPictureWindow: {\n    prototype: PictureInPictureWindow;\n    new(): PictureInPictureWindow;\n};\n\n/**\n * Provides information about a browser plugin.\n * @deprecated\n */\ninterface Plugin {\n    /**\n     * Returns the plugin's description.\n     * @deprecated\n     */\n    readonly description: string;\n    /**\n     * Returns the plugin library's filename, if applicable on the current platform.\n     * @deprecated\n     */\n    readonly filename: string;\n    /**\n     * Returns the number of MIME types, represented by MimeType objects, supported by the plugin.\n     * @deprecated\n     */\n    readonly length: number;\n    /**\n     * Returns the plugin's name.\n     * @deprecated\n     */\n    readonly name: string;\n    /**\n     * Returns the specified MimeType object.\n     * @deprecated\n     */\n    item(index: number): MimeType | null;\n    /** @deprecated */\n    namedItem(name: string): MimeType | null;\n    [index: number]: MimeType;\n}\n\n/** @deprecated */\ndeclare var Plugin: {\n    prototype: Plugin;\n    new(): Plugin;\n};\n\n/**\n * Used to store a list of Plugin objects describing the available plugins; it's returned by the window.navigator.plugins property. The PluginArray is not a JavaScript array, but has the length property and supports accessing individual items using bracket notation (plugins[2]), as well as via item(index) and namedItem(\"name\") methods.\n * @deprecated\n */\ninterface PluginArray {\n    /** @deprecated */\n    readonly length: number;\n    /** @deprecated */\n    item(index: number): Plugin | null;\n    /** @deprecated */\n    namedItem(name: string): Plugin | null;\n    /** @deprecated */\n    refresh(): void;\n    [index: number]: Plugin;\n}\n\n/** @deprecated */\ndeclare var PluginArray: {\n    prototype: PluginArray;\n    new(): PluginArray;\n};\n\n/** The state of a DOM event produced by a pointer such as the geometry of the contact point, the device type that generated the event, the amount of pressure that was applied on the contact surface, etc. */\ninterface PointerEvent extends MouseEvent {\n    readonly height: number;\n    readonly isPrimary: boolean;\n    readonly pointerId: number;\n    readonly pointerType: string;\n    readonly pressure: number;\n    readonly tangentialPressure: number;\n    readonly tiltX: number;\n    readonly tiltY: number;\n    readonly twist: number;\n    readonly width: number;\n    /** Available only in secure contexts. */\n    getCoalescedEvents(): PointerEvent[];\n    getPredictedEvents(): PointerEvent[];\n}\n\ndeclare var PointerEvent: {\n    prototype: PointerEvent;\n    new(type: string, eventInitDict?: PointerEventInit): PointerEvent;\n};\n\n/** PopStateEvent is an event handler for the popstate event on the window. */\ninterface PopStateEvent extends Event {\n    /** Returns a copy of the information that was provided to pushState() or replaceState(). */\n    readonly state: any;\n}\n\ndeclare var PopStateEvent: {\n    prototype: PopStateEvent;\n    new(type: string, eventInitDict?: PopStateEventInit): PopStateEvent;\n};\n\n/** A processing instruction embeds application-specific instructions in XML which can be ignored by other applications that don't recognize them. */\ninterface ProcessingInstruction extends CharacterData, LinkStyle {\n    readonly ownerDocument: Document;\n    readonly target: string;\n}\n\ndeclare var ProcessingInstruction: {\n    prototype: ProcessingInstruction;\n    new(): ProcessingInstruction;\n};\n\n/** Events measuring progress of an underlying process, like an HTTP request (for an XMLHttpRequest, or the loading of the underlying resource of an <img>, <audio>, <video>, <style> or <link>). */\ninterface ProgressEvent<T extends EventTarget = EventTarget> extends Event {\n    readonly lengthComputable: boolean;\n    readonly loaded: number;\n    readonly target: T | null;\n    readonly total: number;\n}\n\ndeclare var ProgressEvent: {\n    prototype: ProgressEvent;\n    new(type: string, eventInitDict?: ProgressEventInit): ProgressEvent;\n};\n\ninterface PromiseRejectionEvent extends Event {\n    readonly promise: Promise<any>;\n    readonly reason: any;\n}\n\ndeclare var PromiseRejectionEvent: {\n    prototype: PromiseRejectionEvent;\n    new(type: string, eventInitDict: PromiseRejectionEventInit): PromiseRejectionEvent;\n};\n\n/** Available only in secure contexts. */\ninterface PublicKeyCredential extends Credential {\n    readonly authenticatorAttachment: string | null;\n    readonly rawId: ArrayBuffer;\n    readonly response: AuthenticatorResponse;\n    getClientExtensionResults(): AuthenticationExtensionsClientOutputs;\n}\n\ndeclare var PublicKeyCredential: {\n    prototype: PublicKeyCredential;\n    new(): PublicKeyCredential;\n    isConditionalMediationAvailable(): Promise<boolean>;\n    isUserVerifyingPlatformAuthenticatorAvailable(): Promise<boolean>;\n};\n\n/**\n * This Push API interface provides a way to receive notifications from third-party servers as well as request URLs for push notifications.\n * Available only in secure contexts.\n */\ninterface PushManager {\n    getSubscription(): Promise<PushSubscription | null>;\n    permissionState(options?: PushSubscriptionOptionsInit): Promise<PermissionState>;\n    subscribe(options?: PushSubscriptionOptionsInit): Promise<PushSubscription>;\n}\n\ndeclare var PushManager: {\n    prototype: PushManager;\n    new(): PushManager;\n    readonly supportedContentEncodings: ReadonlyArray<string>;\n};\n\n/**\n * This Push API interface provides a subcription's URL endpoint and allows unsubscription from a push service.\n * Available only in secure contexts.\n */\ninterface PushSubscription {\n    readonly endpoint: string;\n    readonly expirationTime: EpochTimeStamp | null;\n    readonly options: PushSubscriptionOptions;\n    getKey(name: PushEncryptionKeyName): ArrayBuffer | null;\n    toJSON(): PushSubscriptionJSON;\n    unsubscribe(): Promise<boolean>;\n}\n\ndeclare var PushSubscription: {\n    prototype: PushSubscription;\n    new(): PushSubscription;\n};\n\n/** Available only in secure contexts. */\ninterface PushSubscriptionOptions {\n    readonly applicationServerKey: ArrayBuffer | null;\n    readonly userVisibleOnly: boolean;\n}\n\ndeclare var PushSubscriptionOptions: {\n    prototype: PushSubscriptionOptions;\n    new(): PushSubscriptionOptions;\n};\n\ninterface RTCCertificate {\n    readonly expires: EpochTimeStamp;\n    getFingerprints(): RTCDtlsFingerprint[];\n}\n\ndeclare var RTCCertificate: {\n    prototype: RTCCertificate;\n    new(): RTCCertificate;\n};\n\ninterface RTCDTMFSenderEventMap {\n    \"tonechange\": RTCDTMFToneChangeEvent;\n}\n\ninterface RTCDTMFSender extends EventTarget {\n    readonly canInsertDTMF: boolean;\n    ontonechange: ((this: RTCDTMFSender, ev: RTCDTMFToneChangeEvent) => any) | null;\n    readonly toneBuffer: string;\n    insertDTMF(tones: string, duration?: number, interToneGap?: number): void;\n    addEventListener<K extends keyof RTCDTMFSenderEventMap>(type: K, listener: (this: RTCDTMFSender, ev: RTCDTMFSenderEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof RTCDTMFSenderEventMap>(type: K, listener: (this: RTCDTMFSender, ev: RTCDTMFSenderEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var RTCDTMFSender: {\n    prototype: RTCDTMFSender;\n    new(): RTCDTMFSender;\n};\n\n/** Events sent to indicate that DTMF tones have started or finished playing. This interface is used by the tonechange event. */\ninterface RTCDTMFToneChangeEvent extends Event {\n    readonly tone: string;\n}\n\ndeclare var RTCDTMFToneChangeEvent: {\n    prototype: RTCDTMFToneChangeEvent;\n    new(type: string, eventInitDict?: RTCDTMFToneChangeEventInit): RTCDTMFToneChangeEvent;\n};\n\ninterface RTCDataChannelEventMap {\n    \"bufferedamountlow\": Event;\n    \"close\": Event;\n    \"closing\": Event;\n    \"error\": Event;\n    \"message\": MessageEvent;\n    \"open\": Event;\n}\n\ninterface RTCDataChannel extends EventTarget {\n    binaryType: BinaryType;\n    readonly bufferedAmount: number;\n    bufferedAmountLowThreshold: number;\n    readonly id: number | null;\n    readonly label: string;\n    readonly maxPacketLifeTime: number | null;\n    readonly maxRetransmits: number | null;\n    readonly negotiated: boolean;\n    onbufferedamountlow: ((this: RTCDataChannel, ev: Event) => any) | null;\n    onclose: ((this: RTCDataChannel, ev: Event) => any) | null;\n    onclosing: ((this: RTCDataChannel, ev: Event) => any) | null;\n    onerror: ((this: RTCDataChannel, ev: Event) => any) | null;\n    onmessage: ((this: RTCDataChannel, ev: MessageEvent) => any) | null;\n    onopen: ((this: RTCDataChannel, ev: Event) => any) | null;\n    readonly ordered: boolean;\n    readonly protocol: string;\n    readonly readyState: RTCDataChannelState;\n    close(): void;\n    send(data: string): void;\n    send(data: Blob): void;\n    send(data: ArrayBuffer): void;\n    send(data: ArrayBufferView): void;\n    addEventListener<K extends keyof RTCDataChannelEventMap>(type: K, listener: (this: RTCDataChannel, ev: RTCDataChannelEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof RTCDataChannelEventMap>(type: K, listener: (this: RTCDataChannel, ev: RTCDataChannelEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var RTCDataChannel: {\n    prototype: RTCDataChannel;\n    new(): RTCDataChannel;\n};\n\ninterface RTCDataChannelEvent extends Event {\n    readonly channel: RTCDataChannel;\n}\n\ndeclare var RTCDataChannelEvent: {\n    prototype: RTCDataChannelEvent;\n    new(type: string, eventInitDict: RTCDataChannelEventInit): RTCDataChannelEvent;\n};\n\ninterface RTCDtlsTransportEventMap {\n    \"error\": Event;\n    \"statechange\": Event;\n}\n\ninterface RTCDtlsTransport extends EventTarget {\n    readonly iceTransport: RTCIceTransport;\n    onerror: ((this: RTCDtlsTransport, ev: Event) => any) | null;\n    onstatechange: ((this: RTCDtlsTransport, ev: Event) => any) | null;\n    readonly state: RTCDtlsTransportState;\n    getRemoteCertificates(): ArrayBuffer[];\n    addEventListener<K extends keyof RTCDtlsTransportEventMap>(type: K, listener: (this: RTCDtlsTransport, ev: RTCDtlsTransportEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof RTCDtlsTransportEventMap>(type: K, listener: (this: RTCDtlsTransport, ev: RTCDtlsTransportEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var RTCDtlsTransport: {\n    prototype: RTCDtlsTransport;\n    new(): RTCDtlsTransport;\n};\n\ninterface RTCEncodedAudioFrame {\n    data: ArrayBuffer;\n    readonly timestamp: number;\n    getMetadata(): RTCEncodedAudioFrameMetadata;\n}\n\ndeclare var RTCEncodedAudioFrame: {\n    prototype: RTCEncodedAudioFrame;\n    new(): RTCEncodedAudioFrame;\n};\n\ninterface RTCEncodedVideoFrame {\n    data: ArrayBuffer;\n    readonly timestamp: number;\n    readonly type: RTCEncodedVideoFrameType;\n    getMetadata(): RTCEncodedVideoFrameMetadata;\n}\n\ndeclare var RTCEncodedVideoFrame: {\n    prototype: RTCEncodedVideoFrame;\n    new(): RTCEncodedVideoFrame;\n};\n\ninterface RTCError extends DOMException {\n    readonly errorDetail: RTCErrorDetailType;\n    readonly receivedAlert: number | null;\n    readonly sctpCauseCode: number | null;\n    readonly sdpLineNumber: number | null;\n    readonly sentAlert: number | null;\n}\n\ndeclare var RTCError: {\n    prototype: RTCError;\n    new(init: RTCErrorInit, message?: string): RTCError;\n};\n\ninterface RTCErrorEvent extends Event {\n    readonly error: RTCError;\n}\n\ndeclare var RTCErrorEvent: {\n    prototype: RTCErrorEvent;\n    new(type: string, eventInitDict: RTCErrorEventInit): RTCErrorEvent;\n};\n\n/** The RTCIceCandidate interface—part of the WebRTC API—represents a candidate Internet Connectivity Establishment (ICE) configuration which may be used to establish an RTCPeerConnection. */\ninterface RTCIceCandidate {\n    readonly address: string | null;\n    readonly candidate: string;\n    readonly component: RTCIceComponent | null;\n    readonly foundation: string | null;\n    readonly port: number | null;\n    readonly priority: number | null;\n    readonly protocol: RTCIceProtocol | null;\n    readonly relatedAddress: string | null;\n    readonly relatedPort: number | null;\n    readonly sdpMLineIndex: number | null;\n    readonly sdpMid: string | null;\n    readonly tcpType: RTCIceTcpCandidateType | null;\n    readonly type: RTCIceCandidateType | null;\n    readonly usernameFragment: string | null;\n    toJSON(): RTCIceCandidateInit;\n}\n\ndeclare var RTCIceCandidate: {\n    prototype: RTCIceCandidate;\n    new(candidateInitDict?: RTCIceCandidateInit): RTCIceCandidate;\n};\n\ninterface RTCIceTransportEventMap {\n    \"gatheringstatechange\": Event;\n    \"statechange\": Event;\n}\n\n/** Provides access to information about the ICE transport layer over which the data is being sent and received. */\ninterface RTCIceTransport extends EventTarget {\n    readonly gatheringState: RTCIceGathererState;\n    ongatheringstatechange: ((this: RTCIceTransport, ev: Event) => any) | null;\n    onstatechange: ((this: RTCIceTransport, ev: Event) => any) | null;\n    readonly state: RTCIceTransportState;\n    addEventListener<K extends keyof RTCIceTransportEventMap>(type: K, listener: (this: RTCIceTransport, ev: RTCIceTransportEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof RTCIceTransportEventMap>(type: K, listener: (this: RTCIceTransport, ev: RTCIceTransportEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var RTCIceTransport: {\n    prototype: RTCIceTransport;\n    new(): RTCIceTransport;\n};\n\ninterface RTCPeerConnectionEventMap {\n    \"connectionstatechange\": Event;\n    \"datachannel\": RTCDataChannelEvent;\n    \"icecandidate\": RTCPeerConnectionIceEvent;\n    \"icecandidateerror\": Event;\n    \"iceconnectionstatechange\": Event;\n    \"icegatheringstatechange\": Event;\n    \"negotiationneeded\": Event;\n    \"signalingstatechange\": Event;\n    \"track\": RTCTrackEvent;\n}\n\n/** A WebRTC connection between the local computer and a remote peer. It provides methods to connect to a remote peer, maintain and monitor the connection, and close the connection once it's no longer needed. */\ninterface RTCPeerConnection extends EventTarget {\n    readonly canTrickleIceCandidates: boolean | null;\n    readonly connectionState: RTCPeerConnectionState;\n    readonly currentLocalDescription: RTCSessionDescription | null;\n    readonly currentRemoteDescription: RTCSessionDescription | null;\n    readonly iceConnectionState: RTCIceConnectionState;\n    readonly iceGatheringState: RTCIceGatheringState;\n    readonly localDescription: RTCSessionDescription | null;\n    onconnectionstatechange: ((this: RTCPeerConnection, ev: Event) => any) | null;\n    ondatachannel: ((this: RTCPeerConnection, ev: RTCDataChannelEvent) => any) | null;\n    onicecandidate: ((this: RTCPeerConnection, ev: RTCPeerConnectionIceEvent) => any) | null;\n    onicecandidateerror: ((this: RTCPeerConnection, ev: Event) => any) | null;\n    oniceconnectionstatechange: ((this: RTCPeerConnection, ev: Event) => any) | null;\n    onicegatheringstatechange: ((this: RTCPeerConnection, ev: Event) => any) | null;\n    onnegotiationneeded: ((this: RTCPeerConnection, ev: Event) => any) | null;\n    onsignalingstatechange: ((this: RTCPeerConnection, ev: Event) => any) | null;\n    ontrack: ((this: RTCPeerConnection, ev: RTCTrackEvent) => any) | null;\n    readonly pendingLocalDescription: RTCSessionDescription | null;\n    readonly pendingRemoteDescription: RTCSessionDescription | null;\n    readonly remoteDescription: RTCSessionDescription | null;\n    readonly sctp: RTCSctpTransport | null;\n    readonly signalingState: RTCSignalingState;\n    addIceCandidate(candidate?: RTCIceCandidateInit): Promise<void>;\n    /** @deprecated */\n    addIceCandidate(candidate: RTCIceCandidateInit, successCallback: VoidFunction, failureCallback: RTCPeerConnectionErrorCallback): Promise<void>;\n    addTrack(track: MediaStreamTrack, ...streams: MediaStream[]): RTCRtpSender;\n    addTransceiver(trackOrKind: MediaStreamTrack | string, init?: RTCRtpTransceiverInit): RTCRtpTransceiver;\n    close(): void;\n    createAnswer(options?: RTCAnswerOptions): Promise<RTCSessionDescriptionInit>;\n    /** @deprecated */\n    createAnswer(successCallback: RTCSessionDescriptionCallback, failureCallback: RTCPeerConnectionErrorCallback): Promise<void>;\n    createDataChannel(label: string, dataChannelDict?: RTCDataChannelInit): RTCDataChannel;\n    createOffer(options?: RTCOfferOptions): Promise<RTCSessionDescriptionInit>;\n    /** @deprecated */\n    createOffer(successCallback: RTCSessionDescriptionCallback, failureCallback: RTCPeerConnectionErrorCallback, options?: RTCOfferOptions): Promise<void>;\n    getConfiguration(): RTCConfiguration;\n    getReceivers(): RTCRtpReceiver[];\n    getSenders(): RTCRtpSender[];\n    getStats(selector?: MediaStreamTrack | null): Promise<RTCStatsReport>;\n    getTransceivers(): RTCRtpTransceiver[];\n    removeTrack(sender: RTCRtpSender): void;\n    restartIce(): void;\n    setConfiguration(configuration?: RTCConfiguration): void;\n    setLocalDescription(description?: RTCLocalSessionDescriptionInit): Promise<void>;\n    /** @deprecated */\n    setLocalDescription(description: RTCLocalSessionDescriptionInit, successCallback: VoidFunction, failureCallback: RTCPeerConnectionErrorCallback): Promise<void>;\n    setRemoteDescription(description: RTCSessionDescriptionInit): Promise<void>;\n    /** @deprecated */\n    setRemoteDescription(description: RTCSessionDescriptionInit, successCallback: VoidFunction, failureCallback: RTCPeerConnectionErrorCallback): Promise<void>;\n    addEventListener<K extends keyof RTCPeerConnectionEventMap>(type: K, listener: (this: RTCPeerConnection, ev: RTCPeerConnectionEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof RTCPeerConnectionEventMap>(type: K, listener: (this: RTCPeerConnection, ev: RTCPeerConnectionEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var RTCPeerConnection: {\n    prototype: RTCPeerConnection;\n    new(configuration?: RTCConfiguration): RTCPeerConnection;\n    generateCertificate(keygenAlgorithm: AlgorithmIdentifier): Promise<RTCCertificate>;\n};\n\ninterface RTCPeerConnectionIceErrorEvent extends Event {\n    readonly address: string | null;\n    readonly errorCode: number;\n    readonly errorText: string;\n    readonly port: number | null;\n    readonly url: string;\n}\n\ndeclare var RTCPeerConnectionIceErrorEvent: {\n    prototype: RTCPeerConnectionIceErrorEvent;\n    new(type: string, eventInitDict: RTCPeerConnectionIceErrorEventInit): RTCPeerConnectionIceErrorEvent;\n};\n\n/** Events that occurs in relation to ICE candidates with the target, usually an RTCPeerConnection. Only one event is of this type: icecandidate. */\ninterface RTCPeerConnectionIceEvent extends Event {\n    readonly candidate: RTCIceCandidate | null;\n}\n\ndeclare var RTCPeerConnectionIceEvent: {\n    prototype: RTCPeerConnectionIceEvent;\n    new(type: string, eventInitDict?: RTCPeerConnectionIceEventInit): RTCPeerConnectionIceEvent;\n};\n\n/** This WebRTC API interface manages the reception and decoding of data for a MediaStreamTrack on an RTCPeerConnection. */\ninterface RTCRtpReceiver {\n    readonly track: MediaStreamTrack;\n    readonly transport: RTCDtlsTransport | null;\n    getContributingSources(): RTCRtpContributingSource[];\n    getParameters(): RTCRtpReceiveParameters;\n    getStats(): Promise<RTCStatsReport>;\n    getSynchronizationSources(): RTCRtpSynchronizationSource[];\n}\n\ndeclare var RTCRtpReceiver: {\n    prototype: RTCRtpReceiver;\n    new(): RTCRtpReceiver;\n    getCapabilities(kind: string): RTCRtpCapabilities | null;\n};\n\n/** Provides the ability to control and obtain details about how a particular MediaStreamTrack is encoded and sent to a remote peer. */\ninterface RTCRtpSender {\n    readonly dtmf: RTCDTMFSender | null;\n    readonly track: MediaStreamTrack | null;\n    readonly transport: RTCDtlsTransport | null;\n    getParameters(): RTCRtpSendParameters;\n    getStats(): Promise<RTCStatsReport>;\n    replaceTrack(withTrack: MediaStreamTrack | null): Promise<void>;\n    setParameters(parameters: RTCRtpSendParameters): Promise<void>;\n    setStreams(...streams: MediaStream[]): void;\n}\n\ndeclare var RTCRtpSender: {\n    prototype: RTCRtpSender;\n    new(): RTCRtpSender;\n    getCapabilities(kind: string): RTCRtpCapabilities | null;\n};\n\ninterface RTCRtpTransceiver {\n    readonly currentDirection: RTCRtpTransceiverDirection | null;\n    direction: RTCRtpTransceiverDirection;\n    readonly mid: string | null;\n    readonly receiver: RTCRtpReceiver;\n    readonly sender: RTCRtpSender;\n    setCodecPreferences(codecs: RTCRtpCodecCapability[]): void;\n    stop(): void;\n}\n\ndeclare var RTCRtpTransceiver: {\n    prototype: RTCRtpTransceiver;\n    new(): RTCRtpTransceiver;\n};\n\ninterface RTCSctpTransportEventMap {\n    \"statechange\": Event;\n}\n\ninterface RTCSctpTransport extends EventTarget {\n    readonly maxChannels: number | null;\n    readonly maxMessageSize: number;\n    onstatechange: ((this: RTCSctpTransport, ev: Event) => any) | null;\n    readonly state: RTCSctpTransportState;\n    readonly transport: RTCDtlsTransport;\n    addEventListener<K extends keyof RTCSctpTransportEventMap>(type: K, listener: (this: RTCSctpTransport, ev: RTCSctpTransportEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof RTCSctpTransportEventMap>(type: K, listener: (this: RTCSctpTransport, ev: RTCSctpTransportEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var RTCSctpTransport: {\n    prototype: RTCSctpTransport;\n    new(): RTCSctpTransport;\n};\n\n/** One end of a connection—or potential connection—and how it's configured. Each RTCSessionDescription consists of a description type indicating which part of the offer/answer negotiation process it describes and of the SDP descriptor of the session. */\ninterface RTCSessionDescription {\n    readonly sdp: string;\n    readonly type: RTCSdpType;\n    toJSON(): any;\n}\n\ndeclare var RTCSessionDescription: {\n    prototype: RTCSessionDescription;\n    new(descriptionInitDict: RTCSessionDescriptionInit): RTCSessionDescription;\n};\n\ninterface RTCStatsReport {\n    forEach(callbackfn: (value: any, key: string, parent: RTCStatsReport) => void, thisArg?: any): void;\n}\n\ndeclare var RTCStatsReport: {\n    prototype: RTCStatsReport;\n    new(): RTCStatsReport;\n};\n\ninterface RTCTrackEvent extends Event {\n    readonly receiver: RTCRtpReceiver;\n    readonly streams: ReadonlyArray<MediaStream>;\n    readonly track: MediaStreamTrack;\n    readonly transceiver: RTCRtpTransceiver;\n}\n\ndeclare var RTCTrackEvent: {\n    prototype: RTCTrackEvent;\n    new(type: string, eventInitDict: RTCTrackEventInit): RTCTrackEvent;\n};\n\ninterface RadioNodeList extends NodeList {\n    value: string;\n}\n\ndeclare var RadioNodeList: {\n    prototype: RadioNodeList;\n    new(): RadioNodeList;\n};\n\n/** A fragment of a document that can contain nodes and parts of text nodes. */\ninterface Range extends AbstractRange {\n    /** Returns the node, furthest away from the document, that is an ancestor of both range's start node and end node. */\n    readonly commonAncestorContainer: Node;\n    cloneContents(): DocumentFragment;\n    cloneRange(): Range;\n    collapse(toStart?: boolean): void;\n    compareBoundaryPoints(how: number, sourceRange: Range): number;\n    /** Returns −1 if the point is before the range, 0 if the point is in the range, and 1 if the point is after the range. */\n    comparePoint(node: Node, offset: number): number;\n    createContextualFragment(fragment: string): DocumentFragment;\n    deleteContents(): void;\n    detach(): void;\n    extractContents(): DocumentFragment;\n    getBoundingClientRect(): DOMRect;\n    getClientRects(): DOMRectList;\n    insertNode(node: Node): void;\n    /** Returns whether range intersects node. */\n    intersectsNode(node: Node): boolean;\n    isPointInRange(node: Node, offset: number): boolean;\n    selectNode(node: Node): void;\n    selectNodeContents(node: Node): void;\n    setEnd(node: Node, offset: number): void;\n    setEndAfter(node: Node): void;\n    setEndBefore(node: Node): void;\n    setStart(node: Node, offset: number): void;\n    setStartAfter(node: Node): void;\n    setStartBefore(node: Node): void;\n    surroundContents(newParent: Node): void;\n    toString(): string;\n    readonly START_TO_START: 0;\n    readonly START_TO_END: 1;\n    readonly END_TO_END: 2;\n    readonly END_TO_START: 3;\n}\n\ndeclare var Range: {\n    prototype: Range;\n    new(): Range;\n    readonly START_TO_START: 0;\n    readonly START_TO_END: 1;\n    readonly END_TO_END: 2;\n    readonly END_TO_START: 3;\n    toString(): string;\n};\n\ninterface ReadableByteStreamController {\n    readonly byobRequest: ReadableStreamBYOBRequest | null;\n    readonly desiredSize: number | null;\n    close(): void;\n    enqueue(chunk: ArrayBufferView): void;\n    error(e?: any): void;\n}\n\ndeclare var ReadableByteStreamController: {\n    prototype: ReadableByteStreamController;\n    new(): ReadableByteStreamController;\n};\n\n/** This Streams API interface represents a readable stream of byte data. The Fetch API offers a concrete instance of a ReadableStream through the body property of a Response object. */\ninterface ReadableStream<R = any> {\n    readonly locked: boolean;\n    cancel(reason?: any): Promise<void>;\n    getReader(options: { mode: \"byob\" }): ReadableStreamBYOBReader;\n    getReader(): ReadableStreamDefaultReader<R>;\n    getReader(options?: ReadableStreamGetReaderOptions): ReadableStreamReader<R>;\n    pipeThrough<T>(transform: ReadableWritablePair<T, R>, options?: StreamPipeOptions): ReadableStream<T>;\n    pipeTo(destination: WritableStream<R>, options?: StreamPipeOptions): Promise<void>;\n    tee(): [ReadableStream<R>, ReadableStream<R>];\n}\n\ndeclare var ReadableStream: {\n    prototype: ReadableStream;\n    new(underlyingSource: UnderlyingByteSource, strategy?: { highWaterMark?: number }): ReadableStream<Uint8Array>;\n    new<R = any>(underlyingSource: UnderlyingDefaultSource<R>, strategy?: QueuingStrategy<R>): ReadableStream<R>;\n    new<R = any>(underlyingSource?: UnderlyingSource<R>, strategy?: QueuingStrategy<R>): ReadableStream<R>;\n};\n\ninterface ReadableStreamBYOBReader extends ReadableStreamGenericReader {\n    read<T extends ArrayBufferView>(view: T): Promise<ReadableStreamReadResult<T>>;\n    releaseLock(): void;\n}\n\ndeclare var ReadableStreamBYOBReader: {\n    prototype: ReadableStreamBYOBReader;\n    new(stream: ReadableStream): ReadableStreamBYOBReader;\n};\n\ninterface ReadableStreamBYOBRequest {\n    readonly view: ArrayBufferView | null;\n    respond(bytesWritten: number): void;\n    respondWithNewView(view: ArrayBufferView): void;\n}\n\ndeclare var ReadableStreamBYOBRequest: {\n    prototype: ReadableStreamBYOBRequest;\n    new(): ReadableStreamBYOBRequest;\n};\n\ninterface ReadableStreamDefaultController<R = any> {\n    readonly desiredSize: number | null;\n    close(): void;\n    enqueue(chunk?: R): void;\n    error(e?: any): void;\n}\n\ndeclare var ReadableStreamDefaultController: {\n    prototype: ReadableStreamDefaultController;\n    new(): ReadableStreamDefaultController;\n};\n\ninterface ReadableStreamDefaultReader<R = any> extends ReadableStreamGenericReader {\n    read(): Promise<ReadableStreamReadResult<R>>;\n    releaseLock(): void;\n}\n\ndeclare var ReadableStreamDefaultReader: {\n    prototype: ReadableStreamDefaultReader;\n    new<R = any>(stream: ReadableStream<R>): ReadableStreamDefaultReader<R>;\n};\n\ninterface ReadableStreamGenericReader {\n    readonly closed: Promise<undefined>;\n    cancel(reason?: any): Promise<void>;\n}\n\ninterface RemotePlaybackEventMap {\n    \"connect\": Event;\n    \"connecting\": Event;\n    \"disconnect\": Event;\n}\n\ninterface RemotePlayback extends EventTarget {\n    onconnect: ((this: RemotePlayback, ev: Event) => any) | null;\n    onconnecting: ((this: RemotePlayback, ev: Event) => any) | null;\n    ondisconnect: ((this: RemotePlayback, ev: Event) => any) | null;\n    readonly state: RemotePlaybackState;\n    cancelWatchAvailability(id?: number): Promise<void>;\n    prompt(): Promise<void>;\n    watchAvailability(callback: RemotePlaybackAvailabilityCallback): Promise<number>;\n    addEventListener<K extends keyof RemotePlaybackEventMap>(type: K, listener: (this: RemotePlayback, ev: RemotePlaybackEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof RemotePlaybackEventMap>(type: K, listener: (this: RemotePlayback, ev: RemotePlaybackEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var RemotePlayback: {\n    prototype: RemotePlayback;\n    new(): RemotePlayback;\n};\n\n/** This Fetch API interface represents a resource request. */\ninterface Request extends Body {\n    /** Returns the cache mode associated with request, which is a string indicating how the request will interact with the browser's cache when fetching. */\n    readonly cache: RequestCache;\n    /** Returns the credentials mode associated with request, which is a string indicating whether credentials will be sent with the request always, never, or only when sent to a same-origin URL. */\n    readonly credentials: RequestCredentials;\n    /** Returns the kind of resource requested by request, e.g., \"document\" or \"script\". */\n    readonly destination: RequestDestination;\n    /** Returns a Headers object consisting of the headers associated with request. Note that headers added in the network layer by the user agent will not be accounted for in this object, e.g., the \"Host\" header. */\n    readonly headers: Headers;\n    /** Returns request's subresource integrity metadata, which is a cryptographic hash of the resource being fetched. Its value consists of multiple hashes separated by whitespace. [SRI] */\n    readonly integrity: string;\n    /** Returns a boolean indicating whether or not request can outlive the global in which it was created. */\n    readonly keepalive: boolean;\n    /** Returns request's HTTP method, which is \"GET\" by default. */\n    readonly method: string;\n    /** Returns the mode associated with request, which is a string indicating whether the request will use CORS, or will be restricted to same-origin URLs. */\n    readonly mode: RequestMode;\n    /** Returns the redirect mode associated with request, which is a string indicating how redirects for the request will be handled during fetching. A request will follow redirects by default. */\n    readonly redirect: RequestRedirect;\n    /** Returns the referrer of request. Its value can be a same-origin URL if explicitly set in init, the empty string to indicate no referrer, and \"about:client\" when defaulting to the global's default. This is used during fetching to determine the value of the `Referer` header of the request being made. */\n    readonly referrer: string;\n    /** Returns the referrer policy associated with request. This is used during fetching to compute the value of the request's referrer. */\n    readonly referrerPolicy: ReferrerPolicy;\n    /** Returns the signal associated with request, which is an AbortSignal object indicating whether or not request has been aborted, and its abort event handler. */\n    readonly signal: AbortSignal;\n    /** Returns the URL of request as a string. */\n    readonly url: string;\n    clone(): Request;\n}\n\ndeclare var Request: {\n    prototype: Request;\n    new(input: RequestInfo | URL, init?: RequestInit): Request;\n};\n\ninterface ResizeObserver {\n    disconnect(): void;\n    observe(target: Element, options?: ResizeObserverOptions): void;\n    unobserve(target: Element): void;\n}\n\ndeclare var ResizeObserver: {\n    prototype: ResizeObserver;\n    new(callback: ResizeObserverCallback): ResizeObserver;\n};\n\ninterface ResizeObserverEntry {\n    readonly borderBoxSize: ReadonlyArray<ResizeObserverSize>;\n    readonly contentBoxSize: ReadonlyArray<ResizeObserverSize>;\n    readonly contentRect: DOMRectReadOnly;\n    readonly devicePixelContentBoxSize: ReadonlyArray<ResizeObserverSize>;\n    readonly target: Element;\n}\n\ndeclare var ResizeObserverEntry: {\n    prototype: ResizeObserverEntry;\n    new(): ResizeObserverEntry;\n};\n\ninterface ResizeObserverSize {\n    readonly blockSize: number;\n    readonly inlineSize: number;\n}\n\ndeclare var ResizeObserverSize: {\n    prototype: ResizeObserverSize;\n    new(): ResizeObserverSize;\n};\n\n/** This Fetch API interface represents the response to a request. */\ninterface Response extends Body {\n    readonly headers: Headers;\n    readonly ok: boolean;\n    readonly redirected: boolean;\n    readonly status: number;\n    readonly statusText: string;\n    readonly type: ResponseType;\n    readonly url: string;\n    clone(): Response;\n}\n\ndeclare var Response: {\n    prototype: Response;\n    new(body?: BodyInit | null, init?: ResponseInit): Response;\n    error(): Response;\n    redirect(url: string | URL, status?: number): Response;\n};\n\n/** Provides access to the properties of <a> element, as well as methods to manipulate them. */\ninterface SVGAElement extends SVGGraphicsElement, SVGURIReference {\n    rel: string;\n    readonly relList: DOMTokenList;\n    readonly target: SVGAnimatedString;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGAElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGAElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGAElement: {\n    prototype: SVGAElement;\n    new(): SVGAElement;\n};\n\n/** Used to represent a value that can be an <angle> or <number> value. An SVGAngle reflected through the animVal attribute is always read only. */\ninterface SVGAngle {\n    readonly unitType: number;\n    value: number;\n    valueAsString: string;\n    valueInSpecifiedUnits: number;\n    convertToSpecifiedUnits(unitType: number): void;\n    newValueSpecifiedUnits(unitType: number, valueInSpecifiedUnits: number): void;\n    readonly SVG_ANGLETYPE_UNKNOWN: 0;\n    readonly SVG_ANGLETYPE_UNSPECIFIED: 1;\n    readonly SVG_ANGLETYPE_DEG: 2;\n    readonly SVG_ANGLETYPE_RAD: 3;\n    readonly SVG_ANGLETYPE_GRAD: 4;\n}\n\ndeclare var SVGAngle: {\n    prototype: SVGAngle;\n    new(): SVGAngle;\n    readonly SVG_ANGLETYPE_UNKNOWN: 0;\n    readonly SVG_ANGLETYPE_UNSPECIFIED: 1;\n    readonly SVG_ANGLETYPE_DEG: 2;\n    readonly SVG_ANGLETYPE_RAD: 3;\n    readonly SVG_ANGLETYPE_GRAD: 4;\n};\n\ninterface SVGAnimateElement extends SVGAnimationElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGAnimateElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGAnimateElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGAnimateElement: {\n    prototype: SVGAnimateElement;\n    new(): SVGAnimateElement;\n};\n\ninterface SVGAnimateMotionElement extends SVGAnimationElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGAnimateMotionElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGAnimateMotionElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGAnimateMotionElement: {\n    prototype: SVGAnimateMotionElement;\n    new(): SVGAnimateMotionElement;\n};\n\ninterface SVGAnimateTransformElement extends SVGAnimationElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGAnimateTransformElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGAnimateTransformElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGAnimateTransformElement: {\n    prototype: SVGAnimateTransformElement;\n    new(): SVGAnimateTransformElement;\n};\n\n/** Used for attributes of basic type <angle> which can be animated. */\ninterface SVGAnimatedAngle {\n    readonly animVal: SVGAngle;\n    readonly baseVal: SVGAngle;\n}\n\ndeclare var SVGAnimatedAngle: {\n    prototype: SVGAnimatedAngle;\n    new(): SVGAnimatedAngle;\n};\n\n/** Used for attributes of type boolean which can be animated. */\ninterface SVGAnimatedBoolean {\n    readonly animVal: boolean;\n    baseVal: boolean;\n}\n\ndeclare var SVGAnimatedBoolean: {\n    prototype: SVGAnimatedBoolean;\n    new(): SVGAnimatedBoolean;\n};\n\n/** Used for attributes whose value must be a constant from a particular enumeration and which can be animated. */\ninterface SVGAnimatedEnumeration {\n    readonly animVal: number;\n    baseVal: number;\n}\n\ndeclare var SVGAnimatedEnumeration: {\n    prototype: SVGAnimatedEnumeration;\n    new(): SVGAnimatedEnumeration;\n};\n\n/** Used for attributes of basic type <integer> which can be animated. */\ninterface SVGAnimatedInteger {\n    readonly animVal: number;\n    baseVal: number;\n}\n\ndeclare var SVGAnimatedInteger: {\n    prototype: SVGAnimatedInteger;\n    new(): SVGAnimatedInteger;\n};\n\n/** Used for attributes of basic type <length> which can be animated. */\ninterface SVGAnimatedLength {\n    readonly animVal: SVGLength;\n    readonly baseVal: SVGLength;\n}\n\ndeclare var SVGAnimatedLength: {\n    prototype: SVGAnimatedLength;\n    new(): SVGAnimatedLength;\n};\n\n/** Used for attributes of type SVGLengthList which can be animated. */\ninterface SVGAnimatedLengthList {\n    readonly animVal: SVGLengthList;\n    readonly baseVal: SVGLengthList;\n}\n\ndeclare var SVGAnimatedLengthList: {\n    prototype: SVGAnimatedLengthList;\n    new(): SVGAnimatedLengthList;\n};\n\n/** Used for attributes of basic type <Number> which can be animated. */\ninterface SVGAnimatedNumber {\n    readonly animVal: number;\n    baseVal: number;\n}\n\ndeclare var SVGAnimatedNumber: {\n    prototype: SVGAnimatedNumber;\n    new(): SVGAnimatedNumber;\n};\n\n/** The SVGAnimatedNumber interface is used for attributes which take a list of numbers and which can be animated. */\ninterface SVGAnimatedNumberList {\n    readonly animVal: SVGNumberList;\n    readonly baseVal: SVGNumberList;\n}\n\ndeclare var SVGAnimatedNumberList: {\n    prototype: SVGAnimatedNumberList;\n    new(): SVGAnimatedNumberList;\n};\n\ninterface SVGAnimatedPoints {\n    readonly animatedPoints: SVGPointList;\n    readonly points: SVGPointList;\n}\n\n/** Used for attributes of type SVGPreserveAspectRatio which can be animated. */\ninterface SVGAnimatedPreserveAspectRatio {\n    readonly animVal: SVGPreserveAspectRatio;\n    readonly baseVal: SVGPreserveAspectRatio;\n}\n\ndeclare var SVGAnimatedPreserveAspectRatio: {\n    prototype: SVGAnimatedPreserveAspectRatio;\n    new(): SVGAnimatedPreserveAspectRatio;\n};\n\n/** Used for attributes of basic SVGRect which can be animated. */\ninterface SVGAnimatedRect {\n    readonly animVal: DOMRectReadOnly;\n    readonly baseVal: DOMRect;\n}\n\ndeclare var SVGAnimatedRect: {\n    prototype: SVGAnimatedRect;\n    new(): SVGAnimatedRect;\n};\n\n/** The SVGAnimatedString interface represents string attributes which can be animated from each SVG declaration. You need to create SVG attribute before doing anything else, everything should be declared inside this. */\ninterface SVGAnimatedString {\n    readonly animVal: string;\n    baseVal: string;\n}\n\ndeclare var SVGAnimatedString: {\n    prototype: SVGAnimatedString;\n    new(): SVGAnimatedString;\n};\n\n/** Used for attributes which take a list of numbers and which can be animated. */\ninterface SVGAnimatedTransformList {\n    readonly animVal: SVGTransformList;\n    readonly baseVal: SVGTransformList;\n}\n\ndeclare var SVGAnimatedTransformList: {\n    prototype: SVGAnimatedTransformList;\n    new(): SVGAnimatedTransformList;\n};\n\ninterface SVGAnimationElement extends SVGElement, SVGTests {\n    readonly targetElement: SVGElement | null;\n    beginElement(): void;\n    beginElementAt(offset: number): void;\n    endElement(): void;\n    endElementAt(offset: number): void;\n    getCurrentTime(): number;\n    getSimpleDuration(): number;\n    getStartTime(): number;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGAnimationElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGAnimationElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGAnimationElement: {\n    prototype: SVGAnimationElement;\n    new(): SVGAnimationElement;\n};\n\n/** An interface for the <circle> element. The circle element is defined by the cx and cy attributes that denote the coordinates of the centre of the circle. */\ninterface SVGCircleElement extends SVGGeometryElement {\n    readonly cx: SVGAnimatedLength;\n    readonly cy: SVGAnimatedLength;\n    readonly r: SVGAnimatedLength;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGCircleElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGCircleElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGCircleElement: {\n    prototype: SVGCircleElement;\n    new(): SVGCircleElement;\n};\n\n/** Provides access to the properties of <clipPath> elements, as well as methods to manipulate them. */\ninterface SVGClipPathElement extends SVGElement {\n    readonly clipPathUnits: SVGAnimatedEnumeration;\n    readonly transform: SVGAnimatedTransformList;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGClipPathElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGClipPathElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGClipPathElement: {\n    prototype: SVGClipPathElement;\n    new(): SVGClipPathElement;\n};\n\n/** A base interface used by the component transfer function interfaces. */\ninterface SVGComponentTransferFunctionElement extends SVGElement {\n    readonly amplitude: SVGAnimatedNumber;\n    readonly exponent: SVGAnimatedNumber;\n    readonly intercept: SVGAnimatedNumber;\n    readonly offset: SVGAnimatedNumber;\n    readonly slope: SVGAnimatedNumber;\n    readonly tableValues: SVGAnimatedNumberList;\n    readonly type: SVGAnimatedEnumeration;\n    readonly SVG_FECOMPONENTTRANSFER_TYPE_UNKNOWN: 0;\n    readonly SVG_FECOMPONENTTRANSFER_TYPE_IDENTITY: 1;\n    readonly SVG_FECOMPONENTTRANSFER_TYPE_TABLE: 2;\n    readonly SVG_FECOMPONENTTRANSFER_TYPE_DISCRETE: 3;\n    readonly SVG_FECOMPONENTTRANSFER_TYPE_LINEAR: 4;\n    readonly SVG_FECOMPONENTTRANSFER_TYPE_GAMMA: 5;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGComponentTransferFunctionElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGComponentTransferFunctionElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGComponentTransferFunctionElement: {\n    prototype: SVGComponentTransferFunctionElement;\n    new(): SVGComponentTransferFunctionElement;\n    readonly SVG_FECOMPONENTTRANSFER_TYPE_UNKNOWN: 0;\n    readonly SVG_FECOMPONENTTRANSFER_TYPE_IDENTITY: 1;\n    readonly SVG_FECOMPONENTTRANSFER_TYPE_TABLE: 2;\n    readonly SVG_FECOMPONENTTRANSFER_TYPE_DISCRETE: 3;\n    readonly SVG_FECOMPONENTTRANSFER_TYPE_LINEAR: 4;\n    readonly SVG_FECOMPONENTTRANSFER_TYPE_GAMMA: 5;\n};\n\n/** Corresponds to the <defs> element. */\ninterface SVGDefsElement extends SVGGraphicsElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGDefsElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGDefsElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGDefsElement: {\n    prototype: SVGDefsElement;\n    new(): SVGDefsElement;\n};\n\n/** Corresponds to the <desc> element. */\ninterface SVGDescElement extends SVGElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGDescElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGDescElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGDescElement: {\n    prototype: SVGDescElement;\n    new(): SVGDescElement;\n};\n\ninterface SVGElementEventMap extends ElementEventMap, GlobalEventHandlersEventMap {\n}\n\n/** All of the SVG DOM interfaces that correspond directly to elements in the SVG language derive from the SVGElement interface. */\ninterface SVGElement extends Element, ElementCSSInlineStyle, GlobalEventHandlers, HTMLOrSVGElement {\n    /** @deprecated */\n    readonly className: any;\n    readonly ownerSVGElement: SVGSVGElement | null;\n    readonly viewportElement: SVGElement | null;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGElement: {\n    prototype: SVGElement;\n    new(): SVGElement;\n};\n\n/** Provides access to the properties of <ellipse> elements. */\ninterface SVGEllipseElement extends SVGGeometryElement {\n    readonly cx: SVGAnimatedLength;\n    readonly cy: SVGAnimatedLength;\n    readonly rx: SVGAnimatedLength;\n    readonly ry: SVGAnimatedLength;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGEllipseElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGEllipseElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGEllipseElement: {\n    prototype: SVGEllipseElement;\n    new(): SVGEllipseElement;\n};\n\n/** Corresponds to the <feBlend> element. */\ninterface SVGFEBlendElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly in1: SVGAnimatedString;\n    readonly in2: SVGAnimatedString;\n    readonly mode: SVGAnimatedEnumeration;\n    readonly SVG_FEBLEND_MODE_UNKNOWN: 0;\n    readonly SVG_FEBLEND_MODE_NORMAL: 1;\n    readonly SVG_FEBLEND_MODE_MULTIPLY: 2;\n    readonly SVG_FEBLEND_MODE_SCREEN: 3;\n    readonly SVG_FEBLEND_MODE_DARKEN: 4;\n    readonly SVG_FEBLEND_MODE_LIGHTEN: 5;\n    readonly SVG_FEBLEND_MODE_OVERLAY: 6;\n    readonly SVG_FEBLEND_MODE_COLOR_DODGE: 7;\n    readonly SVG_FEBLEND_MODE_COLOR_BURN: 8;\n    readonly SVG_FEBLEND_MODE_HARD_LIGHT: 9;\n    readonly SVG_FEBLEND_MODE_SOFT_LIGHT: 10;\n    readonly SVG_FEBLEND_MODE_DIFFERENCE: 11;\n    readonly SVG_FEBLEND_MODE_EXCLUSION: 12;\n    readonly SVG_FEBLEND_MODE_HUE: 13;\n    readonly SVG_FEBLEND_MODE_SATURATION: 14;\n    readonly SVG_FEBLEND_MODE_COLOR: 15;\n    readonly SVG_FEBLEND_MODE_LUMINOSITY: 16;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEBlendElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEBlendElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEBlendElement: {\n    prototype: SVGFEBlendElement;\n    new(): SVGFEBlendElement;\n    readonly SVG_FEBLEND_MODE_UNKNOWN: 0;\n    readonly SVG_FEBLEND_MODE_NORMAL: 1;\n    readonly SVG_FEBLEND_MODE_MULTIPLY: 2;\n    readonly SVG_FEBLEND_MODE_SCREEN: 3;\n    readonly SVG_FEBLEND_MODE_DARKEN: 4;\n    readonly SVG_FEBLEND_MODE_LIGHTEN: 5;\n    readonly SVG_FEBLEND_MODE_OVERLAY: 6;\n    readonly SVG_FEBLEND_MODE_COLOR_DODGE: 7;\n    readonly SVG_FEBLEND_MODE_COLOR_BURN: 8;\n    readonly SVG_FEBLEND_MODE_HARD_LIGHT: 9;\n    readonly SVG_FEBLEND_MODE_SOFT_LIGHT: 10;\n    readonly SVG_FEBLEND_MODE_DIFFERENCE: 11;\n    readonly SVG_FEBLEND_MODE_EXCLUSION: 12;\n    readonly SVG_FEBLEND_MODE_HUE: 13;\n    readonly SVG_FEBLEND_MODE_SATURATION: 14;\n    readonly SVG_FEBLEND_MODE_COLOR: 15;\n    readonly SVG_FEBLEND_MODE_LUMINOSITY: 16;\n};\n\n/** Corresponds to the <feColorMatrix> element. */\ninterface SVGFEColorMatrixElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly in1: SVGAnimatedString;\n    readonly type: SVGAnimatedEnumeration;\n    readonly values: SVGAnimatedNumberList;\n    readonly SVG_FECOLORMATRIX_TYPE_UNKNOWN: 0;\n    readonly SVG_FECOLORMATRIX_TYPE_MATRIX: 1;\n    readonly SVG_FECOLORMATRIX_TYPE_SATURATE: 2;\n    readonly SVG_FECOLORMATRIX_TYPE_HUEROTATE: 3;\n    readonly SVG_FECOLORMATRIX_TYPE_LUMINANCETOALPHA: 4;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEColorMatrixElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEColorMatrixElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEColorMatrixElement: {\n    prototype: SVGFEColorMatrixElement;\n    new(): SVGFEColorMatrixElement;\n    readonly SVG_FECOLORMATRIX_TYPE_UNKNOWN: 0;\n    readonly SVG_FECOLORMATRIX_TYPE_MATRIX: 1;\n    readonly SVG_FECOLORMATRIX_TYPE_SATURATE: 2;\n    readonly SVG_FECOLORMATRIX_TYPE_HUEROTATE: 3;\n    readonly SVG_FECOLORMATRIX_TYPE_LUMINANCETOALPHA: 4;\n};\n\n/** Corresponds to the <feComponentTransfer> element. */\ninterface SVGFEComponentTransferElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly in1: SVGAnimatedString;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEComponentTransferElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEComponentTransferElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEComponentTransferElement: {\n    prototype: SVGFEComponentTransferElement;\n    new(): SVGFEComponentTransferElement;\n};\n\n/** Corresponds to the <feComposite> element. */\ninterface SVGFECompositeElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly in1: SVGAnimatedString;\n    readonly in2: SVGAnimatedString;\n    readonly k1: SVGAnimatedNumber;\n    readonly k2: SVGAnimatedNumber;\n    readonly k3: SVGAnimatedNumber;\n    readonly k4: SVGAnimatedNumber;\n    readonly operator: SVGAnimatedEnumeration;\n    readonly SVG_FECOMPOSITE_OPERATOR_UNKNOWN: 0;\n    readonly SVG_FECOMPOSITE_OPERATOR_OVER: 1;\n    readonly SVG_FECOMPOSITE_OPERATOR_IN: 2;\n    readonly SVG_FECOMPOSITE_OPERATOR_OUT: 3;\n    readonly SVG_FECOMPOSITE_OPERATOR_ATOP: 4;\n    readonly SVG_FECOMPOSITE_OPERATOR_XOR: 5;\n    readonly SVG_FECOMPOSITE_OPERATOR_ARITHMETIC: 6;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFECompositeElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFECompositeElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFECompositeElement: {\n    prototype: SVGFECompositeElement;\n    new(): SVGFECompositeElement;\n    readonly SVG_FECOMPOSITE_OPERATOR_UNKNOWN: 0;\n    readonly SVG_FECOMPOSITE_OPERATOR_OVER: 1;\n    readonly SVG_FECOMPOSITE_OPERATOR_IN: 2;\n    readonly SVG_FECOMPOSITE_OPERATOR_OUT: 3;\n    readonly SVG_FECOMPOSITE_OPERATOR_ATOP: 4;\n    readonly SVG_FECOMPOSITE_OPERATOR_XOR: 5;\n    readonly SVG_FECOMPOSITE_OPERATOR_ARITHMETIC: 6;\n};\n\n/** Corresponds to the <feConvolveMatrix> element. */\ninterface SVGFEConvolveMatrixElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly bias: SVGAnimatedNumber;\n    readonly divisor: SVGAnimatedNumber;\n    readonly edgeMode: SVGAnimatedEnumeration;\n    readonly in1: SVGAnimatedString;\n    readonly kernelMatrix: SVGAnimatedNumberList;\n    readonly kernelUnitLengthX: SVGAnimatedNumber;\n    readonly kernelUnitLengthY: SVGAnimatedNumber;\n    readonly orderX: SVGAnimatedInteger;\n    readonly orderY: SVGAnimatedInteger;\n    readonly preserveAlpha: SVGAnimatedBoolean;\n    readonly targetX: SVGAnimatedInteger;\n    readonly targetY: SVGAnimatedInteger;\n    readonly SVG_EDGEMODE_UNKNOWN: 0;\n    readonly SVG_EDGEMODE_DUPLICATE: 1;\n    readonly SVG_EDGEMODE_WRAP: 2;\n    readonly SVG_EDGEMODE_NONE: 3;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEConvolveMatrixElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEConvolveMatrixElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEConvolveMatrixElement: {\n    prototype: SVGFEConvolveMatrixElement;\n    new(): SVGFEConvolveMatrixElement;\n    readonly SVG_EDGEMODE_UNKNOWN: 0;\n    readonly SVG_EDGEMODE_DUPLICATE: 1;\n    readonly SVG_EDGEMODE_WRAP: 2;\n    readonly SVG_EDGEMODE_NONE: 3;\n};\n\n/** Corresponds to the <feDiffuseLighting> element. */\ninterface SVGFEDiffuseLightingElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly diffuseConstant: SVGAnimatedNumber;\n    readonly in1: SVGAnimatedString;\n    readonly kernelUnitLengthX: SVGAnimatedNumber;\n    readonly kernelUnitLengthY: SVGAnimatedNumber;\n    readonly surfaceScale: SVGAnimatedNumber;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEDiffuseLightingElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEDiffuseLightingElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEDiffuseLightingElement: {\n    prototype: SVGFEDiffuseLightingElement;\n    new(): SVGFEDiffuseLightingElement;\n};\n\n/** Corresponds to the <feDisplacementMap> element. */\ninterface SVGFEDisplacementMapElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly in1: SVGAnimatedString;\n    readonly in2: SVGAnimatedString;\n    readonly scale: SVGAnimatedNumber;\n    readonly xChannelSelector: SVGAnimatedEnumeration;\n    readonly yChannelSelector: SVGAnimatedEnumeration;\n    readonly SVG_CHANNEL_UNKNOWN: 0;\n    readonly SVG_CHANNEL_R: 1;\n    readonly SVG_CHANNEL_G: 2;\n    readonly SVG_CHANNEL_B: 3;\n    readonly SVG_CHANNEL_A: 4;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEDisplacementMapElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEDisplacementMapElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEDisplacementMapElement: {\n    prototype: SVGFEDisplacementMapElement;\n    new(): SVGFEDisplacementMapElement;\n    readonly SVG_CHANNEL_UNKNOWN: 0;\n    readonly SVG_CHANNEL_R: 1;\n    readonly SVG_CHANNEL_G: 2;\n    readonly SVG_CHANNEL_B: 3;\n    readonly SVG_CHANNEL_A: 4;\n};\n\n/** Corresponds to the <feDistantLight> element. */\ninterface SVGFEDistantLightElement extends SVGElement {\n    readonly azimuth: SVGAnimatedNumber;\n    readonly elevation: SVGAnimatedNumber;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEDistantLightElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEDistantLightElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEDistantLightElement: {\n    prototype: SVGFEDistantLightElement;\n    new(): SVGFEDistantLightElement;\n};\n\ninterface SVGFEDropShadowElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly dx: SVGAnimatedNumber;\n    readonly dy: SVGAnimatedNumber;\n    readonly in1: SVGAnimatedString;\n    readonly stdDeviationX: SVGAnimatedNumber;\n    readonly stdDeviationY: SVGAnimatedNumber;\n    setStdDeviation(stdDeviationX: number, stdDeviationY: number): void;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEDropShadowElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEDropShadowElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEDropShadowElement: {\n    prototype: SVGFEDropShadowElement;\n    new(): SVGFEDropShadowElement;\n};\n\n/** Corresponds to the <feFlood> element. */\ninterface SVGFEFloodElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEFloodElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEFloodElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEFloodElement: {\n    prototype: SVGFEFloodElement;\n    new(): SVGFEFloodElement;\n};\n\n/** Corresponds to the <feFuncA> element. */\ninterface SVGFEFuncAElement extends SVGComponentTransferFunctionElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEFuncAElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEFuncAElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEFuncAElement: {\n    prototype: SVGFEFuncAElement;\n    new(): SVGFEFuncAElement;\n};\n\n/** Corresponds to the <feFuncB> element. */\ninterface SVGFEFuncBElement extends SVGComponentTransferFunctionElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEFuncBElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEFuncBElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEFuncBElement: {\n    prototype: SVGFEFuncBElement;\n    new(): SVGFEFuncBElement;\n};\n\n/** Corresponds to the <feFuncG> element. */\ninterface SVGFEFuncGElement extends SVGComponentTransferFunctionElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEFuncGElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEFuncGElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEFuncGElement: {\n    prototype: SVGFEFuncGElement;\n    new(): SVGFEFuncGElement;\n};\n\n/** Corresponds to the <feFuncR> element. */\ninterface SVGFEFuncRElement extends SVGComponentTransferFunctionElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEFuncRElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEFuncRElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEFuncRElement: {\n    prototype: SVGFEFuncRElement;\n    new(): SVGFEFuncRElement;\n};\n\n/** Corresponds to the <feGaussianBlur> element. */\ninterface SVGFEGaussianBlurElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly in1: SVGAnimatedString;\n    readonly stdDeviationX: SVGAnimatedNumber;\n    readonly stdDeviationY: SVGAnimatedNumber;\n    setStdDeviation(stdDeviationX: number, stdDeviationY: number): void;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEGaussianBlurElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEGaussianBlurElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEGaussianBlurElement: {\n    prototype: SVGFEGaussianBlurElement;\n    new(): SVGFEGaussianBlurElement;\n};\n\n/** Corresponds to the <feImage> element. */\ninterface SVGFEImageElement extends SVGElement, SVGFilterPrimitiveStandardAttributes, SVGURIReference {\n    readonly preserveAspectRatio: SVGAnimatedPreserveAspectRatio;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEImageElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEImageElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEImageElement: {\n    prototype: SVGFEImageElement;\n    new(): SVGFEImageElement;\n};\n\n/** Corresponds to the <feMerge> element. */\ninterface SVGFEMergeElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEMergeElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEMergeElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEMergeElement: {\n    prototype: SVGFEMergeElement;\n    new(): SVGFEMergeElement;\n};\n\n/** Corresponds to the <feMergeNode> element. */\ninterface SVGFEMergeNodeElement extends SVGElement {\n    readonly in1: SVGAnimatedString;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEMergeNodeElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEMergeNodeElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEMergeNodeElement: {\n    prototype: SVGFEMergeNodeElement;\n    new(): SVGFEMergeNodeElement;\n};\n\n/** Corresponds to the <feMorphology> element. */\ninterface SVGFEMorphologyElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly in1: SVGAnimatedString;\n    readonly operator: SVGAnimatedEnumeration;\n    readonly radiusX: SVGAnimatedNumber;\n    readonly radiusY: SVGAnimatedNumber;\n    readonly SVG_MORPHOLOGY_OPERATOR_UNKNOWN: 0;\n    readonly SVG_MORPHOLOGY_OPERATOR_ERODE: 1;\n    readonly SVG_MORPHOLOGY_OPERATOR_DILATE: 2;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEMorphologyElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEMorphologyElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEMorphologyElement: {\n    prototype: SVGFEMorphologyElement;\n    new(): SVGFEMorphologyElement;\n    readonly SVG_MORPHOLOGY_OPERATOR_UNKNOWN: 0;\n    readonly SVG_MORPHOLOGY_OPERATOR_ERODE: 1;\n    readonly SVG_MORPHOLOGY_OPERATOR_DILATE: 2;\n};\n\n/** Corresponds to the <feOffset> element. */\ninterface SVGFEOffsetElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly dx: SVGAnimatedNumber;\n    readonly dy: SVGAnimatedNumber;\n    readonly in1: SVGAnimatedString;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEOffsetElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEOffsetElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEOffsetElement: {\n    prototype: SVGFEOffsetElement;\n    new(): SVGFEOffsetElement;\n};\n\n/** Corresponds to the <fePointLight> element. */\ninterface SVGFEPointLightElement extends SVGElement {\n    readonly x: SVGAnimatedNumber;\n    readonly y: SVGAnimatedNumber;\n    readonly z: SVGAnimatedNumber;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEPointLightElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEPointLightElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEPointLightElement: {\n    prototype: SVGFEPointLightElement;\n    new(): SVGFEPointLightElement;\n};\n\n/** Corresponds to the <feSpecularLighting> element. */\ninterface SVGFESpecularLightingElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly in1: SVGAnimatedString;\n    readonly kernelUnitLengthX: SVGAnimatedNumber;\n    readonly kernelUnitLengthY: SVGAnimatedNumber;\n    readonly specularConstant: SVGAnimatedNumber;\n    readonly specularExponent: SVGAnimatedNumber;\n    readonly surfaceScale: SVGAnimatedNumber;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFESpecularLightingElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFESpecularLightingElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFESpecularLightingElement: {\n    prototype: SVGFESpecularLightingElement;\n    new(): SVGFESpecularLightingElement;\n};\n\n/** Corresponds to the <feSpotLight> element. */\ninterface SVGFESpotLightElement extends SVGElement {\n    readonly limitingConeAngle: SVGAnimatedNumber;\n    readonly pointsAtX: SVGAnimatedNumber;\n    readonly pointsAtY: SVGAnimatedNumber;\n    readonly pointsAtZ: SVGAnimatedNumber;\n    readonly specularExponent: SVGAnimatedNumber;\n    readonly x: SVGAnimatedNumber;\n    readonly y: SVGAnimatedNumber;\n    readonly z: SVGAnimatedNumber;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFESpotLightElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFESpotLightElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFESpotLightElement: {\n    prototype: SVGFESpotLightElement;\n    new(): SVGFESpotLightElement;\n};\n\n/** Corresponds to the <feTile> element. */\ninterface SVGFETileElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly in1: SVGAnimatedString;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFETileElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFETileElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFETileElement: {\n    prototype: SVGFETileElement;\n    new(): SVGFETileElement;\n};\n\n/** Corresponds to the <feTurbulence> element. */\ninterface SVGFETurbulenceElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly baseFrequencyX: SVGAnimatedNumber;\n    readonly baseFrequencyY: SVGAnimatedNumber;\n    readonly numOctaves: SVGAnimatedInteger;\n    readonly seed: SVGAnimatedNumber;\n    readonly stitchTiles: SVGAnimatedEnumeration;\n    readonly type: SVGAnimatedEnumeration;\n    readonly SVG_TURBULENCE_TYPE_UNKNOWN: 0;\n    readonly SVG_TURBULENCE_TYPE_FRACTALNOISE: 1;\n    readonly SVG_TURBULENCE_TYPE_TURBULENCE: 2;\n    readonly SVG_STITCHTYPE_UNKNOWN: 0;\n    readonly SVG_STITCHTYPE_STITCH: 1;\n    readonly SVG_STITCHTYPE_NOSTITCH: 2;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFETurbulenceElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFETurbulenceElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFETurbulenceElement: {\n    prototype: SVGFETurbulenceElement;\n    new(): SVGFETurbulenceElement;\n    readonly SVG_TURBULENCE_TYPE_UNKNOWN: 0;\n    readonly SVG_TURBULENCE_TYPE_FRACTALNOISE: 1;\n    readonly SVG_TURBULENCE_TYPE_TURBULENCE: 2;\n    readonly SVG_STITCHTYPE_UNKNOWN: 0;\n    readonly SVG_STITCHTYPE_STITCH: 1;\n    readonly SVG_STITCHTYPE_NOSTITCH: 2;\n};\n\n/** Provides access to the properties of <filter> elements, as well as methods to manipulate them. */\ninterface SVGFilterElement extends SVGElement, SVGURIReference {\n    readonly filterUnits: SVGAnimatedEnumeration;\n    readonly height: SVGAnimatedLength;\n    readonly primitiveUnits: SVGAnimatedEnumeration;\n    readonly width: SVGAnimatedLength;\n    readonly x: SVGAnimatedLength;\n    readonly y: SVGAnimatedLength;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFilterElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFilterElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFilterElement: {\n    prototype: SVGFilterElement;\n    new(): SVGFilterElement;\n};\n\ninterface SVGFilterPrimitiveStandardAttributes {\n    readonly height: SVGAnimatedLength;\n    readonly result: SVGAnimatedString;\n    readonly width: SVGAnimatedLength;\n    readonly x: SVGAnimatedLength;\n    readonly y: SVGAnimatedLength;\n}\n\ninterface SVGFitToViewBox {\n    readonly preserveAspectRatio: SVGAnimatedPreserveAspectRatio;\n    readonly viewBox: SVGAnimatedRect;\n}\n\n/** Provides access to the properties of <foreignObject> elements, as well as methods to manipulate them. */\ninterface SVGForeignObjectElement extends SVGGraphicsElement {\n    readonly height: SVGAnimatedLength;\n    readonly width: SVGAnimatedLength;\n    readonly x: SVGAnimatedLength;\n    readonly y: SVGAnimatedLength;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGForeignObjectElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGForeignObjectElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGForeignObjectElement: {\n    prototype: SVGForeignObjectElement;\n    new(): SVGForeignObjectElement;\n};\n\n/** Corresponds to the <g> element. */\ninterface SVGGElement extends SVGGraphicsElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGGElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGGElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGGElement: {\n    prototype: SVGGElement;\n    new(): SVGGElement;\n};\n\ninterface SVGGeometryElement extends SVGGraphicsElement {\n    readonly pathLength: SVGAnimatedNumber;\n    getPointAtLength(distance: number): DOMPoint;\n    getTotalLength(): number;\n    isPointInFill(point?: DOMPointInit): boolean;\n    isPointInStroke(point?: DOMPointInit): boolean;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGGeometryElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGGeometryElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGGeometryElement: {\n    prototype: SVGGeometryElement;\n    new(): SVGGeometryElement;\n};\n\n/** The SVGGradient interface is a base interface used by SVGLinearGradientElement and SVGRadialGradientElement. */\ninterface SVGGradientElement extends SVGElement, SVGURIReference {\n    readonly gradientTransform: SVGAnimatedTransformList;\n    readonly gradientUnits: SVGAnimatedEnumeration;\n    readonly spreadMethod: SVGAnimatedEnumeration;\n    readonly SVG_SPREADMETHOD_UNKNOWN: 0;\n    readonly SVG_SPREADMETHOD_PAD: 1;\n    readonly SVG_SPREADMETHOD_REFLECT: 2;\n    readonly SVG_SPREADMETHOD_REPEAT: 3;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGGradientElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGGradientElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGGradientElement: {\n    prototype: SVGGradientElement;\n    new(): SVGGradientElement;\n    readonly SVG_SPREADMETHOD_UNKNOWN: 0;\n    readonly SVG_SPREADMETHOD_PAD: 1;\n    readonly SVG_SPREADMETHOD_REFLECT: 2;\n    readonly SVG_SPREADMETHOD_REPEAT: 3;\n};\n\n/** SVG elements whose primary purpose is to directly render graphics into a group. */\ninterface SVGGraphicsElement extends SVGElement, SVGTests {\n    readonly transform: SVGAnimatedTransformList;\n    getBBox(options?: SVGBoundingBoxOptions): DOMRect;\n    getCTM(): DOMMatrix | null;\n    getScreenCTM(): DOMMatrix | null;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGGraphicsElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGGraphicsElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGGraphicsElement: {\n    prototype: SVGGraphicsElement;\n    new(): SVGGraphicsElement;\n};\n\n/** Corresponds to the <image> element. */\ninterface SVGImageElement extends SVGGraphicsElement, SVGURIReference {\n    readonly height: SVGAnimatedLength;\n    readonly preserveAspectRatio: SVGAnimatedPreserveAspectRatio;\n    readonly width: SVGAnimatedLength;\n    readonly x: SVGAnimatedLength;\n    readonly y: SVGAnimatedLength;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGImageElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGImageElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGImageElement: {\n    prototype: SVGImageElement;\n    new(): SVGImageElement;\n};\n\n/** Correspond to the <length> basic data type. */\ninterface SVGLength {\n    readonly unitType: number;\n    value: number;\n    valueAsString: string;\n    valueInSpecifiedUnits: number;\n    convertToSpecifiedUnits(unitType: number): void;\n    newValueSpecifiedUnits(unitType: number, valueInSpecifiedUnits: number): void;\n    readonly SVG_LENGTHTYPE_UNKNOWN: 0;\n    readonly SVG_LENGTHTYPE_NUMBER: 1;\n    readonly SVG_LENGTHTYPE_PERCENTAGE: 2;\n    readonly SVG_LENGTHTYPE_EMS: 3;\n    readonly SVG_LENGTHTYPE_EXS: 4;\n    readonly SVG_LENGTHTYPE_PX: 5;\n    readonly SVG_LENGTHTYPE_CM: 6;\n    readonly SVG_LENGTHTYPE_MM: 7;\n    readonly SVG_LENGTHTYPE_IN: 8;\n    readonly SVG_LENGTHTYPE_PT: 9;\n    readonly SVG_LENGTHTYPE_PC: 10;\n}\n\ndeclare var SVGLength: {\n    prototype: SVGLength;\n    new(): SVGLength;\n    readonly SVG_LENGTHTYPE_UNKNOWN: 0;\n    readonly SVG_LENGTHTYPE_NUMBER: 1;\n    readonly SVG_LENGTHTYPE_PERCENTAGE: 2;\n    readonly SVG_LENGTHTYPE_EMS: 3;\n    readonly SVG_LENGTHTYPE_EXS: 4;\n    readonly SVG_LENGTHTYPE_PX: 5;\n    readonly SVG_LENGTHTYPE_CM: 6;\n    readonly SVG_LENGTHTYPE_MM: 7;\n    readonly SVG_LENGTHTYPE_IN: 8;\n    readonly SVG_LENGTHTYPE_PT: 9;\n    readonly SVG_LENGTHTYPE_PC: 10;\n};\n\n/** The SVGLengthList defines a list of SVGLength objects. */\ninterface SVGLengthList {\n    readonly length: number;\n    readonly numberOfItems: number;\n    appendItem(newItem: SVGLength): SVGLength;\n    clear(): void;\n    getItem(index: number): SVGLength;\n    initialize(newItem: SVGLength): SVGLength;\n    insertItemBefore(newItem: SVGLength, index: number): SVGLength;\n    removeItem(index: number): SVGLength;\n    replaceItem(newItem: SVGLength, index: number): SVGLength;\n    [index: number]: SVGLength;\n}\n\ndeclare var SVGLengthList: {\n    prototype: SVGLengthList;\n    new(): SVGLengthList;\n};\n\n/** Provides access to the properties of <line> elements, as well as methods to manipulate them. */\ninterface SVGLineElement extends SVGGeometryElement {\n    readonly x1: SVGAnimatedLength;\n    readonly x2: SVGAnimatedLength;\n    readonly y1: SVGAnimatedLength;\n    readonly y2: SVGAnimatedLength;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGLineElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGLineElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGLineElement: {\n    prototype: SVGLineElement;\n    new(): SVGLineElement;\n};\n\n/** Corresponds to the <linearGradient> element. */\ninterface SVGLinearGradientElement extends SVGGradientElement {\n    readonly x1: SVGAnimatedLength;\n    readonly x2: SVGAnimatedLength;\n    readonly y1: SVGAnimatedLength;\n    readonly y2: SVGAnimatedLength;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGLinearGradientElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGLinearGradientElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGLinearGradientElement: {\n    prototype: SVGLinearGradientElement;\n    new(): SVGLinearGradientElement;\n};\n\ninterface SVGMPathElement extends SVGElement, SVGURIReference {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGMPathElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGMPathElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGMPathElement: {\n    prototype: SVGMPathElement;\n    new(): SVGMPathElement;\n};\n\ninterface SVGMarkerElement extends SVGElement, SVGFitToViewBox {\n    readonly markerHeight: SVGAnimatedLength;\n    readonly markerUnits: SVGAnimatedEnumeration;\n    readonly markerWidth: SVGAnimatedLength;\n    readonly orientAngle: SVGAnimatedAngle;\n    readonly orientType: SVGAnimatedEnumeration;\n    readonly refX: SVGAnimatedLength;\n    readonly refY: SVGAnimatedLength;\n    setOrientToAngle(angle: SVGAngle): void;\n    setOrientToAuto(): void;\n    readonly SVG_MARKERUNITS_UNKNOWN: 0;\n    readonly SVG_MARKERUNITS_USERSPACEONUSE: 1;\n    readonly SVG_MARKERUNITS_STROKEWIDTH: 2;\n    readonly SVG_MARKER_ORIENT_UNKNOWN: 0;\n    readonly SVG_MARKER_ORIENT_AUTO: 1;\n    readonly SVG_MARKER_ORIENT_ANGLE: 2;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGMarkerElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGMarkerElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGMarkerElement: {\n    prototype: SVGMarkerElement;\n    new(): SVGMarkerElement;\n    readonly SVG_MARKERUNITS_UNKNOWN: 0;\n    readonly SVG_MARKERUNITS_USERSPACEONUSE: 1;\n    readonly SVG_MARKERUNITS_STROKEWIDTH: 2;\n    readonly SVG_MARKER_ORIENT_UNKNOWN: 0;\n    readonly SVG_MARKER_ORIENT_AUTO: 1;\n    readonly SVG_MARKER_ORIENT_ANGLE: 2;\n};\n\n/** Provides access to the properties of <mask> elements, as well as methods to manipulate them. */\ninterface SVGMaskElement extends SVGElement {\n    readonly height: SVGAnimatedLength;\n    readonly maskContentUnits: SVGAnimatedEnumeration;\n    readonly maskUnits: SVGAnimatedEnumeration;\n    readonly width: SVGAnimatedLength;\n    readonly x: SVGAnimatedLength;\n    readonly y: SVGAnimatedLength;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGMaskElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGMaskElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGMaskElement: {\n    prototype: SVGMaskElement;\n    new(): SVGMaskElement;\n};\n\n/** Corresponds to the <metadata> element. */\ninterface SVGMetadataElement extends SVGElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGMetadataElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGMetadataElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGMetadataElement: {\n    prototype: SVGMetadataElement;\n    new(): SVGMetadataElement;\n};\n\n/** Corresponds to the <number> basic data type. */\ninterface SVGNumber {\n    value: number;\n}\n\ndeclare var SVGNumber: {\n    prototype: SVGNumber;\n    new(): SVGNumber;\n};\n\n/** The SVGNumberList defines a list of SVGNumber objects. */\ninterface SVGNumberList {\n    readonly length: number;\n    readonly numberOfItems: number;\n    appendItem(newItem: SVGNumber): SVGNumber;\n    clear(): void;\n    getItem(index: number): SVGNumber;\n    initialize(newItem: SVGNumber): SVGNumber;\n    insertItemBefore(newItem: SVGNumber, index: number): SVGNumber;\n    removeItem(index: number): SVGNumber;\n    replaceItem(newItem: SVGNumber, index: number): SVGNumber;\n    [index: number]: SVGNumber;\n}\n\ndeclare var SVGNumberList: {\n    prototype: SVGNumberList;\n    new(): SVGNumberList;\n};\n\n/** Corresponds to the <path> element. */\ninterface SVGPathElement extends SVGGeometryElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGPathElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGPathElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGPathElement: {\n    prototype: SVGPathElement;\n    new(): SVGPathElement;\n};\n\n/** Corresponds to the <pattern> element. */\ninterface SVGPatternElement extends SVGElement, SVGFitToViewBox, SVGURIReference {\n    readonly height: SVGAnimatedLength;\n    readonly patternContentUnits: SVGAnimatedEnumeration;\n    readonly patternTransform: SVGAnimatedTransformList;\n    readonly patternUnits: SVGAnimatedEnumeration;\n    readonly width: SVGAnimatedLength;\n    readonly x: SVGAnimatedLength;\n    readonly y: SVGAnimatedLength;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGPatternElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGPatternElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGPatternElement: {\n    prototype: SVGPatternElement;\n    new(): SVGPatternElement;\n};\n\ninterface SVGPointList {\n    readonly length: number;\n    readonly numberOfItems: number;\n    appendItem(newItem: DOMPoint): DOMPoint;\n    clear(): void;\n    getItem(index: number): DOMPoint;\n    initialize(newItem: DOMPoint): DOMPoint;\n    insertItemBefore(newItem: DOMPoint, index: number): DOMPoint;\n    removeItem(index: number): DOMPoint;\n    replaceItem(newItem: DOMPoint, index: number): DOMPoint;\n    [index: number]: DOMPoint;\n}\n\ndeclare var SVGPointList: {\n    prototype: SVGPointList;\n    new(): SVGPointList;\n};\n\n/** Provides access to the properties of <polygon> elements, as well as methods to manipulate them. */\ninterface SVGPolygonElement extends SVGGeometryElement, SVGAnimatedPoints {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGPolygonElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGPolygonElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGPolygonElement: {\n    prototype: SVGPolygonElement;\n    new(): SVGPolygonElement;\n};\n\n/** Provides access to the properties of <polyline> elements, as well as methods to manipulate them. */\ninterface SVGPolylineElement extends SVGGeometryElement, SVGAnimatedPoints {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGPolylineElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGPolylineElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGPolylineElement: {\n    prototype: SVGPolylineElement;\n    new(): SVGPolylineElement;\n};\n\n/** Corresponds to the preserveAspectRatio attribute, which is available for some of SVG's elements. */\ninterface SVGPreserveAspectRatio {\n    align: number;\n    meetOrSlice: number;\n    readonly SVG_PRESERVEASPECTRATIO_UNKNOWN: 0;\n    readonly SVG_PRESERVEASPECTRATIO_NONE: 1;\n    readonly SVG_PRESERVEASPECTRATIO_XMINYMIN: 2;\n    readonly SVG_PRESERVEASPECTRATIO_XMIDYMIN: 3;\n    readonly SVG_PRESERVEASPECTRATIO_XMAXYMIN: 4;\n    readonly SVG_PRESERVEASPECTRATIO_XMINYMID: 5;\n    readonly SVG_PRESERVEASPECTRATIO_XMIDYMID: 6;\n    readonly SVG_PRESERVEASPECTRATIO_XMAXYMID: 7;\n    readonly SVG_PRESERVEASPECTRATIO_XMINYMAX: 8;\n    readonly SVG_PRESERVEASPECTRATIO_XMIDYMAX: 9;\n    readonly SVG_PRESERVEASPECTRATIO_XMAXYMAX: 10;\n    readonly SVG_MEETORSLICE_UNKNOWN: 0;\n    readonly SVG_MEETORSLICE_MEET: 1;\n    readonly SVG_MEETORSLICE_SLICE: 2;\n}\n\ndeclare var SVGPreserveAspectRatio: {\n    prototype: SVGPreserveAspectRatio;\n    new(): SVGPreserveAspectRatio;\n    readonly SVG_PRESERVEASPECTRATIO_UNKNOWN: 0;\n    readonly SVG_PRESERVEASPECTRATIO_NONE: 1;\n    readonly SVG_PRESERVEASPECTRATIO_XMINYMIN: 2;\n    readonly SVG_PRESERVEASPECTRATIO_XMIDYMIN: 3;\n    readonly SVG_PRESERVEASPECTRATIO_XMAXYMIN: 4;\n    readonly SVG_PRESERVEASPECTRATIO_XMINYMID: 5;\n    readonly SVG_PRESERVEASPECTRATIO_XMIDYMID: 6;\n    readonly SVG_PRESERVEASPECTRATIO_XMAXYMID: 7;\n    readonly SVG_PRESERVEASPECTRATIO_XMINYMAX: 8;\n    readonly SVG_PRESERVEASPECTRATIO_XMIDYMAX: 9;\n    readonly SVG_PRESERVEASPECTRATIO_XMAXYMAX: 10;\n    readonly SVG_MEETORSLICE_UNKNOWN: 0;\n    readonly SVG_MEETORSLICE_MEET: 1;\n    readonly SVG_MEETORSLICE_SLICE: 2;\n};\n\n/** Corresponds to the <RadialGradient> element. */\ninterface SVGRadialGradientElement extends SVGGradientElement {\n    readonly cx: SVGAnimatedLength;\n    readonly cy: SVGAnimatedLength;\n    readonly fr: SVGAnimatedLength;\n    readonly fx: SVGAnimatedLength;\n    readonly fy: SVGAnimatedLength;\n    readonly r: SVGAnimatedLength;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGRadialGradientElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGRadialGradientElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGRadialGradientElement: {\n    prototype: SVGRadialGradientElement;\n    new(): SVGRadialGradientElement;\n};\n\n/** Provides access to the properties of <rect> elements, as well as methods to manipulate them. */\ninterface SVGRectElement extends SVGGeometryElement {\n    readonly height: SVGAnimatedLength;\n    readonly rx: SVGAnimatedLength;\n    readonly ry: SVGAnimatedLength;\n    readonly width: SVGAnimatedLength;\n    readonly x: SVGAnimatedLength;\n    readonly y: SVGAnimatedLength;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGRectElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGRectElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGRectElement: {\n    prototype: SVGRectElement;\n    new(): SVGRectElement;\n};\n\ninterface SVGSVGElementEventMap extends SVGElementEventMap, WindowEventHandlersEventMap {\n}\n\n/** Provides access to the properties of <svg> elements, as well as methods to manipulate them. This interface contains also various miscellaneous commonly-used utility methods, such as matrix operations and the ability to control the time of redraw on visual rendering devices. */\ninterface SVGSVGElement extends SVGGraphicsElement, SVGFitToViewBox, WindowEventHandlers {\n    currentScale: number;\n    readonly currentTranslate: DOMPointReadOnly;\n    readonly height: SVGAnimatedLength;\n    readonly width: SVGAnimatedLength;\n    readonly x: SVGAnimatedLength;\n    readonly y: SVGAnimatedLength;\n    animationsPaused(): boolean;\n    checkEnclosure(element: SVGElement, rect: DOMRectReadOnly): boolean;\n    checkIntersection(element: SVGElement, rect: DOMRectReadOnly): boolean;\n    createSVGAngle(): SVGAngle;\n    createSVGLength(): SVGLength;\n    createSVGMatrix(): DOMMatrix;\n    createSVGNumber(): SVGNumber;\n    createSVGPoint(): DOMPoint;\n    createSVGRect(): DOMRect;\n    createSVGTransform(): SVGTransform;\n    createSVGTransformFromMatrix(matrix?: DOMMatrix2DInit): SVGTransform;\n    deselectAll(): void;\n    /** @deprecated */\n    forceRedraw(): void;\n    getCurrentTime(): number;\n    getElementById(elementId: string): Element;\n    getEnclosureList(rect: DOMRectReadOnly, referenceElement: SVGElement | null): NodeListOf<SVGCircleElement | SVGEllipseElement | SVGImageElement | SVGLineElement | SVGPathElement | SVGPolygonElement | SVGPolylineElement | SVGRectElement | SVGTextElement | SVGUseElement>;\n    getIntersectionList(rect: DOMRectReadOnly, referenceElement: SVGElement | null): NodeListOf<SVGCircleElement | SVGEllipseElement | SVGImageElement | SVGLineElement | SVGPathElement | SVGPolygonElement | SVGPolylineElement | SVGRectElement | SVGTextElement | SVGUseElement>;\n    pauseAnimations(): void;\n    setCurrentTime(seconds: number): void;\n    /** @deprecated */\n    suspendRedraw(maxWaitMilliseconds: number): number;\n    unpauseAnimations(): void;\n    /** @deprecated */\n    unsuspendRedraw(suspendHandleID: number): void;\n    /** @deprecated */\n    unsuspendRedrawAll(): void;\n    addEventListener<K extends keyof SVGSVGElementEventMap>(type: K, listener: (this: SVGSVGElement, ev: SVGSVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGSVGElementEventMap>(type: K, listener: (this: SVGSVGElement, ev: SVGSVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGSVGElement: {\n    prototype: SVGSVGElement;\n    new(): SVGSVGElement;\n};\n\n/** Corresponds to the SVG <script> element. */\ninterface SVGScriptElement extends SVGElement, SVGURIReference {\n    type: string;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGScriptElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGScriptElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGScriptElement: {\n    prototype: SVGScriptElement;\n    new(): SVGScriptElement;\n};\n\ninterface SVGSetElement extends SVGAnimationElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGSetElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGSetElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGSetElement: {\n    prototype: SVGSetElement;\n    new(): SVGSetElement;\n};\n\n/** Corresponds to the <stop> element. */\ninterface SVGStopElement extends SVGElement {\n    readonly offset: SVGAnimatedNumber;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGStopElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGStopElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGStopElement: {\n    prototype: SVGStopElement;\n    new(): SVGStopElement;\n};\n\n/** The SVGStringList defines a list of DOMString objects. */\ninterface SVGStringList {\n    readonly length: number;\n    readonly numberOfItems: number;\n    appendItem(newItem: string): string;\n    clear(): void;\n    getItem(index: number): string;\n    initialize(newItem: string): string;\n    insertItemBefore(newItem: string, index: number): string;\n    removeItem(index: number): string;\n    replaceItem(newItem: string, index: number): string;\n    [index: number]: string;\n}\n\ndeclare var SVGStringList: {\n    prototype: SVGStringList;\n    new(): SVGStringList;\n};\n\n/** Corresponds to the SVG <style> element. */\ninterface SVGStyleElement extends SVGElement, LinkStyle {\n    disabled: boolean;\n    media: string;\n    title: string;\n    /** @deprecated */\n    type: string;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGStyleElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGStyleElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGStyleElement: {\n    prototype: SVGStyleElement;\n    new(): SVGStyleElement;\n};\n\n/** Corresponds to the <switch> element. */\ninterface SVGSwitchElement extends SVGGraphicsElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGSwitchElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGSwitchElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGSwitchElement: {\n    prototype: SVGSwitchElement;\n    new(): SVGSwitchElement;\n};\n\n/** Corresponds to the <symbol> element. */\ninterface SVGSymbolElement extends SVGElement, SVGFitToViewBox {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGSymbolElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGSymbolElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGSymbolElement: {\n    prototype: SVGSymbolElement;\n    new(): SVGSymbolElement;\n};\n\n/** A <tspan> element. */\ninterface SVGTSpanElement extends SVGTextPositioningElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGTSpanElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGTSpanElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGTSpanElement: {\n    prototype: SVGTSpanElement;\n    new(): SVGTSpanElement;\n};\n\ninterface SVGTests {\n    readonly requiredExtensions: SVGStringList;\n    readonly systemLanguage: SVGStringList;\n}\n\n/** Implemented by elements that support rendering child text content. It is inherited by various text-related interfaces, such as SVGTextElement, SVGTSpanElement, SVGTRefElement, SVGAltGlyphElement and SVGTextPathElement. */\ninterface SVGTextContentElement extends SVGGraphicsElement {\n    readonly lengthAdjust: SVGAnimatedEnumeration;\n    readonly textLength: SVGAnimatedLength;\n    getCharNumAtPosition(point?: DOMPointInit): number;\n    getComputedTextLength(): number;\n    getEndPositionOfChar(charnum: number): DOMPoint;\n    getExtentOfChar(charnum: number): DOMRect;\n    getNumberOfChars(): number;\n    getRotationOfChar(charnum: number): number;\n    getStartPositionOfChar(charnum: number): DOMPoint;\n    getSubStringLength(charnum: number, nchars: number): number;\n    /** @deprecated */\n    selectSubString(charnum: number, nchars: number): void;\n    readonly LENGTHADJUST_UNKNOWN: 0;\n    readonly LENGTHADJUST_SPACING: 1;\n    readonly LENGTHADJUST_SPACINGANDGLYPHS: 2;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGTextContentElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGTextContentElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGTextContentElement: {\n    prototype: SVGTextContentElement;\n    new(): SVGTextContentElement;\n    readonly LENGTHADJUST_UNKNOWN: 0;\n    readonly LENGTHADJUST_SPACING: 1;\n    readonly LENGTHADJUST_SPACINGANDGLYPHS: 2;\n};\n\n/** Corresponds to the <text> elements. */\ninterface SVGTextElement extends SVGTextPositioningElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGTextElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGTextElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGTextElement: {\n    prototype: SVGTextElement;\n    new(): SVGTextElement;\n};\n\n/** Corresponds to the <textPath> element. */\ninterface SVGTextPathElement extends SVGTextContentElement, SVGURIReference {\n    readonly method: SVGAnimatedEnumeration;\n    readonly spacing: SVGAnimatedEnumeration;\n    readonly startOffset: SVGAnimatedLength;\n    readonly TEXTPATH_METHODTYPE_UNKNOWN: 0;\n    readonly TEXTPATH_METHODTYPE_ALIGN: 1;\n    readonly TEXTPATH_METHODTYPE_STRETCH: 2;\n    readonly TEXTPATH_SPACINGTYPE_UNKNOWN: 0;\n    readonly TEXTPATH_SPACINGTYPE_AUTO: 1;\n    readonly TEXTPATH_SPACINGTYPE_EXACT: 2;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGTextPathElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGTextPathElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGTextPathElement: {\n    prototype: SVGTextPathElement;\n    new(): SVGTextPathElement;\n    readonly TEXTPATH_METHODTYPE_UNKNOWN: 0;\n    readonly TEXTPATH_METHODTYPE_ALIGN: 1;\n    readonly TEXTPATH_METHODTYPE_STRETCH: 2;\n    readonly TEXTPATH_SPACINGTYPE_UNKNOWN: 0;\n    readonly TEXTPATH_SPACINGTYPE_AUTO: 1;\n    readonly TEXTPATH_SPACINGTYPE_EXACT: 2;\n};\n\n/** Implemented by elements that support attributes that position individual text glyphs. It is inherited by SVGTextElement, SVGTSpanElement, SVGTRefElement and SVGAltGlyphElement. */\ninterface SVGTextPositioningElement extends SVGTextContentElement {\n    readonly dx: SVGAnimatedLengthList;\n    readonly dy: SVGAnimatedLengthList;\n    readonly rotate: SVGAnimatedNumberList;\n    readonly x: SVGAnimatedLengthList;\n    readonly y: SVGAnimatedLengthList;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGTextPositioningElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGTextPositioningElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGTextPositioningElement: {\n    prototype: SVGTextPositioningElement;\n    new(): SVGTextPositioningElement;\n};\n\n/** Corresponds to the <title> element. */\ninterface SVGTitleElement extends SVGElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGTitleElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGTitleElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGTitleElement: {\n    prototype: SVGTitleElement;\n    new(): SVGTitleElement;\n};\n\n/** SVGTransform is the interface for one of the component transformations within an SVGTransformList; thus, an SVGTransform object corresponds to a single component (e.g., scale(…) or matrix(…)) within a transform attribute. */\ninterface SVGTransform {\n    readonly angle: number;\n    readonly matrix: DOMMatrix;\n    readonly type: number;\n    setMatrix(matrix?: DOMMatrix2DInit): void;\n    setRotate(angle: number, cx: number, cy: number): void;\n    setScale(sx: number, sy: number): void;\n    setSkewX(angle: number): void;\n    setSkewY(angle: number): void;\n    setTranslate(tx: number, ty: number): void;\n    readonly SVG_TRANSFORM_UNKNOWN: 0;\n    readonly SVG_TRANSFORM_MATRIX: 1;\n    readonly SVG_TRANSFORM_TRANSLATE: 2;\n    readonly SVG_TRANSFORM_SCALE: 3;\n    readonly SVG_TRANSFORM_ROTATE: 4;\n    readonly SVG_TRANSFORM_SKEWX: 5;\n    readonly SVG_TRANSFORM_SKEWY: 6;\n}\n\ndeclare var SVGTransform: {\n    prototype: SVGTransform;\n    new(): SVGTransform;\n    readonly SVG_TRANSFORM_UNKNOWN: 0;\n    readonly SVG_TRANSFORM_MATRIX: 1;\n    readonly SVG_TRANSFORM_TRANSLATE: 2;\n    readonly SVG_TRANSFORM_SCALE: 3;\n    readonly SVG_TRANSFORM_ROTATE: 4;\n    readonly SVG_TRANSFORM_SKEWX: 5;\n    readonly SVG_TRANSFORM_SKEWY: 6;\n};\n\n/** The SVGTransformList defines a list of SVGTransform objects. */\ninterface SVGTransformList {\n    readonly length: number;\n    readonly numberOfItems: number;\n    appendItem(newItem: SVGTransform): SVGTransform;\n    clear(): void;\n    consolidate(): SVGTransform | null;\n    createSVGTransformFromMatrix(matrix?: DOMMatrix2DInit): SVGTransform;\n    getItem(index: number): SVGTransform;\n    initialize(newItem: SVGTransform): SVGTransform;\n    insertItemBefore(newItem: SVGTransform, index: number): SVGTransform;\n    removeItem(index: number): SVGTransform;\n    replaceItem(newItem: SVGTransform, index: number): SVGTransform;\n    [index: number]: SVGTransform;\n}\n\ndeclare var SVGTransformList: {\n    prototype: SVGTransformList;\n    new(): SVGTransformList;\n};\n\ninterface SVGURIReference {\n    readonly href: SVGAnimatedString;\n}\n\n/** A commonly used set of constants used for reflecting gradientUnits, patternContentUnits and other similar attributes. */\ninterface SVGUnitTypes {\n    readonly SVG_UNIT_TYPE_UNKNOWN: 0;\n    readonly SVG_UNIT_TYPE_USERSPACEONUSE: 1;\n    readonly SVG_UNIT_TYPE_OBJECTBOUNDINGBOX: 2;\n}\n\ndeclare var SVGUnitTypes: {\n    prototype: SVGUnitTypes;\n    new(): SVGUnitTypes;\n    readonly SVG_UNIT_TYPE_UNKNOWN: 0;\n    readonly SVG_UNIT_TYPE_USERSPACEONUSE: 1;\n    readonly SVG_UNIT_TYPE_OBJECTBOUNDINGBOX: 2;\n};\n\n/** Corresponds to the <use> element. */\ninterface SVGUseElement extends SVGGraphicsElement, SVGURIReference {\n    readonly height: SVGAnimatedLength;\n    readonly width: SVGAnimatedLength;\n    readonly x: SVGAnimatedLength;\n    readonly y: SVGAnimatedLength;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGUseElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGUseElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGUseElement: {\n    prototype: SVGUseElement;\n    new(): SVGUseElement;\n};\n\n/** Provides access to the properties of <view> elements, as well as methods to manipulate them. */\ninterface SVGViewElement extends SVGElement, SVGFitToViewBox {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGViewElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGViewElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGViewElement: {\n    prototype: SVGViewElement;\n    new(): SVGViewElement;\n};\n\n/** A screen, usually the one on which the current window is being rendered, and is obtained using window.screen. */\ninterface Screen {\n    readonly availHeight: number;\n    readonly availWidth: number;\n    readonly colorDepth: number;\n    readonly height: number;\n    readonly orientation: ScreenOrientation;\n    readonly pixelDepth: number;\n    readonly width: number;\n}\n\ndeclare var Screen: {\n    prototype: Screen;\n    new(): Screen;\n};\n\ninterface ScreenOrientationEventMap {\n    \"change\": Event;\n}\n\ninterface ScreenOrientation extends EventTarget {\n    readonly angle: number;\n    onchange: ((this: ScreenOrientation, ev: Event) => any) | null;\n    readonly type: OrientationType;\n    lock(orientation: OrientationLockType): Promise<void>;\n    unlock(): void;\n    addEventListener<K extends keyof ScreenOrientationEventMap>(type: K, listener: (this: ScreenOrientation, ev: ScreenOrientationEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof ScreenOrientationEventMap>(type: K, listener: (this: ScreenOrientation, ev: ScreenOrientationEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var ScreenOrientation: {\n    prototype: ScreenOrientation;\n    new(): ScreenOrientation;\n};\n\ninterface ScriptProcessorNodeEventMap {\n    \"audioprocess\": AudioProcessingEvent;\n}\n\n/**\n * Allows the generation, processing, or analyzing of audio using JavaScript.\n * @deprecated As of the August 29 2014 Web Audio API spec publication, this feature has been marked as deprecated, and was replaced by AudioWorklet (see AudioWorkletNode).\n */\ninterface ScriptProcessorNode extends AudioNode {\n    /** @deprecated */\n    readonly bufferSize: number;\n    /** @deprecated */\n    onaudioprocess: ((this: ScriptProcessorNode, ev: AudioProcessingEvent) => any) | null;\n    addEventListener<K extends keyof ScriptProcessorNodeEventMap>(type: K, listener: (this: ScriptProcessorNode, ev: ScriptProcessorNodeEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof ScriptProcessorNodeEventMap>(type: K, listener: (this: ScriptProcessorNode, ev: ScriptProcessorNodeEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\n/** @deprecated */\ndeclare var ScriptProcessorNode: {\n    prototype: ScriptProcessorNode;\n    new(): ScriptProcessorNode;\n};\n\n/** Inherits from Event, and represents the event object of an event sent on a document or worker when its content security policy is violated. */\ninterface SecurityPolicyViolationEvent extends Event {\n    readonly blockedURI: string;\n    readonly columnNumber: number;\n    readonly disposition: SecurityPolicyViolationEventDisposition;\n    readonly documentURI: string;\n    readonly effectiveDirective: string;\n    readonly lineNumber: number;\n    readonly originalPolicy: string;\n    readonly referrer: string;\n    readonly sample: string;\n    readonly sourceFile: string;\n    readonly statusCode: number;\n    readonly violatedDirective: string;\n}\n\ndeclare var SecurityPolicyViolationEvent: {\n    prototype: SecurityPolicyViolationEvent;\n    new(type: string, eventInitDict?: SecurityPolicyViolationEventInit): SecurityPolicyViolationEvent;\n};\n\n/** A Selection object represents the range of text selected by the user or the current position of the caret. To obtain a Selection object for examination or modification, call Window.getSelection(). */\ninterface Selection {\n    readonly anchorNode: Node | null;\n    readonly anchorOffset: number;\n    readonly focusNode: Node | null;\n    readonly focusOffset: number;\n    readonly isCollapsed: boolean;\n    readonly rangeCount: number;\n    readonly type: string;\n    addRange(range: Range): void;\n    collapse(node: Node | null, offset?: number): void;\n    collapseToEnd(): void;\n    collapseToStart(): void;\n    containsNode(node: Node, allowPartialContainment?: boolean): boolean;\n    deleteFromDocument(): void;\n    empty(): void;\n    extend(node: Node, offset?: number): void;\n    getRangeAt(index: number): Range;\n    modify(alter?: string, direction?: string, granularity?: string): void;\n    removeAllRanges(): void;\n    removeRange(range: Range): void;\n    selectAllChildren(node: Node): void;\n    setBaseAndExtent(anchorNode: Node, anchorOffset: number, focusNode: Node, focusOffset: number): void;\n    setPosition(node: Node | null, offset?: number): void;\n    toString(): string;\n}\n\ndeclare var Selection: {\n    prototype: Selection;\n    new(): Selection;\n    toString(): string;\n};\n\ninterface ServiceWorkerEventMap extends AbstractWorkerEventMap {\n    \"statechange\": Event;\n}\n\n/**\n * This ServiceWorker API interface provides a reference to a service worker. Multiple browsing contexts (e.g. pages, workers, etc.) can be associated with the same service worker, each through a unique ServiceWorker object.\n * Available only in secure contexts.\n */\ninterface ServiceWorker extends EventTarget, AbstractWorker {\n    onstatechange: ((this: ServiceWorker, ev: Event) => any) | null;\n    readonly scriptURL: string;\n    readonly state: ServiceWorkerState;\n    postMessage(message: any, transfer: Transferable[]): void;\n    postMessage(message: any, options?: StructuredSerializeOptions): void;\n    addEventListener<K extends keyof ServiceWorkerEventMap>(type: K, listener: (this: ServiceWorker, ev: ServiceWorkerEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof ServiceWorkerEventMap>(type: K, listener: (this: ServiceWorker, ev: ServiceWorkerEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var ServiceWorker: {\n    prototype: ServiceWorker;\n    new(): ServiceWorker;\n};\n\ninterface ServiceWorkerContainerEventMap {\n    \"controllerchange\": Event;\n    \"message\": MessageEvent;\n    \"messageerror\": MessageEvent;\n}\n\n/**\n * The ServiceWorkerContainer interface of the ServiceWorker API provides an object representing the service worker as an overall unit in the network ecosystem, including facilities to register, unregister and update service workers, and access the state of service workers and their registrations.\n * Available only in secure contexts.\n */\ninterface ServiceWorkerContainer extends EventTarget {\n    readonly controller: ServiceWorker | null;\n    oncontrollerchange: ((this: ServiceWorkerContainer, ev: Event) => any) | null;\n    onmessage: ((this: ServiceWorkerContainer, ev: MessageEvent) => any) | null;\n    onmessageerror: ((this: ServiceWorkerContainer, ev: MessageEvent) => any) | null;\n    readonly ready: Promise<ServiceWorkerRegistration>;\n    getRegistration(clientURL?: string | URL): Promise<ServiceWorkerRegistration | undefined>;\n    getRegistrations(): Promise<ReadonlyArray<ServiceWorkerRegistration>>;\n    register(scriptURL: string | URL, options?: RegistrationOptions): Promise<ServiceWorkerRegistration>;\n    startMessages(): void;\n    addEventListener<K extends keyof ServiceWorkerContainerEventMap>(type: K, listener: (this: ServiceWorkerContainer, ev: ServiceWorkerContainerEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof ServiceWorkerContainerEventMap>(type: K, listener: (this: ServiceWorkerContainer, ev: ServiceWorkerContainerEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var ServiceWorkerContainer: {\n    prototype: ServiceWorkerContainer;\n    new(): ServiceWorkerContainer;\n};\n\ninterface ServiceWorkerRegistrationEventMap {\n    \"updatefound\": Event;\n}\n\n/**\n * This ServiceWorker API interface represents the service worker registration. You register a service worker to control one or more pages that share the same origin.\n * Available only in secure contexts.\n */\ninterface ServiceWorkerRegistration extends EventTarget {\n    readonly active: ServiceWorker | null;\n    readonly installing: ServiceWorker | null;\n    readonly navigationPreload: NavigationPreloadManager;\n    onupdatefound: ((this: ServiceWorkerRegistration, ev: Event) => any) | null;\n    readonly pushManager: PushManager;\n    readonly scope: string;\n    readonly updateViaCache: ServiceWorkerUpdateViaCache;\n    readonly waiting: ServiceWorker | null;\n    getNotifications(filter?: GetNotificationOptions): Promise<Notification[]>;\n    showNotification(title: string, options?: NotificationOptions): Promise<void>;\n    unregister(): Promise<boolean>;\n    update(): Promise<void>;\n    addEventListener<K extends keyof ServiceWorkerRegistrationEventMap>(type: K, listener: (this: ServiceWorkerRegistration, ev: ServiceWorkerRegistrationEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof ServiceWorkerRegistrationEventMap>(type: K, listener: (this: ServiceWorkerRegistration, ev: ServiceWorkerRegistrationEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var ServiceWorkerRegistration: {\n    prototype: ServiceWorkerRegistration;\n    new(): ServiceWorkerRegistration;\n};\n\ninterface ShadowRootEventMap {\n    \"slotchange\": Event;\n}\n\ninterface ShadowRoot extends DocumentFragment, DocumentOrShadowRoot, InnerHTML {\n    readonly delegatesFocus: boolean;\n    readonly host: Element;\n    readonly mode: ShadowRootMode;\n    onslotchange: ((this: ShadowRoot, ev: Event) => any) | null;\n    readonly slotAssignment: SlotAssignmentMode;\n    /** Throws a \"NotSupportedError\" DOMException if context object is a shadow root. */\n    addEventListener<K extends keyof ShadowRootEventMap>(type: K, listener: (this: ShadowRoot, ev: ShadowRootEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof ShadowRootEventMap>(type: K, listener: (this: ShadowRoot, ev: ShadowRootEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var ShadowRoot: {\n    prototype: ShadowRoot;\n    new(): ShadowRoot;\n};\n\ninterface SharedWorker extends EventTarget, AbstractWorker {\n    /** Returns sharedWorker's MessagePort object which can be used to communicate with the global environment. */\n    readonly port: MessagePort;\n    addEventListener<K extends keyof AbstractWorkerEventMap>(type: K, listener: (this: SharedWorker, ev: AbstractWorkerEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof AbstractWorkerEventMap>(type: K, listener: (this: SharedWorker, ev: AbstractWorkerEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SharedWorker: {\n    prototype: SharedWorker;\n    new(scriptURL: string | URL, options?: string | WorkerOptions): SharedWorker;\n};\n\ninterface Slottable {\n    readonly assignedSlot: HTMLSlotElement | null;\n}\n\ninterface SourceBufferEventMap {\n    \"abort\": Event;\n    \"error\": Event;\n    \"update\": Event;\n    \"updateend\": Event;\n    \"updatestart\": Event;\n}\n\n/** A chunk of media to be passed into an HTMLMediaElement and played, via a MediaSource object. This can be made up of one or several media segments. */\ninterface SourceBuffer extends EventTarget {\n    appendWindowEnd: number;\n    appendWindowStart: number;\n    readonly buffered: TimeRanges;\n    mode: AppendMode;\n    onabort: ((this: SourceBuffer, ev: Event) => any) | null;\n    onerror: ((this: SourceBuffer, ev: Event) => any) | null;\n    onupdate: ((this: SourceBuffer, ev: Event) => any) | null;\n    onupdateend: ((this: SourceBuffer, ev: Event) => any) | null;\n    onupdatestart: ((this: SourceBuffer, ev: Event) => any) | null;\n    timestampOffset: number;\n    readonly updating: boolean;\n    abort(): void;\n    appendBuffer(data: BufferSource): void;\n    changeType(type: string): void;\n    remove(start: number, end: number): void;\n    addEventListener<K extends keyof SourceBufferEventMap>(type: K, listener: (this: SourceBuffer, ev: SourceBufferEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SourceBufferEventMap>(type: K, listener: (this: SourceBuffer, ev: SourceBufferEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SourceBuffer: {\n    prototype: SourceBuffer;\n    new(): SourceBuffer;\n};\n\ninterface SourceBufferListEventMap {\n    \"addsourcebuffer\": Event;\n    \"removesourcebuffer\": Event;\n}\n\n/** A simple container list for multiple SourceBuffer objects. */\ninterface SourceBufferList extends EventTarget {\n    readonly length: number;\n    onaddsourcebuffer: ((this: SourceBufferList, ev: Event) => any) | null;\n    onremovesourcebuffer: ((this: SourceBufferList, ev: Event) => any) | null;\n    addEventListener<K extends keyof SourceBufferListEventMap>(type: K, listener: (this: SourceBufferList, ev: SourceBufferListEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SourceBufferListEventMap>(type: K, listener: (this: SourceBufferList, ev: SourceBufferListEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n    [index: number]: SourceBuffer;\n}\n\ndeclare var SourceBufferList: {\n    prototype: SourceBufferList;\n    new(): SourceBufferList;\n};\n\ninterface SpeechRecognitionAlternative {\n    readonly confidence: number;\n    readonly transcript: string;\n}\n\ndeclare var SpeechRecognitionAlternative: {\n    prototype: SpeechRecognitionAlternative;\n    new(): SpeechRecognitionAlternative;\n};\n\ninterface SpeechRecognitionResult {\n    readonly isFinal: boolean;\n    readonly length: number;\n    item(index: number): SpeechRecognitionAlternative;\n    [index: number]: SpeechRecognitionAlternative;\n}\n\ndeclare var SpeechRecognitionResult: {\n    prototype: SpeechRecognitionResult;\n    new(): SpeechRecognitionResult;\n};\n\ninterface SpeechRecognitionResultList {\n    readonly length: number;\n    item(index: number): SpeechRecognitionResult;\n    [index: number]: SpeechRecognitionResult;\n}\n\ndeclare var SpeechRecognitionResultList: {\n    prototype: SpeechRecognitionResultList;\n    new(): SpeechRecognitionResultList;\n};\n\ninterface SpeechSynthesisEventMap {\n    \"voiceschanged\": Event;\n}\n\n/** This Web Speech API interface is the controller interface for the speech service; this can be used to retrieve information about the synthesis voices available on the device, start and pause speech, and other commands besides. */\ninterface SpeechSynthesis extends EventTarget {\n    onvoiceschanged: ((this: SpeechSynthesis, ev: Event) => any) | null;\n    readonly paused: boolean;\n    readonly pending: boolean;\n    readonly speaking: boolean;\n    cancel(): void;\n    getVoices(): SpeechSynthesisVoice[];\n    pause(): void;\n    resume(): void;\n    speak(utterance: SpeechSynthesisUtterance): void;\n    addEventListener<K extends keyof SpeechSynthesisEventMap>(type: K, listener: (this: SpeechSynthesis, ev: SpeechSynthesisEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SpeechSynthesisEventMap>(type: K, listener: (this: SpeechSynthesis, ev: SpeechSynthesisEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SpeechSynthesis: {\n    prototype: SpeechSynthesis;\n    new(): SpeechSynthesis;\n};\n\ninterface SpeechSynthesisErrorEvent extends SpeechSynthesisEvent {\n    readonly error: SpeechSynthesisErrorCode;\n}\n\ndeclare var SpeechSynthesisErrorEvent: {\n    prototype: SpeechSynthesisErrorEvent;\n    new(type: string, eventInitDict: SpeechSynthesisErrorEventInit): SpeechSynthesisErrorEvent;\n};\n\n/** This Web Speech API interface contains information about the current state of SpeechSynthesisUtterance objects that have been processed in the speech service. */\ninterface SpeechSynthesisEvent extends Event {\n    readonly charIndex: number;\n    readonly charLength: number;\n    readonly elapsedTime: number;\n    readonly name: string;\n    readonly utterance: SpeechSynthesisUtterance;\n}\n\ndeclare var SpeechSynthesisEvent: {\n    prototype: SpeechSynthesisEvent;\n    new(type: string, eventInitDict: SpeechSynthesisEventInit): SpeechSynthesisEvent;\n};\n\ninterface SpeechSynthesisUtteranceEventMap {\n    \"boundary\": SpeechSynthesisEvent;\n    \"end\": SpeechSynthesisEvent;\n    \"error\": SpeechSynthesisErrorEvent;\n    \"mark\": SpeechSynthesisEvent;\n    \"pause\": SpeechSynthesisEvent;\n    \"resume\": SpeechSynthesisEvent;\n    \"start\": SpeechSynthesisEvent;\n}\n\n/** This Web Speech API interface represents a speech request. It contains the content the speech service should read and information about how to read it (e.g. language, pitch and volume.) */\ninterface SpeechSynthesisUtterance extends EventTarget {\n    lang: string;\n    onboundary: ((this: SpeechSynthesisUtterance, ev: SpeechSynthesisEvent) => any) | null;\n    onend: ((this: SpeechSynthesisUtterance, ev: SpeechSynthesisEvent) => any) | null;\n    onerror: ((this: SpeechSynthesisUtterance, ev: SpeechSynthesisErrorEvent) => any) | null;\n    onmark: ((this: SpeechSynthesisUtterance, ev: SpeechSynthesisEvent) => any) | null;\n    onpause: ((this: SpeechSynthesisUtterance, ev: SpeechSynthesisEvent) => any) | null;\n    onresume: ((this: SpeechSynthesisUtterance, ev: SpeechSynthesisEvent) => any) | null;\n    onstart: ((this: SpeechSynthesisUtterance, ev: SpeechSynthesisEvent) => any) | null;\n    pitch: number;\n    rate: number;\n    text: string;\n    voice: SpeechSynthesisVoice | null;\n    volume: number;\n    addEventListener<K extends keyof SpeechSynthesisUtteranceEventMap>(type: K, listener: (this: SpeechSynthesisUtterance, ev: SpeechSynthesisUtteranceEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SpeechSynthesisUtteranceEventMap>(type: K, listener: (this: SpeechSynthesisUtterance, ev: SpeechSynthesisUtteranceEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SpeechSynthesisUtterance: {\n    prototype: SpeechSynthesisUtterance;\n    new(text?: string): SpeechSynthesisUtterance;\n};\n\n/** This Web Speech API interface represents a voice that the system supports. Every SpeechSynthesisVoice has its own relative speech service including information about language, name and URI. */\ninterface SpeechSynthesisVoice {\n    readonly default: boolean;\n    readonly lang: string;\n    readonly localService: boolean;\n    readonly name: string;\n    readonly voiceURI: string;\n}\n\ndeclare var SpeechSynthesisVoice: {\n    prototype: SpeechSynthesisVoice;\n    new(): SpeechSynthesisVoice;\n};\n\ninterface StaticRange extends AbstractRange {\n}\n\ndeclare var StaticRange: {\n    prototype: StaticRange;\n    new(init: StaticRangeInit): StaticRange;\n};\n\n/** The pan property takes a unitless value between -1 (full left pan) and 1 (full right pan). This interface was introduced as a much simpler way to apply a simple panning effect than having to use a full PannerNode. */\ninterface StereoPannerNode extends AudioNode {\n    readonly pan: AudioParam;\n}\n\ndeclare var StereoPannerNode: {\n    prototype: StereoPannerNode;\n    new(context: BaseAudioContext, options?: StereoPannerOptions): StereoPannerNode;\n};\n\n/** This Web Storage API interface provides access to a particular domain's session or local storage. It allows, for example, the addition, modification, or deletion of stored data items. */\ninterface Storage {\n    /** Returns the number of key/value pairs. */\n    readonly length: number;\n    /**\n     * Removes all key/value pairs, if there are any.\n     *\n     * Dispatches a storage event on Window objects holding an equivalent Storage object.\n     */\n    clear(): void;\n    /** Returns the current value associated with the given key, or null if the given key does not exist. */\n    getItem(key: string): string | null;\n    /** Returns the name of the nth key, or null if n is greater than or equal to the number of key/value pairs. */\n    key(index: number): string | null;\n    /**\n     * Removes the key/value pair with the given key, if a key/value pair with the given key exists.\n     *\n     * Dispatches a storage event on Window objects holding an equivalent Storage object.\n     */\n    removeItem(key: string): void;\n    /**\n     * Sets the value of the pair identified by key to value, creating a new key/value pair if none existed for key previously.\n     *\n     * Throws a \"QuotaExceededError\" DOMException exception if the new value couldn't be set. (Setting could fail if, e.g., the user has disabled storage for the site, or if the quota has been exceeded.)\n     *\n     * Dispatches a storage event on Window objects holding an equivalent Storage object.\n     */\n    setItem(key: string, value: string): void;\n    [name: string]: any;\n}\n\ndeclare var Storage: {\n    prototype: Storage;\n    new(): Storage;\n};\n\n/** A StorageEvent is sent to a window when a storage area it has access to is changed within the context of another document. */\ninterface StorageEvent extends Event {\n    /** Returns the key of the storage item being changed. */\n    readonly key: string | null;\n    /** Returns the new value of the key of the storage item whose value is being changed. */\n    readonly newValue: string | null;\n    /** Returns the old value of the key of the storage item whose value is being changed. */\n    readonly oldValue: string | null;\n    /** Returns the Storage object that was affected. */\n    readonly storageArea: Storage | null;\n    /** Returns the URL of the document whose storage item changed. */\n    readonly url: string;\n    /** @deprecated */\n    initStorageEvent(type: string, bubbles?: boolean, cancelable?: boolean, key?: string | null, oldValue?: string | null, newValue?: string | null, url?: string | URL, storageArea?: Storage | null): void;\n}\n\ndeclare var StorageEvent: {\n    prototype: StorageEvent;\n    new(type: string, eventInitDict?: StorageEventInit): StorageEvent;\n};\n\n/** Available only in secure contexts. */\ninterface StorageManager {\n    estimate(): Promise<StorageEstimate>;\n    getDirectory(): Promise<FileSystemDirectoryHandle>;\n    persist(): Promise<boolean>;\n    persisted(): Promise<boolean>;\n}\n\ndeclare var StorageManager: {\n    prototype: StorageManager;\n    new(): StorageManager;\n};\n\n/** @deprecated */\ninterface StyleMedia {\n    type: string;\n    matchMedium(mediaquery: string): boolean;\n}\n\n/** A single style sheet. CSS style sheets will further implement the more specialized CSSStyleSheet interface. */\ninterface StyleSheet {\n    disabled: boolean;\n    readonly href: string | null;\n    readonly media: MediaList;\n    readonly ownerNode: Element | ProcessingInstruction | null;\n    readonly parentStyleSheet: CSSStyleSheet | null;\n    readonly title: string | null;\n    readonly type: string;\n}\n\ndeclare var StyleSheet: {\n    prototype: StyleSheet;\n    new(): StyleSheet;\n};\n\n/** A list of StyleSheet. */\ninterface StyleSheetList {\n    readonly length: number;\n    item(index: number): CSSStyleSheet | null;\n    [index: number]: CSSStyleSheet;\n}\n\ndeclare var StyleSheetList: {\n    prototype: StyleSheetList;\n    new(): StyleSheetList;\n};\n\ninterface SubmitEvent extends Event {\n    /** Returns the element representing the submit button that triggered the form submission, or null if the submission was not triggered by a button. */\n    readonly submitter: HTMLElement | null;\n}\n\ndeclare var SubmitEvent: {\n    prototype: SubmitEvent;\n    new(type: string, eventInitDict?: SubmitEventInit): SubmitEvent;\n};\n\n/**\n * This Web Crypto API interface provides a number of low-level cryptographic functions. It is accessed via the Crypto.subtle properties available in a window context (via Window.crypto).\n * Available only in secure contexts.\n */\ninterface SubtleCrypto {\n    decrypt(algorithm: AlgorithmIdentifier | RsaOaepParams | AesCtrParams | AesCbcParams | AesGcmParams, key: CryptoKey, data: BufferSource): Promise<ArrayBuffer>;\n    deriveBits(algorithm: AlgorithmIdentifier | EcdhKeyDeriveParams | HkdfParams | Pbkdf2Params, baseKey: CryptoKey, length: number): Promise<ArrayBuffer>;\n    deriveKey(algorithm: AlgorithmIdentifier | EcdhKeyDeriveParams | HkdfParams | Pbkdf2Params, baseKey: CryptoKey, derivedKeyType: AlgorithmIdentifier | AesDerivedKeyParams | HmacImportParams | HkdfParams | Pbkdf2Params, extractable: boolean, keyUsages: KeyUsage[]): Promise<CryptoKey>;\n    digest(algorithm: AlgorithmIdentifier, data: BufferSource): Promise<ArrayBuffer>;\n    encrypt(algorithm: AlgorithmIdentifier | RsaOaepParams | AesCtrParams | AesCbcParams | AesGcmParams, key: CryptoKey, data: BufferSource): Promise<ArrayBuffer>;\n    exportKey(format: \"jwk\", key: CryptoKey): Promise<JsonWebKey>;\n    exportKey(format: Exclude<KeyFormat, \"jwk\">, key: CryptoKey): Promise<ArrayBuffer>;\n    generateKey(algorithm: RsaHashedKeyGenParams | EcKeyGenParams, extractable: boolean, keyUsages: ReadonlyArray<KeyUsage>): Promise<CryptoKeyPair>;\n    generateKey(algorithm: AesKeyGenParams | HmacKeyGenParams | Pbkdf2Params, extractable: boolean, keyUsages: ReadonlyArray<KeyUsage>): Promise<CryptoKey>;\n    generateKey(algorithm: AlgorithmIdentifier, extractable: boolean, keyUsages: KeyUsage[]): Promise<CryptoKeyPair | CryptoKey>;\n    importKey(format: \"jwk\", keyData: JsonWebKey, algorithm: AlgorithmIdentifier | RsaHashedImportParams | EcKeyImportParams | HmacImportParams | AesKeyAlgorithm, extractable: boolean, keyUsages: ReadonlyArray<KeyUsage>): Promise<CryptoKey>;\n    importKey(format: Exclude<KeyFormat, \"jwk\">, keyData: BufferSource, algorithm: AlgorithmIdentifier | RsaHashedImportParams | EcKeyImportParams | HmacImportParams | AesKeyAlgorithm, extractable: boolean, keyUsages: KeyUsage[]): Promise<CryptoKey>;\n    sign(algorithm: AlgorithmIdentifier | RsaPssParams | EcdsaParams, key: CryptoKey, data: BufferSource): Promise<ArrayBuffer>;\n    unwrapKey(format: KeyFormat, wrappedKey: BufferSource, unwrappingKey: CryptoKey, unwrapAlgorithm: AlgorithmIdentifier | RsaOaepParams | AesCtrParams | AesCbcParams | AesGcmParams, unwrappedKeyAlgorithm: AlgorithmIdentifier | RsaHashedImportParams | EcKeyImportParams | HmacImportParams | AesKeyAlgorithm, extractable: boolean, keyUsages: KeyUsage[]): Promise<CryptoKey>;\n    verify(algorithm: AlgorithmIdentifier | RsaPssParams | EcdsaParams, key: CryptoKey, signature: BufferSource, data: BufferSource): Promise<boolean>;\n    wrapKey(format: KeyFormat, key: CryptoKey, wrappingKey: CryptoKey, wrapAlgorithm: AlgorithmIdentifier | RsaOaepParams | AesCtrParams | AesCbcParams | AesGcmParams): Promise<ArrayBuffer>;\n}\n\ndeclare var SubtleCrypto: {\n    prototype: SubtleCrypto;\n    new(): SubtleCrypto;\n};\n\n/** The textual content of Element or Attr. If an element has no markup within its content, it has a single child implementing Text that contains the element's text. However, if the element contains markup, it is parsed into information items and Text nodes that form its children. */\ninterface Text extends CharacterData, Slottable {\n    /** Returns the combined data of all direct Text node siblings. */\n    readonly wholeText: string;\n    /** Splits data at the given offset and returns the remainder as Text node. */\n    splitText(offset: number): Text;\n}\n\ndeclare var Text: {\n    prototype: Text;\n    new(data?: string): Text;\n};\n\n/** A decoder for a specific method, that is a specific character encoding, like utf-8, iso-8859-2, koi8, cp1261, gbk, etc. A decoder takes a stream of bytes as input and emits a stream of code points. For a more scalable, non-native library, see StringView – a C-like representation of strings based on typed arrays. */\ninterface TextDecoder extends TextDecoderCommon {\n    /**\n     * Returns the result of running encoding's decoder. The method can be invoked zero or more times with options's stream set to true, and then once without options's stream (or set to false), to process a fragmented input. If the invocation without options's stream (or set to false) has no input, it's clearest to omit both arguments.\n     *\n     * ```\n     * var string = \"\", decoder = new TextDecoder(encoding), buffer;\n     * while(buffer = next_chunk()) {\n     *   string += decoder.decode(buffer, {stream:true});\n     * }\n     * string += decoder.decode(); // end-of-queue\n     * ```\n     *\n     * If the error mode is \"fatal\" and encoding's decoder returns error, throws a TypeError.\n     */\n    decode(input?: BufferSource, options?: TextDecodeOptions): string;\n}\n\ndeclare var TextDecoder: {\n    prototype: TextDecoder;\n    new(label?: string, options?: TextDecoderOptions): TextDecoder;\n};\n\ninterface TextDecoderCommon {\n    /** Returns encoding's name, lowercased. */\n    readonly encoding: string;\n    /** Returns true if error mode is \"fatal\", otherwise false. */\n    readonly fatal: boolean;\n    /** Returns the value of ignore BOM. */\n    readonly ignoreBOM: boolean;\n}\n\ninterface TextDecoderStream extends GenericTransformStream, TextDecoderCommon {\n    readonly readable: ReadableStream<string>;\n    readonly writable: WritableStream<BufferSource>;\n}\n\ndeclare var TextDecoderStream: {\n    prototype: TextDecoderStream;\n    new(label?: string, options?: TextDecoderOptions): TextDecoderStream;\n};\n\n/** TextEncoder takes a stream of code points as input and emits a stream of bytes. For a more scalable, non-native library, see StringView – a C-like representation of strings based on typed arrays. */\ninterface TextEncoder extends TextEncoderCommon {\n    /** Returns the result of running UTF-8's encoder. */\n    encode(input?: string): Uint8Array;\n    /** Runs the UTF-8 encoder on source, stores the result of that operation into destination, and returns the progress made as an object wherein read is the number of converted code units of source and written is the number of bytes modified in destination. */\n    encodeInto(source: string, destination: Uint8Array): TextEncoderEncodeIntoResult;\n}\n\ndeclare var TextEncoder: {\n    prototype: TextEncoder;\n    new(): TextEncoder;\n};\n\ninterface TextEncoderCommon {\n    /** Returns \"utf-8\". */\n    readonly encoding: string;\n}\n\ninterface TextEncoderStream extends GenericTransformStream, TextEncoderCommon {\n    readonly readable: ReadableStream<Uint8Array>;\n    readonly writable: WritableStream<string>;\n}\n\ndeclare var TextEncoderStream: {\n    prototype: TextEncoderStream;\n    new(): TextEncoderStream;\n};\n\n/** The dimensions of a piece of text in the canvas, as created by the CanvasRenderingContext2D.measureText() method. */\ninterface TextMetrics {\n    /** Returns the measurement described below. */\n    readonly actualBoundingBoxAscent: number;\n    /** Returns the measurement described below. */\n    readonly actualBoundingBoxDescent: number;\n    /** Returns the measurement described below. */\n    readonly actualBoundingBoxLeft: number;\n    /** Returns the measurement described below. */\n    readonly actualBoundingBoxRight: number;\n    /** Returns the measurement described below. */\n    readonly fontBoundingBoxAscent: number;\n    /** Returns the measurement described below. */\n    readonly fontBoundingBoxDescent: number;\n    /** Returns the measurement described below. */\n    readonly width: number;\n}\n\ndeclare var TextMetrics: {\n    prototype: TextMetrics;\n    new(): TextMetrics;\n};\n\ninterface TextTrackEventMap {\n    \"cuechange\": Event;\n}\n\n/** This interface also inherits properties from EventTarget. */\ninterface TextTrack extends EventTarget {\n    /** Returns the text track cues from the text track list of cues that are currently active (i.e. that start before the current playback position and end after it), as a TextTrackCueList object. */\n    readonly activeCues: TextTrackCueList | null;\n    /** Returns the text track list of cues, as a TextTrackCueList object. */\n    readonly cues: TextTrackCueList | null;\n    /**\n     * Returns the ID of the given track.\n     *\n     * For in-band tracks, this is the ID that can be used with a fragment if the format supports media fragment syntax, and that can be used with the getTrackById() method.\n     *\n     * For TextTrack objects corresponding to track elements, this is the ID of the track element.\n     */\n    readonly id: string;\n    /** Returns the text track in-band metadata track dispatch type string. */\n    readonly inBandMetadataTrackDispatchType: string;\n    /** Returns the text track kind string. */\n    readonly kind: TextTrackKind;\n    /** Returns the text track label, if there is one, or the empty string otherwise (indicating that a custom label probably needs to be generated from the other attributes of the object if the object is exposed to the user). */\n    readonly label: string;\n    /** Returns the text track language string. */\n    readonly language: string;\n    /**\n     * Returns the text track mode, represented by a string from the following list:\n     *\n     * Can be set, to change the mode.\n     */\n    mode: TextTrackMode;\n    oncuechange: ((this: TextTrack, ev: Event) => any) | null;\n    /** Adds the given cue to textTrack's text track list of cues. */\n    addCue(cue: TextTrackCue): void;\n    /** Removes the given cue from textTrack's text track list of cues. */\n    removeCue(cue: TextTrackCue): void;\n    addEventListener<K extends keyof TextTrackEventMap>(type: K, listener: (this: TextTrack, ev: TextTrackEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof TextTrackEventMap>(type: K, listener: (this: TextTrack, ev: TextTrackEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var TextTrack: {\n    prototype: TextTrack;\n    new(): TextTrack;\n};\n\ninterface TextTrackCueEventMap {\n    \"enter\": Event;\n    \"exit\": Event;\n}\n\n/** TextTrackCues represent a string of text that will be displayed for some duration of time on a TextTrack. This includes the start and end times that the cue will be displayed. A TextTrackCue cannot be used directly, instead one of the derived types (e.g. VTTCue) must be used. */\ninterface TextTrackCue extends EventTarget {\n    /**\n     * Returns the text track cue end time, in seconds.\n     *\n     * Can be set.\n     */\n    endTime: number;\n    /**\n     * Returns the text track cue identifier.\n     *\n     * Can be set.\n     */\n    id: string;\n    onenter: ((this: TextTrackCue, ev: Event) => any) | null;\n    onexit: ((this: TextTrackCue, ev: Event) => any) | null;\n    /**\n     * Returns true if the text track cue pause-on-exit flag is set, false otherwise.\n     *\n     * Can be set.\n     */\n    pauseOnExit: boolean;\n    /**\n     * Returns the text track cue start time, in seconds.\n     *\n     * Can be set.\n     */\n    startTime: number;\n    /** Returns the TextTrack object to which this text track cue belongs, if any, or null otherwise. */\n    readonly track: TextTrack | null;\n    addEventListener<K extends keyof TextTrackCueEventMap>(type: K, listener: (this: TextTrackCue, ev: TextTrackCueEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof TextTrackCueEventMap>(type: K, listener: (this: TextTrackCue, ev: TextTrackCueEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var TextTrackCue: {\n    prototype: TextTrackCue;\n    new(): TextTrackCue;\n};\n\ninterface TextTrackCueList {\n    /** Returns the number of cues in the list. */\n    readonly length: number;\n    /**\n     * Returns the first text track cue (in text track cue order) with text track cue identifier id.\n     *\n     * Returns null if none of the cues have the given identifier or if the argument is the empty string.\n     */\n    getCueById(id: string): TextTrackCue | null;\n    [index: number]: TextTrackCue;\n}\n\ndeclare var TextTrackCueList: {\n    prototype: TextTrackCueList;\n    new(): TextTrackCueList;\n};\n\ninterface TextTrackListEventMap {\n    \"addtrack\": TrackEvent;\n    \"change\": Event;\n    \"removetrack\": TrackEvent;\n}\n\ninterface TextTrackList extends EventTarget {\n    readonly length: number;\n    onaddtrack: ((this: TextTrackList, ev: TrackEvent) => any) | null;\n    onchange: ((this: TextTrackList, ev: Event) => any) | null;\n    onremovetrack: ((this: TextTrackList, ev: TrackEvent) => any) | null;\n    getTrackById(id: string): TextTrack | null;\n    addEventListener<K extends keyof TextTrackListEventMap>(type: K, listener: (this: TextTrackList, ev: TextTrackListEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof TextTrackListEventMap>(type: K, listener: (this: TextTrackList, ev: TextTrackListEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n    [index: number]: TextTrack;\n}\n\ndeclare var TextTrackList: {\n    prototype: TextTrackList;\n    new(): TextTrackList;\n};\n\n/** Used to represent a set of time ranges, primarily for the purpose of tracking which portions of media have been buffered when loading it for use by the <audio> and <video> elements. */\ninterface TimeRanges {\n    /** Returns the number of ranges in the object. */\n    readonly length: number;\n    /**\n     * Returns the time for the end of the range with the given index.\n     *\n     * Throws an \"IndexSizeError\" DOMException if the index is out of range.\n     */\n    end(index: number): number;\n    /**\n     * Returns the time for the start of the range with the given index.\n     *\n     * Throws an \"IndexSizeError\" DOMException if the index is out of range.\n     */\n    start(index: number): number;\n}\n\ndeclare var TimeRanges: {\n    prototype: TimeRanges;\n    new(): TimeRanges;\n};\n\n/** A single contact point on a touch-sensitive device. The contact point is commonly a finger or stylus and the device may be a touchscreen or trackpad. */\ninterface Touch {\n    readonly clientX: number;\n    readonly clientY: number;\n    readonly force: number;\n    readonly identifier: number;\n    readonly pageX: number;\n    readonly pageY: number;\n    readonly radiusX: number;\n    readonly radiusY: number;\n    readonly rotationAngle: number;\n    readonly screenX: number;\n    readonly screenY: number;\n    readonly target: EventTarget;\n}\n\ndeclare var Touch: {\n    prototype: Touch;\n    new(touchInitDict: TouchInit): Touch;\n};\n\n/** An event sent when the state of contacts with a touch-sensitive surface changes. This surface can be a touch screen or trackpad, for example. The event can describe one or more points of contact with the screen and includes support for detecting movement, addition and removal of contact points, and so forth. */\ninterface TouchEvent extends UIEvent {\n    readonly altKey: boolean;\n    readonly changedTouches: TouchList;\n    readonly ctrlKey: boolean;\n    readonly metaKey: boolean;\n    readonly shiftKey: boolean;\n    readonly targetTouches: TouchList;\n    readonly touches: TouchList;\n}\n\ndeclare var TouchEvent: {\n    prototype: TouchEvent;\n    new(type: string, eventInitDict?: TouchEventInit): TouchEvent;\n};\n\n/** A list of contact points on a touch surface. For example, if the user has three fingers on the touch surface (such as a screen or trackpad), the corresponding TouchList object would have one Touch object for each finger, for a total of three entries. */\ninterface TouchList {\n    readonly length: number;\n    item(index: number): Touch | null;\n    [index: number]: Touch;\n}\n\ndeclare var TouchList: {\n    prototype: TouchList;\n    new(): TouchList;\n};\n\n/** The TrackEvent interface, part of the HTML DOM specification, is used for events which represent changes to the set of available tracks on an HTML media element; these events are addtrack and removetrack. */\ninterface TrackEvent extends Event {\n    /** Returns the track object (TextTrack, AudioTrack, or VideoTrack) to which the event relates. */\n    readonly track: TextTrack | null;\n}\n\ndeclare var TrackEvent: {\n    prototype: TrackEvent;\n    new(type: string, eventInitDict?: TrackEventInit): TrackEvent;\n};\n\ninterface TransformStream<I = any, O = any> {\n    readonly readable: ReadableStream<O>;\n    readonly writable: WritableStream<I>;\n}\n\ndeclare var TransformStream: {\n    prototype: TransformStream;\n    new<I = any, O = any>(transformer?: Transformer<I, O>, writableStrategy?: QueuingStrategy<I>, readableStrategy?: QueuingStrategy<O>): TransformStream<I, O>;\n};\n\ninterface TransformStreamDefaultController<O = any> {\n    readonly desiredSize: number | null;\n    enqueue(chunk?: O): void;\n    error(reason?: any): void;\n    terminate(): void;\n}\n\ndeclare var TransformStreamDefaultController: {\n    prototype: TransformStreamDefaultController;\n    new(): TransformStreamDefaultController;\n};\n\n/** Events providing information related to transitions. */\ninterface TransitionEvent extends Event {\n    readonly elapsedTime: number;\n    readonly propertyName: string;\n    readonly pseudoElement: string;\n}\n\ndeclare var TransitionEvent: {\n    prototype: TransitionEvent;\n    new(type: string, transitionEventInitDict?: TransitionEventInit): TransitionEvent;\n};\n\n/** The nodes of a document subtree and a position within them. */\ninterface TreeWalker {\n    currentNode: Node;\n    readonly filter: NodeFilter | null;\n    readonly root: Node;\n    readonly whatToShow: number;\n    firstChild(): Node | null;\n    lastChild(): Node | null;\n    nextNode(): Node | null;\n    nextSibling(): Node | null;\n    parentNode(): Node | null;\n    previousNode(): Node | null;\n    previousSibling(): Node | null;\n}\n\ndeclare var TreeWalker: {\n    prototype: TreeWalker;\n    new(): TreeWalker;\n};\n\n/** Simple user interface events. */\ninterface UIEvent extends Event {\n    readonly detail: number;\n    readonly view: Window | null;\n    /** @deprecated */\n    readonly which: number;\n    /** @deprecated */\n    initUIEvent(typeArg: string, bubblesArg?: boolean, cancelableArg?: boolean, viewArg?: Window | null, detailArg?: number): void;\n}\n\ndeclare var UIEvent: {\n    prototype: UIEvent;\n    new(type: string, eventInitDict?: UIEventInit): UIEvent;\n};\n\n/** The URL interface represents an object providing static methods used for creating object URLs. */\ninterface URL {\n    hash: string;\n    host: string;\n    hostname: string;\n    href: string;\n    toString(): string;\n    readonly origin: string;\n    password: string;\n    pathname: string;\n    port: string;\n    protocol: string;\n    search: string;\n    readonly searchParams: URLSearchParams;\n    username: string;\n    toJSON(): string;\n}\n\ndeclare var URL: {\n    prototype: URL;\n    new(url: string | URL, base?: string | URL): URL;\n    createObjectURL(obj: Blob | MediaSource): string;\n    revokeObjectURL(url: string): void;\n};\n\ntype webkitURL = URL;\ndeclare var webkitURL: typeof URL;\n\ninterface URLSearchParams {\n    /** Appends a specified key/value pair as a new search parameter. */\n    append(name: string, value: string): void;\n    /** Deletes the given search parameter, and its associated value, from the list of all search parameters. */\n    delete(name: string): void;\n    /** Returns the first value associated to the given search parameter. */\n    get(name: string): string | null;\n    /** Returns all the values association with a given search parameter. */\n    getAll(name: string): string[];\n    /** Returns a Boolean indicating if such a search parameter exists. */\n    has(name: string): boolean;\n    /** Sets the value associated to a given search parameter to the given value. If there were several values, delete the others. */\n    set(name: string, value: string): void;\n    sort(): void;\n    /** Returns a string containing a query string suitable for use in a URL. Does not include the question mark. */\n    toString(): string;\n    forEach(callbackfn: (value: string, key: string, parent: URLSearchParams) => void, thisArg?: any): void;\n}\n\ndeclare var URLSearchParams: {\n    prototype: URLSearchParams;\n    new(init?: string[][] | Record<string, string> | string | URLSearchParams): URLSearchParams;\n    toString(): string;\n};\n\ninterface VTTCue extends TextTrackCue {\n    align: AlignSetting;\n    line: LineAndPositionSetting;\n    lineAlign: LineAlignSetting;\n    position: LineAndPositionSetting;\n    positionAlign: PositionAlignSetting;\n    region: VTTRegion | null;\n    size: number;\n    snapToLines: boolean;\n    text: string;\n    vertical: DirectionSetting;\n    getCueAsHTML(): DocumentFragment;\n    addEventListener<K extends keyof TextTrackCueEventMap>(type: K, listener: (this: VTTCue, ev: TextTrackCueEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof TextTrackCueEventMap>(type: K, listener: (this: VTTCue, ev: TextTrackCueEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var VTTCue: {\n    prototype: VTTCue;\n    new(startTime: number, endTime: number, text: string): VTTCue;\n};\n\ninterface VTTRegion {\n    id: string;\n    lines: number;\n    regionAnchorX: number;\n    regionAnchorY: number;\n    scroll: ScrollSetting;\n    viewportAnchorX: number;\n    viewportAnchorY: number;\n    width: number;\n}\n\ndeclare var VTTRegion: {\n    prototype: VTTRegion;\n    new(): VTTRegion;\n};\n\n/** The validity states that an element can be in, with respect to constraint validation. Together, they help explain why an element's value fails to validate, if it's not valid. */\ninterface ValidityState {\n    readonly badInput: boolean;\n    readonly customError: boolean;\n    readonly patternMismatch: boolean;\n    readonly rangeOverflow: boolean;\n    readonly rangeUnderflow: boolean;\n    readonly stepMismatch: boolean;\n    readonly tooLong: boolean;\n    readonly tooShort: boolean;\n    readonly typeMismatch: boolean;\n    readonly valid: boolean;\n    readonly valueMissing: boolean;\n}\n\ndeclare var ValidityState: {\n    prototype: ValidityState;\n    new(): ValidityState;\n};\n\ninterface VideoColorSpace {\n    readonly fullRange: boolean | null;\n    readonly matrix: VideoMatrixCoefficients | null;\n    readonly primaries: VideoColorPrimaries | null;\n    readonly transfer: VideoTransferCharacteristics | null;\n    toJSON(): VideoColorSpaceInit;\n}\n\ndeclare var VideoColorSpace: {\n    prototype: VideoColorSpace;\n    new(init?: VideoColorSpaceInit): VideoColorSpace;\n};\n\n/** Returned by the HTMLVideoElement.getVideoPlaybackQuality() method and contains metrics that can be used to determine the playback quality of a video. */\ninterface VideoPlaybackQuality {\n    /** @deprecated */\n    readonly corruptedVideoFrames: number;\n    readonly creationTime: DOMHighResTimeStamp;\n    readonly droppedVideoFrames: number;\n    readonly totalVideoFrames: number;\n}\n\ndeclare var VideoPlaybackQuality: {\n    prototype: VideoPlaybackQuality;\n    new(): VideoPlaybackQuality;\n};\n\ninterface VisualViewportEventMap {\n    \"resize\": Event;\n    \"scroll\": Event;\n}\n\ninterface VisualViewport extends EventTarget {\n    readonly height: number;\n    readonly offsetLeft: number;\n    readonly offsetTop: number;\n    onresize: ((this: VisualViewport, ev: Event) => any) | null;\n    onscroll: ((this: VisualViewport, ev: Event) => any) | null;\n    readonly pageLeft: number;\n    readonly pageTop: number;\n    readonly scale: number;\n    readonly width: number;\n    addEventListener<K extends keyof VisualViewportEventMap>(type: K, listener: (this: VisualViewport, ev: VisualViewportEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof VisualViewportEventMap>(type: K, listener: (this: VisualViewport, ev: VisualViewportEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var VisualViewport: {\n    prototype: VisualViewport;\n    new(): VisualViewport;\n};\n\ninterface WEBGL_color_buffer_float {\n    readonly RGBA32F_EXT: 0x8814;\n    readonly FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE_EXT: 0x8211;\n    readonly UNSIGNED_NORMALIZED_EXT: 0x8C17;\n}\n\ninterface WEBGL_compressed_texture_astc {\n    getSupportedProfiles(): string[];\n    readonly COMPRESSED_RGBA_ASTC_4x4_KHR: 0x93B0;\n    readonly COMPRESSED_RGBA_ASTC_5x4_KHR: 0x93B1;\n    readonly COMPRESSED_RGBA_ASTC_5x5_KHR: 0x93B2;\n    readonly COMPRESSED_RGBA_ASTC_6x5_KHR: 0x93B3;\n    readonly COMPRESSED_RGBA_ASTC_6x6_KHR: 0x93B4;\n    readonly COMPRESSED_RGBA_ASTC_8x5_KHR: 0x93B5;\n    readonly COMPRESSED_RGBA_ASTC_8x6_KHR: 0x93B6;\n    readonly COMPRESSED_RGBA_ASTC_8x8_KHR: 0x93B7;\n    readonly COMPRESSED_RGBA_ASTC_10x5_KHR: 0x93B8;\n    readonly COMPRESSED_RGBA_ASTC_10x6_KHR: 0x93B9;\n    readonly COMPRESSED_RGBA_ASTC_10x8_KHR: 0x93BA;\n    readonly COMPRESSED_RGBA_ASTC_10x10_KHR: 0x93BB;\n    readonly COMPRESSED_RGBA_ASTC_12x10_KHR: 0x93BC;\n    readonly COMPRESSED_RGBA_ASTC_12x12_KHR: 0x93BD;\n    readonly COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR: 0x93D0;\n    readonly COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR: 0x93D1;\n    readonly COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR: 0x93D2;\n    readonly COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR: 0x93D3;\n    readonly COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR: 0x93D4;\n    readonly COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR: 0x93D5;\n    readonly COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR: 0x93D6;\n    readonly COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR: 0x93D7;\n    readonly COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR: 0x93D8;\n    readonly COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR: 0x93D9;\n    readonly COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR: 0x93DA;\n    readonly COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR: 0x93DB;\n    readonly COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR: 0x93DC;\n    readonly COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR: 0x93DD;\n}\n\ninterface WEBGL_compressed_texture_etc {\n    readonly COMPRESSED_R11_EAC: 0x9270;\n    readonly COMPRESSED_SIGNED_R11_EAC: 0x9271;\n    readonly COMPRESSED_RG11_EAC: 0x9272;\n    readonly COMPRESSED_SIGNED_RG11_EAC: 0x9273;\n    readonly COMPRESSED_RGB8_ETC2: 0x9274;\n    readonly COMPRESSED_SRGB8_ETC2: 0x9275;\n    readonly COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2: 0x9276;\n    readonly COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2: 0x9277;\n    readonly COMPRESSED_RGBA8_ETC2_EAC: 0x9278;\n    readonly COMPRESSED_SRGB8_ALPHA8_ETC2_EAC: 0x9279;\n}\n\ninterface WEBGL_compressed_texture_etc1 {\n    readonly COMPRESSED_RGB_ETC1_WEBGL: 0x8D64;\n}\n\n/** The WEBGL_compressed_texture_s3tc extension is part of the WebGL API and exposes four S3TC compressed texture formats. */\ninterface WEBGL_compressed_texture_s3tc {\n    readonly COMPRESSED_RGB_S3TC_DXT1_EXT: 0x83F0;\n    readonly COMPRESSED_RGBA_S3TC_DXT1_EXT: 0x83F1;\n    readonly COMPRESSED_RGBA_S3TC_DXT3_EXT: 0x83F2;\n    readonly COMPRESSED_RGBA_S3TC_DXT5_EXT: 0x83F3;\n}\n\ninterface WEBGL_compressed_texture_s3tc_srgb {\n    readonly COMPRESSED_SRGB_S3TC_DXT1_EXT: 0x8C4C;\n    readonly COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT: 0x8C4D;\n    readonly COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT: 0x8C4E;\n    readonly COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT: 0x8C4F;\n}\n\n/** The WEBGL_debug_renderer_info extension is part of the WebGL API and exposes two constants with information about the graphics driver for debugging purposes. */\ninterface WEBGL_debug_renderer_info {\n    readonly UNMASKED_VENDOR_WEBGL: 0x9245;\n    readonly UNMASKED_RENDERER_WEBGL: 0x9246;\n}\n\ninterface WEBGL_debug_shaders {\n    getTranslatedShaderSource(shader: WebGLShader): string;\n}\n\n/** The WEBGL_depth_texture extension is part of the WebGL API and defines 2D depth and depth-stencil textures. */\ninterface WEBGL_depth_texture {\n    readonly UNSIGNED_INT_24_8_WEBGL: 0x84FA;\n}\n\ninterface WEBGL_draw_buffers {\n    drawBuffersWEBGL(buffers: GLenum[]): void;\n    readonly COLOR_ATTACHMENT0_WEBGL: 0x8CE0;\n    readonly COLOR_ATTACHMENT1_WEBGL: 0x8CE1;\n    readonly COLOR_ATTACHMENT2_WEBGL: 0x8CE2;\n    readonly COLOR_ATTACHMENT3_WEBGL: 0x8CE3;\n    readonly COLOR_ATTACHMENT4_WEBGL: 0x8CE4;\n    readonly COLOR_ATTACHMENT5_WEBGL: 0x8CE5;\n    readonly COLOR_ATTACHMENT6_WEBGL: 0x8CE6;\n    readonly COLOR_ATTACHMENT7_WEBGL: 0x8CE7;\n    readonly COLOR_ATTACHMENT8_WEBGL: 0x8CE8;\n    readonly COLOR_ATTACHMENT9_WEBGL: 0x8CE9;\n    readonly COLOR_ATTACHMENT10_WEBGL: 0x8CEA;\n    readonly COLOR_ATTACHMENT11_WEBGL: 0x8CEB;\n    readonly COLOR_ATTACHMENT12_WEBGL: 0x8CEC;\n    readonly COLOR_ATTACHMENT13_WEBGL: 0x8CED;\n    readonly COLOR_ATTACHMENT14_WEBGL: 0x8CEE;\n    readonly COLOR_ATTACHMENT15_WEBGL: 0x8CEF;\n    readonly DRAW_BUFFER0_WEBGL: 0x8825;\n    readonly DRAW_BUFFER1_WEBGL: 0x8826;\n    readonly DRAW_BUFFER2_WEBGL: 0x8827;\n    readonly DRAW_BUFFER3_WEBGL: 0x8828;\n    readonly DRAW_BUFFER4_WEBGL: 0x8829;\n    readonly DRAW_BUFFER5_WEBGL: 0x882A;\n    readonly DRAW_BUFFER6_WEBGL: 0x882B;\n    readonly DRAW_BUFFER7_WEBGL: 0x882C;\n    readonly DRAW_BUFFER8_WEBGL: 0x882D;\n    readonly DRAW_BUFFER9_WEBGL: 0x882E;\n    readonly DRAW_BUFFER10_WEBGL: 0x882F;\n    readonly DRAW_BUFFER11_WEBGL: 0x8830;\n    readonly DRAW_BUFFER12_WEBGL: 0x8831;\n    readonly DRAW_BUFFER13_WEBGL: 0x8832;\n    readonly DRAW_BUFFER14_WEBGL: 0x8833;\n    readonly DRAW_BUFFER15_WEBGL: 0x8834;\n    readonly MAX_COLOR_ATTACHMENTS_WEBGL: 0x8CDF;\n    readonly MAX_DRAW_BUFFERS_WEBGL: 0x8824;\n}\n\ninterface WEBGL_lose_context {\n    loseContext(): void;\n    restoreContext(): void;\n}\n\ninterface WEBGL_multi_draw {\n    multiDrawArraysInstancedWEBGL(mode: GLenum, firstsList: Int32Array | GLint[], firstsOffset: GLuint, countsList: Int32Array | GLsizei[], countsOffset: GLuint, instanceCountsList: Int32Array | GLsizei[], instanceCountsOffset: GLuint, drawcount: GLsizei): void;\n    multiDrawArraysWEBGL(mode: GLenum, firstsList: Int32Array | GLint[], firstsOffset: GLuint, countsList: Int32Array | GLsizei[], countsOffset: GLuint, drawcount: GLsizei): void;\n    multiDrawElementsInstancedWEBGL(mode: GLenum, countsList: Int32Array | GLsizei[], countsOffset: GLuint, type: GLenum, offsetsList: Int32Array | GLsizei[], offsetsOffset: GLuint, instanceCountsList: Int32Array | GLsizei[], instanceCountsOffset: GLuint, drawcount: GLsizei): void;\n    multiDrawElementsWEBGL(mode: GLenum, countsList: Int32Array | GLsizei[], countsOffset: GLuint, type: GLenum, offsetsList: Int32Array | GLsizei[], offsetsOffset: GLuint, drawcount: GLsizei): void;\n}\n\n/** A WaveShaperNode always has exactly one input and one output. */\ninterface WaveShaperNode extends AudioNode {\n    curve: Float32Array | null;\n    oversample: OverSampleType;\n}\n\ndeclare var WaveShaperNode: {\n    prototype: WaveShaperNode;\n    new(context: BaseAudioContext, options?: WaveShaperOptions): WaveShaperNode;\n};\n\ninterface WebGL2RenderingContext extends WebGL2RenderingContextBase, WebGL2RenderingContextOverloads, WebGLRenderingContextBase {\n}\n\ndeclare var WebGL2RenderingContext: {\n    prototype: WebGL2RenderingContext;\n    new(): WebGL2RenderingContext;\n    readonly READ_BUFFER: 0x0C02;\n    readonly UNPACK_ROW_LENGTH: 0x0CF2;\n    readonly UNPACK_SKIP_ROWS: 0x0CF3;\n    readonly UNPACK_SKIP_PIXELS: 0x0CF4;\n    readonly PACK_ROW_LENGTH: 0x0D02;\n    readonly PACK_SKIP_ROWS: 0x0D03;\n    readonly PACK_SKIP_PIXELS: 0x0D04;\n    readonly COLOR: 0x1800;\n    readonly DEPTH: 0x1801;\n    readonly STENCIL: 0x1802;\n    readonly RED: 0x1903;\n    readonly RGB8: 0x8051;\n    readonly RGBA8: 0x8058;\n    readonly RGB10_A2: 0x8059;\n    readonly TEXTURE_BINDING_3D: 0x806A;\n    readonly UNPACK_SKIP_IMAGES: 0x806D;\n    readonly UNPACK_IMAGE_HEIGHT: 0x806E;\n    readonly TEXTURE_3D: 0x806F;\n    readonly TEXTURE_WRAP_R: 0x8072;\n    readonly MAX_3D_TEXTURE_SIZE: 0x8073;\n    readonly UNSIGNED_INT_2_10_10_10_REV: 0x8368;\n    readonly MAX_ELEMENTS_VERTICES: 0x80E8;\n    readonly MAX_ELEMENTS_INDICES: 0x80E9;\n    readonly TEXTURE_MIN_LOD: 0x813A;\n    readonly TEXTURE_MAX_LOD: 0x813B;\n    readonly TEXTURE_BASE_LEVEL: 0x813C;\n    readonly TEXTURE_MAX_LEVEL: 0x813D;\n    readonly MIN: 0x8007;\n    readonly MAX: 0x8008;\n    readonly DEPTH_COMPONENT24: 0x81A6;\n    readonly MAX_TEXTURE_LOD_BIAS: 0x84FD;\n    readonly TEXTURE_COMPARE_MODE: 0x884C;\n    readonly TEXTURE_COMPARE_FUNC: 0x884D;\n    readonly CURRENT_QUERY: 0x8865;\n    readonly QUERY_RESULT: 0x8866;\n    readonly QUERY_RESULT_AVAILABLE: 0x8867;\n    readonly STREAM_READ: 0x88E1;\n    readonly STREAM_COPY: 0x88E2;\n    readonly STATIC_READ: 0x88E5;\n    readonly STATIC_COPY: 0x88E6;\n    readonly DYNAMIC_READ: 0x88E9;\n    readonly DYNAMIC_COPY: 0x88EA;\n    readonly MAX_DRAW_BUFFERS: 0x8824;\n    readonly DRAW_BUFFER0: 0x8825;\n    readonly DRAW_BUFFER1: 0x8826;\n    readonly DRAW_BUFFER2: 0x8827;\n    readonly DRAW_BUFFER3: 0x8828;\n    readonly DRAW_BUFFER4: 0x8829;\n    readonly DRAW_BUFFER5: 0x882A;\n    readonly DRAW_BUFFER6: 0x882B;\n    readonly DRAW_BUFFER7: 0x882C;\n    readonly DRAW_BUFFER8: 0x882D;\n    readonly DRAW_BUFFER9: 0x882E;\n    readonly DRAW_BUFFER10: 0x882F;\n    readonly DRAW_BUFFER11: 0x8830;\n    readonly DRAW_BUFFER12: 0x8831;\n    readonly DRAW_BUFFER13: 0x8832;\n    readonly DRAW_BUFFER14: 0x8833;\n    readonly DRAW_BUFFER15: 0x8834;\n    readonly MAX_FRAGMENT_UNIFORM_COMPONENTS: 0x8B49;\n    readonly MAX_VERTEX_UNIFORM_COMPONENTS: 0x8B4A;\n    readonly SAMPLER_3D: 0x8B5F;\n    readonly SAMPLER_2D_SHADOW: 0x8B62;\n    readonly FRAGMENT_SHADER_DERIVATIVE_HINT: 0x8B8B;\n    readonly PIXEL_PACK_BUFFER: 0x88EB;\n    readonly PIXEL_UNPACK_BUFFER: 0x88EC;\n    readonly PIXEL_PACK_BUFFER_BINDING: 0x88ED;\n    readonly PIXEL_UNPACK_BUFFER_BINDING: 0x88EF;\n    readonly FLOAT_MAT2x3: 0x8B65;\n    readonly FLOAT_MAT2x4: 0x8B66;\n    readonly FLOAT_MAT3x2: 0x8B67;\n    readonly FLOAT_MAT3x4: 0x8B68;\n    readonly FLOAT_MAT4x2: 0x8B69;\n    readonly FLOAT_MAT4x3: 0x8B6A;\n    readonly SRGB: 0x8C40;\n    readonly SRGB8: 0x8C41;\n    readonly SRGB8_ALPHA8: 0x8C43;\n    readonly COMPARE_REF_TO_TEXTURE: 0x884E;\n    readonly RGBA32F: 0x8814;\n    readonly RGB32F: 0x8815;\n    readonly RGBA16F: 0x881A;\n    readonly RGB16F: 0x881B;\n    readonly VERTEX_ATTRIB_ARRAY_INTEGER: 0x88FD;\n    readonly MAX_ARRAY_TEXTURE_LAYERS: 0x88FF;\n    readonly MIN_PROGRAM_TEXEL_OFFSET: 0x8904;\n    readonly MAX_PROGRAM_TEXEL_OFFSET: 0x8905;\n    readonly MAX_VARYING_COMPONENTS: 0x8B4B;\n    readonly TEXTURE_2D_ARRAY: 0x8C1A;\n    readonly TEXTURE_BINDING_2D_ARRAY: 0x8C1D;\n    readonly R11F_G11F_B10F: 0x8C3A;\n    readonly UNSIGNED_INT_10F_11F_11F_REV: 0x8C3B;\n    readonly RGB9_E5: 0x8C3D;\n    readonly UNSIGNED_INT_5_9_9_9_REV: 0x8C3E;\n    readonly TRANSFORM_FEEDBACK_BUFFER_MODE: 0x8C7F;\n    readonly MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS: 0x8C80;\n    readonly TRANSFORM_FEEDBACK_VARYINGS: 0x8C83;\n    readonly TRANSFORM_FEEDBACK_BUFFER_START: 0x8C84;\n    readonly TRANSFORM_FEEDBACK_BUFFER_SIZE: 0x8C85;\n    readonly TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN: 0x8C88;\n    readonly RASTERIZER_DISCARD: 0x8C89;\n    readonly MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS: 0x8C8A;\n    readonly MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS: 0x8C8B;\n    readonly INTERLEAVED_ATTRIBS: 0x8C8C;\n    readonly SEPARATE_ATTRIBS: 0x8C8D;\n    readonly TRANSFORM_FEEDBACK_BUFFER: 0x8C8E;\n    readonly TRANSFORM_FEEDBACK_BUFFER_BINDING: 0x8C8F;\n    readonly RGBA32UI: 0x8D70;\n    readonly RGB32UI: 0x8D71;\n    readonly RGBA16UI: 0x8D76;\n    readonly RGB16UI: 0x8D77;\n    readonly RGBA8UI: 0x8D7C;\n    readonly RGB8UI: 0x8D7D;\n    readonly RGBA32I: 0x8D82;\n    readonly RGB32I: 0x8D83;\n    readonly RGBA16I: 0x8D88;\n    readonly RGB16I: 0x8D89;\n    readonly RGBA8I: 0x8D8E;\n    readonly RGB8I: 0x8D8F;\n    readonly RED_INTEGER: 0x8D94;\n    readonly RGB_INTEGER: 0x8D98;\n    readonly RGBA_INTEGER: 0x8D99;\n    readonly SAMPLER_2D_ARRAY: 0x8DC1;\n    readonly SAMPLER_2D_ARRAY_SHADOW: 0x8DC4;\n    readonly SAMPLER_CUBE_SHADOW: 0x8DC5;\n    readonly UNSIGNED_INT_VEC2: 0x8DC6;\n    readonly UNSIGNED_INT_VEC3: 0x8DC7;\n    readonly UNSIGNED_INT_VEC4: 0x8DC8;\n    readonly INT_SAMPLER_2D: 0x8DCA;\n    readonly INT_SAMPLER_3D: 0x8DCB;\n    readonly INT_SAMPLER_CUBE: 0x8DCC;\n    readonly INT_SAMPLER_2D_ARRAY: 0x8DCF;\n    readonly UNSIGNED_INT_SAMPLER_2D: 0x8DD2;\n    readonly UNSIGNED_INT_SAMPLER_3D: 0x8DD3;\n    readonly UNSIGNED_INT_SAMPLER_CUBE: 0x8DD4;\n    readonly UNSIGNED_INT_SAMPLER_2D_ARRAY: 0x8DD7;\n    readonly DEPTH_COMPONENT32F: 0x8CAC;\n    readonly DEPTH32F_STENCIL8: 0x8CAD;\n    readonly FLOAT_32_UNSIGNED_INT_24_8_REV: 0x8DAD;\n    readonly FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING: 0x8210;\n    readonly FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE: 0x8211;\n    readonly FRAMEBUFFER_ATTACHMENT_RED_SIZE: 0x8212;\n    readonly FRAMEBUFFER_ATTACHMENT_GREEN_SIZE: 0x8213;\n    readonly FRAMEBUFFER_ATTACHMENT_BLUE_SIZE: 0x8214;\n    readonly FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE: 0x8215;\n    readonly FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE: 0x8216;\n    readonly FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE: 0x8217;\n    readonly FRAMEBUFFER_DEFAULT: 0x8218;\n    readonly UNSIGNED_INT_24_8: 0x84FA;\n    readonly DEPTH24_STENCIL8: 0x88F0;\n    readonly UNSIGNED_NORMALIZED: 0x8C17;\n    readonly DRAW_FRAMEBUFFER_BINDING: 0x8CA6;\n    readonly READ_FRAMEBUFFER: 0x8CA8;\n    readonly DRAW_FRAMEBUFFER: 0x8CA9;\n    readonly READ_FRAMEBUFFER_BINDING: 0x8CAA;\n    readonly RENDERBUFFER_SAMPLES: 0x8CAB;\n    readonly FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER: 0x8CD4;\n    readonly MAX_COLOR_ATTACHMENTS: 0x8CDF;\n    readonly COLOR_ATTACHMENT1: 0x8CE1;\n    readonly COLOR_ATTACHMENT2: 0x8CE2;\n    readonly COLOR_ATTACHMENT3: 0x8CE3;\n    readonly COLOR_ATTACHMENT4: 0x8CE4;\n    readonly COLOR_ATTACHMENT5: 0x8CE5;\n    readonly COLOR_ATTACHMENT6: 0x8CE6;\n    readonly COLOR_ATTACHMENT7: 0x8CE7;\n    readonly COLOR_ATTACHMENT8: 0x8CE8;\n    readonly COLOR_ATTACHMENT9: 0x8CE9;\n    readonly COLOR_ATTACHMENT10: 0x8CEA;\n    readonly COLOR_ATTACHMENT11: 0x8CEB;\n    readonly COLOR_ATTACHMENT12: 0x8CEC;\n    readonly COLOR_ATTACHMENT13: 0x8CED;\n    readonly COLOR_ATTACHMENT14: 0x8CEE;\n    readonly COLOR_ATTACHMENT15: 0x8CEF;\n    readonly FRAMEBUFFER_INCOMPLETE_MULTISAMPLE: 0x8D56;\n    readonly MAX_SAMPLES: 0x8D57;\n    readonly HALF_FLOAT: 0x140B;\n    readonly RG: 0x8227;\n    readonly RG_INTEGER: 0x8228;\n    readonly R8: 0x8229;\n    readonly RG8: 0x822B;\n    readonly R16F: 0x822D;\n    readonly R32F: 0x822E;\n    readonly RG16F: 0x822F;\n    readonly RG32F: 0x8230;\n    readonly R8I: 0x8231;\n    readonly R8UI: 0x8232;\n    readonly R16I: 0x8233;\n    readonly R16UI: 0x8234;\n    readonly R32I: 0x8235;\n    readonly R32UI: 0x8236;\n    readonly RG8I: 0x8237;\n    readonly RG8UI: 0x8238;\n    readonly RG16I: 0x8239;\n    readonly RG16UI: 0x823A;\n    readonly RG32I: 0x823B;\n    readonly RG32UI: 0x823C;\n    readonly VERTEX_ARRAY_BINDING: 0x85B5;\n    readonly R8_SNORM: 0x8F94;\n    readonly RG8_SNORM: 0x8F95;\n    readonly RGB8_SNORM: 0x8F96;\n    readonly RGBA8_SNORM: 0x8F97;\n    readonly SIGNED_NORMALIZED: 0x8F9C;\n    readonly COPY_READ_BUFFER: 0x8F36;\n    readonly COPY_WRITE_BUFFER: 0x8F37;\n    readonly COPY_READ_BUFFER_BINDING: 0x8F36;\n    readonly COPY_WRITE_BUFFER_BINDING: 0x8F37;\n    readonly UNIFORM_BUFFER: 0x8A11;\n    readonly UNIFORM_BUFFER_BINDING: 0x8A28;\n    readonly UNIFORM_BUFFER_START: 0x8A29;\n    readonly UNIFORM_BUFFER_SIZE: 0x8A2A;\n    readonly MAX_VERTEX_UNIFORM_BLOCKS: 0x8A2B;\n    readonly MAX_FRAGMENT_UNIFORM_BLOCKS: 0x8A2D;\n    readonly MAX_COMBINED_UNIFORM_BLOCKS: 0x8A2E;\n    readonly MAX_UNIFORM_BUFFER_BINDINGS: 0x8A2F;\n    readonly MAX_UNIFORM_BLOCK_SIZE: 0x8A30;\n    readonly MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS: 0x8A31;\n    readonly MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS: 0x8A33;\n    readonly UNIFORM_BUFFER_OFFSET_ALIGNMENT: 0x8A34;\n    readonly ACTIVE_UNIFORM_BLOCKS: 0x8A36;\n    readonly UNIFORM_TYPE: 0x8A37;\n    readonly UNIFORM_SIZE: 0x8A38;\n    readonly UNIFORM_BLOCK_INDEX: 0x8A3A;\n    readonly UNIFORM_OFFSET: 0x8A3B;\n    readonly UNIFORM_ARRAY_STRIDE: 0x8A3C;\n    readonly UNIFORM_MATRIX_STRIDE: 0x8A3D;\n    readonly UNIFORM_IS_ROW_MAJOR: 0x8A3E;\n    readonly UNIFORM_BLOCK_BINDING: 0x8A3F;\n    readonly UNIFORM_BLOCK_DATA_SIZE: 0x8A40;\n    readonly UNIFORM_BLOCK_ACTIVE_UNIFORMS: 0x8A42;\n    readonly UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES: 0x8A43;\n    readonly UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER: 0x8A44;\n    readonly UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER: 0x8A46;\n    readonly INVALID_INDEX: 0xFFFFFFFF;\n    readonly MAX_VERTEX_OUTPUT_COMPONENTS: 0x9122;\n    readonly MAX_FRAGMENT_INPUT_COMPONENTS: 0x9125;\n    readonly MAX_SERVER_WAIT_TIMEOUT: 0x9111;\n    readonly OBJECT_TYPE: 0x9112;\n    readonly SYNC_CONDITION: 0x9113;\n    readonly SYNC_STATUS: 0x9114;\n    readonly SYNC_FLAGS: 0x9115;\n    readonly SYNC_FENCE: 0x9116;\n    readonly SYNC_GPU_COMMANDS_COMPLETE: 0x9117;\n    readonly UNSIGNALED: 0x9118;\n    readonly SIGNALED: 0x9119;\n    readonly ALREADY_SIGNALED: 0x911A;\n    readonly TIMEOUT_EXPIRED: 0x911B;\n    readonly CONDITION_SATISFIED: 0x911C;\n    readonly WAIT_FAILED: 0x911D;\n    readonly SYNC_FLUSH_COMMANDS_BIT: 0x00000001;\n    readonly VERTEX_ATTRIB_ARRAY_DIVISOR: 0x88FE;\n    readonly ANY_SAMPLES_PASSED: 0x8C2F;\n    readonly ANY_SAMPLES_PASSED_CONSERVATIVE: 0x8D6A;\n    readonly SAMPLER_BINDING: 0x8919;\n    readonly RGB10_A2UI: 0x906F;\n    readonly INT_2_10_10_10_REV: 0x8D9F;\n    readonly TRANSFORM_FEEDBACK: 0x8E22;\n    readonly TRANSFORM_FEEDBACK_PAUSED: 0x8E23;\n    readonly TRANSFORM_FEEDBACK_ACTIVE: 0x8E24;\n    readonly TRANSFORM_FEEDBACK_BINDING: 0x8E25;\n    readonly TEXTURE_IMMUTABLE_FORMAT: 0x912F;\n    readonly MAX_ELEMENT_INDEX: 0x8D6B;\n    readonly TEXTURE_IMMUTABLE_LEVELS: 0x82DF;\n    readonly TIMEOUT_IGNORED: -1;\n    readonly MAX_CLIENT_WAIT_TIMEOUT_WEBGL: 0x9247;\n    readonly DEPTH_BUFFER_BIT: 0x00000100;\n    readonly STENCIL_BUFFER_BIT: 0x00000400;\n    readonly COLOR_BUFFER_BIT: 0x00004000;\n    readonly POINTS: 0x0000;\n    readonly LINES: 0x0001;\n    readonly LINE_LOOP: 0x0002;\n    readonly LINE_STRIP: 0x0003;\n    readonly TRIANGLES: 0x0004;\n    readonly TRIANGLE_STRIP: 0x0005;\n    readonly TRIANGLE_FAN: 0x0006;\n    readonly ZERO: 0;\n    readonly ONE: 1;\n    readonly SRC_COLOR: 0x0300;\n    readonly ONE_MINUS_SRC_COLOR: 0x0301;\n    readonly SRC_ALPHA: 0x0302;\n    readonly ONE_MINUS_SRC_ALPHA: 0x0303;\n    readonly DST_ALPHA: 0x0304;\n    readonly ONE_MINUS_DST_ALPHA: 0x0305;\n    readonly DST_COLOR: 0x0306;\n    readonly ONE_MINUS_DST_COLOR: 0x0307;\n    readonly SRC_ALPHA_SATURATE: 0x0308;\n    readonly FUNC_ADD: 0x8006;\n    readonly BLEND_EQUATION: 0x8009;\n    readonly BLEND_EQUATION_RGB: 0x8009;\n    readonly BLEND_EQUATION_ALPHA: 0x883D;\n    readonly FUNC_SUBTRACT: 0x800A;\n    readonly FUNC_REVERSE_SUBTRACT: 0x800B;\n    readonly BLEND_DST_RGB: 0x80C8;\n    readonly BLEND_SRC_RGB: 0x80C9;\n    readonly BLEND_DST_ALPHA: 0x80CA;\n    readonly BLEND_SRC_ALPHA: 0x80CB;\n    readonly CONSTANT_COLOR: 0x8001;\n    readonly ONE_MINUS_CONSTANT_COLOR: 0x8002;\n    readonly CONSTANT_ALPHA: 0x8003;\n    readonly ONE_MINUS_CONSTANT_ALPHA: 0x8004;\n    readonly BLEND_COLOR: 0x8005;\n    readonly ARRAY_BUFFER: 0x8892;\n    readonly ELEMENT_ARRAY_BUFFER: 0x8893;\n    readonly ARRAY_BUFFER_BINDING: 0x8894;\n    readonly ELEMENT_ARRAY_BUFFER_BINDING: 0x8895;\n    readonly STREAM_DRAW: 0x88E0;\n    readonly STATIC_DRAW: 0x88E4;\n    readonly DYNAMIC_DRAW: 0x88E8;\n    readonly BUFFER_SIZE: 0x8764;\n    readonly BUFFER_USAGE: 0x8765;\n    readonly CURRENT_VERTEX_ATTRIB: 0x8626;\n    readonly FRONT: 0x0404;\n    readonly BACK: 0x0405;\n    readonly FRONT_AND_BACK: 0x0408;\n    readonly CULL_FACE: 0x0B44;\n    readonly BLEND: 0x0BE2;\n    readonly DITHER: 0x0BD0;\n    readonly STENCIL_TEST: 0x0B90;\n    readonly DEPTH_TEST: 0x0B71;\n    readonly SCISSOR_TEST: 0x0C11;\n    readonly POLYGON_OFFSET_FILL: 0x8037;\n    readonly SAMPLE_ALPHA_TO_COVERAGE: 0x809E;\n    readonly SAMPLE_COVERAGE: 0x80A0;\n    readonly NO_ERROR: 0;\n    readonly INVALID_ENUM: 0x0500;\n    readonly INVALID_VALUE: 0x0501;\n    readonly INVALID_OPERATION: 0x0502;\n    readonly OUT_OF_MEMORY: 0x0505;\n    readonly CW: 0x0900;\n    readonly CCW: 0x0901;\n    readonly LINE_WIDTH: 0x0B21;\n    readonly ALIASED_POINT_SIZE_RANGE: 0x846D;\n    readonly ALIASED_LINE_WIDTH_RANGE: 0x846E;\n    readonly CULL_FACE_MODE: 0x0B45;\n    readonly FRONT_FACE: 0x0B46;\n    readonly DEPTH_RANGE: 0x0B70;\n    readonly DEPTH_WRITEMASK: 0x0B72;\n    readonly DEPTH_CLEAR_VALUE: 0x0B73;\n    readonly DEPTH_FUNC: 0x0B74;\n    readonly STENCIL_CLEAR_VALUE: 0x0B91;\n    readonly STENCIL_FUNC: 0x0B92;\n    readonly STENCIL_FAIL: 0x0B94;\n    readonly STENCIL_PASS_DEPTH_FAIL: 0x0B95;\n    readonly STENCIL_PASS_DEPTH_PASS: 0x0B96;\n    readonly STENCIL_REF: 0x0B97;\n    readonly STENCIL_VALUE_MASK: 0x0B93;\n    readonly STENCIL_WRITEMASK: 0x0B98;\n    readonly STENCIL_BACK_FUNC: 0x8800;\n    readonly STENCIL_BACK_FAIL: 0x8801;\n    readonly STENCIL_BACK_PASS_DEPTH_FAIL: 0x8802;\n    readonly STENCIL_BACK_PASS_DEPTH_PASS: 0x8803;\n    readonly STENCIL_BACK_REF: 0x8CA3;\n    readonly STENCIL_BACK_VALUE_MASK: 0x8CA4;\n    readonly STENCIL_BACK_WRITEMASK: 0x8CA5;\n    readonly VIEWPORT: 0x0BA2;\n    readonly SCISSOR_BOX: 0x0C10;\n    readonly COLOR_CLEAR_VALUE: 0x0C22;\n    readonly COLOR_WRITEMASK: 0x0C23;\n    readonly UNPACK_ALIGNMENT: 0x0CF5;\n    readonly PACK_ALIGNMENT: 0x0D05;\n    readonly MAX_TEXTURE_SIZE: 0x0D33;\n    readonly MAX_VIEWPORT_DIMS: 0x0D3A;\n    readonly SUBPIXEL_BITS: 0x0D50;\n    readonly RED_BITS: 0x0D52;\n    readonly GREEN_BITS: 0x0D53;\n    readonly BLUE_BITS: 0x0D54;\n    readonly ALPHA_BITS: 0x0D55;\n    readonly DEPTH_BITS: 0x0D56;\n    readonly STENCIL_BITS: 0x0D57;\n    readonly POLYGON_OFFSET_UNITS: 0x2A00;\n    readonly POLYGON_OFFSET_FACTOR: 0x8038;\n    readonly TEXTURE_BINDING_2D: 0x8069;\n    readonly SAMPLE_BUFFERS: 0x80A8;\n    readonly SAMPLES: 0x80A9;\n    readonly SAMPLE_COVERAGE_VALUE: 0x80AA;\n    readonly SAMPLE_COVERAGE_INVERT: 0x80AB;\n    readonly COMPRESSED_TEXTURE_FORMATS: 0x86A3;\n    readonly DONT_CARE: 0x1100;\n    readonly FASTEST: 0x1101;\n    readonly NICEST: 0x1102;\n    readonly GENERATE_MIPMAP_HINT: 0x8192;\n    readonly BYTE: 0x1400;\n    readonly UNSIGNED_BYTE: 0x1401;\n    readonly SHORT: 0x1402;\n    readonly UNSIGNED_SHORT: 0x1403;\n    readonly INT: 0x1404;\n    readonly UNSIGNED_INT: 0x1405;\n    readonly FLOAT: 0x1406;\n    readonly DEPTH_COMPONENT: 0x1902;\n    readonly ALPHA: 0x1906;\n    readonly RGB: 0x1907;\n    readonly RGBA: 0x1908;\n    readonly LUMINANCE: 0x1909;\n    readonly LUMINANCE_ALPHA: 0x190A;\n    readonly UNSIGNED_SHORT_4_4_4_4: 0x8033;\n    readonly UNSIGNED_SHORT_5_5_5_1: 0x8034;\n    readonly UNSIGNED_SHORT_5_6_5: 0x8363;\n    readonly FRAGMENT_SHADER: 0x8B30;\n    readonly VERTEX_SHADER: 0x8B31;\n    readonly MAX_VERTEX_ATTRIBS: 0x8869;\n    readonly MAX_VERTEX_UNIFORM_VECTORS: 0x8DFB;\n    readonly MAX_VARYING_VECTORS: 0x8DFC;\n    readonly MAX_COMBINED_TEXTURE_IMAGE_UNITS: 0x8B4D;\n    readonly MAX_VERTEX_TEXTURE_IMAGE_UNITS: 0x8B4C;\n    readonly MAX_TEXTURE_IMAGE_UNITS: 0x8872;\n    readonly MAX_FRAGMENT_UNIFORM_VECTORS: 0x8DFD;\n    readonly SHADER_TYPE: 0x8B4F;\n    readonly DELETE_STATUS: 0x8B80;\n    readonly LINK_STATUS: 0x8B82;\n    readonly VALIDATE_STATUS: 0x8B83;\n    readonly ATTACHED_SHADERS: 0x8B85;\n    readonly ACTIVE_UNIFORMS: 0x8B86;\n    readonly ACTIVE_ATTRIBUTES: 0x8B89;\n    readonly SHADING_LANGUAGE_VERSION: 0x8B8C;\n    readonly CURRENT_PROGRAM: 0x8B8D;\n    readonly NEVER: 0x0200;\n    readonly LESS: 0x0201;\n    readonly EQUAL: 0x0202;\n    readonly LEQUAL: 0x0203;\n    readonly GREATER: 0x0204;\n    readonly NOTEQUAL: 0x0205;\n    readonly GEQUAL: 0x0206;\n    readonly ALWAYS: 0x0207;\n    readonly KEEP: 0x1E00;\n    readonly REPLACE: 0x1E01;\n    readonly INCR: 0x1E02;\n    readonly DECR: 0x1E03;\n    readonly INVERT: 0x150A;\n    readonly INCR_WRAP: 0x8507;\n    readonly DECR_WRAP: 0x8508;\n    readonly VENDOR: 0x1F00;\n    readonly RENDERER: 0x1F01;\n    readonly VERSION: 0x1F02;\n    readonly NEAREST: 0x2600;\n    readonly LINEAR: 0x2601;\n    readonly NEAREST_MIPMAP_NEAREST: 0x2700;\n    readonly LINEAR_MIPMAP_NEAREST: 0x2701;\n    readonly NEAREST_MIPMAP_LINEAR: 0x2702;\n    readonly LINEAR_MIPMAP_LINEAR: 0x2703;\n    readonly TEXTURE_MAG_FILTER: 0x2800;\n    readonly TEXTURE_MIN_FILTER: 0x2801;\n    readonly TEXTURE_WRAP_S: 0x2802;\n    readonly TEXTURE_WRAP_T: 0x2803;\n    readonly TEXTURE_2D: 0x0DE1;\n    readonly TEXTURE: 0x1702;\n    readonly TEXTURE_CUBE_MAP: 0x8513;\n    readonly TEXTURE_BINDING_CUBE_MAP: 0x8514;\n    readonly TEXTURE_CUBE_MAP_POSITIVE_X: 0x8515;\n    readonly TEXTURE_CUBE_MAP_NEGATIVE_X: 0x8516;\n    readonly TEXTURE_CUBE_MAP_POSITIVE_Y: 0x8517;\n    readonly TEXTURE_CUBE_MAP_NEGATIVE_Y: 0x8518;\n    readonly TEXTURE_CUBE_MAP_POSITIVE_Z: 0x8519;\n    readonly TEXTURE_CUBE_MAP_NEGATIVE_Z: 0x851A;\n    readonly MAX_CUBE_MAP_TEXTURE_SIZE: 0x851C;\n    readonly TEXTURE0: 0x84C0;\n    readonly TEXTURE1: 0x84C1;\n    readonly TEXTURE2: 0x84C2;\n    readonly TEXTURE3: 0x84C3;\n    readonly TEXTURE4: 0x84C4;\n    readonly TEXTURE5: 0x84C5;\n    readonly TEXTURE6: 0x84C6;\n    readonly TEXTURE7: 0x84C7;\n    readonly TEXTURE8: 0x84C8;\n    readonly TEXTURE9: 0x84C9;\n    readonly TEXTURE10: 0x84CA;\n    readonly TEXTURE11: 0x84CB;\n    readonly TEXTURE12: 0x84CC;\n    readonly TEXTURE13: 0x84CD;\n    readonly TEXTURE14: 0x84CE;\n    readonly TEXTURE15: 0x84CF;\n    readonly TEXTURE16: 0x84D0;\n    readonly TEXTURE17: 0x84D1;\n    readonly TEXTURE18: 0x84D2;\n    readonly TEXTURE19: 0x84D3;\n    readonly TEXTURE20: 0x84D4;\n    readonly TEXTURE21: 0x84D5;\n    readonly TEXTURE22: 0x84D6;\n    readonly TEXTURE23: 0x84D7;\n    readonly TEXTURE24: 0x84D8;\n    readonly TEXTURE25: 0x84D9;\n    readonly TEXTURE26: 0x84DA;\n    readonly TEXTURE27: 0x84DB;\n    readonly TEXTURE28: 0x84DC;\n    readonly TEXTURE29: 0x84DD;\n    readonly TEXTURE30: 0x84DE;\n    readonly TEXTURE31: 0x84DF;\n    readonly ACTIVE_TEXTURE: 0x84E0;\n    readonly REPEAT: 0x2901;\n    readonly CLAMP_TO_EDGE: 0x812F;\n    readonly MIRRORED_REPEAT: 0x8370;\n    readonly FLOAT_VEC2: 0x8B50;\n    readonly FLOAT_VEC3: 0x8B51;\n    readonly FLOAT_VEC4: 0x8B52;\n    readonly INT_VEC2: 0x8B53;\n    readonly INT_VEC3: 0x8B54;\n    readonly INT_VEC4: 0x8B55;\n    readonly BOOL: 0x8B56;\n    readonly BOOL_VEC2: 0x8B57;\n    readonly BOOL_VEC3: 0x8B58;\n    readonly BOOL_VEC4: 0x8B59;\n    readonly FLOAT_MAT2: 0x8B5A;\n    readonly FLOAT_MAT3: 0x8B5B;\n    readonly FLOAT_MAT4: 0x8B5C;\n    readonly SAMPLER_2D: 0x8B5E;\n    readonly SAMPLER_CUBE: 0x8B60;\n    readonly VERTEX_ATTRIB_ARRAY_ENABLED: 0x8622;\n    readonly VERTEX_ATTRIB_ARRAY_SIZE: 0x8623;\n    readonly VERTEX_ATTRIB_ARRAY_STRIDE: 0x8624;\n    readonly VERTEX_ATTRIB_ARRAY_TYPE: 0x8625;\n    readonly VERTEX_ATTRIB_ARRAY_NORMALIZED: 0x886A;\n    readonly VERTEX_ATTRIB_ARRAY_POINTER: 0x8645;\n    readonly VERTEX_ATTRIB_ARRAY_BUFFER_BINDING: 0x889F;\n    readonly IMPLEMENTATION_COLOR_READ_TYPE: 0x8B9A;\n    readonly IMPLEMENTATION_COLOR_READ_FORMAT: 0x8B9B;\n    readonly COMPILE_STATUS: 0x8B81;\n    readonly LOW_FLOAT: 0x8DF0;\n    readonly MEDIUM_FLOAT: 0x8DF1;\n    readonly HIGH_FLOAT: 0x8DF2;\n    readonly LOW_INT: 0x8DF3;\n    readonly MEDIUM_INT: 0x8DF4;\n    readonly HIGH_INT: 0x8DF5;\n    readonly FRAMEBUFFER: 0x8D40;\n    readonly RENDERBUFFER: 0x8D41;\n    readonly RGBA4: 0x8056;\n    readonly RGB5_A1: 0x8057;\n    readonly RGB565: 0x8D62;\n    readonly DEPTH_COMPONENT16: 0x81A5;\n    readonly STENCIL_INDEX8: 0x8D48;\n    readonly DEPTH_STENCIL: 0x84F9;\n    readonly RENDERBUFFER_WIDTH: 0x8D42;\n    readonly RENDERBUFFER_HEIGHT: 0x8D43;\n    readonly RENDERBUFFER_INTERNAL_FORMAT: 0x8D44;\n    readonly RENDERBUFFER_RED_SIZE: 0x8D50;\n    readonly RENDERBUFFER_GREEN_SIZE: 0x8D51;\n    readonly RENDERBUFFER_BLUE_SIZE: 0x8D52;\n    readonly RENDERBUFFER_ALPHA_SIZE: 0x8D53;\n    readonly RENDERBUFFER_DEPTH_SIZE: 0x8D54;\n    readonly RENDERBUFFER_STENCIL_SIZE: 0x8D55;\n    readonly FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE: 0x8CD0;\n    readonly FRAMEBUFFER_ATTACHMENT_OBJECT_NAME: 0x8CD1;\n    readonly FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL: 0x8CD2;\n    readonly FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE: 0x8CD3;\n    readonly COLOR_ATTACHMENT0: 0x8CE0;\n    readonly DEPTH_ATTACHMENT: 0x8D00;\n    readonly STENCIL_ATTACHMENT: 0x8D20;\n    readonly DEPTH_STENCIL_ATTACHMENT: 0x821A;\n    readonly NONE: 0;\n    readonly FRAMEBUFFER_COMPLETE: 0x8CD5;\n    readonly FRAMEBUFFER_INCOMPLETE_ATTACHMENT: 0x8CD6;\n    readonly FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT: 0x8CD7;\n    readonly FRAMEBUFFER_INCOMPLETE_DIMENSIONS: 0x8CD9;\n    readonly FRAMEBUFFER_UNSUPPORTED: 0x8CDD;\n    readonly FRAMEBUFFER_BINDING: 0x8CA6;\n    readonly RENDERBUFFER_BINDING: 0x8CA7;\n    readonly MAX_RENDERBUFFER_SIZE: 0x84E8;\n    readonly INVALID_FRAMEBUFFER_OPERATION: 0x0506;\n    readonly UNPACK_FLIP_Y_WEBGL: 0x9240;\n    readonly UNPACK_PREMULTIPLY_ALPHA_WEBGL: 0x9241;\n    readonly CONTEXT_LOST_WEBGL: 0x9242;\n    readonly UNPACK_COLORSPACE_CONVERSION_WEBGL: 0x9243;\n    readonly BROWSER_DEFAULT_WEBGL: 0x9244;\n};\n\ninterface WebGL2RenderingContextBase {\n    beginQuery(target: GLenum, query: WebGLQuery): void;\n    beginTransformFeedback(primitiveMode: GLenum): void;\n    bindBufferBase(target: GLenum, index: GLuint, buffer: WebGLBuffer | null): void;\n    bindBufferRange(target: GLenum, index: GLuint, buffer: WebGLBuffer | null, offset: GLintptr, size: GLsizeiptr): void;\n    bindSampler(unit: GLuint, sampler: WebGLSampler | null): void;\n    bindTransformFeedback(target: GLenum, tf: WebGLTransformFeedback | null): void;\n    bindVertexArray(array: WebGLVertexArrayObject | null): void;\n    blitFramebuffer(srcX0: GLint, srcY0: GLint, srcX1: GLint, srcY1: GLint, dstX0: GLint, dstY0: GLint, dstX1: GLint, dstY1: GLint, mask: GLbitfield, filter: GLenum): void;\n    clearBufferfi(buffer: GLenum, drawbuffer: GLint, depth: GLfloat, stencil: GLint): void;\n    clearBufferfv(buffer: GLenum, drawbuffer: GLint, values: Float32List, srcOffset?: GLuint): void;\n    clearBufferiv(buffer: GLenum, drawbuffer: GLint, values: Int32List, srcOffset?: GLuint): void;\n    clearBufferuiv(buffer: GLenum, drawbuffer: GLint, values: Uint32List, srcOffset?: GLuint): void;\n    clientWaitSync(sync: WebGLSync, flags: GLbitfield, timeout: GLuint64): GLenum;\n    compressedTexImage3D(target: GLenum, level: GLint, internalformat: GLenum, width: GLsizei, height: GLsizei, depth: GLsizei, border: GLint, imageSize: GLsizei, offset: GLintptr): void;\n    compressedTexImage3D(target: GLenum, level: GLint, internalformat: GLenum, width: GLsizei, height: GLsizei, depth: GLsizei, border: GLint, srcData: ArrayBufferView, srcOffset?: GLuint, srcLengthOverride?: GLuint): void;\n    compressedTexSubImage3D(target: GLenum, level: GLint, xoffset: GLint, yoffset: GLint, zoffset: GLint, width: GLsizei, height: GLsizei, depth: GLsizei, format: GLenum, imageSize: GLsizei, offset: GLintptr): void;\n    compressedTexSubImage3D(target: GLenum, level: GLint, xoffset: GLint, yoffset: GLint, zoffset: GLint, width: GLsizei, height: GLsizei, depth: GLsizei, format: GLenum, srcData: ArrayBufferView, srcOffset?: GLuint, srcLengthOverride?: GLuint): void;\n    copyBufferSubData(readTarget: GLenum, writeTarget: GLenum, readOffset: GLintptr, writeOffset: GLintptr, size: GLsizeiptr): void;\n    copyTexSubImage3D(target: GLenum, level: GLint, xoffset: GLint, yoffset: GLint, zoffset: GLint, x: GLint, y: GLint, width: GLsizei, height: GLsizei): void;\n    createQuery(): WebGLQuery | null;\n    createSampler(): WebGLSampler | null;\n    createTransformFeedback(): WebGLTransformFeedback | null;\n    createVertexArray(): WebGLVertexArrayObject | null;\n    deleteQuery(query: WebGLQuery | null): void;\n    deleteSampler(sampler: WebGLSampler | null): void;\n    deleteSync(sync: WebGLSync | null): void;\n    deleteTransformFeedback(tf: WebGLTransformFeedback | null): void;\n    deleteVertexArray(vertexArray: WebGLVertexArrayObject | null): void;\n    drawArraysInstanced(mode: GLenum, first: GLint, count: GLsizei, instanceCount: GLsizei): void;\n    drawBuffers(buffers: GLenum[]): void;\n    drawElementsInstanced(mode: GLenum, count: GLsizei, type: GLenum, offset: GLintptr, instanceCount: GLsizei): void;\n    drawRangeElements(mode: GLenum, start: GLuint, end: GLuint, count: GLsizei, type: GLenum, offset: GLintptr): void;\n    endQuery(target: GLenum): void;\n    endTransformFeedback(): void;\n    fenceSync(condition: GLenum, flags: GLbitfield): WebGLSync | null;\n    framebufferTextureLayer(target: GLenum, attachment: GLenum, texture: WebGLTexture | null, level: GLint, layer: GLint): void;\n    getActiveUniformBlockName(program: WebGLProgram, uniformBlockIndex: GLuint): string | null;\n    getActiveUniformBlockParameter(program: WebGLProgram, uniformBlockIndex: GLuint, pname: GLenum): any;\n    getActiveUniforms(program: WebGLProgram, uniformIndices: GLuint[], pname: GLenum): any;\n    getBufferSubData(target: GLenum, srcByteOffset: GLintptr, dstBuffer: ArrayBufferView, dstOffset?: GLuint, length?: GLuint): void;\n    getFragDataLocation(program: WebGLProgram, name: string): GLint;\n    getIndexedParameter(target: GLenum, index: GLuint): any;\n    getInternalformatParameter(target: GLenum, internalformat: GLenum, pname: GLenum): any;\n    getQuery(target: GLenum, pname: GLenum): WebGLQuery | null;\n    getQueryParameter(query: WebGLQuery, pname: GLenum): any;\n    getSamplerParameter(sampler: WebGLSampler, pname: GLenum): any;\n    getSyncParameter(sync: WebGLSync, pname: GLenum): any;\n    getTransformFeedbackVarying(program: WebGLProgram, index: GLuint): WebGLActiveInfo | null;\n    getUniformBlockIndex(program: WebGLProgram, uniformBlockName: string): GLuint;\n    getUniformIndices(program: WebGLProgram, uniformNames: string[]): GLuint[] | null;\n    invalidateFramebuffer(target: GLenum, attachments: GLenum[]): void;\n    invalidateSubFramebuffer(target: GLenum, attachments: GLenum[], x: GLint, y: GLint, width: GLsizei, height: GLsizei): void;\n    isQuery(query: WebGLQuery | null): GLboolean;\n    isSampler(sampler: WebGLSampler | null): GLboolean;\n    isSync(sync: WebGLSync | null): GLboolean;\n    isTransformFeedback(tf: WebGLTransformFeedback | null): GLboolean;\n    isVertexArray(vertexArray: WebGLVertexArrayObject | null): GLboolean;\n    pauseTransformFeedback(): void;\n    readBuffer(src: GLenum): void;\n    renderbufferStorageMultisample(target: GLenum, samples: GLsizei, internalformat: GLenum, width: GLsizei, height: GLsizei): void;\n    resumeTransformFeedback(): void;\n    samplerParameterf(sampler: WebGLSampler, pname: GLenum, param: GLfloat): void;\n    samplerParameteri(sampler: WebGLSampler, pname: GLenum, param: GLint): void;\n    texImage3D(target: GLenum, level: GLint, internalformat: GLint, width: GLsizei, height: GLsizei, depth: GLsizei, border: GLint, format: GLenum, type: GLenum, pboOffset: GLintptr): void;\n    texImage3D(target: GLenum, level: GLint, internalformat: GLint, width: GLsizei, height: GLsizei, depth: GLsizei, border: GLint, format: GLenum, type: GLenum, source: TexImageSource): void;\n    texImage3D(target: GLenum, level: GLint, internalformat: GLint, width: GLsizei, height: GLsizei, depth: GLsizei, border: GLint, format: GLenum, type: GLenum, srcData: ArrayBufferView | null): void;\n    texImage3D(target: GLenum, level: GLint, internalformat: GLint, width: GLsizei, height: GLsizei, depth: GLsizei, border: GLint, format: GLenum, type: GLenum, srcData: ArrayBufferView, srcOffset: GLuint): void;\n    texStorage2D(target: GLenum, levels: GLsizei, internalformat: GLenum, width: GLsizei, height: GLsizei): void;\n    texStorage3D(target: GLenum, levels: GLsizei, internalformat: GLenum, width: GLsizei, height: GLsizei, depth: GLsizei): void;\n    texSubImage3D(target: GLenum, level: GLint, xoffset: GLint, yoffset: GLint, zoffset: GLint, width: GLsizei, height: GLsizei, depth: GLsizei, format: GLenum, type: GLenum, pboOffset: GLintptr): void;\n    texSubImage3D(target: GLenum, level: GLint, xoffset: GLint, yoffset: GLint, zoffset: GLint, width: GLsizei, height: GLsizei, depth: GLsizei, format: GLenum, type: GLenum, source: TexImageSource): void;\n    texSubImage3D(target: GLenum, level: GLint, xoffset: GLint, yoffset: GLint, zoffset: GLint, width: GLsizei, height: GLsizei, depth: GLsizei, format: GLenum, type: GLenum, srcData: ArrayBufferView | null, srcOffset?: GLuint): void;\n    transformFeedbackVaryings(program: WebGLProgram, varyings: string[], bufferMode: GLenum): void;\n    uniform1ui(location: WebGLUniformLocation | null, v0: GLuint): void;\n    uniform1uiv(location: WebGLUniformLocation | null, data: Uint32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform2ui(location: WebGLUniformLocation | null, v0: GLuint, v1: GLuint): void;\n    uniform2uiv(location: WebGLUniformLocation | null, data: Uint32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform3ui(location: WebGLUniformLocation | null, v0: GLuint, v1: GLuint, v2: GLuint): void;\n    uniform3uiv(location: WebGLUniformLocation | null, data: Uint32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform4ui(location: WebGLUniformLocation | null, v0: GLuint, v1: GLuint, v2: GLuint, v3: GLuint): void;\n    uniform4uiv(location: WebGLUniformLocation | null, data: Uint32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniformBlockBinding(program: WebGLProgram, uniformBlockIndex: GLuint, uniformBlockBinding: GLuint): void;\n    uniformMatrix2x3fv(location: WebGLUniformLocation | null, transpose: GLboolean, data: Float32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniformMatrix2x4fv(location: WebGLUniformLocation | null, transpose: GLboolean, data: Float32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniformMatrix3x2fv(location: WebGLUniformLocation | null, transpose: GLboolean, data: Float32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniformMatrix3x4fv(location: WebGLUniformLocation | null, transpose: GLboolean, data: Float32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniformMatrix4x2fv(location: WebGLUniformLocation | null, transpose: GLboolean, data: Float32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniformMatrix4x3fv(location: WebGLUniformLocation | null, transpose: GLboolean, data: Float32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    vertexAttribDivisor(index: GLuint, divisor: GLuint): void;\n    vertexAttribI4i(index: GLuint, x: GLint, y: GLint, z: GLint, w: GLint): void;\n    vertexAttribI4iv(index: GLuint, values: Int32List): void;\n    vertexAttribI4ui(index: GLuint, x: GLuint, y: GLuint, z: GLuint, w: GLuint): void;\n    vertexAttribI4uiv(index: GLuint, values: Uint32List): void;\n    vertexAttribIPointer(index: GLuint, size: GLint, type: GLenum, stride: GLsizei, offset: GLintptr): void;\n    waitSync(sync: WebGLSync, flags: GLbitfield, timeout: GLint64): void;\n    readonly READ_BUFFER: 0x0C02;\n    readonly UNPACK_ROW_LENGTH: 0x0CF2;\n    readonly UNPACK_SKIP_ROWS: 0x0CF3;\n    readonly UNPACK_SKIP_PIXELS: 0x0CF4;\n    readonly PACK_ROW_LENGTH: 0x0D02;\n    readonly PACK_SKIP_ROWS: 0x0D03;\n    readonly PACK_SKIP_PIXELS: 0x0D04;\n    readonly COLOR: 0x1800;\n    readonly DEPTH: 0x1801;\n    readonly STENCIL: 0x1802;\n    readonly RED: 0x1903;\n    readonly RGB8: 0x8051;\n    readonly RGBA8: 0x8058;\n    readonly RGB10_A2: 0x8059;\n    readonly TEXTURE_BINDING_3D: 0x806A;\n    readonly UNPACK_SKIP_IMAGES: 0x806D;\n    readonly UNPACK_IMAGE_HEIGHT: 0x806E;\n    readonly TEXTURE_3D: 0x806F;\n    readonly TEXTURE_WRAP_R: 0x8072;\n    readonly MAX_3D_TEXTURE_SIZE: 0x8073;\n    readonly UNSIGNED_INT_2_10_10_10_REV: 0x8368;\n    readonly MAX_ELEMENTS_VERTICES: 0x80E8;\n    readonly MAX_ELEMENTS_INDICES: 0x80E9;\n    readonly TEXTURE_MIN_LOD: 0x813A;\n    readonly TEXTURE_MAX_LOD: 0x813B;\n    readonly TEXTURE_BASE_LEVEL: 0x813C;\n    readonly TEXTURE_MAX_LEVEL: 0x813D;\n    readonly MIN: 0x8007;\n    readonly MAX: 0x8008;\n    readonly DEPTH_COMPONENT24: 0x81A6;\n    readonly MAX_TEXTURE_LOD_BIAS: 0x84FD;\n    readonly TEXTURE_COMPARE_MODE: 0x884C;\n    readonly TEXTURE_COMPARE_FUNC: 0x884D;\n    readonly CURRENT_QUERY: 0x8865;\n    readonly QUERY_RESULT: 0x8866;\n    readonly QUERY_RESULT_AVAILABLE: 0x8867;\n    readonly STREAM_READ: 0x88E1;\n    readonly STREAM_COPY: 0x88E2;\n    readonly STATIC_READ: 0x88E5;\n    readonly STATIC_COPY: 0x88E6;\n    readonly DYNAMIC_READ: 0x88E9;\n    readonly DYNAMIC_COPY: 0x88EA;\n    readonly MAX_DRAW_BUFFERS: 0x8824;\n    readonly DRAW_BUFFER0: 0x8825;\n    readonly DRAW_BUFFER1: 0x8826;\n    readonly DRAW_BUFFER2: 0x8827;\n    readonly DRAW_BUFFER3: 0x8828;\n    readonly DRAW_BUFFER4: 0x8829;\n    readonly DRAW_BUFFER5: 0x882A;\n    readonly DRAW_BUFFER6: 0x882B;\n    readonly DRAW_BUFFER7: 0x882C;\n    readonly DRAW_BUFFER8: 0x882D;\n    readonly DRAW_BUFFER9: 0x882E;\n    readonly DRAW_BUFFER10: 0x882F;\n    readonly DRAW_BUFFER11: 0x8830;\n    readonly DRAW_BUFFER12: 0x8831;\n    readonly DRAW_BUFFER13: 0x8832;\n    readonly DRAW_BUFFER14: 0x8833;\n    readonly DRAW_BUFFER15: 0x8834;\n    readonly MAX_FRAGMENT_UNIFORM_COMPONENTS: 0x8B49;\n    readonly MAX_VERTEX_UNIFORM_COMPONENTS: 0x8B4A;\n    readonly SAMPLER_3D: 0x8B5F;\n    readonly SAMPLER_2D_SHADOW: 0x8B62;\n    readonly FRAGMENT_SHADER_DERIVATIVE_HINT: 0x8B8B;\n    readonly PIXEL_PACK_BUFFER: 0x88EB;\n    readonly PIXEL_UNPACK_BUFFER: 0x88EC;\n    readonly PIXEL_PACK_BUFFER_BINDING: 0x88ED;\n    readonly PIXEL_UNPACK_BUFFER_BINDING: 0x88EF;\n    readonly FLOAT_MAT2x3: 0x8B65;\n    readonly FLOAT_MAT2x4: 0x8B66;\n    readonly FLOAT_MAT3x2: 0x8B67;\n    readonly FLOAT_MAT3x4: 0x8B68;\n    readonly FLOAT_MAT4x2: 0x8B69;\n    readonly FLOAT_MAT4x3: 0x8B6A;\n    readonly SRGB: 0x8C40;\n    readonly SRGB8: 0x8C41;\n    readonly SRGB8_ALPHA8: 0x8C43;\n    readonly COMPARE_REF_TO_TEXTURE: 0x884E;\n    readonly RGBA32F: 0x8814;\n    readonly RGB32F: 0x8815;\n    readonly RGBA16F: 0x881A;\n    readonly RGB16F: 0x881B;\n    readonly VERTEX_ATTRIB_ARRAY_INTEGER: 0x88FD;\n    readonly MAX_ARRAY_TEXTURE_LAYERS: 0x88FF;\n    readonly MIN_PROGRAM_TEXEL_OFFSET: 0x8904;\n    readonly MAX_PROGRAM_TEXEL_OFFSET: 0x8905;\n    readonly MAX_VARYING_COMPONENTS: 0x8B4B;\n    readonly TEXTURE_2D_ARRAY: 0x8C1A;\n    readonly TEXTURE_BINDING_2D_ARRAY: 0x8C1D;\n    readonly R11F_G11F_B10F: 0x8C3A;\n    readonly UNSIGNED_INT_10F_11F_11F_REV: 0x8C3B;\n    readonly RGB9_E5: 0x8C3D;\n    readonly UNSIGNED_INT_5_9_9_9_REV: 0x8C3E;\n    readonly TRANSFORM_FEEDBACK_BUFFER_MODE: 0x8C7F;\n    readonly MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS: 0x8C80;\n    readonly TRANSFORM_FEEDBACK_VARYINGS: 0x8C83;\n    readonly TRANSFORM_FEEDBACK_BUFFER_START: 0x8C84;\n    readonly TRANSFORM_FEEDBACK_BUFFER_SIZE: 0x8C85;\n    readonly TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN: 0x8C88;\n    readonly RASTERIZER_DISCARD: 0x8C89;\n    readonly MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS: 0x8C8A;\n    readonly MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS: 0x8C8B;\n    readonly INTERLEAVED_ATTRIBS: 0x8C8C;\n    readonly SEPARATE_ATTRIBS: 0x8C8D;\n    readonly TRANSFORM_FEEDBACK_BUFFER: 0x8C8E;\n    readonly TRANSFORM_FEEDBACK_BUFFER_BINDING: 0x8C8F;\n    readonly RGBA32UI: 0x8D70;\n    readonly RGB32UI: 0x8D71;\n    readonly RGBA16UI: 0x8D76;\n    readonly RGB16UI: 0x8D77;\n    readonly RGBA8UI: 0x8D7C;\n    readonly RGB8UI: 0x8D7D;\n    readonly RGBA32I: 0x8D82;\n    readonly RGB32I: 0x8D83;\n    readonly RGBA16I: 0x8D88;\n    readonly RGB16I: 0x8D89;\n    readonly RGBA8I: 0x8D8E;\n    readonly RGB8I: 0x8D8F;\n    readonly RED_INTEGER: 0x8D94;\n    readonly RGB_INTEGER: 0x8D98;\n    readonly RGBA_INTEGER: 0x8D99;\n    readonly SAMPLER_2D_ARRAY: 0x8DC1;\n    readonly SAMPLER_2D_ARRAY_SHADOW: 0x8DC4;\n    readonly SAMPLER_CUBE_SHADOW: 0x8DC5;\n    readonly UNSIGNED_INT_VEC2: 0x8DC6;\n    readonly UNSIGNED_INT_VEC3: 0x8DC7;\n    readonly UNSIGNED_INT_VEC4: 0x8DC8;\n    readonly INT_SAMPLER_2D: 0x8DCA;\n    readonly INT_SAMPLER_3D: 0x8DCB;\n    readonly INT_SAMPLER_CUBE: 0x8DCC;\n    readonly INT_SAMPLER_2D_ARRAY: 0x8DCF;\n    readonly UNSIGNED_INT_SAMPLER_2D: 0x8DD2;\n    readonly UNSIGNED_INT_SAMPLER_3D: 0x8DD3;\n    readonly UNSIGNED_INT_SAMPLER_CUBE: 0x8DD4;\n    readonly UNSIGNED_INT_SAMPLER_2D_ARRAY: 0x8DD7;\n    readonly DEPTH_COMPONENT32F: 0x8CAC;\n    readonly DEPTH32F_STENCIL8: 0x8CAD;\n    readonly FLOAT_32_UNSIGNED_INT_24_8_REV: 0x8DAD;\n    readonly FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING: 0x8210;\n    readonly FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE: 0x8211;\n    readonly FRAMEBUFFER_ATTACHMENT_RED_SIZE: 0x8212;\n    readonly FRAMEBUFFER_ATTACHMENT_GREEN_SIZE: 0x8213;\n    readonly FRAMEBUFFER_ATTACHMENT_BLUE_SIZE: 0x8214;\n    readonly FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE: 0x8215;\n    readonly FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE: 0x8216;\n    readonly FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE: 0x8217;\n    readonly FRAMEBUFFER_DEFAULT: 0x8218;\n    readonly UNSIGNED_INT_24_8: 0x84FA;\n    readonly DEPTH24_STENCIL8: 0x88F0;\n    readonly UNSIGNED_NORMALIZED: 0x8C17;\n    readonly DRAW_FRAMEBUFFER_BINDING: 0x8CA6;\n    readonly READ_FRAMEBUFFER: 0x8CA8;\n    readonly DRAW_FRAMEBUFFER: 0x8CA9;\n    readonly READ_FRAMEBUFFER_BINDING: 0x8CAA;\n    readonly RENDERBUFFER_SAMPLES: 0x8CAB;\n    readonly FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER: 0x8CD4;\n    readonly MAX_COLOR_ATTACHMENTS: 0x8CDF;\n    readonly COLOR_ATTACHMENT1: 0x8CE1;\n    readonly COLOR_ATTACHMENT2: 0x8CE2;\n    readonly COLOR_ATTACHMENT3: 0x8CE3;\n    readonly COLOR_ATTACHMENT4: 0x8CE4;\n    readonly COLOR_ATTACHMENT5: 0x8CE5;\n    readonly COLOR_ATTACHMENT6: 0x8CE6;\n    readonly COLOR_ATTACHMENT7: 0x8CE7;\n    readonly COLOR_ATTACHMENT8: 0x8CE8;\n    readonly COLOR_ATTACHMENT9: 0x8CE9;\n    readonly COLOR_ATTACHMENT10: 0x8CEA;\n    readonly COLOR_ATTACHMENT11: 0x8CEB;\n    readonly COLOR_ATTACHMENT12: 0x8CEC;\n    readonly COLOR_ATTACHMENT13: 0x8CED;\n    readonly COLOR_ATTACHMENT14: 0x8CEE;\n    readonly COLOR_ATTACHMENT15: 0x8CEF;\n    readonly FRAMEBUFFER_INCOMPLETE_MULTISAMPLE: 0x8D56;\n    readonly MAX_SAMPLES: 0x8D57;\n    readonly HALF_FLOAT: 0x140B;\n    readonly RG: 0x8227;\n    readonly RG_INTEGER: 0x8228;\n    readonly R8: 0x8229;\n    readonly RG8: 0x822B;\n    readonly R16F: 0x822D;\n    readonly R32F: 0x822E;\n    readonly RG16F: 0x822F;\n    readonly RG32F: 0x8230;\n    readonly R8I: 0x8231;\n    readonly R8UI: 0x8232;\n    readonly R16I: 0x8233;\n    readonly R16UI: 0x8234;\n    readonly R32I: 0x8235;\n    readonly R32UI: 0x8236;\n    readonly RG8I: 0x8237;\n    readonly RG8UI: 0x8238;\n    readonly RG16I: 0x8239;\n    readonly RG16UI: 0x823A;\n    readonly RG32I: 0x823B;\n    readonly RG32UI: 0x823C;\n    readonly VERTEX_ARRAY_BINDING: 0x85B5;\n    readonly R8_SNORM: 0x8F94;\n    readonly RG8_SNORM: 0x8F95;\n    readonly RGB8_SNORM: 0x8F96;\n    readonly RGBA8_SNORM: 0x8F97;\n    readonly SIGNED_NORMALIZED: 0x8F9C;\n    readonly COPY_READ_BUFFER: 0x8F36;\n    readonly COPY_WRITE_BUFFER: 0x8F37;\n    readonly COPY_READ_BUFFER_BINDING: 0x8F36;\n    readonly COPY_WRITE_BUFFER_BINDING: 0x8F37;\n    readonly UNIFORM_BUFFER: 0x8A11;\n    readonly UNIFORM_BUFFER_BINDING: 0x8A28;\n    readonly UNIFORM_BUFFER_START: 0x8A29;\n    readonly UNIFORM_BUFFER_SIZE: 0x8A2A;\n    readonly MAX_VERTEX_UNIFORM_BLOCKS: 0x8A2B;\n    readonly MAX_FRAGMENT_UNIFORM_BLOCKS: 0x8A2D;\n    readonly MAX_COMBINED_UNIFORM_BLOCKS: 0x8A2E;\n    readonly MAX_UNIFORM_BUFFER_BINDINGS: 0x8A2F;\n    readonly MAX_UNIFORM_BLOCK_SIZE: 0x8A30;\n    readonly MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS: 0x8A31;\n    readonly MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS: 0x8A33;\n    readonly UNIFORM_BUFFER_OFFSET_ALIGNMENT: 0x8A34;\n    readonly ACTIVE_UNIFORM_BLOCKS: 0x8A36;\n    readonly UNIFORM_TYPE: 0x8A37;\n    readonly UNIFORM_SIZE: 0x8A38;\n    readonly UNIFORM_BLOCK_INDEX: 0x8A3A;\n    readonly UNIFORM_OFFSET: 0x8A3B;\n    readonly UNIFORM_ARRAY_STRIDE: 0x8A3C;\n    readonly UNIFORM_MATRIX_STRIDE: 0x8A3D;\n    readonly UNIFORM_IS_ROW_MAJOR: 0x8A3E;\n    readonly UNIFORM_BLOCK_BINDING: 0x8A3F;\n    readonly UNIFORM_BLOCK_DATA_SIZE: 0x8A40;\n    readonly UNIFORM_BLOCK_ACTIVE_UNIFORMS: 0x8A42;\n    readonly UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES: 0x8A43;\n    readonly UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER: 0x8A44;\n    readonly UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER: 0x8A46;\n    readonly INVALID_INDEX: 0xFFFFFFFF;\n    readonly MAX_VERTEX_OUTPUT_COMPONENTS: 0x9122;\n    readonly MAX_FRAGMENT_INPUT_COMPONENTS: 0x9125;\n    readonly MAX_SERVER_WAIT_TIMEOUT: 0x9111;\n    readonly OBJECT_TYPE: 0x9112;\n    readonly SYNC_CONDITION: 0x9113;\n    readonly SYNC_STATUS: 0x9114;\n    readonly SYNC_FLAGS: 0x9115;\n    readonly SYNC_FENCE: 0x9116;\n    readonly SYNC_GPU_COMMANDS_COMPLETE: 0x9117;\n    readonly UNSIGNALED: 0x9118;\n    readonly SIGNALED: 0x9119;\n    readonly ALREADY_SIGNALED: 0x911A;\n    readonly TIMEOUT_EXPIRED: 0x911B;\n    readonly CONDITION_SATISFIED: 0x911C;\n    readonly WAIT_FAILED: 0x911D;\n    readonly SYNC_FLUSH_COMMANDS_BIT: 0x00000001;\n    readonly VERTEX_ATTRIB_ARRAY_DIVISOR: 0x88FE;\n    readonly ANY_SAMPLES_PASSED: 0x8C2F;\n    readonly ANY_SAMPLES_PASSED_CONSERVATIVE: 0x8D6A;\n    readonly SAMPLER_BINDING: 0x8919;\n    readonly RGB10_A2UI: 0x906F;\n    readonly INT_2_10_10_10_REV: 0x8D9F;\n    readonly TRANSFORM_FEEDBACK: 0x8E22;\n    readonly TRANSFORM_FEEDBACK_PAUSED: 0x8E23;\n    readonly TRANSFORM_FEEDBACK_ACTIVE: 0x8E24;\n    readonly TRANSFORM_FEEDBACK_BINDING: 0x8E25;\n    readonly TEXTURE_IMMUTABLE_FORMAT: 0x912F;\n    readonly MAX_ELEMENT_INDEX: 0x8D6B;\n    readonly TEXTURE_IMMUTABLE_LEVELS: 0x82DF;\n    readonly TIMEOUT_IGNORED: -1;\n    readonly MAX_CLIENT_WAIT_TIMEOUT_WEBGL: 0x9247;\n}\n\ninterface WebGL2RenderingContextOverloads {\n    bufferData(target: GLenum, size: GLsizeiptr, usage: GLenum): void;\n    bufferData(target: GLenum, srcData: BufferSource | null, usage: GLenum): void;\n    bufferData(target: GLenum, srcData: ArrayBufferView, usage: GLenum, srcOffset: GLuint, length?: GLuint): void;\n    bufferSubData(target: GLenum, dstByteOffset: GLintptr, srcData: BufferSource): void;\n    bufferSubData(target: GLenum, dstByteOffset: GLintptr, srcData: ArrayBufferView, srcOffset: GLuint, length?: GLuint): void;\n    compressedTexImage2D(target: GLenum, level: GLint, internalformat: GLenum, width: GLsizei, height: GLsizei, border: GLint, imageSize: GLsizei, offset: GLintptr): void;\n    compressedTexImage2D(target: GLenum, level: GLint, internalformat: GLenum, width: GLsizei, height: GLsizei, border: GLint, srcData: ArrayBufferView, srcOffset?: GLuint, srcLengthOverride?: GLuint): void;\n    compressedTexSubImage2D(target: GLenum, level: GLint, xoffset: GLint, yoffset: GLint, width: GLsizei, height: GLsizei, format: GLenum, imageSize: GLsizei, offset: GLintptr): void;\n    compressedTexSubImage2D(target: GLenum, level: GLint, xoffset: GLint, yoffset: GLint, width: GLsizei, height: GLsizei, format: GLenum, srcData: ArrayBufferView, srcOffset?: GLuint, srcLengthOverride?: GLuint): void;\n    readPixels(x: GLint, y: GLint, width: GLsizei, height: GLsizei, format: GLenum, type: GLenum, dstData: ArrayBufferView | null): void;\n    readPixels(x: GLint, y: GLint, width: GLsizei, height: GLsizei, format: GLenum, type: GLenum, offset: GLintptr): void;\n    readPixels(x: GLint, y: GLint, width: GLsizei, height: GLsizei, format: GLenum, type: GLenum, dstData: ArrayBufferView, dstOffset: GLuint): void;\n    texImage2D(target: GLenum, level: GLint, internalformat: GLint, width: GLsizei, height: GLsizei, border: GLint, format: GLenum, type: GLenum, pixels: ArrayBufferView | null): void;\n    texImage2D(target: GLenum, level: GLint, internalformat: GLint, format: GLenum, type: GLenum, source: TexImageSource): void;\n    texImage2D(target: GLenum, level: GLint, internalformat: GLint, width: GLsizei, height: GLsizei, border: GLint, format: GLenum, type: GLenum, pboOffset: GLintptr): void;\n    texImage2D(target: GLenum, level: GLint, internalformat: GLint, width: GLsizei, height: GLsizei, border: GLint, format: GLenum, type: GLenum, source: TexImageSource): void;\n    texImage2D(target: GLenum, level: GLint, internalformat: GLint, width: GLsizei, height: GLsizei, border: GLint, format: GLenum, type: GLenum, srcData: ArrayBufferView, srcOffset: GLuint): void;\n    texSubImage2D(target: GLenum, level: GLint, xoffset: GLint, yoffset: GLint, width: GLsizei, height: GLsizei, format: GLenum, type: GLenum, pixels: ArrayBufferView | null): void;\n    texSubImage2D(target: GLenum, level: GLint, xoffset: GLint, yoffset: GLint, format: GLenum, type: GLenum, source: TexImageSource): void;\n    texSubImage2D(target: GLenum, level: GLint, xoffset: GLint, yoffset: GLint, width: GLsizei, height: GLsizei, format: GLenum, type: GLenum, pboOffset: GLintptr): void;\n    texSubImage2D(target: GLenum, level: GLint, xoffset: GLint, yoffset: GLint, width: GLsizei, height: GLsizei, format: GLenum, type: GLenum, source: TexImageSource): void;\n    texSubImage2D(target: GLenum, level: GLint, xoffset: GLint, yoffset: GLint, width: GLsizei, height: GLsizei, format: GLenum, type: GLenum, srcData: ArrayBufferView, srcOffset: GLuint): void;\n    uniform1fv(location: WebGLUniformLocation | null, data: Float32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform1iv(location: WebGLUniformLocation | null, data: Int32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform2fv(location: WebGLUniformLocation | null, data: Float32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform2iv(location: WebGLUniformLocation | null, data: Int32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform3fv(location: WebGLUniformLocation | null, data: Float32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform3iv(location: WebGLUniformLocation | null, data: Int32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform4fv(location: WebGLUniformLocation | null, data: Float32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform4iv(location: WebGLUniformLocation | null, data: Int32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniformMatrix2fv(location: WebGLUniformLocation | null, transpose: GLboolean, data: Float32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniformMatrix3fv(location: WebGLUniformLocation | null, transpose: GLboolean, data: Float32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniformMatrix4fv(location: WebGLUniformLocation | null, transpose: GLboolean, data: Float32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n}\n\n/** Part of the WebGL API and represents the information returned by calling the WebGLRenderingContext.getActiveAttrib() and WebGLRenderingContext.getActiveUniform() methods. */\ninterface WebGLActiveInfo {\n    readonly name: string;\n    readonly size: GLint;\n    readonly type: GLenum;\n}\n\ndeclare var WebGLActiveInfo: {\n    prototype: WebGLActiveInfo;\n    new(): WebGLActiveInfo;\n};\n\n/** Part of the WebGL API and represents an opaque buffer object storing data such as vertices or colors. */\ninterface WebGLBuffer {\n}\n\ndeclare var WebGLBuffer: {\n    prototype: WebGLBuffer;\n    new(): WebGLBuffer;\n};\n\n/** The WebContextEvent interface is part of the WebGL API and is an interface for an event that is generated in response to a status change to the WebGL rendering context. */\ninterface WebGLContextEvent extends Event {\n    readonly statusMessage: string;\n}\n\ndeclare var WebGLContextEvent: {\n    prototype: WebGLContextEvent;\n    new(type: string, eventInit?: WebGLContextEventInit): WebGLContextEvent;\n};\n\n/** Part of the WebGL API and represents a collection of buffers that serve as a rendering destination. */\ninterface WebGLFramebuffer {\n}\n\ndeclare var WebGLFramebuffer: {\n    prototype: WebGLFramebuffer;\n    new(): WebGLFramebuffer;\n};\n\n/** The WebGLProgram is part of the WebGL API and is a combination of two compiled WebGLShaders consisting of a vertex shader and a fragment shader (both written in GLSL). */\ninterface WebGLProgram {\n}\n\ndeclare var WebGLProgram: {\n    prototype: WebGLProgram;\n    new(): WebGLProgram;\n};\n\ninterface WebGLQuery {\n}\n\ndeclare var WebGLQuery: {\n    prototype: WebGLQuery;\n    new(): WebGLQuery;\n};\n\n/** Part of the WebGL API and represents a buffer that can contain an image, or can be source or target of an rendering operation. */\ninterface WebGLRenderbuffer {\n}\n\ndeclare var WebGLRenderbuffer: {\n    prototype: WebGLRenderbuffer;\n    new(): WebGLRenderbuffer;\n};\n\n/** Provides an interface to the OpenGL ES 2.0 graphics rendering context for the drawing surface of an HTML <canvas> element. */\ninterface WebGLRenderingContext extends WebGLRenderingContextBase, WebGLRenderingContextOverloads {\n}\n\ndeclare var WebGLRenderingContext: {\n    prototype: WebGLRenderingContext;\n    new(): WebGLRenderingContext;\n    readonly DEPTH_BUFFER_BIT: 0x00000100;\n    readonly STENCIL_BUFFER_BIT: 0x00000400;\n    readonly COLOR_BUFFER_BIT: 0x00004000;\n    readonly POINTS: 0x0000;\n    readonly LINES: 0x0001;\n    readonly LINE_LOOP: 0x0002;\n    readonly LINE_STRIP: 0x0003;\n    readonly TRIANGLES: 0x0004;\n    readonly TRIANGLE_STRIP: 0x0005;\n    readonly TRIANGLE_FAN: 0x0006;\n    readonly ZERO: 0;\n    readonly ONE: 1;\n    readonly SRC_COLOR: 0x0300;\n    readonly ONE_MINUS_SRC_COLOR: 0x0301;\n    readonly SRC_ALPHA: 0x0302;\n    readonly ONE_MINUS_SRC_ALPHA: 0x0303;\n    readonly DST_ALPHA: 0x0304;\n    readonly ONE_MINUS_DST_ALPHA: 0x0305;\n    readonly DST_COLOR: 0x0306;\n    readonly ONE_MINUS_DST_COLOR: 0x0307;\n    readonly SRC_ALPHA_SATURATE: 0x0308;\n    readonly FUNC_ADD: 0x8006;\n    readonly BLEND_EQUATION: 0x8009;\n    readonly BLEND_EQUATION_RGB: 0x8009;\n    readonly BLEND_EQUATION_ALPHA: 0x883D;\n    readonly FUNC_SUBTRACT: 0x800A;\n    readonly FUNC_REVERSE_SUBTRACT: 0x800B;\n    readonly BLEND_DST_RGB: 0x80C8;\n    readonly BLEND_SRC_RGB: 0x80C9;\n    readonly BLEND_DST_ALPHA: 0x80CA;\n    readonly BLEND_SRC_ALPHA: 0x80CB;\n    readonly CONSTANT_COLOR: 0x8001;\n    readonly ONE_MINUS_CONSTANT_COLOR: 0x8002;\n    readonly CONSTANT_ALPHA: 0x8003;\n    readonly ONE_MINUS_CONSTANT_ALPHA: 0x8004;\n    readonly BLEND_COLOR: 0x8005;\n    readonly ARRAY_BUFFER: 0x8892;\n    readonly ELEMENT_ARRAY_BUFFER: 0x8893;\n    readonly ARRAY_BUFFER_BINDING: 0x8894;\n    readonly ELEMENT_ARRAY_BUFFER_BINDING: 0x8895;\n    readonly STREAM_DRAW: 0x88E0;\n    readonly STATIC_DRAW: 0x88E4;\n    readonly DYNAMIC_DRAW: 0x88E8;\n    readonly BUFFER_SIZE: 0x8764;\n    readonly BUFFER_USAGE: 0x8765;\n    readonly CURRENT_VERTEX_ATTRIB: 0x8626;\n    readonly FRONT: 0x0404;\n    readonly BACK: 0x0405;\n    readonly FRONT_AND_BACK: 0x0408;\n    readonly CULL_FACE: 0x0B44;\n    readonly BLEND: 0x0BE2;\n    readonly DITHER: 0x0BD0;\n    readonly STENCIL_TEST: 0x0B90;\n    readonly DEPTH_TEST: 0x0B71;\n    readonly SCISSOR_TEST: 0x0C11;\n    readonly POLYGON_OFFSET_FILL: 0x8037;\n    readonly SAMPLE_ALPHA_TO_COVERAGE: 0x809E;\n    readonly SAMPLE_COVERAGE: 0x80A0;\n    readonly NO_ERROR: 0;\n    readonly INVALID_ENUM: 0x0500;\n    readonly INVALID_VALUE: 0x0501;\n    readonly INVALID_OPERATION: 0x0502;\n    readonly OUT_OF_MEMORY: 0x0505;\n    readonly CW: 0x0900;\n    readonly CCW: 0x0901;\n    readonly LINE_WIDTH: 0x0B21;\n    readonly ALIASED_POINT_SIZE_RANGE: 0x846D;\n    readonly ALIASED_LINE_WIDTH_RANGE: 0x846E;\n    readonly CULL_FACE_MODE: 0x0B45;\n    readonly FRONT_FACE: 0x0B46;\n    readonly DEPTH_RANGE: 0x0B70;\n    readonly DEPTH_WRITEMASK: 0x0B72;\n    readonly DEPTH_CLEAR_VALUE: 0x0B73;\n    readonly DEPTH_FUNC: 0x0B74;\n    readonly STENCIL_CLEAR_VALUE: 0x0B91;\n    readonly STENCIL_FUNC: 0x0B92;\n    readonly STENCIL_FAIL: 0x0B94;\n    readonly STENCIL_PASS_DEPTH_FAIL: 0x0B95;\n    readonly STENCIL_PASS_DEPTH_PASS: 0x0B96;\n    readonly STENCIL_REF: 0x0B97;\n    readonly STENCIL_VALUE_MASK: 0x0B93;\n    readonly STENCIL_WRITEMASK: 0x0B98;\n    readonly STENCIL_BACK_FUNC: 0x8800;\n    readonly STENCIL_BACK_FAIL: 0x8801;\n    readonly STENCIL_BACK_PASS_DEPTH_FAIL: 0x8802;\n    readonly STENCIL_BACK_PASS_DEPTH_PASS: 0x8803;\n    readonly STENCIL_BACK_REF: 0x8CA3;\n    readonly STENCIL_BACK_VALUE_MASK: 0x8CA4;\n    readonly STENCIL_BACK_WRITEMASK: 0x8CA5;\n    readonly VIEWPORT: 0x0BA2;\n    readonly SCISSOR_BOX: 0x0C10;\n    readonly COLOR_CLEAR_VALUE: 0x0C22;\n    readonly COLOR_WRITEMASK: 0x0C23;\n    readonly UNPACK_ALIGNMENT: 0x0CF5;\n    readonly PACK_ALIGNMENT: 0x0D05;\n    readonly MAX_TEXTURE_SIZE: 0x0D33;\n    readonly MAX_VIEWPORT_DIMS: 0x0D3A;\n    readonly SUBPIXEL_BITS: 0x0D50;\n    readonly RED_BITS: 0x0D52;\n    readonly GREEN_BITS: 0x0D53;\n    readonly BLUE_BITS: 0x0D54;\n    readonly ALPHA_BITS: 0x0D55;\n    readonly DEPTH_BITS: 0x0D56;\n    readonly STENCIL_BITS: 0x0D57;\n    readonly POLYGON_OFFSET_UNITS: 0x2A00;\n    readonly POLYGON_OFFSET_FACTOR: 0x8038;\n    readonly TEXTURE_BINDING_2D: 0x8069;\n    readonly SAMPLE_BUFFERS: 0x80A8;\n    readonly SAMPLES: 0x80A9;\n    readonly SAMPLE_COVERAGE_VALUE: 0x80AA;\n    readonly SAMPLE_COVERAGE_INVERT: 0x80AB;\n    readonly COMPRESSED_TEXTURE_FORMATS: 0x86A3;\n    readonly DONT_CARE: 0x1100;\n    readonly FASTEST: 0x1101;\n    readonly NICEST: 0x1102;\n    readonly GENERATE_MIPMAP_HINT: 0x8192;\n    readonly BYTE: 0x1400;\n    readonly UNSIGNED_BYTE: 0x1401;\n    readonly SHORT: 0x1402;\n    readonly UNSIGNED_SHORT: 0x1403;\n    readonly INT: 0x1404;\n    readonly UNSIGNED_INT: 0x1405;\n    readonly FLOAT: 0x1406;\n    readonly DEPTH_COMPONENT: 0x1902;\n    readonly ALPHA: 0x1906;\n    readonly RGB: 0x1907;\n    readonly RGBA: 0x1908;\n    readonly LUMINANCE: 0x1909;\n    readonly LUMINANCE_ALPHA: 0x190A;\n    readonly UNSIGNED_SHORT_4_4_4_4: 0x8033;\n    readonly UNSIGNED_SHORT_5_5_5_1: 0x8034;\n    readonly UNSIGNED_SHORT_5_6_5: 0x8363;\n    readonly FRAGMENT_SHADER: 0x8B30;\n    readonly VERTEX_SHADER: 0x8B31;\n    readonly MAX_VERTEX_ATTRIBS: 0x8869;\n    readonly MAX_VERTEX_UNIFORM_VECTORS: 0x8DFB;\n    readonly MAX_VARYING_VECTORS: 0x8DFC;\n    readonly MAX_COMBINED_TEXTURE_IMAGE_UNITS: 0x8B4D;\n    readonly MAX_VERTEX_TEXTURE_IMAGE_UNITS: 0x8B4C;\n    readonly MAX_TEXTURE_IMAGE_UNITS: 0x8872;\n    readonly MAX_FRAGMENT_UNIFORM_VECTORS: 0x8DFD;\n    readonly SHADER_TYPE: 0x8B4F;\n    readonly DELETE_STATUS: 0x8B80;\n    readonly LINK_STATUS: 0x8B82;\n    readonly VALIDATE_STATUS: 0x8B83;\n    readonly ATTACHED_SHADERS: 0x8B85;\n    readonly ACTIVE_UNIFORMS: 0x8B86;\n    readonly ACTIVE_ATTRIBUTES: 0x8B89;\n    readonly SHADING_LANGUAGE_VERSION: 0x8B8C;\n    readonly CURRENT_PROGRAM: 0x8B8D;\n    readonly NEVER: 0x0200;\n    readonly LESS: 0x0201;\n    readonly EQUAL: 0x0202;\n    readonly LEQUAL: 0x0203;\n    readonly GREATER: 0x0204;\n    readonly NOTEQUAL: 0x0205;\n    readonly GEQUAL: 0x0206;\n    readonly ALWAYS: 0x0207;\n    readonly KEEP: 0x1E00;\n    readonly REPLACE: 0x1E01;\n    readonly INCR: 0x1E02;\n    readonly DECR: 0x1E03;\n    readonly INVERT: 0x150A;\n    readonly INCR_WRAP: 0x8507;\n    readonly DECR_WRAP: 0x8508;\n    readonly VENDOR: 0x1F00;\n    readonly RENDERER: 0x1F01;\n    readonly VERSION: 0x1F02;\n    readonly NEAREST: 0x2600;\n    readonly LINEAR: 0x2601;\n    readonly NEAREST_MIPMAP_NEAREST: 0x2700;\n    readonly LINEAR_MIPMAP_NEAREST: 0x2701;\n    readonly NEAREST_MIPMAP_LINEAR: 0x2702;\n    readonly LINEAR_MIPMAP_LINEAR: 0x2703;\n    readonly TEXTURE_MAG_FILTER: 0x2800;\n    readonly TEXTURE_MIN_FILTER: 0x2801;\n    readonly TEXTURE_WRAP_S: 0x2802;\n    readonly TEXTURE_WRAP_T: 0x2803;\n    readonly TEXTURE_2D: 0x0DE1;\n    readonly TEXTURE: 0x1702;\n    readonly TEXTURE_CUBE_MAP: 0x8513;\n    readonly TEXTURE_BINDING_CUBE_MAP: 0x8514;\n    readonly TEXTURE_CUBE_MAP_POSITIVE_X: 0x8515;\n    readonly TEXTURE_CUBE_MAP_NEGATIVE_X: 0x8516;\n    readonly TEXTURE_CUBE_MAP_POSITIVE_Y: 0x8517;\n    readonly TEXTURE_CUBE_MAP_NEGATIVE_Y: 0x8518;\n    readonly TEXTURE_CUBE_MAP_POSITIVE_Z: 0x8519;\n    readonly TEXTURE_CUBE_MAP_NEGATIVE_Z: 0x851A;\n    readonly MAX_CUBE_MAP_TEXTURE_SIZE: 0x851C;\n    readonly TEXTURE0: 0x84C0;\n    readonly TEXTURE1: 0x84C1;\n    readonly TEXTURE2: 0x84C2;\n    readonly TEXTURE3: 0x84C3;\n    readonly TEXTURE4: 0x84C4;\n    readonly TEXTURE5: 0x84C5;\n    readonly TEXTURE6: 0x84C6;\n    readonly TEXTURE7: 0x84C7;\n    readonly TEXTURE8: 0x84C8;\n    readonly TEXTURE9: 0x84C9;\n    readonly TEXTURE10: 0x84CA;\n    readonly TEXTURE11: 0x84CB;\n    readonly TEXTURE12: 0x84CC;\n    readonly TEXTURE13: 0x84CD;\n    readonly TEXTURE14: 0x84CE;\n    readonly TEXTURE15: 0x84CF;\n    readonly TEXTURE16: 0x84D0;\n    readonly TEXTURE17: 0x84D1;\n    readonly TEXTURE18: 0x84D2;\n    readonly TEXTURE19: 0x84D3;\n    readonly TEXTURE20: 0x84D4;\n    readonly TEXTURE21: 0x84D5;\n    readonly TEXTURE22: 0x84D6;\n    readonly TEXTURE23: 0x84D7;\n    readonly TEXTURE24: 0x84D8;\n    readonly TEXTURE25: 0x84D9;\n    readonly TEXTURE26: 0x84DA;\n    readonly TEXTURE27: 0x84DB;\n    readonly TEXTURE28: 0x84DC;\n    readonly TEXTURE29: 0x84DD;\n    readonly TEXTURE30: 0x84DE;\n    readonly TEXTURE31: 0x84DF;\n    readonly ACTIVE_TEXTURE: 0x84E0;\n    readonly REPEAT: 0x2901;\n    readonly CLAMP_TO_EDGE: 0x812F;\n    readonly MIRRORED_REPEAT: 0x8370;\n    readonly FLOAT_VEC2: 0x8B50;\n    readonly FLOAT_VEC3: 0x8B51;\n    readonly FLOAT_VEC4: 0x8B52;\n    readonly INT_VEC2: 0x8B53;\n    readonly INT_VEC3: 0x8B54;\n    readonly INT_VEC4: 0x8B55;\n    readonly BOOL: 0x8B56;\n    readonly BOOL_VEC2: 0x8B57;\n    readonly BOOL_VEC3: 0x8B58;\n    readonly BOOL_VEC4: 0x8B59;\n    readonly FLOAT_MAT2: 0x8B5A;\n    readonly FLOAT_MAT3: 0x8B5B;\n    readonly FLOAT_MAT4: 0x8B5C;\n    readonly SAMPLER_2D: 0x8B5E;\n    readonly SAMPLER_CUBE: 0x8B60;\n    readonly VERTEX_ATTRIB_ARRAY_ENABLED: 0x8622;\n    readonly VERTEX_ATTRIB_ARRAY_SIZE: 0x8623;\n    readonly VERTEX_ATTRIB_ARRAY_STRIDE: 0x8624;\n    readonly VERTEX_ATTRIB_ARRAY_TYPE: 0x8625;\n    readonly VERTEX_ATTRIB_ARRAY_NORMALIZED: 0x886A;\n    readonly VERTEX_ATTRIB_ARRAY_POINTER: 0x8645;\n    readonly VERTEX_ATTRIB_ARRAY_BUFFER_BINDING: 0x889F;\n    readonly IMPLEMENTATION_COLOR_READ_TYPE: 0x8B9A;\n    readonly IMPLEMENTATION_COLOR_READ_FORMAT: 0x8B9B;\n    readonly COMPILE_STATUS: 0x8B81;\n    readonly LOW_FLOAT: 0x8DF0;\n    readonly MEDIUM_FLOAT: 0x8DF1;\n    readonly HIGH_FLOAT: 0x8DF2;\n    readonly LOW_INT: 0x8DF3;\n    readonly MEDIUM_INT: 0x8DF4;\n    readonly HIGH_INT: 0x8DF5;\n    readonly FRAMEBUFFER: 0x8D40;\n    readonly RENDERBUFFER: 0x8D41;\n    readonly RGBA4: 0x8056;\n    readonly RGB5_A1: 0x8057;\n    readonly RGB565: 0x8D62;\n    readonly DEPTH_COMPONENT16: 0x81A5;\n    readonly STENCIL_INDEX8: 0x8D48;\n    readonly DEPTH_STENCIL: 0x84F9;\n    readonly RENDERBUFFER_WIDTH: 0x8D42;\n    readonly RENDERBUFFER_HEIGHT: 0x8D43;\n    readonly RENDERBUFFER_INTERNAL_FORMAT: 0x8D44;\n    readonly RENDERBUFFER_RED_SIZE: 0x8D50;\n    readonly RENDERBUFFER_GREEN_SIZE: 0x8D51;\n    readonly RENDERBUFFER_BLUE_SIZE: 0x8D52;\n    readonly RENDERBUFFER_ALPHA_SIZE: 0x8D53;\n    readonly RENDERBUFFER_DEPTH_SIZE: 0x8D54;\n    readonly RENDERBUFFER_STENCIL_SIZE: 0x8D55;\n    readonly FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE: 0x8CD0;\n    readonly FRAMEBUFFER_ATTACHMENT_OBJECT_NAME: 0x8CD1;\n    readonly FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL: 0x8CD2;\n    readonly FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE: 0x8CD3;\n    readonly COLOR_ATTACHMENT0: 0x8CE0;\n    readonly DEPTH_ATTACHMENT: 0x8D00;\n    readonly STENCIL_ATTACHMENT: 0x8D20;\n    readonly DEPTH_STENCIL_ATTACHMENT: 0x821A;\n    readonly NONE: 0;\n    readonly FRAMEBUFFER_COMPLETE: 0x8CD5;\n    readonly FRAMEBUFFER_INCOMPLETE_ATTACHMENT: 0x8CD6;\n    readonly FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT: 0x8CD7;\n    readonly FRAMEBUFFER_INCOMPLETE_DIMENSIONS: 0x8CD9;\n    readonly FRAMEBUFFER_UNSUPPORTED: 0x8CDD;\n    readonly FRAMEBUFFER_BINDING: 0x8CA6;\n    readonly RENDERBUFFER_BINDING: 0x8CA7;\n    readonly MAX_RENDERBUFFER_SIZE: 0x84E8;\n    readonly INVALID_FRAMEBUFFER_OPERATION: 0x0506;\n    readonly UNPACK_FLIP_Y_WEBGL: 0x9240;\n    readonly UNPACK_PREMULTIPLY_ALPHA_WEBGL: 0x9241;\n    readonly CONTEXT_LOST_WEBGL: 0x9242;\n    readonly UNPACK_COLORSPACE_CONVERSION_WEBGL: 0x9243;\n    readonly BROWSER_DEFAULT_WEBGL: 0x9244;\n};\n\ninterface WebGLRenderingContextBase {\n    readonly canvas: HTMLCanvasElement | OffscreenCanvas;\n    readonly drawingBufferHeight: GLsizei;\n    readonly drawingBufferWidth: GLsizei;\n    activeTexture(texture: GLenum): void;\n    attachShader(program: WebGLProgram, shader: WebGLShader): void;\n    bindAttribLocation(program: WebGLProgram, index: GLuint, name: string): void;\n    bindBuffer(target: GLenum, buffer: WebGLBuffer | null): void;\n    bindFramebuffer(target: GLenum, framebuffer: WebGLFramebuffer | null): void;\n    bindRenderbuffer(target: GLenum, renderbuffer: WebGLRenderbuffer | null): void;\n    bindTexture(target: GLenum, texture: WebGLTexture | null): void;\n    blendColor(red: GLclampf, green: GLclampf, blue: GLclampf, alpha: GLclampf): void;\n    blendEquation(mode: GLenum): void;\n    blendEquationSeparate(modeRGB: GLenum, modeAlpha: GLenum): void;\n    blendFunc(sfactor: GLenum, dfactor: GLenum): void;\n    blendFuncSeparate(srcRGB: GLenum, dstRGB: GLenum, srcAlpha: GLenum, dstAlpha: GLenum): void;\n    checkFramebufferStatus(target: GLenum): GLenum;\n    clear(mask: GLbitfield): void;\n    clearColor(red: GLclampf, green: GLclampf, blue: GLclampf, alpha: GLclampf): void;\n    clearDepth(depth: GLclampf): void;\n    clearStencil(s: GLint): void;\n    colorMask(red: GLboolean, green: GLboolean, blue: GLboolean, alpha: GLboolean): void;\n    compileShader(shader: WebGLShader): void;\n    copyTexImage2D(target: GLenum, level: GLint, internalformat: GLenum, x: GLint, y: GLint, width: GLsizei, height: GLsizei, border: GLint): void;\n    copyTexSubImage2D(target: GLenum, level: GLint, xoffset: GLint, yoffset: GLint, x: GLint, y: GLint, width: GLsizei, height: GLsizei): void;\n    createBuffer(): WebGLBuffer | null;\n    createFramebuffer(): WebGLFramebuffer | null;\n    createProgram(): WebGLProgram | null;\n    createRenderbuffer(): WebGLRenderbuffer | null;\n    createShader(type: GLenum): WebGLShader | null;\n    createTexture(): WebGLTexture | null;\n    cullFace(mode: GLenum): void;\n    deleteBuffer(buffer: WebGLBuffer | null): void;\n    deleteFramebuffer(framebuffer: WebGLFramebuffer | null): void;\n    deleteProgram(program: WebGLProgram | null): void;\n    deleteRenderbuffer(renderbuffer: WebGLRenderbuffer | null): void;\n    deleteShader(shader: WebGLShader | null): void;\n    deleteTexture(texture: WebGLTexture | null): void;\n    depthFunc(func: GLenum): void;\n    depthMask(flag: GLboolean): void;\n    depthRange(zNear: GLclampf, zFar: GLclampf): void;\n    detachShader(program: WebGLProgram, shader: WebGLShader): void;\n    disable(cap: GLenum): void;\n    disableVertexAttribArray(index: GLuint): void;\n    drawArrays(mode: GLenum, first: GLint, count: GLsizei): void;\n    drawElements(mode: GLenum, count: GLsizei, type: GLenum, offset: GLintptr): void;\n    enable(cap: GLenum): void;\n    enableVertexAttribArray(index: GLuint): void;\n    finish(): void;\n    flush(): void;\n    framebufferRenderbuffer(target: GLenum, attachment: GLenum, renderbuffertarget: GLenum, renderbuffer: WebGLRenderbuffer | null): void;\n    framebufferTexture2D(target: GLenum, attachment: GLenum, textarget: GLenum, texture: WebGLTexture | null, level: GLint): void;\n    frontFace(mode: GLenum): void;\n    generateMipmap(target: GLenum): void;\n    getActiveAttrib(program: WebGLProgram, index: GLuint): WebGLActiveInfo | null;\n    getActiveUniform(program: WebGLProgram, index: GLuint): WebGLActiveInfo | null;\n    getAttachedShaders(program: WebGLProgram): WebGLShader[] | null;\n    getAttribLocation(program: WebGLProgram, name: string): GLint;\n    getBufferParameter(target: GLenum, pname: GLenum): any;\n    getContextAttributes(): WebGLContextAttributes | null;\n    getError(): GLenum;\n    getExtension(extensionName: \"ANGLE_instanced_arrays\"): ANGLE_instanced_arrays | null;\n    getExtension(extensionName: \"EXT_blend_minmax\"): EXT_blend_minmax | null;\n    getExtension(extensionName: \"EXT_color_buffer_float\"): EXT_color_buffer_float | null;\n    getExtension(extensionName: \"EXT_color_buffer_half_float\"): EXT_color_buffer_half_float | null;\n    getExtension(extensionName: \"EXT_float_blend\"): EXT_float_blend | null;\n    getExtension(extensionName: \"EXT_frag_depth\"): EXT_frag_depth | null;\n    getExtension(extensionName: \"EXT_sRGB\"): EXT_sRGB | null;\n    getExtension(extensionName: \"EXT_shader_texture_lod\"): EXT_shader_texture_lod | null;\n    getExtension(extensionName: \"EXT_texture_compression_bptc\"): EXT_texture_compression_bptc | null;\n    getExtension(extensionName: \"EXT_texture_compression_rgtc\"): EXT_texture_compression_rgtc | null;\n    getExtension(extensionName: \"EXT_texture_filter_anisotropic\"): EXT_texture_filter_anisotropic | null;\n    getExtension(extensionName: \"KHR_parallel_shader_compile\"): KHR_parallel_shader_compile | null;\n    getExtension(extensionName: \"OES_element_index_uint\"): OES_element_index_uint | null;\n    getExtension(extensionName: \"OES_fbo_render_mipmap\"): OES_fbo_render_mipmap | null;\n    getExtension(extensionName: \"OES_standard_derivatives\"): OES_standard_derivatives | null;\n    getExtension(extensionName: \"OES_texture_float\"): OES_texture_float | null;\n    getExtension(extensionName: \"OES_texture_float_linear\"): OES_texture_float_linear | null;\n    getExtension(extensionName: \"OES_texture_half_float\"): OES_texture_half_float | null;\n    getExtension(extensionName: \"OES_texture_half_float_linear\"): OES_texture_half_float_linear | null;\n    getExtension(extensionName: \"OES_vertex_array_object\"): OES_vertex_array_object | null;\n    getExtension(extensionName: \"OVR_multiview2\"): OVR_multiview2 | null;\n    getExtension(extensionName: \"WEBGL_color_buffer_float\"): WEBGL_color_buffer_float | null;\n    getExtension(extensionName: \"WEBGL_compressed_texture_astc\"): WEBGL_compressed_texture_astc | null;\n    getExtension(extensionName: \"WEBGL_compressed_texture_etc\"): WEBGL_compressed_texture_etc | null;\n    getExtension(extensionName: \"WEBGL_compressed_texture_etc1\"): WEBGL_compressed_texture_etc1 | null;\n    getExtension(extensionName: \"WEBGL_compressed_texture_s3tc\"): WEBGL_compressed_texture_s3tc | null;\n    getExtension(extensionName: \"WEBGL_compressed_texture_s3tc_srgb\"): WEBGL_compressed_texture_s3tc_srgb | null;\n    getExtension(extensionName: \"WEBGL_debug_renderer_info\"): WEBGL_debug_renderer_info | null;\n    getExtension(extensionName: \"WEBGL_debug_shaders\"): WEBGL_debug_shaders | null;\n    getExtension(extensionName: \"WEBGL_depth_texture\"): WEBGL_depth_texture | null;\n    getExtension(extensionName: \"WEBGL_draw_buffers\"): WEBGL_draw_buffers | null;\n    getExtension(extensionName: \"WEBGL_lose_context\"): WEBGL_lose_context | null;\n    getExtension(extensionName: \"WEBGL_multi_draw\"): WEBGL_multi_draw | null;\n    getExtension(name: string): any;\n    getFramebufferAttachmentParameter(target: GLenum, attachment: GLenum, pname: GLenum): any;\n    getParameter(pname: GLenum): any;\n    getProgramInfoLog(program: WebGLProgram): string | null;\n    getProgramParameter(program: WebGLProgram, pname: GLenum): any;\n    getRenderbufferParameter(target: GLenum, pname: GLenum): any;\n    getShaderInfoLog(shader: WebGLShader): string | null;\n    getShaderParameter(shader: WebGLShader, pname: GLenum): any;\n    getShaderPrecisionFormat(shadertype: GLenum, precisiontype: GLenum): WebGLShaderPrecisionFormat | null;\n    getShaderSource(shader: WebGLShader): string | null;\n    getSupportedExtensions(): string[] | null;\n    getTexParameter(target: GLenum, pname: GLenum): any;\n    getUniform(program: WebGLProgram, location: WebGLUniformLocation): any;\n    getUniformLocation(program: WebGLProgram, name: string): WebGLUniformLocation | null;\n    getVertexAttrib(index: GLuint, pname: GLenum): any;\n    getVertexAttribOffset(index: GLuint, pname: GLenum): GLintptr;\n    hint(target: GLenum, mode: GLenum): void;\n    isBuffer(buffer: WebGLBuffer | null): GLboolean;\n    isContextLost(): boolean;\n    isEnabled(cap: GLenum): GLboolean;\n    isFramebuffer(framebuffer: WebGLFramebuffer | null): GLboolean;\n    isProgram(program: WebGLProgram | null): GLboolean;\n    isRenderbuffer(renderbuffer: WebGLRenderbuffer | null): GLboolean;\n    isShader(shader: WebGLShader | null): GLboolean;\n    isTexture(texture: WebGLTexture | null): GLboolean;\n    lineWidth(width: GLfloat): void;\n    linkProgram(program: WebGLProgram): void;\n    pixelStorei(pname: GLenum, param: GLint | GLboolean): void;\n    polygonOffset(factor: GLfloat, units: GLfloat): void;\n    renderbufferStorage(target: GLenum, internalformat: GLenum, width: GLsizei, height: GLsizei): void;\n    sampleCoverage(value: GLclampf, invert: GLboolean): void;\n    scissor(x: GLint, y: GLint, width: GLsizei, height: GLsizei): void;\n    shaderSource(shader: WebGLShader, source: string): void;\n    stencilFunc(func: GLenum, ref: GLint, mask: GLuint): void;\n    stencilFuncSeparate(face: GLenum, func: GLenum, ref: GLint, mask: GLuint): void;\n    stencilMask(mask: GLuint): void;\n    stencilMaskSeparate(face: GLenum, mask: GLuint): void;\n    stencilOp(fail: GLenum, zfail: GLenum, zpass: GLenum): void;\n    stencilOpSeparate(face: GLenum, fail: GLenum, zfail: GLenum, zpass: GLenum): void;\n    texParameterf(target: GLenum, pname: GLenum, param: GLfloat): void;\n    texParameteri(target: GLenum, pname: GLenum, param: GLint): void;\n    uniform1f(location: WebGLUniformLocation | null, x: GLfloat): void;\n    uniform1i(location: WebGLUniformLocation | null, x: GLint): void;\n    uniform2f(location: WebGLUniformLocation | null, x: GLfloat, y: GLfloat): void;\n    uniform2i(location: WebGLUniformLocation | null, x: GLint, y: GLint): void;\n    uniform3f(location: WebGLUniformLocation | null, x: GLfloat, y: GLfloat, z: GLfloat): void;\n    uniform3i(location: WebGLUniformLocation | null, x: GLint, y: GLint, z: GLint): void;\n    uniform4f(location: WebGLUniformLocation | null, x: GLfloat, y: GLfloat, z: GLfloat, w: GLfloat): void;\n    uniform4i(location: WebGLUniformLocation | null, x: GLint, y: GLint, z: GLint, w: GLint): void;\n    useProgram(program: WebGLProgram | null): void;\n    validateProgram(program: WebGLProgram): void;\n    vertexAttrib1f(index: GLuint, x: GLfloat): void;\n    vertexAttrib1fv(index: GLuint, values: Float32List): void;\n    vertexAttrib2f(index: GLuint, x: GLfloat, y: GLfloat): void;\n    vertexAttrib2fv(index: GLuint, values: Float32List): void;\n    vertexAttrib3f(index: GLuint, x: GLfloat, y: GLfloat, z: GLfloat): void;\n    vertexAttrib3fv(index: GLuint, values: Float32List): void;\n    vertexAttrib4f(index: GLuint, x: GLfloat, y: GLfloat, z: GLfloat, w: GLfloat): void;\n    vertexAttrib4fv(index: GLuint, values: Float32List): void;\n    vertexAttribPointer(index: GLuint, size: GLint, type: GLenum, normalized: GLboolean, stride: GLsizei, offset: GLintptr): void;\n    viewport(x: GLint, y: GLint, width: GLsizei, height: GLsizei): void;\n    readonly DEPTH_BUFFER_BIT: 0x00000100;\n    readonly STENCIL_BUFFER_BIT: 0x00000400;\n    readonly COLOR_BUFFER_BIT: 0x00004000;\n    readonly POINTS: 0x0000;\n    readonly LINES: 0x0001;\n    readonly LINE_LOOP: 0x0002;\n    readonly LINE_STRIP: 0x0003;\n    readonly TRIANGLES: 0x0004;\n    readonly TRIANGLE_STRIP: 0x0005;\n    readonly TRIANGLE_FAN: 0x0006;\n    readonly ZERO: 0;\n    readonly ONE: 1;\n    readonly SRC_COLOR: 0x0300;\n    readonly ONE_MINUS_SRC_COLOR: 0x0301;\n    readonly SRC_ALPHA: 0x0302;\n    readonly ONE_MINUS_SRC_ALPHA: 0x0303;\n    readonly DST_ALPHA: 0x0304;\n    readonly ONE_MINUS_DST_ALPHA: 0x0305;\n    readonly DST_COLOR: 0x0306;\n    readonly ONE_MINUS_DST_COLOR: 0x0307;\n    readonly SRC_ALPHA_SATURATE: 0x0308;\n    readonly FUNC_ADD: 0x8006;\n    readonly BLEND_EQUATION: 0x8009;\n    readonly BLEND_EQUATION_RGB: 0x8009;\n    readonly BLEND_EQUATION_ALPHA: 0x883D;\n    readonly FUNC_SUBTRACT: 0x800A;\n    readonly FUNC_REVERSE_SUBTRACT: 0x800B;\n    readonly BLEND_DST_RGB: 0x80C8;\n    readonly BLEND_SRC_RGB: 0x80C9;\n    readonly BLEND_DST_ALPHA: 0x80CA;\n    readonly BLEND_SRC_ALPHA: 0x80CB;\n    readonly CONSTANT_COLOR: 0x8001;\n    readonly ONE_MINUS_CONSTANT_COLOR: 0x8002;\n    readonly CONSTANT_ALPHA: 0x8003;\n    readonly ONE_MINUS_CONSTANT_ALPHA: 0x8004;\n    readonly BLEND_COLOR: 0x8005;\n    readonly ARRAY_BUFFER: 0x8892;\n    readonly ELEMENT_ARRAY_BUFFER: 0x8893;\n    readonly ARRAY_BUFFER_BINDING: 0x8894;\n    readonly ELEMENT_ARRAY_BUFFER_BINDING: 0x8895;\n    readonly STREAM_DRAW: 0x88E0;\n    readonly STATIC_DRAW: 0x88E4;\n    readonly DYNAMIC_DRAW: 0x88E8;\n    readonly BUFFER_SIZE: 0x8764;\n    readonly BUFFER_USAGE: 0x8765;\n    readonly CURRENT_VERTEX_ATTRIB: 0x8626;\n    readonly FRONT: 0x0404;\n    readonly BACK: 0x0405;\n    readonly FRONT_AND_BACK: 0x0408;\n    readonly CULL_FACE: 0x0B44;\n    readonly BLEND: 0x0BE2;\n    readonly DITHER: 0x0BD0;\n    readonly STENCIL_TEST: 0x0B90;\n    readonly DEPTH_TEST: 0x0B71;\n    readonly SCISSOR_TEST: 0x0C11;\n    readonly POLYGON_OFFSET_FILL: 0x8037;\n    readonly SAMPLE_ALPHA_TO_COVERAGE: 0x809E;\n    readonly SAMPLE_COVERAGE: 0x80A0;\n    readonly NO_ERROR: 0;\n    readonly INVALID_ENUM: 0x0500;\n    readonly INVALID_VALUE: 0x0501;\n    readonly INVALID_OPERATION: 0x0502;\n    readonly OUT_OF_MEMORY: 0x0505;\n    readonly CW: 0x0900;\n    readonly CCW: 0x0901;\n    readonly LINE_WIDTH: 0x0B21;\n    readonly ALIASED_POINT_SIZE_RANGE: 0x846D;\n    readonly ALIASED_LINE_WIDTH_RANGE: 0x846E;\n    readonly CULL_FACE_MODE: 0x0B45;\n    readonly FRONT_FACE: 0x0B46;\n    readonly DEPTH_RANGE: 0x0B70;\n    readonly DEPTH_WRITEMASK: 0x0B72;\n    readonly DEPTH_CLEAR_VALUE: 0x0B73;\n    readonly DEPTH_FUNC: 0x0B74;\n    readonly STENCIL_CLEAR_VALUE: 0x0B91;\n    readonly STENCIL_FUNC: 0x0B92;\n    readonly STENCIL_FAIL: 0x0B94;\n    readonly STENCIL_PASS_DEPTH_FAIL: 0x0B95;\n    readonly STENCIL_PASS_DEPTH_PASS: 0x0B96;\n    readonly STENCIL_REF: 0x0B97;\n    readonly STENCIL_VALUE_MASK: 0x0B93;\n    readonly STENCIL_WRITEMASK: 0x0B98;\n    readonly STENCIL_BACK_FUNC: 0x8800;\n    readonly STENCIL_BACK_FAIL: 0x8801;\n    readonly STENCIL_BACK_PASS_DEPTH_FAIL: 0x8802;\n    readonly STENCIL_BACK_PASS_DEPTH_PASS: 0x8803;\n    readonly STENCIL_BACK_REF: 0x8CA3;\n    readonly STENCIL_BACK_VALUE_MASK: 0x8CA4;\n    readonly STENCIL_BACK_WRITEMASK: 0x8CA5;\n    readonly VIEWPORT: 0x0BA2;\n    readonly SCISSOR_BOX: 0x0C10;\n    readonly COLOR_CLEAR_VALUE: 0x0C22;\n    readonly COLOR_WRITEMASK: 0x0C23;\n    readonly UNPACK_ALIGNMENT: 0x0CF5;\n    readonly PACK_ALIGNMENT: 0x0D05;\n    readonly MAX_TEXTURE_SIZE: 0x0D33;\n    readonly MAX_VIEWPORT_DIMS: 0x0D3A;\n    readonly SUBPIXEL_BITS: 0x0D50;\n    readonly RED_BITS: 0x0D52;\n    readonly GREEN_BITS: 0x0D53;\n    readonly BLUE_BITS: 0x0D54;\n    readonly ALPHA_BITS: 0x0D55;\n    readonly DEPTH_BITS: 0x0D56;\n    readonly STENCIL_BITS: 0x0D57;\n    readonly POLYGON_OFFSET_UNITS: 0x2A00;\n    readonly POLYGON_OFFSET_FACTOR: 0x8038;\n    readonly TEXTURE_BINDING_2D: 0x8069;\n    readonly SAMPLE_BUFFERS: 0x80A8;\n    readonly SAMPLES: 0x80A9;\n    readonly SAMPLE_COVERAGE_VALUE: 0x80AA;\n    readonly SAMPLE_COVERAGE_INVERT: 0x80AB;\n    readonly COMPRESSED_TEXTURE_FORMATS: 0x86A3;\n    readonly DONT_CARE: 0x1100;\n    readonly FASTEST: 0x1101;\n    readonly NICEST: 0x1102;\n    readonly GENERATE_MIPMAP_HINT: 0x8192;\n    readonly BYTE: 0x1400;\n    readonly UNSIGNED_BYTE: 0x1401;\n    readonly SHORT: 0x1402;\n    readonly UNSIGNED_SHORT: 0x1403;\n    readonly INT: 0x1404;\n    readonly UNSIGNED_INT: 0x1405;\n    readonly FLOAT: 0x1406;\n    readonly DEPTH_COMPONENT: 0x1902;\n    readonly ALPHA: 0x1906;\n    readonly RGB: 0x1907;\n    readonly RGBA: 0x1908;\n    readonly LUMINANCE: 0x1909;\n    readonly LUMINANCE_ALPHA: 0x190A;\n    readonly UNSIGNED_SHORT_4_4_4_4: 0x8033;\n    readonly UNSIGNED_SHORT_5_5_5_1: 0x8034;\n    readonly UNSIGNED_SHORT_5_6_5: 0x8363;\n    readonly FRAGMENT_SHADER: 0x8B30;\n    readonly VERTEX_SHADER: 0x8B31;\n    readonly MAX_VERTEX_ATTRIBS: 0x8869;\n    readonly MAX_VERTEX_UNIFORM_VECTORS: 0x8DFB;\n    readonly MAX_VARYING_VECTORS: 0x8DFC;\n    readonly MAX_COMBINED_TEXTURE_IMAGE_UNITS: 0x8B4D;\n    readonly MAX_VERTEX_TEXTURE_IMAGE_UNITS: 0x8B4C;\n    readonly MAX_TEXTURE_IMAGE_UNITS: 0x8872;\n    readonly MAX_FRAGMENT_UNIFORM_VECTORS: 0x8DFD;\n    readonly SHADER_TYPE: 0x8B4F;\n    readonly DELETE_STATUS: 0x8B80;\n    readonly LINK_STATUS: 0x8B82;\n    readonly VALIDATE_STATUS: 0x8B83;\n    readonly ATTACHED_SHADERS: 0x8B85;\n    readonly ACTIVE_UNIFORMS: 0x8B86;\n    readonly ACTIVE_ATTRIBUTES: 0x8B89;\n    readonly SHADING_LANGUAGE_VERSION: 0x8B8C;\n    readonly CURRENT_PROGRAM: 0x8B8D;\n    readonly NEVER: 0x0200;\n    readonly LESS: 0x0201;\n    readonly EQUAL: 0x0202;\n    readonly LEQUAL: 0x0203;\n    readonly GREATER: 0x0204;\n    readonly NOTEQUAL: 0x0205;\n    readonly GEQUAL: 0x0206;\n    readonly ALWAYS: 0x0207;\n    readonly KEEP: 0x1E00;\n    readonly REPLACE: 0x1E01;\n    readonly INCR: 0x1E02;\n    readonly DECR: 0x1E03;\n    readonly INVERT: 0x150A;\n    readonly INCR_WRAP: 0x8507;\n    readonly DECR_WRAP: 0x8508;\n    readonly VENDOR: 0x1F00;\n    readonly RENDERER: 0x1F01;\n    readonly VERSION: 0x1F02;\n    readonly NEAREST: 0x2600;\n    readonly LINEAR: 0x2601;\n    readonly NEAREST_MIPMAP_NEAREST: 0x2700;\n    readonly LINEAR_MIPMAP_NEAREST: 0x2701;\n    readonly NEAREST_MIPMAP_LINEAR: 0x2702;\n    readonly LINEAR_MIPMAP_LINEAR: 0x2703;\n    readonly TEXTURE_MAG_FILTER: 0x2800;\n    readonly TEXTURE_MIN_FILTER: 0x2801;\n    readonly TEXTURE_WRAP_S: 0x2802;\n    readonly TEXTURE_WRAP_T: 0x2803;\n    readonly TEXTURE_2D: 0x0DE1;\n    readonly TEXTURE: 0x1702;\n    readonly TEXTURE_CUBE_MAP: 0x8513;\n    readonly TEXTURE_BINDING_CUBE_MAP: 0x8514;\n    readonly TEXTURE_CUBE_MAP_POSITIVE_X: 0x8515;\n    readonly TEXTURE_CUBE_MAP_NEGATIVE_X: 0x8516;\n    readonly TEXTURE_CUBE_MAP_POSITIVE_Y: 0x8517;\n    readonly TEXTURE_CUBE_MAP_NEGATIVE_Y: 0x8518;\n    readonly TEXTURE_CUBE_MAP_POSITIVE_Z: 0x8519;\n    readonly TEXTURE_CUBE_MAP_NEGATIVE_Z: 0x851A;\n    readonly MAX_CUBE_MAP_TEXTURE_SIZE: 0x851C;\n    readonly TEXTURE0: 0x84C0;\n    readonly TEXTURE1: 0x84C1;\n    readonly TEXTURE2: 0x84C2;\n    readonly TEXTURE3: 0x84C3;\n    readonly TEXTURE4: 0x84C4;\n    readonly TEXTURE5: 0x84C5;\n    readonly TEXTURE6: 0x84C6;\n    readonly TEXTURE7: 0x84C7;\n    readonly TEXTURE8: 0x84C8;\n    readonly TEXTURE9: 0x84C9;\n    readonly TEXTURE10: 0x84CA;\n    readonly TEXTURE11: 0x84CB;\n    readonly TEXTURE12: 0x84CC;\n    readonly TEXTURE13: 0x84CD;\n    readonly TEXTURE14: 0x84CE;\n    readonly TEXTURE15: 0x84CF;\n    readonly TEXTURE16: 0x84D0;\n    readonly TEXTURE17: 0x84D1;\n    readonly TEXTURE18: 0x84D2;\n    readonly TEXTURE19: 0x84D3;\n    readonly TEXTURE20: 0x84D4;\n    readonly TEXTURE21: 0x84D5;\n    readonly TEXTURE22: 0x84D6;\n    readonly TEXTURE23: 0x84D7;\n    readonly TEXTURE24: 0x84D8;\n    readonly TEXTURE25: 0x84D9;\n    readonly TEXTURE26: 0x84DA;\n    readonly TEXTURE27: 0x84DB;\n    readonly TEXTURE28: 0x84DC;\n    readonly TEXTURE29: 0x84DD;\n    readonly TEXTURE30: 0x84DE;\n    readonly TEXTURE31: 0x84DF;\n    readonly ACTIVE_TEXTURE: 0x84E0;\n    readonly REPEAT: 0x2901;\n    readonly CLAMP_TO_EDGE: 0x812F;\n    readonly MIRRORED_REPEAT: 0x8370;\n    readonly FLOAT_VEC2: 0x8B50;\n    readonly FLOAT_VEC3: 0x8B51;\n    readonly FLOAT_VEC4: 0x8B52;\n    readonly INT_VEC2: 0x8B53;\n    readonly INT_VEC3: 0x8B54;\n    readonly INT_VEC4: 0x8B55;\n    readonly BOOL: 0x8B56;\n    readonly BOOL_VEC2: 0x8B57;\n    readonly BOOL_VEC3: 0x8B58;\n    readonly BOOL_VEC4: 0x8B59;\n    readonly FLOAT_MAT2: 0x8B5A;\n    readonly FLOAT_MAT3: 0x8B5B;\n    readonly FLOAT_MAT4: 0x8B5C;\n    readonly SAMPLER_2D: 0x8B5E;\n    readonly SAMPLER_CUBE: 0x8B60;\n    readonly VERTEX_ATTRIB_ARRAY_ENABLED: 0x8622;\n    readonly VERTEX_ATTRIB_ARRAY_SIZE: 0x8623;\n    readonly VERTEX_ATTRIB_ARRAY_STRIDE: 0x8624;\n    readonly VERTEX_ATTRIB_ARRAY_TYPE: 0x8625;\n    readonly VERTEX_ATTRIB_ARRAY_NORMALIZED: 0x886A;\n    readonly VERTEX_ATTRIB_ARRAY_POINTER: 0x8645;\n    readonly VERTEX_ATTRIB_ARRAY_BUFFER_BINDING: 0x889F;\n    readonly IMPLEMENTATION_COLOR_READ_TYPE: 0x8B9A;\n    readonly IMPLEMENTATION_COLOR_READ_FORMAT: 0x8B9B;\n    readonly COMPILE_STATUS: 0x8B81;\n    readonly LOW_FLOAT: 0x8DF0;\n    readonly MEDIUM_FLOAT: 0x8DF1;\n    readonly HIGH_FLOAT: 0x8DF2;\n    readonly LOW_INT: 0x8DF3;\n    readonly MEDIUM_INT: 0x8DF4;\n    readonly HIGH_INT: 0x8DF5;\n    readonly FRAMEBUFFER: 0x8D40;\n    readonly RENDERBUFFER: 0x8D41;\n    readonly RGBA4: 0x8056;\n    readonly RGB5_A1: 0x8057;\n    readonly RGB565: 0x8D62;\n    readonly DEPTH_COMPONENT16: 0x81A5;\n    readonly STENCIL_INDEX8: 0x8D48;\n    readonly DEPTH_STENCIL: 0x84F9;\n    readonly RENDERBUFFER_WIDTH: 0x8D42;\n    readonly RENDERBUFFER_HEIGHT: 0x8D43;\n    readonly RENDERBUFFER_INTERNAL_FORMAT: 0x8D44;\n    readonly RENDERBUFFER_RED_SIZE: 0x8D50;\n    readonly RENDERBUFFER_GREEN_SIZE: 0x8D51;\n    readonly RENDERBUFFER_BLUE_SIZE: 0x8D52;\n    readonly RENDERBUFFER_ALPHA_SIZE: 0x8D53;\n    readonly RENDERBUFFER_DEPTH_SIZE: 0x8D54;\n    readonly RENDERBUFFER_STENCIL_SIZE: 0x8D55;\n    readonly FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE: 0x8CD0;\n    readonly FRAMEBUFFER_ATTACHMENT_OBJECT_NAME: 0x8CD1;\n    readonly FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL: 0x8CD2;\n    readonly FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE: 0x8CD3;\n    readonly COLOR_ATTACHMENT0: 0x8CE0;\n    readonly DEPTH_ATTACHMENT: 0x8D00;\n    readonly STENCIL_ATTACHMENT: 0x8D20;\n    readonly DEPTH_STENCIL_ATTACHMENT: 0x821A;\n    readonly NONE: 0;\n    readonly FRAMEBUFFER_COMPLETE: 0x8CD5;\n    readonly FRAMEBUFFER_INCOMPLETE_ATTACHMENT: 0x8CD6;\n    readonly FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT: 0x8CD7;\n    readonly FRAMEBUFFER_INCOMPLETE_DIMENSIONS: 0x8CD9;\n    readonly FRAMEBUFFER_UNSUPPORTED: 0x8CDD;\n    readonly FRAMEBUFFER_BINDING: 0x8CA6;\n    readonly RENDERBUFFER_BINDING: 0x8CA7;\n    readonly MAX_RENDERBUFFER_SIZE: 0x84E8;\n    readonly INVALID_FRAMEBUFFER_OPERATION: 0x0506;\n    readonly UNPACK_FLIP_Y_WEBGL: 0x9240;\n    readonly UNPACK_PREMULTIPLY_ALPHA_WEBGL: 0x9241;\n    readonly CONTEXT_LOST_WEBGL: 0x9242;\n    readonly UNPACK_COLORSPACE_CONVERSION_WEBGL: 0x9243;\n    readonly BROWSER_DEFAULT_WEBGL: 0x9244;\n}\n\ninterface WebGLRenderingContextOverloads {\n    bufferData(target: GLenum, size: GLsizeiptr, usage: GLenum): void;\n    bufferData(target: GLenum, data: BufferSource | null, usage: GLenum): void;\n    bufferSubData(target: GLenum, offset: GLintptr, data: BufferSource): void;\n    compressedTexImage2D(target: GLenum, level: GLint, internalformat: GLenum, width: GLsizei, height: GLsizei, border: GLint, data: ArrayBufferView): void;\n    compressedTexSubImage2D(target: GLenum, level: GLint, xoffset: GLint, yoffset: GLint, width: GLsizei, height: GLsizei, format: GLenum, data: ArrayBufferView): void;\n    readPixels(x: GLint, y: GLint, width: GLsizei, height: GLsizei, format: GLenum, type: GLenum, pixels: ArrayBufferView | null): void;\n    texImage2D(target: GLenum, level: GLint, internalformat: GLint, width: GLsizei, height: GLsizei, border: GLint, format: GLenum, type: GLenum, pixels: ArrayBufferView | null): void;\n    texImage2D(target: GLenum, level: GLint, internalformat: GLint, format: GLenum, type: GLenum, source: TexImageSource): void;\n    texSubImage2D(target: GLenum, level: GLint, xoffset: GLint, yoffset: GLint, width: GLsizei, height: GLsizei, format: GLenum, type: GLenum, pixels: ArrayBufferView | null): void;\n    texSubImage2D(target: GLenum, level: GLint, xoffset: GLint, yoffset: GLint, format: GLenum, type: GLenum, source: TexImageSource): void;\n    uniform1fv(location: WebGLUniformLocation | null, v: Float32List): void;\n    uniform1iv(location: WebGLUniformLocation | null, v: Int32List): void;\n    uniform2fv(location: WebGLUniformLocation | null, v: Float32List): void;\n    uniform2iv(location: WebGLUniformLocation | null, v: Int32List): void;\n    uniform3fv(location: WebGLUniformLocation | null, v: Float32List): void;\n    uniform3iv(location: WebGLUniformLocation | null, v: Int32List): void;\n    uniform4fv(location: WebGLUniformLocation | null, v: Float32List): void;\n    uniform4iv(location: WebGLUniformLocation | null, v: Int32List): void;\n    uniformMatrix2fv(location: WebGLUniformLocation | null, transpose: GLboolean, value: Float32List): void;\n    uniformMatrix3fv(location: WebGLUniformLocation | null, transpose: GLboolean, value: Float32List): void;\n    uniformMatrix4fv(location: WebGLUniformLocation | null, transpose: GLboolean, value: Float32List): void;\n}\n\ninterface WebGLSampler {\n}\n\ndeclare var WebGLSampler: {\n    prototype: WebGLSampler;\n    new(): WebGLSampler;\n};\n\n/** The WebGLShader is part of the WebGL API and can either be a vertex or a fragment shader. A WebGLProgram requires both types of shaders. */\ninterface WebGLShader {\n}\n\ndeclare var WebGLShader: {\n    prototype: WebGLShader;\n    new(): WebGLShader;\n};\n\n/** Part of the WebGL API and represents the information returned by calling the WebGLRenderingContext.getShaderPrecisionFormat() method. */\ninterface WebGLShaderPrecisionFormat {\n    readonly precision: GLint;\n    readonly rangeMax: GLint;\n    readonly rangeMin: GLint;\n}\n\ndeclare var WebGLShaderPrecisionFormat: {\n    prototype: WebGLShaderPrecisionFormat;\n    new(): WebGLShaderPrecisionFormat;\n};\n\ninterface WebGLSync {\n}\n\ndeclare var WebGLSync: {\n    prototype: WebGLSync;\n    new(): WebGLSync;\n};\n\n/** Part of the WebGL API and represents an opaque texture object providing storage and state for texturing operations. */\ninterface WebGLTexture {\n}\n\ndeclare var WebGLTexture: {\n    prototype: WebGLTexture;\n    new(): WebGLTexture;\n};\n\ninterface WebGLTransformFeedback {\n}\n\ndeclare var WebGLTransformFeedback: {\n    prototype: WebGLTransformFeedback;\n    new(): WebGLTransformFeedback;\n};\n\n/** Part of the WebGL API and represents the location of a uniform variable in a shader program. */\ninterface WebGLUniformLocation {\n}\n\ndeclare var WebGLUniformLocation: {\n    prototype: WebGLUniformLocation;\n    new(): WebGLUniformLocation;\n};\n\ninterface WebGLVertexArrayObject {\n}\n\ndeclare var WebGLVertexArrayObject: {\n    prototype: WebGLVertexArrayObject;\n    new(): WebGLVertexArrayObject;\n};\n\ninterface WebGLVertexArrayObjectOES {\n}\n\ninterface WebSocketEventMap {\n    \"close\": CloseEvent;\n    \"error\": Event;\n    \"message\": MessageEvent;\n    \"open\": Event;\n}\n\n/** Provides the API for creating and managing a WebSocket connection to a server, as well as for sending and receiving data on the connection. */\ninterface WebSocket extends EventTarget {\n    /**\n     * Returns a string that indicates how binary data from the WebSocket object is exposed to scripts:\n     *\n     * Can be set, to change how binary data is returned. The default is \"blob\".\n     */\n    binaryType: BinaryType;\n    /**\n     * Returns the number of bytes of application data (UTF-8 text and binary data) that have been queued using send() but not yet been transmitted to the network.\n     *\n     * If the WebSocket connection is closed, this attribute's value will only increase with each call to the send() method. (The number does not reset to zero once the connection closes.)\n     */\n    readonly bufferedAmount: number;\n    /** Returns the extensions selected by the server, if any. */\n    readonly extensions: string;\n    onclose: ((this: WebSocket, ev: CloseEvent) => any) | null;\n    onerror: ((this: WebSocket, ev: Event) => any) | null;\n    onmessage: ((this: WebSocket, ev: MessageEvent) => any) | null;\n    onopen: ((this: WebSocket, ev: Event) => any) | null;\n    /** Returns the subprotocol selected by the server, if any. It can be used in conjunction with the array form of the constructor's second argument to perform subprotocol negotiation. */\n    readonly protocol: string;\n    /** Returns the state of the WebSocket object's connection. It can have the values described below. */\n    readonly readyState: number;\n    /** Returns the URL that was used to establish the WebSocket connection. */\n    readonly url: string;\n    /** Closes the WebSocket connection, optionally using code as the the WebSocket connection close code and reason as the the WebSocket connection close reason. */\n    close(code?: number, reason?: string): void;\n    /** Transmits data using the WebSocket connection. data can be a string, a Blob, an ArrayBuffer, or an ArrayBufferView. */\n    send(data: string | ArrayBufferLike | Blob | ArrayBufferView): void;\n    readonly CONNECTING: 0;\n    readonly OPEN: 1;\n    readonly CLOSING: 2;\n    readonly CLOSED: 3;\n    addEventListener<K extends keyof WebSocketEventMap>(type: K, listener: (this: WebSocket, ev: WebSocketEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof WebSocketEventMap>(type: K, listener: (this: WebSocket, ev: WebSocketEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var WebSocket: {\n    prototype: WebSocket;\n    new(url: string | URL, protocols?: string | string[]): WebSocket;\n    readonly CONNECTING: 0;\n    readonly OPEN: 1;\n    readonly CLOSING: 2;\n    readonly CLOSED: 3;\n};\n\n/** Events that occur due to the user moving a mouse wheel or similar input device. */\ninterface WheelEvent extends MouseEvent {\n    readonly deltaMode: number;\n    readonly deltaX: number;\n    readonly deltaY: number;\n    readonly deltaZ: number;\n    readonly DOM_DELTA_PIXEL: 0x00;\n    readonly DOM_DELTA_LINE: 0x01;\n    readonly DOM_DELTA_PAGE: 0x02;\n}\n\ndeclare var WheelEvent: {\n    prototype: WheelEvent;\n    new(type: string, eventInitDict?: WheelEventInit): WheelEvent;\n    readonly DOM_DELTA_PIXEL: 0x00;\n    readonly DOM_DELTA_LINE: 0x01;\n    readonly DOM_DELTA_PAGE: 0x02;\n};\n\ninterface WindowEventMap extends GlobalEventHandlersEventMap, WindowEventHandlersEventMap {\n    \"DOMContentLoaded\": Event;\n    \"devicemotion\": DeviceMotionEvent;\n    \"deviceorientation\": DeviceOrientationEvent;\n    \"gamepadconnected\": GamepadEvent;\n    \"gamepaddisconnected\": GamepadEvent;\n    \"orientationchange\": Event;\n}\n\n/** A window containing a DOM document; the document property points to the DOM document loaded in that window. */\ninterface Window extends EventTarget, AnimationFrameProvider, GlobalEventHandlers, WindowEventHandlers, WindowLocalStorage, WindowOrWorkerGlobalScope, WindowSessionStorage {\n    /** @deprecated This is a legacy alias of `navigator`. */\n    readonly clientInformation: Navigator;\n    /** Returns true if the window has been closed, false otherwise. */\n    readonly closed: boolean;\n    /** Defines a new custom element, mapping the given name to the given constructor as an autonomous custom element. */\n    readonly customElements: CustomElementRegistry;\n    readonly devicePixelRatio: number;\n    readonly document: Document;\n    /** @deprecated */\n    readonly event: Event | undefined;\n    /** @deprecated */\n    readonly external: External;\n    readonly frameElement: Element | null;\n    readonly frames: WindowProxy;\n    readonly history: History;\n    readonly innerHeight: number;\n    readonly innerWidth: number;\n    readonly length: number;\n    get location(): Location;\n    set location(href: string | Location);\n    /** Returns true if the location bar is visible; otherwise, returns false. */\n    readonly locationbar: BarProp;\n    /** Returns true if the menu bar is visible; otherwise, returns false. */\n    readonly menubar: BarProp;\n    name: string;\n    readonly navigator: Navigator;\n    /** Available only in secure contexts. */\n    ondevicemotion: ((this: Window, ev: DeviceMotionEvent) => any) | null;\n    /** Available only in secure contexts. */\n    ondeviceorientation: ((this: Window, ev: DeviceOrientationEvent) => any) | null;\n    /** @deprecated */\n    onorientationchange: ((this: Window, ev: Event) => any) | null;\n    opener: any;\n    /** @deprecated */\n    readonly orientation: number;\n    readonly outerHeight: number;\n    readonly outerWidth: number;\n    /** @deprecated This is a legacy alias of `scrollX`. */\n    readonly pageXOffset: number;\n    /** @deprecated This is a legacy alias of `scrollY`. */\n    readonly pageYOffset: number;\n    /**\n     * Refers to either the parent WindowProxy, or itself.\n     *\n     * It can rarely be null e.g. for contentWindow of an iframe that is already removed from the parent.\n     */\n    readonly parent: WindowProxy;\n    /** Returns true if the personal bar is visible; otherwise, returns false. */\n    readonly personalbar: BarProp;\n    readonly screen: Screen;\n    readonly screenLeft: number;\n    readonly screenTop: number;\n    readonly screenX: number;\n    readonly screenY: number;\n    readonly scrollX: number;\n    readonly scrollY: number;\n    /** Returns true if the scrollbars are visible; otherwise, returns false. */\n    readonly scrollbars: BarProp;\n    readonly self: Window & typeof globalThis;\n    readonly speechSynthesis: SpeechSynthesis;\n    /** @deprecated */\n    status: string;\n    /** Returns true if the status bar is visible; otherwise, returns false. */\n    readonly statusbar: BarProp;\n    /** Returns true if the toolbar is visible; otherwise, returns false. */\n    readonly toolbar: BarProp;\n    readonly top: WindowProxy | null;\n    readonly visualViewport: VisualViewport | null;\n    readonly window: Window & typeof globalThis;\n    alert(message?: any): void;\n    blur(): void;\n    cancelIdleCallback(handle: number): void;\n    /** @deprecated */\n    captureEvents(): void;\n    /** Closes the window. */\n    close(): void;\n    confirm(message?: string): boolean;\n    /** Moves the focus to the window's browsing context, if any. */\n    focus(): void;\n    getComputedStyle(elt: Element, pseudoElt?: string | null): CSSStyleDeclaration;\n    getSelection(): Selection | null;\n    matchMedia(query: string): MediaQueryList;\n    moveBy(x: number, y: number): void;\n    moveTo(x: number, y: number): void;\n    open(url?: string | URL, target?: string, features?: string): WindowProxy | null;\n    /**\n     * Posts a message to the given window. Messages can be structured objects, e.g. nested objects and arrays, can contain JavaScript values (strings, numbers, Date objects, etc), and can contain certain data objects such as File Blob, FileList, and ArrayBuffer objects.\n     *\n     * Objects listed in the transfer member of options are transferred, not just cloned, meaning that they are no longer usable on the sending side.\n     *\n     * A target origin can be specified using the targetOrigin member of options. If not provided, it defaults to \"/\". This default restricts the message to same-origin targets only.\n     *\n     * If the origin of the target window doesn't match the given target origin, the message is discarded, to avoid information leakage. To send the message to the target regardless of origin, set the target origin to \"*\".\n     *\n     * Throws a \"DataCloneError\" DOMException if transfer array contains duplicate objects or if message could not be cloned.\n     */\n    postMessage(message: any, targetOrigin: string, transfer?: Transferable[]): void;\n    postMessage(message: any, options?: WindowPostMessageOptions): void;\n    print(): void;\n    prompt(message?: string, _default?: string): string | null;\n    /** @deprecated */\n    releaseEvents(): void;\n    requestIdleCallback(callback: IdleRequestCallback, options?: IdleRequestOptions): number;\n    resizeBy(x: number, y: number): void;\n    resizeTo(width: number, height: number): void;\n    scroll(options?: ScrollToOptions): void;\n    scroll(x: number, y: number): void;\n    scrollBy(options?: ScrollToOptions): void;\n    scrollBy(x: number, y: number): void;\n    scrollTo(options?: ScrollToOptions): void;\n    scrollTo(x: number, y: number): void;\n    /** Cancels the document load. */\n    stop(): void;\n    addEventListener<K extends keyof WindowEventMap>(type: K, listener: (this: Window, ev: WindowEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof WindowEventMap>(type: K, listener: (this: Window, ev: WindowEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n    [index: number]: Window;\n}\n\ndeclare var Window: {\n    prototype: Window;\n    new(): Window;\n};\n\ninterface WindowEventHandlersEventMap {\n    \"afterprint\": Event;\n    \"beforeprint\": Event;\n    \"beforeunload\": BeforeUnloadEvent;\n    \"gamepadconnected\": GamepadEvent;\n    \"gamepaddisconnected\": GamepadEvent;\n    \"hashchange\": HashChangeEvent;\n    \"languagechange\": Event;\n    \"message\": MessageEvent;\n    \"messageerror\": MessageEvent;\n    \"offline\": Event;\n    \"online\": Event;\n    \"pagehide\": PageTransitionEvent;\n    \"pageshow\": PageTransitionEvent;\n    \"popstate\": PopStateEvent;\n    \"rejectionhandled\": PromiseRejectionEvent;\n    \"storage\": StorageEvent;\n    \"unhandledrejection\": PromiseRejectionEvent;\n    \"unload\": Event;\n}\n\ninterface WindowEventHandlers {\n    onafterprint: ((this: WindowEventHandlers, ev: Event) => any) | null;\n    onbeforeprint: ((this: WindowEventHandlers, ev: Event) => any) | null;\n    onbeforeunload: ((this: WindowEventHandlers, ev: BeforeUnloadEvent) => any) | null;\n    ongamepadconnected: ((this: WindowEventHandlers, ev: GamepadEvent) => any) | null;\n    ongamepaddisconnected: ((this: WindowEventHandlers, ev: GamepadEvent) => any) | null;\n    onhashchange: ((this: WindowEventHandlers, ev: HashChangeEvent) => any) | null;\n    onlanguagechange: ((this: WindowEventHandlers, ev: Event) => any) | null;\n    onmessage: ((this: WindowEventHandlers, ev: MessageEvent) => any) | null;\n    onmessageerror: ((this: WindowEventHandlers, ev: MessageEvent) => any) | null;\n    onoffline: ((this: WindowEventHandlers, ev: Event) => any) | null;\n    ononline: ((this: WindowEventHandlers, ev: Event) => any) | null;\n    onpagehide: ((this: WindowEventHandlers, ev: PageTransitionEvent) => any) | null;\n    onpageshow: ((this: WindowEventHandlers, ev: PageTransitionEvent) => any) | null;\n    onpopstate: ((this: WindowEventHandlers, ev: PopStateEvent) => any) | null;\n    onrejectionhandled: ((this: WindowEventHandlers, ev: PromiseRejectionEvent) => any) | null;\n    onstorage: ((this: WindowEventHandlers, ev: StorageEvent) => any) | null;\n    onunhandledrejection: ((this: WindowEventHandlers, ev: PromiseRejectionEvent) => any) | null;\n    onunload: ((this: WindowEventHandlers, ev: Event) => any) | null;\n    addEventListener<K extends keyof WindowEventHandlersEventMap>(type: K, listener: (this: WindowEventHandlers, ev: WindowEventHandlersEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof WindowEventHandlersEventMap>(type: K, listener: (this: WindowEventHandlers, ev: WindowEventHandlersEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ninterface WindowLocalStorage {\n    readonly localStorage: Storage;\n}\n\ninterface WindowOrWorkerGlobalScope {\n    /** Available only in secure contexts. */\n    readonly caches: CacheStorage;\n    readonly crossOriginIsolated: boolean;\n    readonly crypto: Crypto;\n    readonly indexedDB: IDBFactory;\n    readonly isSecureContext: boolean;\n    readonly origin: string;\n    readonly performance: Performance;\n    atob(data: string): string;\n    btoa(data: string): string;\n    clearInterval(id: number | undefined): void;\n    clearTimeout(id: number | undefined): void;\n    createImageBitmap(image: ImageBitmapSource, options?: ImageBitmapOptions): Promise<ImageBitmap>;\n    createImageBitmap(image: ImageBitmapSource, sx: number, sy: number, sw: number, sh: number, options?: ImageBitmapOptions): Promise<ImageBitmap>;\n    fetch(input: RequestInfo | URL, init?: RequestInit): Promise<Response>;\n    queueMicrotask(callback: VoidFunction): void;\n    reportError(e: any): void;\n    setInterval(handler: TimerHandler, timeout?: number, ...arguments: any[]): number;\n    setTimeout(handler: TimerHandler, timeout?: number, ...arguments: any[]): number;\n    structuredClone(value: any, options?: StructuredSerializeOptions): any;\n}\n\ninterface WindowSessionStorage {\n    readonly sessionStorage: Storage;\n}\n\ninterface WorkerEventMap extends AbstractWorkerEventMap {\n    \"message\": MessageEvent;\n    \"messageerror\": MessageEvent;\n}\n\n/** This Web Workers API interface represents a background task that can be easily created and can send messages back to its creator. Creating a worker is as simple as calling the Worker() constructor and specifying a script to be run in the worker thread. */\ninterface Worker extends EventTarget, AbstractWorker {\n    onmessage: ((this: Worker, ev: MessageEvent) => any) | null;\n    onmessageerror: ((this: Worker, ev: MessageEvent) => any) | null;\n    /** Clones message and transmits it to worker's global environment. transfer can be passed as a list of objects that are to be transferred rather than cloned. */\n    postMessage(message: any, transfer: Transferable[]): void;\n    postMessage(message: any, options?: StructuredSerializeOptions): void;\n    /** Aborts worker's associated global environment. */\n    terminate(): void;\n    addEventListener<K extends keyof WorkerEventMap>(type: K, listener: (this: Worker, ev: WorkerEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof WorkerEventMap>(type: K, listener: (this: Worker, ev: WorkerEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var Worker: {\n    prototype: Worker;\n    new(scriptURL: string | URL, options?: WorkerOptions): Worker;\n};\n\n/** Available only in secure contexts. */\ninterface Worklet {\n    /**\n     * Loads and executes the module script given by moduleURL into all of worklet's global scopes. It can also create additional global scopes as part of this process, depending on the worklet type. The returned promise will fulfill once the script has been successfully loaded and run in all global scopes.\n     *\n     * The credentials option can be set to a credentials mode to modify the script-fetching process. It defaults to \"same-origin\".\n     *\n     * Any failures in fetching the script or its dependencies will cause the returned promise to be rejected with an \"AbortError\" DOMException. Any errors in parsing the script or its dependencies will cause the returned promise to be rejected with the exception generated during parsing.\n     */\n    addModule(moduleURL: string | URL, options?: WorkletOptions): Promise<void>;\n}\n\ndeclare var Worklet: {\n    prototype: Worklet;\n    new(): Worklet;\n};\n\n/** This Streams API interface provides a standard abstraction for writing streaming data to a destination, known as a sink. This object comes with built-in backpressure and queuing. */\ninterface WritableStream<W = any> {\n    readonly locked: boolean;\n    abort(reason?: any): Promise<void>;\n    close(): Promise<void>;\n    getWriter(): WritableStreamDefaultWriter<W>;\n}\n\ndeclare var WritableStream: {\n    prototype: WritableStream;\n    new<W = any>(underlyingSink?: UnderlyingSink<W>, strategy?: QueuingStrategy<W>): WritableStream<W>;\n};\n\n/** This Streams API interface represents a controller allowing control of a WritableStream's state. When constructing a WritableStream, the underlying sink is given a corresponding WritableStreamDefaultController instance to manipulate. */\ninterface WritableStreamDefaultController {\n    readonly signal: AbortSignal;\n    error(e?: any): void;\n}\n\ndeclare var WritableStreamDefaultController: {\n    prototype: WritableStreamDefaultController;\n    new(): WritableStreamDefaultController;\n};\n\n/** This Streams API interface is the object returned by WritableStream.getWriter() and once created locks the < writer to the WritableStream ensuring that no other streams can write to the underlying sink. */\ninterface WritableStreamDefaultWriter<W = any> {\n    readonly closed: Promise<undefined>;\n    readonly desiredSize: number | null;\n    readonly ready: Promise<undefined>;\n    abort(reason?: any): Promise<void>;\n    close(): Promise<void>;\n    releaseLock(): void;\n    write(chunk?: W): Promise<void>;\n}\n\ndeclare var WritableStreamDefaultWriter: {\n    prototype: WritableStreamDefaultWriter;\n    new<W = any>(stream: WritableStream<W>): WritableStreamDefaultWriter<W>;\n};\n\n/** An XML document. It inherits from the generic Document and does not add any specific methods or properties to it: nevertheless, several algorithms behave differently with the two types of documents. */\ninterface XMLDocument extends Document {\n    addEventListener<K extends keyof DocumentEventMap>(type: K, listener: (this: XMLDocument, ev: DocumentEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof DocumentEventMap>(type: K, listener: (this: XMLDocument, ev: DocumentEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var XMLDocument: {\n    prototype: XMLDocument;\n    new(): XMLDocument;\n};\n\ninterface XMLHttpRequestEventMap extends XMLHttpRequestEventTargetEventMap {\n    \"readystatechange\": Event;\n}\n\n/** Use XMLHttpRequest (XHR) objects to interact with servers. You can retrieve data from a URL without having to do a full page refresh. This enables a Web page to update just part of a page without disrupting what the user is doing. */\ninterface XMLHttpRequest extends XMLHttpRequestEventTarget {\n    onreadystatechange: ((this: XMLHttpRequest, ev: Event) => any) | null;\n    /** Returns client's state. */\n    readonly readyState: number;\n    /** Returns the response body. */\n    readonly response: any;\n    /**\n     * Returns response as text.\n     *\n     * Throws an \"InvalidStateError\" DOMException if responseType is not the empty string or \"text\".\n     */\n    readonly responseText: string;\n    /**\n     * Returns the response type.\n     *\n     * Can be set to change the response type. Values are: the empty string (default), \"arraybuffer\", \"blob\", \"document\", \"json\", and \"text\".\n     *\n     * When set: setting to \"document\" is ignored if current global object is not a Window object.\n     *\n     * When set: throws an \"InvalidStateError\" DOMException if state is loading or done.\n     *\n     * When set: throws an \"InvalidAccessError\" DOMException if the synchronous flag is set and current global object is a Window object.\n     */\n    responseType: XMLHttpRequestResponseType;\n    readonly responseURL: string;\n    /**\n     * Returns the response as document.\n     *\n     * Throws an \"InvalidStateError\" DOMException if responseType is not the empty string or \"document\".\n     */\n    readonly responseXML: Document | null;\n    readonly status: number;\n    readonly statusText: string;\n    /**\n     * Can be set to a time in milliseconds. When set to a non-zero value will cause fetching to terminate after the given time has passed. When the time has passed, the request has not yet completed, and this's synchronous flag is unset, a timeout event will then be dispatched, or a \"TimeoutError\" DOMException will be thrown otherwise (for the send() method).\n     *\n     * When set: throws an \"InvalidAccessError\" DOMException if the synchronous flag is set and current global object is a Window object.\n     */\n    timeout: number;\n    /** Returns the associated XMLHttpRequestUpload object. It can be used to gather transmission information when data is transferred to a server. */\n    readonly upload: XMLHttpRequestUpload;\n    /**\n     * True when credentials are to be included in a cross-origin request. False when they are to be excluded in a cross-origin request and when cookies are to be ignored in its response. Initially false.\n     *\n     * When set: throws an \"InvalidStateError\" DOMException if state is not unsent or opened, or if the send() flag is set.\n     */\n    withCredentials: boolean;\n    /** Cancels any network activity. */\n    abort(): void;\n    getAllResponseHeaders(): string;\n    getResponseHeader(name: string): string | null;\n    /**\n     * Sets the request method, request URL, and synchronous flag.\n     *\n     * Throws a \"SyntaxError\" DOMException if either method is not a valid method or url cannot be parsed.\n     *\n     * Throws a \"SecurityError\" DOMException if method is a case-insensitive match for `CONNECT`, `TRACE`, or `TRACK`.\n     *\n     * Throws an \"InvalidAccessError\" DOMException if async is false, current global object is a Window object, and the timeout attribute is not zero or the responseType attribute is not the empty string.\n     */\n    open(method: string, url: string | URL): void;\n    open(method: string, url: string | URL, async: boolean, username?: string | null, password?: string | null): void;\n    /**\n     * Acts as if the `Content-Type` header value for a response is mime. (It does not change the header.)\n     *\n     * Throws an \"InvalidStateError\" DOMException if state is loading or done.\n     */\n    overrideMimeType(mime: string): void;\n    /**\n     * Initiates the request. The body argument provides the request body, if any, and is ignored if the request method is GET or HEAD.\n     *\n     * Throws an \"InvalidStateError\" DOMException if either state is not opened or the send() flag is set.\n     */\n    send(body?: Document | XMLHttpRequestBodyInit | null): void;\n    /**\n     * Combines a header in author request headers.\n     *\n     * Throws an \"InvalidStateError\" DOMException if either state is not opened or the send() flag is set.\n     *\n     * Throws a \"SyntaxError\" DOMException if name is not a header name or if value is not a header value.\n     */\n    setRequestHeader(name: string, value: string): void;\n    readonly UNSENT: 0;\n    readonly OPENED: 1;\n    readonly HEADERS_RECEIVED: 2;\n    readonly LOADING: 3;\n    readonly DONE: 4;\n    addEventListener<K extends keyof XMLHttpRequestEventMap>(type: K, listener: (this: XMLHttpRequest, ev: XMLHttpRequestEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof XMLHttpRequestEventMap>(type: K, listener: (this: XMLHttpRequest, ev: XMLHttpRequestEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var XMLHttpRequest: {\n    prototype: XMLHttpRequest;\n    new(): XMLHttpRequest;\n    readonly UNSENT: 0;\n    readonly OPENED: 1;\n    readonly HEADERS_RECEIVED: 2;\n    readonly LOADING: 3;\n    readonly DONE: 4;\n};\n\ninterface XMLHttpRequestEventTargetEventMap {\n    \"abort\": ProgressEvent<XMLHttpRequestEventTarget>;\n    \"error\": ProgressEvent<XMLHttpRequestEventTarget>;\n    \"load\": ProgressEvent<XMLHttpRequestEventTarget>;\n    \"loadend\": ProgressEvent<XMLHttpRequestEventTarget>;\n    \"loadstart\": ProgressEvent<XMLHttpRequestEventTarget>;\n    \"progress\": ProgressEvent<XMLHttpRequestEventTarget>;\n    \"timeout\": ProgressEvent<XMLHttpRequestEventTarget>;\n}\n\ninterface XMLHttpRequestEventTarget extends EventTarget {\n    onabort: ((this: XMLHttpRequest, ev: ProgressEvent) => any) | null;\n    onerror: ((this: XMLHttpRequest, ev: ProgressEvent) => any) | null;\n    onload: ((this: XMLHttpRequest, ev: ProgressEvent) => any) | null;\n    onloadend: ((this: XMLHttpRequest, ev: ProgressEvent) => any) | null;\n    onloadstart: ((this: XMLHttpRequest, ev: ProgressEvent) => any) | null;\n    onprogress: ((this: XMLHttpRequest, ev: ProgressEvent) => any) | null;\n    ontimeout: ((this: XMLHttpRequest, ev: ProgressEvent) => any) | null;\n    addEventListener<K extends keyof XMLHttpRequestEventTargetEventMap>(type: K, listener: (this: XMLHttpRequestEventTarget, ev: XMLHttpRequestEventTargetEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof XMLHttpRequestEventTargetEventMap>(type: K, listener: (this: XMLHttpRequestEventTarget, ev: XMLHttpRequestEventTargetEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var XMLHttpRequestEventTarget: {\n    prototype: XMLHttpRequestEventTarget;\n    new(): XMLHttpRequestEventTarget;\n};\n\ninterface XMLHttpRequestUpload extends XMLHttpRequestEventTarget {\n    addEventListener<K extends keyof XMLHttpRequestEventTargetEventMap>(type: K, listener: (this: XMLHttpRequestUpload, ev: XMLHttpRequestEventTargetEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof XMLHttpRequestEventTargetEventMap>(type: K, listener: (this: XMLHttpRequestUpload, ev: XMLHttpRequestEventTargetEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var XMLHttpRequestUpload: {\n    prototype: XMLHttpRequestUpload;\n    new(): XMLHttpRequestUpload;\n};\n\n/** Provides the serializeToString() method to construct an XML string representing a DOM tree. */\ninterface XMLSerializer {\n    serializeToString(root: Node): string;\n}\n\ndeclare var XMLSerializer: {\n    prototype: XMLSerializer;\n    new(): XMLSerializer;\n};\n\n/** The XPathEvaluator interface allows to compile and evaluate XPath expressions. */\ninterface XPathEvaluator extends XPathEvaluatorBase {\n}\n\ndeclare var XPathEvaluator: {\n    prototype: XPathEvaluator;\n    new(): XPathEvaluator;\n};\n\ninterface XPathEvaluatorBase {\n    createExpression(expression: string, resolver?: XPathNSResolver | null): XPathExpression;\n    createNSResolver(nodeResolver: Node): XPathNSResolver;\n    evaluate(expression: string, contextNode: Node, resolver?: XPathNSResolver | null, type?: number, result?: XPathResult | null): XPathResult;\n}\n\n/** This interface is a compiled XPath expression that can be evaluated on a document or specific node to return information its DOM tree. */\ninterface XPathExpression {\n    evaluate(contextNode: Node, type?: number, result?: XPathResult | null): XPathResult;\n}\n\ndeclare var XPathExpression: {\n    prototype: XPathExpression;\n    new(): XPathExpression;\n};\n\n/** The results generated by evaluating an XPath expression within the context of a given node. */\ninterface XPathResult {\n    readonly booleanValue: boolean;\n    readonly invalidIteratorState: boolean;\n    readonly numberValue: number;\n    readonly resultType: number;\n    readonly singleNodeValue: Node | null;\n    readonly snapshotLength: number;\n    readonly stringValue: string;\n    iterateNext(): Node | null;\n    snapshotItem(index: number): Node | null;\n    readonly ANY_TYPE: 0;\n    readonly NUMBER_TYPE: 1;\n    readonly STRING_TYPE: 2;\n    readonly BOOLEAN_TYPE: 3;\n    readonly UNORDERED_NODE_ITERATOR_TYPE: 4;\n    readonly ORDERED_NODE_ITERATOR_TYPE: 5;\n    readonly UNORDERED_NODE_SNAPSHOT_TYPE: 6;\n    readonly ORDERED_NODE_SNAPSHOT_TYPE: 7;\n    readonly ANY_UNORDERED_NODE_TYPE: 8;\n    readonly FIRST_ORDERED_NODE_TYPE: 9;\n}\n\ndeclare var XPathResult: {\n    prototype: XPathResult;\n    new(): XPathResult;\n    readonly ANY_TYPE: 0;\n    readonly NUMBER_TYPE: 1;\n    readonly STRING_TYPE: 2;\n    readonly BOOLEAN_TYPE: 3;\n    readonly UNORDERED_NODE_ITERATOR_TYPE: 4;\n    readonly ORDERED_NODE_ITERATOR_TYPE: 5;\n    readonly UNORDERED_NODE_SNAPSHOT_TYPE: 6;\n    readonly ORDERED_NODE_SNAPSHOT_TYPE: 7;\n    readonly ANY_UNORDERED_NODE_TYPE: 8;\n    readonly FIRST_ORDERED_NODE_TYPE: 9;\n};\n\n/** An XSLTProcessor applies an XSLT stylesheet transformation to an XML document to produce a new XML document as output. It has methods to load the XSLT stylesheet, to manipulate <xsl:param> parameter values, and to apply the transformation to documents. */\ninterface XSLTProcessor {\n    clearParameters(): void;\n    getParameter(namespaceURI: string | null, localName: string): any;\n    importStylesheet(style: Node): void;\n    removeParameter(namespaceURI: string | null, localName: string): void;\n    reset(): void;\n    setParameter(namespaceURI: string | null, localName: string, value: any): void;\n    transformToDocument(source: Node): Document;\n    transformToFragment(source: Node, output: Document): DocumentFragment;\n}\n\ndeclare var XSLTProcessor: {\n    prototype: XSLTProcessor;\n    new(): XSLTProcessor;\n};\n\ninterface Console {\n    assert(condition?: boolean, ...data: any[]): void;\n    clear(): void;\n    count(label?: string): void;\n    countReset(label?: string): void;\n    debug(...data: any[]): void;\n    dir(item?: any, options?: any): void;\n    dirxml(...data: any[]): void;\n    error(...data: any[]): void;\n    group(...data: any[]): void;\n    groupCollapsed(...data: any[]): void;\n    groupEnd(): void;\n    info(...data: any[]): void;\n    log(...data: any[]): void;\n    table(tabularData?: any, properties?: string[]): void;\n    time(label?: string): void;\n    timeEnd(label?: string): void;\n    timeLog(label?: string, ...data: any[]): void;\n    timeStamp(label?: string): void;\n    trace(...data: any[]): void;\n    warn(...data: any[]): void;\n}\n\ndeclare var console: Console;\n\n/** Holds useful CSS-related methods. No object with this interface are implemented: it contains only static methods and therefore is a utilitarian interface. */\ndeclare namespace CSS {\n    function escape(ident: string): string;\n    function supports(property: string, value: string): boolean;\n    function supports(conditionText: string): boolean;\n}\n\ndeclare namespace WebAssembly {\n    interface CompileError extends Error {\n    }\n\n    var CompileError: {\n        prototype: CompileError;\n        new(message?: string): CompileError;\n        (message?: string): CompileError;\n    };\n\n    interface Global {\n        value: any;\n        valueOf(): any;\n    }\n\n    var Global: {\n        prototype: Global;\n        new(descriptor: GlobalDescriptor, v?: any): Global;\n    };\n\n    interface Instance {\n        readonly exports: Exports;\n    }\n\n    var Instance: {\n        prototype: Instance;\n        new(module: Module, importObject?: Imports): Instance;\n    };\n\n    interface LinkError extends Error {\n    }\n\n    var LinkError: {\n        prototype: LinkError;\n        new(message?: string): LinkError;\n        (message?: string): LinkError;\n    };\n\n    interface Memory {\n        readonly buffer: ArrayBuffer;\n        grow(delta: number): number;\n    }\n\n    var Memory: {\n        prototype: Memory;\n        new(descriptor: MemoryDescriptor): Memory;\n    };\n\n    interface Module {\n    }\n\n    var Module: {\n        prototype: Module;\n        new(bytes: BufferSource): Module;\n        customSections(moduleObject: Module, sectionName: string): ArrayBuffer[];\n        exports(moduleObject: Module): ModuleExportDescriptor[];\n        imports(moduleObject: Module): ModuleImportDescriptor[];\n    };\n\n    interface RuntimeError extends Error {\n    }\n\n    var RuntimeError: {\n        prototype: RuntimeError;\n        new(message?: string): RuntimeError;\n        (message?: string): RuntimeError;\n    };\n\n    interface Table {\n        readonly length: number;\n        get(index: number): any;\n        grow(delta: number, value?: any): number;\n        set(index: number, value?: any): void;\n    }\n\n    var Table: {\n        prototype: Table;\n        new(descriptor: TableDescriptor, value?: any): Table;\n    };\n\n    interface GlobalDescriptor {\n        mutable?: boolean;\n        value: ValueType;\n    }\n\n    interface MemoryDescriptor {\n        initial: number;\n        maximum?: number;\n        shared?: boolean;\n    }\n\n    interface ModuleExportDescriptor {\n        kind: ImportExportKind;\n        name: string;\n    }\n\n    interface ModuleImportDescriptor {\n        kind: ImportExportKind;\n        module: string;\n        name: string;\n    }\n\n    interface TableDescriptor {\n        element: TableKind;\n        initial: number;\n        maximum?: number;\n    }\n\n    interface WebAssemblyInstantiatedSource {\n        instance: Instance;\n        module: Module;\n    }\n\n    type ImportExportKind = \"function\" | \"global\" | \"memory\" | \"table\";\n    type TableKind = \"anyfunc\" | \"externref\";\n    type ValueType = \"anyfunc\" | \"externref\" | \"f32\" | \"f64\" | \"i32\" | \"i64\" | \"v128\";\n    type ExportValue = Function | Global | Memory | Table;\n    type Exports = Record<string, ExportValue>;\n    type ImportValue = ExportValue | number;\n    type Imports = Record<string, ModuleImports>;\n    type ModuleImports = Record<string, ImportValue>;\n    function compile(bytes: BufferSource): Promise<Module>;\n    function compileStreaming(source: Response | PromiseLike<Response>): Promise<Module>;\n    function instantiate(bytes: BufferSource, importObject?: Imports): Promise<WebAssemblyInstantiatedSource>;\n    function instantiate(moduleObject: Module, importObject?: Imports): Promise<Instance>;\n    function instantiateStreaming(source: Response | PromiseLike<Response>, importObject?: Imports): Promise<WebAssemblyInstantiatedSource>;\n    function validate(bytes: BufferSource): boolean;\n}\n\ninterface BlobCallback {\n    (blob: Blob | null): void;\n}\n\ninterface CustomElementConstructor {\n    new (...params: any[]): HTMLElement;\n}\n\ninterface DecodeErrorCallback {\n    (error: DOMException): void;\n}\n\ninterface DecodeSuccessCallback {\n    (decodedData: AudioBuffer): void;\n}\n\ninterface ErrorCallback {\n    (err: DOMException): void;\n}\n\ninterface FileCallback {\n    (file: File): void;\n}\n\ninterface FileSystemEntriesCallback {\n    (entries: FileSystemEntry[]): void;\n}\n\ninterface FileSystemEntryCallback {\n    (entry: FileSystemEntry): void;\n}\n\ninterface FrameRequestCallback {\n    (time: DOMHighResTimeStamp): void;\n}\n\ninterface FunctionStringCallback {\n    (data: string): void;\n}\n\ninterface IdleRequestCallback {\n    (deadline: IdleDeadline): void;\n}\n\ninterface IntersectionObserverCallback {\n    (entries: IntersectionObserverEntry[], observer: IntersectionObserver): void;\n}\n\ninterface LockGrantedCallback {\n    (lock: Lock | null): any;\n}\n\ninterface MediaSessionActionHandler {\n    (details: MediaSessionActionDetails): void;\n}\n\ninterface MutationCallback {\n    (mutations: MutationRecord[], observer: MutationObserver): void;\n}\n\ninterface NotificationPermissionCallback {\n    (permission: NotificationPermission): void;\n}\n\ninterface OnBeforeUnloadEventHandlerNonNull {\n    (event: Event): string | null;\n}\n\ninterface OnErrorEventHandlerNonNull {\n    (event: Event | string, source?: string, lineno?: number, colno?: number, error?: Error): any;\n}\n\ninterface PerformanceObserverCallback {\n    (entries: PerformanceObserverEntryList, observer: PerformanceObserver): void;\n}\n\ninterface PositionCallback {\n    (position: GeolocationPosition): void;\n}\n\ninterface PositionErrorCallback {\n    (positionError: GeolocationPositionError): void;\n}\n\ninterface QueuingStrategySize<T = any> {\n    (chunk: T): number;\n}\n\ninterface RTCPeerConnectionErrorCallback {\n    (error: DOMException): void;\n}\n\ninterface RTCSessionDescriptionCallback {\n    (description: RTCSessionDescriptionInit): void;\n}\n\ninterface RemotePlaybackAvailabilityCallback {\n    (available: boolean): void;\n}\n\ninterface ResizeObserverCallback {\n    (entries: ResizeObserverEntry[], observer: ResizeObserver): void;\n}\n\ninterface TransformerFlushCallback<O> {\n    (controller: TransformStreamDefaultController<O>): void | PromiseLike<void>;\n}\n\ninterface TransformerStartCallback<O> {\n    (controller: TransformStreamDefaultController<O>): any;\n}\n\ninterface TransformerTransformCallback<I, O> {\n    (chunk: I, controller: TransformStreamDefaultController<O>): void | PromiseLike<void>;\n}\n\ninterface UnderlyingSinkAbortCallback {\n    (reason?: any): void | PromiseLike<void>;\n}\n\ninterface UnderlyingSinkCloseCallback {\n    (): void | PromiseLike<void>;\n}\n\ninterface UnderlyingSinkStartCallback {\n    (controller: WritableStreamDefaultController): any;\n}\n\ninterface UnderlyingSinkWriteCallback<W> {\n    (chunk: W, controller: WritableStreamDefaultController): void | PromiseLike<void>;\n}\n\ninterface UnderlyingSourceCancelCallback {\n    (reason?: any): void | PromiseLike<void>;\n}\n\ninterface UnderlyingSourcePullCallback<R> {\n    (controller: ReadableStreamController<R>): void | PromiseLike<void>;\n}\n\ninterface UnderlyingSourceStartCallback<R> {\n    (controller: ReadableStreamController<R>): any;\n}\n\ninterface VideoFrameRequestCallback {\n    (now: DOMHighResTimeStamp, metadata: VideoFrameCallbackMetadata): void;\n}\n\ninterface VoidFunction {\n    (): void;\n}\n\ninterface HTMLElementTagNameMap {\n    \"a\": HTMLAnchorElement;\n    \"abbr\": HTMLElement;\n    \"address\": HTMLElement;\n    \"area\": HTMLAreaElement;\n    \"article\": HTMLElement;\n    \"aside\": HTMLElement;\n    \"audio\": HTMLAudioElement;\n    \"b\": HTMLElement;\n    \"base\": HTMLBaseElement;\n    \"bdi\": HTMLElement;\n    \"bdo\": HTMLElement;\n    \"blockquote\": HTMLQuoteElement;\n    \"body\": HTMLBodyElement;\n    \"br\": HTMLBRElement;\n    \"button\": HTMLButtonElement;\n    \"canvas\": HTMLCanvasElement;\n    \"caption\": HTMLTableCaptionElement;\n    \"cite\": HTMLElement;\n    \"code\": HTMLElement;\n    \"col\": HTMLTableColElement;\n    \"colgroup\": HTMLTableColElement;\n    \"data\": HTMLDataElement;\n    \"datalist\": HTMLDataListElement;\n    \"dd\": HTMLElement;\n    \"del\": HTMLModElement;\n    \"details\": HTMLDetailsElement;\n    \"dfn\": HTMLElement;\n    \"dialog\": HTMLDialogElement;\n    \"div\": HTMLDivElement;\n    \"dl\": HTMLDListElement;\n    \"dt\": HTMLElement;\n    \"em\": HTMLElement;\n    \"embed\": HTMLEmbedElement;\n    \"fieldset\": HTMLFieldSetElement;\n    \"figcaption\": HTMLElement;\n    \"figure\": HTMLElement;\n    \"footer\": HTMLElement;\n    \"form\": HTMLFormElement;\n    \"h1\": HTMLHeadingElement;\n    \"h2\": HTMLHeadingElement;\n    \"h3\": HTMLHeadingElement;\n    \"h4\": HTMLHeadingElement;\n    \"h5\": HTMLHeadingElement;\n    \"h6\": HTMLHeadingElement;\n    \"head\": HTMLHeadElement;\n    \"header\": HTMLElement;\n    \"hgroup\": HTMLElement;\n    \"hr\": HTMLHRElement;\n    \"html\": HTMLHtmlElement;\n    \"i\": HTMLElement;\n    \"iframe\": HTMLIFrameElement;\n    \"img\": HTMLImageElement;\n    \"input\": HTMLInputElement;\n    \"ins\": HTMLModElement;\n    \"kbd\": HTMLElement;\n    \"label\": HTMLLabelElement;\n    \"legend\": HTMLLegendElement;\n    \"li\": HTMLLIElement;\n    \"link\": HTMLLinkElement;\n    \"main\": HTMLElement;\n    \"map\": HTMLMapElement;\n    \"mark\": HTMLElement;\n    \"menu\": HTMLMenuElement;\n    \"meta\": HTMLMetaElement;\n    \"meter\": HTMLMeterElement;\n    \"nav\": HTMLElement;\n    \"noscript\": HTMLElement;\n    \"object\": HTMLObjectElement;\n    \"ol\": HTMLOListElement;\n    \"optgroup\": HTMLOptGroupElement;\n    \"option\": HTMLOptionElement;\n    \"output\": HTMLOutputElement;\n    \"p\": HTMLParagraphElement;\n    \"picture\": HTMLPictureElement;\n    \"pre\": HTMLPreElement;\n    \"progress\": HTMLProgressElement;\n    \"q\": HTMLQuoteElement;\n    \"rp\": HTMLElement;\n    \"rt\": HTMLElement;\n    \"ruby\": HTMLElement;\n    \"s\": HTMLElement;\n    \"samp\": HTMLElement;\n    \"script\": HTMLScriptElement;\n    \"section\": HTMLElement;\n    \"select\": HTMLSelectElement;\n    \"slot\": HTMLSlotElement;\n    \"small\": HTMLElement;\n    \"source\": HTMLSourceElement;\n    \"span\": HTMLSpanElement;\n    \"strong\": HTMLElement;\n    \"style\": HTMLStyleElement;\n    \"sub\": HTMLElement;\n    \"summary\": HTMLElement;\n    \"sup\": HTMLElement;\n    \"table\": HTMLTableElement;\n    \"tbody\": HTMLTableSectionElement;\n    \"td\": HTMLTableCellElement;\n    \"template\": HTMLTemplateElement;\n    \"textarea\": HTMLTextAreaElement;\n    \"tfoot\": HTMLTableSectionElement;\n    \"th\": HTMLTableCellElement;\n    \"thead\": HTMLTableSectionElement;\n    \"time\": HTMLTimeElement;\n    \"title\": HTMLTitleElement;\n    \"tr\": HTMLTableRowElement;\n    \"track\": HTMLTrackElement;\n    \"u\": HTMLElement;\n    \"ul\": HTMLUListElement;\n    \"var\": HTMLElement;\n    \"video\": HTMLVideoElement;\n    \"wbr\": HTMLElement;\n}\n\ninterface HTMLElementDeprecatedTagNameMap {\n    \"acronym\": HTMLElement;\n    \"applet\": HTMLUnknownElement;\n    \"basefont\": HTMLElement;\n    \"bgsound\": HTMLUnknownElement;\n    \"big\": HTMLElement;\n    \"blink\": HTMLUnknownElement;\n    \"center\": HTMLElement;\n    \"dir\": HTMLDirectoryElement;\n    \"font\": HTMLFontElement;\n    \"frame\": HTMLFrameElement;\n    \"frameset\": HTMLFrameSetElement;\n    \"isindex\": HTMLUnknownElement;\n    \"keygen\": HTMLUnknownElement;\n    \"listing\": HTMLPreElement;\n    \"marquee\": HTMLMarqueeElement;\n    \"menuitem\": HTMLElement;\n    \"multicol\": HTMLUnknownElement;\n    \"nextid\": HTMLUnknownElement;\n    \"nobr\": HTMLElement;\n    \"noembed\": HTMLElement;\n    \"noframes\": HTMLElement;\n    \"param\": HTMLParamElement;\n    \"plaintext\": HTMLElement;\n    \"rb\": HTMLElement;\n    \"rtc\": HTMLElement;\n    \"spacer\": HTMLUnknownElement;\n    \"strike\": HTMLElement;\n    \"tt\": HTMLElement;\n    \"xmp\": HTMLPreElement;\n}\n\ninterface SVGElementTagNameMap {\n    \"a\": SVGAElement;\n    \"animate\": SVGAnimateElement;\n    \"animateMotion\": SVGAnimateMotionElement;\n    \"animateTransform\": SVGAnimateTransformElement;\n    \"circle\": SVGCircleElement;\n    \"clipPath\": SVGClipPathElement;\n    \"defs\": SVGDefsElement;\n    \"desc\": SVGDescElement;\n    \"ellipse\": SVGEllipseElement;\n    \"feBlend\": SVGFEBlendElement;\n    \"feColorMatrix\": SVGFEColorMatrixElement;\n    \"feComponentTransfer\": SVGFEComponentTransferElement;\n    \"feComposite\": SVGFECompositeElement;\n    \"feConvolveMatrix\": SVGFEConvolveMatrixElement;\n    \"feDiffuseLighting\": SVGFEDiffuseLightingElement;\n    \"feDisplacementMap\": SVGFEDisplacementMapElement;\n    \"feDistantLight\": SVGFEDistantLightElement;\n    \"feDropShadow\": SVGFEDropShadowElement;\n    \"feFlood\": SVGFEFloodElement;\n    \"feFuncA\": SVGFEFuncAElement;\n    \"feFuncB\": SVGFEFuncBElement;\n    \"feFuncG\": SVGFEFuncGElement;\n    \"feFuncR\": SVGFEFuncRElement;\n    \"feGaussianBlur\": SVGFEGaussianBlurElement;\n    \"feImage\": SVGFEImageElement;\n    \"feMerge\": SVGFEMergeElement;\n    \"feMergeNode\": SVGFEMergeNodeElement;\n    \"feMorphology\": SVGFEMorphologyElement;\n    \"feOffset\": SVGFEOffsetElement;\n    \"fePointLight\": SVGFEPointLightElement;\n    \"feSpecularLighting\": SVGFESpecularLightingElement;\n    \"feSpotLight\": SVGFESpotLightElement;\n    \"feTile\": SVGFETileElement;\n    \"feTurbulence\": SVGFETurbulenceElement;\n    \"filter\": SVGFilterElement;\n    \"foreignObject\": SVGForeignObjectElement;\n    \"g\": SVGGElement;\n    \"image\": SVGImageElement;\n    \"line\": SVGLineElement;\n    \"linearGradient\": SVGLinearGradientElement;\n    \"marker\": SVGMarkerElement;\n    \"mask\": SVGMaskElement;\n    \"metadata\": SVGMetadataElement;\n    \"mpath\": SVGMPathElement;\n    \"path\": SVGPathElement;\n    \"pattern\": SVGPatternElement;\n    \"polygon\": SVGPolygonElement;\n    \"polyline\": SVGPolylineElement;\n    \"radialGradient\": SVGRadialGradientElement;\n    \"rect\": SVGRectElement;\n    \"script\": SVGScriptElement;\n    \"set\": SVGSetElement;\n    \"stop\": SVGStopElement;\n    \"style\": SVGStyleElement;\n    \"svg\": SVGSVGElement;\n    \"switch\": SVGSwitchElement;\n    \"symbol\": SVGSymbolElement;\n    \"text\": SVGTextElement;\n    \"textPath\": SVGTextPathElement;\n    \"title\": SVGTitleElement;\n    \"tspan\": SVGTSpanElement;\n    \"use\": SVGUseElement;\n    \"view\": SVGViewElement;\n}\n\ninterface MathMLElementTagNameMap {\n    \"annotation\": MathMLElement;\n    \"annotation-xml\": MathMLElement;\n    \"maction\": MathMLElement;\n    \"math\": MathMLElement;\n    \"merror\": MathMLElement;\n    \"mfrac\": MathMLElement;\n    \"mi\": MathMLElement;\n    \"mmultiscripts\": MathMLElement;\n    \"mn\": MathMLElement;\n    \"mo\": MathMLElement;\n    \"mover\": MathMLElement;\n    \"mpadded\": MathMLElement;\n    \"mphantom\": MathMLElement;\n    \"mprescripts\": MathMLElement;\n    \"mroot\": MathMLElement;\n    \"mrow\": MathMLElement;\n    \"ms\": MathMLElement;\n    \"mspace\": MathMLElement;\n    \"msqrt\": MathMLElement;\n    \"mstyle\": MathMLElement;\n    \"msub\": MathMLElement;\n    \"msubsup\": MathMLElement;\n    \"msup\": MathMLElement;\n    \"mtable\": MathMLElement;\n    \"mtd\": MathMLElement;\n    \"mtext\": MathMLElement;\n    \"mtr\": MathMLElement;\n    \"munder\": MathMLElement;\n    \"munderover\": MathMLElement;\n    \"semantics\": MathMLElement;\n}\n\n/** @deprecated Directly use HTMLElementTagNameMap or SVGElementTagNameMap as appropriate, instead. */\ntype ElementTagNameMap = HTMLElementTagNameMap & Pick<SVGElementTagNameMap, Exclude<keyof SVGElementTagNameMap, keyof HTMLElementTagNameMap>>;\n\ndeclare var Audio: {\n    new(src?: string): HTMLAudioElement;\n};\ndeclare var Image: {\n    new(width?: number, height?: number): HTMLImageElement;\n};\ndeclare var Option: {\n    new(text?: string, value?: string, defaultSelected?: boolean, selected?: boolean): HTMLOptionElement;\n};\n/** @deprecated This is a legacy alias of `navigator`. */\ndeclare var clientInformation: Navigator;\n/** Returns true if the window has been closed, false otherwise. */\ndeclare var closed: boolean;\n/** Defines a new custom element, mapping the given name to the given constructor as an autonomous custom element. */\ndeclare var customElements: CustomElementRegistry;\ndeclare var devicePixelRatio: number;\ndeclare var document: Document;\n/** @deprecated */\ndeclare var event: Event | undefined;\n/** @deprecated */\ndeclare var external: External;\ndeclare var frameElement: Element | null;\ndeclare var frames: WindowProxy;\ndeclare var history: History;\ndeclare var innerHeight: number;\ndeclare var innerWidth: number;\ndeclare var length: number;\ndeclare var location: Location;\n/** Returns true if the location bar is visible; otherwise, returns false. */\ndeclare var locationbar: BarProp;\n/** Returns true if the menu bar is visible; otherwise, returns false. */\ndeclare var menubar: BarProp;\n/** @deprecated */\ndeclare const name: void;\ndeclare var navigator: Navigator;\n/** Available only in secure contexts. */\ndeclare var ondevicemotion: ((this: Window, ev: DeviceMotionEvent) => any) | null;\n/** Available only in secure contexts. */\ndeclare var ondeviceorientation: ((this: Window, ev: DeviceOrientationEvent) => any) | null;\n/** @deprecated */\ndeclare var onorientationchange: ((this: Window, ev: Event) => any) | null;\ndeclare var opener: any;\n/** @deprecated */\ndeclare var orientation: number;\ndeclare var outerHeight: number;\ndeclare var outerWidth: number;\n/** @deprecated This is a legacy alias of `scrollX`. */\ndeclare var pageXOffset: number;\n/** @deprecated This is a legacy alias of `scrollY`. */\ndeclare var pageYOffset: number;\n/**\n * Refers to either the parent WindowProxy, or itself.\n *\n * It can rarely be null e.g. for contentWindow of an iframe that is already removed from the parent.\n */\ndeclare var parent: WindowProxy;\n/** Returns true if the personal bar is visible; otherwise, returns false. */\ndeclare var personalbar: BarProp;\ndeclare var screen: Screen;\ndeclare var screenLeft: number;\ndeclare var screenTop: number;\ndeclare var screenX: number;\ndeclare var screenY: number;\ndeclare var scrollX: number;\ndeclare var scrollY: number;\n/** Returns true if the scrollbars are visible; otherwise, returns false. */\ndeclare var scrollbars: BarProp;\ndeclare var self: Window & typeof globalThis;\ndeclare var speechSynthesis: SpeechSynthesis;\n/** @deprecated */\ndeclare var status: string;\n/** Returns true if the status bar is visible; otherwise, returns false. */\ndeclare var statusbar: BarProp;\n/** Returns true if the toolbar is visible; otherwise, returns false. */\ndeclare var toolbar: BarProp;\ndeclare var top: WindowProxy | null;\ndeclare var visualViewport: VisualViewport | null;\ndeclare var window: Window & typeof globalThis;\ndeclare function alert(message?: any): void;\ndeclare function blur(): void;\ndeclare function cancelIdleCallback(handle: number): void;\n/** @deprecated */\ndeclare function captureEvents(): void;\n/** Closes the window. */\ndeclare function close(): void;\ndeclare function confirm(message?: string): boolean;\n/** Moves the focus to the window's browsing context, if any. */\ndeclare function focus(): void;\ndeclare function getComputedStyle(elt: Element, pseudoElt?: string | null): CSSStyleDeclaration;\ndeclare function getSelection(): Selection | null;\ndeclare function matchMedia(query: string): MediaQueryList;\ndeclare function moveBy(x: number, y: number): void;\ndeclare function moveTo(x: number, y: number): void;\ndeclare function open(url?: string | URL, target?: string, features?: string): WindowProxy | null;\n/**\n * Posts a message to the given window. Messages can be structured objects, e.g. nested objects and arrays, can contain JavaScript values (strings, numbers, Date objects, etc), and can contain certain data objects such as File Blob, FileList, and ArrayBuffer objects.\n *\n * Objects listed in the transfer member of options are transferred, not just cloned, meaning that they are no longer usable on the sending side.\n *\n * A target origin can be specified using the targetOrigin member of options. If not provided, it defaults to \"/\". This default restricts the message to same-origin targets only.\n *\n * If the origin of the target window doesn't match the given target origin, the message is discarded, to avoid information leakage. To send the message to the target regardless of origin, set the target origin to \"*\".\n *\n * Throws a \"DataCloneError\" DOMException if transfer array contains duplicate objects or if message could not be cloned.\n */\ndeclare function postMessage(message: any, targetOrigin: string, transfer?: Transferable[]): void;\ndeclare function postMessage(message: any, options?: WindowPostMessageOptions): void;\ndeclare function print(): void;\ndeclare function prompt(message?: string, _default?: string): string | null;\n/** @deprecated */\ndeclare function releaseEvents(): void;\ndeclare function requestIdleCallback(callback: IdleRequestCallback, options?: IdleRequestOptions): number;\ndeclare function resizeBy(x: number, y: number): void;\ndeclare function resizeTo(width: number, height: number): void;\ndeclare function scroll(options?: ScrollToOptions): void;\ndeclare function scroll(x: number, y: number): void;\ndeclare function scrollBy(options?: ScrollToOptions): void;\ndeclare function scrollBy(x: number, y: number): void;\ndeclare function scrollTo(options?: ScrollToOptions): void;\ndeclare function scrollTo(x: number, y: number): void;\n/** Cancels the document load. */\ndeclare function stop(): void;\ndeclare function toString(): string;\n/** Dispatches a synthetic event event to target and returns true if either event's cancelable attribute value is false or its preventDefault() method was not invoked, and false otherwise. */\ndeclare function dispatchEvent(event: Event): boolean;\ndeclare function cancelAnimationFrame(handle: number): void;\ndeclare function requestAnimationFrame(callback: FrameRequestCallback): number;\n/**\n * Fires when the user aborts the download.\n * @param ev The event.\n */\ndeclare var onabort: ((this: Window, ev: UIEvent) => any) | null;\ndeclare var onanimationcancel: ((this: Window, ev: AnimationEvent) => any) | null;\ndeclare var onanimationend: ((this: Window, ev: AnimationEvent) => any) | null;\ndeclare var onanimationiteration: ((this: Window, ev: AnimationEvent) => any) | null;\ndeclare var onanimationstart: ((this: Window, ev: AnimationEvent) => any) | null;\ndeclare var onauxclick: ((this: Window, ev: MouseEvent) => any) | null;\ndeclare var onbeforeinput: ((this: Window, ev: InputEvent) => any) | null;\n/**\n * Fires when the object loses the input focus.\n * @param ev The focus event.\n */\ndeclare var onblur: ((this: Window, ev: FocusEvent) => any) | null;\ndeclare var oncancel: ((this: Window, ev: Event) => any) | null;\n/**\n * Occurs when playback is possible, but would require further buffering.\n * @param ev The event.\n */\ndeclare var oncanplay: ((this: Window, ev: Event) => any) | null;\ndeclare var oncanplaythrough: ((this: Window, ev: Event) => any) | null;\n/**\n * Fires when the contents of the object or selection have changed.\n * @param ev The event.\n */\ndeclare var onchange: ((this: Window, ev: Event) => any) | null;\n/**\n * Fires when the user clicks the left mouse button on the object\n * @param ev The mouse event.\n */\ndeclare var onclick: ((this: Window, ev: MouseEvent) => any) | null;\ndeclare var onclose: ((this: Window, ev: Event) => any) | null;\n/**\n * Fires when the user clicks the right mouse button in the client area, opening the context menu.\n * @param ev The mouse event.\n */\ndeclare var oncontextmenu: ((this: Window, ev: MouseEvent) => any) | null;\ndeclare var oncopy: ((this: Window, ev: ClipboardEvent) => any) | null;\ndeclare var oncuechange: ((this: Window, ev: Event) => any) | null;\ndeclare var oncut: ((this: Window, ev: ClipboardEvent) => any) | null;\n/**\n * Fires when the user double-clicks the object.\n * @param ev The mouse event.\n */\ndeclare var ondblclick: ((this: Window, ev: MouseEvent) => any) | null;\n/**\n * Fires on the source object continuously during a drag operation.\n * @param ev The event.\n */\ndeclare var ondrag: ((this: Window, ev: DragEvent) => any) | null;\n/**\n * Fires on the source object when the user releases the mouse at the close of a drag operation.\n * @param ev The event.\n */\ndeclare var ondragend: ((this: Window, ev: DragEvent) => any) | null;\n/**\n * Fires on the target element when the user drags the object to a valid drop target.\n * @param ev The drag event.\n */\ndeclare var ondragenter: ((this: Window, ev: DragEvent) => any) | null;\n/**\n * Fires on the target object when the user moves the mouse out of a valid drop target during a drag operation.\n * @param ev The drag event.\n */\ndeclare var ondragleave: ((this: Window, ev: DragEvent) => any) | null;\n/**\n * Fires on the target element continuously while the user drags the object over a valid drop target.\n * @param ev The event.\n */\ndeclare var ondragover: ((this: Window, ev: DragEvent) => any) | null;\n/**\n * Fires on the source object when the user starts to drag a text selection or selected object.\n * @param ev The event.\n */\ndeclare var ondragstart: ((this: Window, ev: DragEvent) => any) | null;\ndeclare var ondrop: ((this: Window, ev: DragEvent) => any) | null;\n/**\n * Occurs when the duration attribute is updated.\n * @param ev The event.\n */\ndeclare var ondurationchange: ((this: Window, ev: Event) => any) | null;\n/**\n * Occurs when the media element is reset to its initial state.\n * @param ev The event.\n */\ndeclare var onemptied: ((this: Window, ev: Event) => any) | null;\n/**\n * Occurs when the end of playback is reached.\n * @param ev The event\n */\ndeclare var onended: ((this: Window, ev: Event) => any) | null;\n/**\n * Fires when an error occurs during object loading.\n * @param ev The event.\n */\ndeclare var onerror: OnErrorEventHandler;\n/**\n * Fires when the object receives focus.\n * @param ev The event.\n */\ndeclare var onfocus: ((this: Window, ev: FocusEvent) => any) | null;\ndeclare var onformdata: ((this: Window, ev: FormDataEvent) => any) | null;\ndeclare var ongotpointercapture: ((this: Window, ev: PointerEvent) => any) | null;\ndeclare var oninput: ((this: Window, ev: Event) => any) | null;\ndeclare var oninvalid: ((this: Window, ev: Event) => any) | null;\n/**\n * Fires when the user presses a key.\n * @param ev The keyboard event\n */\ndeclare var onkeydown: ((this: Window, ev: KeyboardEvent) => any) | null;\n/**\n * Fires when the user presses an alphanumeric key.\n * @param ev The event.\n * @deprecated\n */\ndeclare var onkeypress: ((this: Window, ev: KeyboardEvent) => any) | null;\n/**\n * Fires when the user releases a key.\n * @param ev The keyboard event\n */\ndeclare var onkeyup: ((this: Window, ev: KeyboardEvent) => any) | null;\n/**\n * Fires immediately after the browser loads the object.\n * @param ev The event.\n */\ndeclare var onload: ((this: Window, ev: Event) => any) | null;\n/**\n * Occurs when media data is loaded at the current playback position.\n * @param ev The event.\n */\ndeclare var onloadeddata: ((this: Window, ev: Event) => any) | null;\n/**\n * Occurs when the duration and dimensions of the media have been determined.\n * @param ev The event.\n */\ndeclare var onloadedmetadata: ((this: Window, ev: Event) => any) | null;\n/**\n * Occurs when Internet Explorer begins looking for media data.\n * @param ev The event.\n */\ndeclare var onloadstart: ((this: Window, ev: Event) => any) | null;\ndeclare var onlostpointercapture: ((this: Window, ev: PointerEvent) => any) | null;\n/**\n * Fires when the user clicks the object with either mouse button.\n * @param ev The mouse event.\n */\ndeclare var onmousedown: ((this: Window, ev: MouseEvent) => any) | null;\ndeclare var onmouseenter: ((this: Window, ev: MouseEvent) => any) | null;\ndeclare var onmouseleave: ((this: Window, ev: MouseEvent) => any) | null;\n/**\n * Fires when the user moves the mouse over the object.\n * @param ev The mouse event.\n */\ndeclare var onmousemove: ((this: Window, ev: MouseEvent) => any) | null;\n/**\n * Fires when the user moves the mouse pointer outside the boundaries of the object.\n * @param ev The mouse event.\n */\ndeclare var onmouseout: ((this: Window, ev: MouseEvent) => any) | null;\n/**\n * Fires when the user moves the mouse pointer into the object.\n * @param ev The mouse event.\n */\ndeclare var onmouseover: ((this: Window, ev: MouseEvent) => any) | null;\n/**\n * Fires when the user releases a mouse button while the mouse is over the object.\n * @param ev The mouse event.\n */\ndeclare var onmouseup: ((this: Window, ev: MouseEvent) => any) | null;\ndeclare var onpaste: ((this: Window, ev: ClipboardEvent) => any) | null;\n/**\n * Occurs when playback is paused.\n * @param ev The event.\n */\ndeclare var onpause: ((this: Window, ev: Event) => any) | null;\n/**\n * Occurs when the play method is requested.\n * @param ev The event.\n */\ndeclare var onplay: ((this: Window, ev: Event) => any) | null;\n/**\n * Occurs when the audio or video has started playing.\n * @param ev The event.\n */\ndeclare var onplaying: ((this: Window, ev: Event) => any) | null;\ndeclare var onpointercancel: ((this: Window, ev: PointerEvent) => any) | null;\ndeclare var onpointerdown: ((this: Window, ev: PointerEvent) => any) | null;\ndeclare var onpointerenter: ((this: Window, ev: PointerEvent) => any) | null;\ndeclare var onpointerleave: ((this: Window, ev: PointerEvent) => any) | null;\ndeclare var onpointermove: ((this: Window, ev: PointerEvent) => any) | null;\ndeclare var onpointerout: ((this: Window, ev: PointerEvent) => any) | null;\ndeclare var onpointerover: ((this: Window, ev: PointerEvent) => any) | null;\ndeclare var onpointerup: ((this: Window, ev: PointerEvent) => any) | null;\n/**\n * Occurs to indicate progress while downloading media data.\n * @param ev The event.\n */\ndeclare var onprogress: ((this: Window, ev: ProgressEvent) => any) | null;\n/**\n * Occurs when the playback rate is increased or decreased.\n * @param ev The event.\n */\ndeclare var onratechange: ((this: Window, ev: Event) => any) | null;\n/**\n * Fires when the user resets a form.\n * @param ev The event.\n */\ndeclare var onreset: ((this: Window, ev: Event) => any) | null;\ndeclare var onresize: ((this: Window, ev: UIEvent) => any) | null;\n/**\n * Fires when the user repositions the scroll box in the scroll bar on the object.\n * @param ev The event.\n */\ndeclare var onscroll: ((this: Window, ev: Event) => any) | null;\ndeclare var onsecuritypolicyviolation: ((this: Window, ev: SecurityPolicyViolationEvent) => any) | null;\n/**\n * Occurs when the seek operation ends.\n * @param ev The event.\n */\ndeclare var onseeked: ((this: Window, ev: Event) => any) | null;\n/**\n * Occurs when the current playback position is moved.\n * @param ev The event.\n */\ndeclare var onseeking: ((this: Window, ev: Event) => any) | null;\n/**\n * Fires when the current selection changes.\n * @param ev The event.\n */\ndeclare var onselect: ((this: Window, ev: Event) => any) | null;\ndeclare var onselectionchange: ((this: Window, ev: Event) => any) | null;\ndeclare var onselectstart: ((this: Window, ev: Event) => any) | null;\ndeclare var onslotchange: ((this: Window, ev: Event) => any) | null;\n/**\n * Occurs when the download has stopped.\n * @param ev The event.\n */\ndeclare var onstalled: ((this: Window, ev: Event) => any) | null;\ndeclare var onsubmit: ((this: Window, ev: SubmitEvent) => any) | null;\n/**\n * Occurs if the load operation has been intentionally halted.\n * @param ev The event.\n */\ndeclare var onsuspend: ((this: Window, ev: Event) => any) | null;\n/**\n * Occurs to indicate the current playback position.\n * @param ev The event.\n */\ndeclare var ontimeupdate: ((this: Window, ev: Event) => any) | null;\ndeclare var ontoggle: ((this: Window, ev: Event) => any) | null;\ndeclare var ontouchcancel: ((this: Window, ev: TouchEvent) => any) | null | undefined;\ndeclare var ontouchend: ((this: Window, ev: TouchEvent) => any) | null | undefined;\ndeclare var ontouchmove: ((this: Window, ev: TouchEvent) => any) | null | undefined;\ndeclare var ontouchstart: ((this: Window, ev: TouchEvent) => any) | null | undefined;\ndeclare var ontransitioncancel: ((this: Window, ev: TransitionEvent) => any) | null;\ndeclare var ontransitionend: ((this: Window, ev: TransitionEvent) => any) | null;\ndeclare var ontransitionrun: ((this: Window, ev: TransitionEvent) => any) | null;\ndeclare var ontransitionstart: ((this: Window, ev: TransitionEvent) => any) | null;\n/**\n * Occurs when the volume is changed, or playback is muted or unmuted.\n * @param ev The event.\n */\ndeclare var onvolumechange: ((this: Window, ev: Event) => any) | null;\n/**\n * Occurs when playback stops because the next frame of a video resource is not available.\n * @param ev The event.\n */\ndeclare var onwaiting: ((this: Window, ev: Event) => any) | null;\n/** @deprecated This is a legacy alias of `onanimationend`. */\ndeclare var onwebkitanimationend: ((this: Window, ev: Event) => any) | null;\n/** @deprecated This is a legacy alias of `onanimationiteration`. */\ndeclare var onwebkitanimationiteration: ((this: Window, ev: Event) => any) | null;\n/** @deprecated This is a legacy alias of `onanimationstart`. */\ndeclare var onwebkitanimationstart: ((this: Window, ev: Event) => any) | null;\n/** @deprecated This is a legacy alias of `ontransitionend`. */\ndeclare var onwebkittransitionend: ((this: Window, ev: Event) => any) | null;\ndeclare var onwheel: ((this: Window, ev: WheelEvent) => any) | null;\ndeclare var onafterprint: ((this: Window, ev: Event) => any) | null;\ndeclare var onbeforeprint: ((this: Window, ev: Event) => any) | null;\ndeclare var onbeforeunload: ((this: Window, ev: BeforeUnloadEvent) => any) | null;\ndeclare var ongamepadconnected: ((this: Window, ev: GamepadEvent) => any) | null;\ndeclare var ongamepaddisconnected: ((this: Window, ev: GamepadEvent) => any) | null;\ndeclare var onhashchange: ((this: Window, ev: HashChangeEvent) => any) | null;\ndeclare var onlanguagechange: ((this: Window, ev: Event) => any) | null;\ndeclare var onmessage: ((this: Window, ev: MessageEvent) => any) | null;\ndeclare var onmessageerror: ((this: Window, ev: MessageEvent) => any) | null;\ndeclare var onoffline: ((this: Window, ev: Event) => any) | null;\ndeclare var ononline: ((this: Window, ev: Event) => any) | null;\ndeclare var onpagehide: ((this: Window, ev: PageTransitionEvent) => any) | null;\ndeclare var onpageshow: ((this: Window, ev: PageTransitionEvent) => any) | null;\ndeclare var onpopstate: ((this: Window, ev: PopStateEvent) => any) | null;\ndeclare var onrejectionhandled: ((this: Window, ev: PromiseRejectionEvent) => any) | null;\ndeclare var onstorage: ((this: Window, ev: StorageEvent) => any) | null;\ndeclare var onunhandledrejection: ((this: Window, ev: PromiseRejectionEvent) => any) | null;\ndeclare var onunload: ((this: Window, ev: Event) => any) | null;\ndeclare var localStorage: Storage;\n/** Available only in secure contexts. */\ndeclare var caches: CacheStorage;\ndeclare var crossOriginIsolated: boolean;\ndeclare var crypto: Crypto;\ndeclare var indexedDB: IDBFactory;\ndeclare var isSecureContext: boolean;\ndeclare var origin: string;\ndeclare var performance: Performance;\ndeclare function atob(data: string): string;\ndeclare function btoa(data: string): string;\ndeclare function clearInterval(id: number | undefined): void;\ndeclare function clearTimeout(id: number | undefined): void;\ndeclare function createImageBitmap(image: ImageBitmapSource, options?: ImageBitmapOptions): Promise<ImageBitmap>;\ndeclare function createImageBitmap(image: ImageBitmapSource, sx: number, sy: number, sw: number, sh: number, options?: ImageBitmapOptions): Promise<ImageBitmap>;\ndeclare function fetch(input: RequestInfo | URL, init?: RequestInit): Promise<Response>;\ndeclare function queueMicrotask(callback: VoidFunction): void;\ndeclare function reportError(e: any): void;\ndeclare function setInterval(handler: TimerHandler, timeout?: number, ...arguments: any[]): number;\ndeclare function setTimeout(handler: TimerHandler, timeout?: number, ...arguments: any[]): number;\ndeclare function structuredClone(value: any, options?: StructuredSerializeOptions): any;\ndeclare var sessionStorage: Storage;\ndeclare function addEventListener<K extends keyof WindowEventMap>(type: K, listener: (this: Window, ev: WindowEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\ndeclare function addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\ndeclare function removeEventListener<K extends keyof WindowEventMap>(type: K, listener: (this: Window, ev: WindowEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\ndeclare function removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\ntype AlgorithmIdentifier = Algorithm | string;\ntype BigInteger = Uint8Array;\ntype BinaryData = ArrayBuffer | ArrayBufferView;\ntype BlobPart = BufferSource | Blob | string;\ntype BodyInit = ReadableStream | XMLHttpRequestBodyInit;\ntype BufferSource = ArrayBufferView | ArrayBuffer;\ntype COSEAlgorithmIdentifier = number;\ntype CSSNumberish = number;\ntype CanvasImageSource = HTMLOrSVGImageElement | HTMLVideoElement | HTMLCanvasElement | ImageBitmap | OffscreenCanvas;\ntype ClipboardItemData = Promise<string | Blob>;\ntype ClipboardItems = ClipboardItem[];\ntype ConstrainBoolean = boolean | ConstrainBooleanParameters;\ntype ConstrainDOMString = string | string[] | ConstrainDOMStringParameters;\ntype ConstrainDouble = number | ConstrainDoubleRange;\ntype ConstrainULong = number | ConstrainULongRange;\ntype DOMHighResTimeStamp = number;\ntype EpochTimeStamp = number;\ntype EventListenerOrEventListenerObject = EventListener | EventListenerObject;\ntype Float32List = Float32Array | GLfloat[];\ntype FormDataEntryValue = File | string;\ntype GLbitfield = number;\ntype GLboolean = boolean;\ntype GLclampf = number;\ntype GLenum = number;\ntype GLfloat = number;\ntype GLint = number;\ntype GLint64 = number;\ntype GLintptr = number;\ntype GLsizei = number;\ntype GLsizeiptr = number;\ntype GLuint = number;\ntype GLuint64 = number;\ntype HTMLOrSVGImageElement = HTMLImageElement | SVGImageElement;\ntype HTMLOrSVGScriptElement = HTMLScriptElement | SVGScriptElement;\ntype HashAlgorithmIdentifier = AlgorithmIdentifier;\ntype HeadersInit = [string, string][] | Record<string, string> | Headers;\ntype IDBValidKey = number | string | Date | BufferSource | IDBValidKey[];\ntype ImageBitmapSource = CanvasImageSource | Blob | ImageData;\ntype Int32List = Int32Array | GLint[];\ntype LineAndPositionSetting = number | AutoKeyword;\ntype MediaProvider = MediaStream | MediaSource | Blob;\ntype MessageEventSource = WindowProxy | MessagePort | ServiceWorker;\ntype MutationRecordType = \"attributes\" | \"characterData\" | \"childList\";\ntype NamedCurve = string;\ntype OffscreenRenderingContext = OffscreenCanvasRenderingContext2D | ImageBitmapRenderingContext | WebGLRenderingContext | WebGL2RenderingContext;\ntype OnBeforeUnloadEventHandler = OnBeforeUnloadEventHandlerNonNull | null;\ntype OnErrorEventHandler = OnErrorEventHandlerNonNull | null;\ntype PerformanceEntryList = PerformanceEntry[];\ntype ReadableStreamController<T> = ReadableStreamDefaultController<T> | ReadableByteStreamController;\ntype ReadableStreamReadResult<T> = ReadableStreamReadValueResult<T> | ReadableStreamReadDoneResult<T>;\ntype ReadableStreamReader<T> = ReadableStreamDefaultReader<T> | ReadableStreamBYOBReader;\ntype RenderingContext = CanvasRenderingContext2D | ImageBitmapRenderingContext | WebGLRenderingContext | WebGL2RenderingContext;\ntype RequestInfo = Request | string;\ntype TexImageSource = ImageBitmap | ImageData | HTMLImageElement | HTMLCanvasElement | HTMLVideoElement | OffscreenCanvas;\ntype TimerHandler = string | Function;\ntype Transferable = OffscreenCanvas | ImageBitmap | MessagePort | ReadableStream | WritableStream | TransformStream | ArrayBuffer;\ntype Uint32List = Uint32Array | GLuint[];\ntype VibratePattern = number | number[];\ntype WindowProxy = Window;\ntype XMLHttpRequestBodyInit = Blob | BufferSource | FormData | URLSearchParams | string;\ntype AlignSetting = \"center\" | \"end\" | \"left\" | \"right\" | \"start\";\ntype AnimationPlayState = \"finished\" | \"idle\" | \"paused\" | \"running\";\ntype AnimationReplaceState = \"active\" | \"persisted\" | \"removed\";\ntype AppendMode = \"segments\" | \"sequence\";\ntype AttestationConveyancePreference = \"direct\" | \"enterprise\" | \"indirect\" | \"none\";\ntype AudioContextLatencyCategory = \"balanced\" | \"interactive\" | \"playback\";\ntype AudioContextState = \"closed\" | \"running\" | \"suspended\";\ntype AuthenticatorAttachment = \"cross-platform\" | \"platform\";\ntype AuthenticatorTransport = \"ble\" | \"hybrid\" | \"internal\" | \"nfc\" | \"usb\";\ntype AutoKeyword = \"auto\";\ntype AutomationRate = \"a-rate\" | \"k-rate\";\ntype BinaryType = \"arraybuffer\" | \"blob\";\ntype BiquadFilterType = \"allpass\" | \"bandpass\" | \"highpass\" | \"highshelf\" | \"lowpass\" | \"lowshelf\" | \"notch\" | \"peaking\";\ntype CanPlayTypeResult = \"\" | \"maybe\" | \"probably\";\ntype CanvasDirection = \"inherit\" | \"ltr\" | \"rtl\";\ntype CanvasFillRule = \"evenodd\" | \"nonzero\";\ntype CanvasFontKerning = \"auto\" | \"none\" | \"normal\";\ntype CanvasFontStretch = \"condensed\" | \"expanded\" | \"extra-condensed\" | \"extra-expanded\" | \"normal\" | \"semi-condensed\" | \"semi-expanded\" | \"ultra-condensed\" | \"ultra-expanded\";\ntype CanvasFontVariantCaps = \"all-petite-caps\" | \"all-small-caps\" | \"normal\" | \"petite-caps\" | \"small-caps\" | \"titling-caps\" | \"unicase\";\ntype CanvasLineCap = \"butt\" | \"round\" | \"square\";\ntype CanvasLineJoin = \"bevel\" | \"miter\" | \"round\";\ntype CanvasTextAlign = \"center\" | \"end\" | \"left\" | \"right\" | \"start\";\ntype CanvasTextBaseline = \"alphabetic\" | \"bottom\" | \"hanging\" | \"ideographic\" | \"middle\" | \"top\";\ntype CanvasTextRendering = \"auto\" | \"geometricPrecision\" | \"optimizeLegibility\" | \"optimizeSpeed\";\ntype ChannelCountMode = \"clamped-max\" | \"explicit\" | \"max\";\ntype ChannelInterpretation = \"discrete\" | \"speakers\";\ntype ClientTypes = \"all\" | \"sharedworker\" | \"window\" | \"worker\";\ntype ColorGamut = \"p3\" | \"rec2020\" | \"srgb\";\ntype ColorSpaceConversion = \"default\" | \"none\";\ntype CompositeOperation = \"accumulate\" | \"add\" | \"replace\";\ntype CompositeOperationOrAuto = \"accumulate\" | \"add\" | \"auto\" | \"replace\";\ntype CredentialMediationRequirement = \"optional\" | \"required\" | \"silent\";\ntype DOMParserSupportedType = \"application/xhtml+xml\" | \"application/xml\" | \"image/svg+xml\" | \"text/html\" | \"text/xml\";\ntype DirectionSetting = \"\" | \"lr\" | \"rl\";\ntype DisplayCaptureSurfaceType = \"browser\" | \"monitor\" | \"window\";\ntype DistanceModelType = \"exponential\" | \"inverse\" | \"linear\";\ntype DocumentReadyState = \"complete\" | \"interactive\" | \"loading\";\ntype DocumentVisibilityState = \"hidden\" | \"visible\";\ntype EndOfStreamError = \"decode\" | \"network\";\ntype EndingType = \"native\" | \"transparent\";\ntype FileSystemHandleKind = \"directory\" | \"file\";\ntype FillMode = \"auto\" | \"backwards\" | \"both\" | \"forwards\" | \"none\";\ntype FontDisplay = \"auto\" | \"block\" | \"fallback\" | \"optional\" | \"swap\";\ntype FontFaceLoadStatus = \"error\" | \"loaded\" | \"loading\" | \"unloaded\";\ntype FontFaceSetLoadStatus = \"loaded\" | \"loading\";\ntype FullscreenNavigationUI = \"auto\" | \"hide\" | \"show\";\ntype GamepadHapticActuatorType = \"vibration\";\ntype GamepadMappingType = \"\" | \"standard\" | \"xr-standard\";\ntype GlobalCompositeOperation = \"color\" | \"color-burn\" | \"color-dodge\" | \"copy\" | \"darken\" | \"destination-atop\" | \"destination-in\" | \"destination-out\" | \"destination-over\" | \"difference\" | \"exclusion\" | \"hard-light\" | \"hue\" | \"lighten\" | \"lighter\" | \"luminosity\" | \"multiply\" | \"overlay\" | \"saturation\" | \"screen\" | \"soft-light\" | \"source-atop\" | \"source-in\" | \"source-out\" | \"source-over\" | \"xor\";\ntype HdrMetadataType = \"smpteSt2086\" | \"smpteSt2094-10\" | \"smpteSt2094-40\";\ntype IDBCursorDirection = \"next\" | \"nextunique\" | \"prev\" | \"prevunique\";\ntype IDBRequestReadyState = \"done\" | \"pending\";\ntype IDBTransactionDurability = \"default\" | \"relaxed\" | \"strict\";\ntype IDBTransactionMode = \"readonly\" | \"readwrite\" | \"versionchange\";\ntype ImageOrientation = \"flipY\" | \"from-image\";\ntype ImageSmoothingQuality = \"high\" | \"low\" | \"medium\";\ntype InsertPosition = \"afterbegin\" | \"afterend\" | \"beforebegin\" | \"beforeend\";\ntype IterationCompositeOperation = \"accumulate\" | \"replace\";\ntype KeyFormat = \"jwk\" | \"pkcs8\" | \"raw\" | \"spki\";\ntype KeyType = \"private\" | \"public\" | \"secret\";\ntype KeyUsage = \"decrypt\" | \"deriveBits\" | \"deriveKey\" | \"encrypt\" | \"sign\" | \"unwrapKey\" | \"verify\" | \"wrapKey\";\ntype LineAlignSetting = \"center\" | \"end\" | \"start\";\ntype LockMode = \"exclusive\" | \"shared\";\ntype MIDIPortConnectionState = \"closed\" | \"open\" | \"pending\";\ntype MIDIPortDeviceState = \"connected\" | \"disconnected\";\ntype MIDIPortType = \"input\" | \"output\";\ntype MediaDecodingType = \"file\" | \"media-source\" | \"webrtc\";\ntype MediaDeviceKind = \"audioinput\" | \"audiooutput\" | \"videoinput\";\ntype MediaEncodingType = \"record\" | \"webrtc\";\ntype MediaKeyMessageType = \"individualization-request\" | \"license-release\" | \"license-renewal\" | \"license-request\";\ntype MediaKeySessionClosedReason = \"closed-by-application\" | \"hardware-context-reset\" | \"internal-error\" | \"release-acknowledged\" | \"resource-evicted\";\ntype MediaKeySessionType = \"persistent-license\" | \"temporary\";\ntype MediaKeyStatus = \"expired\" | \"internal-error\" | \"output-downscaled\" | \"output-restricted\" | \"released\" | \"status-pending\" | \"usable\" | \"usable-in-future\";\ntype MediaKeysRequirement = \"not-allowed\" | \"optional\" | \"required\";\ntype MediaSessionAction = \"nexttrack\" | \"pause\" | \"play\" | \"previoustrack\" | \"seekbackward\" | \"seekforward\" | \"seekto\" | \"skipad\" | \"stop\";\ntype MediaSessionPlaybackState = \"none\" | \"paused\" | \"playing\";\ntype MediaStreamTrackState = \"ended\" | \"live\";\ntype NavigationTimingType = \"back_forward\" | \"navigate\" | \"prerender\" | \"reload\";\ntype NotificationDirection = \"auto\" | \"ltr\" | \"rtl\";\ntype NotificationPermission = \"default\" | \"denied\" | \"granted\";\ntype OffscreenRenderingContextId = \"2d\" | \"bitmaprenderer\" | \"webgl\" | \"webgl2\" | \"webgpu\";\ntype OrientationLockType = \"any\" | \"landscape\" | \"landscape-primary\" | \"landscape-secondary\" | \"natural\" | \"portrait\" | \"portrait-primary\" | \"portrait-secondary\";\ntype OrientationType = \"landscape-primary\" | \"landscape-secondary\" | \"portrait-primary\" | \"portrait-secondary\";\ntype OscillatorType = \"custom\" | \"sawtooth\" | \"sine\" | \"square\" | \"triangle\";\ntype OverSampleType = \"2x\" | \"4x\" | \"none\";\ntype PanningModelType = \"HRTF\" | \"equalpower\";\ntype PaymentComplete = \"fail\" | \"success\" | \"unknown\";\ntype PermissionName = \"geolocation\" | \"notifications\" | \"persistent-storage\" | \"push\" | \"screen-wake-lock\" | \"xr-spatial-tracking\";\ntype PermissionState = \"denied\" | \"granted\" | \"prompt\";\ntype PlaybackDirection = \"alternate\" | \"alternate-reverse\" | \"normal\" | \"reverse\";\ntype PositionAlignSetting = \"auto\" | \"center\" | \"line-left\" | \"line-right\";\ntype PredefinedColorSpace = \"display-p3\" | \"srgb\";\ntype PremultiplyAlpha = \"default\" | \"none\" | \"premultiply\";\ntype PresentationStyle = \"attachment\" | \"inline\" | \"unspecified\";\ntype PublicKeyCredentialType = \"public-key\";\ntype PushEncryptionKeyName = \"auth\" | \"p256dh\";\ntype RTCBundlePolicy = \"balanced\" | \"max-bundle\" | \"max-compat\";\ntype RTCDataChannelState = \"closed\" | \"closing\" | \"connecting\" | \"open\";\ntype RTCDegradationPreference = \"balanced\" | \"maintain-framerate\" | \"maintain-resolution\";\ntype RTCDtlsTransportState = \"closed\" | \"connected\" | \"connecting\" | \"failed\" | \"new\";\ntype RTCEncodedVideoFrameType = \"delta\" | \"empty\" | \"key\";\ntype RTCErrorDetailType = \"data-channel-failure\" | \"dtls-failure\" | \"fingerprint-failure\" | \"hardware-encoder-error\" | \"hardware-encoder-not-available\" | \"sctp-failure\" | \"sdp-syntax-error\";\ntype RTCIceCandidateType = \"host\" | \"prflx\" | \"relay\" | \"srflx\";\ntype RTCIceComponent = \"rtcp\" | \"rtp\";\ntype RTCIceConnectionState = \"checking\" | \"closed\" | \"completed\" | \"connected\" | \"disconnected\" | \"failed\" | \"new\";\ntype RTCIceGathererState = \"complete\" | \"gathering\" | \"new\";\ntype RTCIceGatheringState = \"complete\" | \"gathering\" | \"new\";\ntype RTCIceProtocol = \"tcp\" | \"udp\";\ntype RTCIceTcpCandidateType = \"active\" | \"passive\" | \"so\";\ntype RTCIceTransportPolicy = \"all\" | \"relay\";\ntype RTCIceTransportState = \"checking\" | \"closed\" | \"completed\" | \"connected\" | \"disconnected\" | \"failed\" | \"new\";\ntype RTCPeerConnectionState = \"closed\" | \"connected\" | \"connecting\" | \"disconnected\" | \"failed\" | \"new\";\ntype RTCPriorityType = \"high\" | \"low\" | \"medium\" | \"very-low\";\ntype RTCRtcpMuxPolicy = \"require\";\ntype RTCRtpTransceiverDirection = \"inactive\" | \"recvonly\" | \"sendonly\" | \"sendrecv\" | \"stopped\";\ntype RTCSctpTransportState = \"closed\" | \"connected\" | \"connecting\";\ntype RTCSdpType = \"answer\" | \"offer\" | \"pranswer\" | \"rollback\";\ntype RTCSignalingState = \"closed\" | \"have-local-offer\" | \"have-local-pranswer\" | \"have-remote-offer\" | \"have-remote-pranswer\" | \"stable\";\ntype RTCStatsIceCandidatePairState = \"failed\" | \"frozen\" | \"in-progress\" | \"inprogress\" | \"succeeded\" | \"waiting\";\ntype RTCStatsType = \"candidate-pair\" | \"certificate\" | \"codec\" | \"data-channel\" | \"inbound-rtp\" | \"local-candidate\" | \"media-source\" | \"outbound-rtp\" | \"peer-connection\" | \"remote-candidate\" | \"remote-inbound-rtp\" | \"remote-outbound-rtp\" | \"track\" | \"transport\";\ntype ReadableStreamReaderMode = \"byob\";\ntype ReadableStreamType = \"bytes\";\ntype ReadyState = \"closed\" | \"ended\" | \"open\";\ntype RecordingState = \"inactive\" | \"paused\" | \"recording\";\ntype ReferrerPolicy = \"\" | \"no-referrer\" | \"no-referrer-when-downgrade\" | \"origin\" | \"origin-when-cross-origin\" | \"same-origin\" | \"strict-origin\" | \"strict-origin-when-cross-origin\" | \"unsafe-url\";\ntype RemotePlaybackState = \"connected\" | \"connecting\" | \"disconnected\";\ntype RequestCache = \"default\" | \"force-cache\" | \"no-cache\" | \"no-store\" | \"only-if-cached\" | \"reload\";\ntype RequestCredentials = \"include\" | \"omit\" | \"same-origin\";\ntype RequestDestination = \"\" | \"audio\" | \"audioworklet\" | \"document\" | \"embed\" | \"font\" | \"frame\" | \"iframe\" | \"image\" | \"manifest\" | \"object\" | \"paintworklet\" | \"report\" | \"script\" | \"sharedworker\" | \"style\" | \"track\" | \"video\" | \"worker\" | \"xslt\";\ntype RequestMode = \"cors\" | \"navigate\" | \"no-cors\" | \"same-origin\";\ntype RequestRedirect = \"error\" | \"follow\" | \"manual\";\ntype ResidentKeyRequirement = \"discouraged\" | \"preferred\" | \"required\";\ntype ResizeObserverBoxOptions = \"border-box\" | \"content-box\" | \"device-pixel-content-box\";\ntype ResizeQuality = \"high\" | \"low\" | \"medium\" | \"pixelated\";\ntype ResponseType = \"basic\" | \"cors\" | \"default\" | \"error\" | \"opaque\" | \"opaqueredirect\";\ntype ScrollBehavior = \"auto\" | \"smooth\";\ntype ScrollLogicalPosition = \"center\" | \"end\" | \"nearest\" | \"start\";\ntype ScrollRestoration = \"auto\" | \"manual\";\ntype ScrollSetting = \"\" | \"up\";\ntype SecurityPolicyViolationEventDisposition = \"enforce\" | \"report\";\ntype SelectionMode = \"end\" | \"preserve\" | \"select\" | \"start\";\ntype ServiceWorkerState = \"activated\" | \"activating\" | \"installed\" | \"installing\" | \"parsed\" | \"redundant\";\ntype ServiceWorkerUpdateViaCache = \"all\" | \"imports\" | \"none\";\ntype ShadowRootMode = \"closed\" | \"open\";\ntype SlotAssignmentMode = \"manual\" | \"named\";\ntype SpeechSynthesisErrorCode = \"audio-busy\" | \"audio-hardware\" | \"canceled\" | \"interrupted\" | \"invalid-argument\" | \"language-unavailable\" | \"network\" | \"not-allowed\" | \"synthesis-failed\" | \"synthesis-unavailable\" | \"text-too-long\" | \"voice-unavailable\";\ntype TextTrackKind = \"captions\" | \"chapters\" | \"descriptions\" | \"metadata\" | \"subtitles\";\ntype TextTrackMode = \"disabled\" | \"hidden\" | \"showing\";\ntype TouchType = \"direct\" | \"stylus\";\ntype TransferFunction = \"hlg\" | \"pq\" | \"srgb\";\ntype UserVerificationRequirement = \"discouraged\" | \"preferred\" | \"required\";\ntype VideoColorPrimaries = \"bt470bg\" | \"bt709\" | \"smpte170m\";\ntype VideoFacingModeEnum = \"environment\" | \"left\" | \"right\" | \"user\";\ntype VideoMatrixCoefficients = \"bt470bg\" | \"bt709\" | \"rgb\" | \"smpte170m\";\ntype VideoTransferCharacteristics = \"bt709\" | \"iec61966-2-1\" | \"smpte170m\";\ntype WebGLPowerPreference = \"default\" | \"high-performance\" | \"low-power\";\ntype WorkerType = \"classic\" | \"module\";\ntype XMLHttpRequestResponseType = \"\" | \"arraybuffer\" | \"blob\" | \"document\" | \"json\" | \"text\";\n";
libFileMap['lib.dom.iterable.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\n/////////////////////////////\n/// Window Iterable APIs\n/////////////////////////////\n\ninterface AudioParam {\n    setValueCurveAtTime(values: Iterable<number>, startTime: number, duration: number): AudioParam;\n}\n\ninterface AudioParamMap extends ReadonlyMap<string, AudioParam> {\n}\n\ninterface BaseAudioContext {\n    createIIRFilter(feedforward: Iterable<number>, feedback: Iterable<number>): IIRFilterNode;\n    createPeriodicWave(real: Iterable<number>, imag: Iterable<number>, constraints?: PeriodicWaveConstraints): PeriodicWave;\n}\n\ninterface CSSKeyframesRule {\n    [Symbol.iterator](): IterableIterator<CSSKeyframeRule>;\n}\n\ninterface CSSRuleList {\n    [Symbol.iterator](): IterableIterator<CSSRule>;\n}\n\ninterface CSSStyleDeclaration {\n    [Symbol.iterator](): IterableIterator<string>;\n}\n\ninterface Cache {\n    addAll(requests: Iterable<RequestInfo>): Promise<void>;\n}\n\ninterface CanvasPath {\n    roundRect(x: number, y: number, w: number, h: number, radii?: number | DOMPointInit | Iterable<number | DOMPointInit>): void;\n}\n\ninterface CanvasPathDrawingStyles {\n    setLineDash(segments: Iterable<number>): void;\n}\n\ninterface DOMRectList {\n    [Symbol.iterator](): IterableIterator<DOMRect>;\n}\n\ninterface DOMStringList {\n    [Symbol.iterator](): IterableIterator<string>;\n}\n\ninterface DOMTokenList {\n    [Symbol.iterator](): IterableIterator<string>;\n    entries(): IterableIterator<[number, string]>;\n    keys(): IterableIterator<number>;\n    values(): IterableIterator<string>;\n}\n\ninterface DataTransferItemList {\n    [Symbol.iterator](): IterableIterator<DataTransferItem>;\n}\n\ninterface EventCounts extends ReadonlyMap<string, number> {\n}\n\ninterface FileList {\n    [Symbol.iterator](): IterableIterator<File>;\n}\n\ninterface FontFaceSet extends Set<FontFace> {\n}\n\ninterface FormData {\n    [Symbol.iterator](): IterableIterator<[string, FormDataEntryValue]>;\n    /** Returns an array of key, value pairs for every entry in the list. */\n    entries(): IterableIterator<[string, FormDataEntryValue]>;\n    /** Returns a list of keys in the list. */\n    keys(): IterableIterator<string>;\n    /** Returns a list of values in the list. */\n    values(): IterableIterator<FormDataEntryValue>;\n}\n\ninterface HTMLAllCollection {\n    [Symbol.iterator](): IterableIterator<Element>;\n}\n\ninterface HTMLCollectionBase {\n    [Symbol.iterator](): IterableIterator<Element>;\n}\n\ninterface HTMLCollectionOf<T extends Element> {\n    [Symbol.iterator](): IterableIterator<T>;\n}\n\ninterface HTMLFormElement {\n    [Symbol.iterator](): IterableIterator<Element>;\n}\n\ninterface HTMLSelectElement {\n    [Symbol.iterator](): IterableIterator<HTMLOptionElement>;\n}\n\ninterface Headers {\n    [Symbol.iterator](): IterableIterator<[string, string]>;\n    /** Returns an iterator allowing to go through all key/value pairs contained in this object. */\n    entries(): IterableIterator<[string, string]>;\n    /** Returns an iterator allowing to go through all keys of the key/value pairs contained in this object. */\n    keys(): IterableIterator<string>;\n    /** Returns an iterator allowing to go through all values of the key/value pairs contained in this object. */\n    values(): IterableIterator<string>;\n}\n\ninterface IDBDatabase {\n    /** Returns a new transaction with the given mode (\"readonly\" or \"readwrite\") and scope which can be a single object store name or an array of names. */\n    transaction(storeNames: string | Iterable<string>, mode?: IDBTransactionMode, options?: IDBTransactionOptions): IDBTransaction;\n}\n\ninterface IDBObjectStore {\n    /**\n     * Creates a new index in store with the given name, keyPath and options and returns a new IDBIndex. If the keyPath and options define constraints that cannot be satisfied with the data already in store the upgrade transaction will abort with a \"ConstraintError\" DOMException.\n     *\n     * Throws an \"InvalidStateError\" DOMException if not called within an upgrade transaction.\n     */\n    createIndex(name: string, keyPath: string | Iterable<string>, options?: IDBIndexParameters): IDBIndex;\n}\n\ninterface MIDIInputMap extends ReadonlyMap<string, MIDIInput> {\n}\n\ninterface MIDIOutput {\n    send(data: Iterable<number>, timestamp?: DOMHighResTimeStamp): void;\n}\n\ninterface MIDIOutputMap extends ReadonlyMap<string, MIDIOutput> {\n}\n\ninterface MediaKeyStatusMap {\n    [Symbol.iterator](): IterableIterator<[BufferSource, MediaKeyStatus]>;\n    entries(): IterableIterator<[BufferSource, MediaKeyStatus]>;\n    keys(): IterableIterator<BufferSource>;\n    values(): IterableIterator<MediaKeyStatus>;\n}\n\ninterface MediaList {\n    [Symbol.iterator](): IterableIterator<string>;\n}\n\ninterface MessageEvent<T = any> {\n    /** @deprecated */\n    initMessageEvent(type: string, bubbles?: boolean, cancelable?: boolean, data?: any, origin?: string, lastEventId?: string, source?: MessageEventSource | null, ports?: Iterable<MessagePort>): void;\n}\n\ninterface MimeTypeArray {\n    [Symbol.iterator](): IterableIterator<MimeType>;\n}\n\ninterface NamedNodeMap {\n    [Symbol.iterator](): IterableIterator<Attr>;\n}\n\ninterface Navigator {\n    /** Available only in secure contexts. */\n    requestMediaKeySystemAccess(keySystem: string, supportedConfigurations: Iterable<MediaKeySystemConfiguration>): Promise<MediaKeySystemAccess>;\n    vibrate(pattern: Iterable<number>): boolean;\n}\n\ninterface NodeList {\n    [Symbol.iterator](): IterableIterator<Node>;\n    /** Returns an array of key, value pairs for every entry in the list. */\n    entries(): IterableIterator<[number, Node]>;\n    /** Returns an list of keys in the list. */\n    keys(): IterableIterator<number>;\n    /** Returns an list of values in the list. */\n    values(): IterableIterator<Node>;\n}\n\ninterface NodeListOf<TNode extends Node> {\n    [Symbol.iterator](): IterableIterator<TNode>;\n    /** Returns an array of key, value pairs for every entry in the list. */\n    entries(): IterableIterator<[number, TNode]>;\n    /** Returns an list of keys in the list. */\n    keys(): IterableIterator<number>;\n    /** Returns an list of values in the list. */\n    values(): IterableIterator<TNode>;\n}\n\ninterface Plugin {\n    [Symbol.iterator](): IterableIterator<MimeType>;\n}\n\ninterface PluginArray {\n    [Symbol.iterator](): IterableIterator<Plugin>;\n}\n\ninterface RTCRtpTransceiver {\n    setCodecPreferences(codecs: Iterable<RTCRtpCodecCapability>): void;\n}\n\ninterface RTCStatsReport extends ReadonlyMap<string, any> {\n}\n\ninterface SVGLengthList {\n    [Symbol.iterator](): IterableIterator<SVGLength>;\n}\n\ninterface SVGNumberList {\n    [Symbol.iterator](): IterableIterator<SVGNumber>;\n}\n\ninterface SVGPointList {\n    [Symbol.iterator](): IterableIterator<DOMPoint>;\n}\n\ninterface SVGStringList {\n    [Symbol.iterator](): IterableIterator<string>;\n}\n\ninterface SVGTransformList {\n    [Symbol.iterator](): IterableIterator<SVGTransform>;\n}\n\ninterface SourceBufferList {\n    [Symbol.iterator](): IterableIterator<SourceBuffer>;\n}\n\ninterface SpeechRecognitionResult {\n    [Symbol.iterator](): IterableIterator<SpeechRecognitionAlternative>;\n}\n\ninterface SpeechRecognitionResultList {\n    [Symbol.iterator](): IterableIterator<SpeechRecognitionResult>;\n}\n\ninterface StyleSheetList {\n    [Symbol.iterator](): IterableIterator<CSSStyleSheet>;\n}\n\ninterface SubtleCrypto {\n    deriveKey(algorithm: AlgorithmIdentifier | EcdhKeyDeriveParams | HkdfParams | Pbkdf2Params, baseKey: CryptoKey, derivedKeyType: AlgorithmIdentifier | AesDerivedKeyParams | HmacImportParams | HkdfParams | Pbkdf2Params, extractable: boolean, keyUsages: Iterable<KeyUsage>): Promise<CryptoKey>;\n    generateKey(algorithm: RsaHashedKeyGenParams | EcKeyGenParams, extractable: boolean, keyUsages: ReadonlyArray<KeyUsage>): Promise<CryptoKeyPair>;\n    generateKey(algorithm: AesKeyGenParams | HmacKeyGenParams | Pbkdf2Params, extractable: boolean, keyUsages: ReadonlyArray<KeyUsage>): Promise<CryptoKey>;\n    generateKey(algorithm: AlgorithmIdentifier, extractable: boolean, keyUsages: Iterable<KeyUsage>): Promise<CryptoKeyPair | CryptoKey>;\n    importKey(format: \"jwk\", keyData: JsonWebKey, algorithm: AlgorithmIdentifier | RsaHashedImportParams | EcKeyImportParams | HmacImportParams | AesKeyAlgorithm, extractable: boolean, keyUsages: ReadonlyArray<KeyUsage>): Promise<CryptoKey>;\n    importKey(format: Exclude<KeyFormat, \"jwk\">, keyData: BufferSource, algorithm: AlgorithmIdentifier | RsaHashedImportParams | EcKeyImportParams | HmacImportParams | AesKeyAlgorithm, extractable: boolean, keyUsages: Iterable<KeyUsage>): Promise<CryptoKey>;\n    unwrapKey(format: KeyFormat, wrappedKey: BufferSource, unwrappingKey: CryptoKey, unwrapAlgorithm: AlgorithmIdentifier | RsaOaepParams | AesCtrParams | AesCbcParams | AesGcmParams, unwrappedKeyAlgorithm: AlgorithmIdentifier | RsaHashedImportParams | EcKeyImportParams | HmacImportParams | AesKeyAlgorithm, extractable: boolean, keyUsages: Iterable<KeyUsage>): Promise<CryptoKey>;\n}\n\ninterface TextTrackCueList {\n    [Symbol.iterator](): IterableIterator<TextTrackCue>;\n}\n\ninterface TextTrackList {\n    [Symbol.iterator](): IterableIterator<TextTrack>;\n}\n\ninterface TouchList {\n    [Symbol.iterator](): IterableIterator<Touch>;\n}\n\ninterface URLSearchParams {\n    [Symbol.iterator](): IterableIterator<[string, string]>;\n    /** Returns an array of key, value pairs for every entry in the search params. */\n    entries(): IterableIterator<[string, string]>;\n    /** Returns a list of keys in the search params. */\n    keys(): IterableIterator<string>;\n    /** Returns a list of values in the search params. */\n    values(): IterableIterator<string>;\n}\n\ninterface WEBGL_draw_buffers {\n    drawBuffersWEBGL(buffers: Iterable<GLenum>): void;\n}\n\ninterface WEBGL_multi_draw {\n    multiDrawArraysInstancedWEBGL(mode: GLenum, firstsList: Int32Array | Iterable<GLint>, firstsOffset: GLuint, countsList: Int32Array | Iterable<GLsizei>, countsOffset: GLuint, instanceCountsList: Int32Array | Iterable<GLsizei>, instanceCountsOffset: GLuint, drawcount: GLsizei): void;\n    multiDrawArraysWEBGL(mode: GLenum, firstsList: Int32Array | Iterable<GLint>, firstsOffset: GLuint, countsList: Int32Array | Iterable<GLsizei>, countsOffset: GLuint, drawcount: GLsizei): void;\n    multiDrawElementsInstancedWEBGL(mode: GLenum, countsList: Int32Array | Iterable<GLsizei>, countsOffset: GLuint, type: GLenum, offsetsList: Int32Array | Iterable<GLsizei>, offsetsOffset: GLuint, instanceCountsList: Int32Array | Iterable<GLsizei>, instanceCountsOffset: GLuint, drawcount: GLsizei): void;\n    multiDrawElementsWEBGL(mode: GLenum, countsList: Int32Array | Iterable<GLsizei>, countsOffset: GLuint, type: GLenum, offsetsList: Int32Array | Iterable<GLsizei>, offsetsOffset: GLuint, drawcount: GLsizei): void;\n}\n\ninterface WebGL2RenderingContextBase {\n    clearBufferfv(buffer: GLenum, drawbuffer: GLint, values: Iterable<GLfloat>, srcOffset?: GLuint): void;\n    clearBufferiv(buffer: GLenum, drawbuffer: GLint, values: Iterable<GLint>, srcOffset?: GLuint): void;\n    clearBufferuiv(buffer: GLenum, drawbuffer: GLint, values: Iterable<GLuint>, srcOffset?: GLuint): void;\n    drawBuffers(buffers: Iterable<GLenum>): void;\n    getActiveUniforms(program: WebGLProgram, uniformIndices: Iterable<GLuint>, pname: GLenum): any;\n    getUniformIndices(program: WebGLProgram, uniformNames: Iterable<string>): Iterable<GLuint> | null;\n    invalidateFramebuffer(target: GLenum, attachments: Iterable<GLenum>): void;\n    invalidateSubFramebuffer(target: GLenum, attachments: Iterable<GLenum>, x: GLint, y: GLint, width: GLsizei, height: GLsizei): void;\n    transformFeedbackVaryings(program: WebGLProgram, varyings: Iterable<string>, bufferMode: GLenum): void;\n    uniform1uiv(location: WebGLUniformLocation | null, data: Iterable<GLuint>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform2uiv(location: WebGLUniformLocation | null, data: Iterable<GLuint>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform3uiv(location: WebGLUniformLocation | null, data: Iterable<GLuint>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform4uiv(location: WebGLUniformLocation | null, data: Iterable<GLuint>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniformMatrix2x3fv(location: WebGLUniformLocation | null, transpose: GLboolean, data: Iterable<GLfloat>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniformMatrix2x4fv(location: WebGLUniformLocation | null, transpose: GLboolean, data: Iterable<GLfloat>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniformMatrix3x2fv(location: WebGLUniformLocation | null, transpose: GLboolean, data: Iterable<GLfloat>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniformMatrix3x4fv(location: WebGLUniformLocation | null, transpose: GLboolean, data: Iterable<GLfloat>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniformMatrix4x2fv(location: WebGLUniformLocation | null, transpose: GLboolean, data: Iterable<GLfloat>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniformMatrix4x3fv(location: WebGLUniformLocation | null, transpose: GLboolean, data: Iterable<GLfloat>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    vertexAttribI4iv(index: GLuint, values: Iterable<GLint>): void;\n    vertexAttribI4uiv(index: GLuint, values: Iterable<GLuint>): void;\n}\n\ninterface WebGL2RenderingContextOverloads {\n    uniform1fv(location: WebGLUniformLocation | null, data: Iterable<GLfloat>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform1iv(location: WebGLUniformLocation | null, data: Iterable<GLint>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform2fv(location: WebGLUniformLocation | null, data: Iterable<GLfloat>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform2iv(location: WebGLUniformLocation | null, data: Iterable<GLint>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform3fv(location: WebGLUniformLocation | null, data: Iterable<GLfloat>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform3iv(location: WebGLUniformLocation | null, data: Iterable<GLint>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform4fv(location: WebGLUniformLocation | null, data: Iterable<GLfloat>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform4iv(location: WebGLUniformLocation | null, data: Iterable<GLint>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniformMatrix2fv(location: WebGLUniformLocation | null, transpose: GLboolean, data: Iterable<GLfloat>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniformMatrix3fv(location: WebGLUniformLocation | null, transpose: GLboolean, data: Iterable<GLfloat>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniformMatrix4fv(location: WebGLUniformLocation | null, transpose: GLboolean, data: Iterable<GLfloat>, srcOffset?: GLuint, srcLength?: GLuint): void;\n}\n\ninterface WebGLRenderingContextBase {\n    vertexAttrib1fv(index: GLuint, values: Iterable<GLfloat>): void;\n    vertexAttrib2fv(index: GLuint, values: Iterable<GLfloat>): void;\n    vertexAttrib3fv(index: GLuint, values: Iterable<GLfloat>): void;\n    vertexAttrib4fv(index: GLuint, values: Iterable<GLfloat>): void;\n}\n\ninterface WebGLRenderingContextOverloads {\n    uniform1fv(location: WebGLUniformLocation | null, v: Iterable<GLfloat>): void;\n    uniform1iv(location: WebGLUniformLocation | null, v: Iterable<GLint>): void;\n    uniform2fv(location: WebGLUniformLocation | null, v: Iterable<GLfloat>): void;\n    uniform2iv(location: WebGLUniformLocation | null, v: Iterable<GLint>): void;\n    uniform3fv(location: WebGLUniformLocation | null, v: Iterable<GLfloat>): void;\n    uniform3iv(location: WebGLUniformLocation | null, v: Iterable<GLint>): void;\n    uniform4fv(location: WebGLUniformLocation | null, v: Iterable<GLfloat>): void;\n    uniform4iv(location: WebGLUniformLocation | null, v: Iterable<GLint>): void;\n    uniformMatrix2fv(location: WebGLUniformLocation | null, transpose: GLboolean, value: Iterable<GLfloat>): void;\n    uniformMatrix3fv(location: WebGLUniformLocation | null, transpose: GLboolean, value: Iterable<GLfloat>): void;\n    uniformMatrix4fv(location: WebGLUniformLocation | null, transpose: GLboolean, value: Iterable<GLfloat>): void;\n}\n";
libFileMap['lib.es2015.collection.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\ninterface Map<K, V> {\n\n    clear(): void;\n    /**\n     * @returns true if an element in the Map existed and has been removed, or false if the element does not exist.\n     */\n    delete(key: K): boolean;\n    /**\n     * Executes a provided function once per each key/value pair in the Map, in insertion order.\n     */\n    forEach(callbackfn: (value: V, key: K, map: Map<K, V>) => void, thisArg?: any): void;\n    /**\n     * Returns a specified element from the Map object. If the value that is associated to the provided key is an object, then you will get a reference to that object and any change made to that object will effectively modify it inside the Map.\n     * @returns Returns the element associated with the specified key. If no element is associated with the specified key, undefined is returned.\n     */\n    get(key: K): V | undefined;\n    /**\n     * @returns boolean indicating whether an element with the specified key exists or not.\n     */\n    has(key: K): boolean;\n    /**\n     * Adds a new element with a specified key and value to the Map. If an element with the same key already exists, the element will be updated.\n     */\n    set(key: K, value: V): this;\n    /**\n     * @returns the number of elements in the Map.\n     */\n    readonly size: number;\n}\n\ninterface MapConstructor {\n    new(): Map<any, any>;\n    new <K, V>(entries?: readonly (readonly [K, V])[] | null): Map<K, V>;\n    readonly prototype: Map<any, any>;\n}\ndeclare var Map: MapConstructor;\n\ninterface ReadonlyMap<K, V> {\n    forEach(callbackfn: (value: V, key: K, map: ReadonlyMap<K, V>) => void, thisArg?: any): void;\n    get(key: K): V | undefined;\n    has(key: K): boolean;\n    readonly size: number;\n}\n\ninterface WeakMap<K extends object, V> {\n    /**\n     * Removes the specified element from the WeakMap.\n     * @returns true if the element was successfully removed, or false if it was not present.\n     */\n    delete(key: K): boolean;\n    /**\n     * @returns a specified element.\n     */\n    get(key: K): V | undefined;\n    /**\n     * @returns a boolean indicating whether an element with the specified key exists or not.\n     */\n    has(key: K): boolean;\n    /**\n     * Adds a new element with a specified key and value.\n     * @param key Must be an object.\n     */\n    set(key: K, value: V): this;\n}\n\ninterface WeakMapConstructor {\n    new <K extends object = object, V = any>(entries?: readonly [K, V][] | null): WeakMap<K, V>;\n    readonly prototype: WeakMap<object, any>;\n}\ndeclare var WeakMap: WeakMapConstructor;\n\ninterface Set<T> {\n    /**\n     * Appends a new element with a specified value to the end of the Set.\n     */\n    add(value: T): this;\n\n    clear(): void;\n    /**\n     * Removes a specified value from the Set.\n     * @returns Returns true if an element in the Set existed and has been removed, or false if the element does not exist.\n     */\n    delete(value: T): boolean;\n    /**\n     * Executes a provided function once per each value in the Set object, in insertion order.\n     */\n    forEach(callbackfn: (value: T, value2: T, set: Set<T>) => void, thisArg?: any): void;\n    /**\n     * @returns a boolean indicating whether an element with the specified value exists in the Set or not.\n     */\n    has(value: T): boolean;\n    /**\n     * @returns the number of (unique) elements in Set.\n     */\n    readonly size: number;\n}\n\ninterface SetConstructor {\n    new <T = any>(values?: readonly T[] | null): Set<T>;\n    readonly prototype: Set<any>;\n}\ndeclare var Set: SetConstructor;\n\ninterface ReadonlySet<T> {\n    forEach(callbackfn: (value: T, value2: T, set: ReadonlySet<T>) => void, thisArg?: any): void;\n    has(value: T): boolean;\n    readonly size: number;\n}\n\ninterface WeakSet<T extends object> {\n    /**\n     * Appends a new object to the end of the WeakSet.\n     */\n    add(value: T): this;\n    /**\n     * Removes the specified element from the WeakSet.\n     * @returns Returns true if the element existed and has been removed, or false if the element does not exist.\n     */\n    delete(value: T): boolean;\n    /**\n     * @returns a boolean indicating whether an object exists in the WeakSet or not.\n     */\n    has(value: T): boolean;\n}\n\ninterface WeakSetConstructor {\n    new <T extends object = object>(values?: readonly T[] | null): WeakSet<T>;\n    readonly prototype: WeakSet<object>;\n}\ndeclare var WeakSet: WeakSetConstructor;\n";
libFileMap['lib.es2015.core.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\ninterface Array<T> {\n    /**\n     * Returns the value of the first element in the array where predicate is true, and undefined\n     * otherwise.\n     * @param predicate find calls predicate once for each element of the array, in ascending\n     * order, until it finds one where predicate returns true. If such an element is found, find\n     * immediately returns that element value. Otherwise, find returns undefined.\n     * @param thisArg If provided, it will be used as the this value for each invocation of\n     * predicate. If it is not provided, undefined is used instead.\n     */\n    find<S extends T>(predicate: (value: T, index: number, obj: T[]) => value is S, thisArg?: any): S | undefined;\n    find(predicate: (value: T, index: number, obj: T[]) => unknown, thisArg?: any): T | undefined;\n\n    /**\n     * Returns the index of the first element in the array where predicate is true, and -1\n     * otherwise.\n     * @param predicate find calls predicate once for each element of the array, in ascending\n     * order, until it finds one where predicate returns true. If such an element is found,\n     * findIndex immediately returns that element index. Otherwise, findIndex returns -1.\n     * @param thisArg If provided, it will be used as the this value for each invocation of\n     * predicate. If it is not provided, undefined is used instead.\n     */\n    findIndex(predicate: (value: T, index: number, obj: T[]) => unknown, thisArg?: any): number;\n\n    /**\n     * Changes all array elements from `start` to `end` index to a static `value` and returns the modified array\n     * @param value value to fill array section with\n     * @param start index to start filling the array at. If start is negative, it is treated as\n     * length+start where length is the length of the array.\n     * @param end index to stop filling the array at. If end is negative, it is treated as\n     * length+end.\n     */\n    fill(value: T, start?: number, end?: number): this;\n\n    /**\n     * Returns the this object after copying a section of the array identified by start and end\n     * to the same array starting at position target\n     * @param target If target is negative, it is treated as length+target where length is the\n     * length of the array.\n     * @param start If start is negative, it is treated as length+start. If end is negative, it\n     * is treated as length+end.\n     * @param end If not specified, length of the this object is used as its default value.\n     */\n    copyWithin(target: number, start: number, end?: number): this;\n}\n\ninterface ArrayConstructor {\n    /**\n     * Creates an array from an array-like object.\n     * @param arrayLike An array-like object to convert to an array.\n     */\n    from<T>(arrayLike: ArrayLike<T>): T[];\n\n    /**\n     * Creates an array from an iterable object.\n     * @param arrayLike An array-like object to convert to an array.\n     * @param mapfn A mapping function to call on every element of the array.\n     * @param thisArg Value of 'this' used to invoke the mapfn.\n     */\n    from<T, U>(arrayLike: ArrayLike<T>, mapfn: (v: T, k: number) => U, thisArg?: any): U[];\n\n    /**\n     * Returns a new array from a set of elements.\n     * @param items A set of elements to include in the new array object.\n     */\n    of<T>(...items: T[]): T[];\n}\n\ninterface DateConstructor {\n    new (value: number | string | Date): Date;\n}\n\ninterface Function {\n    /**\n     * Returns the name of the function. Function names are read-only and can not be changed.\n     */\n    readonly name: string;\n}\n\ninterface Math {\n    /**\n     * Returns the number of leading zero bits in the 32-bit binary representation of a number.\n     * @param x A numeric expression.\n     */\n    clz32(x: number): number;\n\n    /**\n     * Returns the result of 32-bit multiplication of two numbers.\n     * @param x First number\n     * @param y Second number\n     */\n    imul(x: number, y: number): number;\n\n    /**\n     * Returns the sign of the x, indicating whether x is positive, negative or zero.\n     * @param x The numeric expression to test\n     */\n    sign(x: number): number;\n\n    /**\n     * Returns the base 10 logarithm of a number.\n     * @param x A numeric expression.\n     */\n    log10(x: number): number;\n\n    /**\n     * Returns the base 2 logarithm of a number.\n     * @param x A numeric expression.\n     */\n    log2(x: number): number;\n\n    /**\n     * Returns the natural logarithm of 1 + x.\n     * @param x A numeric expression.\n     */\n    log1p(x: number): number;\n\n    /**\n     * Returns the result of (e^x - 1), which is an implementation-dependent approximation to\n     * subtracting 1 from the exponential function of x (e raised to the power of x, where e\n     * is the base of the natural logarithms).\n     * @param x A numeric expression.\n     */\n    expm1(x: number): number;\n\n    /**\n     * Returns the hyperbolic cosine of a number.\n     * @param x A numeric expression that contains an angle measured in radians.\n     */\n    cosh(x: number): number;\n\n    /**\n     * Returns the hyperbolic sine of a number.\n     * @param x A numeric expression that contains an angle measured in radians.\n     */\n    sinh(x: number): number;\n\n    /**\n     * Returns the hyperbolic tangent of a number.\n     * @param x A numeric expression that contains an angle measured in radians.\n     */\n    tanh(x: number): number;\n\n    /**\n     * Returns the inverse hyperbolic cosine of a number.\n     * @param x A numeric expression that contains an angle measured in radians.\n     */\n    acosh(x: number): number;\n\n    /**\n     * Returns the inverse hyperbolic sine of a number.\n     * @param x A numeric expression that contains an angle measured in radians.\n     */\n    asinh(x: number): number;\n\n    /**\n     * Returns the inverse hyperbolic tangent of a number.\n     * @param x A numeric expression that contains an angle measured in radians.\n     */\n    atanh(x: number): number;\n\n    /**\n     * Returns the square root of the sum of squares of its arguments.\n     * @param values Values to compute the square root for.\n     *     If no arguments are passed, the result is +0.\n     *     If there is only one argument, the result is the absolute value.\n     *     If any argument is +Infinity or -Infinity, the result is +Infinity.\n     *     If any argument is NaN, the result is NaN.\n     *     If all arguments are either +0 or −0, the result is +0.\n     */\n    hypot(...values: number[]): number;\n\n    /**\n     * Returns the integral part of the a numeric expression, x, removing any fractional digits.\n     * If x is already an integer, the result is x.\n     * @param x A numeric expression.\n     */\n    trunc(x: number): number;\n\n    /**\n     * Returns the nearest single precision float representation of a number.\n     * @param x A numeric expression.\n     */\n    fround(x: number): number;\n\n    /**\n     * Returns an implementation-dependent approximation to the cube root of number.\n     * @param x A numeric expression.\n     */\n    cbrt(x: number): number;\n}\n\ninterface NumberConstructor {\n    /**\n     * The value of Number.EPSILON is the difference between 1 and the smallest value greater than 1\n     * that is representable as a Number value, which is approximately:\n     * 2.2204460492503130808472633361816 x 10‍−‍16.\n     */\n    readonly EPSILON: number;\n\n    /**\n     * Returns true if passed value is finite.\n     * Unlike the global isFinite, Number.isFinite doesn't forcibly convert the parameter to a\n     * number. Only finite values of the type number, result in true.\n     * @param number A numeric value.\n     */\n    isFinite(number: unknown): boolean;\n\n    /**\n     * Returns true if the value passed is an integer, false otherwise.\n     * @param number A numeric value.\n     */\n    isInteger(number: unknown): boolean;\n\n    /**\n     * Returns a Boolean value that indicates whether a value is the reserved value NaN (not a\n     * number). Unlike the global isNaN(), Number.isNaN() doesn't forcefully convert the parameter\n     * to a number. Only values of the type number, that are also NaN, result in true.\n     * @param number A numeric value.\n     */\n    isNaN(number: unknown): boolean;\n\n    /**\n     * Returns true if the value passed is a safe integer.\n     * @param number A numeric value.\n     */\n    isSafeInteger(number: unknown): boolean;\n\n    /**\n     * The value of the largest integer n such that n and n + 1 are both exactly representable as\n     * a Number value.\n     * The value of Number.MAX_SAFE_INTEGER is 9007199254740991 2^53 − 1.\n     */\n    readonly MAX_SAFE_INTEGER: number;\n\n    /**\n     * The value of the smallest integer n such that n and n − 1 are both exactly representable as\n     * a Number value.\n     * The value of Number.MIN_SAFE_INTEGER is −9007199254740991 (−(2^53 − 1)).\n     */\n    readonly MIN_SAFE_INTEGER: number;\n\n    /**\n     * Converts a string to a floating-point number.\n     * @param string A string that contains a floating-point number.\n     */\n    parseFloat(string: string): number;\n\n    /**\n     * Converts A string to an integer.\n     * @param string A string to convert into a number.\n     * @param radix A value between 2 and 36 that specifies the base of the number in `string`.\n     * If this argument is not supplied, strings with a prefix of '0x' are considered hexadecimal.\n     * All other strings are considered decimal.\n     */\n    parseInt(string: string, radix?: number): number;\n}\n\ninterface ObjectConstructor {\n    /**\n     * Copy the values of all of the enumerable own properties from one or more source objects to a\n     * target object. Returns the target object.\n     * @param target The target object to copy to.\n     * @param source The source object from which to copy properties.\n     */\n    assign<T extends {}, U>(target: T, source: U): T & U;\n\n    /**\n     * Copy the values of all of the enumerable own properties from one or more source objects to a\n     * target object. Returns the target object.\n     * @param target The target object to copy to.\n     * @param source1 The first source object from which to copy properties.\n     * @param source2 The second source object from which to copy properties.\n     */\n    assign<T extends {}, U, V>(target: T, source1: U, source2: V): T & U & V;\n\n    /**\n     * Copy the values of all of the enumerable own properties from one or more source objects to a\n     * target object. Returns the target object.\n     * @param target The target object to copy to.\n     * @param source1 The first source object from which to copy properties.\n     * @param source2 The second source object from which to copy properties.\n     * @param source3 The third source object from which to copy properties.\n     */\n    assign<T extends {}, U, V, W>(target: T, source1: U, source2: V, source3: W): T & U & V & W;\n\n    /**\n     * Copy the values of all of the enumerable own properties from one or more source objects to a\n     * target object. Returns the target object.\n     * @param target The target object to copy to.\n     * @param sources One or more source objects from which to copy properties\n     */\n    assign(target: object, ...sources: any[]): any;\n\n    /**\n     * Returns an array of all symbol properties found directly on object o.\n     * @param o Object to retrieve the symbols from.\n     */\n    getOwnPropertySymbols(o: any): symbol[];\n\n    /**\n     * Returns the names of the enumerable string properties and methods of an object.\n     * @param o Object that contains the properties and methods. This can be an object that you created or an existing Document Object Model (DOM) object.\n     */\n    keys(o: {}): string[];\n\n    /**\n     * Returns true if the values are the same value, false otherwise.\n     * @param value1 The first value.\n     * @param value2 The second value.\n     */\n    is(value1: any, value2: any): boolean;\n\n    /**\n     * Sets the prototype of a specified object o to object proto or null. Returns the object o.\n     * @param o The object to change its prototype.\n     * @param proto The value of the new prototype or null.\n     */\n    setPrototypeOf(o: any, proto: object | null): any;\n}\n\ninterface ReadonlyArray<T> {\n    /**\n     * Returns the value of the first element in the array where predicate is true, and undefined\n     * otherwise.\n     * @param predicate find calls predicate once for each element of the array, in ascending\n     * order, until it finds one where predicate returns true. If such an element is found, find\n     * immediately returns that element value. Otherwise, find returns undefined.\n     * @param thisArg If provided, it will be used as the this value for each invocation of\n     * predicate. If it is not provided, undefined is used instead.\n     */\n    find<S extends T>(predicate: (value: T, index: number, obj: readonly T[]) => value is S, thisArg?: any): S | undefined;\n    find(predicate: (value: T, index: number, obj: readonly T[]) => unknown, thisArg?: any): T | undefined;\n\n    /**\n     * Returns the index of the first element in the array where predicate is true, and -1\n     * otherwise.\n     * @param predicate find calls predicate once for each element of the array, in ascending\n     * order, until it finds one where predicate returns true. If such an element is found,\n     * findIndex immediately returns that element index. Otherwise, findIndex returns -1.\n     * @param thisArg If provided, it will be used as the this value for each invocation of\n     * predicate. If it is not provided, undefined is used instead.\n     */\n    findIndex(predicate: (value: T, index: number, obj: readonly T[]) => unknown, thisArg?: any): number;\n}\n\ninterface RegExp {\n    /**\n     * Returns a string indicating the flags of the regular expression in question. This field is read-only.\n     * The characters in this string are sequenced and concatenated in the following order:\n     *\n     *    - \"g\" for global\n     *    - \"i\" for ignoreCase\n     *    - \"m\" for multiline\n     *    - \"u\" for unicode\n     *    - \"y\" for sticky\n     *\n     * If no flags are set, the value is the empty string.\n     */\n    readonly flags: string;\n\n    /**\n     * Returns a Boolean value indicating the state of the sticky flag (y) used with a regular\n     * expression. Default is false. Read-only.\n     */\n    readonly sticky: boolean;\n\n    /**\n     * Returns a Boolean value indicating the state of the Unicode flag (u) used with a regular\n     * expression. Default is false. Read-only.\n     */\n    readonly unicode: boolean;\n}\n\ninterface RegExpConstructor {\n    new (pattern: RegExp | string, flags?: string): RegExp;\n    (pattern: RegExp | string, flags?: string): RegExp;\n}\n\ninterface String {\n    /**\n     * Returns a nonnegative integer Number less than 1114112 (0x110000) that is the code point\n     * value of the UTF-16 encoded code point starting at the string element at position pos in\n     * the String resulting from converting this object to a String.\n     * If there is no element at that position, the result is undefined.\n     * If a valid UTF-16 surrogate pair does not begin at pos, the result is the code unit at pos.\n     */\n    codePointAt(pos: number): number | undefined;\n\n    /**\n     * Returns true if searchString appears as a substring of the result of converting this\n     * object to a String, at one or more positions that are\n     * greater than or equal to position; otherwise, returns false.\n     * @param searchString search string\n     * @param position If position is undefined, 0 is assumed, so as to search all of the String.\n     */\n    includes(searchString: string, position?: number): boolean;\n\n    /**\n     * Returns true if the sequence of elements of searchString converted to a String is the\n     * same as the corresponding elements of this object (converted to a String) starting at\n     * endPosition – length(this). Otherwise returns false.\n     */\n    endsWith(searchString: string, endPosition?: number): boolean;\n\n    /**\n     * Returns the String value result of normalizing the string into the normalization form\n     * named by form as specified in Unicode Standard Annex #15, Unicode Normalization Forms.\n     * @param form Applicable values: \"NFC\", \"NFD\", \"NFKC\", or \"NFKD\", If not specified default\n     * is \"NFC\"\n     */\n    normalize(form: \"NFC\" | \"NFD\" | \"NFKC\" | \"NFKD\"): string;\n\n    /**\n     * Returns the String value result of normalizing the string into the normalization form\n     * named by form as specified in Unicode Standard Annex #15, Unicode Normalization Forms.\n     * @param form Applicable values: \"NFC\", \"NFD\", \"NFKC\", or \"NFKD\", If not specified default\n     * is \"NFC\"\n     */\n    normalize(form?: string): string;\n\n    /**\n     * Returns a String value that is made from count copies appended together. If count is 0,\n     * the empty string is returned.\n     * @param count number of copies to append\n     */\n    repeat(count: number): string;\n\n    /**\n     * Returns true if the sequence of elements of searchString converted to a String is the\n     * same as the corresponding elements of this object (converted to a String) starting at\n     * position. Otherwise returns false.\n     */\n    startsWith(searchString: string, position?: number): boolean;\n\n    /**\n     * Returns an `<a>` HTML anchor element and sets the name attribute to the text value\n     * @deprecated A legacy feature for browser compatibility\n     * @param name\n     */\n    anchor(name: string): string;\n\n    /**\n     * Returns a `<big>` HTML element\n     * @deprecated A legacy feature for browser compatibility\n     */\n    big(): string;\n\n    /**\n     * Returns a `<blink>` HTML element\n     * @deprecated A legacy feature for browser compatibility\n     */\n    blink(): string;\n\n    /**\n     * Returns a `<b>` HTML element\n     * @deprecated A legacy feature for browser compatibility\n     */\n    bold(): string;\n\n    /**\n     * Returns a `<tt>` HTML element\n     * @deprecated A legacy feature for browser compatibility\n     */\n    fixed(): string;\n\n    /**\n     * Returns a `<font>` HTML element and sets the color attribute value\n     * @deprecated A legacy feature for browser compatibility\n     */\n    fontcolor(color: string): string;\n\n    /**\n     * Returns a `<font>` HTML element and sets the size attribute value\n     * @deprecated A legacy feature for browser compatibility\n     */\n    fontsize(size: number): string;\n\n    /**\n     * Returns a `<font>` HTML element and sets the size attribute value\n     * @deprecated A legacy feature for browser compatibility\n     */\n    fontsize(size: string): string;\n\n    /**\n     * Returns an `<i>` HTML element\n     * @deprecated A legacy feature for browser compatibility\n     */\n    italics(): string;\n\n    /**\n     * Returns an `<a>` HTML element and sets the href attribute value\n     * @deprecated A legacy feature for browser compatibility\n     */\n    link(url: string): string;\n\n    /**\n     * Returns a `<small>` HTML element\n     * @deprecated A legacy feature for browser compatibility\n     */\n    small(): string;\n\n    /**\n     * Returns a `<strike>` HTML element\n     * @deprecated A legacy feature for browser compatibility\n     */\n    strike(): string;\n\n    /**\n     * Returns a `<sub>` HTML element\n     * @deprecated A legacy feature for browser compatibility\n     */\n    sub(): string;\n\n    /**\n     * Returns a `<sup>` HTML element\n     * @deprecated A legacy feature for browser compatibility\n     */\n    sup(): string;\n}\n\ninterface StringConstructor {\n    /**\n     * Return the String value whose elements are, in order, the elements in the List elements.\n     * If length is 0, the empty string is returned.\n     */\n    fromCodePoint(...codePoints: number[]): string;\n\n    /**\n     * String.raw is usually used as a tag function of a Tagged Template String. When called as\n     * such, the first argument will be a well formed template call site object and the rest\n     * parameter will contain the substitution values. It can also be called directly, for example,\n     * to interleave strings and values from your own tag function, and in this case the only thing\n     * it needs from the first argument is the raw property.\n     * @param template A well-formed template string call site representation.\n     * @param substitutions A set of substitution values.\n     */\n    raw(template: { raw: readonly string[] | ArrayLike<string>}, ...substitutions: any[]): string;\n}\n";
libFileMap['lib.es2015.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\n/// <reference lib=\"es5\" />\n/// <reference lib=\"es2015.core\" />\n/// <reference lib=\"es2015.collection\" />\n/// <reference lib=\"es2015.iterable\" />\n/// <reference lib=\"es2015.generator\" />\n/// <reference lib=\"es2015.promise\" />\n/// <reference lib=\"es2015.proxy\" />\n/// <reference lib=\"es2015.reflect\" />\n/// <reference lib=\"es2015.symbol\" />\n/// <reference lib=\"es2015.symbol.wellknown\" />\n";
libFileMap['lib.es2015.generator.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\n/// <reference lib=\"es2015.iterable\" />\n\ninterface Generator<T = unknown, TReturn = any, TNext = unknown> extends Iterator<T, TReturn, TNext> {\n    // NOTE: 'next' is defined using a tuple to ensure we report the correct assignability errors in all places.\n    next(...args: [] | [TNext]): IteratorResult<T, TReturn>;\n    return(value: TReturn): IteratorResult<T, TReturn>;\n    throw(e: any): IteratorResult<T, TReturn>;\n    [Symbol.iterator](): Generator<T, TReturn, TNext>;\n}\n\ninterface GeneratorFunction {\n    /**\n     * Creates a new Generator object.\n     * @param args A list of arguments the function accepts.\n     */\n    new (...args: any[]): Generator;\n    /**\n     * Creates a new Generator object.\n     * @param args A list of arguments the function accepts.\n     */\n    (...args: any[]): Generator;\n    /**\n     * The length of the arguments.\n     */\n    readonly length: number;\n    /**\n     * Returns the name of the function.\n     */\n    readonly name: string;\n    /**\n     * A reference to the prototype.\n     */\n    readonly prototype: Generator;\n}\n\ninterface GeneratorFunctionConstructor {\n    /**\n     * Creates a new Generator function.\n     * @param args A list of arguments the function accepts.\n     */\n    new (...args: string[]): GeneratorFunction;\n    /**\n     * Creates a new Generator function.\n     * @param args A list of arguments the function accepts.\n     */\n    (...args: string[]): GeneratorFunction;\n    /**\n     * The length of the arguments.\n     */\n    readonly length: number;\n    /**\n     * Returns the name of the function.\n     */\n    readonly name: string;\n    /**\n     * A reference to the prototype.\n     */\n    readonly prototype: GeneratorFunction;\n}\n";
libFileMap['lib.es2015.iterable.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\n/// <reference lib=\"es2015.symbol\" />\n\ninterface SymbolConstructor {\n    /**\n     * A method that returns the default iterator for an object. Called by the semantics of the\n     * for-of statement.\n     */\n    readonly iterator: unique symbol;\n}\n\ninterface IteratorYieldResult<TYield> {\n    done?: false;\n    value: TYield;\n}\n\ninterface IteratorReturnResult<TReturn> {\n    done: true;\n    value: TReturn;\n}\n\ntype IteratorResult<T, TReturn = any> = IteratorYieldResult<T> | IteratorReturnResult<TReturn>;\n\ninterface Iterator<T, TReturn = any, TNext = undefined> {\n    // NOTE: 'next' is defined using a tuple to ensure we report the correct assignability errors in all places.\n    next(...args: [] | [TNext]): IteratorResult<T, TReturn>;\n    return?(value?: TReturn): IteratorResult<T, TReturn>;\n    throw?(e?: any): IteratorResult<T, TReturn>;\n}\n\ninterface Iterable<T> {\n    [Symbol.iterator](): Iterator<T>;\n}\n\ninterface IterableIterator<T> extends Iterator<T> {\n    [Symbol.iterator](): IterableIterator<T>;\n}\n\ninterface Array<T> {\n    /** Iterator */\n    [Symbol.iterator](): IterableIterator<T>;\n\n    /**\n     * Returns an iterable of key, value pairs for every entry in the array\n     */\n    entries(): IterableIterator<[number, T]>;\n\n    /**\n     * Returns an iterable of keys in the array\n     */\n    keys(): IterableIterator<number>;\n\n    /**\n     * Returns an iterable of values in the array\n     */\n    values(): IterableIterator<T>;\n}\n\ninterface ArrayConstructor {\n    /**\n     * Creates an array from an iterable object.\n     * @param iterable An iterable object to convert to an array.\n     */\n    from<T>(iterable: Iterable<T> | ArrayLike<T>): T[];\n\n    /**\n     * Creates an array from an iterable object.\n     * @param iterable An iterable object to convert to an array.\n     * @param mapfn A mapping function to call on every element of the array.\n     * @param thisArg Value of 'this' used to invoke the mapfn.\n     */\n    from<T, U>(iterable: Iterable<T> | ArrayLike<T>, mapfn: (v: T, k: number) => U, thisArg?: any): U[];\n}\n\ninterface ReadonlyArray<T> {\n    /** Iterator of values in the array. */\n    [Symbol.iterator](): IterableIterator<T>;\n\n    /**\n     * Returns an iterable of key, value pairs for every entry in the array\n     */\n    entries(): IterableIterator<[number, T]>;\n\n    /**\n     * Returns an iterable of keys in the array\n     */\n    keys(): IterableIterator<number>;\n\n    /**\n     * Returns an iterable of values in the array\n     */\n    values(): IterableIterator<T>;\n}\n\ninterface IArguments {\n    /** Iterator */\n    [Symbol.iterator](): IterableIterator<any>;\n}\n\ninterface Map<K, V> {\n    /** Returns an iterable of entries in the map. */\n    [Symbol.iterator](): IterableIterator<[K, V]>;\n\n    /**\n     * Returns an iterable of key, value pairs for every entry in the map.\n     */\n    entries(): IterableIterator<[K, V]>;\n\n    /**\n     * Returns an iterable of keys in the map\n     */\n    keys(): IterableIterator<K>;\n\n    /**\n     * Returns an iterable of values in the map\n     */\n    values(): IterableIterator<V>;\n}\n\ninterface ReadonlyMap<K, V> {\n    /** Returns an iterable of entries in the map. */\n    [Symbol.iterator](): IterableIterator<[K, V]>;\n\n    /**\n     * Returns an iterable of key, value pairs for every entry in the map.\n     */\n    entries(): IterableIterator<[K, V]>;\n\n    /**\n     * Returns an iterable of keys in the map\n     */\n    keys(): IterableIterator<K>;\n\n    /**\n     * Returns an iterable of values in the map\n     */\n    values(): IterableIterator<V>;\n}\n\ninterface MapConstructor {\n    new(): Map<any, any>;\n    new <K, V>(iterable?: Iterable<readonly [K, V]> | null): Map<K, V>;\n}\n\ninterface WeakMap<K extends object, V> { }\n\ninterface WeakMapConstructor {\n    new <K extends object, V>(iterable: Iterable<readonly [K, V]>): WeakMap<K, V>;\n}\n\ninterface Set<T> {\n    /** Iterates over values in the set. */\n    [Symbol.iterator](): IterableIterator<T>;\n    /**\n     * Returns an iterable of [v,v] pairs for every value `v` in the set.\n     */\n    entries(): IterableIterator<[T, T]>;\n    /**\n     * Despite its name, returns an iterable of the values in the set.\n     */\n    keys(): IterableIterator<T>;\n\n    /**\n     * Returns an iterable of values in the set.\n     */\n    values(): IterableIterator<T>;\n}\n\ninterface ReadonlySet<T> {\n    /** Iterates over values in the set. */\n    [Symbol.iterator](): IterableIterator<T>;\n\n    /**\n     * Returns an iterable of [v,v] pairs for every value `v` in the set.\n     */\n    entries(): IterableIterator<[T, T]>;\n\n    /**\n     * Despite its name, returns an iterable of the values in the set.\n     */\n    keys(): IterableIterator<T>;\n\n    /**\n     * Returns an iterable of values in the set.\n     */\n    values(): IterableIterator<T>;\n}\n\ninterface SetConstructor {\n    new <T>(iterable?: Iterable<T> | null): Set<T>;\n}\n\ninterface WeakSet<T extends object> { }\n\ninterface WeakSetConstructor {\n    new <T extends object = object>(iterable: Iterable<T>): WeakSet<T>;\n}\n\ninterface Promise<T> { }\n\ninterface PromiseConstructor {\n    /**\n     * Creates a Promise that is resolved with an array of results when all of the provided Promises\n     * resolve, or rejected when any Promise is rejected.\n     * @param values An iterable of Promises.\n     * @returns A new Promise.\n     */\n    all<T>(values: Iterable<T | PromiseLike<T>>): Promise<Awaited<T>[]>;\n\n    /**\n     * Creates a Promise that is resolved or rejected when any of the provided Promises are resolved\n     * or rejected.\n     * @param values An iterable of Promises.\n     * @returns A new Promise.\n     */\n    race<T>(values: Iterable<T | PromiseLike<T>>): Promise<Awaited<T>>;\n}\n\ninterface String {\n    /** Iterator */\n    [Symbol.iterator](): IterableIterator<string>;\n}\n\ninterface Int8Array {\n    [Symbol.iterator](): IterableIterator<number>;\n    /**\n     * Returns an array of key, value pairs for every entry in the array\n     */\n    entries(): IterableIterator<[number, number]>;\n    /**\n     * Returns an list of keys in the array\n     */\n    keys(): IterableIterator<number>;\n    /**\n     * Returns an list of values in the array\n     */\n    values(): IterableIterator<number>;\n}\n\ninterface Int8ArrayConstructor {\n    new (elements: Iterable<number>): Int8Array;\n\n    /**\n     * Creates an array from an array-like or iterable object.\n     * @param arrayLike An array-like or iterable object to convert to an array.\n     * @param mapfn A mapping function to call on every element of the array.\n     * @param thisArg Value of 'this' used to invoke the mapfn.\n     */\n    from(arrayLike: Iterable<number>, mapfn?: (v: number, k: number) => number, thisArg?: any): Int8Array;\n}\n\ninterface Uint8Array {\n    [Symbol.iterator](): IterableIterator<number>;\n    /**\n     * Returns an array of key, value pairs for every entry in the array\n     */\n    entries(): IterableIterator<[number, number]>;\n    /**\n     * Returns an list of keys in the array\n     */\n    keys(): IterableIterator<number>;\n    /**\n     * Returns an list of values in the array\n     */\n    values(): IterableIterator<number>;\n}\n\ninterface Uint8ArrayConstructor {\n    new (elements: Iterable<number>): Uint8Array;\n\n    /**\n     * Creates an array from an array-like or iterable object.\n     * @param arrayLike An array-like or iterable object to convert to an array.\n     * @param mapfn A mapping function to call on every element of the array.\n     * @param thisArg Value of 'this' used to invoke the mapfn.\n     */\n    from(arrayLike: Iterable<number>, mapfn?: (v: number, k: number) => number, thisArg?: any): Uint8Array;\n}\n\ninterface Uint8ClampedArray {\n    [Symbol.iterator](): IterableIterator<number>;\n    /**\n     * Returns an array of key, value pairs for every entry in the array\n     */\n    entries(): IterableIterator<[number, number]>;\n\n    /**\n     * Returns an list of keys in the array\n     */\n    keys(): IterableIterator<number>;\n\n    /**\n     * Returns an list of values in the array\n     */\n    values(): IterableIterator<number>;\n}\n\ninterface Uint8ClampedArrayConstructor {\n    new (elements: Iterable<number>): Uint8ClampedArray;\n\n\n    /**\n     * Creates an array from an array-like or iterable object.\n     * @param arrayLike An array-like or iterable object to convert to an array.\n     * @param mapfn A mapping function to call on every element of the array.\n     * @param thisArg Value of 'this' used to invoke the mapfn.\n     */\n    from(arrayLike: Iterable<number>, mapfn?: (v: number, k: number) => number, thisArg?: any): Uint8ClampedArray;\n}\n\ninterface Int16Array {\n    [Symbol.iterator](): IterableIterator<number>;\n    /**\n     * Returns an array of key, value pairs for every entry in the array\n     */\n    entries(): IterableIterator<[number, number]>;\n\n    /**\n     * Returns an list of keys in the array\n     */\n    keys(): IterableIterator<number>;\n\n    /**\n     * Returns an list of values in the array\n     */\n    values(): IterableIterator<number>;\n}\n\ninterface Int16ArrayConstructor {\n    new (elements: Iterable<number>): Int16Array;\n\n    /**\n     * Creates an array from an array-like or iterable object.\n     * @param arrayLike An array-like or iterable object to convert to an array.\n     * @param mapfn A mapping function to call on every element of the array.\n     * @param thisArg Value of 'this' used to invoke the mapfn.\n     */\n    from(arrayLike: Iterable<number>, mapfn?: (v: number, k: number) => number, thisArg?: any): Int16Array;\n}\n\ninterface Uint16Array {\n    [Symbol.iterator](): IterableIterator<number>;\n    /**\n     * Returns an array of key, value pairs for every entry in the array\n     */\n    entries(): IterableIterator<[number, number]>;\n    /**\n     * Returns an list of keys in the array\n     */\n    keys(): IterableIterator<number>;\n    /**\n     * Returns an list of values in the array\n     */\n    values(): IterableIterator<number>;\n}\n\ninterface Uint16ArrayConstructor {\n    new (elements: Iterable<number>): Uint16Array;\n\n    /**\n     * Creates an array from an array-like or iterable object.\n     * @param arrayLike An array-like or iterable object to convert to an array.\n     * @param mapfn A mapping function to call on every element of the array.\n     * @param thisArg Value of 'this' used to invoke the mapfn.\n     */\n    from(arrayLike: Iterable<number>, mapfn?: (v: number, k: number) => number, thisArg?: any): Uint16Array;\n}\n\ninterface Int32Array {\n    [Symbol.iterator](): IterableIterator<number>;\n    /**\n     * Returns an array of key, value pairs for every entry in the array\n     */\n    entries(): IterableIterator<[number, number]>;\n    /**\n     * Returns an list of keys in the array\n     */\n    keys(): IterableIterator<number>;\n    /**\n     * Returns an list of values in the array\n     */\n    values(): IterableIterator<number>;\n}\n\ninterface Int32ArrayConstructor {\n    new (elements: Iterable<number>): Int32Array;\n\n    /**\n     * Creates an array from an array-like or iterable object.\n     * @param arrayLike An array-like or iterable object to convert to an array.\n     * @param mapfn A mapping function to call on every element of the array.\n     * @param thisArg Value of 'this' used to invoke the mapfn.\n     */\n    from(arrayLike: Iterable<number>, mapfn?: (v: number, k: number) => number, thisArg?: any): Int32Array;\n}\n\ninterface Uint32Array {\n    [Symbol.iterator](): IterableIterator<number>;\n    /**\n     * Returns an array of key, value pairs for every entry in the array\n     */\n    entries(): IterableIterator<[number, number]>;\n    /**\n     * Returns an list of keys in the array\n     */\n    keys(): IterableIterator<number>;\n    /**\n     * Returns an list of values in the array\n     */\n    values(): IterableIterator<number>;\n}\n\ninterface Uint32ArrayConstructor {\n    new (elements: Iterable<number>): Uint32Array;\n\n    /**\n     * Creates an array from an array-like or iterable object.\n     * @param arrayLike An array-like or iterable object to convert to an array.\n     * @param mapfn A mapping function to call on every element of the array.\n     * @param thisArg Value of 'this' used to invoke the mapfn.\n     */\n    from(arrayLike: Iterable<number>, mapfn?: (v: number, k: number) => number, thisArg?: any): Uint32Array;\n}\n\ninterface Float32Array {\n    [Symbol.iterator](): IterableIterator<number>;\n    /**\n     * Returns an array of key, value pairs for every entry in the array\n     */\n    entries(): IterableIterator<[number, number]>;\n    /**\n     * Returns an list of keys in the array\n     */\n    keys(): IterableIterator<number>;\n    /**\n     * Returns an list of values in the array\n     */\n    values(): IterableIterator<number>;\n}\n\ninterface Float32ArrayConstructor {\n    new (elements: Iterable<number>): Float32Array;\n\n    /**\n     * Creates an array from an array-like or iterable object.\n     * @param arrayLike An array-like or iterable object to convert to an array.\n     * @param mapfn A mapping function to call on every element of the array.\n     * @param thisArg Value of 'this' used to invoke the mapfn.\n     */\n    from(arrayLike: Iterable<number>, mapfn?: (v: number, k: number) => number, thisArg?: any): Float32Array;\n}\n\ninterface Float64Array {\n    [Symbol.iterator](): IterableIterator<number>;\n    /**\n     * Returns an array of key, value pairs for every entry in the array\n     */\n    entries(): IterableIterator<[number, number]>;\n    /**\n     * Returns an list of keys in the array\n     */\n    keys(): IterableIterator<number>;\n    /**\n     * Returns an list of values in the array\n     */\n    values(): IterableIterator<number>;\n}\n\ninterface Float64ArrayConstructor {\n    new (elements: Iterable<number>): Float64Array;\n\n    /**\n     * Creates an array from an array-like or iterable object.\n     * @param arrayLike An array-like or iterable object to convert to an array.\n     * @param mapfn A mapping function to call on every element of the array.\n     * @param thisArg Value of 'this' used to invoke the mapfn.\n     */\n    from(arrayLike: Iterable<number>, mapfn?: (v: number, k: number) => number, thisArg?: any): Float64Array;\n}\n";
libFileMap['lib.es2015.promise.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\ninterface PromiseConstructor {\n    /**\n     * A reference to the prototype.\n     */\n    readonly prototype: Promise<any>;\n\n    /**\n     * Creates a new Promise.\n     * @param executor A callback used to initialize the promise. This callback is passed two arguments:\n     * a resolve callback used to resolve the promise with a value or the result of another promise,\n     * and a reject callback used to reject the promise with a provided reason or error.\n     */\n    new <T>(executor: (resolve: (value: T | PromiseLike<T>) => void, reject: (reason?: any) => void) => void): Promise<T>;\n\n    /**\n     * Creates a Promise that is resolved with an array of results when all of the provided Promises\n     * resolve, or rejected when any Promise is rejected.\n     * @param values An array of Promises.\n     * @returns A new Promise.\n     */\n    all<T extends readonly unknown[] | []>(values: T): Promise<{ -readonly [P in keyof T]: Awaited<T[P]> }>;\n\n    // see: lib.es2015.iterable.d.ts\n    // all<T>(values: Iterable<T | PromiseLike<T>>): Promise<Awaited<T>[]>;\n\n    /**\n     * Creates a Promise that is resolved or rejected when any of the provided Promises are resolved\n     * or rejected.\n     * @param values An array of Promises.\n     * @returns A new Promise.\n     */\n    race<T extends readonly unknown[] | []>(values: T): Promise<Awaited<T[number]>>;\n\n    // see: lib.es2015.iterable.d.ts\n    // race<T>(values: Iterable<T | PromiseLike<T>>): Promise<Awaited<T>>;\n\n    /**\n     * Creates a new rejected promise for the provided reason.\n     * @param reason The reason the promise was rejected.\n     * @returns A new rejected Promise.\n     */\n    reject<T = never>(reason?: any): Promise<T>;\n\n    /**\n     * Creates a new resolved promise.\n     * @returns A resolved promise.\n     */\n    resolve(): Promise<void>;\n    /**\n     * Creates a new resolved promise for the provided value.\n     * @param value A promise.\n     * @returns A promise whose internal state matches the provided promise.\n     */\n    resolve<T>(value: T): Promise<Awaited<T>>;\n    /**\n     * Creates a new resolved promise for the provided value.\n     * @param value A promise.\n     * @returns A promise whose internal state matches the provided promise.\n     */\n    resolve<T>(value: T | PromiseLike<T>): Promise<Awaited<T>>;\n}\n\ndeclare var Promise: PromiseConstructor;\n";
libFileMap['lib.es2015.proxy.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\ninterface ProxyHandler<T extends object> {\n    /**\n     * A trap method for a function call.\n     * @param target The original callable object which is being proxied.\n     */\n    apply?(target: T, thisArg: any, argArray: any[]): any;\n\n    /**\n     * A trap for the `new` operator.\n     * @param target The original object which is being proxied.\n     * @param newTarget The constructor that was originally called.\n     */\n    construct?(target: T, argArray: any[], newTarget: Function): object;\n\n    /**\n     * A trap for `Object.defineProperty()`.\n     * @param target The original object which is being proxied.\n     * @returns A `Boolean` indicating whether or not the property has been defined.\n     */\n    defineProperty?(target: T, property: string | symbol, attributes: PropertyDescriptor): boolean;\n\n    /**\n     * A trap for the `delete` operator.\n     * @param target The original object which is being proxied.\n     * @param p The name or `Symbol` of the property to delete.\n     * @returns A `Boolean` indicating whether or not the property was deleted.\n     */\n    deleteProperty?(target: T, p: string | symbol): boolean;\n\n    /**\n     * A trap for getting a property value.\n     * @param target The original object which is being proxied.\n     * @param p The name or `Symbol` of the property to get.\n     * @param receiver The proxy or an object that inherits from the proxy.\n     */\n    get?(target: T, p: string | symbol, receiver: any): any;\n\n    /**\n     * A trap for `Object.getOwnPropertyDescriptor()`.\n     * @param target The original object which is being proxied.\n     * @param p The name of the property whose description should be retrieved.\n     */\n    getOwnPropertyDescriptor?(target: T, p: string | symbol): PropertyDescriptor | undefined;\n\n    /**\n     * A trap for the `[[GetPrototypeOf]]` internal method.\n     * @param target The original object which is being proxied.\n     */\n    getPrototypeOf?(target: T): object | null;\n\n    /**\n     * A trap for the `in` operator.\n     * @param target The original object which is being proxied.\n     * @param p The name or `Symbol` of the property to check for existence.\n     */\n    has?(target: T, p: string | symbol): boolean;\n\n    /**\n     * A trap for `Object.isExtensible()`.\n     * @param target The original object which is being proxied.\n     */\n    isExtensible?(target: T): boolean;\n\n    /**\n     * A trap for `Reflect.ownKeys()`.\n     * @param target The original object which is being proxied.\n     */\n    ownKeys?(target: T): ArrayLike<string | symbol>;\n\n    /**\n     * A trap for `Object.preventExtensions()`.\n     * @param target The original object which is being proxied.\n     */\n    preventExtensions?(target: T): boolean;\n\n    /**\n     * A trap for setting a property value.\n     * @param target The original object which is being proxied.\n     * @param p The name or `Symbol` of the property to set.\n     * @param receiver The object to which the assignment was originally directed.\n     * @returns A `Boolean` indicating whether or not the property was set.\n     */\n    set?(target: T, p: string | symbol, newValue: any, receiver: any): boolean;\n\n    /**\n     * A trap for `Object.setPrototypeOf()`.\n     * @param target The original object which is being proxied.\n     * @param newPrototype The object's new prototype or `null`.\n     */\n    setPrototypeOf?(target: T, v: object | null): boolean;\n}\n\ninterface ProxyConstructor {\n    /**\n     * Creates a revocable Proxy object.\n     * @param target A target object to wrap with Proxy.\n     * @param handler An object whose properties define the behavior of Proxy when an operation is attempted on it.\n     */\n    revocable<T extends object>(target: T, handler: ProxyHandler<T>): { proxy: T; revoke: () => void; };\n\n    /**\n     * Creates a Proxy object. The Proxy object allows you to create an object that can be used in place of the\n     * original object, but which may redefine fundamental Object operations like getting, setting, and defining\n     * properties. Proxy objects are commonly used to log property accesses, validate, format, or sanitize inputs.\n     * @param target A target object to wrap with Proxy.\n     * @param handler An object whose properties define the behavior of Proxy when an operation is attempted on it.\n     */\n    new <T extends object>(target: T, handler: ProxyHandler<T>): T;\n}\ndeclare var Proxy: ProxyConstructor;\n";
libFileMap['lib.es2015.reflect.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\ndeclare namespace Reflect {\n    /**\n     * Calls the function with the specified object as the this value\n     * and the elements of specified array as the arguments.\n     * @param target The function to call.\n     * @param thisArgument The object to be used as the this object.\n     * @param argumentsList An array of argument values to be passed to the function.\n     */\n    function apply<T, A extends readonly any[], R>(\n        target: (this: T, ...args: A) => R,\n        thisArgument: T,\n        argumentsList: Readonly<A>,\n    ): R;\n    function apply(target: Function, thisArgument: any, argumentsList: ArrayLike<any>): any;\n\n    /**\n     * Constructs the target with the elements of specified array as the arguments\n     * and the specified constructor as the `new.target` value.\n     * @param target The constructor to invoke.\n     * @param argumentsList An array of argument values to be passed to the constructor.\n     * @param newTarget The constructor to be used as the `new.target` object.\n     */\n    function construct<A extends readonly any[], R>(\n        target: new (...args: A) => R,\n        argumentsList: Readonly<A>,\n        newTarget?: new (...args: any) => any,\n    ): R;\n    function construct(target: Function, argumentsList: ArrayLike<any>, newTarget?: Function): any;\n\n    /**\n     * Adds a property to an object, or modifies attributes of an existing property.\n     * @param target Object on which to add or modify the property. This can be a native JavaScript object\n     *        (that is, a user-defined object or a built in object) or a DOM object.\n     * @param propertyKey The property name.\n     * @param attributes Descriptor for the property. It can be for a data property or an accessor property.\n     */\n    function defineProperty(target: object, propertyKey: PropertyKey, attributes: PropertyDescriptor & ThisType<any>): boolean;\n\n    /**\n     * Removes a property from an object, equivalent to `delete target[propertyKey]`,\n     * except it won't throw if `target[propertyKey]` is non-configurable.\n     * @param target Object from which to remove the own property.\n     * @param propertyKey The property name.\n     */\n    function deleteProperty(target: object, propertyKey: PropertyKey): boolean;\n\n    /**\n     * Gets the property of target, equivalent to `target[propertyKey]` when `receiver === target`.\n     * @param target Object that contains the property on itself or in its prototype chain.\n     * @param propertyKey The property name.\n     * @param receiver The reference to use as the `this` value in the getter function,\n     *        if `target[propertyKey]` is an accessor property.\n     */\n    function get<T extends object, P extends PropertyKey>(\n        target: T,\n        propertyKey: P,\n        receiver?: unknown,\n    ): P extends keyof T ? T[P] : any;\n\n    /**\n     * Gets the own property descriptor of the specified object.\n     * An own property descriptor is one that is defined directly on the object and is not inherited from the object's prototype.\n     * @param target Object that contains the property.\n     * @param propertyKey The property name.\n     */\n    function getOwnPropertyDescriptor<T extends object, P extends PropertyKey>(\n        target: T,\n        propertyKey: P,\n    ): TypedPropertyDescriptor<P extends keyof T ? T[P] : any> | undefined;\n\n    /**\n     * Returns the prototype of an object.\n     * @param target The object that references the prototype.\n     */\n    function getPrototypeOf(target: object): object | null;\n\n    /**\n     * Equivalent to `propertyKey in target`.\n     * @param target Object that contains the property on itself or in its prototype chain.\n     * @param propertyKey Name of the property.\n     */\n    function has(target: object, propertyKey: PropertyKey): boolean;\n\n    /**\n     * Returns a value that indicates whether new properties can be added to an object.\n     * @param target Object to test.\n     */\n    function isExtensible(target: object): boolean;\n\n    /**\n     * Returns the string and symbol keys of the own properties of an object. The own properties of an object\n     * are those that are defined directly on that object, and are not inherited from the object's prototype.\n     * @param target Object that contains the own properties.\n     */\n    function ownKeys(target: object): (string | symbol)[];\n\n    /**\n     * Prevents the addition of new properties to an object.\n     * @param target Object to make non-extensible.\n     * @return Whether the object has been made non-extensible.\n     */\n    function preventExtensions(target: object): boolean;\n\n    /**\n     * Sets the property of target, equivalent to `target[propertyKey] = value` when `receiver === target`.\n     * @param target Object that contains the property on itself or in its prototype chain.\n     * @param propertyKey Name of the property.\n     * @param receiver The reference to use as the `this` value in the setter function,\n     *        if `target[propertyKey]` is an accessor property.\n     */\n    function set<T extends object, P extends PropertyKey>(\n        target: T,\n        propertyKey: P,\n        value: P extends keyof T ? T[P] : any,\n        receiver?: any,\n    ): boolean;\n    function set(target: object, propertyKey: PropertyKey, value: any, receiver?: any): boolean;\n\n    /**\n     * Sets the prototype of a specified object o to object proto or null.\n     * @param target The object to change its prototype.\n     * @param proto The value of the new prototype or null.\n     * @return Whether setting the prototype was successful.\n     */\n    function setPrototypeOf(target: object, proto: object | null): boolean;\n}\n";
libFileMap['lib.es2015.symbol.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\ninterface SymbolConstructor {\n    /**\n     * A reference to the prototype.\n     */\n    readonly prototype: Symbol;\n\n    /**\n     * Returns a new unique Symbol value.\n     * @param  description Description of the new Symbol object.\n     */\n    (description?: string | number): symbol;\n\n    /**\n     * Returns a Symbol object from the global symbol registry matching the given key if found.\n     * Otherwise, returns a new symbol with this key.\n     * @param key key to search for.\n     */\n    for(key: string): symbol;\n\n    /**\n     * Returns a key from the global symbol registry matching the given Symbol if found.\n     * Otherwise, returns a undefined.\n     * @param sym Symbol to find the key for.\n     */\n    keyFor(sym: symbol): string | undefined;\n}\n\ndeclare var Symbol: SymbolConstructor;";
libFileMap['lib.es2015.symbol.wellknown.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\n/// <reference lib=\"es2015.symbol\" />\n\ninterface SymbolConstructor {\n    /**\n     * A method that determines if a constructor object recognizes an object as one of the\n     * constructor’s instances. Called by the semantics of the instanceof operator.\n     */\n    readonly hasInstance: unique symbol;\n\n    /**\n     * A Boolean value that if true indicates that an object should flatten to its array elements\n     * by Array.prototype.concat.\n     */\n    readonly isConcatSpreadable: unique symbol;\n\n    /**\n     * A regular expression method that matches the regular expression against a string. Called\n     * by the String.prototype.match method.\n     */\n    readonly match: unique symbol;\n\n    /**\n     * A regular expression method that replaces matched substrings of a string. Called by the\n     * String.prototype.replace method.\n     */\n    readonly replace: unique symbol;\n\n    /**\n     * A regular expression method that returns the index within a string that matches the\n     * regular expression. Called by the String.prototype.search method.\n     */\n    readonly search: unique symbol;\n\n    /**\n     * A function valued property that is the constructor function that is used to create\n     * derived objects.\n     */\n    readonly species: unique symbol;\n\n    /**\n     * A regular expression method that splits a string at the indices that match the regular\n     * expression. Called by the String.prototype.split method.\n     */\n    readonly split: unique symbol;\n\n    /**\n     * A method that converts an object to a corresponding primitive value.\n     * Called by the ToPrimitive abstract operation.\n     */\n    readonly toPrimitive: unique symbol;\n\n    /**\n     * A String value that is used in the creation of the default string description of an object.\n     * Called by the built-in method Object.prototype.toString.\n     */\n    readonly toStringTag: unique symbol;\n\n    /**\n     * An Object whose truthy properties are properties that are excluded from the 'with'\n     * environment bindings of the associated objects.\n     */\n    readonly unscopables: unique symbol;\n}\n\ninterface Symbol {\n    /**\n     * Converts a Symbol object to a symbol.\n     */\n    [Symbol.toPrimitive](hint: string): symbol;\n\n    readonly [Symbol.toStringTag]: string;\n}\n\ninterface Array<T> {\n    /**\n     * Is an object whose properties have the value 'true'\n     * when they will be absent when used in a 'with' statement.\n     */\n    readonly [Symbol.unscopables]: {\n        [K in keyof any[]]?: boolean;\n    };\n}\n\ninterface ReadonlyArray<T> {\n    /**\n     * Is an object whose properties have the value 'true'\n     * when they will be absent when used in a 'with' statement.\n     */\n    readonly [Symbol.unscopables]: {\n        [K in keyof readonly any[]]?: boolean;\n    };\n}\n\ninterface Date {\n    /**\n     * Converts a Date object to a string.\n     */\n    [Symbol.toPrimitive](hint: \"default\"): string;\n    /**\n     * Converts a Date object to a string.\n     */\n    [Symbol.toPrimitive](hint: \"string\"): string;\n    /**\n     * Converts a Date object to a number.\n     */\n    [Symbol.toPrimitive](hint: \"number\"): number;\n    /**\n     * Converts a Date object to a string or number.\n     *\n     * @param hint The strings \"number\", \"string\", or \"default\" to specify what primitive to return.\n     *\n     * @throws {TypeError} If 'hint' was given something other than \"number\", \"string\", or \"default\".\n     * @returns A number if 'hint' was \"number\", a string if 'hint' was \"string\" or \"default\".\n     */\n    [Symbol.toPrimitive](hint: string): string | number;\n}\n\ninterface Map<K, V> {\n    readonly [Symbol.toStringTag]: string;\n}\n\ninterface WeakMap<K extends object, V> {\n    readonly [Symbol.toStringTag]: string;\n}\n\ninterface Set<T> {\n    readonly [Symbol.toStringTag]: string;\n}\n\ninterface WeakSet<T extends object> {\n    readonly [Symbol.toStringTag]: string;\n}\n\ninterface JSON {\n    readonly [Symbol.toStringTag]: string;\n}\n\ninterface Function {\n    /**\n     * Determines whether the given value inherits from this function if this function was used\n     * as a constructor function.\n     *\n     * A constructor function can control which objects are recognized as its instances by\n     * 'instanceof' by overriding this method.\n     */\n    [Symbol.hasInstance](value: any): boolean;\n}\n\ninterface GeneratorFunction {\n    readonly [Symbol.toStringTag]: string;\n}\n\ninterface Math {\n    readonly [Symbol.toStringTag]: string;\n}\n\ninterface Promise<T> {\n    readonly [Symbol.toStringTag]: string;\n}\n\ninterface PromiseConstructor {\n    readonly [Symbol.species]: PromiseConstructor;\n}\n\ninterface RegExp {\n    /**\n     * Matches a string with this regular expression, and returns an array containing the results of\n     * that search.\n     * @param string A string to search within.\n     */\n    [Symbol.match](string: string): RegExpMatchArray | null;\n\n    /**\n     * Replaces text in a string, using this regular expression.\n     * @param string A String object or string literal whose contents matching against\n     *               this regular expression will be replaced\n     * @param replaceValue A String object or string literal containing the text to replace for every\n     *                     successful match of this regular expression.\n     */\n    [Symbol.replace](string: string, replaceValue: string): string;\n\n    /**\n     * Replaces text in a string, using this regular expression.\n     * @param string A String object or string literal whose contents matching against\n     *               this regular expression will be replaced\n     * @param replacer A function that returns the replacement text.\n     */\n    [Symbol.replace](string: string, replacer: (substring: string, ...args: any[]) => string): string;\n\n    /**\n     * Finds the position beginning first substring match in a regular expression search\n     * using this regular expression.\n     *\n     * @param string The string to search within.\n     */\n    [Symbol.search](string: string): number;\n\n    /**\n     * Returns an array of substrings that were delimited by strings in the original input that\n     * match against this regular expression.\n     *\n     * If the regular expression contains capturing parentheses, then each time this\n     * regular expression matches, the results (including any undefined results) of the\n     * capturing parentheses are spliced.\n     *\n     * @param string string value to split\n     * @param limit if not undefined, the output array is truncated so that it contains no more\n     * than 'limit' elements.\n     */\n    [Symbol.split](string: string, limit?: number): string[];\n}\n\ninterface RegExpConstructor {\n    readonly [Symbol.species]: RegExpConstructor;\n}\n\ninterface String {\n    /**\n     * Matches a string or an object that supports being matched against, and returns an array\n     * containing the results of that search, or null if no matches are found.\n     * @param matcher An object that supports being matched against.\n     */\n    match(matcher: { [Symbol.match](string: string): RegExpMatchArray | null; }): RegExpMatchArray | null;\n\n    /**\n     * Passes a string and {@linkcode replaceValue} to the `[Symbol.replace]` method on {@linkcode searchValue}. This method is expected to implement its own replacement algorithm.\n     * @param searchValue An object that supports searching for and replacing matches within a string.\n     * @param replaceValue The replacement text.\n     */\n    replace(searchValue: { [Symbol.replace](string: string, replaceValue: string): string; }, replaceValue: string): string;\n\n    /**\n     * Replaces text in a string, using an object that supports replacement within a string.\n     * @param searchValue A object can search for and replace matches within a string.\n     * @param replacer A function that returns the replacement text.\n     */\n    replace(searchValue: { [Symbol.replace](string: string, replacer: (substring: string, ...args: any[]) => string): string; }, replacer: (substring: string, ...args: any[]) => string): string;\n\n    /**\n     * Finds the first substring match in a regular expression search.\n     * @param searcher An object which supports searching within a string.\n     */\n    search(searcher: { [Symbol.search](string: string): number; }): number;\n\n    /**\n     * Split a string into substrings using the specified separator and return them as an array.\n     * @param splitter An object that can split a string.\n     * @param limit A value used to limit the number of elements returned in the array.\n     */\n    split(splitter: { [Symbol.split](string: string, limit?: number): string[]; }, limit?: number): string[];\n}\n\ninterface ArrayBuffer {\n    readonly [Symbol.toStringTag]: string;\n}\n\ninterface DataView {\n    readonly [Symbol.toStringTag]: string;\n}\n\ninterface Int8Array {\n    readonly [Symbol.toStringTag]: \"Int8Array\";\n}\n\ninterface Uint8Array {\n    readonly [Symbol.toStringTag]: \"Uint8Array\";\n}\n\ninterface Uint8ClampedArray {\n    readonly [Symbol.toStringTag]: \"Uint8ClampedArray\";\n}\n\ninterface Int16Array {\n    readonly [Symbol.toStringTag]: \"Int16Array\";\n}\n\ninterface Uint16Array {\n    readonly [Symbol.toStringTag]: \"Uint16Array\";\n}\n\ninterface Int32Array {\n    readonly [Symbol.toStringTag]: \"Int32Array\";\n}\n\ninterface Uint32Array {\n    readonly [Symbol.toStringTag]: \"Uint32Array\";\n}\n\ninterface Float32Array {\n    readonly [Symbol.toStringTag]: \"Float32Array\";\n}\n\ninterface Float64Array {\n    readonly [Symbol.toStringTag]: \"Float64Array\";\n}\n\ninterface ArrayConstructor {\n    readonly [Symbol.species]: ArrayConstructor;\n}\ninterface MapConstructor {\n    readonly [Symbol.species]: MapConstructor;\n}\ninterface SetConstructor {\n    readonly [Symbol.species]: SetConstructor;\n}\ninterface ArrayBufferConstructor {\n    readonly [Symbol.species]: ArrayBufferConstructor;\n}\n";
libFileMap['lib.es2016.array.include.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\ninterface Array<T> {\n    /**\n     * Determines whether an array includes a certain element, returning true or false as appropriate.\n     * @param searchElement The element to search for.\n     * @param fromIndex The position in this array at which to begin searching for searchElement.\n     */\n    includes(searchElement: T, fromIndex?: number): boolean;\n}\n\ninterface ReadonlyArray<T> {\n    /**\n     * Determines whether an array includes a certain element, returning true or false as appropriate.\n     * @param searchElement The element to search for.\n     * @param fromIndex The position in this array at which to begin searching for searchElement.\n     */\n    includes(searchElement: T, fromIndex?: number): boolean;\n}\n\ninterface Int8Array {\n    /**\n     * Determines whether an array includes a certain element, returning true or false as appropriate.\n     * @param searchElement The element to search for.\n     * @param fromIndex The position in this array at which to begin searching for searchElement.\n     */\n    includes(searchElement: number, fromIndex?: number): boolean;\n}\n\ninterface Uint8Array {\n    /**\n     * Determines whether an array includes a certain element, returning true or false as appropriate.\n     * @param searchElement The element to search for.\n     * @param fromIndex The position in this array at which to begin searching for searchElement.\n     */\n    includes(searchElement: number, fromIndex?: number): boolean;\n}\n\ninterface Uint8ClampedArray {\n    /**\n     * Determines whether an array includes a certain element, returning true or false as appropriate.\n     * @param searchElement The element to search for.\n     * @param fromIndex The position in this array at which to begin searching for searchElement.\n     */\n    includes(searchElement: number, fromIndex?: number): boolean;\n}\n\ninterface Int16Array {\n    /**\n     * Determines whether an array includes a certain element, returning true or false as appropriate.\n     * @param searchElement The element to search for.\n     * @param fromIndex The position in this array at which to begin searching for searchElement.\n     */\n    includes(searchElement: number, fromIndex?: number): boolean;\n}\n\ninterface Uint16Array {\n    /**\n     * Determines whether an array includes a certain element, returning true or false as appropriate.\n     * @param searchElement The element to search for.\n     * @param fromIndex The position in this array at which to begin searching for searchElement.\n     */\n    includes(searchElement: number, fromIndex?: number): boolean;\n}\n\ninterface Int32Array {\n    /**\n     * Determines whether an array includes a certain element, returning true or false as appropriate.\n     * @param searchElement The element to search for.\n     * @param fromIndex The position in this array at which to begin searching for searchElement.\n     */\n    includes(searchElement: number, fromIndex?: number): boolean;\n}\n\ninterface Uint32Array {\n    /**\n     * Determines whether an array includes a certain element, returning true or false as appropriate.\n     * @param searchElement The element to search for.\n     * @param fromIndex The position in this array at which to begin searching for searchElement.\n     */\n    includes(searchElement: number, fromIndex?: number): boolean;\n}\n\ninterface Float32Array {\n    /**\n     * Determines whether an array includes a certain element, returning true or false as appropriate.\n     * @param searchElement The element to search for.\n     * @param fromIndex The position in this array at which to begin searching for searchElement.\n     */\n    includes(searchElement: number, fromIndex?: number): boolean;\n}\n\ninterface Float64Array {\n    /**\n     * Determines whether an array includes a certain element, returning true or false as appropriate.\n     * @param searchElement The element to search for.\n     * @param fromIndex The position in this array at which to begin searching for searchElement.\n     */\n    includes(searchElement: number, fromIndex?: number): boolean;\n}";
libFileMap['lib.es2016.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\n/// <reference lib=\"es2015\" />\n/// <reference lib=\"es2016.array.include\" />";
libFileMap['lib.es2016.full.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\n/// <reference lib=\"es2016\" />\n/// <reference lib=\"dom\" />\n/// <reference lib=\"webworker.importscripts\" />\n/// <reference lib=\"scripthost\" />\n/// <reference lib=\"dom.iterable\" />";
libFileMap['lib.es2017.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\n/// <reference lib=\"es2016\" />\n/// <reference lib=\"es2017.object\" />\n/// <reference lib=\"es2017.sharedmemory\" />\n/// <reference lib=\"es2017.string\" />\n/// <reference lib=\"es2017.intl\" />\n/// <reference lib=\"es2017.typedarrays\" />\n";
libFileMap['lib.es2017.full.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\n/// <reference lib=\"es2017\" />\n/// <reference lib=\"dom\" />\n/// <reference lib=\"webworker.importscripts\" />\n/// <reference lib=\"scripthost\" />\n/// <reference lib=\"dom.iterable\" />";
libFileMap['lib.es2017.intl.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\ndeclare namespace Intl {\n\n    interface DateTimeFormatPartTypesRegistry {\n        day: any\n        dayPeriod: any\n        era: any\n        hour: any\n        literal: any\n        minute: any\n        month: any\n        second: any\n        timeZoneName: any\n        weekday: any\n        year: any\n    }\n\n    type DateTimeFormatPartTypes = keyof DateTimeFormatPartTypesRegistry;\n\n    interface DateTimeFormatPart {\n        type: DateTimeFormatPartTypes;\n        value: string;\n    }\n\n    interface DateTimeFormat {\n        formatToParts(date?: Date | number): DateTimeFormatPart[];\n    }\n}\n";
libFileMap['lib.es2017.object.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\ninterface ObjectConstructor {\n    /**\n     * Returns an array of values of the enumerable properties of an object\n     * @param o Object that contains the properties and methods. This can be an object that you created or an existing Document Object Model (DOM) object.\n     */\n    values<T>(o: { [s: string]: T } | ArrayLike<T>): T[];\n\n    /**\n     * Returns an array of values of the enumerable properties of an object\n     * @param o Object that contains the properties and methods. This can be an object that you created or an existing Document Object Model (DOM) object.\n     */\n    values(o: {}): any[];\n\n    /**\n     * Returns an array of key/values of the enumerable properties of an object\n     * @param o Object that contains the properties and methods. This can be an object that you created or an existing Document Object Model (DOM) object.\n     */\n    entries<T>(o: { [s: string]: T } | ArrayLike<T>): [string, T][];\n\n    /**\n     * Returns an array of key/values of the enumerable properties of an object\n     * @param o Object that contains the properties and methods. This can be an object that you created or an existing Document Object Model (DOM) object.\n     */\n    entries(o: {}): [string, any][];\n\n    /**\n     * Returns an object containing all own property descriptors of an object\n     * @param o Object that contains the properties and methods. This can be an object that you created or an existing Document Object Model (DOM) object.\n     */\n    getOwnPropertyDescriptors<T>(o: T): {[P in keyof T]: TypedPropertyDescriptor<T[P]>} & { [x: string]: PropertyDescriptor };\n}\n";
libFileMap['lib.es2017.sharedmemory.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\n/// <reference lib=\"es2015.symbol\" />\n/// <reference lib=\"es2015.symbol.wellknown\" />\n\ninterface SharedArrayBuffer {\n    /**\n     * Read-only. The length of the ArrayBuffer (in bytes).\n     */\n    readonly byteLength: number;\n\n    /**\n     * Returns a section of an SharedArrayBuffer.\n     */\n    slice(begin: number, end?: number): SharedArrayBuffer;\n    readonly [Symbol.species]: SharedArrayBuffer;\n    readonly [Symbol.toStringTag]: \"SharedArrayBuffer\";\n}\n\ninterface SharedArrayBufferConstructor {\n    readonly prototype: SharedArrayBuffer;\n    new (byteLength: number): SharedArrayBuffer;\n}\ndeclare var SharedArrayBuffer: SharedArrayBufferConstructor;\n\ninterface ArrayBufferTypes {\n    SharedArrayBuffer: SharedArrayBuffer;\n}\n\ninterface Atomics {\n    /**\n     * Adds a value to the value at the given position in the array, returning the original value.\n     * Until this atomic operation completes, any other read or write operation against the array\n     * will block.\n     */\n    add(typedArray: Int8Array | Uint8Array | Int16Array | Uint16Array | Int32Array | Uint32Array, index: number, value: number): number;\n\n    /**\n     * Stores the bitwise AND of a value with the value at the given position in the array,\n     * returning the original value. Until this atomic operation completes, any other read or\n     * write operation against the array will block.\n     */\n    and(typedArray: Int8Array | Uint8Array | Int16Array | Uint16Array | Int32Array | Uint32Array, index: number, value: number): number;\n\n    /**\n     * Replaces the value at the given position in the array if the original value equals the given\n     * expected value, returning the original value. Until this atomic operation completes, any\n     * other read or write operation against the array will block.\n     */\n    compareExchange(typedArray: Int8Array | Uint8Array | Int16Array | Uint16Array | Int32Array | Uint32Array, index: number, expectedValue: number, replacementValue: number): number;\n\n    /**\n     * Replaces the value at the given position in the array, returning the original value. Until\n     * this atomic operation completes, any other read or write operation against the array will\n     * block.\n     */\n    exchange(typedArray: Int8Array | Uint8Array | Int16Array | Uint16Array | Int32Array | Uint32Array, index: number, value: number): number;\n\n    /**\n     * Returns a value indicating whether high-performance algorithms can use atomic operations\n     * (`true`) or must use locks (`false`) for the given number of bytes-per-element of a typed\n     * array.\n     */\n    isLockFree(size: number): boolean;\n\n    /**\n     * Returns the value at the given position in the array. Until this atomic operation completes,\n     * any other read or write operation against the array will block.\n     */\n    load(typedArray: Int8Array | Uint8Array | Int16Array | Uint16Array | Int32Array | Uint32Array, index: number): number;\n\n    /**\n     * Stores the bitwise OR of a value with the value at the given position in the array,\n     * returning the original value. Until this atomic operation completes, any other read or write\n     * operation against the array will block.\n     */\n    or(typedArray: Int8Array | Uint8Array | Int16Array | Uint16Array | Int32Array | Uint32Array, index: number, value: number): number;\n\n    /**\n     * Stores a value at the given position in the array, returning the new value. Until this\n     * atomic operation completes, any other read or write operation against the array will block.\n     */\n    store(typedArray: Int8Array | Uint8Array | Int16Array | Uint16Array | Int32Array | Uint32Array, index: number, value: number): number;\n\n    /**\n     * Subtracts a value from the value at the given position in the array, returning the original\n     * value. Until this atomic operation completes, any other read or write operation against the\n     * array will block.\n     */\n    sub(typedArray: Int8Array | Uint8Array | Int16Array | Uint16Array | Int32Array | Uint32Array, index: number, value: number): number;\n\n    /**\n     * If the value at the given position in the array is equal to the provided value, the current\n     * agent is put to sleep causing execution to suspend until the timeout expires (returning\n     * `\"timed-out\"`) or until the agent is awoken (returning `\"ok\"`); otherwise, returns\n     * `\"not-equal\"`.\n     */\n    wait(typedArray: Int32Array, index: number, value: number, timeout?: number): \"ok\" | \"not-equal\" | \"timed-out\";\n\n    /**\n     * Wakes up sleeping agents that are waiting on the given index of the array, returning the\n     * number of agents that were awoken.\n     * @param typedArray A shared Int32Array.\n     * @param index The position in the typedArray to wake up on.\n     * @param count The number of sleeping agents to notify. Defaults to +Infinity.\n     */\n    notify(typedArray: Int32Array, index: number, count?: number): number;\n\n    /**\n     * Stores the bitwise XOR of a value with the value at the given position in the array,\n     * returning the original value. Until this atomic operation completes, any other read or write\n     * operation against the array will block.\n     */\n    xor(typedArray: Int8Array | Uint8Array | Int16Array | Uint16Array | Int32Array | Uint32Array, index: number, value: number): number;\n\n    readonly [Symbol.toStringTag]: \"Atomics\";\n}\n\ndeclare var Atomics: Atomics;\n";
libFileMap['lib.es2017.string.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\ninterface String {\n    /**\n     * Pads the current string with a given string (possibly repeated) so that the resulting string reaches a given length.\n     * The padding is applied from the start (left) of the current string.\n     *\n     * @param maxLength The length of the resulting string once the current string has been padded.\n     *        If this parameter is smaller than the current string's length, the current string will be returned as it is.\n     *\n     * @param fillString The string to pad the current string with.\n     *        If this string is too long, it will be truncated and the left-most part will be applied.\n     *        The default value for this parameter is \" \" (U+0020).\n     */\n    padStart(maxLength: number, fillString?: string): string;\n\n    /**\n     * Pads the current string with a given string (possibly repeated) so that the resulting string reaches a given length.\n     * The padding is applied from the end (right) of the current string.\n     *\n     * @param maxLength The length of the resulting string once the current string has been padded.\n     *        If this parameter is smaller than the current string's length, the current string will be returned as it is.\n     *\n     * @param fillString The string to pad the current string with.\n     *        If this string is too long, it will be truncated and the left-most part will be applied.\n     *        The default value for this parameter is \" \" (U+0020).\n     */\n    padEnd(maxLength: number, fillString?: string): string;\n}\n";
libFileMap['lib.es2017.typedarrays.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\ninterface Int8ArrayConstructor {\n    new (): Int8Array;\n}\n\ninterface Uint8ArrayConstructor {\n    new (): Uint8Array;\n}\n\ninterface Uint8ClampedArrayConstructor {\n    new (): Uint8ClampedArray;\n}\n\ninterface Int16ArrayConstructor {\n    new (): Int16Array;\n}\n\ninterface Uint16ArrayConstructor {\n    new (): Uint16Array;\n}\n\ninterface Int32ArrayConstructor {\n    new (): Int32Array;\n}\n\ninterface Uint32ArrayConstructor {\n    new (): Uint32Array;\n}\n\ninterface Float32ArrayConstructor {\n    new (): Float32Array;\n}\n\ninterface Float64ArrayConstructor {\n    new (): Float64Array;\n}\n";
libFileMap['lib.es2018.asyncgenerator.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\n/// <reference lib=\"es2018.asynciterable\" />\n\ninterface AsyncGenerator<T = unknown, TReturn = any, TNext = unknown> extends AsyncIterator<T, TReturn, TNext> {\n    // NOTE: 'next' is defined using a tuple to ensure we report the correct assignability errors in all places.\n    next(...args: [] | [TNext]): Promise<IteratorResult<T, TReturn>>;\n    return(value: TReturn | PromiseLike<TReturn>): Promise<IteratorResult<T, TReturn>>;\n    throw(e: any): Promise<IteratorResult<T, TReturn>>;\n    [Symbol.asyncIterator](): AsyncGenerator<T, TReturn, TNext>;\n}\n\ninterface AsyncGeneratorFunction {\n    /**\n     * Creates a new AsyncGenerator object.\n     * @param args A list of arguments the function accepts.\n     */\n    new (...args: any[]): AsyncGenerator;\n    /**\n     * Creates a new AsyncGenerator object.\n     * @param args A list of arguments the function accepts.\n     */\n    (...args: any[]): AsyncGenerator;\n    /**\n     * The length of the arguments.\n     */\n    readonly length: number;\n    /**\n     * Returns the name of the function.\n     */\n    readonly name: string;\n    /**\n     * A reference to the prototype.\n     */\n    readonly prototype: AsyncGenerator;\n}\n\ninterface AsyncGeneratorFunctionConstructor {\n    /**\n     * Creates a new AsyncGenerator function.\n     * @param args A list of arguments the function accepts.\n     */\n    new (...args: string[]): AsyncGeneratorFunction;\n    /**\n     * Creates a new AsyncGenerator function.\n     * @param args A list of arguments the function accepts.\n     */\n    (...args: string[]): AsyncGeneratorFunction;\n    /**\n     * The length of the arguments.\n     */\n    readonly length: number;\n    /**\n     * Returns the name of the function.\n     */\n    readonly name: string;\n    /**\n     * A reference to the prototype.\n     */\n    readonly prototype: AsyncGeneratorFunction;\n}\n";
libFileMap['lib.es2018.asynciterable.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\n/// <reference lib=\"es2015.symbol\" />\n/// <reference lib=\"es2015.iterable\" />\n\ninterface SymbolConstructor {\n    /**\n     * A method that returns the default async iterator for an object. Called by the semantics of\n     * the for-await-of statement.\n     */\n    readonly asyncIterator: unique symbol;\n}\n\ninterface AsyncIterator<T, TReturn = any, TNext = undefined> {\n    // NOTE: 'next' is defined using a tuple to ensure we report the correct assignability errors in all places.\n    next(...args: [] | [TNext]): Promise<IteratorResult<T, TReturn>>;\n    return?(value?: TReturn | PromiseLike<TReturn>): Promise<IteratorResult<T, TReturn>>;\n    throw?(e?: any): Promise<IteratorResult<T, TReturn>>;\n}\n\ninterface AsyncIterable<T> {\n    [Symbol.asyncIterator](): AsyncIterator<T>;\n}\n\ninterface AsyncIterableIterator<T> extends AsyncIterator<T> {\n    [Symbol.asyncIterator](): AsyncIterableIterator<T>;\n}";
libFileMap['lib.es2018.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\n/// <reference lib=\"es2017\" />\n/// <reference lib=\"es2018.asynciterable\" />\n/// <reference lib=\"es2018.asyncgenerator\" />\n/// <reference lib=\"es2018.promise\" />\n/// <reference lib=\"es2018.regexp\" />\n/// <reference lib=\"es2018.intl\" />\n";
libFileMap['lib.es2018.full.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\n/// <reference lib=\"es2018\" />\n/// <reference lib=\"dom\" />\n/// <reference lib=\"webworker.importscripts\" />\n/// <reference lib=\"scripthost\" />\n/// <reference lib=\"dom.iterable\" />";
libFileMap['lib.es2018.intl.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\ndeclare namespace Intl {\n\n    // http://cldr.unicode.org/index/cldr-spec/plural-rules#TOC-Determining-Plural-Categories\n    type LDMLPluralRule = \"zero\" | \"one\" | \"two\" | \"few\" | \"many\" | \"other\";\n    type PluralRuleType = \"cardinal\" | \"ordinal\";\n\n    interface PluralRulesOptions {\n        localeMatcher?: \"lookup\" | \"best fit\" | undefined;\n        type?: PluralRuleType | undefined;\n        minimumIntegerDigits?: number | undefined;\n        minimumFractionDigits?: number | undefined;\n        maximumFractionDigits?: number | undefined;\n        minimumSignificantDigits?: number | undefined;\n        maximumSignificantDigits?: number | undefined;\n    }\n\n    interface ResolvedPluralRulesOptions {\n        locale: string;\n        pluralCategories: LDMLPluralRule[];\n        type: PluralRuleType;\n        minimumIntegerDigits: number;\n        minimumFractionDigits: number;\n        maximumFractionDigits: number;\n        minimumSignificantDigits?: number;\n        maximumSignificantDigits?: number;\n    }\n\n    interface PluralRules {\n        resolvedOptions(): ResolvedPluralRulesOptions;\n        select(n: number): LDMLPluralRule;\n    }\n\n    const PluralRules: {\n        new (locales?: string | string[], options?: PluralRulesOptions): PluralRules;\n        (locales?: string | string[], options?: PluralRulesOptions): PluralRules;\n\n        supportedLocalesOf(locales: string | string[], options?: { localeMatcher?: \"lookup\" | \"best fit\" }): string[];\n    };\n\n    // We can only have one definition for 'type' in TypeScript, and so you can learn where the keys come from here:\n    type ES2018NumberFormatPartType = \"literal\" | \"nan\" | \"infinity\" | \"percent\" | \"integer\" | \"group\" | \"decimal\" | \"fraction\" | \"plusSign\" | \"minusSign\" | \"percentSign\" | \"currency\" | \"code\" | \"symbol\" | \"name\";\n    type ES2020NumberFormatPartType = \"compact\" | \"exponentInteger\" | \"exponentMinusSign\" | \"exponentSeparator\" | \"unit\" | \"unknown\";\n    type NumberFormatPartTypes = ES2018NumberFormatPartType | ES2020NumberFormatPartType;\n\n    interface NumberFormatPart {\n        type: NumberFormatPartTypes;\n        value: string;\n    }\n\n    interface NumberFormat {\n        formatToParts(number?: number | bigint): NumberFormatPart[];\n    }\n}\n";
libFileMap['lib.es2018.promise.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\n/**\n * Represents the completion of an asynchronous operation\n */\ninterface Promise<T> {\n    /**\n     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The\n     * resolved value cannot be modified from the callback.\n     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).\n     * @returns A Promise for the completion of the callback.\n     */\n    finally(onfinally?: (() => void) | undefined | null): Promise<T>\n}\n";
libFileMap['lib.es2018.regexp.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\ninterface RegExpMatchArray {\n    groups?: {\n        [key: string]: string\n    }\n}\n\ninterface RegExpExecArray {\n    groups?: {\n        [key: string]: string\n    }\n}\n\ninterface RegExp {\n    /**\n     * Returns a Boolean value indicating the state of the dotAll flag (s) used with a regular expression.\n     * Default is false. Read-only.\n     */\n    readonly dotAll: boolean;\n}";
libFileMap['lib.es2019.array.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\ntype FlatArray<Arr, Depth extends number> = {\n    \"done\": Arr,\n    \"recur\": Arr extends ReadonlyArray<infer InnerArr>\n        ? FlatArray<InnerArr, [-1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20][Depth]>\n        : Arr\n}[Depth extends -1 ? \"done\" : \"recur\"];\n\ninterface ReadonlyArray<T> {\n\n    /**\n     * Calls a defined callback function on each element of an array. Then, flattens the result into\n     * a new array.\n     * This is identical to a map followed by flat with depth 1.\n     *\n     * @param callback A function that accepts up to three arguments. The flatMap method calls the\n     * callback function one time for each element in the array.\n     * @param thisArg An object to which the this keyword can refer in the callback function. If\n     * thisArg is omitted, undefined is used as the this value.\n     */\n    flatMap<U, This = undefined> (\n        callback: (this: This, value: T, index: number, array: T[]) => U | ReadonlyArray<U>,\n        thisArg?: This\n    ): U[]\n\n\n    /**\n     * Returns a new array with all sub-array elements concatenated into it recursively up to the\n     * specified depth.\n     *\n     * @param depth The maximum recursion depth\n     */\n    flat<A, D extends number = 1>(\n        this: A,\n        depth?: D\n    ): FlatArray<A, D>[]\n  }\n\ninterface Array<T> {\n\n    /**\n     * Calls a defined callback function on each element of an array. Then, flattens the result into\n     * a new array.\n     * This is identical to a map followed by flat with depth 1.\n     *\n     * @param callback A function that accepts up to three arguments. The flatMap method calls the\n     * callback function one time for each element in the array.\n     * @param thisArg An object to which the this keyword can refer in the callback function. If\n     * thisArg is omitted, undefined is used as the this value.\n     */\n    flatMap<U, This = undefined> (\n        callback: (this: This, value: T, index: number, array: T[]) => U | ReadonlyArray<U>,\n        thisArg?: This\n    ): U[]\n\n    /**\n     * Returns a new array with all sub-array elements concatenated into it recursively up to the\n     * specified depth.\n     *\n     * @param depth The maximum recursion depth\n     */\n    flat<A, D extends number = 1>(\n        this: A,\n        depth?: D\n    ): FlatArray<A, D>[]\n}\n";
libFileMap['lib.es2019.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\n/// <reference lib=\"es2018\" />\n/// <reference lib=\"es2019.array\" />\n/// <reference lib=\"es2019.object\" />\n/// <reference lib=\"es2019.string\" />\n/// <reference lib=\"es2019.symbol\" />\n/// <reference lib=\"es2019.intl\" />\n";
libFileMap['lib.es2019.full.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\n/// <reference lib=\"es2019\" />\n/// <reference lib=\"dom\" />\n/// <reference lib=\"webworker.importscripts\" />\n/// <reference lib=\"scripthost\" />\n/// <reference lib=\"dom.iterable\" />\n";
libFileMap['lib.es2019.intl.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\ndeclare namespace Intl {\n    interface DateTimeFormatPartTypesRegistry {\n        unknown: any\n    }\n}\n";
libFileMap['lib.es2019.object.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\n/// <reference lib=\"es2015.iterable\" />\n\ninterface ObjectConstructor {\n    /**\n     * Returns an object created by key-value entries for properties and methods\n     * @param entries An iterable object that contains key-value entries for properties and methods.\n     */\n    fromEntries<T = any>(entries: Iterable<readonly [PropertyKey, T]>): { [k: string]: T };\n\n    /**\n     * Returns an object created by key-value entries for properties and methods\n     * @param entries An iterable object that contains key-value entries for properties and methods.\n     */\n    fromEntries(entries: Iterable<readonly any[]>): any;\n}\n";
libFileMap['lib.es2019.string.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\ninterface String {\n    /** Removes the trailing white space and line t