import React from 'react';
import { assert } from 'chai';
import { createShallow, getClasses } from '@material-ui/core/test-utils';
import DialogTitle from './DialogTitle';

describe('<DialogTitle />', () => {
  let shallow;
  let classes;

  before(() => {
    shallow = createShallow({ dive: true });
    classes = getClasses(<DialogTitle>foo</DialogTitle>);
  });

  it('should render a div', () => {
    const wrapper = shallow(<DialogTitle>foo</DialogTitle>);
    assert.strictEqual(wrapper.name(), 'div');
  });

  it('should spread custom props on the root node', () => {
    const wrapper = shallow(<DialogTitle data-my-prop="woofDialogTitle">foo</DialogTitle>);
    assert.strictEqual(
      wrapper.props()['data-my-prop'],
      'woofDialogTitle',
      'custom prop should be woofDialogTitle',
    );
  });

  it('should render with the user and root classes', () => {
    const wrapper = shallow(<DialogTitle className="woofDialogTitle">foo</DialogTitle>);
    assert.strictEqual(wrapper.hasClass('woofDialogTitle'), true);
    assert.strictEqual(wrapper.hasClass(classes.root), true);
  });

  it('should render JSX children', () => {
    const children = <p className="test">Hello</p>;
    const wrapper = shallow(<DialogTitle disableTypography>{children}</DialogTitle>);
    assert.strictEqual(wrapper.childAt(0).equals(children), true);
  });

  it('should render string children as given string', () => {
    const children = 'Hello';
    const wrapper = shallow(<DialogTitle>{children}</DialogTitle>);
    assert.strictEqual(wrapper.childAt(0).props().children, children);
  });
});
