---
title: Componente React para Barra de Aplicativos
components: AppBar, Toolbar, Menu
---
# App Bar (Barra de Aplicativos)

<p class="description">O App Bar exibe informação e ações relacionadas à tela atual.</p>

O [App Bar superior](https://material.io/design/components/app-bars-top.html) provê conteúdo e ações relacionados à tela atual. Ele é utilizado para a identidade visual, títulos de tela, navegação, e ações.

Ele pode se transformar em uma barra de ações contextual ou utilizado como uma barra de navegação.

## Barra de Aplicativos com botões

{{"demo": "pages/demos/app-bar/ButtonAppBar.js"}}

## Barra de Aplicativos simples

{{"demo": "pages/demos/app-bar/SimpleAppBar.js"}}

## Barra de Aplicativos com um campo de busca principal

Um campo de busca principal.

{{"demo": "pages/demos/app-bar/PrimarySearchAppBar.js"}}

## Barra de Aplicativos com menu

{{"demo": "pages/demos/app-bar/MenuAppBar.js"}}

## Barra de Aplicativos com campo de busca

Uma barra de pesquisa na lateral.

{{"demo": "pages/demos/app-bar/SearchAppBar.js"}}

## Barra de Aplicativos densa (apenas para desktop)

{{"demo": "pages/demos/app-bar/DenseAppBar.js"}}

## Barra de Aplicativos inferior

{{"demo": "pages/demos/app-bar/BottomAppBar.js", "iframe": true}}