---
title: App Bar React component
components: AppBar, Toolbar, Menu
---

# App Bar

<p class="description">The App Bar displays information and actions relating to the current screen.</p>

The [top App Bar](https://material.io/design/components/app-bars-top.html) provides content and actions related to the current screen. It’s used for branding, screen titles, navigation, and actions.

It can transform into a contextual action bar or used as a navbar.

## App Bar with buttons

{{"demo": "pages/demos/app-bar/ButtonAppBar.js"}}

## Simple App Bar

{{"demo": "pages/demos/app-bar/SimpleAppBar.js"}}

## App Bar with a primary search field

A primary searchbar.

{{"demo": "pages/demos/app-bar/PrimarySearchAppBar.js"}}

## App Bar with menu

{{"demo": "pages/demos/app-bar/MenuAppBar.js"}}

## App Bar with search field

A side searchbar.

{{"demo": "pages/demos/app-bar/SearchAppBar.js"}}

## Dense (desktop only)

{{"demo": "pages/demos/app-bar/DenseAppBar.js"}}

## Bottom App Bar

{{"demo": "pages/demos/app-bar/BottomAppBar.js", "iframe": true}}
