# 相关项目

<p class="description">我们精心策划了一系列值得一看的图书馆。</p>

因为Material-UI解决的问题范围有限，我们尝试与其他库很好地协作. 随意提交pull-request来添加更多的项目; 如果符合我们的标准, 我们将接受他们。

## Material-UI 特定项目

- [create-mui-theme](https://react-theming.github.io/create-mui-theme/) 用于通过Material Design Color Tool创建Material-UI主题的在线工具
- [dx-react-chart-material-ui](https://devexpress.github.io/devextreme-reactive/react/chart/) Material-UI图表，使用各种系列类型可视化数据，包括条形图，折线图，面积图，散点图，饼图等（[自定义许可证](https://js.devexpress.com/licensing/)）。
- [ dx-react-grid-material-ui ](https://devexpress.github.io/devextreme-reactive/react/grid/) Material-UI 的一种数据表格, 具有分页，排序功能, 过滤, 分组和编辑功能([自定义许可](https://js.devexpress.com/licensing/))。
- [final-form-material-ui](https://github.com/Deadly0/final-form-material-ui) 用于更加方便地与Final Form配搭来使用Material UI的一组包装组件。
- [formik-material-ui](https://github.com/stackworx/formik-material-ui) 用于结合formik来使用Material-UI的绑定。
- - [material-table](https://github.com/mbrn/material-table) DataTable 是基于表格组件, 具有搜索,过滤,排序等附加功能。
- [material-ui-autosuggest](https://github.com/plan-three/material-ui-autosuggest) React和Material-UI的模糊搜索组件。
- [material-ui-next-Pickers](https://github.com/chingyawhao/material-ui-next-pickers) Material UI中的datepicker或timepicker Next或者可以作为时钟或日历组件导入。
- [material-ui-Pickers](https://github.com/dmtrKovalenko/material-ui-pickers) 为Material-UI实现Material Design日期和时间选择器的组件。
- [material-ui-popup-state](https://github.com/jcoreio/material-ui-popup-state) 渲染道具组件，管理菜单，弹出窗口和弹出窗口的状态，显着减少样板。
- [material-ui-theme-editor](https://in-your-saas.github.io/material-ui-theme-editor/) 一款只需要选择颜色即可为你的 Material-UI 应用生成主题的工具，同时还支持在线预览。
- [material-ui-time-picker](https://github.com/TeamWertarbyte/material-ui-time-picker) 适用于Material-UI的TimePicker。
- [mui-datatables](https://github.com/gregnb/mui-datatables) Material-UI 的响应式数据表格,包括过滤,排序,搜索等功能.
- [mui-downshift](https://github.com/techniq/mui-downshift) 在paypal的降档上使用Material-UI可视组件的薄层。
- [notistack](https://github.com/iamhosseindhv/notistack) 高度可定制的通知零食栏，可以堆叠在一起
- [react-material-ui-typescript](https://github.com/goemen/react-material-ui-typescript) 使用Typescript，Material UI和Redux，React Router进行React的样板。
- [react-media-material-ui](https://github.com/jcoreio/react-media-material-ui) 使用 [反应介质](https://github.com/ReactTraining/react-media)轻松使用Material-UI主题中的断点。
- [redux-form-material-ui](https://github.com/erikras/redux-form-material-ui) 用于更加方便地与Redux Form配搭来使用Material UI的一组包装组件。
- [uniforms-material](https://github.com/vazco/uniforms/tree/master/packages/uniforms-material) Uniforms的Material-UI包装组件。
- [Wertarbyte](https://mui.wertarbyte.com/) Wertarbyte正在为他们的许多项目使用Material-UI。 这是他们构建的补充组件的集合。
- [高级过滤器构建器](https://github.com/logipro/logi-filter-builder) 组件将帮助您的用户创建强大的过滤器标准。

## 补充项目

- [downshift](https://github.com/paypal/downshift) 用于构建简单，灵活，符合WAI-ARIA标准的增强型输入React组件的原型
- [react-admin](https://github.com/marmelab/react-admin) 将材料-ui与Redux，redux-form，redux-saga和重新组合相结合的管理框架
- [react-autosuggest](https://github.com/moroshko/react-autosuggest) 符合WAI-ARIA标准的React autosuggest组件。
- [react-final-form](https://github.com/final-form/react-final-form#material-ui-10) React的基于订阅的表单状态管理。
- [反应最需要的](https://github.com/TarikHuber/react-most-wanted) 入门套件，使用Material-UI，CRA，Redux，Firebase和所有“最想要的”功能。
- [react-number-format](https://github.com/s-yadav/react-number-format) React组件，用于格式化输入中的数字或文本。
- [react-popper](https://github.com/FezVrasta/react-popper) 反映PopperJS的包装。
- [react-swipeable-views](https://github.com/oliviertassinari/react-swipeable-views) 可滑动视图的React组件。 使用 `Tabs` 组件可以很好地播放。
- [react-text-mask](https://github.com/text-mask/text-mask) React，Angular，Ember，Vue， & 普通JavaScript的输入掩码。
- [redux-form](https://redux-form.com/7.3.0/examples/material-ui/) 在Redux中管理你的表单状态。
- [制服](https://github.com/vazco/uniforms) 用于构建表单的一组React库。