# Supported Components

<p class="description">The following is a list of Material Design components & features. Those currently supported by Material-UI are highlighted ✓.</p>

While we strive to follow the guidelines where practical (applying common sense where guidelines contradict - a more common occurrence than one might expect), we do not expect to support every component, or every feature of every component, but rather to provide the building blocks to allow developers to create compelling user interfaces and experiences.

If you wish to add support for a component or feature not highlighted here, please search for the relevant [GitHub Issue](https://github.com/mui-org/material-ui/issues), or create a new one to discuss the approach before submitting a pull request.

- App bars 
  - **[Top](https://material.io/design/components/app-bars-top.html) ✓**
  - **[Bottom](https://material.io/design/components/app-bars-bottom.html) ✓**
- **[Banners](https://material.io/design/components/banners.html)** ([Pode ser composto](https://medium.com/material-ui/introducing-material-ui-design-system-93e921beb8df))
- **[Bottom navigation](https://material.io/design/components/bottom-navigation.html) ✓**
- **[Buttons](https://material.io/design/components/buttons.html) ✓** 
  - **[Texto & contidas botões (Antigamente flat & raised)](https://material.io/design/components/buttons.html) ✓**
  - **[Toggle buttons](https://material.io/design/components/buttons.html#buttons-toggle-buttons) ~** ([Lab](/lab/about/))
  - **[Icon toggle buttons](https://material.io/design/components/buttons.html#toggle-button) ✓** (Custom Checkbox)
- **[Buttons: Floating Action Button](https://material.io/design/components/buttons-floating-action-button.html) ✓** 
  - Transições: 
    - **[Speed dial](https://material.io/design/components/buttons-floating-action-button.html#types-of-transitions) ~** ([Lab](/lab/about/))
    - [Menu](https://material.io/design/components/buttons-floating-action-button.html#types-of-transitions)
    - [Morph](https://material.io/design/components/buttons-floating-action-button.html#types-of-transitions)
    - [Full screen](https://material.io/design/components/buttons-floating-action-button.html#types-of-transitions)
  - **[Extended FAB](https://material.io/design/components/buttons-floating-action-button.html#extended-fab) ✓** 
    - Speed dial
- **[Cards](https://material.io/design/components/cards.html) ✓**
- **[Chips](https://material.io/design/components/chips.html) ✓** 
  - **[Input](https://material.io/design/components/chips.html#input-chips) ✓**
  - [Choice](https://material.io/design/components/chips.html#choice-chips)
  - [Filter](https://material.io/design/components/chips.html#filter-chips)
  - [Action](https://material.io/design/components/chips.html#action-chips)
- **[Data tables](https://material.io/design/components/data-tables.html) ✓** 
  - **Sortable ✓**
  - **Selectable ✓**
  - **Pagination ✓**
- **[Dialogs](https://material.io/design/components/dialogs.html) ✓** 
  - **[Alert dialog](https://material.io/design/components/dialogs.html#alert-dialog) ✓**
  - **[Diálogos simples](https://material.io/design/components/dialogs.html#simple-dialog) ✓** (Pode ser composto com Dialog e a List.)
  - **[Confirmation dialogs](https://material.io/design/components/dialogs.html#confirmation-dialog) ✓**
  - **[Full screen dialogs](https://material.io/design/components/dialogs.html#full-screen-dialog) ✓**
- **[Dividers](https://material.io/design/components/dividers.html) ✓** 
  - **[Full bleed](https://material.io/design/components/dividers.html#types) ✓**
  - **[Inset](https://material.io/design/components/dividers.html#types) ✓**
  - **[Middle](https://material.io/design/components/dividers.html#types) ✓**
  - **[Subheader](https://material.io/design/components/dividers.html#types) ✓**
- **[Painéis de Expansão](https://material.io/archive/guidelines/components/expansion-panels.html) ✓** (*Legado Material v1*)
- **[Listas de Imagem](https://material.io/design/components/image-lists.html) ✓** (também conhecido como Grade Lista)
- **[Lists](https://material.io/design/components/lists.html) ✓** 
  - [Types:](https://material.io/design/components/lists.html#types) 
    - **Single line ✓**
    - **Two line ✓**
    - Three line
  - **Avatar ✓**
  - **Icon ✓**
  - Thumbnail
  - **Controls ✓** 
    - **Checkbox ✓**
    - **Expand/collapse ✓** (AKA Nested)
    - **Switch ✓**
    - Reorder
- **[Menus](https://material.io/design/components/menus.html) ✓** 
  - **[Dropdown menu](https://material.io/design/components/menus.html#dropdown-menu) ✓** (Pode ser composto) 
    - [Cascade](https://material.io/design/components/menus.html#dropdown-menu)
  - [Exposed dropdown menus](https://material.io/design/components/menus.html#exposed-dropdown-menu) 
    - **Text field dropdown menu ✓** (Select)
    - Editable dropdown menu
  - **Contextual ✓**
- **[Progress indicators](https://material.io/design/components/progress-indicators.html) ✓** 
  - **[Linear](https://material.io/design/components/progress-indicators.html#linear-progress-indicators) ✓**
  - **[Circular](https://material.io/design/components/progress-indicators.html#circular-progress-indicators) ✓**
  - **[Loading](https://material.io/archive/guidelines/components/progress-activity.html) ✓** (*Legacy Material v1*)
- **[Selection controls](https://material.io/design/components/selection-controls.html) ✓** 
  - **[Checkbox](https://material.io/design/components/selection-controls.html#checkboxes) ✓**
  - **[Radio button](https://material.io/design/components/selection-controls.html#radio-buttons) ✓**
  - **[Switch](https://material.io/design/components/selection-controls.html#switches) ✓**
- **[Sliders](https://material.io/design/components/sliders.html) ~** ([Lab](/lab/about/)) 
  - **[Continuous](https://material.io/design/components/sliders.html#continuous-slider) ✓**
  - **[Discrete](https://material.io/design/components/sliders.html#discrete-slider) ~**
- **[Snackbars](https://material.io/design/components/snackbars.html) ✓** (*Legacy Material v1*)
- **[Subheaders](https://material.io/archive/guidelines/components/subheaders.html) ✓** (*Legacy Material v1*) 
  - **[List](https://material.io/archive/guidelines/components/subheaders.html#subheaders-list-subheaders) ✓**
  - **[Grid](https://material.io/archive/guidelines/components/subheaders.html#subheaders-list-subheaders) ✓**
  - [Menu](https://material.io/archive/guidelines/components/subheaders.html#subheaders-list-subheaders)
- **[Steppers](https://material.io/archive/guidelines/components/steppers.html) ✓** (*Legacy Material v1*) 
  - **[Horizontal](https://material.io/archive/guidelines/components/steppers.html#steppers-types-of-steppers) ✓**
  - **[Vertical](https://material.io/archive/guidelines/components/steppers.html#steppers-types-of-steppers) ✓**
  - **[Mobile steps](https://material.io/archive/guidelines/components/steppers.html#steppers-types-of-steps) ✓**
- **[Tabs](https://material.io/design/components/tabs.html) ✓** 
  - **[Fixed tabs](https://material.io/design/components/tabs.html#fixed-tabs) ✓**
  - **[Scrollable tabs](https://material.io/design/components/tabs.html#scrollable-tabs) ✓**
- **[Text fields](https://material.io/design/components/text-fields.html) ✓** 
  - **[Standard](https://material.io/archive/guidelines/components/text-fields.html) ✓** (Legacy Material v1)
  - **[Filled](https://material.io/design/components/text-fields.html#filled-text-field) ✓**
  - **[Outline](https://material.io/design/components/text-fields.html#outlined-text-field) ✓**
  - [Types](https://material.io/design/components/text-fields.html#input-types): 
    - **Single-line ✓**
    - **Multi-line ✓**
    - Text-area
    - **Full-width ✓**
  - [Assistive elements:](https://material.io/design/components/text-fields.html#anatomy) 
    - **Helper text ✓**
    - **Error message ✓**
    - **Icons ✓**
    - Character counter
- **[Toolbars](https://material.io/archive/guidelines/components/toolbars.html) ✓** (Legacy Material v1)
- **[Tooltips](https://material.io/design/components/tooltips.html) ✓** 
  - **Desktop ✓**
  - **Mobile ✓**