# 支持组件

<p class="description">以下是Material Design组件和功能的列表. 当前由Material-UI支持的那些被高亮显示✓.</p>

虽然我们努力遵循实践中的指导原则（在指导原则相互矛盾的情况下应用 常识 - 比 可能预期的更常见），但我们不希望支持每个组件，或每个组件的每 特征，而是提供构建块 允许开发人员创建引人注目的用户界面和体验。

如果您希望在此处添加对组件或功能未高亮显示的支持, 请搜索相关的 [ GitHub 问题 ](https://github.com/mui-org/material-ui/issues), 或创建一个新的问题 来讨论该方法, 然后再提交pull请求。

- App bars 
  - **[Top](https://material.io/design/components/app-bars-top.html) ✓**
  - **[Bottom](https://material.io/design/components/app-bars-bottom.html) ✓**
- **[Banners](https://material.io/design/components/banners.html)** ([可以组成](https://medium.com/material-ui/introducing-material-ui-design-system-93e921beb8df))
- **[Bottom navigation](https://material.io/design/components/bottom-navigation.html) ✓**
- **[Buttons](https://material.io/design/components/buttons.html) ✓** 
  - **[Text & contained buttons (先前 flat & raised)](https://material.io/design/components/buttons.html) ✓**
  - **[Toggle buttons](https://material.io/design/components/buttons.html#buttons-toggle-buttons) ~** ([Lab](/lab/about/))
  - **[Icon toggle buttons](https://material.io/design/components/buttons.html#toggle-button) ✓** (Custom Checkbox)
- **[Buttons: Floating Action Button](https://material.io/design/components/buttons-floating-action-button.html) ✓** 
  - 过渡动画: 
    - **[Speed dial](https://material.io/design/components/buttons-floating-action-button.html#types-of-transitions) ~** ([Lab](/lab/about/))
    - [Menu](https://material.io/design/components/buttons-floating-action-button.html#types-of-transitions)
    - [Morph](https://material.io/design/components/buttons-floating-action-button.html#types-of-transitions)
    - [Full screen](https://material.io/design/components/buttons-floating-action-button.html#types-of-transitions)
  - **[Extended FAB](https://material.io/design/components/buttons-floating-action-button.html#extended-fab) ✓** 
    - Speed dial
- **[Cards](https://material.io/design/components/cards.html) ✓**
- **[Chips](https://material.io/design/components/chips.html) ✓** 
  - **[Input](https://material.io/design/components/chips.html#input-chips) ✓**
  - [Choice](https://material.io/design/components/chips.html#choice-chips)
  - [Filter](https://material.io/design/components/chips.html#filter-chips)
  - [Action](https://material.io/design/components/chips.html#action-chips)
- **[Data tables](https://material.io/design/components/data-tables.html) ✓** 
  - **Sortable ✓**
  - **Selectable ✓**
  - **Pagination ✓**
- **[Dialogs](https://material.io/design/components/dialogs.html) ✓** 
  - **[Alert dialog](https://material.io/design/components/dialogs.html#alert-dialog) ✓**
  - **[Simple dialogs](https://material.io/design/components/dialogs.html#simple-dialog) ✓** （可以用Dialog和List组成。）
  - **[Confirmation dialogs](https://material.io/design/components/dialogs.html#confirmation-dialog) ✓**
  - **[Full screen dialogs](https://material.io/design/components/dialogs.html#full-screen-dialog) ✓**
- **[Dividers](https://material.io/design/components/dividers.html) ✓** 
  - **[Full bleed](https://material.io/design/components/dividers.html#types) ✓**
  - **[Inset](https://material.io/design/components/dividers.html#types) ✓**
  - **[Middle](https://material.io/design/components/dividers.html#types) ✓**
  - **[Subheader](https://material.io/design/components/dividers.html#types) ✓**
- **[Expansion Panels](https://material.io/archive/guidelines/components/expansion-panels.html) ✓** (*旧 Material v1*)
- **[Image lists](https://material.io/design/components/image-lists.html) ✓** (又名 Grid Lists)
- **[Lists](https://material.io/design/components/lists.html) ✓** 
  - [Types:](https://material.io/design/components/lists.html#types) 
    - **Single line ✓**
    - **Two line ✓**
    - Three line
  - **Avatar ✓**
  - **Icon ✓**
  - Thumbnail
  - **Controls ✓** 
    - **复选框 ✓**
    - **Expand/collapse ✓** (又名 Nested)
    - **开关 ✓**
    - Reorder
- **[Menus](https://material.io/design/components/menus.html) ✓** 
  - **[Dropdown menu](https://material.io/design/components/menus.html#dropdown-menu) ✓** (可以组成) 
    - [Cascade](https://material.io/design/components/menus.html#dropdown-menu)
  - [Exposed dropdown menus](https://material.io/design/components/menus.html#exposed-dropdown-menu) 
    - **Text field dropdown menu ✓** (Select)
    - Editable dropdown menu
  - **Contextual ✓**
- **[Progress indicators](https://material.io/design/components/progress-indicators.html) ✓** 
  - **[Linear](https://material.io/design/components/progress-indicators.html#linear-progress-indicators) ✓**
  - **[Circular](https://material.io/design/components/progress-indicators.html#circular-progress-indicators) ✓**
  - **[Loading](https://material.io/archive/guidelines/components/progress-activity.html) ✓** (*旧 Material v1*)
- **[Selection controls](https://material.io/design/components/selection-controls.html) ✓** 
  - **[Checkbox](https://material.io/design/components/selection-controls.html#checkboxes) ✓**
  - **[Radio button](https://material.io/design/components/selection-controls.html#radio-buttons) ✓**
  - **[Switch](https://material.io/design/components/selection-controls.html#switches) ✓**
- **[Sliders](https://material.io/design/components/sliders.html) ~** ([Lab](/lab/about/)) 
  - **[Continuous](https://material.io/design/components/sliders.html#continuous-slider) ✓**
  - **[Discrete](https://material.io/design/components/sliders.html#discrete-slider) ~**
- **[Snackbars](https://material.io/design/components/snackbars.html) ✓** (*旧 Material v1*)
- **[Subheaders](https://material.io/archive/guidelines/components/subheaders.html) ✓** (*旧 Material v1*) 
  - **[List](https://material.io/archive/guidelines/components/subheaders.html#subheaders-list-subheaders) ✓**
  - **[Grid](https://material.io/archive/guidelines/components/subheaders.html#subheaders-list-subheaders) ✓**
  - [Menu](https://material.io/archive/guidelines/components/subheaders.html#subheaders-list-subheaders)
- **[Steppers](https://material.io/archive/guidelines/components/steppers.html) ✓** (*旧 Material v1*) 
  - **[Horizontal](https://material.io/archive/guidelines/components/steppers.html#steppers-types-of-steppers) ✓**
  - **[Vertical](https://material.io/archive/guidelines/components/steppers.html#steppers-types-of-steppers) ✓**
  - **[Mobile steps](https://material.io/archive/guidelines/components/steppers.html#steppers-types-of-steps) ✓**
- **[Tabs](https://material.io/design/components/tabs.html) ✓** 
  - **[Fixed tabs](https://material.io/design/components/tabs.html#fixed-tabs) ✓**
  - **[Scrollable tabs](https://material.io/design/components/tabs.html#scrollable-tabs) ✓**
- **[Text fields](https://material.io/design/components/text-fields.html) ✓** 
  - **[Standard](https://material.io/archive/guidelines/components/text-fields.html) ✓** (旧 Material v1)
  - **[Filled](https://material.io/design/components/text-fields.html#filled-text-field) ✓**
  - **[Outline](https://material.io/design/components/text-fields.html#outlined-text-field) ✓**
  - [Types](https://material.io/design/components/text-fields.html#input-types): 
    - **Single-line ✓**
    - **Multi-line ✓**
    - Text-area
    - **Full-width ✓**
  - [Assistive elements:](https://material.io/design/components/text-fields.html#anatomy) 
    - **Helper text ✓**
    - **Error message ✓**
    - **图标 ✓**
    - Character counter
- **[Toolbars](https://material.io/archive/guidelines/components/toolbars.html) ✓** (旧 Material v1)
- **[Tooltips](https://material.io/design/components/tooltips.html) ✓** 
  - **Desktop ✓**
  - **可移动 ✓**