---
title: Slider React component
components: Slider
---
# Slider

<p class="description">Sliders allow users to make selections from a range of values.</p>

[Sliders](https://material.io/design/components/sliders.html) reflect a range of values along a bar, from which users may select a single value. They are ideal for adjusting settings such as volume, brightness, or applying image filters.

Sliders can have icons on both ends of the bar that reflect a range of values.

#### Immediate effects

Changes made with sliders are immediate, allowing a user to make slider adjustments until finding their preference. They shouldn’t be paired with settings that have even minor delays in providing user feedback.

#### Current state

Sliders reflect the current state of the settings they control.

## Simple slider

{{"demo": "pages/lab/slider/SimpleSlider.js"}}

## Slider with steps

{{"demo": "pages/lab/slider/StepSlider.js"}}

## Disabled slider

{{"demo": "pages/lab/slider/DisabledSlider.js"}}

## Vertical slider

{{"demo": "pages/lab/slider/VerticalSlider.js"}}

## Custom thumb

{{"demo": "pages/lab/slider/CustomIconSlider.js"}}

## Custom value reducer

{{"demo": "pages/lab/slider/CustomValueReducerSlider.js"}}