---
title: React-компонент Сетка
components: Сетка
---
# Сетка

<p class="description">Сетка адаптивного макета Material Design адаптируется к размеру экрана и ориентации, обеспечивая согласованность макетов.</p>

[Сетка](https://material.io/design/layout/responsive-layout-grid.html) создает визуальную согласованность между макетами, позволяя гибко адаптироваться к разнообразным дизайнам. Адаптивный пользовательский интерфейс Material Design основан на сетке с 12 колонками.

## Как это работает

Система сетки реализована с помощью компонента `Grid`:

- Она использует [модуль Flexible Box CSS](https://www.w3.org/TR/css-flexbox-1/) для повышеной гибкости.
- Существует два типа макетов: *контейнеры* и *элементы*.
- Ширина элементов задается в процентах, поэтому они всегда гибко изменяют свой размер относительно родительского элемента.
- Элементы имеют отступы для создания промежутков между отдельными элементами.
- Существует пять контрольных точек прерывания сетки: xs, sm, md, lg и xl.

## Интервал

Адаптивная сетка фокусируется на постоянной ширине отступов, а не на ширине столбца. Поля и столбцы Material Design соответствуют базовой квадратной **8dp** сетке. Интервал может быть 8, 16, 24, 32 или 40dp в ширину.

{{"demo": "pages/layout/grid/SpacingGrid.js"}}

## Адаптивные сетки

Адаптивные сетки используют столбцы, которые масштабируют и изменяют размер содержимого. Макет адаптивной сетки может использовать точки прерывания, чтобы определить, нужно ли кардинально изменить макет.

### Базовая сетка

Ширина столбца меняется во всех точках прерывания (от `xs` и выше).

{{"demo": "pages/layout/grid/CenteredGrid.js"}}

### Сетка с точками прерывания

Некоторые столбцы имеют несколько значений ширины, что приводит к изменению макета в определенной точке прерывания.

{{"demo": "pages/layout/grid/FullWidthGrid.js"}}

## Интерактивность

Ниже приведен интерактивный пример, который демонстрирует результаты различных настроек сетки:

{{"demo": "pages/layout/grid/InteractiveGrid.js"}}

## Авто-разметка

Автоматическая разметка позволяет *элементам* равномерно распределять доступное пространство. Это также означает, что вы можете установить ширину одного *элемента*, а остальные будут автоматически изменять размер вокруг него.

{{"demo": "pages/layout/grid/AutoGrid.js"}}

## Сложная сетка

Следующая демонстрация не соответствует спецификации Material Design, но иллюстрирует, как сетка может использоваться для создания сложных макетов.

{{"demo": "pages/layout/grid/ComplexGrid.js"}}

## CSS макет сетки

**CSS Grid Layout** отлично подходит для разделения страницы на основные блоки или определяет взаимосвязь размера, позиционирования и уровня между частями управляемого элемента, состоящего из HTML примитивов.

⚠️ К сожалению, CSS-сетка поддерживается только самыми современными браузерами.

{{"demo": "pages/layout/grid/CSSGrid.js"}}

## Вложенная сетка

Свойства `контейнера` и `элемента` - это два независимых логических значения. Они могут быть объединены.

> Flex **контейнер** представляет собой блок, созданный элементом с вычисляемым свойством display `flex` или `inline-flex`. Дочерние элементы flex контейнера называются flex **элементы** и размещаются используя flex-модель.

https://www.w3.org/TR/css-flexbox-1/#box-model

{{"demo": "pages/layout/grid/NestedGrid.js"}}

## Ограничения

### Отрицательный margin

Есть одно ограничение с отрицательным margin, которое мы используем для добавления расстояния между элементами. Появится горизонтальная прокрутка, если отрицательный margin выходит за пределы `<body>`. Существует 3 обходных пути: 1. Не использовать отступы и не реализовывать их в пространстве пользователя. `spacing={0}` (по умолчанию). 2. Применение padding к родителю с использованием как минимум половины значения отступа, имеющегося у дочернего элемента:

```jsx
  <body>
    <div style={{ padding: 20 }}>
      <Grid container spacing={40}>
        //...
      </Grid>
    </div>
  </body>
```

1. Добавление `overflow-x: hidden;` к родителю.

### white-space: nowrap;

Исходное значение для элементов Flex: `min-width: auto`. Это вызывает конфликт позиционирования, когда дети используют `white-space: nowrap;` Вы можете столкнуться со следующей проблемой:

```jsx
<Grid item xs>
  <Typography noWrap>
```

Чтобы элемент оставался в контейнере, необходимо установить `min-width: 0`. На практике вы можете использовать свойство `zeroMinWidth`:

```jsx
<Grid item xs zeroMinWidth>
  <Typography noWrap>
```

{{"demo": "pages/layout/grid/AutoGridNoWrap.js"}}