# 调色板

<p class="description">通过一些颜色实用程序类的颜色传达意义。 还包括支持带悬停状态的样式链接。</p>

## 颜色

```jsx
<Box color="primary.main">…
<Box color="secondary.main">…
<Box color="error.main">…
<Box color="text.primary">…
<Box color="text.secondary">…
<Box color="text.disabled">…
<Box color="text.hint">…
```

{{"demo": "pages/system/palette/Color.js"}}

## 背景颜色

```jsx
<Box bgcolor="primary.main">…
<Box bgcolor="secondary.main">…
<Box bgcolor="error.main">…
<Box bgcolor="text.primary">…
<Box bgcolor="text.secondary">…
<Box bgcolor="text.disabled">…
<Box bgcolor="text.hint">…
```

{{"demo": "pages/system/palette/BackgroundColor.js"}}

## API

```js
import { palette } from '@material-ui/system';
```

| 导入名称      | Prop      | CSS 属性            | 主题键                                                              |
|:--------- |:--------- |:----------------- |:---------------------------------------------------------------- |
| `color`   | `color`   | `color`           | [`palette`](/customization/default-theme/?expend-path=$.palette) |
| `bgcolor` | `bgcolor` | `backgroundColor` | [`palette`](/customization/default-theme/?expend-path=$.palette) |