# Material-UI 版本号

<p class="description">你可以在任意时间回到本页切换文档的版本。</p>

## 稳定版本

我们推荐在生产环境中使用最新版本。

{{"demo": "pages/versions/StableVersions.js", "hideHeader": true}}

## 最新版本

在这里您可以找到尚未发布的最新文档和代码。 你可以使用它来查看最新的更新内容, 并为 Material-UI 的贡献者提供更好的反馈。

{{"demo": "pages/versions/LatestVersion.js", "hideHeader": true}}

## 版本控制策略

我们认识到您需要来自Material-UI库的**稳定性**. 稳定性确保可重用组件和库、教程、工具和学习教程不会意外过时. 稳定性对于Material-UI蓬勃发展的生态系统至关重要.

本文档包含 **我们遵循的做法** ，为您提供前沿的UI库，与稳定性保持平衡。 我们努力确保始终以可预测的方式引入未来的变化。 我们希望每个依赖于Material-UI的人都知道添加新功能的时间和方式，并在删除过时功能时做好充分准备。

Material-UI 严格遵循 [Semantic Versioning 2.0.0](https://semver.org/) 语义化版本规范。 Material-UI 的版本号由三部分组成：`主版本号.次版本号.修订版本号`。 版本号的选择是根据更新内容的数量决定

- **主要版本** 包含重要的新功能，有些但在更新期间预计会提供最少的开发人员帮助。 更新到新的主要版本时，您可能需要运行更新脚本，重构代码，运行其他测试以及学习新API。
- **次版本**包含重要的新功能。 次要版本完全向后兼容;更新期间不需要开发人员协助，但您可以选择修改应用程序和库，以开始使用发行版中添加的新API，功能和功能。
- **日常更新**的风险较低。它包含了对bug的修复和较小的新功能。 更新期间不需要开发人员协助。

## 发布周期

我们致力于定期发布，以便您可以通过Material-UI的不断发展来规划和协调您的更新。

通常情况下, 你可以根据以下的发布周期来预测:

- 每六个月发布一个**主版本**。
- 每个主版本会附带1-3个向下兼容的**次版本**。
- 每周会进行**日常**更新 (如果有紧急的 bugfix，则任何时候都可发布)。

## 发布计划

> 免责声明: 日期作为一般指导提供, 我们可以在必要时调整, 以确保交付高质量的代码。

| 日期      | 版本                         |
|:------- |:-------------------------- |
| 2019年1月 | `@material-ui/core` v4.0.0 |
| 2019年7月 | `@material-ui/core` v5.0.0 |

你可以在 [ 我们的里程碑 ](https://github.com/mui-org/material-ui/milestones) 中查看更详细的概述。

## 支持政策

我们只支持Material-UI的最新版本。 我们目前还没有提供[LTS](https://en.wikipedia.org/wiki/Long-term_support)的版本

## 弃用做法

有时， **“破坏更改”**，例如删除对选定API和功能的支持，是必要的。

为了使这些过渡尽可能简单，我们向您做出两项承诺：

- 我们努力减少重大变更的数量，并尽可能提供迁移工具。
- 我们遵循此处所述的弃用政策，因此您有时间将应用更新为最新的API和最佳做法。

为了确保您有足够的时间和明确的方法更新, 以下是我们的弃用策略:

- 我们会在更新日志中公布过时的功能, 并在可能的情况下, 在运行时发出警告。
- 当我们公布一个过时的功能时, 同时会提供一个最佳的更新方法。
- 我们支持在弃用期间使用稳定的API，因此您的代码将在此期间继续运行。
- 我们仅在主要版本中进行需要更改应用程序的对等依赖项更新（React）。