/*!
 * 
 *  SIP version 0.8.2
 *  Copyright (c) 2014-2017 Junction Networks, Inc <http://www.onsip.com>
 *  Homepage: http://sipjs.com
 *  License: http://sipjs.com/license/
 * 
 * 
 *  ~~~SIP.js contains substantial portions of JsSIP under the following license~~~
 *  Homepage: http://jssip.net
 *  Copyright (c) 2012-2013 José Luis Millán - Versatica <http://www.versatica.com>
 * 
 *  Permission is hereby granted, free of charge, to any person obtaining
 *  a copy of this software and associated documentation files (the
 *  "Software"), to deal in the Software without restriction, including
 *  without limitation the rights to use, copy, modify, merge, publish,
 *  distribute, sublicense, and/or sell copies of the Software, and to
 *  permit persons to whom the Software is furnished to do so, subject to
 *  the following conditions:
 * 
 *  The above copyright notice and this permission notice shall be
 *  included in all copies or substantial portions of the Software.
 * 
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 *  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 *  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 *  LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 *  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 *  WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 *  ~~~ end JsSIP license ~~~
 * 
 * 
 * 
 * 
 */
!function(t,e){"object"==typeof exports&&"object"==typeof module?module.exports=e():"function"==typeof define&&define.amd?define([],e):"object"==typeof exports?exports.SIP=e():t.SIP=e()}(this,function(){return function(t){function e(r){if(i[r])return i[r].exports;var s=i[r]={i:r,l:!1,exports:{}};return t[r].call(s.exports,s,s.exports,e),s.l=!0,s.exports}var i={};return e.m=t,e.c=i,e.d=function(t,i,r){e.o(t,i)||Object.defineProperty(t,i,{configurable:!1,enumerable:!0,get:r})},e.n=function(t){var i=t&&t.__esModule?function(){return t.default}:function(){return t};return e.d(i,"a",i),i},e.o=function(t,e){return Object.prototype.hasOwnProperty.call(t,e)},e.p="",e(e.s=1)}([function(t,e){var i;i=function(){return this}();try{i=i||Function("return this")()||(0,eval)("this")}catch(t){"object"==typeof window&&(i=window)}t.exports=i},function(t,e,i){"use strict";t.exports=i(2)(i(34))},function(t,e,i){"use strict";t.exports=function(t){var e=i(3),r=e.version,s=e.title,n=Object.defineProperties({},{version:{get:function(){return r}},name:{get:function(){return s}}});return i(4)(n,t),n.LoggerFactory=i(5)(t.console),n.EventEmitter=i(6)(),n.C=i(8)(n.name,n.version),n.Exceptions=i(9),n.Timers=i(10)(t.timers),n.Transport=t.Transport(n,t.WebSocket),i(11)(n),i(12)(n),i(13)(n),i(14)(n),i(15)(n),i(16)(n),i(18)(n),i(19)(n),n.SessionDescriptionHandler=i(20)(n.EventEmitter),i(21)(n),i(22)(n),i(23)(n,t),i(25)(n),i(26)(n,t),i(28)(n),n.DigestAuthentication=i(29)(n.Utils),n.Grammar=i(30)(n),n.WebRTC={Modifiers:i(32)(n),Simple:i(33)(n)},n}},function(t,e){t.exports={name:"sip.js",title:"SIP.js",description:"A simple, intuitive, and powerful JavaScript signaling library",version:"0.8.2",main:"src/index.js",browser:{"./src/environment.js":"./src/environment_browser.js"},homepage:"http://sipjs.com",author:"OnSIP <developer@onsip.com> (http://sipjs.com/aboutus/)",contributors:[{url:"https://github.com/onsip/SIP.js/blob/master/THANKS.md"}],repository:{type:"git",url:"https://github.com/onsip/SIP.js.git"},keywords:["sip","websocket","webrtc","library","javascript"],devDependencies:{eslint:"^4.5.0","eslint-loader":"^1.9.0","jasmine-core":"^2.6.4",karma:"^1.7.0","karma-cli":"^1.0.1","karma-jasmine":"^1.1.0","karma-jasmine-html-reporter":"^0.2.2","karma-mocha-reporter":"^2.2.3","karma-phantomjs-launcher":"^1.0.4",pegjs:"^0.10.0","pegjs-loader":"^0.5.2","uglifyjs-webpack-plugin":"^0.4.6",webpack:"^3.5.5"},engines:{node:">=4.0"},license:"MIT",scripts:{build:"webpack --progress && cp dist/sip.js dist/sip-$npm_package_version.js && cp dist/sip.min.js  dist/sip-$npm_package_version.min.js",browserTest:"sleep 2 && open http://0.0.0.0:9876/debug.html & karma start --reporters kjhtml --no-single-run",commandLineTest:"karma start --reporters mocha --browsers PhantomJS --single-run",buildAndTest:"npm run build && npm run commandLineTest"},dependencies:{ws:"^1.0.1"},optionalDependencies:{promiscuous:"^0.6.0"}}},function(t,e,i){"use strict";t.exports=function(t,e){var i;i={Promise:e.Promise,defer:function(){var t={};return t.promise=new i.Promise(function(e,i){t.resolve=e,t.reject=i}),t},reducePromises:function(e,i){return e.reduce(function(t,e){return t=t.then(e)},t.Utils.Promise.resolve(i))},augment:function(t,e,i,r){var s,n;n=e.prototype;for(s in n)(r||void 0===t[s])&&(t[s]=n[s]);e.apply(t,i)},optionsOverride:function(t,e,i,r,s,n){r&&t[i]&&s.warn(i+" is deprecated, please use "+e+" instead"),t[e]&&t[i]&&s.warn(e+" overriding "+i),t[e]=t[e]||t[i]||n},str_utf8_length:function(t){return encodeURIComponent(t).replace(/%[A-F\d]{2}/g,"U").length},generateFakeSDP:function(t){if(t){var e=t.indexOf("o="),i=t.indexOf("\r\n",e);return"v=0\r\n"+t.slice(e,i)+"\r\ns=-\r\nt=0 0\r\nc=IN IP4 0.0.0.0"}},isFunction:function(t){return void 0!==t&&"[object Function]"===Object.prototype.toString.call(t)},isDecimal:function(t){return!isNaN(t)&&parseFloat(t)===parseInt(t,10)},createRandomToken:function(t,e){var i,r,s="";for(e=e||32,i=0;i<t;i++)r=Math.random()*e|0,s+=r.toString(e);return s},newTag:function(){return t.Utils.createRandomToken(t.UA.C.TAG_LENGTH)},newUUID:function(){return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(t){var e=16*Math.random()|0;return("x"===t?e:3&e|8).toString(16)})},hostType:function(e){if(e)return-1!==(e=t.Grammar.parse(e,"host"))?e.host_type:void 0},normalizeTarget:function(e,i){var r,s,n;if(e){if(e instanceof t.URI)return e;if("string"==typeof e){switch(r=e.split("@"),r.length){case 1:if(!i)return;s=e,n=i;break;case 2:s=r[0],n=r[1];break;default:s=r.slice(0,r.length-1).join("@"),n=r[r.length-1]}return s=s.replace(/^(sips?|tel):/i,""),/^[\-\.\(\)]*\+?[0-9\-\.\(\)]+$/.test(s)&&(s=s.replace(/[\-\.\(\)]/g,"")),e=t.C.SIP+":"+t.Utils.escapeUser(s)+"@"+n,t.URI.parse(e)}}else;},escapeUser:function(t){return encodeURIComponent(decodeURIComponent(t)).replace(/%3A/gi,":").replace(/%2B/gi,"+").replace(/%3F/gi,"?").replace(/%2F/gi,"/")},headerize:function(t){var e,i={"Call-Id":"Call-ID",Cseq:"CSeq","Min-Se":"Min-SE",Rack:"RAck",Rseq:"RSeq","Www-Authenticate":"WWW-Authenticate"},r=t.toLowerCase().replace(/_/g,"-").split("-"),s="",n=r.length;for(e=0;e<n;e++)0!==e&&(s+="-"),s+=r[e].charAt(0).toUpperCase()+r[e].substring(1);return i[s]&&(s=i[s]),s},sipErrorCause:function(e){var i;for(i in t.C.SIP_ERROR_CAUSES)if(-1!==t.C.SIP_ERROR_CAUSES[i].indexOf(e))return t.C.causes[i];return t.C.causes.SIP_FAILURE_CODE},getReasonPhrase:function(e,i){return i||t.C.REASON_PHRASE[e]||""},getReasonHeaderValue:function(e,i){return i=t.Utils.getReasonPhrase(e,i),"SIP ;cause="+e+' ;text="'+i+'"'},getCancelReason:function(e,i){if(e&&e<200||e>699)throw new TypeError("Invalid status_code: "+e);if(e)return t.Utils.getReasonHeaderValue(e,i)},buildStatusLine:function(t,e){if(t=t||null,e=e||null,!t||t<100||t>699)throw new TypeError("Invalid status_code: "+t);if(e&&"string"!=typeof e&&!(e instanceof String))throw new TypeError("Invalid reason_phrase: "+e);return e=i.getReasonPhrase(t,e),"SIP/2.0 "+t+" "+e+"\r\n"},getRandomTestNetIP:function(){return"192.0.2."+function(t,e){return Math.floor(Math.random()*(e-t+1)+t)}(1,254)},calculateMD5:function(t){function e(t,e){return t<<e|t>>>32-e}function i(t,e){var i,r,s,n,o;return s=2147483648&t,n=2147483648&e,i=1073741824&t,r=1073741824&e,o=(1073741823&t)+(1073741823&e),i&r?2147483648^o^s^n:i|r?1073741824&o?3221225472^o^s^n:1073741824^o^s^n:o^s^n}function r(t,e,i){return t&e|~t&i}function s(t,e,i){return t&i|e&~i}function n(t,e,i){return t^e^i}function o(t,e,i){return e^(t|~i)}function a(t,s,n,o,a,c,h){return t=i(t,i(i(r(s,n,o),a),h)),i(e(t,c),s)}function c(t,r,n,o,a,c,h){return t=i(t,i(i(s(r,n,o),a),h)),i(e(t,c),r)}function h(t,r,s,o,a,c,h){return t=i(t,i(i(n(r,s,o),a),h)),i(e(t,c),r)}function u(t,r,s,n,a,c,h){return t=i(t,i(i(o(r,s,n),a),h)),i(e(t,c),r)}function l(t){var e,i,r="",s="";for(i=0;i<=3;i++)e=t>>>8*i&255,s="0"+e.toString(16),r+=s.substr(s.length-2,2);return r}var d,p,f,g,T,m,_,E,S,v=[];for(t=function(t){t=t.replace(/\r\n/g,"\n");for(var e="",i=0;i<t.length;i++){var r=t.charCodeAt(i);r<128?e+=String.fromCharCode(r):r>127&&r<2048?(e+=String.fromCharCode(r>>6|192),e+=String.fromCharCode(63&r|128)):(e+=String.fromCharCode(r>>12|224),e+=String.fromCharCode(r>>6&63|128),e+=String.fromCharCode(63&r|128))}return e}(t),v=function(t){for(var e,i=t.length,r=i+8,s=(r-r%64)/64,n=16*(s+1),o=Array(n-1),a=0,c=0;c<i;)e=(c-c%4)/4,a=c%4*8,o[e]=o[e]|t.charCodeAt(c)<<a,c++;return e=(c-c%4)/4,a=c%4*8,o[e]=o[e]|128<<a,o[n-2]=i<<3,o[n-1]=i>>>29,o}(t),m=1732584193,_=4023233417,E=2562383102,S=271733878,d=0;d<v.length;d+=16)p=m,f=_,g=E,T=S,m=a(m,_,E,S,v[d+0],7,3614090360),S=a(S,m,_,E,v[d+1],12,3905402710),E=a(E,S,m,_,v[d+2],17,606105819),_=a(_,E,S,m,v[d+3],22,3250441966),m=a(m,_,E,S,v[d+4],7,4118548399),S=a(S,m,_,E,v[d+5],12,1200080426),E=a(E,S,m,_,v[d+6],17,2821735955),_=a(_,E,S,m,v[d+7],22,4249261313),m=a(m,_,E,S,v[d+8],7,1770035416),S=a(S,m,_,E,v[d+9],12,2336552879),E=a(E,S,m,_,v[d+10],17,4294925233),_=a(_,E,S,m,v[d+11],22,2304563134),m=a(m,_,E,S,v[d+12],7,1804603682),S=a(S,m,_,E,v[d+13],12,4254626195),E=a(E,S,m,_,v[d+14],17,2792965006),_=a(_,E,S,m,v[d+15],22,1236535329),m=c(m,_,E,S,v[d+1],5,4129170786),S=c(S,m,_,E,v[d+6],9,3225465664),E=c(E,S,m,_,v[d+11],14,643717713),_=c(_,E,S,m,v[d+0],20,3921069994),m=c(m,_,E,S,v[d+5],5,3593408605),S=c(S,m,_,E,v[d+10],9,38016083),E=c(E,S,m,_,v[d+15],14,3634488961),_=c(_,E,S,m,v[d+4],20,3889429448),m=c(m,_,E,S,v[d+9],5,568446438),S=c(S,m,_,E,v[d+14],9,3275163606),E=c(E,S,m,_,v[d+3],14,4107603335),_=c(_,E,S,m,v[d+8],20,1163531501),m=c(m,_,E,S,v[d+13],5,2850285829),S=c(S,m,_,E,v[d+2],9,4243563512),E=c(E,S,m,_,v[d+7],14,1735328473),_=c(_,E,S,m,v[d+12],20,2368359562),m=h(m,_,E,S,v[d+5],4,4294588738),S=h(S,m,_,E,v[d+8],11,2272392833),E=h(E,S,m,_,v[d+11],16,1839030562),_=h(_,E,S,m,v[d+14],23,4259657740),m=h(m,_,E,S,v[d+1],4,2763975236),S=h(S,m,_,E,v[d+4],11,1272893353),E=h(E,S,m,_,v[d+7],16,4139469664),_=h(_,E,S,m,v[d+10],23,3200236656),m=h(m,_,E,S,v[d+13],4,681279174),S=h(S,m,_,E,v[d+0],11,3936430074),E=h(E,S,m,_,v[d+3],16,3572445317),_=h(_,E,S,m,v[d+6],23,76029189),m=h(m,_,E,S,v[d+9],4,3654602809),S=h(S,m,_,E,v[d+12],11,3873151461),E=h(E,S,m,_,v[d+15],16,530742520),_=h(_,E,S,m,v[d+2],23,3299628645),m=u(m,_,E,S,v[d+0],6,4096336452),S=u(S,m,_,E,v[d+7],10,1126891415),E=u(E,S,m,_,v[d+14],15,2878612391),_=u(_,E,S,m,v[d+5],21,4237533241),m=u(m,_,E,S,v[d+12],6,1700485571),S=u(S,m,_,E,v[d+3],10,2399980690),E=u(E,S,m,_,v[d+10],15,4293915773),_=u(_,E,S,m,v[d+1],21,2240044497),m=u(m,_,E,S,v[d+8],6,1873313359),S=u(S,m,_,E,v[d+15],10,4264355552),E=u(E,S,m,_,v[d+6],15,2734768916),_=u(_,E,S,m,v[d+13],21,1309151649),m=u(m,_,E,S,v[d+4],6,4149444226),S=u(S,m,_,E,v[d+11],10,3174756917),E=u(E,S,m,_,v[d+2],15,718787259),_=u(_,E,S,m,v[d+9],21,3951481745),m=i(m,p),_=i(_,f),E=i(E,g),S=i(S,T);return(l(m)+l(_)+l(E)+l(S)).toLowerCase()}},t.Utils=i}},function(t,e,i){"use strict";var r={error:0,warn:1,log:2,debug:3};t.exports=function(t){function e(t,e,i){this.logger=t,this.category=e,this.label=i}var i=function(){var t,e=2,i=!0,s=null;this.loggers={},t=this.getLogger("sip.loggerfactory"),Object.defineProperties(this,{builtinEnabled:{get:function(){return i},set:function(e){"boolean"==typeof e?i=e:t.error('invalid "builtinEnabled" parameter value: '+JSON.stringify(e))}},level:{get:function(){return e},set:function(i){i>=0&&i<=3?e=i:i>3?e=3:r.hasOwnProperty(i)?e=r[i]:t.error('invalid "level" parameter value: '+JSON.stringify(i))}},connector:{get:function(){return s},set:function(e){null===e||""===e||void 0===e?s=null:"function"==typeof e?s=e:t.error('invalid "connector" parameter value: '+JSON.stringify(e))}}})};return i.prototype.print=function(e,i,r,s){if("string"==typeof s){var n=[new Date,i];r&&n.push(r),s=n.concat(s).join(" | ")}e.call(t,s)},Object.keys(r).forEach(function(s){e.prototype[s]=function(t){this.logger[s](this.category,this.label,t)},i.prototype[s]=function(e,i,n){this.level>=r[s]&&(this.builtinEnabled&&this.print(t[s],e,i,n),this.connector&&this.connector(s,e,i,n))}}),i.prototype.getLogger=function(t,i){var r;return i&&3===this.level?new e(this,t,i):this.loggers[t]?this.loggers[t]:(r=new e(this,t),this.loggers[t]=r,r)},i}},function(t,e,i){"use strict";var r=i(7).EventEmitter;t.exports=function(){function t(){r.call(this)}return t.prototype=Object.create(r.prototype,{constructor:{value:t,enumerable:!1,writable:!0,configurable:!0}}),t}},function(t,e){function i(){this._events=this._events||{},this._maxListeners=this._maxListeners||void 0}function r(t){return"function"==typeof t}function s(t){return"number"==typeof t}function n(t){return"object"==typeof t&&null!==t}function o(t){return void 0===t}t.exports=i,i.EventEmitter=i,i.prototype._events=void 0,i.prototype._maxListeners=void 0,i.defaultMaxListeners=10,i.prototype.setMaxListeners=function(t){if(!s(t)||t<0||isNaN(t))throw TypeError("n must be a positive number");return this._maxListeners=t,this},i.prototype.emit=function(t){var e,i,s,a,c,h;if(this._events||(this._events={}),"error"===t&&(!this._events.error||n(this._events.error)&&!this._events.error.length)){if((e=arguments[1])instanceof Error)throw e;var u=new Error('Uncaught, unspecified "error" event. ('+e+")");throw u.context=e,u}if(i=this._events[t],o(i))return!1;if(r(i))switch(arguments.length){case 1:i.call(this);break;case 2:i.call(this,arguments[1]);break;case 3:i.call(this,arguments[1],arguments[2]);break;default:a=Array.prototype.slice.call(arguments,1),i.apply(this,a)}else if(n(i))for(a=Array.prototype.slice.call(arguments,1),h=i.slice(),s=h.length,c=0;c<s;c++)h[c].apply(this,a);return!0},i.prototype.addListener=function(t,e){var s;if(!r(e))throw TypeError("listener must be a function");return this._events||(this._events={}),this._events.newListener&&this.emit("newListener",t,r(e.listener)?e.listener:e),this._events[t]?n(this._events[t])?this._events[t].push(e):this._events[t]=[this._events[t],e]:this._events[t]=e,n(this._events[t])&&!this._events[t].warned&&(s=o(this._maxListeners)?i.defaultMaxListeners:this._maxListeners)&&s>0&&this._events[t].length>s&&(this._events[t].warned=!0,console.error("(node) warning: possible EventEmitter memory leak detected. %d listeners added. Use emitter.setMaxListeners() to increase limit.",this._events[t].length),"function"==typeof console.trace&&console.trace()),this},i.prototype.on=i.prototype.addListener,i.prototype.once=function(t,e){function i(){this.removeListener(t,i),s||(s=!0,e.apply(this,arguments))}if(!r(e))throw TypeError("listener must be a function");var s=!1;return i.listener=e,this.on(t,i),this},i.prototype.removeListener=function(t,e){var i,s,o,a;if(!r(e))throw TypeError("listener must be a function");if(!this._events||!this._events[t])return this;if(i=this._events[t],o=i.length,s=-1,i===e||r(i.listener)&&i.listener===e)delete this._events[t],this._events.removeListener&&this.emit("removeListener",t,e);else if(n(i)){for(a=o;a-- >0;)if(i[a]===e||i[a].listener&&i[a].listener===e){s=a;break}if(s<0)return this;1===i.length?(i.length=0,delete this._events[t]):i.splice(s,1),this._events.removeListener&&this.emit("removeListener",t,e)}return this},i.prototype.removeAllListeners=function(t){var e,i;if(!this._events)return this;if(!this._events.removeListener)return 0===arguments.length?this._events={}:this._events[t]&&delete this._events[t],this;if(0===arguments.length){for(e in this._events)"removeListener"!==e&&this.removeAllListeners(e);return this.removeAllListeners("removeListener"),this._events={},this}if(i=this._events[t],r(i))this.removeListener(t,i);else if(i)for(;i.length;)this.removeListener(t,i[i.length-1]);return delete this._events[t],this},i.prototype.listeners=function(t){return this._events&&this._events[t]?r(this._events[t])?[this._events[t]]:this._events[t].slice():[]},i.prototype.listenerCount=function(t){if(this._events){var e=this._events[t];if(r(e))return 1;if(e)return e.length}return 0},i.listenerCount=function(t,e){return t.listenerCount(e)}},function(t,e,i){"use strict";t.exports=function(t,e){return{USER_AGENT:t+"/"+e,SIP:"sip",SIPS:"sips",causes:{CONNECTION_ERROR:"Connection Error",REQUEST_TIMEOUT:"Request Timeout",SIP_FAILURE_CODE:"SIP Failure Code",INTERNAL_ERROR:"Internal Error",BUSY:"Busy",REJECTED:"Rejected",REDIRECTED:"Redirected",UNAVAILABLE:"Unavailable",NOT_FOUND:"Not Found",ADDRESS_INCOMPLETE:"Address Incomplete",INCOMPATIBLE_SDP:"Incompatible SDP",AUTHENTICATION_ERROR:"Authentication Error",DIALOG_ERROR:"Dialog Error",WEBRTC_NOT_SUPPORTED:"WebRTC Not Supported",WEBRTC_ERROR:"WebRTC Error",CANCELED:"Canceled",NO_ANSWER:"No Answer",EXPIRES:"Expires",NO_ACK:"No ACK",NO_PRACK:"No PRACK",USER_DENIED_MEDIA_ACCESS:"User Denied Media Access",BAD_MEDIA_DESCRIPTION:"Bad Media Description",RTP_TIMEOUT:"RTP Timeout"},supported:{UNSUPPORTED:"none",SUPPORTED:"supported",REQUIRED:"required"},SIP_ERROR_CAUSES:{REDIRECTED:[300,301,302,305,380],BUSY:[486,600],REJECTED:[403,603],NOT_FOUND:[404,604],UNAVAILABLE:[480,410,408,430],ADDRESS_INCOMPLETE:[484],INCOMPATIBLE_SDP:[488,606],AUTHENTICATION_ERROR:[401,407]},ACK:"ACK",BYE:"BYE",CANCEL:"CANCEL",INFO:"INFO",INVITE:"INVITE",MESSAGE:"MESSAGE",NOTIFY:"NOTIFY",OPTIONS:"OPTIONS",REGISTER:"REGISTER",UPDATE:"UPDATE",SUBSCRIBE:"SUBSCRIBE",REFER:"REFER",PRACK:"PRACK",REASON_PHRASE:{100:"Trying",180:"Ringing",181:"Call Is Being Forwarded",182:"Queued",183:"Session Progress",199:"Early Dialog Terminated",200:"OK",202:"Accepted",204:"No Notification",300:"Multiple Choices",301:"Moved Permanently",302:"Moved Temporarily",305:"Use Proxy",380:"Alternative Service",400:"Bad Request",401:"Unauthorized",402:"Payment Required",403:"Forbidden",404:"Not Found",405:"Method Not Allowed",406:"Not Acceptable",407:"Proxy Authentication Required",408:"Request Timeout",410:"Gone",412:"Conditional Request Failed",413:"Request Entity Too Large",414:"Request-URI Too Long",415:"Unsupported Media Type",416:"Unsupported URI Scheme",417:"Unknown Resource-Priority",420:"Bad Extension",421:"Extension Required",422:"Session Interval Too Small",423:"Interval Too Brief",428:"Use Identity Header",429:"Provide Referrer Identity",430:"Flow Failed",433:"Anonymity Disallowed",436:"Bad Identity-Info",437:"Unsupported Certificate",438:"Invalid Identity Header",439:"First Hop Lacks Outbound Support",440:"Max-Breadth Exceeded",469:"Bad Info Package",470:"Consent Needed",478:"Unresolvable Destination",480:"Temporarily Unavailable",481:"Call/Transaction Does Not Exist",482:"Loop Detected",483:"Too Many Hops",484:"Address Incomplete",485:"Ambiguous",486:"Busy Here",487:"Request Terminated",488:"Not Acceptable Here",489:"Bad Event",491:"Request Pending",493:"Undecipherable",494:"Security Agreement Required",500:"Internal Server Error",501:"Not Implemented",502:"Bad Gateway",503:"Service Unavailable",504:"Server Time-out",505:"Version Not Supported",513:"Message Too Large",580:"Precondition Failure",600:"Busy Everywhere",603:"Decline",604:"Does Not Exist Anywhere",606:"Not Acceptable"},OPTION_TAGS:{"100rel":!0,199:!0,answermode:!0,"early-session":!0,eventlist:!0,explicitsub:!0,"from-change":!0,"geolocation-http":!0,"geolocation-sip":!0,gin:!0,gruu:!0,histinfo:!0,ice:!0,join:!0,"multiple-refer":!0,norefersub:!0,nosub:!0,outbound:!0,path:!0,policy:!0,precondition:!0,pref:!0,privacy:!0,"recipient-list-invite":!0,"recipient-list-message":!0,"recipient-list-subscribe":!0,replaces:!0,"resource-priority":!0,"sdp-anat":!0,"sec-agree":!0,tdialog:!0,timer:!0,uui:!0}}}},function(t,e,i){"use strict";t.exports={ConfigurationError:function(){var t=function(t,e){this.code=1,this.name="CONFIGURATION_ERROR",this.parameter=t,this.value=e,this.message=this.value?"Invalid value "+JSON.stringify(this.value)+' for parameter "'+this.parameter+'"':"Missing parameter: "+this.parameter};return t.prototype=new Error,t}(),InvalidStateError:function(){var t=function(t){this.code=2,this.name="INVALID_STATE_ERROR",this.status=t,this.message="Invalid status: "+t};return t.prototype=new Error,t}(),NotSupportedError:function(){var t=function(t){this.code=3,this.name="NOT_SUPPORTED_ERROR",this.message=t};return t.prototype=new Error,t}(),GetDescriptionError:function(){var t=function(t){this.code=4,this.name="GET_DESCRIPTION_ERROR",this.message=t};return t.prototype=new Error,t}(),RenegotiationError:function(){var t=function(t){this.code=5,this.name="RENEGOTIATION_ERROR",this.message=t};return t.prototype=new Error,t}()}},function(t,e,i){"use strict";var r=500;t.exports=function(t){var e={T1:r,T2:4e3,T4:5e3,TIMER_B:32e3,TIMER_D:0,TIMER_F:32e3,TIMER_H:32e3,TIMER_I:0,TIMER_J:0,TIMER_K:0,TIMER_L:32e3,TIMER_M:32e3,TIMER_N:32e3,PROVISIONAL_RESPONSE_INTERVAL:6e4};return["setTimeout","clearTimeout","setInterval","clearInterval"].forEach(function(i){e[i]=function(){return t[i].apply(t,arguments)}}),e}},function(t,e,i){"use strict";t.exports=function(t){function e(t,e){var i=e,r=0,s=0;if(t.substring(i,i+2).match(/(^\r\n)/))return-2;for(;0===r;){if(-1===(s=t.indexOf("\r\n",i)))return s;!t.substring(s+2,s+4).match(/(^\r\n)/)&&t.charAt(s+2).match(/(^\s+)/)?i=s+2:r=s}return r}function i(e,i,r,s){var n,o,a,c,h=i.indexOf(":",r),u=i.substring(r,h).trim(),l=i.substring(h+1,s).trim();switch(u.toLowerCase()){case"via":case"v":e.addHeader("via",l),1===e.getHeaders("via").length?(c=e.parseHeader("Via"))&&(e.via=c,e.via_branch=c.branch):c=0;break;case"from":case"f":e.setHeader("from",l),c=e.parseHeader("from"),c&&(e.from=c,e.from_tag=c.getParam("tag"));break;case"to":case"t":e.setHeader("to",l),c=e.parseHeader("to"),c&&(e.to=c,e.to_tag=c.getParam("tag"));break;case"record-route":if(-1===(c=t.Grammar.parse(l,"Record_Route"))){c=void 0;break}for(a=c.length,o=0;o<a;o++)n=c[o],e.addHeader("record-route",l.substring(n.position,n.offset)),e.headers["Record-Route"][e.getHeaders("record-route").length-1].parsed=n.parsed;break;case"call-id":case"i":e.setHeader("call-id",l),c=e.parseHeader("call-id"),c&&(e.call_id=l);break;case"contact":case"m":if(-1===(c=t.Grammar.parse(l,"Contact"))){c=void 0;break}for(a=c.length,o=0;o<a;o++)n=c[o],e.addHeader("contact",l.substring(n.position,n.offset)),e.headers.Contact[e.getHeaders("contact").length-1].parsed=n.parsed;break;case"content-length":case"l":e.setHeader("content-length",l),c=e.parseHeader("content-length");break;case"content-type":case"c":e.setHeader("content-type",l),c=e.parseHeader("content-type");break;case"cseq":e.setHeader("cseq",l),c=e.parseHeader("cseq"),c&&(e.cseq=c.value),e instanceof t.IncomingResponse&&(e.method=c.method);break;case"max-forwards":e.setHeader("max-forwards",l),c=e.parseHeader("max-forwards");break;case"www-authenticate":e.setHeader("www-authenticate",l),c=e.parseHeader("www-authenticate");break;case"proxy-authenticate":e.setHeader("proxy-authenticate",l),c=e.parseHeader("proxy-authenticate");break;case"refer-to":case"r":e.setHeader("refer-to",l),c=e.parseHeader("refer-to"),c&&(e.refer_to=c);break;default:e.setHeader(u,l),c=0}return void 0!==c||{error:'error parsing header "'+u+'"'}}var r;r={},r.parseMessage=function(r,s){var n,o,a,c,h,u=0,l=r.indexOf("\r\n"),d=s.getLogger("sip.parser");if(-1===l)return void d.warn("no CRLF found, not a SIP message, discarded");if(o=r.substring(0,l),-1===(h=t.Grammar.parse(o,"Request_Response")))return void d.warn('error parsing first line of SIP message: "'+o+'"');for(h.status_code?(n=new t.IncomingResponse(s),n.status_code=h.status_code,n.reason_phrase=h.reason_phrase):(n=new t.IncomingRequest(s),n.method=h.method,n.ruri=h.uri),n.data=r,u=l+2;;){if(-2===(l=e(r,u))){c=u+2;break}if(-1===l)return void d.error("malformed message");if(!0!==(h=i(n,r,u,l)))return void d.error(h.error);u=l+2}return n.hasHeader("content-length")?(a=n.getHeader("content-length"),n.body=r.substr(c,a)):n.body=r.substring(c),n},t.Parser=r}},function(t,e,i){"use strict";t.exports=function(t){function e(e){var i=e.ua.configuration.hackAllowUnregisteredOptionTags,r=[],s={};return e.method===t.C.REGISTER?r.push("path","gruu"):e.method===t.C.INVITE&&(e.ua.contact.pub_gruu||e.ua.contact.temp_gruu)&&r.push("gruu"),e.ua.configuration.rel100===t.C.supported.SUPPORTED&&r.push("100rel"),e.ua.configuration.replaces===t.C.supported.SUPPORTED&&r.push("replaces"),r.push("outbound"),r=r.concat(e.ua.configuration.extraSupported),r=r.filter(function(e){var r=t.C.OPTION_TAGS[e],n=!s[e];return s[e]=!0,(r||i)&&n}),"Supported: "+r.join(", ")+"\r\n"}var i,r,s,n;i=function(e,i,r,s,n,o){var a,c,h,u,l,d;if(s=s||{},!e||!i||!r)return null;this.logger=r.getLogger("sip.sipmessage"),this.ua=r,this.headers={},this.method=e,this.ruri=i,this.body=o,this.extraHeaders=(n||[]).slice(),this.statusCode=s.status_code,this.reasonPhrase=s.reason_phrase,s.route_set?this.setHeader("route",s.route_set):r.configuration.usePreloadedRoute&&this.setHeader("route",r.transport.server.sip_uri),this.setHeader("via",""),this.setHeader("max-forwards",t.UA.C.MAX_FORWARDS),l=s.to_uri||i,a=s.to_displayName||0===s.to_displayName?'"'+s.to_displayName+'" ':"",a+="<"+(l&&l.toRaw?l.toRaw():l)+">",a+=s.to_tag?";tag="+s.to_tag:"",this.to=new t.NameAddrHeader.parse(a),this.setHeader("to",a),d=s.from_uri||r.configuration.uri,c=s.from_displayName||0===s.from_displayName?'"'+s.from_displayName+'" ':r.configuration.displayName?'"'+r.configuration.displayName+'" ':"",c+="<"+(d&&d.toRaw?d.toRaw():d)+">;tag=",c+=s.from_tag||t.Utils.newTag(),this.from=new t.NameAddrHeader.parse(c),this.setHeader("from",c),h=s.call_id||r.configuration.sipjsId+t.Utils.createRandomToken(15),this.call_id=h,this.setHeader("call-id",h),u=s.cseq||Math.floor(1e4*Math.random()),this.cseq=u,this.setHeader("cseq",u+" "+e)},i.prototype={setHeader:function(e,i){this.headers[t.Utils.headerize(e)]=i instanceof Array?i:[i]},getHeader:function(e){var i,r,s=this.extraHeaders.length,n=this.headers[t.Utils.headerize(e)];if(n){if(n[0])return n[0]}else for(i=new RegExp("^\\s*"+e+"\\s*:","i"),r=0;r<s;r++)if(n=this.extraHeaders[r],i.test(n))return n.substring(n.indexOf(":")+1).trim()},getHeaders:function(e){var i,r,s,n=this.headers[t.Utils.headerize(e)],o=[];if(n){for(r=n.length,i=0;i<r;i++)o.push(n[i]);return o}for(r=this.extraHeaders.length,s=new RegExp("^\\s*"+e+"\\s*:","i"),i=0;i<r;i++)n=this.extraHeaders[i],s.test(n)&&o.push(n.substring(n.indexOf(":")+1).trim());return o},hasHeader:function(e){var i,r,s=this.extraHeaders.length;if(this.headers[t.Utils.headerize(e)])return!0;for(i=new RegExp("^\\s*"+e+"\\s*:","i"),r=0;r<s;r++)if(i.test(this.extraHeaders[r]))return!0;return!1},toString:function(){var i,r,s,n="";n+=this.method+" "+(this.ruri.toRaw?this.ruri.toRaw():this.ruri)+" SIP/2.0\r\n";for(i in this.headers)for(r=this.headers[i].length,s=0;s<r;s++)n+=i+": "+this.headers[i][s]+"\r\n";for(r=this.extraHeaders.length,s=0;s<r;s++)n+=this.extraHeaders[s].trim()+"\r\n";return n+=e(this),n+="User-Agent: "+this.ua.configuration.userAgentString+"\r\n",this.body?"string"==typeof this.body?(r=t.Utils.str_utf8_length(this.body),n+="Content-Length: "+r+"\r\n\r\n",n+=this.body):this.body.body&&this.body.contentType?(r=t.Utils.str_utf8_length(this.body.body),n+="Content-Type: "+this.body.contentType+"\r\n",n+="Content-Length: "+r+"\r\n\r\n",n+=this.body.body):n+="Content-Length: 0\r\n\r\n":n+="Content-Length: 0\r\n\r\n",n}},r=function(){this.data=null,this.headers=null,this.method=null,this.via=null,this.via_branch=null,this.call_id=null,this.cseq=null,this.from=null,this.from_tag=null,this.to=null,this.to_tag=null,this.body=null},r.prototype={addHeader:function(e,i){var r={raw:i};e=t.Utils.headerize(e),this.headers[e]?this.headers[e].push(r):this.headers[e]=[r]},getHeader:function(e){var i=this.headers[t.Utils.headerize(e)];if(i)return i[0]?i[0].raw:void 0},getHeaders:function(e){var i,r,s=this.headers[t.Utils.headerize(e)],n=[];if(!s)return[];for(r=s.length,i=0;i<r;i++)n.push(s[i].raw);return n},hasHeader:function(e){return!!this.headers[t.Utils.headerize(e)]},parseHeader:function(e,i){var r,s,n;return e=t.Utils.headerize(e),i=i||0,this.headers[e]?i>=this.headers[e].length?void this.logger.log('not so many "'+e+'" headers present'):(r=this.headers[e][i],s=r.raw,r.parsed?r.parsed:(n=t.Grammar.parse(s,e.replace(/-/g,"_")),-1===n?(this.headers[e].splice(i,1),void this.logger.warn('error parsing "'+e+'" header field with value "'+s+'"')):(r.parsed=n,n))):void this.logger.log('header "'+e+'" not present')},s:function(t,e){return this.parseHeader(t,e)},setHeader:function(e,i){var r={raw:i};this.headers[t.Utils.headerize(e)]=[r]},toString:function(){return this.data}},s=function(t){this.logger=t.getLogger("sip.sipmessage"),this.ua=t,this.headers={},this.ruri=null,this.transport=null,this.server_transaction=null},s.prototype=new r,s.prototype.reply=function(i,r,s,n,o,a){var c,h,u,l,d,p=this.getHeader("To"),f=0,g=0;if(d=t.Utils.buildStatusLine(i,r),s=(s||[]).slice(),this.method===t.C.INVITE&&i>100&&i<=200)for(c=this.getHeaders("record-route"),u=c.length,f;f<u;f++)d+="Record-Route: "+c[f]+"\r\n";for(h=this.getHeaders("via"),u=h.length,g;g<u;g++)d+="Via: "+h[g]+"\r\n";for(!this.to_tag&&i>100?p+=";tag="+t.Utils.newTag():this.to_tag&&!this.s("to").hasParam("tag")&&(p+=";tag="+this.to_tag),d+="To: "+p+"\r\n",d+="From: "+this.getHeader("From")+"\r\n",d+="Call-ID: "+this.call_id+"\r\n",d+="CSeq: "+this.cseq+" "+this.method+"\r\n",u=s.length,l=0;l<u;l++)d+=s[l].trim()+"\r\n";return d+=e(this),d+="User-Agent: "+this.ua.configuration.userAgentString+"\r\n",n?"string"==typeof n?(u=t.Utils.str_utf8_length(n),d+="Content-Type: application/sdp\r\n",d+="Content-Length: "+u+"\r\n\r\n",d+=n):n.body&&n.contentType?(u=t.Utils.str_utf8_length(n.body),d+="Content-Type: "+n.contentType+"\r\n",d+="Content-Length: "+u+"\r\n\r\n",d+=n.body):d+="Content-Length: 0\r\n\r\n":d+="Content-Length: 0\r\n\r\n",this.server_transaction.receiveResponse(i,d).then(o,a),d},s.prototype.reply_sl=function(e,i){var r,s,n=0,o=this.getHeaders("via"),a=o.length;for(s=t.Utils.buildStatusLine(e,i),n;n<a;n++)s+="Via: "+o[n]+"\r\n";r=this.getHeader("To"),!this.to_tag&&e>100?r+=";tag="+t.Utils.newTag():this.to_tag&&!this.s("to").hasParam("tag")&&(r+=";tag="+this.to_tag),s+="To: "+r+"\r\n",s+="From: "+this.getHeader("From")+"\r\n",s+="Call-ID: "+this.call_id+"\r\n",s+="CSeq: "+this.cseq+" "+this.method+"\r\n",s+="User-Agent: "+this.ua.configuration.userAgentString+"\r\n",s+="Content-Length: 0\r\n\r\n",this.transport.send(s)},n=function(t){this.logger=t.getLogger("sip.sipmessage"),this.headers={},this.status_code=null,this.reason_phrase=null},n.prototype=new r,t.OutgoingRequest=i,t.IncomingRequest=s,t.IncomingResponse=n}},function(t,e,i){"use strict";t.exports=function(t){var e;e=function(e,i,r,s,n,o){var a,c,h,u;if(!r)throw new TypeError('missing or invalid "host" parameter');e=e||t.C.SIP,this.parameters={},this.headers={};for(a in n)this.setParam(a,n[a]);for(c in o)this.setHeader(c,o[c]);h={scheme:e,user:i,host:r,port:s},u={scheme:e.toLowerCase(),user:i,host:r.toLowerCase(),port:s},Object.defineProperties(this,{_normal:{get:function(){return u}},_raw:{get:function(){return h}},scheme:{get:function(){return u.scheme},set:function(t){h.scheme=t,u.scheme=t.toLowerCase()}},user:{get:function(){return u.user},set:function(t){u.user=h.user=t}},host:{get:function(){return u.host},set:function(t){h.host=t,u.host=t.toLowerCase()}},aor:{get:function(){return u.user+"@"+u.host}},port:{get:function(){return u.port},set:function(t){u.port=h.port=0===t?t:parseInt(t,10)||null}}})},e.prototype={setParam:function(t,e){t&&(this.parameters[t.toLowerCase()]=void 0===e||null===e?null:e.toString().toLowerCase())},getParam:function(t){if(t)return this.parameters[t.toLowerCase()]},hasParam:function(t){if(t)return this.parameters.hasOwnProperty(t.toLowerCase())&&!0||!1},deleteParam:function(t){var e;if(t=t.toLowerCase(),this.parameters.hasOwnProperty(t))return e=this.parameters[t],delete this.parameters[t],e},clearParams:function(){this.parameters={}},setHeader:function(e,i){this.headers[t.Utils.headerize(e)]=i instanceof Array?i:[i]},getHeader:function(e){if(e)return this.headers[t.Utils.headerize(e)]},hasHeader:function(e){if(e)return this.headers.hasOwnProperty(t.Utils.headerize(e))&&!0||!1},deleteHeader:function(e){var i;if(e=t.Utils.headerize(e),this.headers.hasOwnProperty(e))return i=this.headers[e],delete this.headers[e],i},clearHeaders:function(){this.headers={}},clone:function(){return new e(this._raw.scheme,this._raw.user,this._raw.host,this._raw.port,JSON.parse(JSON.stringify(this.parameters)),JSON.parse(JSON.stringify(this.headers)))},toRaw:function(){return this._toString(this._raw)},toString:function(){return this._toString(this._normal)},_toString:function(e){var i,r,s,n,o=[];n=e.scheme+":",e.scheme.toLowerCase().match("^sips?$")||(n+="//"),e.user&&(n+=t.Utils.escapeUser(e.user)+"@"),n+=e.host,(e.port||0===e.port)&&(n+=":"+e.port);for(r in this.parameters)n+=";"+r,null!==this.parameters[r]&&(n+="="+this.parameters[r]);for(i in this.headers)for(s in this.headers[i])o.push(i+"="+this.headers[i][s]);return o.length>0&&(n+="?"+o.join("&")),n}},e.parse=function(e){return e=t.Grammar.parse(e,"SIP_URI"),-1!==e?e:void 0},t.URI=e}},function(t,e,i){"use strict";t.exports=function(t){var e;e=function(e,i,r){var s;if(!(e&&e instanceof t.URI))throw new TypeError('missing or invalid "uri" parameter');this.uri=e,this.parameters={};for(s in r)this.setParam(s,r[s]);Object.defineProperties(this,{friendlyName:{get:function(){return this.displayName||e.aor}},displayName:{get:function(){return i},set:function(t){i=0===t?"0":t}}})},e.prototype={setParam:function(t,e){t&&(this.parameters[t.toLowerCase()]=void 0===e||null===e?null:e.toString())},getParam:t.URI.prototype.getParam,hasParam:t.URI.prototype.hasParam,deleteParam:t.URI.prototype.deleteParam,clearParams:t.URI.prototype.clearParams,clone:function(){return new e(this.uri.clone(),this.displayName,JSON.parse(JSON.stringify(this.parameters)))},toString:function(){var t,e;t=this.displayName||0===this.displayName?'"'+this.displayName+'" ':"",t+="<"+this.uri.toString()+">";for(e in this.parameters)t+=";"+e,null!==this.parameters[e]&&(t+="="+this.parameters[e]);return t}},e.parse=function(e){return e=t.Grammar.parse(e,"Name_Addr_Header"),-1!==e?e:void 0},t.NameAddrHeader=e}},function(t,e,i){"use strict";t.exports=function(t){function e(t,e,i){var r;return r="SIP/2.0/"+(t.ua.configuration.hackViaTcp?"TCP":e.server.scheme),r+=" "+t.ua.configuration.viaHost+";branch="+i,t.ua.configuration.forceRport&&(r+=";rport"),r}var i={STATUS_TRYING:1,STATUS_PROCEEDING:2,STATUS_CALLING:3,STATUS_ACCEPTED:4,STATUS_COMPLETED:5,STATUS_TERMINATED:6,STATUS_CONFIRMED:7,NON_INVITE_CLIENT:"nict",NON_INVITE_SERVER:"nist",INVITE_CLIENT:"ict",INVITE_SERVER:"ist"},r=function(t,r,s){var n;this.type=i.NON_INVITE_CLIENT,this.transport=s,this.id="z9hG4bK"+Math.floor(1e7*Math.random()),this.request_sender=t,this.request=r,this.logger=t.ua.getLogger("sip.transaction.nict",this.id),n=e(t,s,this.id),this.request.setHeader("via",n),this.request_sender.ua.newTransaction(this)};r.prototype=Object.create(t.EventEmitter.prototype),r.prototype.stateChanged=function(t){this.state=t,this.emit("stateChanged")},r.prototype.send=function(){var e=this;this.stateChanged(i.STATUS_TRYING),this.F=t.Timers.setTimeout(e.timer_F.bind(e),t.Timers.TIMER_F),this.transport.send(this.request)||this.onTransportError()},r.prototype.onTransportError=function(){this.logger.log("transport error occurred, deleting non-INVITE client transaction "+this.id),t.Timers.clearTimeout(this.F),t.Timers.clearTimeout(this.K),this.stateChanged(i.STATUS_TERMINATED),this.request_sender.ua.destroyTransaction(this),this.request_sender.onTransportError()},r.prototype.timer_F=function(){this.logger.log("Timer F expired for non-INVITE client transaction "+this.id),this.stateChanged(i.STATUS_TERMINATED),this.request_sender.ua.destroyTransaction(this),this.request_sender.onRequestTimeout()},r.prototype.timer_K=function(){this.stateChanged(i.STATUS_TERMINATED),this.request_sender.ua.destroyTransaction(this)},r.prototype.receiveResponse=function(e){var r=this,s=e.status_code;if(s<200)switch(this.state){case i.STATUS_TRYING:case i.STATUS_PROCEEDING:this.stateChanged(i.STATUS_PROCEEDING),this.request_sender.receiveResponse(e)}else switch(this.state){case i.STATUS_TRYING:case i.STATUS_PROCEEDING:this.stateChanged(i.STATUS_COMPLETED),t.Timers.clearTimeout(this.F),408===s?this.request_sender.onRequestTimeout():this.request_sender.receiveResponse(e),this.K=t.Timers.setTimeout(r.timer_K.bind(r),t.Timers.TIMER_K)}};var s=function(t,r,s){var n,o=this;this.type=i.INVITE_CLIENT,this.transport=s,this.id="z9hG4bK"+Math.floor(1e7*Math.random()),this.request_sender=t,this.request=r,this.logger=t.ua.getLogger("sip.transaction.ict",this.id),n=e(t,s,this.id),this.request.setHeader("via",n),this.request_sender.ua.newTransaction(this),this.request.cancel=function(t,e){e=(e||[]).slice();for(var i=e.length,r=null,s=0;s<i;s++)r=(r||"")+e[s].trim()+"\r\n";o.cancel_request(o,t,r)}};s.prototype=Object.create(t.EventEmitter.prototype),s.prototype.stateChanged=function(t){this.state=t,this.emit("stateChanged")},s.prototype.send=function(){var e=this;this.stateChanged(i.STATUS_CALLING),this.B=t.Timers.setTimeout(e.timer_B.bind(e),t.Timers.TIMER_B),this.transport.send(this.request)||this.onTransportError()},s.prototype.onTransportError=function(){this.logger.log("transport error occurred, deleting INVITE client transaction "+this.id),t.Timers.clearTimeout(this.B),t.Timers.clearTimeout(this.D),t.Timers.clearTimeout(this.M),this.stateChanged(i.STATUS_TERMINATED),this.request_sender.ua.destroyTransaction(this),this.state!==i.STATUS_ACCEPTED&&this.request_sender.onTransportError()},s.prototype.timer_M=function(){this.logger.log("Timer M expired for INVITE client transaction "+this.id),this.state===i.STATUS_ACCEPTED&&(t.Timers.clearTimeout(this.B),this.stateChanged(i.STATUS_TERMINATED),this.request_sender.ua.destroyTransaction(this))},s.prototype.timer_B=function(){this.logger.log("Timer B expired for INVITE client transaction "+this.id),this.state===i.STATUS_CALLING&&(this.stateChanged(i.STATUS_TERMINATED),this.request_sender.ua.destroyTransaction(this),this.request_sender.onRequestTimeout())},s.prototype.timer_D=function(){this.logger.log("Timer D expired for INVITE client transaction "+this.id),t.Timers.clearTimeout(this.B),this.stateChanged(i.STATUS_TERMINATED),this.request_sender.ua.destroyTransaction(this)},s.prototype.sendACK=function(e){var i,r=this;e=e||{},i=this.response.getHeader("contact")?this.response.getHeader("contact").replace(/</g,"").replace(/>/g,""):this.request.ruri;var s=new t.OutgoingRequest("ACK",i,this.request.ua,{cseq:this.response.cseq,call_id:this.response.call_id,from_uri:this.response.from.uri,from_tag:this.response.from_tag,to_uri:this.response.to.uri,to_tag:this.response.to_tag,route_set:this.response.getHeaders("record-route").reverse()},e.extraHeaders||[],e.body);return this.ackSender=new t.RequestSender({request:s,onRequestTimeout:this.request_sender.applicant.applicant?this.request_sender.applicant.applicant.onRequestTimeout:function(){r.logger.warn("ACK Request timed out")},onTransportError:this.request_sender.applicant.applicant?this.request_sender.applicant.applicant.onRequestTransportError:function(){r.loigger.warn("ACK Request had a transport error")},receiveResponse:e.receiveResponse||function(){r.logger.warn("Received a response to an ACK which was unexpected. Dropping Response.")}},this.request.ua).send(),s},s.prototype.cancel_request=function(e,r,s){var n=e.request;this.cancel=t.C.CANCEL+" "+n.ruri+" SIP/2.0\r\n",this.cancel+="Via: "+n.headers.Via.toString()+"\r\n",this.request.headers.Route&&(this.cancel+="Route: "+n.headers.Route.toString()+"\r\n"),this.cancel+="To: "+n.headers.To.toString()+"\r\n",this.cancel+="From: "+n.headers.From.toString()+"\r\n",this.cancel+="Call-ID: "+n.headers["Call-ID"].toString()+"\r\n",this.cancel+="CSeq: "+n.headers.CSeq.toString().split(" ")[0]+" CANCEL\r\n",r&&(this.cancel+="Reason: "+r+"\r\n"),s&&(this.cancel+=s),this.cancel+="Content-Length: 0\r\n\r\n",this.state===i.STATUS_PROCEEDING&&this.transport.send(this.cancel)},s.prototype.receiveResponse=function(e){var r=this,s=e.status_code;if(e.transaction=this,this.response&&this.response.status_code===e.status_code&&this.response.cseq===e.cseq)return this.logger.debug("ICT Received a retransmission for cseq: "+e.cseq),void(this.ackSender&&this.ackSender.send());if(this.response=e,s>=100&&s<=199)switch(this.state){case i.STATUS_CALLING:this.stateChanged(i.STATUS_PROCEEDING),this.request_sender.receiveResponse(e),this.cancel&&this.transport.send(this.cancel);break;case i.STATUS_PROCEEDING:this.request_sender.receiveResponse(e)}else if(s>=200&&s<=299)switch(this.state){case i.STATUS_CALLING:case i.STATUS_PROCEEDING:this.stateChanged(i.STATUS_ACCEPTED),this.M=t.Timers.setTimeout(r.timer_M.bind(r),t.Timers.TIMER_M),this.request_sender.receiveResponse(e);break;case i.STATUS_ACCEPTED:this.request_sender.receiveResponse(e)}else if(s>=300&&s<=699)switch(this.state){case i.STATUS_CALLING:case i.STATUS_PROCEEDING:this.stateChanged(i.STATUS_COMPLETED),this.sendACK(),this.request_sender.receiveResponse(e);break;case i.STATUS_COMPLETED:this.sendACK()}};var n=function(t,i,r){var s;this.transport=r,this.id="z9hG4bK"+Math.floor(1e7*Math.random()),this.request_sender=t,this.request=i,this.logger=t.ua.getLogger("sip.transaction.nict",this.id),s=e(t,r,this.id),this.request.setHeader("via",s)};n.prototype=Object.create(t.EventEmitter.prototype),n.prototype.send=function(){this.transport.send(this.request)||this.onTransportError()},n.prototype.onTransportError=function(){this.logger.log("transport error occurred, for an ACK client transaction "+this.id),this.request_sender.onTransportError()};var o=function(t,e){this.type=i.NON_INVITE_SERVER,this.id=t.via_branch,this.request=t,this.transport=t.transport,this.ua=e,this.last_response="",t.server_transaction=this,this.logger=e.getLogger("sip.transaction.nist",this.id),this.state=i.STATUS_TRYING,e.newTransaction(this)};o.prototype=Object.create(t.EventEmitter.prototype),o.prototype.stateChanged=function(t){this.state=t,this.emit("stateChanged")},o.prototype.timer_J=function(){this.logger.log("Timer J expired for non-INVITE server transaction "+this.id),this.stateChanged(i.STATUS_TERMINATED),this.ua.destroyTransaction(this)},o.prototype.onTransportError=function(){this.transportError||(this.transportError=!0,this.logger.log("transport error occurred, deleting non-INVITE server transaction "+this.id),t.Timers.clearTimeout(this.J),this.stateChanged(i.STATUS_TERMINATED),this.ua.destroyTransaction(this))},o.prototype.receiveResponse=function(e,r){var s=this,n=t.Utils.defer();if(100===e)switch(this.state){case i.STATUS_TRYING:this.stateChanged(i.STATUS_PROCEEDING),this.transport.send(r)||this.onTransportError();break;case i.STATUS_PROCEEDING:this.last_response=r,this.transport.send(r)?n.resolve():(this.onTransportError(),n.reject())}else if(e>=200&&e<=699)switch(this.state){case i.STATUS_TRYING:case i.STATUS_PROCEEDING:this.stateChanged(i.STATUS_COMPLETED),this.last_response=r,this.J=t.Timers.setTimeout(s.timer_J.bind(s),t.Timers.TIMER_J),this.transport.send(r)?n.resolve():(this.onTransportError(),n.reject())}return n.promise};var a=function(t,e){this.type=i.INVITE_SERVER,this.id=t.via_branch,this.request=t,this.transport=t.transport,this.ua=e,this.last_response="",t.server_transaction=this,this.logger=e.getLogger("sip.transaction.ist",this.id),this.state=i.STATUS_PROCEEDING,e.newTransaction(this),this.resendProvisionalTimer=null,t.reply(100)};a.prototype=Object.create(t.EventEmitter.prototype),a.prototype.stateChanged=function(t){this.state=t,this.emit("stateChanged")},a.prototype.timer_H=function(){this.logger.log("Timer H expired for INVITE server transaction "+this.id),this.state===i.STATUS_COMPLETED&&this.logger.warn("transactions","ACK for INVITE server transaction was never received, call will be terminated"),this.stateChanged(i.STATUS_TERMINATED),this.ua.destroyTransaction(this)},a.prototype.timer_I=function(){this.stateChanged(i.STATUS_TERMINATED),this.ua.destroyTransaction(this)},a.prototype.timer_L=function(){this.logger.log("Timer L expired for INVITE server transaction "+this.id),this.state===i.STATUS_ACCEPTED&&(this.stateChanged(i.STATUS_TERMINATED),this.ua.destroyTransaction(this))},a.prototype.onTransportError=function(){this.transportError||(this.transportError=!0,this.logger.log("transport error occurred, deleting INVITE server transaction "+this.id),null!==this.resendProvisionalTimer&&(t.Timers.clearInterval(this.resendProvisionalTimer),this.resendProvisionalTimer=null),t.Timers.clearTimeout(this.L),t.Timers.clearTimeout(this.H),t.Timers.clearTimeout(this.I),this.stateChanged(i.STATUS_TERMINATED),this.ua.destroyTransaction(this))},a.prototype.resend_provisional=function(){this.transport.send(this.last_response)||this.onTransportError()},a.prototype.receiveResponse=function(e,r){var s=this,n=t.Utils.defer();if(e>=100&&e<=199)switch(this.state){case i.STATUS_PROCEEDING:this.transport.send(r)||this.onTransportError(),this.last_response=r}if(e>100&&e<=199&&this.state===i.STATUS_PROCEEDING)null===this.resendProvisionalTimer&&(this.resendProvisionalTimer=t.Timers.setInterval(s.resend_provisional.bind(s),t.Timers.PROVISIONAL_RESPONSE_INTERVAL));else if(e>=200&&e<=299)switch(this.state){case i.STATUS_PROCEEDING:this.stateChanged(i.STATUS_ACCEPTED),this.last_response=r,this.L=t.Timers.setTimeout(s.timer_L.bind(s),t.Timers.TIMER_L),null!==this.resendProvisionalTimer&&(t.Timers.clearInterval(this.resendProvisionalTimer),this.resendProvisionalTimer=null);case i.STATUS_ACCEPTED:this.transport.send(r)?n.resolve():(this.onTransportError(),n.reject())}else if(e>=300&&e<=699)switch(this.state){case i.STATUS_PROCEEDING:null!==this.resendProvisionalTimer&&(t.Timers.clearInterval(this.resendProvisionalTimer),this.resendProvisionalTimer=null),this.transport.send(r)?(this.stateChanged(i.STATUS_COMPLETED),this.H=t.Timers.setTimeout(s.timer_H.bind(s),t.Timers.TIMER_H),n.resolve()):(this.onTransportError(),n.reject())}return n.promise};var c=function(e,r){var s;switch(r.method){case t.C.INVITE:if(s=e.transactions.ist[r.via_branch]){switch(s.state){case i.STATUS_PROCEEDING:s.transport.send(s.last_response)}return!0}break;case t.C.ACK:if(!(s=e.transactions.ist[r.via_branch]))return!1;if(s.state===i.STATUS_ACCEPTED)return!1;if(s.state===i.STATUS_COMPLETED)return s.stateChanged(i.STATUS_CONFIRMED),s.I=t.Timers.setTimeout(s.timer_I.bind(s),t.Timers.TIMER_I),!0;break;case t.C.CANCEL:return s=e.transactions.ist[r.via_branch],s?(r.reply_sl(200),s.state!==i.STATUS_PROCEEDING):(r.reply_sl(481),!0);default:if(s=e.transactions.nist[r.via_branch]){switch(s.state){case i.STATUS_TRYING:break;case i.STATUS_PROCEEDING:case i.STATUS_COMPLETED:s.transport.send(s.last_response)}return!0}}};t.Transactions={C:i,checkTransaction:c,NonInviteClientTransaction:r,InviteClientTransaction:s,AckClientTransaction:n,NonInviteServerTransaction:o,InviteServerTransaction:a}}},function(t,e,i){"use strict";t.exports=function(t){var e,r=i(17)(t),s={STATUS_EARLY:1,STATUS_CONFIRMED:2};e=function(e,i,r,n){var o;if(this.uac_pending_reply=!1,this.uas_pending_reply=!1,!i.hasHeader("contact"))return{error:"unable to create a Dialog without Contact header field"};n=i instanceof t.IncomingResponse?i.status_code<200?s.STATUS_EARLY:s.STATUS_CONFIRMED:n||s.STATUS_CONFIRMED,o=i.parseHeader("contact"),"UAS"===r?(this.id={call_id:i.call_id,local_tag:i.to_tag,remote_tag:i.from_tag,toString:function(){return this.call_id+this.local_tag+this.remote_tag}},this.state=n,this.remote_seqnum=i.cseq,this.local_uri=i.parseHeader("to").uri,this.remote_uri=i.parseHeader("from").uri,this.remote_target=o.uri,this.route_set=i.getHeaders("record-route"),this.invite_seqnum=i.cseq,this.local_seqnum=i.cseq):"UAC"===r&&(this.id={call_id:i.call_id,local_tag:i.from_tag,remote_tag:i.to_tag,toString:function(){return this.call_id+this.local_tag+this.remote_tag}},this.state=n,this.invite_seqnum=i.cseq,this.local_seqnum=i.cseq,this.local_uri=i.parseHeader("from").uri,this.pracked=[],this.remote_uri=i.parseHeader("to").uri,this.remote_target=o.uri,this.route_set=i.getHeaders("record-route").reverse()),this.logger=e.ua.getLogger("sip.dialog",this.id.toString()),this.owner=e,e.ua.dialogs[this.id.toString()]=this,this.logger.log("new "+r+" dialog created with status "+(this.state===s.STATUS_EARLY?"EARLY":"CONFIRMED")),e.emit("dialog",this)},e.prototype={update:function(t,e){this.state=s.STATUS_CONFIRMED,this.logger.log("dialog "+this.id.toString()+"  changed to CONFIRMED state"),"UAC"===e&&(this.route_set=t.getHeaders("record-route").reverse())},terminate:function(){this.logger.log("dialog "+this.id.toString()+" deleted"),this.sessionDescriptionHandler&&this.state!==s.STATUS_CONFIRMED&&this.sessionDescriptionHandler.close(),delete this.owner.ua.dialogs[this.id.toString()]},createRequest:function(e,i,r){var s,n;return i=(i||[]).slice(),this.local_seqnum||(this.local_seqnum=Math.floor(1e4*Math.random())),s=e===t.C.CANCEL||e===t.C.ACK?this.invite_seqnum:this.local_seqnum+=1,n=new t.OutgoingRequest(e,this.remote_target,this.owner.ua,{cseq:s,call_id:this.id.call_id,from_uri:this.local_uri,from_tag:this.id.local_tag,to_uri:this.remote_uri,to_tag:this.id.remote_tag,route_set:this.route_set},i,r),n.dialog=this,n},checkInDialogRequest:function(e){var i=this;if(this.remote_seqnum){if(e.cseq<this.remote_seqnum)return e.method!==t.C.ACK&&e.reply(500),e.cseq===this.invite_seqnum}else this.remote_seqnum=e.cseq;switch(e.method){case t.C.INVITE:if(!0===this.uac_pending_reply)e.reply(491);else{if(!0===this.uas_pending_reply&&e.cseq>this.remote_seqnum){var r=1+(10*Math.random()|0);return e.reply(500,null,["Retry-After:"+r]),this.remote_seqnum=e.cseq,!1}this.uas_pending_reply=!0,e.server_transaction.on("stateChanged",function e(){this.state!==t.Transactions.C.STATUS_ACCEPTED&&this.state!==t.Transactions.C.STATUS_COMPLETED&&this.state!==t.Transactions.C.STATUS_TERMINATED||(this.removeListener("stateChanged",e),i.uas_pending_reply=!1)})}e.hasHeader("contact")&&e.server_transaction.on("stateChanged",function(){this.state===t.Transactions.C.STATUS_ACCEPTED&&(i.remote_target=e.parseHeader("contact").uri)});break;case t.C.NOTIFY:e.hasHeader("contact")&&e.server_transaction.on("stateChanged",function(){this.state===t.Transactions.C.STATUS_COMPLETED&&(i.remote_target=e.parseHeader("contact").uri)})}return e.cseq>this.remote_seqnum&&(this.remote_seqnum=e.cseq),!0},sendRequest:function(t,e,i){i=i||{};var s=(i.extraHeaders||[]).slice(),n=null;i.body&&(i.body.body?n=i.body:(n={},n.body=i.body,i.contentType&&(n.contentType=i.contentType)));var o=this.createRequest(e,s,n);return new r(this,t,o).send(),o},receiveRequest:function(t){this.checkInDialogRequest(t)&&this.owner.receiveRequest(t)}},e.C=s,t.Dialog=e}},function(t,e,i){"use strict";t.exports=function(t){var e;return e=function(t,e,i){this.dialog=t,this.applicant=e,this.request=i,this.reattempt=!1,this.reattemptTimer=null},e.prototype={send:function(){var e=this,i=new t.RequestSender(this,this.dialog.owner.ua);i.send(),this.request.method===t.C.INVITE&&i.clientTransaction.state!==t.Transactions.C.STATUS_TERMINATED&&(this.dialog.uac_pending_reply=!0,i.clientTransaction.on("stateChanged",function i(){this.state!==t.Transactions.C.STATUS_ACCEPTED&&this.state!==t.Transactions.C.STATUS_COMPLETED&&this.state!==t.Transactions.C.STATUS_TERMINATED||(this.removeListener("stateChanged",i),e.dialog.uac_pending_reply=!1)}))},onRequestTimeout:function(){this.applicant.onRequestTimeout()},onTransportError:function(){this.applicant.onTransportError()},receiveResponse:function(e){var i=this;408===e.status_code||481===e.status_code?this.applicant.onDialogError(e):e.method===t.C.INVITE&&491===e.status_code?this.reattempt?this.applicant.receiveResponse(e):(this.request.cseq.value=this.dialog.local_seqnum+=1,this.reattemptTimer=t.Timers.setTimeout(function(){i.applicant.owner.status!==t.Session.C.STATUS_TERMINATED&&(i.reattempt=!0,i.request_sender.send())},this.getReattemptTimeout())):this.applicant.receiveResponse(e)}},e}},function(t,e,i){"use strict";t.exports=function(t){var e;e=function(e,i){this.logger=i.getLogger("sip.requestsender"),this.ua=i,this.applicant=e,this.method=e.request.method,this.request=e.request,this.credentials=null,this.challenged=!1,this.staled=!1,i.status!==t.UA.C.STATUS_USER_CLOSED||this.method===t.C.BYE&&this.method===t.C.ACK||this.onTransportError()},e.prototype={send:function(){switch(this.method){case"INVITE":this.clientTransaction=new t.Transactions.InviteClientTransaction(this,this.request,this.ua.transport);break;case"ACK":this.clientTransaction=new t.Transactions.AckClientTransaction(this,this.request,this.ua.transport);break;default:this.clientTransaction=new t.Transactions.NonInviteClientTransaction(this,this.request,this.ua.transport)}return this.clientTransaction.send(),this.clientTransaction},onRequestTimeout:function(){this.applicant.onRequestTimeout()},onTransportError:function(){this.applicant.onTransportError()},receiveResponse:function(e){var i,r,s,n=e.status_code;if(401===n||407===n){if(401===e.status_code?(r=e.parseHeader("www-authenticate"),s="authorization"):(r=e.parseHeader("proxy-authenticate"),s="proxy-authorization"),!r)return this.logger.warn(e.status_code+" with wrong or missing challenge, cannot authenticate"),void this.applicant.receiveResponse(e);if(!this.challenged||!this.staled&&!0===r.stale){if(this.credentials||(this.credentials=this.ua.configuration.authenticationFactory(this.ua)),!this.credentials.authenticate(this.request,r))return void this.applicant.receiveResponse(e);this.challenged=!0,r.stale&&(this.staled=!0),e.method===t.C.REGISTER?i=this.applicant.cseq+=1:this.request.dialog?i=this.request.dialog.local_seqnum+=1:(i=this.request.cseq+1,this.request.cseq=i),this.request.setHeader("cseq",i+" "+this.method),this.request.setHeader(s,this.credentials.toString()),this.send()}else this.applicant.receiveResponse(e)}else this.applicant.receiveResponse(e)}},t.RequestSender=e}},function(t,e,i){"use strict";t.exports=function(t){var e;e=function(e){var i={};this.registrar=e.configuration.registrarServer,this.expires=e.configuration.registerExpires,this.contact=e.contact.toString(),this.contact+=";reg-id=1",this.contact+=';+sip.instance="<urn:uuid:'+e.configuration.instanceId+'>"',this.call_id=t.Utils.createRandomToken(22),this.cseq=80,this.to_uri=e.configuration.uri,i.to_uri=this.to_uri,i.to_displayName=e.configuration.displayName,i.call_id=this.call_id,i.cseq=this.cseq,t.Utils.augment(this,t.ClientContext,[e,"REGISTER",this.registrar,{params:i}]),this.registrationTimer=null,this.registrationExpiredTimer=null,this.registered=!1,this.logger=e.getLogger("sip.registercontext")},e.prototype={register:function(e){var i,r=this;this.options=e||{},i=(this.options.extraHeaders||[]).slice(),i.push("Contact: "+this.contact+";expires="+this.expires),i.push("Allow: "+t.UA.C.ALLOWED_METHODS.toString()),this.closeHeaders=this.options.closeWithHeaders?(this.options.extraHeaders||[]).slice():[],this.receiveResponse=function(e){var i,s,n,o=e.getHeaders("contact").length;if(e.cseq===this.cseq)switch(null!==this.registrationTimer&&(t.Timers.clearTimeout(this.registrationTimer),this.registrationTimer=null),!0){case/^1[0-9]{2}$/.test(e.status_code):this.emit("progress",e);break;case/^2[0-9]{2}$/.test(e.status_code):if(this.emit("accepted",e),e.hasHeader("expires")&&(s=e.getHeader("expires")),null!==this.registrationExpiredTimer&&(t.Timers.clearTimeout(this.registrationExpiredTimer),this.registrationExpiredTimer=null),!o){this.logger.warn("no Contact header in response to REGISTER, response ignored");break}for(;o--;){if(i=e.parseHeader("contact",o),i.uri.user===this.ua.contact.uri.user){s=i.getParam("expires");break}i=null}if(!i){this.logger.warn("no Contact header pointing to us, response ignored");break}s||(s=this.expires),this.registrationTimer=t.Timers.setTimeout(function(){r.registrationTimer=null,r.register(r.options)},1e3*s-3e3),this.registrationExpiredTimer=t.Timers.setTimeout(function(){r.logger.warn("registration expired"),r.registered&&r.unregistered(null,t.C.causes.EXPIRES)},1e3*s),i.hasParam("temp-gruu")&&(this.ua.contact.temp_gruu=t.URI.parse(i.getParam("temp-gruu").replace(/"/g,""))),i.hasParam("pub-gruu")&&(this.ua.contact.pub_gruu=t.URI.parse(i.getParam("pub-gruu").replace(/"/g,""))),this.registered=!0,this.emit("registered",e||null);break;case/^423$/.test(e.status_code):e.hasHeader("min-expires")?(this.expires=e.getHeader("min-expires"),this.register(this.options)):(this.logger.warn("423 response received for REGISTER without Min-Expires"),this.registrationFailure(e,t.C.causes.SIP_FAILURE_CODE));break;default:n=t.Utils.sipErrorCause(e.status_code),this.registrationFailure(e,n)}},this.onRequestTimeout=function(){this.registrationFailure(null,t.C.causes.REQUEST_TIMEOUT)},this.onTransportError=function(){this.registrationFailure(null,t.C.causes.CONNECTION_ERROR)},this.cseq++,this.request.cseq=this.cseq,this.request.setHeader("cseq",this.cseq+" REGISTER"),this.request.extraHeaders=i,this.send()},registrationFailure:function(t,e){this.emit("failed",t||null,e||null)},onTransportClosed:function(){this.registered_before=this.registered,null!==this.registrationTimer&&(t.Timers.clearTimeout(this.registrationTimer),this.registrationTimer=null),null!==this.registrationExpiredTimer&&(t.Timers.clearTimeout(this.registrationExpiredTimer),this.registrationExpiredTimer=null),this.registered&&this.unregistered(null,t.C.causes.CONNECTION_ERROR)},onTransportConnected:function(){this.register(this.options)},close:function(){var t={all:!1,extraHeaders:this.closeHeaders};this.registered_before=this.registered,this.registered&&this.unregister(t)},unregister:function(e){var i;e=e||{},this.registered||e.all||this.logger.warn("Already unregistered, but sending an unregister anyways."),i=(e.extraHeaders||[]).slice(),this.registered=!1,null!==this.registrationTimer&&(t.Timers.clearTimeout(this.registrationTimer),this.registrationTimer=null),e.all?(i.push("Contact: *"),i.push("Expires: 0")):i.push("Contact: "+this.contact+";expires=0"),this.receiveResponse=function(e){var i;switch(!0){case/^1[0-9]{2}$/.test(e.status_code):this.emit("progress",e);break;case/^2[0-9]{2}$/.test(e.status_code):this.emit("accepted",e),null!==this.registrationExpiredTimer&&(t.Timers.clearTimeout(this.registrationExpiredTimer),this.registrationExpiredTimer=null),this.unregistered(e);break;default:i=t.Utils.sipErrorCause(e.status_code),this.unregistered(e,i)}},this.onRequestTimeout=function(){},this.onTransportError=function(){},this.cseq++,this.request.cseq=this.cseq,this.request.setHeader("cseq",this.cseq+" REGISTER"),this.request.extraHeaders=i,this.send()},unregistered:function(t,e){this.registered=!1,this.emit("unregistered",t||null,e||null)}},t.RegisterContext=e}},function(t,e,i){"use strict";t.exports=function(t){var e=function(t,e){};return e.prototype=Object.create(t.prototype,{close:{value:function(){}},getDescription:{value:function(t,e){}},hasDescription:{value:function(t){}},holdModifier:{value:function(t){}},setDescription:{value:function(t,e,i){}}}),e}},function(t,e,i){"use strict";t.exports=function(t){var e;e=function(e,i,r,s){var n=r;if(void 0===r)throw new TypeError("Not enough arguments");if(this.ua=e,this.logger=e.getLogger("sip.clientcontext"),this.method=i,!(r=e.normalizeTarget(r)))throw new TypeError("Invalid target: "+n);s=Object.create(s||Object.prototype),s.extraHeaders=(s.extraHeaders||[]).slice(),this.request=new t.OutgoingRequest(this.method,r,this.ua,s.params,s.extraHeaders),s.body&&(this.body={},this.body.body=s.body,s.contentType&&(this.body.contentType=s.contentType),this.request.body=this.body),this.localIdentity=this.request.from,this.remoteIdentity=this.request.to,this.data={}},e.prototype=Object.create(t.EventEmitter.prototype),e.prototype.send=function(){return new t.RequestSender(this,this.ua).send(),this},e.prototype.cancel=function(e){e=e||{},e.extraHeaders=(e.extraHeaders||[]).slice();var i=t.Utils.getCancelReason(e.status_code,e.reason_phrase);this.request.cancel(i,e.extraHeaders),this.emit("cancel")},e.prototype.receiveResponse=function(e){var i=t.Utils.getReasonPhrase(e.status_code);switch(!0){case/^1[0-9]{2}$/.test(e.status_code):this.emit("progress",e,i);break;case/^2[0-9]{2}$/.test(e.status_code):this.ua.applicants[this]&&delete this.ua.applicants[this],this.emit("accepted",e,i);break;default:this.ua.applicants[this]&&delete this.ua.applicants[this],this.emit("rejected",e,i),this.emit("failed",e,i)}},e.prototype.onRequestTimeout=function(){this.emit("failed",null,t.C.causes.REQUEST_TIMEOUT)},e.prototype.onTransportError=function(){this.emit("failed",null,t.C.causes.CONNECTION_ERROR)},t.ClientContext=e}},function(t,e,i){"use strict";t.exports=function(t){var e;e=function(e,i){this.ua=e,this.logger=e.getLogger("sip.servercontext"),this.request=i,i.method===t.C.INVITE?this.transaction=new t.Transactions.InviteServerTransaction(i,e):this.transaction=new t.Transactions.NonInviteServerTransaction(i,e),i.body&&(this.body=i.body),i.hasHeader("Content-Type")&&(this.contentType=i.getHeader("Content-Type")),this.method=i.method,this.data={},this.localIdentity=i.to,this.remoteIdentity=i.from},e.prototype=Object.create(t.EventEmitter.prototype),e.prototype.progress=function(t){return t=Object.create(t||Object.prototype),t.statusCode||(t.statusCode=180),t.minCode=100,t.maxCode=199,t.events=["progress"],this.reply(t)},e.prototype.accept=function(t){return t=Object.create(t||Object.prototype),t.statusCode||(t.statusCode=200),t.minCode=200,t.maxCode=299,t.events=["accepted"],this.reply(t)},e.prototype.reject=function(t){return t=Object.create(t||Object.prototype),t.statusCode||(t.statusCode=480),t.minCode=300,t.maxCode=699,t.events=["rejected","failed"],this.reply(t)},e.prototype.reply=function(e){e=e||{};var i,r=e.statusCode||100,s=e.minCode||100,n=e.maxCode||699,o=t.Utils.getReasonPhrase(r,e.reasonPhrase),a=e.extraHeaders||[],c=e.body,h=e.events||[];if(r<s||r>n)throw new TypeError("Invalid statusCode: "+r);return i=this.request.reply(r,o,a,c),h.forEach(function(t){this.emit(t,i,o)},this),this},e.prototype.onRequestTimeout=function(){this.emit("failed",null,t.C.causes.REQUEST_TIMEOUT)},e.prototype.onTransportError=function(){this.emit("failed",null,t.C.causes.CONNECTION_ERROR)},t.ServerContext=e}},function(t,e,i){"use strict";t.exports=function(t,e){var r,s,n,o=i(24)(t),a={STATUS_NULL:0,STATUS_INVITE_SENT:1,STATUS_1XX_RECEIVED:2,STATUS_INVITE_RECEIVED:3,STATUS_WAITING_FOR_ANSWER:4,STATUS_ANSWERED:5,STATUS_WAITING_FOR_PRACK:6,STATUS_WAITING_FOR_ACK:7,STATUS_CANCELED:8,STATUS_TERMINATED:9,STATUS_ANSWERED_WAITING_FOR_PRACK:10,STATUS_EARLY_MEDIA:11,STATUS_CONFIRMED:12};r=function(e){if(this.status=a.STATUS_NULL,this.dialog=null,this.pendingReinvite=!1,this.earlyDialogs={},!e)throw new t.Exceptions.SessionDescriptionHandlerMissing("A session description handler is required for the session to function");this.sessionDescriptionHandlerFactory=e,this.hasOffer=!1,this.hasAnswer=!1,this.timers={ackTimer:null,expiresTimer:null,invite2xxTimer:null,userNoAnswerTimer:null,rel1xxTimer:null,prackTimer:null},this.startTime=null,this.endTime=null,this.tones=null,this.local_hold=!1,this.remote_hold=!1,this.disableRenegotiation=!1,this.early_sdp=null,this.rel100=t.C.supported.UNSUPPORTED},r.prototype={dtmf:function(e,i){var r=[],s=this;if(i=i||{},void 0===e)throw new TypeError("Not enough arguments");if(this.status!==a.STATUS_CONFIRMED&&this.status!==a.STATUS_WAITING_FOR_ACK)throw new t.Exceptions.InvalidStateError(this.status);if("string"!=typeof e&&"number"!=typeof e||!e.toString().match(/^[0-9A-D#*,]+$/i))throw new TypeError("Invalid tones: "+e);for(e=e.toString().split("");e.length>0;)r.push(new o(this,e.shift(),i));if(this.tones)return this.tones=this.tones.concat(r),this;var n=function(){var e,r;if(s.status===a.STATUS_TERMINATED||!s.tones||0===s.tones.length)return s.tones=null,this;e=s.tones.shift(),e.on("failed",function(){s.tones=null}),e.send(i),r=e.duration+e.interToneGap,t.Timers.setTimeout(n,r)};return this.tones=r,n(),this},bye:function(e){e=Object.create(e||Object.prototype);var i=e.statusCode;if(this.status===a.STATUS_TERMINATED)return this.logger.error("Error: Attempted to send BYE in a terminated session."),this;if(this.logger.log("terminating Session"),i&&(i<200||i>=700))throw new TypeError("Invalid statusCode: "+i);return e.receiveResponse=function(){},this.sendRequest(t.C.BYE,e).terminated()},refer:function(e,i){i=i||{};var r=(i.extraHeaders||[]).slice(),s=e instanceof t.InviteServerContext||e instanceof t.InviteClientContext,n=e;if(void 0===e)throw new TypeError("Not enough arguments");if(this.status!==a.STATUS_CONFIRMED)throw new t.Exceptions.InvalidStateError(this.status);if(s)e='"'+e.remoteIdentity.friendlyName+'" <'+e.dialog.remote_target.toString()+"?Replaces="+e.dialog.id.call_id+"%3Bto-tag%3D"+e.dialog.id.remote_tag+"%3Bfrom-tag%3D"+e.dialog.id.local_tag+">";else{try{e=t.Grammar.parse(e,"Refer_To").uri||e}catch(t){this.logger.debug(".refer() cannot parse Refer_To from",e),this.logger.debug("...falling through to normalizeTarget()")}if(!(e=this.ua.normalizeTarget(e)))throw new TypeError("Invalid target: "+n)}return r.push("Contact: "+this.contact),r.push("Allow: "+t.UA.C.ALLOWED_METHODS.toString()),r.push("Refer-To: "+e),this.sendRequest(t.C.REFER,{extraHeaders:r,body:i.body,receiveResponse:function(t){/^2[0-9]{2}$/.test(t.status_code)&&(s||e.scheme&&e.scheme.match("^sips?$"))&&this.terminate()}.bind(this)}),this},followRefer:function(t){return function(t,i){var r=i.parseHeader("refer-to"),s=r.uri;if(!s.scheme.match("^sips?$")){var n=s.toString();return void("function"==typeof e.open?e.open(n):this.logger.warn("referred to non-SIP URI but `open` isn't in the environment: "+n))}var o=[],a=s.getHeader("Replaces");void 0!==a&&o.push("Replaces: "+decodeURIComponent(a)),s.clearHeaders();var c=this.passedOptions||{};c.params=c.params||{},c.params.to_displayName=r.friendlyName,c.extraHeaders=o,this.sessionDescriptionHandler&&(c.sessionDescriptionHandlerOptions=this.sessionDescriptionHandler.options);var h=this.ua.invite(s,c,this.modifiers);t.call(this,i,h),this.terminate()}.bind(this,t)},sendRequest:function(e,i){i=i||{};var r=this,s=new t.OutgoingRequest(e,this.dialog.remote_target,this.ua,{cseq:i.cseq||(this.dialog.local_seqnum+=1),call_id:this.dialog.id.call_id,from_uri:this.dialog.local_uri,from_tag:this.dialog.id.local_tag,to_uri:this.dialog.remote_uri,to_tag:this.dialog.id.remote_tag,route_set:this.dialog.route_set,statusCode:i.statusCode,reasonPhrase:i.reasonPhrase},i.extraHeaders||[],i.body);return new t.RequestSender({request:s,onRequestTimeout:function(){r.onRequestTimeout()},onTransportError:function(){r.onTransportError()},receiveResponse:i.receiveResponse||function(t){r.receiveNonInviteResponse(t)}},this.ua).send(),this.emit(e.toLowerCase(),s),this},close:function(){var e;if(this.status===a.STATUS_TERMINATED)return this;this.logger.log("closing INVITE session "+this.id),this.sessionDescriptionHandler&&this.sessionDescriptionHandler.close();for(e in this.timers)t.Timers.clearTimeout(this.timers[e]);this.dialog&&(this.dialog.terminate(),delete this.dialog);for(e in this.earlyDialogs)this.earlyDialogs[e].terminate(),delete this.earlyDialogs[e];return this.status=a.STATUS_TERMINATED,delete this.ua.sessions[this.id],this},createDialog:function(e,i,r){var s,n,o=e["UAS"===i?"to_tag":"from_tag"],a=e["UAS"===i?"from_tag":"to_tag"],c=e.call_id+o+a;if(n=this.earlyDialogs[c],r)return!!n||(n=new t.Dialog(this,e,i,t.Dialog.C.STATUS_EARLY),n.error?(this.logger.error(n.error),this.failed(e,t.C.causes.INTERNAL_ERROR),!1):(this.earlyDialogs[c]=n,!0));if(n){n.update(e,i),this.dialog=n,delete this.earlyDialogs[c];for(var h in this.earlyDialogs)this.earlyDialogs[h].terminate(),delete this.earlyDialogs[h];return!0}return s=new t.Dialog(this,e,i),s.error?(this.logger.error(s.error),this.failed(e,t.C.causes.INTERNAL_ERROR),!1):(this.to_tag=e.to_tag,this.dialog=s,!0)},hold:function(e,i){if(this.status!==a.STATUS_WAITING_FOR_ACK&&this.status!==a.STATUS_CONFIRMED)throw new t.Exceptions.InvalidStateError(this.status);if(this.isOnHold().local)return void this.logger.log("Session is already on hold, cannot put it on hold again");e=e||{},i&&(e.modifiers=i),this.onhold("local"),this.sendReinvite(e)},unhold:function(e,i){if(this.status!==a.STATUS_WAITING_FOR_ACK&&this.status!==a.STATUS_CONFIRMED)throw new t.Exceptions.InvalidStateError(this.status);if(!this.isOnHold().local)return void this.logger.log("Session is not on hold, cannot unhold it");e=e||{},i&&(e.modifiers=i),this.onunhold("local"),this.sendReinvite(e)},isOnHold:function(){return{local:this.local_hold,remote:this.remote_hold}},reinvite:function(t,e){return t=t||{},e&&(t.modifiers=e),this.sendReinvite(t)},receiveReinvite:function(e){var i=this;if(!this.sessionDescriptionHandler.hasDescription(e.getHeader("Content-Type")))return this.logger.warn("invalid Content-Type"),void e.reply(415);this.sessionDescriptionHandler.setDescription(e.body,this.sessionDescriptionHandlerOptions,this.modifiers).then(this.sessionDescriptionHandler.getDescription.bind(this.sessionDescriptionHandler,this.sessionDescriptionHandlerOptions,this.modifiers)).then(function(t){var r=["Contact: "+i.contact];e.reply(200,null,r,t,function(){i.status=a.STATUS_WAITING_FOR_ACK,i.setACKTimer(),i.remote_hold?i.onunhold("remote"):i.remote_hold||i.onhold("remote")})}).catch(function(r){var s;r instanceof t.Exceptions.GetDescriptionError?s=500:r instanceof t.Exceptions.RenegotiationError?(i.emit("renegotiationError",r),i.logger.warn(r),s=488):(i.logger.error(r),s=488),e.reply(s)})},sendReinvite:function(e){if(this.pendingReinvite)return void this.logger.warn("Reinvite in progress. Please wait until complete, then try again.");this.pendingReinvite=!0,e=e||{},e.modifiers=e.modifiers||[];var i=this,r=(e.extraHeaders||[]).slice();r.push("Contact: "+this.contact),r.push("Allow: "+t.UA.C.ALLOWED_METHODS.toString()),this.receiveResponse=this.receiveReinviteResponse,this.isOnHold().local&&e.modifiers.push(i.sessionDescriptionHandler.holdModifier),this.sessionDescriptionHandler.getDescription(e.sessionDescriptionHandlerOptions,e.modifiers).then(function(e){i.dialog.sendRequest(i,t.C.INVITE,{extraHeaders:r,body:e})}).catch(function(e){if(e instanceof t.Exceptions.RenegotiationError)return i.pendingReinvite=!1,i.emit("renegotiationError",e),i.logger.warn("Renegotiation Error"),void i.logger.warn(e);i.logger.error("sessionDescriptionHandler error"),i.logger.error(e)})},receiveRequest:function(e){switch(e.method){case t.C.BYE:e.reply(200),this.status===a.STATUS_CONFIRMED&&(this.emit("bye",e),this.terminated(e,t.C.causes.BYE));break;case t.C.INVITE:this.status===a.STATUS_CONFIRMED&&(this.logger.log("re-INVITE received"),this.receiveReinvite(e));break;case t.C.INFO:if(this.status===a.STATUS_CONFIRMED||this.status===a.STATUS_WAITING_FOR_ACK){if(this.onInfo)return this.onInfo(e);var i,r,s,n=e.getHeader("content-type"),c=/^(Signal\s*?=\s*?)([0-9A-D#*]{1})(\s)?.*/,h=/^(Duration\s?=\s?)([0-9]{1,4})(\s)?.*/;n&&(n.match(/^application\/dtmf-relay/i)?(e.body&&(i=e.body.split("\r\n",2),2===i.length&&(c.test(i[0])&&(r=i[0].replace(c,"$2")),h.test(i[1])&&(s=parseInt(i[1].replace(h,"$2"),10)))),new o(this,r,{duration:s}).init_incoming(e)):e.reply(415,null,["Accept: application/dtmf-relay"]))}break;case t.C.REFER:if(this.status===a.STATUS_CONFIRMED){this.logger.log("REFER received");var u,l=this.listeners("refer").length;l?(e.reply(202,"Accepted"),u="SIP/2.0 100 Trying",this.sendRequest(t.C.NOTIFY,{extraHeaders:["Event: refer","Subscription-State: terminated","Content-Type: message/sipfrag"],body:u,receiveResponse:function(){}}),this.emit("refer",e)):e.reply(603,"Declined")}break;case t.C.NOTIFY:e.reply(200,"OK"),this.emit("notify",e)}},receiveReinviteResponse:function(e){var i=this;if(this.status!==a.STATUS_TERMINATED)switch(!0){case/^1[0-9]{2}$/.test(e.status_code):break;case/^2[0-9]{2}$/.test(e.status_code):if(this.status=a.STATUS_CONFIRMED,this.emit("ack",e.transaction.sendACK()),this.pendingReinvite=!1,t.Timers.clearTimeout(i.timers.invite2xxTimer),!this.sessionDescriptionHandler.hasDescription(e.getHeader("Content-Type"))){this.logger.error("2XX response received to re-invite but did not have a description"),this.emit("renegotiationError",new t.Exceptions.RenegotiationError("2XX response received to re-invite but did not have a description"));break}this.sessionDescriptionHandler.setDescription(e.body,this.sessionDescriptionHandlerOptions,this.modifiers).catch(function(e){i.logger.error("Could not set the description in 2XX response"),i.logger.error(e),i.emit("renegotiationError",e),i.sendRequest(t.C.BYE,{extraHeaders:[t.Utils.getReasonHeaderValue(488,"Not Acceptable Here")]})});break;default:this.disableRenegotiation=!0,this.pendingReinvite=!1,this.logger.log("Received a non 1XX or 2XX response to a re-invite"),this.emit("renegotiationError",new t.Exceptions.RenegotiationError("Invalid response to a re-invite"))}},acceptAndTerminate:function(e,i,r){var s=[];return i&&s.push("Reason: "+t.Utils.getReasonHeaderValue(i,r)),(this.dialog||this.createDialog(e,"UAC"))&&(this.emit("ack",e.transaction.sendACK()),this.sendRequest(t.C.BYE,{extraHeaders:s})),this},setInvite2xxTimer:function(e,i){var r=this,s=t.Timers.T1;this.timers.invite2xxTimer=t.Timers.setTimeout(function n(){if(r.status===a.STATUS_WAITING_FOR_ACK){r.logger.log("no ACK received, attempting to retransmit OK");var o=["Contact: "+r.contact];e.reply(200,null,o,i),s=Math.min(2*s,t.Timers.T2),r.timers.invite2xxTimer=t.Timers.setTimeout(n,s)}},s)},setACKTimer:function(){var e=this;this.timers.ackTimer=t.Timers.setTimeout(function(){e.status===a.STATUS_WAITING_FOR_ACK&&(e.logger.log("no ACK received for an extended period of time, terminating the call"),t.Timers.clearTimeout(e.timers.invite2xxTimer),e.sendRequest(t.C.BYE),e.terminated(null,t.C.causes.NO_ACK))},t.Timers.TIMER_H)},onTransportError:function(){this.status!==a.STATUS_CONFIRMED&&this.status!==a.STATUS_TERMINATED&&this.failed(null,t.C.causes.CONNECTION_ERROR)},onRequestTimeout:function(){this.status===a.STATUS_CONFIRMED?this.terminated(null,t.C.causes.REQUEST_TIMEOUT):this.status!==a.STATUS_TERMINATED&&(this.failed(null,t.C.causes.REQUEST_TIMEOUT),this.terminated(null,t.C.causes.REQUEST_TIMEOUT))},onDialogError:function(e){this.status===a.STATUS_CONFIRMED?this.terminated(e,t.C.causes.DIALOG_ERROR):this.status!==a.STATUS_TERMINATED&&(this.failed(e,t.C.causes.DIALOG_ERROR),this.terminated(e,t.C.causes.DIALOG_ERROR))},onhold:function(t){this["local"===t?"local_hold":"remote_hold"]=!0,this.emit("hold",{originator:t})},onunhold:function(t){this["local"===t?"local_hold":"remote_hold"]=!1,this.emit("unhold",{originator:t})},failed:function(t,e){return this.status===a.STATUS_TERMINATED?this:(this.emit("failed",t||null,e||null),this)},rejected:function(t,e){return this.emit("rejected",t||null,e||null),this},canceled:function(){return this.emit("cancel"),this},accepted:function(e,i){return i=t.Utils.getReasonPhrase(e&&e.status_code,i),this.startTime=new Date,this.replacee&&(this.replacee.emit("replaced",this),this.replacee.terminate()),this.emit("accepted",e,i),this},terminated:function(t,e){return this.status===a.STATUS_TERMINATED?this:(this.endTime=new Date,this.close(),this.emit("terminated",t||null,e||null),this)},connecting:function(t){return this.emit("connecting",{request:t}),this}},r.C=a,t.Session=r,s=function(e,i){function r(t,e){i.hasHeader(t)&&i.getHeader(t).toLowerCase().indexOf("100rel")>=0&&(n.rel100=e)}var s,n=this,o=i.getHeader("Content-Type"),c=i.parseHeader("Content-Disposition");if(t.Utils.augment(this,t.ServerContext,[e,i]),t.Utils.augment(this,t.Session,[e.configuration.sessionDescriptionHandlerFactory]),c&&"render"===c.type&&(this.renderbody=i.body,this.rendertype=o),this.status=a.STATUS_INVITE_RECEIVED,this.from_tag=i.from_tag,this.id=i.call_id+this.from_tag,this.request=i,this.contact=this.ua.contact.toString(),this.receiveNonInviteResponse=function(){},this.logger=e.getLogger("sip.inviteservercontext",this.id),this.ua.sessions[this.id]=this,i.hasHeader("expires")&&(s=1e3*i.getHeader("expires")),r("require",t.C.supported.REQUIRED),r("supported",t.C.supported.SUPPORTED),i.to_tag=t.Utils.newTag(),!this.createDialog(i,"UAS",!0))return void i.reply(500,"Missing Contact header field");var h={extraHeaders:["Contact: "+n.contact]};n.rel100!==t.C.supported.REQUIRED&&n.progress(h),n.status=a.STATUS_WAITING_FOR_ANSWER,n.timers.userNoAnswerTimer=t.Timers.setTimeout(function(){i.reply(408),n.failed(i,t.C.causes.NO_ANSWER),n.terminated(i,t.C.causes.NO_ANSWER)},n.ua.configuration.noAnswerTimeout),s&&(n.timers.expiresTimer=t.Timers.setTimeout(function(){n.status===a.STATUS_WAITING_FOR_ANSWER&&(i.reply(487),n.failed(i,t.C.causes.EXPIRES),n.terminated(i,t.C.causes.EXPIRES))},s))},s.prototype={reject:function(e){if(this.status===a.STATUS_TERMINATED)throw new t.Exceptions.InvalidStateError(this.status);return this.logger.log("rejecting RTCSession"),t.ServerContext.prototype.reject.call(this,e),this.terminated()},terminate:function(e){e=e||{};var i,r=(e.extraHeaders||[]).slice(),s=e.body,n=this;return this.status===a.STATUS_WAITING_FOR_ACK&&this.request.server_transaction.state!==t.Transactions.C.STATUS_TERMINATED?(i=this.dialog,this.receiveRequest=function(e){e.method===t.C.ACK&&(this.sendRequest(t.C.BYE,{extraHeaders:r,body:s}),i.terminate())},this.request.server_transaction.on("stateChanged",function(){this.state===t.Transactions.C.STATUS_TERMINATED&&this.dialog&&(this.request=new t.OutgoingRequest(t.C.BYE,this.dialog.remote_target,this.ua,{cseq:this.dialog.local_seqnum+=1,call_id:this.dialog.id.call_id,from_uri:this.dialog.local_uri,from_tag:this.dialog.id.local_tag,to_uri:this.dialog.remote_uri,to_tag:this.dialog.id.remote_tag,route_set:this.dialog.route_set},r,s),new t.RequestSender({request:this.request,onRequestTimeout:function(){n.onRequestTimeout()},onTransportError:function(){n.onTransportError()},receiveResponse:function(){}},this.ua).send(),i.terminate())}),this.emit("bye",this.request),this.terminated(),this.dialog=i,this.ua.dialogs[i.id.toString()]=i):this.status===a.STATUS_CONFIRMED?this.bye(e):this.reject(e),this},progress:function(e){function i(){n=e.statusCode||183,this.status=a.STATUS_WAITING_FOR_PRACK,c.push("Contact: "+this.contact),c.push("Require: 100rel"),c.push("RSeq: "+Math.floor(1e4*Math.random())),this.sessionDescriptionHandler.getDescription(e.sessionDescriptionHandlerOptions,e.modifiers).then(function(e){if(!this.isCanceled&&this.status!==a.STATUS_TERMINATED){this.early_sdp=e.body,this[this.hasOffer?"hasAnswer":"hasOffer"]=!0;var i=t.Timers.T1;this.timers.rel1xxTimer=t.Timers.setTimeout(function r(){this.request.reply(n,null,c,e),i*=2,this.timers.rel1xxTimer=t.Timers.setTimeout(r.bind(this),i)}.bind(this),i),this.timers.prackTimer=t.Timers.setTimeout(function(){this.status===a.STATUS_WAITING_FOR_PRACK&&(this.logger.log("no PRACK received, rejecting the call"),t.Timers.clearTimeout(this.timers.rel1xxTimer),this.request.reply(504),this.terminated(null,t.C.causes.NO_PRACK))}.bind(this),64*t.Timers.T1),s=this.request.reply(n,o,c,e),this.emit("progress",s,o)}}.bind(this),function(){this.request.reply(480),this.failed(null,t.C.causes.WEBRTC_ERROR),this.terminated(null,t.C.causes.WEBRTC_ERROR)}.bind(this))}function r(){s=this.request.reply(n,o,c,h),this.emit("progress",s,o)}e=e||{};var s,n=e.statusCode||180,o=e.reasonPhrase,c=(e.extraHeaders||[]).slice(),h=e.body;if(n<100||n>199)throw new TypeError("Invalid statusCode: "+n);return this.isCanceled||this.status===a.STATUS_TERMINATED?this:(100!==e.statusCode&&(this.rel100===t.C.supported.REQUIRED||this.rel100===t.C.supported.SUPPORTED&&e.rel100||this.rel100===t.C.supported.SUPPORTED&&this.ua.configuration.rel100===t.C.supported.REQUIRED)?(this.sessionDescriptionHandler=this.setupSessionDescriptionHandler(),this.sessionDescriptionHandler.hasDescription(this.request.getHeader("Content-Type"))?(this.hasOffer=!0,this.sessionDescriptionHandler.setDescription(this.request.body,e.sessionDescriptionHandlerOptions,e.modifiers).then(i.apply(this)).catch(function(e){this.logger.warn("invalid description"),this.logger.warn(e),this.failed(null,t.C.causes.WEBRTC_ERROR),this.terminated(null,t.C.causes.WEBRTC_ERROR)}.bind(this))):i.apply(this)):r.apply(this),this)},accept:function(e){e=e||{},this.onInfo=e.onInfo;var i=this,r=this.request,s=(e.extraHeaders||[]).slice(),n=function(e){var n,o=function(){i.status=a.STATUS_WAITING_FOR_ACK,i.setInvite2xxTimer(r,e),i.setACKTimer()},c=function(){i.failed(null,t.C.causes.CONNECTION_ERROR),i.terminated(null,t.C.causes.CONNECTION_ERROR)};s.push("Contact: "+i.contact),s.push("Allow: "+t.UA.C.ALLOWED_METHODS.toString()),i.hasOffer?i.hasAnswer=!0:i.hasOffer=!0,n=r.reply(200,null,s,e,o,c),i.status!==a.STATUS_TERMINATED&&i.accepted(n,t.Utils.getReasonPhrase(200))},o=function(){i.status!==a.STATUS_TERMINATED&&(i.request.reply(480),i.failed(null,t.C.causes.WEBRTC_ERROR),i.terminated(null,t.C.causes.WEBRTC_ERROR))};if(this.status===a.STATUS_WAITING_FOR_PRACK)return this.status=a.STATUS_ANSWERED_WAITING_FOR_PRACK,this;if(this.status===a.STATUS_WAITING_FOR_ANSWER)this.status=a.STATUS_ANSWERED;else if(this.status!==a.STATUS_EARLY_MEDIA)throw new t.Exceptions.InvalidStateError(this.status);if(!this.createDialog(r,"UAS"))return r.reply(500,"Missing Contact header field"),this;if(t.Timers.clearTimeout(this.timers.userNoAnswerTimer),this.status===a.STATUS_EARLY_MEDIA)n({});else if(this.sessionDescriptionHandler=this.setupSessionDescriptionHandler(),"0"!==this.request.getHeader("Content-Length")||this.request.getHeader("Content-Type")){if(!this.sessionDescriptionHandler.hasDescription(this.request.getHeader("Content-Type")))return void this.request.reply(415);this.hasOffer=!0,this.sessionDescriptionHandler.setDescription(this.request.body,e.sessionDescriptionHandlerOptions,e.modifiers).then(function(){return this.sessionDescriptionHandler.getDescription(e.sessionDescriptionHandlerOptions,e.modifiers)}.bind(this)).then(n).catch(o)}else this.sessionDescriptionHandler.getDescription(e.sessionDescriptionHandlerOptions,e.modifiers).then(n).catch(o);return this},receiveRequest:function(e){function i(){var i,r;t.Timers.clearTimeout(this.timers.ackTimer),t.Timers.clearTimeout(this.timers.invite2xxTimer),this.status=a.STATUS_CONFIRMED,i=e.getHeader("Content-Type"),r=e.getHeader("Content-Disposition"),r&&"render"===r.type&&(this.renderbody=e.body,this.rendertype=i),this.emit("confirmed",e)}switch(e.method){case t.C.CANCEL:this.status!==a.STATUS_WAITING_FOR_ANSWER&&this.status!==a.STATUS_WAITING_FOR_PRACK&&this.status!==a.STATUS_ANSWERED_WAITING_FOR_PRACK&&this.status!==a.STATUS_EARLY_MEDIA&&this.status!==a.STATUS_ANSWERED||(this.status=a.STATUS_CANCELED,this.request.reply(487),this.canceled(e),this.rejected(e,t.C.causes.CANCELED),this.failed(e,t.C.causes.CANCELED),this.terminated(e,t.C.causes.CANCELED));break;case t.C.ACK:this.status===a.STATUS_WAITING_FOR_ACK&&(this.hasAnswer?i.apply(this):(this.sessionDescriptionHandler=this.setupSessionDescriptionHandler(),this.sessionDescriptionHandler.hasDescription(e.getHeader("Content-Type"))?(this.hasAnswer=!0,this.sessionDescriptionHandler.setDescription(e.body,this.sessionDescriptionHandlerOptions,this.modifiers).then(i.bind(this),function(i){this.logger.warn(i),this.terminate({statusCode:"488",reasonPhrase:"Bad Media Description"}),this.failed(e,t.C.causes.BAD_MEDIA_DESCRIPTION),this.terminated(e,t.C.causes.BAD_MEDIA_DESCRIPTION)}.bind(this))):this.early_sdp?i.apply(this):(this.failed(e,t.C.causes.BAD_MEDIA_DESCRIPTION),this.terminated(e,t.C.causes.BAD_MEDIA_DESCRIPTION))));break;case t.C.PRACK:this.status===a.STATUS_WAITING_FOR_PRACK||this.status===a.STATUS_ANSWERED_WAITING_FOR_PRACK?this.hasAnswer?(t.Timers.clearTimeout(this.timers.rel1xxTimer),t.Timers.clearTimeout(this.timers.prackTimer),e.reply(200),this.status===a.STATUS_ANSWERED_WAITING_FOR_PRACK&&(this.status=a.STATUS_EARLY_MEDIA,this.accept()),this.status=a.STATUS_EARLY_MEDIA):(this.sessionDescriptionHandler=this.setupSessionDescriptionHandler(),this.sessionDescriptionHandler.hasDescription(e.getHeader("Content-Type"))?(this.hasAnswer=!0,this.sessionDescriptionHandler.setDescription(e.body,this.sessionDescriptionHandlerOptions,this.modifiers).then(function(){t.Timers.clearTimeout(this.timers.rel1xxTimer),t.Timers.clearTimeout(this.timers.prackTimer),e.reply(200),this.status===a.STATUS_ANSWERED_WAITING_FOR_PRACK&&(this.status=a.STATUS_EARLY_MEDIA,this.accept()),this.status=a.STATUS_EARLY_MEDIA}.bind(this),function(i){this.logger.warn(i),this.terminate({statusCode:"488",reasonPhrase:"Bad Media Description"}),this.failed(e,t.C.causes.BAD_MEDIA_DESCRIPTION),this.terminated(e,t.C.causes.BAD_MEDIA_DESCRIPTION)}.bind(this))):(this.terminate({statusCode:"488",reasonPhrase:"Bad Media Description"}),this.failed(e,t.C.causes.BAD_MEDIA_DESCRIPTION),this.terminated(e,t.C.causes.BAD_MEDIA_DESCRIPTION))):this.status===a.STATUS_EARLY_MEDIA&&e.reply(200);break;default:r.prototype.receiveRequest.apply(this,[e])}},setupSessionDescriptionHandler:function(){return this.sessionDescriptionHandler?this.sessionDescriptionHandler:this.sessionDescriptionHandlerFactory(this,this.ua.configuration.sessionDescriptionHandlerFactoryOptions)},onTransportError:function(){this.status!==a.STATUS_CONFIRMED&&this.status!==a.STATUS_TERMINATED&&this.failed(null,t.C.causes.CONNECTION_ERROR)},onRequestTimeout:function(){this.status===a.STATUS_CONFIRMED?this.terminated(null,t.C.causes.REQUEST_TIMEOUT):this.status!==a.STATUS_TERMINATED&&(this.failed(null,t.C.causes.REQUEST_TIMEOUT),this.terminated(null,t.C.causes.REQUEST_TIMEOUT))}},t.InviteServerContext=s,n=function(e,i,r,s){r=r||{},this.passedOptions=r,r.params=Object.create(r.params||Object.prototype);var n=(r.extraHeaders||[]).slice(),o=e.configuration.sessionDescriptionHandlerFactory;if(this.sessionDescriptionHandlerFactoryOptions=e.configuration.sessionDescriptionHandlerFactoryOptions||{},this.sessionDescriptionHandlerOptions=r.sessionDescriptionHandlerOptions||{},this.modifiers=s,this.inviteWithoutSdp=r.inviteWithoutSdp||!1,this.anonymous=r.anonymous||!1,this.renderbody=r.renderbody||null,this.rendertype=r.rendertype||"text/plain",this.from_tag=t.Utils.newTag(),r.params.from_tag=this.from_tag,this.contact=e.contact.toString({anonymous:this.anonymous,outbound:this.anonymous?!e.contact.temp_gruu:!e.contact.pub_gruu}),this.anonymous&&(r.params.from_displayName="Anonymous",r.params.from_uri="sip:anonymous@anonymous.invalid",n.push("P-Preferred-Identity: "+e.configuration.uri.toString()),n.push("Privacy: id")),n.push("Contact: "+this.contact),n.push("Allow: "+t.UA.C.ALLOWED_METHODS.toString()),this.inviteWithoutSdp&&this.renderbody&&(n.push("Content-Type: "+this.rendertype),n.push("Content-Disposition: render;handling=optional")),e.configuration.rel100===t.C.supported.REQUIRED&&n.push("Require: 100rel"),e.configuration.replaces===t.C.supported.REQUIRED&&n.push("Require: replaces"),r.extraHeaders=n,t.Utils.augment(this,t.ClientContext,[e,t.C.INVITE,i,r]),t.Utils.augment(this,t.Session,[o]),this.status!==a.STATUS_NULL)throw new t.Exceptions.InvalidStateError(this.status);this.isCanceled=!1,this.received_100=!1,this.method=t.C.INVITE,this.receiveNonInviteResponse=this.receiveResponse,this.receiveResponse=this.receiveInviteResponse,this.logger=e.getLogger("sip.inviteclientcontext"),e.applicants[this]=this,this.id=this.request.call_id+this.from_tag,this.onInfo=r.onInfo},n.prototype={invite:function(){var e=this;return this.ua.sessions[this.id]=this,this.inviteWithoutSdp?(this.request.body=e.renderbody,this.status=a.STATUS_INVITE_SENT,this.send()):(this.sessionDescriptionHandler=this.sessionDescriptionHandlerFactory(this,this.sessionDescriptionHandlerFactoryOptions),this.sessionDescriptionHandler.getDescription(this.sessionDescriptionHandlerOptions,this.modifiers).then(function(t){e.isCanceled||e.status===a.STATUS_TERMINATED||(e.hasOffer=!0,e.request.body=t,e.status=a.STATUS_INVITE_SENT,e.send())},function(){e.status!==a.STATUS_TERMINATED&&(e.failed(null,t.C.causes.WEBRTC_ERROR),e.terminated(null,t.C.causes.WEBRTC_ERROR))})),this},receiveInviteResponse:function(e){var i,r=this,s=e.call_id+e.from_tag+e.to_tag,n=[],o={};if(this.status!==a.STATUS_TERMINATED&&e.method===t.C.INVITE){if(this.dialog&&e.status_code>=200&&e.status_code<=299){if(s!==this.dialog.id.toString()){if(!this.createDialog(e,"UAC",!0))return;return this.emit("ack",e.transaction.sendACK({body:t.Utils.generateFakeSDP(e.body)})),this.earlyDialogs[s].sendRequest(this,t.C.BYE),void(this.status!==a.STATUS_CONFIRMED&&(this.failed(e,t.C.causes.WEBRTC_ERROR),this.terminated(e,t.C.causes.WEBRTC_ERROR)))}if(this.status===a.STATUS_CONFIRMED)return void this.emit("ack",e.transaction.sendACK());if(!this.hasAnswer)return}if(this.dialog&&e.status_code<200){if(-1!==this.dialog.pracked.indexOf(e.getHeader("rseq"))||this.dialog.pracked[this.dialog.pracked.length-1]>=e.getHeader("rseq")&&this.dialog.pracked.length>0)return;if(!this.earlyDialogs[s]&&!this.createDialog(e,"UAC",!0))return;if(-1!==this.earlyDialogs[s].pracked.indexOf(e.getHeader("rseq"))||this.earlyDialogs[s].pracked[this.earlyDialogs[s].pracked.length-1]>=e.getHeader("rseq")&&this.earlyDialogs[s].pracked.length>0)return;return n.push("RAck: "+e.getHeader("rseq")+" "+e.getHeader("cseq")),this.earlyDialogs[s].pracked.push(e.getHeader("rseq")),void this.earlyDialogs[s].sendRequest(this,t.C.PRACK,{extraHeaders:n,body:t.Utils.generateFakeSDP(e.body)})}if(this.isCanceled)return void(e.status_code>=100&&e.status_code<200?(this.request.cancel(this.cancelReason,n),this.canceled(null)):e.status_code>=200&&e.status_code<299?(this.acceptAndTerminate(e),this.emit("bye",this.request)):e.status_code>=300&&(i=t.C.REASON_PHRASE[e.status_code]||t.C.causes.CANCELED,this.rejected(e,i),this.failed(e,i),this.terminated(e,i)));switch(!0){case/^100$/.test(e.status_code):this.received_100=!0,this.emit("progress",e);break;case/^1[0-9]{2}$/.test(e.status_code):if(!e.to_tag){this.logger.warn("1xx response received without to tag");break}if(e.hasHeader("contact")&&!this.createDialog(e,"UAC",!0))break;if(this.status=a.STATUS_1XX_RECEIVED,e.hasHeader("require")&&-1!==e.getHeader("require").indexOf("100rel")){if(this.dialog||!this.earlyDialogs[s])break;if(-1!==this.earlyDialogs[s].pracked.indexOf(e.getHeader("rseq"))||this.earlyDialogs[s].pracked[this.earlyDialogs[s].pracked.length-1]>=e.getHeader("rseq")&&this.earlyDialogs[s].pracked.length>0)return;if(this.sessionDescriptionHandler=this.sessionDescriptionHandlerFactory(this,this.sessionDescriptionHandlerFactoryOptions),this.sessionDescriptionHandler.hasDescription(e.getHeader("Content-Type")))if(this.hasOffer){if(!this.createDialog(e,"UAC"))break;this.hasAnswer=!0,this.dialog.pracked.push(e.getHeader("rseq")),this.sessionDescriptionHandler.setDescription(e.body,this.sessionDescriptionHandlerOptions,this.modifiers).then(function(){n.push("RAck: "+e.getHeader("rseq")+" "+e.getHeader("cseq")),r.sendRequest(t.C.PRACK,{extraHeaders:n,receiveResponse:function(){}}),r.status=a.STATUS_EARLY_MEDIA,r.emit("progress",e)},function(i){r.logger.warn(i),r.acceptAndTerminate(e,488,"Not Acceptable Here"),r.failed(e,t.C.causes.BAD_MEDIA_DESCRIPTION)})}else{var c=this.earlyDialogs[s],h=c.sessionDescriptionHandler=this.sessionDescriptionHandlerFactory(this,this.sessionDescriptionHandlerOptions);c.pracked.push(e.getHeader("rseq")),h.setDescription(e.body,r.sessionDescriptionHandlerOptions,r.modifers).then(h.getDescription.bind(h,r.sessionDescriptionHandlerOptions,r.modifiers)).then(function(i){n.push("RAck: "+e.getHeader("rseq")+" "+e.getHeader("cseq")),c.sendRequest(r,t.C.PRACK,{extraHeaders:n,body:i}),r.status=a.STATUS_EARLY_MEDIA,r.emit("progress",e)}).catch(function(i){if(i instanceof t.Exceptions.GetDescriptionError){if(c.pracked.push(e.getHeader("rseq")),r.status===a.STATUS_TERMINATED)return;r.failed(null,t.C.causes.WEBRTC_ERROR),r.terminated(null,t.C.causes.WEBRTC_ERROR)}else c.pracked.splice(c.pracked.indexOf(e.getHeader("rseq")),1),r.logger.warn("invalid description"),r.logger.warn(i)})}else n.push("RAck: "+e.getHeader("rseq")+" "+e.getHeader("cseq")),this.earlyDialogs[s].pracked.push(e.getHeader("rseq")),this.earlyDialogs[s].sendRequest(this,t.C.PRACK,{extraHeaders:n}),this.emit("progress",e)}else this.emit("progress",e);break;case/^2[0-9]{2}$/.test(e.status_code):if(this.request.cseq+" "+this.request.method!==e.getHeader("cseq"))break;if(this.status===a.STATUS_EARLY_MEDIA&&this.dialog){this.status=a.STATUS_CONFIRMED,o={},this.renderbody&&(n.push("Content-Type: "+this.rendertype),o.extraHeaders=n,o.body=this.renderbody),this.emit("ack",e.transaction.sendACK(o)),this.accepted(e);break}if(this.dialog)break;if(this.hasOffer)if(this.hasAnswer)this.renderbody&&(n.push("Content-Type: "+r.rendertype),o.extraHeaders=n,o.body=this.renderbody),this.emit("ack",e.transaction.sendACK(o));else{if(!this.sessionDescriptionHandler.hasDescription(e.getHeader("Content-Type"))){this.acceptAndTerminate(e,400,"Missing session description"),this.failed(e,t.C.causes.BAD_MEDIA_DESCRIPTION);break}if(!this.createDialog(e,"UAC"))break;this.hasAnswer=!0,this.sessionDescriptionHandler.setDescription(e.body,this.sessionDescriptionHandlerOptions,this.modifiers).then(function(){var t={};r.status=a.STATUS_CONFIRMED,r.renderbody&&(n.push("Content-Type: "+r.rendertype),t.extraHeaders=n,t.body=r.renderbody),r.emit("ack",e.transaction.sendACK(t)),r.accepted(e)},function(i){r.logger.warn(i),r.acceptAndTerminate(e,488,"Not Acceptable Here"),r.failed(e,t.C.causes.BAD_MEDIA_DESCRIPTION)})}else if(this.earlyDialogs[s]&&this.earlyDialogs[s].sessionDescriptionHandler){if(this.hasOffer=!0,this.hasAnswer=!0,this.sessionDescriptionHandler=this.earlyDialogs[s].sessionDescriptionHandler,!this.createDialog(e,"UAC"))break;this.status=a.STATUS_CONFIRMED,this.emit("ack",e.transaction.sendACK()),this.accepted(e)}else{if(this.sessionDescriptionHandler=this.sessionDescriptionHandlerFactory(this,this.sessionDescriptionHandlerFactoryOptions),!this.sessionDescriptionHandler.hasDescription(e.getHeader("Content-Type"))){this.acceptAndTerminate(e,400,"Missing session description"),this.failed(e,t.C.causes.BAD_MEDIA_DESCRIPTION);break}if(!this.createDialog(e,"UAC"))break;this.hasOffer=!0,this.sessionDescriptionHandler.setDescription(e.body,this.sessionDescriptionHandlerOptions,this.modifiers).then(this.sessionDescriptionHandler.getDescription.bind(this.sessionDescriptionHandler,this.sessionDescriptionHandlerOptions,this.modifiers)).then(function(t){r.isCanceled||r.status===a.STATUS_TERMINATED||(r.status=a.STATUS_CONFIRMED,r.hasAnswer=!0,r.emit("ack",e.transaction.sendACK({body:t})),r.accepted(e))}).catch(function(i){i instanceof t.Exceptions.GetDescriptionError?r.logger.warn("there was a problem"):(r.logger.warn("invalid description"),r.logger.warn(i),r.acceptAndTerminate(e,488,"Invalid session description"),r.failed(e,t.C.causes.BAD_MEDIA_DESCRIPTION))})}break;default:i=t.Utils.sipErrorCause(e.status_code),this.rejected(e,i),this.failed(e,i),this.terminated(e,i)}}},cancel:function(e){if(e=e||{},e.extraHeaders=(e.extraHeaders||[]).slice(),this.status===a.STATUS_TERMINATED||this.status===a.STATUS_CONFIRMED)throw new t.Exceptions.InvalidStateError(this.status);this.logger.log("canceling RTCSession");var i=t.Utils.getCancelReason(e.status_code,e.reason_phrase);return this.status===a.STATUS_NULL||this.status===a.STATUS_INVITE_SENT&&!this.received_100?(this.isCanceled=!0,this.cancelReason=i):this.status!==a.STATUS_INVITE_SENT&&this.status!==a.STATUS_1XX_RECEIVED&&this.status!==a.STATUS_EARLY_MEDIA||this.request.cancel(i,e.extraHeaders),this.canceled()},terminate:function(t){return this.status===a.STATUS_TERMINATED?this:(this.status===a.STATUS_WAITING_FOR_ACK||this.status===a.STATUS_CONFIRMED?this.bye(t):this.cancel(t),this)},receiveRequest:function(e){return e.method,t.C.CANCEL,e.method===t.C.ACK&&this.status===a.STATUS_WAITING_FOR_ACK&&(t.Timers.clearTimeout(this.timers.ackTimer),t.Timers.clearTimeout(this.timers.invite2xxTimer),this.status=a.STATUS_CONFIRMED,this.accepted()),r.prototype.receiveRequest.apply(this,[e])},onTransportError:function(){this.status!==a.STATUS_CONFIRMED&&this.status!==a.STATUS_TERMINATED&&this.failed(null,t.C.causes.CONNECTION_ERROR)},onRequestTimeout:function(){this.status===a.STATUS_CONFIRMED?this.terminated(null,t.C.causes.REQUEST_TIMEOUT):this.status!==a.STATUS_TERMINATED&&(this.failed(null,t.C.causes.REQUEST_TIMEOUT),this.terminated(null,t.C.causes.REQUEST_TIMEOUT))}},t.InviteClientContext=n}},function(t,e,i){"use strict";t.exports=function(t){var e,i={MIN_DURATION:70,MAX_DURATION:6e3,DEFAULT_DURATION:100,MIN_INTER_TONE_GAP:50,DEFAULT_INTER_TONE_GAP:500};return e=function(i,r,s){var n,o;if(void 0===r)throw new TypeError("Not enough arguments");if(this.logger=i.ua.getLogger("sip.invitecontext.dtmf",i.id),this.owner=i,this.direction=null,s=s||{},n=s.duration||null,o=s.interToneGap||null,"string"==typeof r)r=r.toUpperCase();else{if("number"!=typeof r)throw new TypeError("Invalid tone: "+r);r=r.toString()}if(!r.match(/^[0-9A-D#*]$/))throw new TypeError("Invalid tone: "+r);if(this.tone=r,n&&!t.Utils.isDecimal(n))throw new TypeError("Invalid tone duration: "+n);if(n?n<e.C.MIN_DURATION?(this.logger.warn('"duration" value is lower than the minimum allowed, setting it to '+e.C.MIN_DURATION+" milliseconds"),n=e.C.MIN_DURATION):n>e.C.MAX_DURATION?(this.logger.warn('"duration" value is greater than the maximum allowed, setting it to '+e.C.MAX_DURATION+" milliseconds"),n=e.C.MAX_DURATION):n=Math.abs(n):n=e.C.DEFAULT_DURATION,this.duration=n,o&&!t.Utils.isDecimal(o))throw new TypeError("Invalid interToneGap: "+o);o?o<e.C.MIN_INTER_TONE_GAP?(this.logger.warn('"interToneGap" value is lower than the minimum allowed, setting it to '+e.C.MIN_INTER_TONE_GAP+" milliseconds"),o=e.C.MIN_INTER_TONE_GAP):o=Math.abs(o):o=e.C.DEFAULT_INTER_TONE_GAP,this.interToneGap=o},e.prototype=Object.create(t.EventEmitter.prototype),e.prototype.send=function(e){var i,r={};if(this.direction="outgoing",this.owner.status!==t.Session.C.STATUS_CONFIRMED&&this.owner.status!==t.Session.C.STATUS_WAITING_FOR_ACK)throw new t.Exceptions.InvalidStateError(this.owner.status);e=e||{},i=e.extraHeaders?e.extraHeaders.slice():[],r.contentType="application/dtmf-relay",r.body="Signal= "+this.tone+"\r\n",r.body+="Duration= "+this.duration,this.request=this.owner.dialog.sendRequest(this,t.C.INFO,{extraHeaders:i,body:r}),this.owner.emit("dtmf",this.request,this)},e.prototype.receiveResponse=function(e){var i;switch(!0){case/^1[0-9]{2}$/.test(e.status_code):break;case/^2[0-9]{2}$/.test(e.status_code):this.emit("succeeded",{originator:"remote",response:e});break;default:i=t.Utils.sipErrorCause(e.status_code),this.emit("failed",e,i)}},e.prototype.onRequestTimeout=function(){this.emit("failed",null,t.C.causes.REQUEST_TIMEOUT),this.owner.onRequestTimeout()},e.prototype.onTransportError=function(){this.emit("failed",null,t.C.causes.CONNECTION_ERROR),this.owner.onTransportError()},e.prototype.onDialogError=function(e){this.emit("failed",e,t.C.causes.DIALOG_ERROR),this.owner.onDialogError(e)},e.prototype.init_incoming=function(t){this.direction="incoming",this.request=t,t.reply(200),this.tone&&this.duration?this.owner.emit("dtmf",t,this):this.logger.warn("invalid INFO DTMF received, discarded")},e.C=i,e}},function(t,e,i){"use strict";t.exports=function(t){t.Subscription=function(e,i,r,s){if(s=Object.create(s||Object.prototype),this.extraHeaders=s.extraHeaders=(s.extraHeaders||[]).slice(),this.id=null,this.state="init",!r)throw new TypeError("Event necessary to create a subscription.");this.event=r,"number"!=typeof s.expires?(e.logger.warn("expires must be a number. Using default of 3600."),this.expires=3600):this.expires=s.expires,this.requestedExpires=this.expires,s.extraHeaders.push("Event: "+this.event),s.extraHeaders.push("Expires: "+this.expires),s.body&&(this.body=s.body),this.contact=e.contact.toString(),s.extraHeaders.push("Contact: "+this.contact),s.extraHeaders.push("Allow: "+t.UA.C.ALLOWED_METHODS.toString()),t.Utils.augment(this,t.ClientContext,[e,t.C.SUBSCRIBE,i,s]),this.logger=e.getLogger("sip.subscription"),this.dialog=null,this.timers={N:null,sub_duration:null},this.errorCodes=[404,405,410,416,480,481,482,483,484,485,489,501,604]},t.Subscription.prototype={subscribe:function(){var e=this;return"active"===this.state?(this.refresh(),this):"notify_wait"===this.state?this:(t.Timers.clearTimeout(this.timers.sub_duration),t.Timers.clearTimeout(this.timers.N),this.timers.N=t.Timers.setTimeout(e.timer_fire.bind(e),t.Timers.TIMER_N),this.ua.earlySubscriptions[this.request.call_id+this.request.from.parameters.tag+this.event]=this,this.send(),this.state="notify_wait",this)},refresh:function(){"terminated"!==this.state&&"pending"!==this.state&&"notify_wait"!==this.state&&this.dialog.sendRequest(this,t.C.SUBSCRIBE,{extraHeaders:this.extraHeaders,body:this.body})},receiveResponse:function(e){var i,r=this,s=t.Utils.getReasonPhrase(e.status_code);"notify_wait"===this.state&&e.status_code>=300||"notify_wait"!==this.state&&-1!==this.errorCodes.indexOf(e.status_code)?this.failed(e,null):/^2[0-9]{2}$/.test(e.status_code)?(this.emit("accepted",e,s),i=e.getHeader("Expires"),i&&i<=this.requestedExpires?(this.expires=i,this.timers.sub_duration=t.Timers.setTimeout(r.refresh.bind(r),900*i)):i?(this.logger.warn("Expires header in a 200-class response to SUBSCRIBE with a higher value than the one in the request"),this.failed(e,t.C.INVALID_EXPIRES_HEADER)):(this.logger.warn("Expires header missing in a 200-class response to SUBSCRIBE"),this.failed(e,t.C.EXPIRES_HEADER_MISSING))):e.statusCode>300&&(this.emit("failed",e,s),this.emit("rejected",e,s))},unsubscribe:function(){var e=[],i=this;this.state="terminated",e.push("Event: "+this.event),e.push("Expires: 0"),e.push("Contact: "+this.contact),e.push("Allow: "+t.UA.C.ALLOWED_METHODS.toString()),this.receiveResponse=function(){},this.dialog.sendRequest(this,this.method,{extraHeaders:e,body:this.body}),t.Timers.clearTimeout(this.timers.sub_duration),t.Timers.clearTimeout(this.timers.N),this.timers.N=t.Timers.setTimeout(i.timer_fire.bind(i),t.Timers.TIMER_N)},timer_fire:function(){"terminated"===this.state?(this.terminateDialog(),t.Timers.clearTimeout(this.timers.N),t.Timers.clearTimeout(this.timers.sub_duration),delete this.ua.subscriptions[this.id]):"notify_wait"===this.state||"pending"===this.state?this.close():this.refresh()},close:function(){"notify_wait"===this.state?(this.state="terminated",t.Timers.clearTimeout(this.timers.N),t.Timers.clearTimeout(this.timers.sub_duration),this.receiveResponse=function(){},delete this.ua.earlySubscriptions[this.request.call_id+this.request.from.parameters.tag+this.event]):"terminated"!==this.state&&this.unsubscribe()},createConfirmedDialog:function(e,i){var r;return this.terminateDialog(),r=new t.Dialog(this,e,i),r.invite_seqnum=this.request.cseq,r.local_seqnum=this.request.cseq,!r.error&&(this.dialog=r,!0)},terminateDialog:function(){this.dialog&&(delete this.ua.subscriptions[this.id],this.dialog.terminate(),delete this.dialog)},receiveRequest:function(e){function i(){r.expires&&(t.Timers.clearTimeout(s.timers.sub_duration),r.expires=Math.min(s.expires,Math.max(r.expires,0)),s.timers.sub_duration=t.Timers.setTimeout(s.refresh.bind(s),900*r.expires))}var r,s=this;if(!this.matchEvent(e))return void e.reply(489);if(this.dialog||this.createConfirmedDialog(e,"UAS")&&(this.id=this.dialog.id.toString(),delete this.ua.earlySubscriptions[this.request.call_id+this.request.from.parameters.tag+this.event],this.ua.subscriptions[this.id]=this),r=e.parseHeader("Subscription-State"),e.reply(200,t.C.REASON_200),t.Timers.clearTimeout(this.timers.N),this.emit("notify",{request:e}),"terminated"===this.state)return void("terminated"===r.state&&(this.terminateDialog(),t.Timers.clearTimeout(this.timers.N),t.Timers.clearTimeout(this.timers.sub_duration),delete this.ua.subscriptions[this.id]));switch(r.state){case"active":this.state="active",i();break;case"pending":"notify_wait"===this.state&&i(),this.state="pending";break;case"terminated":if(t.Timers.clearTimeout(this.timers.sub_duration),r.reason)switch(this.logger.log("terminating subscription with reason "+r.reason),r.reason){case"deactivated":case"timeout":return void this.subscribe();case"probation":case"giveup":return void(r.params&&r.params["retry-after"]?this.timers.sub_duration=t.Timers.setTimeout(s.subscribe.bind(s),r.params["retry-after"]):this.subscribe())}this.close()}},failed:function(t,e){return this.close(),this.emit("failed",t,e),this.emit("rejected",t,e),this},onDialogError:function(e){this.failed(e,t.C.causes.DIALOG_ERROR)},matchEvent:function(t){var e;return t.hasHeader("Event")?t.hasHeader("Subscription-State")?(e=t.parseHeader("event").event,this.event===e||(this.logger.warn("event match failed"),t.reply(481,"Event Match Failed"),!1)):(this.logger.warn("missing Subscription-State header"),!1):(this.logger.warn("missing Event header"),!1)}}}},function(t,e,i){"use strict";(function(e){t.exports=function(t,r){function s(e){if(e instanceof Function)return e.initialize||(e.initialize=function(){return t.Utils.Promise.resolve()}),e}var n,o={STATUS_INIT:0,STATUS_STARTING:1,STATUS_READY:2,STATUS_USER_CLOSED:3,STATUS_NOT_READY:4,CONFIGURATION_ERROR:1,NETWORK_ERROR:2,ALLOWED_METHODS:["ACK","CANCEL","INVITE","MESSAGE","BYE","OPTIONS","INFO","NOTIFY","REFER"],ACCEPTED_BODY_TYPES:["application/sdp","application/dtmf-relay"],MAX_FORWARDS:70,TAG_LENGTH:10};n=function(e){function i(t){return r.emit.bind(r,t)}var r=this;o.ACCEPTED_BODY_TYPES=o.ACCEPTED_BODY_TYPES.toString(),this.log=new t.LoggerFactory,this.logger=this.getLogger("sip.ua"),this.cache={credentials:{}},this.configuration={},this.dialogs={},this.applicants={},this.data={},this.sessions={},this.subscriptions={},this.earlySubscriptions={},this.transport=null,this.contact=null,this.status=o.STATUS_INIT,this.error=null,this.transactions={nist:{},nict:{},ist:{},ict:{}},this.transportRecoverAttempts=0,this.transportRecoveryTimer=null,Object.defineProperties(this,{transactionsCount:{get:function(){var t,e=["nist","nict","ist","ict"],i=0;for(t in e)i+=Object.keys(this.transactions[e[t]]).length;return i}},nictTransactionsCount:{get:function(){return Object.keys(this.transactions.nict).length}},nistTransactionsCount:{get:function(){return Object.keys(this.transactions.nist).length}},ictTransactionsCount:{get:function(){return Object.keys(this.transactions.ict).length}},istTransactionsCount:{get:function(){return Object.keys(this.transactions.ist).length}}}),void 0===e?e={}:("string"==typeof e||e instanceof String)&&(e={uri:e}),e.log&&(e.log.hasOwnProperty("builtinEnabled")&&(this.log.builtinEnabled=e.log.builtinEnabled),e.log.hasOwnProperty("level")&&(this.log.level=e.log.level),e.log.hasOwnProperty("connector")&&(this.log.connector=e.log.connector));try{this.loadConfig(e)}catch(t){throw this.status=o.STATUS_NOT_READY,this.error=o.CONFIGURATION_ERROR,t}this.registerContext=new t.RegisterContext(this),this.registerContext.on("failed",i("registrationFailed")),this.registerContext.on("registered",i("registered")),this.registerContext.on("unregistered",i("unregistered")),this.configuration.autostart&&this.start()},n.prototype=Object.create(t.EventEmitter.prototype),n.prototype.register=function(t){return this.configuration.register=!0,this.registerContext.register(t),this},n.prototype.unregister=function(t){this.configuration.register=!1;var e=this.registerContext;return this.afterConnected(e.unregister.bind(e,t)),this},n.prototype.isRegistered=function(){return this.registerContext.registered},n.prototype.isConnected=function(){return!!this.transport&&this.transport.connected},n.prototype.afterConnected=function(t){this.isConnected()?t():this.once("connected",t)},n.prototype.invite=function(e,i,r){var s=new t.InviteClientContext(this,e,i,r);return this.afterConnected(s.invite.bind(s)),this.emit("inviteSent",s),s},n.prototype.subscribe=function(e,i,r){var s=new t.Subscription(this,e,i,r);return this.afterConnected(s.subscribe.bind(s)),s},n.prototype.message=function(e,i,r){if(void 0===i)throw new TypeError("Not enough arguments");return r=Object.create(r||Object.prototype),r.contentType||(r.contentType="text/plain"),r.body=i,this.request(t.C.MESSAGE,e,r)},n.prototype.request=function(e,i,r){var s=new t.ClientContext(this,e,i,r);return this.afterConnected(s.send.bind(s)),s},n.prototype.stop=function(){function i(){0===c.nistTransactionsCount&&0===c.nictTransactionsCount&&(c.removeListener("transactionDestroyed",i),c.transport.disconnect())}var s,n,a,c=this;if(this.logger.log("user requested closure..."),this.status===o.STATUS_USER_CLOSED)return this.logger.warn("UA already closed"),this;t.Timers.clearTimeout(this.transportRecoveryTimer),this.logger.log("closing registerContext"),this.registerContext.close();for(s in this.sessions)this.logger.log("closing session "+s),this.sessions[s].terminate();for(n in this.subscriptions)this.logger.log("unsubscribing from subscription "+n),this.subscriptions[n].close();for(n in this.earlySubscriptions)this.logger.log("unsubscribing from early subscription "+n),this.earlySubscriptions[n].close();for(a in this.applicants)this.applicants[a].close();return this.status=o.STATUS_USER_CLOSED,0===this.nistTransactionsCount&&0===this.nictTransactionsCount?this.transport.disconnect():this.on("transactionDestroyed",i),"function"==typeof r.removeEventListener&&(e.chrome&&e.chrome.app&&e.chrome.app.runtime||r.removeEventListener("unload",this.environListener)),this},n.prototype.start=function(){var i;return this.logger.log("user requested startup..."),this.status===o.STATUS_INIT?(i=this.getNextWsServer(),this.status=o.STATUS_STARTING,new t.Transport(this,i)):this.status===o.STATUS_USER_CLOSED?(this.logger.log("resuming"),this.status=o.STATUS_READY,this.transport.connect()):this.status===o.STATUS_STARTING?this.logger.log("UA is in STARTING status, not opening new connection"):this.status===o.STATUS_READY?this.logger.log("UA is in READY status, not resuming"):this.logger.error("Connection is down. Auto-Recovery system is trying to connect"),this.configuration.autostop&&"function"==typeof r.addEventListener&&(e.chrome&&e.chrome.app&&e.chrome.app.runtime||(this.environListener=this.stop.bind(this),r.addEventListener("unload",this.environListener))),this},n.prototype.normalizeTarget=function(e){return t.Utils.normalizeTarget(e,this.configuration.hostportParams)},n.prototype.saveCredentials=function(t){return this.cache.credentials[t.realm]=this.cache.credentials[t.realm]||{},this.cache.credentials[t.realm][t.uri]=t,this},n.prototype.getCredentials=function(t){var e,i;return e=t.ruri.host,this.cache.credentials[e]&&this.cache.credentials[e][t.ruri]&&(i=this.cache.credentials[e][t.ruri],i.method=t.method),i},n.prototype.getLogger=function(t,e){return this.log.getLogger(t,e)},n.prototype.onTransportClosed=function(e){var i,r,s,n=["nict","ict","nist","ist"];for(e.server.status=t.Transport.C.STATUS_DISCONNECTED,this.logger.log("connection state set to "+t.Transport.C.STATUS_DISCONNECTED),s=n.length,i=0;i<s;i++)for(r in this.transactions[n[i]])this.transactions[n[i]][r].onTransportError();this.contact.pub_gruu||this.closeSessionsOnTransportError()},n.prototype.onTransportError=function(e){var i;this.logger.log("transport "+e.server.ws_uri+" failed | connection state set to "+t.Transport.C.STATUS_ERROR),e.server.status=t.Transport.C.STATUS_ERROR,this.emit("disconnected",{transport:e}),this.status!==o.STATUS_USER_CLOSED&&(i=this.getNextWsServer(),i?new t.Transport(this,i):(this.closeSessionsOnTransportError(),this.error&&this.error===o.NETWORK_ERROR||(this.status=o.STATUS_NOT_READY,this.error=o.NETWORK_ERROR),this.recoverTransport()))},n.prototype.onTransportConnected=function(e){this.transport=e,this.transportRecoverAttempts=0,e.server.status=t.Transport.C.STATUS_READY,this.logger.log("connection state set to "+t.Transport.C.STATUS_READY),this.status!==o.STATUS_USER_CLOSED&&(this.status=o.STATUS_READY,this.error=null,this.configuration.register&&this.configuration.authenticationFactory.initialize().then(function(){this.registerContext.onTransportConnected()}.bind(this)),this.emit("connected",{transport:e}))},n.prototype.onTransportConnecting=function(t,e){this.emit("connecting",{transport:t,attempts:e})},n.prototype.newTransaction=function(t){this.transactions[t.type][t.id]=t,this.emit("newTransaction",{transaction:t})},n.prototype.destroyTransaction=function(t){delete this.transactions[t.type][t.id],this.emit("transactionDestroyed",{transaction:t})},n.prototype.receiveRequest=function(e){function i(t){return t&&t.user===e.ruri.user}var r,s,n,a,c,h,u=e.method,l=this;if(!(i(this.configuration.uri)||i(this.contact.uri)||i(this.contact.pub_gruu)||i(this.contact.temp_gruu)))return this.logger.warn("Request-URI does not point to us"),void(e.method!==t.C.ACK&&e.reply_sl(404));if(e.ruri.scheme===t.C.SIPS)return void e.reply_sl(416);if(!t.Transactions.checkTransaction(this,e))if(u===t.C.OPTIONS?(new t.Transactions.NonInviteServerTransaction(e,this),e.reply(200,null,["Allow: "+t.UA.C.ALLOWED_METHODS.toString(),"Accept: "+o.ACCEPTED_BODY_TYPES])):u===t.C.MESSAGE?(n=new t.ServerContext(this,e),n.body=e.body,n.content_type=e.getHeader("Content-Type")||"text/plain",e.reply(200,null),this.emit("message",n)):u!==t.C.INVITE&&u!==t.C.ACK&&new t.ServerContext(this,e),e.to_tag)r=this.findDialog(e),r?(u===t.C.INVITE&&new t.Transactions.InviteServerTransaction(e,this),r.receiveRequest(e)):u===t.C.NOTIFY?(s=this.findSession(e),a=this.findEarlySubscription(e),s?s.receiveRequest(e):a?a.receiveRequest(e):(this.logger.warn("received NOTIFY request for a non existent session or subscription"),e.reply(481,"Subscription does not exist"))):u!==t.C.ACK&&e.reply(481);else switch(u){case t.C.INVITE:if(c=this.configuration.replaces!==t.C.supported.UNSUPPORTED&&e.parseHeader("replaces")){if(!(h=this.dialogs[c.call_id+c.replaces_to_tag+c.replaces_from_tag]))return void e.reply_sl(481,null);if(h.owner.status===t.Session.C.STATUS_TERMINATED)return void e.reply_sl(603,null);if(h.state===t.Dialog.C.STATUS_CONFIRMED&&c.early_only)return void e.reply_sl(486,null)}s=new t.InviteServerContext(this,e),s.replacee=h&&h.owner,l.emit("invite",s);break;case t.C.BYE:e.reply(481);break;case t.C.CANCEL:s=this.findSession(e),s?s.receiveRequest(e):this.logger.warn("received CANCEL request for a non existent session");break;case t.C.ACK:break;case t.C.NOTIFY:this.configuration.allowLegacyNotifications&&this.listeners("notify").length>0?(e.reply(200,null),l.emit("notify",{request:e})):e.reply(481,"Subscription does not exist");break;default:e.reply(405)}},n.prototype.findSession=function(t){return this.sessions[t.call_id+t.from_tag]||this.sessions[t.call_id+t.to_tag]||null},n.prototype.findDialog=function(t){return this.dialogs[t.call_id+t.from_tag+t.to_tag]||this.dialogs[t.call_id+t.to_tag+t.from_tag]||null},n.prototype.findEarlySubscription=function(t){return this.earlySubscriptions[t.call_id+t.to_tag+t.getHeader("event")]||null},n.prototype.getNextWsServer=function(){var e,i,r,s=[];for(i=this.configuration.wsServers.length,e=0;e<i;e++)r=this.configuration.wsServers[e],r.status!==t.Transport.C.STATUS_ERROR&&(0===s.length?s.push(r):r.weight>s[0].weight?s=[r]:r.weight===s[0].weight&&s.push(r));return e=Math.floor(Math.random()*s.length),s[e]},n.prototype.closeSessionsOnTransportError=function(){var t;for(t in this.sessions)this.sessions[t].onTransportError();this.registerContext.onTransportClosed()},n.prototype.recoverTransport=function(e){var i,r,s,n,o,a;for(e=e||this,o=e.transportRecoverAttempts,r=e.configuration.wsServers.length,i=0;i<r;i++)e.configuration.wsServers[i].status=0;a=e.getNextWsServer(),s=Math.floor(Math.random()*Math.pow(2,o)+1),n=s*e.configuration.connectionRecoveryMinInterval,n>e.configuration.connectionRecoveryMaxInterval&&(this.logger.log("time for next connection attempt exceeds connectionRecoveryMaxInterval, resetting counter"),n=e.configuration.connectionRecoveryMinInterval,o=0),this.logger.log("next connection attempt in "+n+" seconds"),this.transportRecoveryTimer=t.Timers.setTimeout(function(){e.transportRecoverAttempts=o+1,new t.Transport(e,a)},1e3*n)},n.prototype.loadConfig=function(e){function r(t,i){var r=t.replace(/([a-z][A-Z])/g,function(t){return t[0]+"_"+t[1].toLowerCase()});if(t!==r){var s=e.hasOwnProperty(t);e.hasOwnProperty(r)&&(i.warn(r+" is deprecated, please use "+t),s&&i.warn(t+" overriding "+r)),e[t]=s?e[t]:e[r]}}var n,o,a,c,h,u={viaHost:t.Utils.createRandomToken(12)+".invalid",uri:new t.URI("sip","anonymous."+t.Utils.createRandomToken(6),"anonymous.invalid",null,null),wsServers:[{scheme:"WSS",sip_uri:"<sip:edge.sip.onsip.com;transport=ws;lr>",status:0,weight:0,ws_uri:"wss://edge.sip.onsip.com"}],custom:{},displayName:"",password:null,registerExpires:600,register:!0,registrarServer:null,wsServerMaxReconnection:3,wsServerReconnectionTimeout:4,connectionRecoveryMinInterval:2,connectionRecoveryMaxInterval:30,keepAliveInterval:0,extraSupported:[],usePreloadedRoute:!1,userAgentString:t.C.USER_AGENT,noAnswerTimeout:60,traceSip:!1,hackViaTcp:!1,hackIpInContact:!1,hackWssInTransport:!1,hackAllowUnregisteredOptionTags:!1,sessionDescriptionHandlerFactoryOptions:{constraints:{},peerConnectionOptions:{iceCheckingTimeout:5e3,rtcConfiguration:{}}},contactName:t.Utils.createRandomToken(8),contactTransport:"ws",forceRport:!1,autostart:!0,autostop:!0,rel100:t.C.supported.UNSUPPORTED,replaces:t.C.supported.UNSUPPORTED,sessionDescriptionHandlerFactory:i(27)(t).defaultFactory,authenticationFactory:s(function(e){return new t.DigestAuthentication(e)}),allowLegacyNotifications:!1},l=this.getConfigurationCheck();for(n in l.mandatory){if(r(n,this.logger),!e.hasOwnProperty(n))throw new t.Exceptions.ConfigurationError(n);if(o=e[n],void 0===(a=l.mandatory[n](o)))throw new t.Exceptions.ConfigurationError(n,o);u[n]=a}for(n in l.optional)if(r(n,this.logger),e.hasOwnProperty(n)){if((o=e[n])instanceof Array&&0===o.length)continue;if(null===o||""===o||void 0===o)continue;if("number"==typeof o&&isNaN(o))continue;if(void 0===(a=l.optional[n](o)))throw new t.Exceptions.ConfigurationError(n,o);u[n]=a}if(u.connectionRecoveryMaxInterval<u.connectionRecoveryMinInterval)throw new t.Exceptions.ConfigurationError("connectionRecoveryMaxInterval",u.connectionRecoveryMaxInterval);0===u.displayName&&(u.displayName="0"),u.instanceId||(u.instanceId=t.Utils.newUUID()),u.sipjsId=t.Utils.createRandomToken(5),c=u.uri.clone(),c.user=null,u.hostportParams=c.toRaw().replace(/^sip:/i,""),u.authorizationUser||(u.authorizationUser=u.uri.user),u.registrarServer||(h=u.uri.clone(),h.user=null,u.registrarServer=h),u.noAnswerTimeout=1e3*u.noAnswerTimeout,u.hackIpInContact&&("boolean"==typeof u.hackIpInContact?u.viaHost=t.Utils.getRandomTestNetIP():"string"==typeof u.hackIpInContact&&(u.viaHost=u.hackIpInContact)),u.hackWssInTransport&&(u.contactTransport="wss"),this.contact={pub_gruu:null,temp_gruu:null,uri:new t.URI("sip",u.contactName,u.viaHost,null,{transport:u.contactTransport}),toString:function(t){t=t||{};var e=t.anonymous||null,i=t.outbound||null,r="<";return r+=e?(this.temp_gruu||"sip:anonymous@anonymous.invalid;transport="+u.contactTransport).toString():(this.pub_gruu||this.uri).toString(),i&&(r+=";ob"),r+=">"}};var d={};for(n in u)d[n]={value:u[n],writable:"register"===n||"custom"===n,configurable:!1};Object.defineProperties(this.configuration,d),this.logger.log("configuration parameters after validation:");for(n in u)switch(n){case"uri":case"registrarServer":case"sessionDescriptionHandlerFactory":this.logger.log("\xb7 "+n+": "+u[n]);break;case"password":this.logger.log("\xb7 "+n+": NOT SHOWN");break;default:this.logger.log("\xb7 "+n+": "+JSON.stringify(u[n]))}},n.prototype.getConfigurationCheck=function(){return{mandatory:{},optional:{uri:function(e){var i;return/^sip:/i.test(e)||(e=t.C.SIP+":"+e),i=t.URI.parse(e),i&&i.user?i:void 0},wsServers:function(e){var i,r,s;if("string"==typeof e)e=[{ws_uri:e}];else{if(!(e instanceof Array))return;for(r=e.length,i=0;i<r;i++)"string"==typeof e[i]&&(e[i]={ws_uri:e[i]})}if(0===e.length)return!1;for(r=e.length,i=0;i<r;i++){if(!e[i].ws_uri)return;if(e[i].weight&&!Number(e[i].weight))return;if(-1===(s=t.Grammar.parse(e[i].ws_uri,"absoluteURI")))return;if(["wss","ws","udp"].indexOf(s.scheme)<0)return;e[i].sip_uri="<sip:"+s.host+(s.port?":"+s.port:"")+";transport="+s.scheme.replace(/^wss$/i,"ws")+";lr>",e[i].weight||(e[i].weight=0),e[i].status=0,e[i].scheme=s.scheme.toUpperCase()}return e},authorizationUser:function(e){return-1===t.Grammar.parse('"'+e+'"',"quoted_string")?void 0:e},connectionRecoveryMaxInterval:function(e){var i;if(t.Utils.isDecimal(e)&&(i=Number(e))>0)return i},connectionRecoveryMinInterval:function(e){var i;if(t.Utils.isDecimal(e)&&(i=Number(e))>0)return i},displayName:function(e){return-1===t.Grammar.parse('"'+e+'"',"displayName")?void 0:e},hackViaTcp:function(t){if("boolean"==typeof t)return t},hackIpInContact:function(e){return"boolean"==typeof e?e:"string"==typeof e&&-1!==t.Grammar.parse(e,"host")?e:void 0},hackWssInTransport:function(t){if("boolean"==typeof t)return t},hackAllowUnregisteredOptionTags:function(t){if("boolean"==typeof t)return t},contactTransport:function(t){if("string"==typeof t)return t},forceRport:function(t){if("boolean"==typeof t)return t},instanceId:function(e){if("string"==typeof e)return/^uuid:/i.test(e)&&(e=e.substr(5)),-1===t.Grammar.parse(e,"uuid")?void 0:e},keepAliveInterval:function(e){var i;if(t.Utils.isDecimal(e)&&(i=Number(e))>0)return i},extraSupported:function(t){var e,i;if(t instanceof Array){for(i=t.length,e=0;e<i;e++)if("string"!=typeof t[e])return;return t}},noAnswerTimeout:function(e){var i;if(t.Utils.isDecimal(e)&&(i=Number(e))>0)return i},password:function(t){return String(t)},rel100:function(e){return e===t.C.supported.REQUIRED?t.C.supported.REQUIRED:e===t.C.supported.SUPPORTED?t.C.supported.SUPPORTED:t.C.supported.UNSUPPORTED},replaces:function(e){return e===t.C.supported.REQUIRED?t.C.supported.REQUIRED:e===t.C.supported.SUPPORTED?t.C.supported.SUPPORTED:t.C.supported.UNSUPPORTED},register:function(t){if("boolean"==typeof t)return t},registerExpires:function(e){var i;if(t.Utils.isDecimal(e)&&(i=Number(e))>0)return i},registrarServer:function(e){var i;if("string"==typeof e)return/^sip:/i.test(e)||(e=t.C.SIP+":"+e),i=t.URI.parse(e),i?i.user?void 0:i:void 0},traceSip:function(t){if("boolean"==typeof t)return t},rtcpMuxPolicy:function(t){if("string"==typeof t)return t},userAgentString:function(t){if("string"==typeof t)return t},usePreloadedRoute:function(t){if("boolean"==typeof t)return t},wsServerMaxReconnection:function(e){var i;if(t.Utils.isDecimal(e)&&(i=Number(e))>0)return i},wsServerReconnectionTimeout:function(e){var i;if(t.Utils.isDecimal(e)&&(i=Number(e))>0)return i},autostart:function(t){if("boolean"==typeof t)return t},autostop:function(t){if("boolean"==typeof t)return t},sessionDescriptionHandlerFactory:function(t){if(t instanceof Function)return t},sessionDescriptionHandlerFactoryOptions:function(t){if("object"==typeof t)return t},authenticationFactory:s,allowLegacyNotifications:function(t){if("boolean"==typeof t)return t},custom:function(t){if("object"==typeof t)return t},contactName:function(t){if("string"==typeof t)return t}}}},n.C=o,t.UA=n}}).call(e,i(0))},function(t,e,i){"use strict";(function(e){t.exports=function(t){var i=function(t,i){this.options=i||{},this.logger=t.ua.getLogger("sip.invitecontext.sessionDescriptionHandler",t.id),this.session=t,this.CONTENT_TYPE="application/sdp",this.modifiers=this.options.modifiers||[],Array.isArray(this.modifiers)||(this.modifiers=[this.modifiers]);var r=e.window||e;this.WebRTC={MediaStream:r.MediaStream,getUserMedia:r.navigator.mediaDevices.getUserMedia.bind(r.navigator.mediaDevices),RTCPeerConnection:r.RTCPeerConnection,RTCSessionDescription:r.RTCSessionDescription},this.initPeerConnection(this.options.peerConnectionOptions),this.constraints=this.checkAndDefaultConstraints(this.options.constraints),this.session.emit("SessionDescriptionHandler-created",this)};return i.defaultFactory=function(t,e){return new i(t,e)},i.prototype=Object.create(t.SessionDescriptionHandler.prototype,{close:{writable:!0,value:function(){this.logger.log("closing PeerConnection"),this.peerConnection&&"closed"!==this.peerConnection.signalingState&&(this.peerConnection.getSenders?this.peerConnection.getSenders().forEach(function(t){t.track&&t.track.stop()}):(this.logger.warn("Using getLocalStreams which is deprecated"),this.peerConnection.getLocalStreams().forEach(function(t){t.getTracks().forEach(function(t){t.stop()})})),this.peerConnection.getReceivers?this.peerConnection.getReceivers().forEach(function(t){t.track&&t.track.stop()}):(this.logger.warn("Using getRemoteStreams which is deprecated"),this.peerConnection.getRemoteStreams().forEach(function(t){t.getTracks().forEach(function(t){t.stop()})})),this.peerConnection.close())}},getDescription:{writable:!0,value:function(e,i){var r=this,s=!0;return this.session.disableRenegotiation?(this.logger.warn('The flag "disableRenegotiation" is set to true for this session description handler. We will not try to renegotiate.'),t.Utils.Promise.reject(new t.Exceptions.RenegotiationError("disableRenegotiation flag set to true for this session description handler"))):(e=e||{},e.peerConnectionOptions&&this.initPeerConnection(e.peerConnectionOptions),this.constraints&&e.constraints&&this.constraints===e.constraints&&(s=!1),this.constraints=Object.assign(this.constraints,e.constraints),this.constraints=this.checkAndDefaultConstraints(this.constraints),i=i||[],Array.isArray(i)||(i=[i]),i=i.concat(this.modifiers),!s&&this.peerConnection.localDescription&&this.peerConnection.localDescription.sdp&&""!==this.peerConnection.localDescription.sdp?this.createOfferOrAnswer({},i).then(function(t){return{body:t,contentType:r.CONTENT_TYPE}}):(r.logger.log("acquiring local media"),this.acquire(r.constraints).then(function(t){return r.logger.log("acquired local media streams"),t},function(t){throw r.logger.error("unable to acquire streams"),r.logger.error(t),t}).then(function(e){try{e=[].concat(e),e.forEach(function(t){r.peerConnection.addTrack?t.getTracks().forEach(function(e){r.peerConnection.addTrack(e,t)}):r.peerConnection.addStream(t)},this)}catch(e){return r.logger.error("error adding stream"),r.logger.error(e),t.Utils.Promise.reject(e)}return t.Utils.Promise.resolve()}).then(function(){return r.createOfferOrAnswer(e.RTCOfferOptions,i)}).then(function(t){return{body:t,contentType:r.CONTENT_TYPE}}).catch(function(t){throw this.session.disableRenegotiation=!0,t})))}},hasDescription:{writable:!0,value:function(t){return t===this.CONTENT_TYPE}},holdModifier:{writable:!0,value:function(e){return/a=(sendrecv|sendonly|recvonly|inactive)/.test(e.sdp)?(e.sdp=e.sdp.replace(/a=sendrecv\r\n/g,"a=sendonly\r\n"),e.sdp=e.sdp.replace(/a=recvonly\r\n/g,"a=inactive\r\n")):e.sdp=e.sdp.replace(/(m=[^\r]*\r\n)/g,"$1a=sendonly\r\n"),t.Utils.Promise.resolve(e)}},setDescription:{writable:!0,value:function(e,i,r){var s=this,n="undefined"!=typeof InstallTrigger;if(!this.session.disableRenegotiation&&n&&this.peerConnection&&this.isVideoHold(e)&&(this.session.disableRenegotiation=!0),this.session.disableRenegotiation)return this.logger.warn('The flag "disableRenegotiation" is set to true for this session description handler. We will not try to renegotiate.'),t.Utils.Promise.reject(new t.Exceptions.RenegotiationError("disableRenegotiation flag set to true for this session description handler"));i=i||{},i.peerConnectionOptions&&this.initPeerConnection(i.peerConnectionOptions),this.constraints=Object.assign(this.constraints,i.constraints),this.constraints=this.checkAndDefaultConstraints(this.constraints),r=r||[],Array.isArray(r)||(r=[r]),r=r.concat(this.modifiers);var o={type:this.hasOffer("local")?"answer":"offer",sdp:e};return t.Utils.reducePromises(r,o).catch(function(t){throw s.logger.error("The modifiers did not resolve successfully"),s.logger.error(t),t}).then(function(t){return s.emit("setDescription",t),s.peerConnection.setRemoteDescription(new s.WebRTC.RTCSessionDescription(t))}).catch(function(t){throw s.session.disableRenegotiation=!0,s.logger.error(t),s.emit("peerConnection-setRemoteDescriptionFailed",t),t}).then(function(){s.peerConnection.getRemoteStreams?s.emit("setRemoteDescription",s.peerConnection.getRemoteStreams()):s.emit("setRemoteDescription",s.peerConnection.getReceivers()),s.emit("confirmed",s)})}},createOfferOrAnswer:{writable:!0,value:function(e,i){var r,s=this,n=this.peerConnection;return e=e||{},r=s.hasOffer("remote")?"createAnswer":"createOffer",n[r](e).catch(function(t){throw s.emit("peerConnection-"+r+"Failed",t),t}).then(function(e){return t.Utils.reducePromises(i,e)}).then(function(t){return s.logger.log(t),n.setLocalDescription(t)}).catch(function(t){throw s.emit("peerConnection-SetLocalDescriptionFailed",t),t}).then(function(){return new t.Utils.Promise(function(t){"complete"!==n.iceGatheringState||"connected"!==n.iceConnectionState&&"completed"!==n.iceConnectionState?s.onIceCompleted.promise.then(t):t()})}).then(function(){var t=s.peerConnection.localDescription;return s.emit("getDescription",t),t.sdp}).catch(function(e){throw s.logger.error(e),new t.Exceptions.GetDescriptionError(e)})}},addDefaultIceServers:{writable:!0,value:function(t){return t.iceServers||(t.iceServers=[{urls:"stun:stun.l.google.com:19302"}]),t}},checkAndDefaultConstraints:{writable:!0,value:function(t){var e={audio:!0,video:!0};return t=t||e,0===Object.keys(t).length&&t.constructor===Object?e:t}},initPeerConnection:{writable:!0,value:function(e){var i=this;e=e||{},e.rtcConfiguration=e.rtcConfiguration||{},e.rtcConfiguration=this.addDefaultIceServers(e.rtcConfiguration),this.onIceCompleted=t.Utils.defer(),this.onIceCompleted.promise.then(function(e){i.emit("iceGatheringComplete",e),i.iceCheckingTimer&&(t.Timers.clearTimeout(i.iceCheckingTimer),i.iceCheckingTimer=null)}),this.peerConnection&&this.peerConnection.close(),this.peerConnection=new this.WebRTC.RTCPeerConnection(e.rtcConfiguration),this.session.emit("peerConnection-created",this.peerConnection),this.peerConnection.ontrack=function(t){i.logger.log("track added"),i.emit("addTrack",t)},this.peerConnection.onaddstream=function(t){i.logger.warn("Using deprecated stream API"),i.logger.log("stream added"),i.emit("addStream",t)},this.peerConnection.onremovestream=function(t){i.logger.log("stream removed: "+t.stream.id)},this.startIceCheckingTimer=function(){!i.iceCheckingTimer&&e.iceCheckingTimeout&&(i.iceCheckingTimer=t.Timers.setTimeout(function(){i.logger.log("RTCIceChecking Timeout Triggered after "+e.iceCheckingTimeout+" milliseconds"),i.onIceCompleted.resolve(this)}.bind(this.peerConnection),e.iceCheckingTimeout))},this.peerConnection.onicecandidate=function(t){i.emit("iceCandidate",t),t.candidate?(i.logger.log("ICE candidate received: "+(null===t.candidate.candidate?null:t.candidate.candidate.trim())),i.startIceCheckingTimer()):i.onIceCompleted.resolve(this)},this.peerConnection.onicegatheringstatechange=function(){i.logger.log("RTCIceGatheringState changed: "+this.iceGatheringState),"gathering"===this.iceGatheringState&&i.emit("iceGathering",this),"complete"===this.iceGatheringState&&i.onIceCompleted.resolve(this)},this.peerConnection.oniceconnectionstatechange=function(){var t;switch("checking"===this.iceConnectionState&&i.startIceCheckingTimer(),this.iceConnectionState){case"new":t="iceConnection";break;case"checking":t="iceConnectionChecking";break;case"connected":t="iceConnectionConnected";break;case"completed":t="iceConnectionCompleted";break;case"failed":t="iceConnectionFailed";break;case"disconnected":t="iceConnectionDisconnected";break;case"closed":t="iceConnectionClosed";break;default:return void i.logger.warn("Unknown iceConnection state:",this.iceConnectionState)}i.emit(t,this)}}},acquire:{writable:!0,value:function(e){return e=this.checkAndDefaultConstraints(e),new t.Utils.Promise(function(t,i){this.emit("userMediaRequest",e);var r=function(t,e){var i=Array.prototype.slice.call(arguments,2),r=[t].concat(i);return this.emit.apply(this,r),e.apply(null,i)}.bind(this);e.audio||e.video?this.WebRTC.getUserMedia(e).then(r.bind(this,"userMedia",function(e){t(e)}),r.bind(this,"userMediaFailed",function(t){throw i(t),t})):t([])}.bind(this))}},isVideoHold:{writable:!0,value:function(t){return-1!==t.search(/^(m=video.*?)[\s\S]*^(a=sendonly?)/gm)}},hasOffer:{writable:!0,value:function(t){var e="have-"+t+"-offer";return this.peerConnection.signalingState===e}}}),i}}).call(e,i(0))},function(t,e,i){"use strict";t.exports=function(t){function e(e,i,r){var s,n=t.Utils.buildStatusLine(e),o=i.getHeaders("via"),a=o.length,c=0;for(c;c<a;c++)n+="Via: "+o[c]+"\r\n";s=i.getHeader("To"),i.to_tag||(s+=";tag="+t.Utils.newTag()),n+="To: "+s+"\r\n",n+="From: "+i.getHeader("From")+"\r\n",n+="Call-ID: "+i.call_id+"\r\n",n+="CSeq: "+i.cseq+" "+i.method+"\r\n",n+="\r\n",r.send(n)}function i(t,i,r){if(!t.ruri||"sip"!==t.ruri.scheme)return e(416,t,r),!1}function r(t,i,r){if(!t.to_tag&&t.call_id.substr(0,5)===i.configuration.sipjsId)return e(482,t,r),!1}function s(i,r,s){if(t.Utils.str_utf8_length(i.body)<i.getHeader("content-length"))return e(400,i,s),!1}function n(i,r,s){var n,o,a=i.from_tag,c=i.call_id,h=i.cseq;if(!i.to_tag)if(i.method===t.C.INVITE){if(n=r.transactions.ist[i.via_branch])return;for(o in r.transactions.ist)if(n=r.transactions.ist[o],n.request.from_tag===a&&n.request.call_id===c&&n.request.cseq===h)return e(482,i,s),!1}else{if(n=r.transactions.nist[i.via_branch])return;for(o in r.transactions.nist)if(n=r.transactions.nist[o],n.request.from_tag===a&&n.request.call_id===c&&n.request.cseq===h)return e(482,i,s),!1}}function o(t,e){if(t.getHeaders("via").length>1)return e.getLogger("sip.sanitycheck").warn("More than one Via header field present in the response. Dropping the response"),!1}function a(t,e){var i=e.configuration.viaHost;if(t.via.host!==i||void 0!==t.via.port)return e.getLogger("sip.sanitycheck").warn("Via sent-by in the response does not match UA Via host value. Dropping the response"),!1}function c(e,i){if(t.Utils.str_utf8_length(e.body)<e.getHeader("content-length"))return i.getLogger("sip.sanitycheck").warn("Message body length is lower than the value in Content-Length header field. Dropping the response"),!1}function h(t,e){for(var i=["from","to","call_id","cseq","via"],r=i.length;r--;)if(!t.hasHeader(i[r]))return e.getLogger("sip.sanitycheck").warn("Missing mandatory header field : "+i[r]+". Dropping the response"),!1}var u,l=[],d=[],p=[];l.push(i),l.push(r),l.push(s),l.push(n),d.push(o),d.push(a),d.push(c),p.push(h),u=function(e,i,r){var s;for(s=p.length;s--;)if(!1===p[s](e,i,r))return!1;if(e instanceof t.IncomingRequest){for(s=l.length;s--;)if(!1===l[s](e,i,r))return!1}else if(e instanceof t.IncomingResponse)for(s=d.length;s--;)if(!1===d[s](e,i,r))return!1;return!0},t.sanityCheck=u}},function(t,e,i){"use strict";t.exports=function(t){var e;return e=function(t){this.logger=t.getLogger("sipjs.digestauthentication"),this.username=t.configuration.authorizationUser,this.password=t.configuration.password,this.cnonce=null,this.nc=0,this.ncHex="00000000",this.response=null},e.prototype.authenticate=function(e,i){if(this.algorithm=i.algorithm,this.realm=i.realm,this.nonce=i.nonce,this.opaque=i.opaque,this.stale=i.stale,this.algorithm){if("MD5"!==this.algorithm)return this.logger.warn('challenge with Digest algorithm different than "MD5", authentication aborted'),!1}else this.algorithm="MD5";if(!this.realm)return this.logger.warn("challenge without Digest realm, authentication aborted"),!1;if(!this.nonce)return this.logger.warn("challenge without Digest nonce, authentication aborted"),!1;if(i.qop)if(i.qop.indexOf("auth")>-1)this.qop="auth";else{if(!(i.qop.indexOf("auth-int")>-1))return this.logger.warn('challenge without Digest qop different than "auth" or "auth-int", authentication aborted'),!1;this.qop="auth-int"}else this.qop=null;return this.method=e.method,this.uri=e.ruri,this.cnonce=t.createRandomToken(12),this.nc+=1,this.updateNcHex(),4294967296===this.nc&&(this.nc=1,this.ncHex="00000001"),this.calculateResponse(),!0},e.prototype.calculateResponse=function(){var e,i;e=t.calculateMD5(this.username+":"+this.realm+":"+this.password),"auth"===this.qop?(i=t.calculateMD5(this.method+":"+this.uri),this.response=t.calculateMD5(e+":"+this.nonce+":"+this.ncHex+":"+this.cnonce+":auth:"+i)):"auth-int"===this.qop?(i=t.calculateMD5(this.method+":"+this.uri+":"+t.calculateMD5(this.body?this.body:"")),this.response=t.calculateMD5(e+":"+this.nonce+":"+this.ncHex+":"+this.cnonce+":auth-int:"+i)):null===this.qop&&(i=t.calculateMD5(this.method+":"+this.uri),this.response=t.calculateMD5(e+":"+this.nonce+":"+i))},e.prototype.toString=function(){var t=[];if(!this.response)throw new Error("response field does not exist, cannot generate Authorization header");return t.push("algorithm="+this.algorithm),t.push('username="'+this.username+'"'),t.push('realm="'+this.realm+'"'),t.push('nonce="'+this.nonce+'"'),t.push('uri="'+this.uri+'"'),t.push('response="'+this.response+'"'),this.opaque&&t.push('opaque="'+this.opaque+'"'),this.qop&&(t.push("qop="+this.qop),t.push('cnonce="'+this.cnonce+'"'),t.push("nc="+this.ncHex)),"Digest "+t.join(", ")},e.prototype.updateNcHex=function(){var t=Number(this.nc).toString(16);this.ncHex="00000000".substr(0,8-t.length)+t},e}},function(t,e,i){"use strict";var r=i(31);t.exports=function(t){return{parse:function(e,i){var s={startRule:i,SIP:t};try{r.parse(e,s)}catch(t){s.data=-1}return s.data}}}},function(t,e,i){"use strict";function r(t,e,i,s){this.message=t,this.expected=e,this.found=i,this.location=s,this.name="SyntaxError","function"==typeof Error.captureStackTrace&&Error.captureStackTrace(this,r)}function s(t,e){function i(){return t.substring(C,v)}function s(){return h(C,v)}function n(t,e){return{type:"literal",text:t,ignoreCase:e}}function o(t,e,i){return{type:"class",parts:t,inverted:e,ignoreCase:i}}function a(t){return{type:"other",description:t}}function c(e){var i,r=R[e];if(r)return r;for(i=e-1;!R[i];)i--;for(r=R[i],r={line:r.line,column:r.column};i<e;)10===t.charCodeAt(i)?(r.line++,r.column=1):r.column++,i++;return R[e]=r,r}function h(t,e){var i=c(t),r=c(e);return{start:{offset:t,line:i.line,column:i.column},end:{offset:e,line:r.line,column:r.column}}}function u(t){v<A||(v>A&&(A=v,y=[]),y.push(t))}function l(t,e,i){return new r(r.buildMessage(t,e),t,e,i)}function d(t){var e,i=new Array(t.length);for(e=0;e<t.length;e++)i[e]=t.charCodeAt(e)-32;return i}function p(e){for(var i,r,s=S[e],n=0,o=[],a=s.length,c=[],h=[];;){for(;n<a;)switch(s[n]){case 0:h.push(E[s[n+1]]),n+=2;break;case 1:h.push(void 0),n++;break;case 2:h.push(null),n++;break;case 3:h.push(T),n++;break;case 4:h.push([]),n++;break;case 5:h.push(v),n++;break;case 6:h.pop(),n++;break;case 7:v=h.pop(),n++;break;case 8:h.length-=s[n+1],n+=2;break;case 9:h.splice(-2,1),n++;break;case 10:h[h.length-2].push(h.pop()),n++;break;case 11:h.push(h.splice(h.length-s[n+1],s[n+1])),n+=2;break;case 12:h.push(t.substring(h.pop(),v)),n++;break;case 13:c.push(a),o.push(n+3+s[n+1]+s[n+2]),h[h.length-1]?(a=n+3+s[n+1],n+=3):(a=n+3+s[n+1]+s[n+2],n+=3+s[n+1]);break;case 14:c.push(a),o.push(n+3+s[n+1]+s[n+2]),h[h.length-1]===T?(a=n+3+s[n+1],n+=3):(a=n+3+s[n+1]+s[n+2],n+=3+s[n+1]);break;case 15:c.push(a),o.push(n+3+s[n+1]+s[n+2]),h[h.length-1]!==T?(a=n+3+s[n+1],n+=3):(a=n+3+s[n+1]+s[n+2],n+=3+s[n+1]);break;case 16:h[h.length-1]!==T?(c.push(a),o.push(n),a=n+2+s[n+1],n+=2):n+=2+s[n+1];break;case 17:c.push(a),o.push(n+3+s[n+1]+s[n+2]),t.length>v?(a=n+3+s[n+1],n+=3):(a=n+3+s[n+1]+s[n+2],n+=3+s[n+1]);break;case 18:c.push(a),o.push(n+4+s[n+2]+s[n+3]),t.substr(v,E[s[n+1]].length)===E[s[n+1]]?(a=n+4+s[n+2],n+=4):(a=n+4+s[n+2]+s[n+3],n+=4+s[n+2]);break;case 19:c.push(a),o.push(n+4+s[n+2]+s[n+3]),t.substr(v,E[s[n+1]].length).toLowerCase()===E[s[n+1]]?(a=n+4+s[n+2],n+=4):(a=n+4+s[n+2]+s[n+3],n+=4+s[n+2]);break;case 20:c.push(a),o.push(n+4+s[n+2]+s[n+3]),E[s[n+1]].test(t.charAt(v))?(a=n+4+s[n+2],n+=4):(a=n+4+s[n+2]+s[n+3],n+=4+s[n+2]);break;case 21:h.push(t.substr(v,s[n+1])),v+=s[n+1],n+=2;break;case 22:h.push(E[s[n+1]]),v+=E[s[n+1]].length,n+=2;break;case 23:h.push(T),0===I&&u(E[s[n+1]]),n+=2;break;case 24:C=h[h.length-1-s[n+1]],n+=2;break;case 25:C=v,n++;break;case 26:for(i=s.slice(n+4,n+4+s[n+3]),r=0;r<s[n+3];r++)i[r]=h[h.length-1-i[r]];h.splice(h.length-s[n+2],s[n+2],E[s[n+1]].apply(null,i)),n+=4+s[n+3];break;case 27:h.push(p(s[n+1])),n+=2;break;case 28:I++,n++;break;case 29:I--,n++;break;default:throw new Error("Invalid opcode: "+s[n]+".")}if(!(c.length>0))break;a=c.pop(),n=o.pop()}return h[0]}function f(t,e){return[t].concat(e)}e=void 0!==e?e:{};var g,T={},m={Contact:118,Name_Addr_Header:155,Record_Route:175,Request_Response:81,SIP_URI:45,Subscription_State:185,Supported:190,Require:181,Via:193,absoluteURI:84,Call_ID:117,Content_Disposition:129,Content_Length:134,Content_Type:135,CSeq:145,displayName:121,Event:148,From:150,host:52,Max_Forwards:153,Min_SE:212,Proxy_Authenticate:156,quoted_string:40,Refer_To:177,Replaces:178,Session_Expires:209,stun_URI:216,To:191,turn_URI:222,uuid:225,WWW_Authenticate:208,challenge:157},_=118,E=["\r\n",n("\r\n",!1),/^[0-9]/,o([["0","9"]],!1,!1),/^[a-zA-Z]/,o([["a","z"],["A","Z"]],!1,!1),/^[0-9a-fA-F]/,o([["0","9"],["a","f"],["A","F"]],!1,!1),/^[\0-\xFF]/,o([["\0","\xff"]],!1,!1),/^["]/,o(['"'],!1,!1)," ",n(" ",!1),"\t",n("\t",!1),/^[a-zA-Z0-9]/,o([["a","z"],["A","Z"],["0","9"]],!1,!1),";",n(";",!1),"/",n("/",!1),"?",n("?",!1),":",n(":",!1),"@",n("@",!1),"&",n("&",!1),"=",n("=",!1),"+",n("+",!1),"$",n("$",!1),",",n(",",!1),"-",n("-",!1),"_",n("_",!1),".",n(".",!1),"!",n("!",!1),"~",n("~",!1),"*",n("*",!1),"'",n("'",!1),"(",n("(",!1),")",n(")",!1),"%",n("%",!1),function(){return" "},function(){return":"},/^[!-~]/,o([["!","~"]],!1,!1),/^[\x80-\uFFFF]/,o([["\x80","\uffff"]],!1,!1),/^[\x80-\xBF]/,o([["\x80","\xbf"]],!1,!1),/^[a-f]/,o([["a","f"]],!1,!1),"`",n("`",!1),"<",n("<",!1),">",n(">",!1),"\\",n("\\",!1),"[",n("[",!1),"]",n("]",!1),"{",n("{",!1),"}",n("}",!1),function(){return"*"},function(){return"/"},function(){return"="},function(){return"("},function(){return")"},function(){return">"},function(){return"<"},function(){return","},function(){return";"},function(){return":"},function(){return'"'},/^[!-']/,o([["!","'"]],!1,!1),/^[*-[]/,o([["*","["]],!1,!1),/^[\]-~]/,o([["]","~"]],!1,!1),function(t){return t},/^[#-[]/,o([["#","["]],!1,!1),/^[\0-\t]/,o([["\0","\t"]],!1,!1),/^[\x0B-\f]/,o([["\v","\f"]],!1,!1),/^[\x0E-\x7F]/,o([["\x0e","\x7f"]],!1,!1),function(){e.data.uri=new e.SIP.URI(e.data.scheme,e.data.user,e.data.host,e.data.port),delete e.data.scheme,delete e.data.user,delete e.data.host,delete e.data.host_type,delete e.data.port},function(){e.data.uri=new e.SIP.URI(e.data.scheme,e.data.user,e.data.host,e.data.port,e.data.uri_params,e.data.uri_headers),delete e.data.scheme,delete e.data.user,delete e.data.host,delete e.data.host_type,delete e.data.port,delete e.data.uri_params,"SIP_URI"===e.startRule&&(e.data=e.data.uri)},"sips",n("sips",!0),"sip",n("sip",!0),function(t){e.data.scheme=t},function(){e.data.user=decodeURIComponent(i().slice(0,-1))},function(){e.data.password=i()},function(){return e.data.host=i(),e.data.host},function(){return e.data.host_type="domain",i()},/^[a-zA-Z0-9_\-]/,o([["a","z"],["A","Z"],["0","9"],"_","-"],!1,!1),/^[a-zA-Z0-9\-]/,o([["a","z"],["A","Z"],["0","9"],"-"],!1,!1),function(){return e.data.host_type="IPv6",i()},"::",n("::",!1),function(){return e.data.host_type="IPv6",i()},function(){return e.data.host_type="IPv4",i()},"25",n("25",!1),/^[0-5]/,o([["0","5"]],!1,!1),"2",n("2",!1),/^[0-4]/,o([["0","4"]],!1,!1),"1",n("1",!1),/^[1-9]/,o([["1","9"]],!1,!1),function(t){return t=parseInt(t.join("")),e.data.port=t,t},"transport=",n("transport=",!0),"udp",n("udp",!0),"tcp",n("tcp",!0),"sctp",n("sctp",!0),"tls",n("tls",!0),function(t){e.data.uri_params||(e.data.uri_params={}),e.data.uri_params.transport=t.toLowerCase()},"user=",n("user=",!0),"phone",n("phone",!0),"ip",n("ip",!0),function(t){e.data.uri_params||(e.data.uri_params={}),e.data.uri_params.user=t.toLowerCase()},"method=",n("method=",!0),function(t){e.data.uri_params||(e.data.uri_params={}),e.data.uri_params.method=t},"ttl=",n("ttl=",!0),function(t){e.data.params||(e.data.params={}),e.data.params.ttl=t},"maddr=",n("maddr=",!0),function(t){e.data.uri_params||(e.data.uri_params={}),e.data.uri_params.maddr=t},"lr",n("lr",!0),function(){e.data.uri_params||(e.data.uri_params={}),e.data.uri_params.lr=void 0},function(t,i){e.data.uri_params||(e.data.uri_params={}),i=null===i?void 0:i[1],e.data.uri_params[t.toLowerCase()]=i&&i.toLowerCase()},function(t,i){t=t.join("").toLowerCase(),i=i.join(""),e.data.uri_headers||(e.data.uri_headers={}),e.data.uri_headers[t]?e.data.uri_headers[t].push(i):e.data.uri_headers[t]=[i]},function(){"Refer_To"===e.startRule&&(e.data.uri=new e.SIP.URI(e.data.scheme,e.data.user,e.data.host,e.data.port,e.data.uri_params,e.data.uri_headers),delete e.data.scheme,delete e.data.user,delete e.data.host,delete e.data.host_type,delete e.data.port,delete e.data.uri_params)},"//",n("//",!1),function(){e.data.scheme=i()},n("SIP",!0),function(){e.data.sip_version=i()},"INVITE",n("INVITE",!1),"ACK",n("ACK",!1),"VXACH",n("VXACH",!1),"OPTIONS",n("OPTIONS",!1),"BYE",n("BYE",!1),"CANCEL",n("CANCEL",!1),"REGISTER",n("REGISTER",!1),"SUBSCRIBE",n("SUBSCRIBE",!1),"NOTIFY",n("NOTIFY",!1),"REFER",n("REFER",!1),function(){return e.data.method=i(),e.data.method},function(t){e.data.status_code=parseInt(t.join(""))},function(){e.data.reason_phrase=i()},function(){e.data=i()},function(){var t,i;for(i=e.data.multi_header.length,t=0;t<i;t++)if(null===e.data.multi_header[t].parsed){e.data=null;break}null!==e.data?e.data=e.data.multi_header:e.data=-1},function(){var t;e.data.multi_header||(e.data.multi_header=[]);try{t=new e.SIP.NameAddrHeader(e.data.uri,e.data.displayName,e.data.params),delete e.data.uri,delete e.data.displayName,delete e.data.params}catch(e){t=null}e.data.multi_header.push({position:v,offset:s().start.offset,parsed:t})},function(t){t=i().trim(),'"'===t[0]&&(t=t.substring(1,t.length-1)),e.data.displayName=t},"q",n("q",!0),function(t){e.data.params||(e.data.params={}),e.data.params.q=t},"expires",n("expires",!0),function(t){e.data.params||(e.data.params={}),e.data.params.expires=t},function(t){return parseInt(t.join(""))},"0",n("0",!1),function(){return parseFloat(i())},function(t,i){e.data.params||(e.data.params={}),i=null===i?void 0:i[1],e.data.params[t.toLowerCase()]=i},"render",n("render",!0),"session",n("session",!0),"icon",n("icon",!0),"alert",n("alert",!0),function(){"Content_Disposition"===e.startRule&&(e.data.type=i().toLowerCase())},"handling",n("handling",!0),"optional",n("optional",!0),"required",n("required",!0),function(t){e.data=parseInt(t.join(""))},function(){e.data=i()},"text",n("text",!0),"image",n("image",!0),"audio",n("audio",!0),"video",n("video",!0),"application",n("application",!0),"message",n("message",!0),"multipart",n("multipart",!0),"x-",n("x-",!0),function(t){e.data.value=parseInt(t.join(""))},function(t){e.data=t},function(t){e.data.event=t.toLowerCase()},function(){var t=e.data.tag;e.data=new e.SIP.NameAddrHeader(e.data.uri,e.data.displayName,e.data.params),t&&e.data.setParam("tag",t)},"tag",n("tag",!0),function(t){e.data.tag=t},function(t){e.data=parseInt(t.join(""))},function(t){e.data=t},function(){e.data=new e.SIP.NameAddrHeader(e.data.uri,e.data.displayName,e.data.params)},"digest",n("Digest",!0),"realm",n("realm",!0),function(t){e.data.realm=t},"domain",n("domain",!0),"nonce",n("nonce",!0),function(t){e.data.nonce=t},"opaque",n("opaque",!0),function(t){e.data.opaque=t},"stale",n("stale",!0),"true",n("true",!0),function(){e.data.stale=!0},"false",n("false",!0),function(){e.data.stale=!1},"algorithm",n("algorithm",!0),"md5",n("MD5",!0),"md5-sess",n("MD5-sess",!0),function(t){e.data.algorithm=t.toUpperCase()},"qop",n("qop",!0),"auth-int",n("auth-int",!0),"auth",n("auth",!0),function(t){e.data.qop||(e.data.qop=[]),e.data.qop.push(t.toLowerCase())},function(t){e.data.value=parseInt(t.join(""))},function(){var t,i;for(i=e.data.multi_header.length,t=0;t<i;t++)if(null===e.data.multi_header[t].parsed){e.data=null;break}null!==e.data?e.data=e.data.multi_header:e.data=-1},function(){var t;e.data.multi_header||(e.data.multi_header=[]);try{t=new e.SIP.NameAddrHeader(e.data.uri,e.data.displayName,e.data.params),delete e.data.uri,delete e.data.displayName,delete e.data.params}catch(e){t=null}e.data.multi_header.push({position:v,offset:s().start.offset,parsed:t})},function(){e.data=new e.SIP.NameAddrHeader(e.data.uri,e.data.displayName,e.data.params)},function(){e.data.replaces_from_tag&&e.data.replaces_to_tag||(e.data=-1)},function(){e.data={call_id:e.data}},"from-tag",n("from-tag",!0),function(t){e.data.replaces_from_tag=t},"to-tag",n("to-tag",!0),function(t){e.data.replaces_to_tag=t},"early-only",n("early-only",!0),function(){e.data.early_only=!0},function(t,e){return e},function(t,e){return f(t,e)},function(t){"Require"===e.startRule&&(e.data=t||[])},function(t){e.data.value=parseInt(t.join(""))},"active",n("active",!0),"pending",n("pending",!0),"terminated",n("terminated",!0),function(){e.data.state=i()},"reason",n("reason",!0),function(t){void 0!==t&&(e.data.reason=t)},function(t){void 0!==t&&(e.data.expires=t)},"retry_after",n("retry_after",!0),function(t){void 0!==t&&(e.data.retry_after=t)},"deactivated",n("deactivated",!0),"probation",n("probation",!0),"rejected",n("rejected",!0),"timeout",n("timeout",!0),"giveup",n("giveup",!0),"noresource",n("noresource",!0),"invariant",n("invariant",!0),function(t){"Supported"===e.startRule&&(e.data=t||[])},function(){var t=e.data.tag;e.data=new e.SIP.NameAddrHeader(e.data.uri,e.data.displayName,e.data.params),t&&e.data.setParam("tag",t)},"ttl",n("ttl",!0),function(t){e.data.ttl=t},"maddr",n("maddr",!0),function(t){e.data.maddr=t},"received",n("received",!0),function(t){e.data.received=t},"branch",n("branch",!0),function(t){e.data.branch=t},"rport",n("rport",!0),function(){"undefined"!=typeof response_port&&(e.data.rport=response_port.join(""))},function(t){e.data.protocol=t},n("UDP",!0),n("TCP",!0),n("TLS",!0),n("SCTP",!0),function(t){e.data.transport=t},function(){e.data.host=i()},function(t){e.data.port=parseInt(t.join(""))},function(t){return parseInt(t.join(""))},function(t){"Session_Expires"===e.startRule&&(e.data.deltaSeconds=t)},"refresher",n("refresher",!1),"uas",n("uas",!1),"uac",n("uac",!1),function(t){"Session_Expires"===e.startRule&&(e.data.refresher=t)},function(t){"Min_SE"===e.startRule&&(e.data=t)},"stuns",n("stuns",!0),"stun",n("stun",!0),function(t){e.data.scheme=t},function(t){e.data.host=t},"?transport=",n("?transport=",!1),"turns",n("turns",!0),"turn",n("turn",!0),function(){e.data.transport=transport},function(){e.data=i()}],S=[d('2 ""6 7!'),d('4"""5!7#'),d('4$""5!7%'),d('4&""5!7\''),d(";'.# &;("),d('4(""5!7)'),d('4*""5!7+'),d('2,""6,7-'),d('2.""6.7/'),d('40""5!71'),d('22""6273.\x89 &24""6475.} &26""6677.q &28""6879.e &2:""6:7;.Y &2<""6<7=.M &2>""6>7?.A &2@""6@7A.5 &2B""6B7C.) &2D""6D7E'),d(";).# &;,"),d('2F""6F7G.} &2H""6H7I.q &2J""6J7K.e &2L""6L7M.Y &2N""6N7O.M &2P""6P7Q.A &2R""6R7S.5 &2T""6T7U.) &2V""6V7W'),d('%%2X""6X7Y/5#;#/,$;#/#$+#)(#\'#("\'#&\'#/"!&,)'),d('%%$;$0#*;$&/,#; /#$+")("\'#&\'#." &"/=#$;$/&#0#*;$&&&#/\'$8":Z" )("\'#&\'#'),d(';.." &"'),d("%$;'.# &;(0)*;'.# &;(&/?#28\"\"6879/0$;//'$8#:[# )(#'#(\"'#&'#"),d('%%$;2/&#0#*;2&&&#/g#$%$;.0#*;.&/,#;2/#$+")("\'#&\'#0=*%$;.0#*;.&/,#;2/#$+")("\'#&\'#&/#$+")("\'#&\'#/"!&,)'),d('4\\""5!7].# &;3'),d('4^""5!7_'),d('4`""5!7a'),d(';!.) &4b""5!7c'),d('%$;).\x95 &2F""6F7G.\x89 &2J""6J7K.} &2L""6L7M.q &2X""6X7Y.e &2P""6P7Q.Y &2H""6H7I.M &2@""6@7A.A &2d""6d7e.5 &2R""6R7S.) &2N""6N7O/\x9e#0\x9b*;).\x95 &2F""6F7G.\x89 &2J""6J7K.} &2L""6L7M.q &2X""6X7Y.e &2P""6P7Q.Y &2H""6H7I.M &2@""6@7A.A &2d""6d7e.5 &2R""6R7S.) &2N""6N7O&&&#/"!&,)'),d('%$;).\x89 &2F""6F7G.} &2L""6L7M.q &2X""6X7Y.e &2P""6P7Q.Y &2H""6H7I.M &2@""6@7A.A &2d""6d7e.5 &2R""6R7S.) &2N""6N7O/\x92#0\x8f*;).\x89 &2F""6F7G.} &2L""6L7M.q &2X""6X7Y.e &2P""6P7Q.Y &2H""6H7I.M &2@""6@7A.A &2d""6d7e.5 &2R""6R7S.) &2N""6N7O&&&#/"!&,)'),d('2T""6T7U.\xe3 &2V""6V7W.\xd7 &2f""6f7g.\xcb &2h""6h7i.\xbf &2:""6:7;.\xb3 &2D""6D7E.\xa7 &22""6273.\x9b &28""6879.\x8f &2j""6j7k.\x83 &;&.} &24""6475.q &2l""6l7m.e &2n""6n7o.Y &26""6677.M &2>""6>7?.A &2p""6p7q.5 &2r""6r7s.) &;\'.# &;('),d('%$;).\u012b &2F""6F7G.\u011f &2J""6J7K.\u0113 &2L""6L7M.\u0107 &2X""6X7Y.\xfb &2P""6P7Q.\xef &2H""6H7I.\xe3 &2@""6@7A.\xd7 &2d""6d7e.\xcb &2R""6R7S.\xbf &2N""6N7O.\xb3 &2T""6T7U.\xa7 &2V""6V7W.\x9b &2f""6f7g.\x8f &2h""6h7i.\x83 &28""6879.w &2j""6j7k.k &;&.e &24""6475.Y &2l""6l7m.M &2n""6n7o.A &26""6677.5 &2p""6p7q.) &2r""6r7s/\u0134#0\u0131*;).\u012b &2F""6F7G.\u011f &2J""6J7K.\u0113 &2L""6L7M.\u0107 &2X""6X7Y.\xfb &2P""6P7Q.\xef &2H""6H7I.\xe3 &2@""6@7A.\xd7 &2d""6d7e.\xcb &2R""6R7S.\xbf &2N""6N7O.\xb3 &2T""6T7U.\xa7 &2V""6V7W.\x9b &2f""6f7g.\x8f &2h""6h7i.\x83 &28""6879.w &2j""6j7k.k &;&.e &24""6475.Y &2l""6l7m.M &2n""6n7o.A &26""6677.5 &2p""6p7q.) &2r""6r7s&&&#/"!&,)'),d("%;//?#2P\"\"6P7Q/0$;//'$8#:t# )(#'#(\"'#&'#"),d("%;//?#24\"\"6475/0$;//'$8#:u# )(#'#(\"'#&'#"),d("%;//?#2>\"\"6>7?/0$;//'$8#:v# )(#'#(\"'#&'#"),d("%;//?#2T\"\"6T7U/0$;//'$8#:w# )(#'#(\"'#&'#"),d("%;//?#2V\"\"6V7W/0$;//'$8#:x# )(#'#(\"'#&'#"),d('%2h""6h7i/0#;//\'$8":y" )("\'#&\'#'),d('%;//6#2f""6f7g/\'$8":z" )("\'#&\'#'),d("%;//?#2D\"\"6D7E/0$;//'$8#:{# )(#'#(\"'#&'#"),d("%;//?#22\"\"6273/0$;//'$8#:|# )(#'#(\"'#&'#"),d("%;//?#28\"\"6879/0$;//'$8#:}# )(#'#(\"'#&'#"),d("%;//0#;&/'$8\":~\" )(\"'#&'#"),d("%;&/0#;//'$8\":~\" )(\"'#&'#"),d("%;=/T#$;G.) &;K.# &;F0/*;G.) &;K.# &;F&/,$;>/#$+#)(#'#(\"'#&'#"),d('4\x7f""5!7\x80.A &4\x81""5!7\x82.5 &4\x83""5!7\x84.) &;3.# &;.'),d("%%;//Q#;&/H$$;J.# &;K0)*;J.# &;K&/,$;&/#$+$)($'#(#'#(\"'#&'#/\"!&,)"),d("%;//]#;&/T$%$;J.# &;K0)*;J.# &;K&/\"!&,)/1$;&/($8$:\x85$!!)($'#(#'#(\"'#&'#"),d(';..G &2L""6L7M.; &4\x86""5!7\x87./ &4\x83""5!7\x84.# &;3'),d('%2j""6j7k/J#4\x88""5!7\x89.5 &4\x8a""5!7\x8b.) &4\x8c""5!7\x8d/#$+")("\'#&\'#'),d("%;N/M#28\"\"6879/>$;O.\" &\"/0$;S/'$8$:\x8e$ )($'#(#'#(\"'#&'#"),d("%;N/d#28\"\"6879/U$;O.\" &\"/G$;S/>$;_/5$;l.\" &\"/'$8&:\x8f& )(&'#(%'#($'#(#'#(\"'#&'#"),d('%3\x90""5$7\x91.) &3\x92""5#7\x93/\' 8!:\x94!! )'),d('%;P/]#%28""6879/,#;R/#$+")("\'#&\'#." &"/6$2:""6:7;/\'$8#:\x95# )(#\'#("\'#&\'#'),d("$;+.) &;-.# &;Q/2#0/*;+.) &;-.# &;Q&&&#"),d('2<""6<7=.q &2>""6>7?.e &2@""6@7A.Y &2B""6B7C.M &2D""6D7E.A &22""6273.5 &26""6677.) &24""6475'),d('%$;+._ &;-.Y &2<""6<7=.M &2>""6>7?.A &2@""6@7A.5 &2B""6B7C.) &2D""6D7E0e*;+._ &;-.Y &2<""6<7=.M &2>""6>7?.A &2@""6@7A.5 &2B""6B7C.) &2D""6D7E&/& 8!:\x96! )'),d('%;T/J#%28""6879/,#;^/#$+")("\'#&\'#." &"/#$+")("\'#&\'#'),d("%;U.) &;\\.# &;X/& 8!:\x97! )"),d('%$%;V/2#2J""6J7K/#$+")("\'#&\'#0<*%;V/2#2J""6J7K/#$+")("\'#&\'#&/D#;W/;$2J""6J7K." &"/\'$8#:\x98# )(#\'#("\'#&\'#'),d('$4\x99""5!7\x9a/,#0)*4\x99""5!7\x9a&&&#'),d('%4$""5!7%/?#$4\x9b""5!7\x9c0)*4\x9b""5!7\x9c&/#$+")("\'#&\'#'),d('%2l""6l7m/?#;Y/6$2n""6n7o/\'$8#:\x9d# )(#\'#("\'#&\'#'),d('%%;Z/\xb3#28""6879/\xa4$;Z/\x9b$28""6879/\x8c$;Z/\x83$28""6879/t$;Z/k$28""6879/\\$;Z/S$28""6879/D$;Z/;$28""6879/,$;[/#$+-)(-\'#(,\'#(+\'#(*\'#()\'#((\'#(\'\'#(&\'#(%\'#($\'#(#\'#("\'#&\'#.\u0790 &%2\x9e""6\x9e7\x9f/\xa4#;Z/\x9b$28""6879/\x8c$;Z/\x83$28""6879/t$;Z/k$28""6879/\\$;Z/S$28""6879/D$;Z/;$28""6879/,$;[/#$+,)(,\'#(+\'#(*\'#()\'#((\'#(\'\'#(&\'#(%\'#($\'#(#\'#("\'#&\'#.\u06f9 &%2\x9e""6\x9e7\x9f/\x8c#;Z/\x83$28""6879/t$;Z/k$28""6879/\\$;Z/S$28""6879/D$;Z/;$28""6879/,$;[/#$+*)(*\'#()\'#((\'#(\'\'#(&\'#(%\'#($\'#(#\'#("\'#&\'#.\u067a &%2\x9e""6\x9e7\x9f/t#;Z/k$28""6879/\\$;Z/S$28""6879/D$;Z/;$28""6879/,$;[/#$+()((\'#(\'\'#(&\'#(%\'#($\'#(#\'#("\'#&\'#.\u0613 &%2\x9e""6\x9e7\x9f/\\#;Z/S$28""6879/D$;Z/;$28""6879/,$;[/#$+&)(&\'#(%\'#($\'#(#\'#("\'#&\'#.\u05c4 &%2\x9e""6\x9e7\x9f/D#;Z/;$28""6879/,$;[/#$+$)($\'#(#\'#("\'#&\'#.\u058d &%2\x9e""6\x9e7\x9f/,#;[/#$+")("\'#&\'#.\u056e &%2\x9e""6\x9e7\x9f/,#;Z/#$+")("\'#&\'#.\u054f &%;Z/\x9b#2\x9e""6\x9e7\x9f/\x8c$;Z/\x83$28""6879/t$;Z/k$28""6879/\\$;Z/S$28""6879/D$;Z/;$28""6879/,$;[/#$++)(+\'#(*\'#()\'#((\'#(\'\'#(&\'#(%\'#($\'#(#\'#("\'#&\'#.\u04c7 &%;Z/\xaa#%28""6879/,#;Z/#$+")("\'#&\'#." &"/\x83$2\x9e""6\x9e7\x9f/t$;Z/k$28""6879/\\$;Z/S$28""6879/D$;Z/;$28""6879/,$;[/#$+*)(*\'#()\'#((\'#(\'\'#(&\'#(%\'#($\'#(#\'#("\'#&\'#.\u0430 &%;Z/\xb9#%28""6879/,#;Z/#$+")("\'#&\'#." &"/\x92$%28""6879/,#;Z/#$+")("\'#&\'#." &"/k$2\x9e""6\x9e7\x9f/\\$;Z/S$28""6879/D$;Z/;$28""6879/,$;[/#$+))()\'#((\'#(\'\'#(&\'#(%\'#($\'#(#\'#("\'#&\'#.\u038a &%;Z/\xc8#%28""6879/,#;Z/#$+")("\'#&\'#." &"/\xa1$%28""6879/,#;Z/#$+")("\'#&\'#." &"/z$%28""6879/,#;Z/#$+")("\'#&\'#." &"/S$2\x9e""6\x9e7\x9f/D$;Z/;$28""6879/,$;[/#$+()((\'#(\'\'#(&\'#(%\'#($\'#(#\'#("\'#&\'#.\u02d5 &%;Z/\xd7#%28""6879/,#;Z/#$+")("\'#&\'#." &"/\xb0$%28""6879/,#;Z/#$+")("\'#&\'#." &"/\x89$%28""6879/,#;Z/#$+")("\'#&\'#." &"/b$%28""6879/,#;Z/#$+")("\'#&\'#." &"/;$2\x9e""6\x9e7\x9f/,$;[/#$+\')(\'\'#(&\'#(%\'#($\'#(#\'#("\'#&\'#.\u0211 &%;Z/\xfe#%28""6879/,#;Z/#$+")("\'#&\'#." &"/\xd7$%28""6879/,#;Z/#$+")("\'#&\'#." &"/\xb0$%28""6879/,#;Z/#$+")("\'#&\'#." &"/\x89$%28""6879/,#;Z/#$+")("\'#&\'#." &"/b$%28""6879/,#;Z/#$+")("\'#&\'#." &"/;$2\x9e""6\x9e7\x9f/,$;Z/#$+()((\'#(\'\'#(&\'#(%\'#($\'#(#\'#("\'#&\'#.\u0126 &%;Z/\u011c#%28""6879/,#;Z/#$+")("\'#&\'#." &"/\xf5$%28""6879/,#;Z/#$+")("\'#&\'#." &"/\xce$%28""6879/,#;Z/#$+")("\'#&\'#." &"/\xa7$%28""6879/,#;Z/#$+")("\'#&\'#." &"/\x80$%28""6879/,#;Z/#$+")("\'#&\'#." &"/Y$%28""6879/,#;Z/#$+")("\'#&\'#." &"/2$2\x9e""6\x9e7\x9f/#$+()((\'#(\'\'#(&\'#(%\'#($\'#(#\'#("\'#&\'#/& 8!:\xa0! )'),d('%;#/M#;#." &"/?$;#." &"/1$;#." &"/#$+$)($\'#(#\'#("\'#&\'#'),d("%;Z/;#28\"\"6879/,$;Z/#$+#)(#'#(\"'#&'#.# &;\\"),d("%;]/o#2J\"\"6J7K/`$;]/W$2J\"\"6J7K/H$;]/?$2J\"\"6J7K/0$;]/'$8':\xa1' )(''#(&'#(%'#($'#(#'#(\"'#&'#"),d('%2\xa2""6\xa27\xa3/2#4\xa4""5!7\xa5/#$+")("\'#&\'#.\x98 &%2\xa6""6\xa67\xa7/;#4\xa8""5!7\xa9/,$;!/#$+#)(#\'#("\'#&\'#.j &%2\xaa""6\xaa7\xab/5#;!/,$;!/#$+#)(#\'#("\'#&\'#.B &%4\xac""5!7\xad/,#;!/#$+")("\'#&\'#.# &;!'),d('%%;!." &"/[#;!." &"/M$;!." &"/?$;!." &"/1$;!." &"/#$+%)(%\'#($\'#(#\'#("\'#&\'#/\' 8!:\xae!! )'),d('$%22""6273/,#;`/#$+")("\'#&\'#0<*%22""6273/,#;`/#$+")("\'#&\'#&'),d(";a.A &;b.; &;c.5 &;d./ &;e.) &;f.# &;g"),d('%3\xaf""5*7\xb0/a#3\xb1""5#7\xb2.G &3\xb3""5#7\xb4.; &3\xb5""5$7\xb6./ &3\xb7""5#7\xb8.# &;6/($8":\xb9"! )("\'#&\'#'),d('%3\xba""5%7\xbb/I#3\xbc""5%7\xbd./ &3\xbe""5"7\xbf.# &;6/($8":\xc0"! )("\'#&\'#'),d('%3\xc1""5\'7\xc2/1#;\x8f/($8":\xc3"! )("\'#&\'#'),d('%3\xc4""5$7\xc5/1#;\xef/($8":\xc6"! )("\'#&\'#'),d('%3\xc7""5&7\xc8/1#;T/($8":\xc9"! )("\'#&\'#'),d('%3\xca""5"7\xcb/N#%2>""6>7?/,#;6/#$+")("\'#&\'#." &"/\'$8":\xcc" )("\'#&\'#'),d('%;h/P#%2>""6>7?/,#;i/#$+")("\'#&\'#." &"/)$8":\xcd""! )("\'#&\'#'),d('%$;j/&#0#*;j&&&#/"!&,)'),d('%$;j/&#0#*;j&&&#/"!&,)'),d(";k.) &;+.# &;-"),d('2l""6l7m.e &2n""6n7o.Y &24""6475.M &28""6879.A &2<""6<7=.5 &2@""6@7A.) &2B""6B7C'),d('%26""6677/n#;m/e$$%2<""6<7=/,#;m/#$+")("\'#&\'#0<*%2<""6<7=/,#;m/#$+")("\'#&\'#&/#$+#)(#\'#("\'#&\'#'),d('%;n/A#2>""6>7?/2$;o/)$8#:\xce#"" )(#\'#("\'#&\'#'),d("$;p.) &;+.# &;-/2#0/*;p.) &;+.# &;-&&&#"),d("$;p.) &;+.# &;-0/*;p.) &;+.# &;-&"),d('2l""6l7m.e &2n""6n7o.Y &24""6475.M &26""6677.A &28""6879.5 &2@""6@7A.) &2B""6B7C'),d(";\x90.# &;r"),d("%;\x8f/G#;'/>$;s/5$;'/,$;\x84/#$+%)(%'#($'#(#'#(\"'#&'#"),d(";M.# &;t"),d("%;\x7f/E#28\"\"6879/6$;u.# &;x/'$8#:\xcf# )(#'#(\"'#&'#"),d('%;v.# &;w/J#%26""6677/,#;\x83/#$+")("\'#&\'#." &"/#$+")("\'#&\'#'),d('%2\xd0""6\xd07\xd1/:#;\x80/1$;w." &"/#$+#)(#\'#("\'#&\'#'),d('%24""6475/,#;{/#$+")("\'#&\'#'),d("%;z/3#$;y0#*;y&/#$+\")(\"'#&'#"),d(";*.) &;+.# &;-"),d(';+.\x8f &;-.\x89 &22""6273.} &26""6677.q &28""6879.e &2:""6:7;.Y &2<""6<7=.M &2>""6>7?.A &2@""6@7A.5 &2B""6B7C.) &2D""6D7E'),d('%;|/e#$%24""6475/,#;|/#$+")("\'#&\'#0<*%24""6475/,#;|/#$+")("\'#&\'#&/#$+")("\'#&\'#'),d('%$;~0#*;~&/e#$%22""6273/,#;}/#$+")("\'#&\'#0<*%22""6273/,#;}/#$+")("\'#&\'#&/#$+")("\'#&\'#'),d("$;~0#*;~&"),d(';+.w &;-.q &28""6879.e &2:""6:7;.Y &2<""6<7=.M &2>""6>7?.A &2@""6@7A.5 &2B""6B7C.) &2D""6D7E'),d('%%;"/\x87#$;".G &;!.A &2@""6@7A.5 &2F""6F7G.) &2J""6J7K0M*;".G &;!.A &2@""6@7A.5 &2F""6F7G.) &2J""6J7K&/#$+")("\'#&\'#/& 8!:\xd2! )'),d(";\x81.# &;\x82"),d('%%;O/2#2:""6:7;/#$+")("\'#&\'#." &"/,#;S/#$+")("\'#&\'#." &"'),d('$;+.\x83 &;-.} &2B""6B7C.q &2D""6D7E.e &22""6273.Y &28""6879.M &2:""6:7;.A &2<""6<7=.5 &2>""6>7?.) &2@""6@7A/\x8c#0\x89*;+.\x83 &;-.} &2B""6B7C.q &2D""6D7E.e &22""6273.Y &28""6879.M &2:""6:7;.A &2<""6<7=.5 &2>""6>7?.) &2@""6@7A&&&#'),d("$;y0#*;y&"),d('%3\x92""5#7\xd3/q#24""6475/b$$;!/&#0#*;!&&&#/L$2J""6J7K/=$$;!/&#0#*;!&&&#/\'$8%:\xd4% )(%\'#($\'#(#\'#("\'#&\'#'),d('2\xd5""6\xd57\xd6'),d('2\xd7""6\xd77\xd8'),d('2\xd9""6\xd97\xda'),d('2\xdb""6\xdb7\xdc'),d('2\xdd""6\xdd7\xde'),d('2\xdf""6\xdf7\xe0'),d('2\xe1""6\xe17\xe2'),d('2\xe3""6\xe37\xe4'),d('2\xe5""6\xe57\xe6'),d('2\xe7""6\xe77\xe8'),d("%;\x85.S &;\x86.M &;\x88.G &;\x89.A &;\x8a.; &;\x8b.5 &;\x8c./ &;\x8d.) &;\x8e.# &;6/& 8!:\xe9! )"),d("%;\x84/G#;'/>$;\x91/5$;'/,$;\x93/#$+%)(%'#($'#(#'#(\"'#&'#"),d("%;\x92/' 8!:\xea!! )"),d("%;!/5#;!/,$;!/#$+#)(#'#(\"'#&'#"),d("%$;*.A &;+.; &;-.5 &;3./ &;4.) &;'.# &;(0G*;*.A &;+.; &;-.5 &;3./ &;4.) &;'.# &;(&/& 8!:\xeb! )"),d("%;\xb5/Y#$%;A/,#;\xb5/#$+\")(\"'#&'#06*%;A/,#;\xb5/#$+\")(\"'#&'#&/#$+\")(\"'#&'#"),d('%;9/N#%2:""6:7;/,#;9/#$+")("\'#&\'#." &"/\'$8":\xec" )("\'#&\'#'),d("%;:.c &%;\x97/Y#$%;A/,#;\x97/#$+\")(\"'#&'#06*%;A/,#;\x97/#$+\")(\"'#&'#&/#$+\")(\"'#&'#/& 8!:\xed! )"),d("%;L.# &;\x98/]#$%;B/,#;\x9a/#$+\")(\"'#&'#06*%;B/,#;\x9a/#$+\")(\"'#&'#&/'$8\":\xee\" )(\"'#&'#"),d("%;\x99.\" &\"/>#;@/5$;M/,$;?/#$+$)($'#(#'#(\"'#&'#"),d("%%;6/Y#$%;./,#;6/#$+\")(\"'#&'#06*%;./,#;6/#$+\")(\"'#&'#&/#$+\")(\"'#&'#.# &;H/' 8!:\xef!! )"),d(";\x9b.) &;\x9c.# &;\x9f"),d("%3\xf0\"\"5!7\xf1/:#;</1$;\x9e/($8#:\xf2#! )(#'#(\"'#&'#"),d("%3\xf3\"\"5'7\xf4/:#;</1$;\x9d/($8#:\xf5#! )(#'#(\"'#&'#"),d("%$;!/&#0#*;!&&&#/' 8!:\xf6!! )"),d('%2\xf7""6\xf77\xf8/o#%2J""6J7K/M#;!." &"/?$;!." &"/1$;!." &"/#$+$)($\'#(#\'#("\'#&\'#." &"/\'$8":\xf9" )("\'#&\'#'),d('%;6/J#%;</,#;\xa0/#$+")("\'#&\'#." &"/)$8":\xfa""! )("\'#&\'#'),d(";6.) &;T.# &;H"),d("%;\xa2/Y#$%;B/,#;\xa3/#$+\")(\"'#&'#06*%;B/,#;\xa3/#$+\")(\"'#&'#&/#$+\")(\"'#&'#"),d('%3\xfb""5&7\xfc.G &3\xfd""5\'7\xfe.; &3\xff""5$7\u0100./ &3\u0101""5%7\u0102.# &;6/& 8!:\u0103! )'),d(";\xa4.# &;\x9f"),d('%3\u0104""5(7\u0105/M#;</D$3\u0106""5(7\u0107./ &3\u0108""5(7\u0109.# &;6/#$+#)(#\'#("\'#&\'#'),d("%;6/Y#$%;A/,#;6/#$+\")(\"'#&'#06*%;A/,#;6/#$+\")(\"'#&'#&/#$+\")(\"'#&'#"),d("%$;!/&#0#*;!&&&#/' 8!:\u010a!! )"),d("%;\xa8/& 8!:\u010b! )"),d("%;\xa9/k#;;/b$;\xae/Y$$%;B/,#;\xaf/#$+\")(\"'#&'#06*%;B/,#;\xaf/#$+\")(\"'#&'#&/#$+$)($'#(#'#(\"'#&'#"),d(";\xaa.# &;\xab"),d('3\u010c""5$7\u010d.S &3\u010e""5%7\u010f.G &3\u0110""5%7\u0111.; &3\u0112""5%7\u0113./ &3\u0114""5+7\u0115.# &;\xac'),d('3\u0116""5\'7\u0117./ &3\u0118""5)7\u0119.# &;\xac'),d(";6.# &;\xad"),d('%3\u011a""5"7\u011b/,#;6/#$+")("\'#&\'#'),d(";\xac.# &;6"),d("%;6/5#;</,$;\xb0/#$+#)(#'#(\"'#&'#"),d(";6.# &;H"),d("%;\xb2/5#;./,$;\x8f/#$+#)(#'#(\"'#&'#"),d("%$;!/&#0#*;!&&&#/' 8!:\u011c!! )"),d("%;\x9d/' 8!:\u011d!! )"),d('%;\xb5/^#$%;B/,#;\x9f/#$+")("\'#&\'#06*%;B/,#;\x9f/#$+")("\'#&\'#&/($8":\u011e"!!)("\'#&\'#'),d('%%;7/e#$%2J""6J7K/,#;7/#$+")("\'#&\'#0<*%2J""6J7K/,#;7/#$+")("\'#&\'#&/#$+")("\'#&\'#/"!&,)'),d("%;L.# &;\x98/]#$%;B/,#;\xb7/#$+\")(\"'#&'#06*%;B/,#;\xb7/#$+\")(\"'#&'#&/'$8\":\u011f\" )(\"'#&'#"),d(";\xb8.# &;\x9f"),d("%3\u0120\"\"5#7\u0121/:#;</1$;6/($8#:\u0122#! )(#'#(\"'#&'#"),d("%$;!/&#0#*;!&&&#/' 8!:\u0123!! )"),d("%;\x9d/' 8!:\u0124!! )"),d("%$;\x990#*;\x99&/x#;@/o$;M/f$;?/]$$%;B/,#;\x9f/#$+\")(\"'#&'#06*%;B/,#;\x9f/#$+\")(\"'#&'#&/'$8%:\u0125% )(%'#($'#(#'#(\"'#&'#"),d(";\xbd"),d("%3\u0126\"\"5&7\u0127/k#;./b$;\xc0/Y$$%;A/,#;\xc0/#$+\")(\"'#&'#06*%;A/,#;\xc0/#$+\")(\"'#&'#&/#$+$)($'#(#'#(\"'#&'#.# &;\xbe"),d("%;6/k#;./b$;\xbf/Y$$%;A/,#;\xbf/#$+\")(\"'#&'#06*%;A/,#;\xbf/#$+\")(\"'#&'#&/#$+$)($'#(#'#(\"'#&'#"),d("%;6/;#;</2$;6.# &;H/#$+#)(#'#(\"'#&'#"),d(";\xc1.G &;\xc3.A &;\xc5.; &;\xc7.5 &;\xc8./ &;\xc9.) &;\xca.# &;\xbf"),d("%3\u0128\"\"5%7\u0129/5#;</,$;\xc2/#$+#)(#'#(\"'#&'#"),d("%;I/' 8!:\u012a!! )"),d("%3\u012b\"\"5&7\u012c/\x97#;</\x8e$;D/\x85$;\xc4/|$$%$;'/&#0#*;'&&&#/,#;\xc4/#$+\")(\"'#&'#0C*%$;'/&#0#*;'&&&#/,#;\xc4/#$+\")(\"'#&'#&/,$;E/#$+&)(&'#(%'#($'#(#'#(\"'#&'#"),d(";t.# &;w"),d("%3\u012d\"\"5%7\u012e/5#;</,$;\xc6/#$+#)(#'#(\"'#&'#"),d("%;I/' 8!:\u012f!! )"),d("%3\u0130\"\"5&7\u0131/:#;</1$;I/($8#:\u0132#! )(#'#(\"'#&'#"),d('%3\u0133""5%7\u0134/]#;</T$%3\u0135""5$7\u0136/& 8!:\u0137! ).4 &%3\u0138""5%7\u0139/& 8!:\u013a! )/#$+#)(#\'#("\'#&\'#'),d('%3\u013b""5)7\u013c/R#;</I$3\u013d""5#7\u013e./ &3\u013f""5(7\u0140.# &;6/($8#:\u0141#! )(#\'#("\'#&\'#'),d('%3\u0142""5#7\u0143/\x93#;</\x8a$;D/\x81$%;\xcb/e#$%2D""6D7E/,#;\xcb/#$+")("\'#&\'#0<*%2D""6D7E/,#;\xcb/#$+")("\'#&\'#&/#$+")("\'#&\'#/,$;E/#$+%)(%\'#($\'#(#\'#("\'#&\'#'),d('%3\u0144""5(7\u0145./ &3\u0146""5$7\u0147.# &;6/\' 8!:\u0148!! )'),d("%;6/Y#$%;A/,#;6/#$+\")(\"'#&'#06*%;A/,#;6/#$+\")(\"'#&'#&/#$+\")(\"'#&'#"),d("%;\xce/G#;./>$;\xce/5$;./,$;\x8f/#$+%)(%'#($'#(#'#(\"'#&'#"),d("%$;!/&#0#*;!&&&#/' 8!:\u0149!! )"),d("%;\xd0/]#$%;A/,#;\xd0/#$+\")(\"'#&'#06*%;A/,#;\xd0/#$+\")(\"'#&'#&/'$8\":\u014a\" )(\"'#&'#"),d("%;\x98/]#$%;B/,#;\x9f/#$+\")(\"'#&'#06*%;B/,#;\x9f/#$+\")(\"'#&'#&/'$8\":\u014b\" )(\"'#&'#"),d('%;L.O &;\x98.I &%;@." &"/:#;t/1$;?." &"/#$+#)(#\'#("\'#&\'#/]#$%;B/,#;\x9f/#$+")("\'#&\'#06*%;B/,#;\x9f/#$+")("\'#&\'#&/\'$8":\u014c" )("\'#&\'#'),d("%;\xd3/]#$%;B/,#;\xd4/#$+\")(\"'#&'#06*%;B/,#;\xd4/#$+\")(\"'#&'#&/'$8\":\u014d\" )(\"'#&'#"),d("%;\x95/& 8!:\u014e! )"),d('%3\u014f""5(7\u0150/:#;</1$;6/($8#:\u0151#! )(#\'#("\'#&\'#.g &%3\u0152""5&7\u0153/:#;</1$;6/($8#:\u0154#! )(#\'#("\'#&\'#.: &%3\u0155""5*7\u0156/& 8!:\u0157! ).# &;\x9f'),d('%%;6/k#$%;A/2#;6/)$8":\u0158""$ )("\'#&\'#0<*%;A/2#;6/)$8":\u0158""$ )("\'#&\'#&/)$8":\u0159""! )("\'#&\'#." &"/\' 8!:\u015a!! )'),d("%;\xd7/Y#$%;A/,#;\xd7/#$+\")(\"'#&'#06*%;A/,#;\xd7/#$+\")(\"'#&'#&/#$+\")(\"'#&'#"),d("%;\x98/Y#$%;B/,#;\x9f/#$+\")(\"'#&'#06*%;B/,#;\x9f/#$+\")(\"'#&'#&/#$+\")(\"'#&'#"),d("%$;!/&#0#*;!&&&#/' 8!:\u015b!! )"),d("%;\xda/Y#$%;B/,#;\xdb/#$+\")(\"'#&'#06*%;B/,#;\xdb/#$+\")(\"'#&'#&/#$+\")(\"'#&'#"),d('%3\u015c""5&7\u015d.; &3\u015e""5\'7\u015f./ &3\u0160""5*7\u0161.# &;6/& 8!:\u0162! )'),d("%3\u0163\"\"5&7\u0164/:#;</1$;\xdc/($8#:\u0165#! )(#'#(\"'#&'#.} &%3\xf3\"\"5'7\xf4/:#;</1$;\x9d/($8#:\u0166#! )(#'#(\"'#&'#.P &%3\u0167\"\"5+7\u0168/:#;</1$;\x9d/($8#:\u0169#! )(#'#(\"'#&'#.# &;\x9f"),d('3\u016a""5+7\u016b.k &3\u016c""5)7\u016d._ &3\u016e""5(7\u016f.S &3\u0170""5\'7\u0171.G &3\u0172""5&7\u0173.; &3\u0174""5*7\u0175./ &3\u0176""5)7\u0177.# &;6'),d(';1." &"'),d('%%;6/k#$%;A/2#;6/)$8":\u0158""$ )("\'#&\'#0<*%;A/2#;6/)$8":\u0158""$ )("\'#&\'#&/)$8":\u0159""! )("\'#&\'#." &"/\' 8!:\u0178!! )'),d("%;L.# &;\x98/]#$%;B/,#;\xe0/#$+\")(\"'#&'#06*%;B/,#;\xe0/#$+\")(\"'#&'#&/'$8\":\u0179\" )(\"'#&'#"),d(";\xb8.# &;\x9f"),d("%;\xe2/Y#$%;A/,#;\xe2/#$+\")(\"'#&'#06*%;A/,#;\xe2/#$+\")(\"'#&'#&/#$+\")(\"'#&'#"),d("%;\xe9/k#;./b$;\xec/Y$$%;B/,#;\xe3/#$+\")(\"'#&'#06*%;B/,#;\xe3/#$+\")(\"'#&'#&/#$+$)($'#(#'#(\"'#&'#"),d(";\xe4.; &;\xe5.5 &;\xe6./ &;\xe7.) &;\xe8.# &;\x9f"),d("%3\u017a\"\"5#7\u017b/:#;</1$;\xef/($8#:\u017c#! )(#'#(\"'#&'#"),d("%3\u017d\"\"5%7\u017e/:#;</1$;T/($8#:\u017f#! )(#'#(\"'#&'#"),d("%3\u0180\"\"5(7\u0181/@#;</7$;\\.# &;Y/($8#:\u0182#! )(#'#(\"'#&'#"),d("%3\u0183\"\"5&7\u0184/:#;</1$;6/($8#:\u0185#! )(#'#(\"'#&'#"),d('%3\u0186""5%7\u0187/O#%;</3#$;!0#*;!&/#$+")("\'#&\'#." &"/\'$8":\u0188" )("\'#&\'#'),d("%;\xea/G#;;/>$;6/5$;;/,$;\xeb/#$+%)(%'#($'#(#'#(\"'#&'#"),d('%3\x92""5#7\xd3.# &;6/\' 8!:\u0189!! )'),d('%3\xb1""5#7\u018a.G &3\xb3""5#7\u018b.; &3\xb7""5#7\u018c./ &3\xb5""5$7\u018d.# &;6/\' 8!:\u018e!! )'),d('%;\xed/D#%;C/,#;\xee/#$+")("\'#&\'#." &"/#$+")("\'#&\'#'),d("%;U.) &;\\.# &;X/& 8!:\u018f! )"),d('%%;!." &"/[#;!." &"/M$;!." &"/?$;!." &"/1$;!." &"/#$+%)(%\'#($\'#(#\'#("\'#&\'#/\' 8!:\u0190!! )'),d('%%;!/?#;!." &"/1$;!." &"/#$+#)(#\'#("\'#&\'#/\' 8!:\u0191!! )'),d(";\xbd"),d('%;\x9d/^#$%;B/,#;\xf2/#$+")("\'#&\'#06*%;B/,#;\xf2/#$+")("\'#&\'#&/($8":\u0192"!!)("\'#&\'#'),d(";\xf3.# &;\x9f"),d('%2\u0193""6\u01937\u0194/L#;</C$2\u0195""6\u01957\u0196.) &2\u0197""6\u01977\u0198/($8#:\u0199#! )(#\'#("\'#&\'#'),d('%;\x9d/^#$%;B/,#;\x9f/#$+")("\'#&\'#06*%;B/,#;\x9f/#$+")("\'#&\'#&/($8":\u019a"!!)("\'#&\'#'),d("%;6/5#;0/,$;\xf6/#$+#)(#'#(\"'#&'#"),d("$;2.) &;4.# &;.0/*;2.) &;4.# &;.&"),d("$;%0#*;%&"),d("%;\xf9/;#28\"\"6879/,$;\xfa/#$+#)(#'#(\"'#&'#"),d('%3\u019b""5%7\u019c.) &3\u019d""5$7\u019e/\' 8!:\u019f!! )'),d('%;\xfb/J#%28""6879/,#;^/#$+")("\'#&\'#." &"/#$+")("\'#&\'#'),d("%;\\.) &;X.# &;\x82/' 8!:\u01a0!! )"),d(';".S &;!.M &2F""6F7G.A &2J""6J7K.5 &2H""6H7I.) &2N""6N7O'),d('2L""6L7M.\x95 &2B""6B7C.\x89 &2<""6<7=.} &2R""6R7S.q &2T""6T7U.e &2V""6V7W.Y &2P""6P7Q.M &2@""6@7A.A &2D""6D7E.5 &22""6273.) &2>""6>7?'),d('%;\xff/b#28""6879/S$;\xfa/J$%2\u01a1""6\u01a17\u01a2/,#;\xeb/#$+")("\'#&\'#." &"/#$+$)($\'#(#\'#("\'#&\'#'),d('%3\u01a3""5%7\u01a4.) &3\u01a5""5$7\u01a6/\' 8!:\u019f!! )'),d('%;\xeb/O#3\xb1""5#7\xb2.6 &3\xb3""5#7\xb4.* &$;+0#*;+&/\'$8":\u01a7" )("\'#&\'#'),d("%;\u0103/\x87#2F\"\"6F7G/x$;\u0102/o$2F\"\"6F7G/`$;\u0102/W$2F\"\"6F7G/H$;\u0102/?$2F\"\"6F7G/0$;\u0104/'$8):\u01a8) )()'#(('#(''#(&'#(%'#($'#(#'#(\"'#&'#"),d("%;#/>#;#/5$;#/,$;#/#$+$)($'#(#'#(\"'#&'#"),d("%;\u0102/,#;\u0102/#$+\")(\"'#&'#"),d("%;\u0102/5#;\u0102/,$;\u0102/#$+#)(#'#(\"'#&'#")],v=0,C=0,R=[{line:1,column:1}],A=0,y=[],I=0;if("startRule"in e){if(!(e.startRule in m))throw new Error("Can't start parsing from rule \""+e.startRule+'".');_=m[e.startRule]}if(e.data={},(g=p(_))!==T&&v===t.length)return g;throw g!==T&&v<t.length&&u(function(){return{type:"end"}}()),l(y,A<t.length?t.charAt(A):null,A<t.length?h(A,A+1):h(A,A))}!function(t,e){function i(){this.constructor=t}i.prototype=e.prototype,t.prototype=new i}(r,Error),r.buildMessage=function(t,e){function i(t){return t.charCodeAt(0).toString(16).toUpperCase()}function r(t){return t.replace(/\\/g,"\\\\").replace(/"/g,'\\"').replace(/\0/g,"\\0").replace(/\t/g,"\\t").replace(/\n/g,"\\n").replace(/\r/g,"\\r").replace(/[\x00-\x0F]/g,function(t){return"\\x0"+i(t)}).replace(/[\x10-\x1F\x7F-\x9F]/g,function(t){return"\\x"+i(t)})}function s(t){return t.replace(/\\/g,"\\\\").replace(/\]/g,"\\]").replace(/\^/g,"\\^").replace(/-/g,"\\-").replace(/\0/g,"\\0").replace(/\t/g,"\\t").replace(/\n/g,"\\n").replace(/\r/g,"\\r").replace(/[\x00-\x0F]/g,function(t){return"\\x0"+i(t)}).replace(/[\x10-\x1F\x7F-\x9F]/g,function(t){return"\\x"+i(t)})}function n(t){return o[t.type](t)}var o={literal:function(t){return'"'+r(t.text)+'"'},class:function(t){var e,i="";for(e=0;e<t.parts.length;e++)i+=t.parts[e]instanceof Array?s(t.parts[e][0])+"-"+s(t.parts[e][1]):s(t.parts[e]);return"["+(t.inverted?"^":"")+i+"]"},any:function(t){return"any character"},end:function(t){return"end of input"},other:function(t){return t.description}};return"Expected "+function(t){var e,i,r=new Array(t.length);for(e=0;e<t.length;e++)r[e]=n(t[e]);if(r.sort(),r.length>0){for(e=1,i=1;e<r.length;e++)r[e-1]!==r[e]&&(r[i]=r[e],i++);r.length=i}switch(r.length){case 1:return r[0];case 2:return r[0]+" or "+r[1];default:return r.slice(0,-1).join(", ")+", or "+r[r.length-1]}}(t)+" but "+function(t){return t?'"'+r(t)+'"':"end of input"}(e)+" found."},t.exports={SyntaxError:r,parse:s}},function(t,e,i){"use strict";t.exports=function(t){return{stripTcpCandidates:function(e){return e.sdp=e.sdp.replace(/^a=candidate:\d+ \d+ tcp .*?\r\n/gim,""),t.Utils.Promise.resolve(e)},stripTelephoneEvent:function(e){return e.sdp=e.sdp.replace(/^a=rtpmap:\d+ telephone-event\/d+/gim,""),t.Utils.Promise.resolve(e)},cleanJitsiSdpImageattr:function(e){return e.sdp=e.sdp.replace(/^(a=imageattr:.*?)(x|y)=\[0-/gm,"$1$2=[1:"),t.Utils.Promise.resolve(e)},stripG722:function(e){var i=e.sdp.match(/^m=audio.*$/gm)[0];i=i.split(" ");for(var r=3;r<i.length;r+=1)if("9"===i[r]){i.splice(r,1);var s=parseInt(i[1],10);s-=1,i[1]=s.toString()}return i=i.join(" "),e.sdp=e.sdp.replace(/^m=audio.*$/gm,i),e.sdp=e.sdp.replace(/^a=rtpmap:.*G722\/8000\r\n?/gm,"").replace(),t.Utils.Promise.resolve(e)}}}},function(t,e,i){"use strict";(function(e){t.exports=function(t){var i={STATUS_NULL:0,STATUS_NEW:1,STATUS_CONNECTING:2,STATUS_CONNECTED:3,STATUS_COMPLETED:4},r=function(r){if(r.media.remote.video?this.video=!0:this.video=!1,r.media.remote.audio?this.audio=!0:this.audio=!1,!this.audio&&!this.video)return void this.logger.error("At least one remote audio or video element is required for Simple.");this.options=r;var s=e.navigator.userAgent.toLowerCase(),n=!1;s.indexOf("safari")>-1&&s.indexOf("chrome")<0&&(n=!0);var o={};return n&&(o.modifiers=[t.WebRTC.Modifiers.stripG722]),this.ua=new t.UA({wsServers:this.options.ua.wsServers,uri:this.options.ua.uri,authorizationUser:this.options.ua.authorizationUser,password:this.options.ua.password,displayName:this.options.ua.displayName,traceSip:this.options.ua.traceSip,userAgentString:this.options.ua.userAgentString,register:!0,sessionDescriptionHandlerFactoryOptions:o}),this.state=i.STATUS_NULL,this.logger=this.ua.getLogger("sip.simple"),this.ua.on("registered",function(){this.emit("registered",this.ua)}.bind(this)),this.ua.on("unregistered",function(){this.emit("unregistered",this.ua)}.bind(this)),this.ua.on("failed",function(){this.emit("unregistered",this.ua)}.bind(this)),this.ua.on("invite",function(t){if(this.state!==i.STATUS_NULL&&this.state!==i.STATUS_COMPLETED)return this.logger.warn("Rejecting incoming call. Simple only supports 1 call at a time"),void t.reject();this.session=t,this.setupSession(),this.emit("ringing",this.session)}.bind(this)),this.ua.on("message",function(t){this.emit("message",t)}.bind(this)),this};return r.prototype=Object.create(t.EventEmitter.prototype),r.C=i,r.prototype.call=function(t){return this.ua&&this.ua.isRegistered()?this.state!==i.STATUS_NULL&&this.state!==i.STATUS_COMPLETED?void this.logger.warn("Cannot make more than a single call with Simple"):(this.options.media.remote.audio&&(this.options.media.remote.audio.autoplay=!0),this.options.media.remote.video&&(this.options.media.remote.video.autoplay=!0),this.options.media.local&&this.options.media.local.video&&(this.options.media.local.video.autoplay=!0,this.options.media.local.video.volume=0),this.session=this.ua.invite(t,{sessionDescriptionHandlerOptions:{constraints:{audio:this.audio,video:this.video}}}),this.setupSession(),this.session):void this.logger.warn("A registered UA is required for calling")},r.prototype.answer=function(){return this.state!==i.STATUS_NEW&&this.state!==i.STATUS_CONNECTING?void this.logger.warn("No call to answer"):(this.options.media.remote.audio&&(this.options.media.remote.audio.autoplay=!0),this.options.media.remote.video&&(this.options.media.remote.video.autoplay=!0),this.session.accept({sessionDescriptionHandlerOptions:{constraints:{audio:this.audio,video:this.video}}}))},r.prototype.reject=function(){return this.state!==i.STATUS_NEW&&this.state!==i.STATUS_CONNECTING?void this.logger.warn("Call is already answered"):this.session.reject()},r.prototype.hangup=function(){return this.state!==i.STATUS_CONNECTED&&this.state!==i.STATUS_CONNECTING&&this.state!==i.STATUS_NEW?void this.logger.warn("No active call to hang up on"):this.state!==i.STATUS_CONNECTED?this.session.cancel():this.session.bye()},r.prototype.hold=function(){return this.state!==i.STATUS_CONNECTED||this.session.isOnHold().local?void this.logger.warn("Cannot put call on hold"):(this.mute(),this.logger.log("Placing session on hold"),this.session.hold())},r.prototype.unhold=function(){return this.state===i.STATUS_CONNECTED&&this.session.isOnHold().local?(this.unmute(),this.logger.log("Placing call off hold"),this.session.unhold()):void this.logger.warn("Cannot unhold a call that is not on hold")},r.prototype.mute=function(){if(this.state!==i.STATUS_CONNECTED)return void this.logger.warn("An acitve call is required to mute audio");this.logger.log("Muting Audio"),this.toggleMute(!0)},r.prototype.unmute=function(){if(this.state!==i.STATUS_CONNECTED)return void this.logger.warn("An active call is required to unmute audio");this.logger.log("Unmuting Audio"),this.toggleMute(!1)},r.prototype.sendDTMF=function(t){if(this.state!==i.STATUS_CONNECTED)return void this.logger.warn("An active call is required to send a DTMF tone");this.logger.log("Sending DTMF tone: "+t),this.session.dtmf(t)},r.prototype.message=function(t,e){return this.ua&&this.ua.isRegistered()?t&&e?void this.ua.message(t,e):void this.logger.warn("A destination and message are required to send a message"):void this.logger.warn("A registered UA is required to send a message")},r.prototype.setupRemoteMedia=function(){var t,i=this.session.sessionDescriptionHandler.peerConnection;i.getRemoteStreams?t=i.getRemoteStreams()[0]:(t=new e.window.MediaStream,i.getReceivers().forEach(function(e){var i=e.track;i&&t.addTrack(i)})),this.video?(this.options.media.remote.video.srcObject=t,this.options.media.remote.video.play().catch(function(){this.logger.log("play was rejected")}.bind(this))):this.audio&&(this.options.media.remote.audio.srcObject=t,this.options.media.remote.audio.play().catch(function(){this.logger.log("play was rejected")}.bind(this)))},r.prototype.setupLocalMedia=function(){if(this.video&&this.options.media.local&&this.options.media.local.video){var t,i=this.session.sessionDescriptionHandler.peerConnection;i.getSenders?(t=new e.window.MediaStream,i.getSenders().forEach(function(e){var i=e.track;i&&"video"===i.kind&&t.addTrack(i)})):t=i.getLocalStreams()[0],this.options.media.local.video.srcObject=t,this.options.media.local.video.volume=0,this.options.media.local.video.play()}},r.prototype.cleanupMedia=function(){this.video&&(this.options.media.remote.video.srcObject=null,this.options.media.remote.video.pause(),this.options.media.local&&this.options.media.local.video&&(this.options.media.local.video.srcObject=null,this.options.media.local.video.pause())),this.audio&&(this.options.media.remote.audio.srcObject=null,this.options.media.remote.audio.pause())},r.prototype.setupSession=function(){this.state=i.STATUS_NEW,this.emit("new",this.session),this.session.on("progress",this.onProgress.bind(this)),this.session.on("accepted",this.onAccepted.bind(this)),this.session.on("rejected",this.onEnded.bind(this)),this.session.on("failed",this.onFailed.bind(this)),this.session.on("terminated",this.onEnded.bind(this))},r.prototype.destroyMedia=function(){this.session.sessionDescriptionHandler.close()},r.prototype.toggleMute=function(t){var e=this.session.sessionDescriptionHandler.peerConnection;e.getSenders?e.getSenders().forEach(function(e){e.track&&(e.track.enabled=!t)}):e.getLocalStreams().forEach(function(e){e.getAudioTracks().forEach(function(e){e.enabled=!t}),e.getVideoTracks().forEach(function(e){e.enabled=!t})})},r.prototype.onAccepted=function(){this.state=i.STATUS_CONNECTED,this.emit("connected",this.session),this.setupLocalMedia(),this.setupRemoteMedia(),this.session.sessionDescriptionHandler.on("addTrack",function(){this.logger.log("A track has been added, triggering new remoteMedia setup"),this.setupRemoteMedia()}.bind(this)),this.session.sessionDescriptionHandler.on("addStream",function(){this.logger.log("A stream has been added, trigger new remoteMedia setup"),this.setupRemoteMedia()}.bind(this)),this.session.on("hold",function(){this.emit("hold",this.session)}.bind(this)),this.session.on("unhold",function(){this.emit("unhold",this.session)}.bind(this)),this.session.on("dtmf",function(t){this.emit("dtmf",t)}.bind(this)),this.session.on("bye",this.onEnded.bind(this))},r.prototype.onProgress=function(){this.state=i.STATUS_CONNECTING,this.emit("connecting",this.session)},r.prototype.onFailed=function(){this.onEnded()},r.prototype.onEnded=function(){this.state=i.STATUS_COMPLETED,this.emit("ended",this.session),this.cleanupMedia()},r}}).call(e,i(0))},function(t,e,i){"use strict";(function(e){function r(t,e){if(null!=t){var i=e.charAt(0).toUpperCase()+e.slice(1),r=[e,"webkit"+i,"moz"+i];for(var s in r){var n=t[r[s]];if(n)return n.bind(t)}}}var s=e.window||e;t.exports={WebSocket:s.WebSocket,Transport:i(35),open:s.open,Promise:s.Promise,timers:s,console:s.console||{debug:function(){},log:function(){},warn:function(){},error:function(){}},addEventListener:r(s,"addEventListener"),removeEventListener:r(s,"removeEventListener")}}).call(e,i(0))},function(t,e,i){"use strict";(function(e){t.exports=function(t,i){function r(t){var e=.8*t;return 1e3*(Math.random()*(t-e)+e)}var s,n={STATUS_READY:0,STATUS_DISCONNECTED:1,STATUS_ERROR:2};return s=function(t,e){this.logger=t.getLogger("sip.transport"),this.ua=t,this.ws=null,this.server=e,this.reconnection_attempts=0,this.closed=!1,this.connected=!1,this.reconnectTimer=null,this.lastTransportError={},this.keepAliveInterval=t.configuration.keepAliveInterval,this.keepAliveTimeout=null,this.keepAliveTimer=null,this.ua.transport=this,this.connect()},s.prototype={send:function(t){var e=t.toString();return this.ws&&this.ws.readyState===i.OPEN?(!0===this.ua.configuration.traceSip&&this.logger.log("sending WebSocket message:\n\n"+e+"\n"),this.ws.send(e),!0):(this.logger.warn("unable to send message, WebSocket is not open"),!1)},sendKeepAlive:function(){if(!this.keepAliveTimeout)return this.keepAliveTimeout=t.Timers.setTimeout(function(){this.ua.emit("keepAliveTimeout")}.bind(this),1e4),this.send("\r\n\r\n")},startSendingKeepAlives:function(){this.keepAliveInterval&&!this.keepAliveTimer&&(this.keepAliveTimer=t.Timers.setTimeout(function(){this.sendKeepAlive(),this.keepAliveTimer=null,this.startSendingKeepAlives()}.bind(this),r(this.keepAliveInterval)))},stopSendingKeepAlives:function(){t.Timers.clearTimeout(this.keepAliveTimer),t.Timers.clearTimeout(this.keepAliveTimeout),this.keepAliveTimer=null,this.keepAliveTimeout=null},disconnect:function(){this.ws&&(t.Timers.clearTimeout(this.reconnectTimer),this.stopSendingKeepAlives(),this.closed=!0,this.logger.log("closing WebSocket "+this.server.ws_uri),this.ws.close(),this.ws=null),null!==this.reconnectTimer&&(t.Timers.clearTimeout(this.reconnectTimer),this.reconnectTimer=null,this.ua.emit("disconnected",{transport:this,code:this.lastTransportError.code,reason:this.lastTransportError.reason}))},connect:function(){var t=this;if(this.ws&&(this.ws.readyState===i.OPEN||this.ws.readyState===i.CONNECTING))return this.logger.log("WebSocket "+this.server.ws_uri+" is already connected"),!1;this.ws&&(this.ws.close(),this.ws=null),this.logger.log("connecting to WebSocket "+this.server.ws_uri),this.ua.onTransportConnecting(this,0===this.reconnection_attempts?1:this.reconnection_attempts);try{this.ws=new i(this.server.ws_uri,"sip")}catch(t){this.logger.warn("error connecting to WebSocket "+this.server.ws_uri+": "+t)}this.ws.binaryType="arraybuffer",this.ws.onopen=function(){t.onOpen()},this.ws.onclose=function(e){t.onClose(e),this.onopen=null,this.onclose=null,this.onmessage=null,this.onerror=null},this.ws.onmessage=function(e){t.onMessage(e)},this.ws.onerror=function(e){t.onError(e)}},onOpen:function(){this.connected=!0,this.logger.log("WebSocket "+this.server.ws_uri+" connected"),null!==this.reconnectTimer&&(t.Timers.clearTimeout(this.reconnectTimer),this.reconnectTimer=null),this.reconnection_attempts=0,this.closed=!1,this.ua.onTransportConnected(this),this.startSendingKeepAlives()},onClose:function(t){var e=this.connected;this.lastTransportError.code=t.code,this.lastTransportError.reason=t.reason,this.stopSendingKeepAlives(),this.reconnection_attempts>0?(this.logger.log("Reconnection attempt "+this.reconnection_attempts+" failed (code: "+t.code+(t.reason?"| reason: "+t.reason:"")+")"),this.reconnect()):(this.connected=!1,this.logger.log("WebSocket disconnected (code: "+t.code+(t.reason?"| reason: "+t.reason:"")+")"),!1===t.wasClean&&this.logger.warn("WebSocket abrupt disconnection"),!0===e?(this.ua.onTransportClosed(this),this.closed?this.ua.emit("disconnected",{transport:this,code:this.lastTransportError.code,reason:this.lastTransportError.reason}):this.reconnect()):this.ua.onTransportError(this))},onMessage:function(i){var r,s,n=i.data;if("\r\n"===n)return t.Timers.clearTimeout(this.keepAliveTimeout),this.keepAliveTimeout=null,void(!0===this.ua.configuration.traceSip&&this.logger.log("received WebSocket message with CRLF Keep Alive response"));if("string"!=typeof n){try{n=String.fromCharCode.apply(null,e.alloc(n))}catch(t){return void this.logger.warn("received WebSocket binary message failed to be converted into string, message discarded")}!0===this.ua.configuration.traceSip&&this.logger.log("received WebSocket binary message:\n\n"+n+"\n")}else!0===this.ua.configuration.traceSip&&this.logger.log("received WebSocket text message:\n\n"+n+"\n");if((r=t.Parser.parseMessage(n,this.ua))&&!(this.ua.status===t.UA.C.STATUS_USER_CLOSED&&r instanceof t.IncomingRequest)&&t.sanityCheck(r,this.ua,this))if(r instanceof t.IncomingRequest)r.transport=this,this.ua.receiveRequest(r);else if(r instanceof t.IncomingResponse)switch(r.method){case t.C.INVITE:s=this.ua.transactions.ict[r.via_branch],s&&s.receiveResponse(r);break;case t.C.ACK:break;default:s=this.ua.transactions.nict[r.via_branch],s&&s.receiveResponse(r)}},onError:function(t){this.logger.warn("WebSocket connection error: "),this.logger.warn(t)},reconnect:function(){var e=this;this.reconnection_attempts+=1,this.reconnection_attempts>this.ua.configuration.wsServerMaxReconnection?(this.logger.warn("maximum reconnection attempts for WebSocket "+this.server.ws_uri),this.ua.onTransportError(this)):1===this.reconnection_attempts?(this.logger.log("Connection to WebSocket "+this.server.ws_uri+" severed, attempting first reconnect"),e.connect()):(this.logger.log("trying to reconnect to WebSocket "+this.server.ws_uri+" (reconnection attempt "+this.reconnection_attempts+")"),this.reconnectTimer=t.Timers.setTimeout(function(){e.connect(),e.reconnectTimer=null},1e3*this.ua.configuration.wsServerReconnectionTimeout))}},s.C=n,s}}).call(e,i(36).Buffer)},function(t,e,i){"use strict";(function(t){function r(){return n.TYPED_ARRAY_SUPPORT?2147483647:1073741823}function s(t,e){if(r()<e)throw new RangeError("Invalid typed array length");return n.TYPED_ARRAY_SUPPORT?(t=new Uint8Array(e),t.__proto__=n.prototype):(null===t&&(t=new n(e)),t.length=e),t}function n(t,e,i){if(!(n.TYPED_ARRAY_SUPPORT||this instanceof n))return new n(t,e,i);if("number"==typeof t){if("string"==typeof e)throw new Error("If encoding is specified then the first argument must be a string");return h(this,t)}return o(this,t,e,i)}function o(t,e,i,r){if("number"==typeof e)throw new TypeError('"value" argument must not be a number');return"undefined"!=typeof ArrayBuffer&&e instanceof ArrayBuffer?d(t,e,i,r):"string"==typeof e?u(t,e,i):p(t,e)}function a(t){if("number"!=typeof t)throw new TypeError('"size" argument must be a number');if(t<0)throw new RangeError('"size" argument must not be negative')}function c(t,e,i,r){return a(e),e<=0?s(t,e):void 0!==i?"string"==typeof r?s(t,e).fill(i,r):s(t,e).fill(i):s(t,e)}function h(t,e){if(a(e),t=s(t,e<0?0:0|f(e)),!n.TYPED_ARRAY_SUPPORT)for(var i=0;i<e;++i)t[i]=0;return t}function u(t,e,i){if("string"==typeof i&&""!==i||(i="utf8"),!n.isEncoding(i))throw new TypeError('"encoding" must be a valid string encoding');var r=0|T(e,i);t=s(t,r);var o=t.write(e,i);return o!==r&&(t=t.slice(0,o)),t}function l(t,e){var i=e.length<0?0:0|f(e.length);t=s(t,i);for(var r=0;r<i;r+=1)t[r]=255&e[r];return t}function d(t,e,i,r){if(e.byteLength,i<0||e.byteLength<i)throw new RangeError("'offset' is out of bounds");if(e.byteLength<i+(r||0))throw new RangeError("'length' is out of bounds");return e=void 0===i&&void 0===r?new Uint8Array(e):void 0===r?new Uint8Array(e,i):new Uint8Array(e,i,r),n.TYPED_ARRAY_SUPPORT?(t=e,t.__proto__=n.prototype):t=l(t,e),t}function p(t,e){if(n.isBuffer(e)){var i=0|f(e.length);return t=s(t,i),0===t.length?t:(e.copy(t,0,0,i),t)}if(e){if("undefined"!=typeof ArrayBuffer&&e.buffer instanceof ArrayBuffer||"length"in e)return"number"!=typeof e.length||Z(e.length)?s(t,0):l(t,e);if("Buffer"===e.type&&X(e.data))return l(t,e.data)}throw new TypeError("First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.")}function f(t){if(t>=r())throw new RangeError("Attempt to allocate Buffer larger than maximum size: 0x"+r().toString(16)+" bytes");return 0|t}function g(t){return+t!=t&&(t=0),n.alloc(+t)}function T(t,e){if(n.isBuffer(t))return t.length;if("undefined"!=typeof ArrayBuffer&&"function"==typeof ArrayBuffer.isView&&(ArrayBuffer.isView(t)||t instanceof ArrayBuffer))return t.byteLength;"string"!=typeof t&&(t=""+t);var i=t.length;if(0===i)return 0;for(var r=!1;;)switch(e){case"ascii":case"latin1":case"binary":return i;case"utf8":case"utf-8":case void 0:return Y(t).length;case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return 2*i;case"hex":return i>>>1;case"base64":return K(t).length;default:if(r)return Y(t).length;e=(""+e).toLowerCase(),r=!0}}function m(t,e,i){var r=!1;if((void 0===e||e<0)&&(e=0),e>this.length)return"";if((void 0===i||i>this.length)&&(i=this.length),i<=0)return"";if(i>>>=0,e>>>=0,i<=e)return"";for(t||(t="utf8");;)switch(t){case"hex":return $(this,e,i);case"utf8":case"utf-8":return b(this,e,i);case"ascii":return N(this,e,i);case"latin1":case"binary":return U(this,e,i);case"base64":return w(this,e,i);case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return O(this,e,i);default:if(r)throw new TypeError("Unknown encoding: "+t);t=(t+"").toLowerCase(),r=!0}}function _(t,e,i){var r=t[e];t[e]=t[i],t[i]=r}function E(t,e,i,r,s){if(0===t.length)return-1;if("string"==typeof i?(r=i,i=0):i>2147483647?i=2147483647:i<-2147483648&&(i=-2147483648),i=+i,isNaN(i)&&(i=s?0:t.length-1),i<0&&(i=t.length+i),i>=t.length){if(s)return-1;i=t.length-1}else if(i<0){if(!s)return-1;i=0}if("string"==typeof e&&(e=n.from(e,r)),n.isBuffer(e))return 0===e.length?-1:S(t,e,i,r,s);if("number"==typeof e)return e&=255,n.TYPED_ARRAY_SUPPORT&&"function"==typeof Uint8Array.prototype.indexOf?s?Uint8Array.prototype.indexOf.call(t,e,i):Uint8Array.prototype.lastIndexOf.call(t,e,i):S(t,[e],i,r,s);throw new TypeError("val must be string, number or Buffer")}function S(t,e,i,r,s){function n(t,e){return 1===o?t[e]:t.readUInt16BE(e*o)}var o=1,a=t.length,c=e.length;if(void 0!==r&&("ucs2"===(r=String(r).toLowerCase())||"ucs-2"===r||"utf16le"===r||"utf-16le"===r)){if(t.length<2||e.length<2)return-1;o=2,a/=2,c/=2,i/=2}var h;if(s){var u=-1;for(h=i;h<a;h++)if(n(t,h)===n(e,-1===u?0:h-u)){if(-1===u&&(u=h),h-u+1===c)return u*o}else-1!==u&&(h-=h-u),u=-1}else for(i+c>a&&(i=a-c),h=i;h>=0;h--){for(var l=!0,d=0;d<c;d++)if(n(t,h+d)!==n(e,d)){l=!1;break}if(l)return h}return-1}function v(t,e,i,r){i=Number(i)||0;var s=t.length-i;r?(r=Number(r))>s&&(r=s):r=s;var n=e.length;if(n%2!=0)throw new TypeError("Invalid hex string");r>n/2&&(r=n/2);for(var o=0;o<r;++o){var a=parseInt(e.substr(2*o,2),16);if(isNaN(a))return o;t[i+o]=a}return o}function C(t,e,i,r){return V(Y(e,t.length-i),t,i,r)}function R(t,e,i,r){return V(j(e),t,i,r)}function A(t,e,i,r){return R(t,e,i,r)}function y(t,e,i,r){return V(K(e),t,i,r)}function I(t,e,i,r){return V(W(e,t.length-i),t,i,r)}function w(t,e,i){return 0===e&&i===t.length?J.fromByteArray(t):J.fromByteArray(t.slice(e,i))}function b(t,e,i){i=Math.min(t.length,i);for(var r=[],s=e;s<i;){var n=t[s],o=null,a=n>239?4:n>223?3:n>191?2:1;if(s+a<=i){var c,h,u,l;switch(a){case 1:n<128&&(o=n);break;case 2:c=t[s+1],128==(192&c)&&(l=(31&n)<<6|63&c)>127&&(o=l);break;case 3:c=t[s+1],h=t[s+2],128==(192&c)&&128==(192&h)&&(l=(15&n)<<12|(63&c)<<6|63&h)>2047&&(l<55296||l>57343)&&(o=l);break;case 4:c=t[s+1],h=t[s+2],u=t[s+3],128==(192&c)&&128==(192&h)&&128==(192&u)&&(l=(15&n)<<18|(63&c)<<12|(63&h)<<6|63&u)>65535&&l<1114112&&(o=l)}}null===o?(o=65533,a=1):o>65535&&(o-=65536,r.push(o>>>10&1023|55296),o=56320|1023&o),r.push(o),s+=a}return D(r)}function D(t){var e=t.length;if(e<=Q)return String.fromCharCode.apply(String,t);for(var i="",r=0;r<e;)i+=String.fromCharCode.apply(String,t.slice(r,r+=Q));return i}function N(t,e,i){var r="";i=Math.min(t.length,i);for(var s=e;s<i;++s)r+=String.fromCharCode(127&t[s]);return r}function U(t,e,i){var r="";i=Math.min(t.length,i);for(var s=e;s<i;++s)r+=String.fromCharCode(t[s]);return r}function $(t,e,i){var r=t.length;(!e||e<0)&&(e=0),(!i||i<0||i>r)&&(i=r);for(var s="",n=e;n<i;++n)s+=G(t[n]);return s}function O(t,e,i){for(var r=t.slice(e,i),s="",n=0;n<r.length;n+=2)s+=String.fromCharCode(r[n]+256*r[n+1]);return s}function x(t,e,i){if(t%1!=0||t<0)throw new RangeError("offset is not uint");if(t+e>i)throw new RangeError("Trying to access beyond buffer length")}function P(t,e,i,r,s,o){if(!n.isBuffer(t))throw new TypeError('"buffer" argument must be a Buffer instance');if(e>s||e<o)throw new RangeError('"value" argument is out of bounds');if(i+r>t.length)throw new RangeError("Index out of range")}function H(t,e,i,r){e<0&&(e=65535+e+1);for(var s=0,n=Math.min(t.length-i,2);s<n;++s)t[i+s]=(e&255<<8*(r?s:1-s))>>>8*(r?s:1-s)}function q(t,e,i,r){e<0&&(e=4294967295+e+1);for(var s=0,n=Math.min(t.length-i,4);s<n;++s)t[i+s]=e>>>8*(r?s:3-s)&255}function M(t,e,i,r,s,n){if(i+r>t.length)throw new RangeError("Index out of range");if(i<0)throw new RangeError("Index out of range")}function k(t,e,i,r,s){return s||M(t,e,i,4,3.4028234663852886e38,-3.4028234663852886e38),z.write(t,e,i,r,23,4),i+4}function L(t,e,i,r,s){return s||M(t,e,i,8,1.7976931348623157e308,-1.7976931348623157e308),z.write(t,e,i,r,52,8),i+8}function F(t){if(t=B(t).replace(tt,""),t.length<2)return"";for(;t.length%4!=0;)t+="=";return t}function B(t){return t.trim?t.trim():t.replace(/^\s+|\s+$/g,"")}function G(t){return t<16?"0"+t.toString(16):t.toString(16)}function Y(t,e){e=e||1/0;for(var i,r=t.length,s=null,n=[],o=0;o<r;++o){if((i=t.charCodeAt(o))>55295&&i<57344){if(!s){if(i>56319){(e-=3)>-1&&n.push(239,191,189);continue}if(o+1===r){(e-=3)>-1&&n.push(239,191,189);continue}s=i;continue}if(i<56320){(e-=3)>-1&&n.push(239,191,189),s=i;continue}i=65536+(s-55296<<10|i-56320)}else s&&(e-=3)>-1&&n.push(239,191,189);if(s=null,i<128){if((e-=1)<0)break;n.push(i)}else if(i<2048){if((e-=2)<0)break;n.push(i>>6|192,63&i|128)}else if(i<65536){if((e-=3)<0)break;n.push(i>>12|224,i>>6&63|128,63&i|128)}else{if(!(i<1114112))throw new Error("Invalid code point");if((e-=4)<0)break;n.push(i>>18|240,i>>12&63|128,i>>6&63|128,63&i|128)}}return n}function j(t){for(var e=[],i=0;i<t.length;++i)e.push(255&t.charCodeAt(i));return e}function W(t,e){for(var i,r,s,n=[],o=0;o<t.length&&!((e-=2)<0);++o)i=t.charCodeAt(o),r=i>>8,s=i%256,n.push(s),n.push(r);return n}function K(t){return J.toByteArray(F(t))}function V(t,e,i,r){for(var s=0;s<r&&!(s+i>=e.length||s>=t.length);++s)e[s+i]=t[s];return s}function Z(t){return t!==t}/*!
 * The buffer module from node.js, for the browser.
 *
 * @author   Feross Aboukhadijeh <feross@feross.org> <http://feross.org>
 * @license  MIT
 */
var J=i(37),z=i(38),X=i(39);e.Buffer=n,e.SlowBuffer=g,e.INSPECT_MAX_BYTES=50,n.TYPED_ARRAY_SUPPORT=void 0!==t.TYPED_ARRAY_SUPPORT?t.TYPED_ARRAY_SUPPORT:function(){try{var t=new Uint8Array(1);return t.__proto__={__proto__:Uint8Array.prototype,foo:function(){return 42}},42===t.foo()&&"function"==typeof t.subarray&&0===t.subarray(1,1).byteLength}catch(t){return!1}}(),e.kMaxLength=r(),n.poolSize=8192,n._augment=function(t){return t.__proto__=n.prototype,t},n.from=function(t,e,i){return o(null,t,e,i)},n.TYPED_ARRAY_SUPPORT&&(n.prototype.__proto__=Uint8Array.prototype,n.__proto__=Uint8Array,"undefined"!=typeof Symbol&&Symbol.species&&n[Symbol.species]===n&&Object.defineProperty(n,Symbol.species,{value:null,configurable:!0})),n.alloc=function(t,e,i){return c(null,t,e,i)},n.allocUnsafe=function(t){return h(null,t)},n.allocUnsafeSlow=function(t){return h(null,t)},n.isBuffer=function(t){return!(null==t||!t._isBuffer)},n.compare=function(t,e){if(!n.isBuffer(t)||!n.isBuffer(e))throw new TypeError("Arguments must be Buffers");if(t===e)return 0;for(var i=t.length,r=e.length,s=0,o=Math.min(i,r);s<o;++s)if(t[s]!==e[s]){i=t[s],r=e[s];break}return i<r?-1:r<i?1:0},n.isEncoding=function(t){switch(String(t).toLowerCase()){case"hex":case"utf8":case"utf-8":case"ascii":case"latin1":case"binary":case"base64":case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return!0;default:return!1}},n.concat=function(t,e){if(!X(t))throw new TypeError('"list" argument must be an Array of Buffers');if(0===t.length)return n.alloc(0);var i;if(void 0===e)for(e=0,i=0;i<t.length;++i)e+=t[i].length;var r=n.allocUnsafe(e),s=0;for(i=0;i<t.length;++i){var o=t[i];if(!n.isBuffer(o))throw new TypeError('"list" argument must be an Array of Buffers');o.copy(r,s),s+=o.length}return r},n.byteLength=T,n.prototype._isBuffer=!0,n.prototype.swap16=function(){var t=this.length;if(t%2!=0)throw new RangeError("Buffer size must be a multiple of 16-bits");for(var e=0;e<t;e+=2)_(this,e,e+1);return this},n.prototype.swap32=function(){var t=this.length;if(t%4!=0)throw new RangeError("Buffer size must be a multiple of 32-bits");for(var e=0;e<t;e+=4)_(this,e,e+3),_(this,e+1,e+2);return this},n.prototype.swap64=function(){var t=this.length;if(t%8!=0)throw new RangeError("Buffer size must be a multiple of 64-bits");for(var e=0;e<t;e+=8)_(this,e,e+7),_(this,e+1,e+6),_(this,e+2,e+5),_(this,e+3,e+4);return this},n.prototype.toString=function(){var t=0|this.length;return 0===t?"":0===arguments.length?b(this,0,t):m.apply(this,arguments)},n.prototype.equals=function(t){if(!n.isBuffer(t))throw new TypeError("Argument must be a Buffer");return this===t||0===n.compare(this,t)},n.prototype.inspect=function(){var t="",i=e.INSPECT_MAX_BYTES;return this.length>0&&(t=this.toString("hex",0,i).match(/.{2}/g).join(" "),this.length>i&&(t+=" ... ")),"<Buffer "+t+">"},n.prototype.compare=function(t,e,i,r,s){if(!n.isBuffer(t))throw new TypeError("Argument must be a Buffer");if(void 0===e&&(e=0),void 0===i&&(i=t?t.length:0),void 0===r&&(r=0),void 0===s&&(s=this.length),e<0||i>t.length||r<0||s>this.length)throw new RangeError("out of range index");if(r>=s&&e>=i)return 0;if(r>=s)return-1;if(e>=i)return 1;if(e>>>=0,i>>>=0,r>>>=0,s>>>=0,this===t)return 0;for(var o=s-r,a=i-e,c=Math.min(o,a),h=this.slice(r,s),u=t.slice(e,i),l=0;l<c;++l)if(h[l]!==u[l]){o=h[l],a=u[l];break}return o<a?-1:a<o?1:0},n.prototype.includes=function(t,e,i){return-1!==this.indexOf(t,e,i)},n.prototype.indexOf=function(t,e,i){return E(this,t,e,i,!0)},n.prototype.lastIndexOf=function(t,e,i){return E(this,t,e,i,!1)},n.prototype.write=function(t,e,i,r){if(void 0===e)r="utf8",i=this.length,e=0;else if(void 0===i&&"string"==typeof e)r=e,i=this.length,e=0;else{if(!isFinite(e))throw new Error("Buffer.write(string, encoding, offset[, length]) is no longer supported");e|=0,isFinite(i)?(i|=0,void 0===r&&(r="utf8")):(r=i,i=void 0)}var s=this.length-e;if((void 0===i||i>s)&&(i=s),t.length>0&&(i<0||e<0)||e>this.length)throw new RangeError("Attempt to write outside buffer bounds");r||(r="utf8");for(var n=!1;;)switch(r){case"hex":return v(this,t,e,i);case"utf8":case"utf-8":return C(this,t,e,i);case"ascii":return R(this,t,e,i);case"latin1":case"binary":return A(this,t,e,i);case"base64":return y(this,t,e,i);case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return I(this,t,e,i);default:if(n)throw new TypeError("Unknown encoding: "+r);r=(""+r).toLowerCase(),n=!0}},n.prototype.toJSON=function(){return{type:"Buffer",data:Array.prototype.slice.call(this._arr||this,0)}};var Q=4096;n.prototype.slice=function(t,e){var i=this.length;t=~~t,e=void 0===e?i:~~e,t<0?(t+=i)<0&&(t=0):t>i&&(t=i),e<0?(e+=i)<0&&(e=0):e>i&&(e=i),e<t&&(e=t);var r;if(n.TYPED_ARRAY_SUPPORT)r=this.subarray(t,e),r.__proto__=n.prototype;else{var s=e-t;r=new n(s,void 0);for(var o=0;o<s;++o)r[o]=this[o+t]}return r},n.prototype.readUIntLE=function(t,e,i){t|=0,e|=0,i||x(t,e,this.length);for(var r=this[t],s=1,n=0;++n<e&&(s*=256);)r+=this[t+n]*s;return r},n.prototype.readUIntBE=function(t,e,i){t|=0,e|=0,i||x(t,e,this.length);for(var r=this[t+--e],s=1;e>0&&(s*=256);)r+=this[t+--e]*s;return r},n.prototype.readUInt8=function(t,e){return e||x(t,1,this.length),this[t]},n.prototype.readUInt16LE=function(t,e){return e||x(t,2,this.length),this[t]|this[t+1]<<8},n.prototype.readUInt16BE=function(t,e){return e||x(t,2,this.length),this[t]<<8|this[t+1]},n.prototype.readUInt32LE=function(t,e){return e||x(t,4,this.length),(this[t]|this[t+1]<<8|this[t+2]<<16)+16777216*this[t+3]},n.prototype.readUInt32BE=function(t,e){return e||x(t,4,this.length),16777216*this[t]+(this[t+1]<<16|this[t+2]<<8|this[t+3])},n.prototype.readIntLE=function(t,e,i){t|=0,e|=0,i||x(t,e,this.length);for(var r=this[t],s=1,n=0;++n<e&&(s*=256);)r+=this[t+n]*s;return s*=128,r>=s&&(r-=Math.pow(2,8*e)),r},n.prototype.readIntBE=function(t,e,i){t|=0,e|=0,i||x(t,e,this.length);for(var r=e,s=1,n=this[t+--r];r>0&&(s*=256);)n+=this[t+--r]*s;return s*=128,n>=s&&(n-=Math.pow(2,8*e)),n},n.prototype.readInt8=function(t,e){return e||x(t,1,this.length),128&this[t]?-1*(255-this[t]+1):this[t]},n.prototype.readInt16LE=function(t,e){e||x(t,2,this.length);var i=this[t]|this[t+1]<<8;return 32768&i?4294901760|i:i},n.prototype.readInt16BE=function(t,e){e||x(t,2,this.length);var i=this[t+1]|this[t]<<8;return 32768&i?4294901760|i:i},n.prototype.readInt32LE=function(t,e){return e||x(t,4,this.length),this[t]|this[t+1]<<8|this[t+2]<<16|this[t+3]<<24},n.prototype.readInt32BE=function(t,e){return e||x(t,4,this.length),this[t]<<24|this[t+1]<<16|this[t+2]<<8|this[t+3]},n.prototype.readFloatLE=function(t,e){return e||x(t,4,this.length),z.read(this,t,!0,23,4)},n.prototype.readFloatBE=function(t,e){return e||x(t,4,this.length),z.read(this,t,!1,23,4)},n.prototype.readDoubleLE=function(t,e){return e||x(t,8,this.length),z.read(this,t,!0,52,8)},n.prototype.readDoubleBE=function(t,e){return e||x(t,8,this.length),z.read(this,t,!1,52,8)},n.prototype.writeUIntLE=function(t,e,i,r){if(t=+t,e|=0,i|=0,!r){P(this,t,e,i,Math.pow(2,8*i)-1,0)}var s=1,n=0;for(this[e]=255&t;++n<i&&(s*=256);)this[e+n]=t/s&255;return e+i},n.prototype.writeUIntBE=function(t,e,i,r){if(t=+t,e|=0,i|=0,!r){P(this,t,e,i,Math.pow(2,8*i)-1,0)}var s=i-1,n=1;for(this[e+s]=255&t;--s>=0&&(n*=256);)this[e+s]=t/n&255;return e+i},n.prototype.writeUInt8=function(t,e,i){return t=+t,e|=0,i||P(this,t,e,1,255,0),n.TYPED_ARRAY_SUPPORT||(t=Math.floor(t)),this[e]=255&t,e+1},n.prototype.writeUInt16LE=function(t,e,i){return t=+t,e|=0,i||P(this,t,e,2,65535,0),n.TYPED_ARRAY_SUPPORT?(this[e]=255&t,this[e+1]=t>>>8):H(this,t,e,!0),e+2},n.prototype.writeUInt16BE=function(t,e,i){return t=+t,e|=0,i||P(this,t,e,2,65535,0),n.TYPED_ARRAY_SUPPORT?(this[e]=t>>>8,this[e+1]=255&t):H(this,t,e,!1),e+2},n.prototype.writeUInt32LE=function(t,e,i){return t=+t,e|=0,i||P(this,t,e,4,4294967295,0),n.TYPED_ARRAY_SUPPORT?(this[e+3]=t>>>24,this[e+2]=t>>>16,this[e+1]=t>>>8,this[e]=255&t):q(this,t,e,!0),e+4},n.prototype.writeUInt32BE=function(t,e,i){return t=+t,e|=0,i||P(this,t,e,4,4294967295,0),n.TYPED_ARRAY_SUPPORT?(this[e]=t>>>24,this[e+1]=t>>>16,this[e+2]=t>>>8,this[e+3]=255&t):q(this,t,e,!1),e+4},n.prototype.writeIntLE=function(t,e,i,r){if(t=+t,e|=0,!r){var s=Math.pow(2,8*i-1);P(this,t,e,i,s-1,-s)}var n=0,o=1,a=0;for(this[e]=255&t;++n<i&&(o*=256);)t<0&&0===a&&0!==this[e+n-1]&&(a=1),this[e+n]=(t/o>>0)-a&255;return e+i},n.prototype.writeIntBE=function(t,e,i,r){if(t=+t,e|=0,!r){var s=Math.pow(2,8*i-1);P(this,t,e,i,s-1,-s)}var n=i-1,o=1,a=0;for(this[e+n]=255&t;--n>=0&&(o*=256);)t<0&&0===a&&0!==this[e+n+1]&&(a=1),this[e+n]=(t/o>>0)-a&255;return e+i},n.prototype.writeInt8=function(t,e,i){return t=+t,e|=0,i||P(this,t,e,1,127,-128),n.TYPED_ARRAY_SUPPORT||(t=Math.floor(t)),t<0&&(t=255+t+1),this[e]=255&t,e+1},n.prototype.writeInt16LE=function(t,e,i){return t=+t,e|=0,i||P(this,t,e,2,32767,-32768),n.TYPED_ARRAY_SUPPORT?(this[e]=255&t,this[e+1]=t>>>8):H(this,t,e,!0),e+2},n.prototype.writeInt16BE=function(t,e,i){return t=+t,e|=0,i||P(this,t,e,2,32767,-32768),n.TYPED_ARRAY_SUPPORT?(this[e]=t>>>8,this[e+1]=255&t):H(this,t,e,!1),e+2},n.prototype.writeInt32LE=function(t,e,i){return t=+t,e|=0,i||P(this,t,e,4,2147483647,-2147483648),n.TYPED_ARRAY_SUPPORT?(this[e]=255&t,this[e+1]=t>>>8,this[e+2]=t>>>16,this[e+3]=t>>>24):q(this,t,e,!0),e+4},n.prototype.writeInt32BE=function(t,e,i){return t=+t,e|=0,i||P(this,t,e,4,2147483647,-2147483648),t<0&&(t=4294967295+t+1),n.TYPED_ARRAY_SUPPORT?(this[e]=t>>>24,this[e+1]=t>>>16,this[e+2]=t>>>8,this[e+3]=255&t):q(this,t,e,!1),e+4},n.prototype.writeFloatLE=function(t,e,i){return k(this,t,e,!0,i)},n.prototype.writeFloatBE=function(t,e,i){return k(this,t,e,!1,i)},n.prototype.writeDoubleLE=function(t,e,i){return L(this,t,e,!0,i)},n.prototype.writeDoubleBE=function(t,e,i){return L(this,t,e,!1,i)},n.prototype.copy=function(t,e,i,r){if(i||(i=0),r||0===r||(r=this.length),e>=t.length&&(e=t.length),e||(e=0),r>0&&r<i&&(r=i),r===i)return 0;if(0===t.length||0===this.length)return 0;if(e<0)throw new RangeError("targetStart out of bounds");if(i<0||i>=this.length)throw new RangeError("sourceStart out of bounds");if(r<0)throw new RangeError("sourceEnd out of bounds");r>this.length&&(r=this.length),t.length-e<r-i&&(r=t.length-e+i);var s,o=r-i;if(this===t&&i<e&&e<r)for(s=o-1;s>=0;--s)t[s+e]=this[s+i];else if(o<1e3||!n.TYPED_ARRAY_SUPPORT)for(s=0;s<o;++s)t[s+e]=this[s+i];else Uint8Array.prototype.set.call(t,this.subarray(i,i+o),e);return o},n.prototype.fill=function(t,e,i,r){if("string"==typeof t){if("string"==typeof e?(r=e,e=0,i=this.length):"string"==typeof i&&(r=i,i=this.length),1===t.length){var s=t.charCodeAt(0);s<256&&(t=s)}if(void 0!==r&&"string"!=typeof r)throw new TypeError("encoding must be a string");if("string"==typeof r&&!n.isEncoding(r))throw new TypeError("Unknown encoding: "+r)}else"number"==typeof t&&(t&=255);if(e<0||this.length<e||this.length<i)throw new RangeError("Out of range index");if(i<=e)return this;e>>>=0,i=void 0===i?this.length:i>>>0,t||(t=0);var o;if("number"==typeof t)for(o=e;o<i;++o)this[o]=t;else{var a=n.isBuffer(t)?t:Y(new n(t,r).toString()),c=a.length;for(o=0;o<i-e;++o)this[o+e]=a[o%c]}return this};var tt=/[^+\/0-9A-Za-z-_]/g}).call(e,i(0))},function(t,e,i){"use strict";function r(t){var e=t.length;if(e%4>0)throw new Error("Invalid string. Length must be a multiple of 4");return"="===t[e-2]?2:"="===t[e-1]?1:0}function s(t){return 3*t.length/4-r(t)}function n(t){var e,i,s,n,o,a=t.length;n=r(t),o=new l(3*a/4-n),i=n>0?a-4:a;var c=0;for(e=0;e<i;e+=4)s=u[t.charCodeAt(e)]<<18|u[t.charCodeAt(e+1)]<<12|u[t.charCodeAt(e+2)]<<6|u[t.charCodeAt(e+3)],o[c++]=s>>16&255,o[c++]=s>>8&255,o[c++]=255&s;return 2===n?(s=u[t.charCodeAt(e)]<<2|u[t.charCodeAt(e+1)]>>4,o[c++]=255&s):1===n&&(s=u[t.charCodeAt(e)]<<10|u[t.charCodeAt(e+1)]<<4|u[t.charCodeAt(e+2)]>>2,o[c++]=s>>8&255,o[c++]=255&s),o}function o(t){return h[t>>18&63]+h[t>>12&63]+h[t>>6&63]+h[63&t]}function a(t,e,i){for(var r,s=[],n=e;n<i;n+=3)r=(t[n]<<16)+(t[n+1]<<8)+t[n+2],s.push(o(r));return s.join("")}function c(t){for(var e,i=t.length,r=i%3,s="",n=[],o=0,c=i-r;o<c;o+=16383)n.push(a(t,o,o+16383>c?c:o+16383));return 1===r?(e=t[i-1],s+=h[e>>2],s+=h[e<<4&63],s+="=="):2===r&&(e=(t[i-2]<<8)+t[i-1],s+=h[e>>10],s+=h[e>>4&63],s+=h[e<<2&63],s+="="),n.push(s),n.join("")}e.byteLength=s,e.toByteArray=n,e.fromByteArray=c;for(var h=[],u=[],l="undefined"!=typeof Uint8Array?Uint8Array:Array,d="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",p=0,f=d.length;p<f;++p)h[p]=d[p],u[d.charCodeAt(p)]=p;u["-".charCodeAt(0)]=62,u["_".charCodeAt(0)]=63},function(t,e){e.read=function(t,e,i,r,s){var n,o,a=8*s-r-1,c=(1<<a)-1,h=c>>1,u=-7,l=i?s-1:0,d=i?-1:1,p=t[e+l];for(l+=d,n=p&(1<<-u)-1,p>>=-u,u+=a;u>0;n=256*n+t[e+l],l+=d,u-=8);for(o=n&(1<<-u)-1,n>>=-u,u+=r;u>0;o=256*o+t[e+l],l+=d,u-=8);if(0===n)n=1-h;else{if(n===c)return o?NaN:1/0*(p?-1:1);o+=Math.pow(2,r),n-=h}return(p?-1:1)*o*Math.pow(2,n-r)},e.write=function(t,e,i,r,s,n){var o,a,c,h=8*n-s-1,u=(1<<h)-1,l=u>>1,d=23===s?Math.pow(2,-24)-Math.pow(2,-77):0,p=r?0:n-1,f=r?1:-1,g=e<0||0===e&&1/e<0?1:0;for(e=Math.abs(e),isNaN(e)||e===1/0?(a=isNaN(e)?1:0,o=u):(o=Math.floor(Math.log(e)/Math.LN2),e*(c=Math.pow(2,-o))<1&&(o--,c*=2),e+=o+l>=1?d/c:d*Math.pow(2,1-l),e*c>=2&&(o++,c/=2),o+l>=u?(a=0,o=u):o+l>=1?(a=(e*c-1)*Math.pow(2,s),o+=l):(a=e*Math.pow(2,l-1)*Math.pow(2,s),o=0));s>=8;t[i+p]=255&a,p+=f,a/=256,s-=8);for(o=o<<s|a,h+=s;h>0;t[i+p]=255&o,p+=f,o/=256,h-=8);t[i+p-f]|=128*g}},function(t,e){var i={}.toString;t.exports=Array.isArray||function(t){return"[object Array]"==i.call(t)}}])});