# 4.4.0

## Summary

The 4.4.0 release includes features and fixes from 80 pull requests, including first time contributions from @EduardoNogueira, @ath0mas, @f7o, @trevorblades, @viethang, and @wb14123.  There are some really nice rendering enhancements included in this release.  It is now possible to render labels along lines (see [#7239](https://github.com/openlayers/openlayers/pull/7239) for more detail) and polygon labels are only rendered if they fit within the polygon ([#7292](https://github.com/openlayers/openlayers/pull/7292)).  In addition, we now render tiles with an opacity transition, so tiled layers more gracefully fade in ([#7267](https://github.com/openlayers/openlayers/pull/7267)).

### Upgrade notes

#### Behavior change for polygon labels

Polygon labels are now only rendered when the label does not exceed the polygon at the label position. To get the old behavior, configure your `ol.style.Text` with `exceedLength: true`.

#### Minor change for custom `tileLoadFunction` with `ol.source.VectorTile`

It is no longer necessary to set the projection on the tile. Instead, the `readFeatures` method must be called with the tile's extent as `extent` option and the view's projection as `featureProjection`.

Before:
```js
tile.setLoader(function() {
  var data = // ... fetch data
  var format = tile.getFormat();
  tile.setFeatures(format.readFeatures(data));
  tile.setProjection(format.readProjection(data));
  // uncomment the line below for ol.format.MVT only
  //tile.setExtent(format.getLastExtent());
});
```

After:
```js
tile.setLoader(function() {
  var data = // ... fetch data
  var format = tile.getFormat();
  tile.setFeatures(format.readFeatures(data, {
    featureProjection: map.getView().getProjection(),
    // uncomment the line below for ol.format.MVT only
    //extent: tile.getExtent()
  }));
);
```

#### Deprecation of `ol.DeviceOrientation`

`ol.DeviceOrientation` is deprecated and will be removed in the next major version.
The device-orientation example has been updated to use the (gyronorm.js)[https://github.com/dorukeker/gyronorm.js] library.


## Detailed changes

See below for the full list of changes.

 * [#7306](https://github.com/openlayers/openlayers/pull/7306) - Enable mouse wheel in freehand draw mode ([@trevorblades](https://github.com/trevorblades))
 * [#7297](https://github.com/openlayers/openlayers/pull/7297) - Fix multipoint instruction set ([@ahocevar](https://github.com/ahocevar))
 * [#7267](https://github.com/openlayers/openlayers/pull/7267) - Render tiles with an opacity transition ([@tschaub](https://github.com/tschaub))
 * [#7292](https://github.com/openlayers/openlayers/pull/7292) - Only render polygon labels when they fit ([@ahocevar](https://github.com/ahocevar))
 * [#7289](https://github.com/openlayers/openlayers/pull/7289) - Release v4.3.4 ([@openlayers](https://github.com/openlayers))
 * [#7287](https://github.com/openlayers/openlayers/pull/7287) - Fix vertical stroke/fill alignment for text along lines ([@ahocevar](https://github.com/ahocevar))
 * [#7285](https://github.com/openlayers/openlayers/pull/7285) - Convert pointerId to string for object lookups ([@tschaub](https://github.com/tschaub))
 * [#7280](https://github.com/openlayers/openlayers/pull/7280) - Updated docs for deleteCondition ([@EduardoNogueira](https://github.com/EduardoNogueira))
 * [#7274](https://github.com/openlayers/openlayers/pull/7274) - Add ability to change the loader of a vector source ([@bartvde](https://github.com/bartvde))
 * [#7259](https://github.com/openlayers/openlayers/pull/7259) - Add missing param doc tag for ol.format.WKT.prototype.writeFeatures ([@fredj](https://github.com/fredj))
 * [#7260](https://github.com/openlayers/openlayers/pull/7260) - Release v4.3.3 ([@openlayers](https://github.com/openlayers))
 * [#7258](https://github.com/openlayers/openlayers/pull/7258) - Revert changes made in #7098. ([@ahocevar](https://github.com/ahocevar))
 * [#7220](https://github.com/openlayers/openlayers/pull/7220) - Mark ol.format.filter.Spatial as abstract class ([@fredj](https://github.com/fredj))
 * [#7249](https://github.com/openlayers/openlayers/pull/7249) - Script to rename files so the case matches the module name ([@ahocevar](https://github.com/ahocevar))
 * [#7252](https://github.com/openlayers/openlayers/pull/7252) - fix osmxml to read ways before the definition of nodes ([@wb14123](https://github.com/wb14123))
 * [#7253](https://github.com/openlayers/openlayers/pull/7253) - Nicer wording in the issue template ([@openlayers](https://github.com/openlayers))
 * [#7236](https://github.com/openlayers/openlayers/pull/7236) - reusing images in ol.style.Icon#clone ([@KlausBenndorf](https://github.com/KlausBenndorf))
 * [#7246](https://github.com/openlayers/openlayers/pull/7246) - Compare measured lengths with a tolerance ([@marcjansen](https://github.com/marcjansen))
 * [#7247](https://github.com/openlayers/openlayers/pull/7247) - Raise tolerance of rendering tests to pass on Firefox 55 (GNU/Linux) ([@marcjansen](https://github.com/marcjansen))
 * [#7239](https://github.com/openlayers/openlayers/pull/7239) - Render text along lines ([@ahocevar](https://github.com/ahocevar))
 * [#7242](https://github.com/openlayers/openlayers/pull/7242) - Use EMPTY and LOADED state properly on ol.VectorImageTile ([@ahocevar](https://github.com/ahocevar))
 * [#7234](https://github.com/openlayers/openlayers/pull/7234) - Fix abort handling of tileload events ([@ahocevar](https://github.com/ahocevar))
 * [#7221](https://github.com/openlayers/openlayers/pull/7221) - update zoomify source to accept tileIndex placeholders and handle iip… ([@thhomas](https://github.com/thhomas))
 * [#6871](https://github.com/openlayers/openlayers/pull/6871) - Correct controls position in Center example ([@ath0mas](https://github.com/ath0mas))
 * [#7229](https://github.com/openlayers/openlayers/pull/7229) - Fix JSDoc paths for custom builds ([@ahocevar](https://github.com/ahocevar))
 * [#7230](https://github.com/openlayers/openlayers/pull/7230) - Remove unused context handling for ol.Image ([@ahocevar](https://github.com/ahocevar))
 * [#7225](https://github.com/openlayers/openlayers/pull/7225) - Fix hit detection for image layers ([@ahocevar](https://github.com/ahocevar))
 * [#7223](https://github.com/openlayers/openlayers/pull/7223) - Transform updates ([@tschaub](https://github.com/tschaub))
 * [#7219](https://github.com/openlayers/openlayers/pull/7219) - Change cartodb domain from cartodb.com to carto.com ([@fredj](https://github.com/fredj))
 * [#7210](https://github.com/openlayers/openlayers/pull/7210) - Avoid unnecessary calculations for a zoom factor of 2 ([@tschaub](https://github.com/tschaub))
 * [#7209](https://github.com/openlayers/openlayers/pull/7209) - Remove grid.getTileRangeForExtentAndResolution() ([@tschaub](https://github.com/tschaub))
 * [#7201](https://github.com/openlayers/openlayers/pull/7201) - Prerender text to images ([@ahocevar](https://github.com/ahocevar))
 * [#7208](https://github.com/openlayers/openlayers/pull/7208) - Do not calculate coverage when running tests locally ([@ahocevar](https://github.com/ahocevar))
 * [#7206](https://github.com/openlayers/openlayers/pull/7206) - Only load source tiles that intersect the source tile grid's extent ([@ahocevar](https://github.com/ahocevar))
 * [#7203](https://github.com/openlayers/openlayers/pull/7203) - Enable Edge tests on SauceLabs ([@ahocevar](https://github.com/ahocevar))
 * [#7194](https://github.com/openlayers/openlayers/pull/7194) - Deprecate ol.DeviceOrientation ([@fredj](https://github.com/fredj))
 * [#7198](https://github.com/openlayers/openlayers/pull/7198) - Use geometry name in WFS updates ([@bartvde](https://github.com/bartvde))
 * [#7205](https://github.com/openlayers/openlayers/pull/7205) - Release v4.3.2 ([@openlayers](https://github.com/openlayers))
 * [#7172](https://github.com/openlayers/openlayers/pull/7172) - added clear method to vectortile source ([@f7o](https://github.com/f7o))
 * [#7196](https://github.com/openlayers/openlayers/pull/7196) - renderSync() to make sure overlay is initially visible ([@ahocevar](https://github.com/ahocevar))
 * [#7193](https://github.com/openlayers/openlayers/pull/7193) - Fix KML links for documents created locally in Safari ([@ahocevar](https://github.com/ahocevar))
 * [#6977](https://github.com/openlayers/openlayers/pull/6977) - Fixed modify feature test ([@KlausBenndorf](https://github.com/KlausBenndorf))
 * [#7190](https://github.com/openlayers/openlayers/pull/7190) - Use jsts version 1.4.0 in example ([@openlayers](https://github.com/openlayers))
 * [#7191](https://github.com/openlayers/openlayers/pull/7191) - Fix provide/require for autogenerated shader files ([@ahocevar](https://github.com/ahocevar))
 * [#7192](https://github.com/openlayers/openlayers/pull/7192) - Fix typo ([@viethang](https://github.com/viethang))
 * [#7133](https://github.com/openlayers/openlayers/pull/7133) - Issue/6991/WFS Write Dimension ([@Sol1du2](https://github.com/Sol1du2))
 * [#7141](https://github.com/openlayers/openlayers/pull/7141) - Issue/6990/Wfs Read srsDimension ([@Sol1du2](https://github.com/Sol1du2))
 * [#7187](https://github.com/openlayers/openlayers/pull/7187) - Simpler tile pixel handling and faster parsing for ol.format.MVT vector tiles ([@ahocevar](https://github.com/ahocevar))
 * [#7182](https://github.com/openlayers/openlayers/pull/7182) - Avoid instanceof checks in global test extensions ([@tschaub](https://github.com/tschaub))
 * [#7168](https://github.com/openlayers/openlayers/pull/7168) - Exclude greenkeeper merges from changelog ([@gberaudo](https://github.com/gberaudo))
 * [#7162](https://github.com/openlayers/openlayers/pull/7162) - Bring back coverage ([@marcjansen](https://github.com/marcjansen))
 * [#7165](https://github.com/openlayers/openlayers/pull/7165) - More assorted test fixes ([@tschaub](https://github.com/tschaub))
 * [#7142](https://github.com/openlayers/openlayers/pull/7142) - Adds unit test to test the projection inside the geometry of esriJson ([@Sol1du2](https://github.com/Sol1du2))
 * [#7163](https://github.com/openlayers/openlayers/pull/7163) - Remove bundling magic for Mapbox styles script ([@ahocevar](https://github.com/ahocevar))
 * [#7160](https://github.com/openlayers/openlayers/pull/7160) - Assorted test updates ([@tschaub](https://github.com/tschaub))
 * [#7158](https://github.com/openlayers/openlayers/pull/7158) - Retain comments when replacing nodes ([@tschaub](https://github.com/tschaub))
 * [#7153](https://github.com/openlayers/openlayers/pull/7153) - Scripts for in-place transforms ([@tschaub](https://github.com/tschaub))
 * [#7154](https://github.com/openlayers/openlayers/pull/7154) - Unused require in examples/d3.js ([@tschaub](https://github.com/tschaub))
 * [#7151](https://github.com/openlayers/openlayers/pull/7151) - Get rid of useless test exports ([@tschaub](https://github.com/tschaub))
 * [#7152](https://github.com/openlayers/openlayers/pull/7152) - Adjust the pull request template (tests, CLA, wording) ([@marcjansen](https://github.com/marcjansen))
 * [#7150](https://github.com/openlayers/openlayers/pull/7150) - Remove problematic spies from scaleline tests ([@marcjansen](https://github.com/marcjansen))
 * [#7149](https://github.com/openlayers/openlayers/pull/7149) - Remove unused requires ([@tschaub](https://github.com/tschaub))
 * [#7148](https://github.com/openlayers/openlayers/pull/7148) - Remove ol.ENABLE_WEBGL wrap from WebGL files ([@ahocevar](https://github.com/ahocevar))
 * [#7147](https://github.com/openlayers/openlayers/pull/7147) - Remove unnecessary import in events.test.js ([@tschaub](https://github.com/tschaub))
 * [#7146](https://github.com/openlayers/openlayers/pull/7146) - Avoid modifying imports ([@openlayers](https://github.com/openlayers))
 * [#7145](https://github.com/openlayers/openlayers/pull/7145) - Spaceless provides ([@tschaub](https://github.com/tschaub))
 * [#7136](https://github.com/openlayers/openlayers/pull/7136) - Use data URI instead of whole empty image ([@ahocevar](https://github.com/ahocevar))
 * [#7137](https://github.com/openlayers/openlayers/pull/7137) - Developer documentation updates ([@tschaub](https://github.com/tschaub))
 * [#7138](https://github.com/openlayers/openlayers/pull/7138) - Improvements to the new test setup ([@ahocevar](https://github.com/ahocevar))
 * [#7140](https://github.com/openlayers/openlayers/pull/7140) - Export ol.Sphere.getLength and ol.Sphere.getArea ([@openlayers](https://github.com/openlayers))
 * [#7131](https://github.com/openlayers/openlayers/pull/7131) - Print ES6 import hint on each doc page ([@ahocevar](https://github.com/ahocevar))
 * [#6953](https://github.com/openlayers/openlayers/pull/6953) - Run tests in real browsers with Karma ([@tschaub](https://github.com/tschaub))
 * [#7127](https://github.com/openlayers/openlayers/pull/7127) - Use static GeoJSON instead of Overpass query for faster loading ([@ahocevar](https://github.com/ahocevar))
 * [#7125](https://github.com/openlayers/openlayers/pull/7125) - Do not try to render error tiles from VectorTile source ([@ahocevar](https://github.com/ahocevar))
 * [#6855](https://github.com/openlayers/openlayers/pull/6855) - Pluggable renderers ([@tschaub](https://github.com/tschaub))
 * [#7128](https://github.com/openlayers/openlayers/pull/7128) - Make view.animate() tolerate undefined views ([@tschaub](https://github.com/tschaub))
 * [#7124](https://github.com/openlayers/openlayers/pull/7124) - Release v4.3.1 ([@openlayers](https://github.com/openlayers))
 * [#7122](https://github.com/openlayers/openlayers/pull/7122) - Immediately complete no-op animations ([@tschaub](https://github.com/tschaub))
 * [#7120](https://github.com/openlayers/openlayers/pull/7120) - Fix hit detection for overzoomed vector tiles ([@ahocevar](https://github.com/ahocevar))
 * [#7114](https://github.com/openlayers/openlayers/pull/7114) - Immediate WebGL text renderer and other improvements ([@GaborFarkas](https://github.com/GaborFarkas))


Additionally a number of updates where made to our dependencies:
 * [#7307](https://github.com/openlayers/openlayers/pull/7307) - Update sinon to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7302](https://github.com/openlayers/openlayers/pull/7302) - Update mocha to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7298](https://github.com/openlayers/openlayers/pull/7298) - Update eslint to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7295](https://github.com/openlayers/openlayers/pull/7295) - chore(package): update coveralls to version 3.0.0 ([@openlayers](https://github.com/openlayers))
 * [#7291](https://github.com/openlayers/openlayers/pull/7291) - Update pbf to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7290](https://github.com/openlayers/openlayers/pull/7290) - Update sinon to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7281](https://github.com/openlayers/openlayers/pull/7281) - Update eslint to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7273](https://github.com/openlayers/openlayers/pull/7273) - Update clean-css-cli to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7272](https://github.com/openlayers/openlayers/pull/7272) - Update eslint to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7269](https://github.com/openlayers/openlayers/pull/7269) - Update sinon to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7265](https://github.com/openlayers/openlayers/pull/7265) - Update rollup to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7263](https://github.com/openlayers/openlayers/pull/7263) - Update eslint to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7254](https://github.com/openlayers/openlayers/pull/7254) - Update closure-util to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7257](https://github.com/openlayers/openlayers/pull/7257) - Update jsdoc to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7251](https://github.com/openlayers/openlayers/pull/7251) - Update fs-extra to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7243](https://github.com/openlayers/openlayers/pull/7243) - Update mocha to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7240](https://github.com/openlayers/openlayers/pull/7240) - Update mocha to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7238](https://github.com/openlayers/openlayers/pull/7238) - Update mocha to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7212](https://github.com/openlayers/openlayers/pull/7212) - chore(package): update clean-css-cli to version 4.1.9 ([@openlayers](https://github.com/openlayers))
 * [#7213](https://github.com/openlayers/openlayers/pull/7213) - Update eslint to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7207](https://github.com/openlayers/openlayers/pull/7207) - Update eslint to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7188](https://github.com/openlayers/openlayers/pull/7188) - fix(package): update rollup to version 0.49.1 ([@openlayers](https://github.com/openlayers))
 * [#7166](https://github.com/openlayers/openlayers/pull/7166) - fix(package): update rollup to version 0.48.1 ([@openlayers](https://github.com/openlayers))
 * [#7161](https://github.com/openlayers/openlayers/pull/7161) - Update eslint to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7144](https://github.com/openlayers/openlayers/pull/7144) - Update sinon to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7135](https://github.com/openlayers/openlayers/pull/7135) - Update closure-util to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7126](https://github.com/openlayers/openlayers/pull/7126) - Update phantomjs-prebuilt to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
