# v5.2.0

The 5.2 release adds a few new features a handful of fixes, including regressions that were reported after the 5.1 release.  You should be able to upgrade without any additional work.  See the one note below regarding `snapToPixel` on `ol/style/Image` and subclasses.

We're still working toward type checking with TypeScript.  Until that is complete, we apologize for some flwas in the online API documentation.  We're excited about the improved experience for application developers when the effort is finished, and will highlight some of the benefit in upcoming releases.

### Upgrade Notes

#### Removal of the `snapToPixel` option for `ol/style/Image` subclasses

The `snapToPixel` option has been removed, and the `getSnapToPixel` and `setSnapToPixel` methods are deprecated.

The renderer now snaps to integer pixels when no interaction or animation is running to get crisp rendering. During interaction or animation, it does not snap to integer pixels to avoid jitter.

When rendering with the Immediate API, symbols will no longer be snapped to integer pixels. To get crisp images, set `context.imageSmoothingEnabled = false` before rendering with the Immediate API, and `context.imageSmoothingEnabled = true` afterwards.

### New Features and Fixes

 * [#8511](https://github.com/openlayers/openlayers/pull/8511) - Update IGN API key ([@openlayers](https://github.com/openlayers))
 * [#8547](https://github.com/openlayers/openlayers/pull/8547) - Fix port number in developing doc ([@pgiraud](https://github.com/pgiraud))
 * [#8546](https://github.com/openlayers/openlayers/pull/8546) - Update projection FAQ for v5 ([@ahocevar](https://github.com/ahocevar))
 * [#8481](https://github.com/openlayers/openlayers/pull/8481) - Expose some internal functions ([@gberaudo](https://github.com/gberaudo))
 * [#8510](https://github.com/openlayers/openlayers/pull/8510) - Fix WMTS URLs with dimensions ([@gberaudo](https://github.com/gberaudo))
 * [#8524](https://github.com/openlayers/openlayers/pull/8524) - Fix compatiblity with XHTML content type ([@NeoRaider](https://github.com/NeoRaider))
 * [#8532](https://github.com/openlayers/openlayers/pull/8532) - Add 'rendercomplete' event ([@ahocevar](https://github.com/ahocevar))
 * [#8529](https://github.com/openlayers/openlayers/pull/8529) - Update link to base class in docs ([@TDesjardins](https://github.com/TDesjardins))
 * [#8528](https://github.com/openlayers/openlayers/pull/8528) - Update link to base class in docs ([@TDesjardins](https://github.com/TDesjardins))
 * [#8525](https://github.com/openlayers/openlayers/pull/8525) - Re-export Projection from ol/proj for convenience ([@tschaub](https://github.com/tschaub))
 * [#8499](https://github.com/openlayers/openlayers/pull/8499) - Round center in viewState to pixels ([@ahocevar](https://github.com/ahocevar))
 * [#8520](https://github.com/openlayers/openlayers/pull/8520) - Remove redundant if block ([@openlayers](https://github.com/openlayers))
 * [#8515](https://github.com/openlayers/openlayers/pull/8515) - More convenient select and sketch layer management ([@ahocevar](https://github.com/ahocevar))
 * [#8503](https://github.com/openlayers/openlayers/pull/8503) - Avoid block scope issues in transpiled code ([@ahocevar](https://github.com/ahocevar))
 * [#8490](https://github.com/openlayers/openlayers/pull/8490) - WMTS getCapabilities readCoodinates more than one whitespace delimiter ([@MarquesDeAzevedo](https://github.com/MarquesDeAzevedo))
 * [#8489](https://github.com/openlayers/openlayers/pull/8489) - Use .prototype. only where necessary ([@ahocevar](https://github.com/ahocevar))
 * [#8478](https://github.com/openlayers/openlayers/pull/8478) - Check font availability with multiple font weights ([@ahocevar](https://github.com/ahocevar))
 * [#8483](https://github.com/openlayers/openlayers/pull/8483) - Don't create Polygon with null coordinates ([@fredj](https://github.com/fredj))
 * [#8471](https://github.com/openlayers/openlayers/pull/8471) - Add getUrl and getImageExtent to ImageStatic API ([@samuel-girard](https://github.com/samuel-girard))
 * [#8470](https://github.com/openlayers/openlayers/pull/8470) - Update Tile loading API docs ([@scroach](https://github.com/scroach))
 * [#8477](https://github.com/openlayers/openlayers/pull/8477) - Expose original getGutter ([@gberaudo](https://github.com/gberaudo))
 * [#8466](https://github.com/openlayers/openlayers/pull/8466) - Add onFocusOnly option to interaction defaults ([@ahocevar](https://github.com/ahocevar))
 * [#8465](https://github.com/openlayers/openlayers/pull/8465) - Do not prevent default on pointermove ([@ahocevar](https://github.com/ahocevar))
 * [#8461](https://github.com/openlayers/openlayers/pull/8461) - Fix double backtick typo ([@lionralfs](https://github.com/lionralfs))
 * [#8452](https://github.com/openlayers/openlayers/pull/8452) - Remove extra translate function in Geometry, add missing api tag ([@fredj](https://github.com/fredj))
 * [#8451](https://github.com/openlayers/openlayers/pull/8451) - Remove unimplemented functions ([@fredj](https://github.com/fredj))
 * [#8450](https://github.com/openlayers/openlayers/pull/8450) - Mark properties of ReadOptions and WriteOptions as optional ([@fredj](https://github.com/fredj))
 * [#8443](https://github.com/openlayers/openlayers/pull/8443) - Explicit void ([@tschaub](https://github.com/tschaub))
 * [#8437](https://github.com/openlayers/openlayers/pull/8437) - Avoid shadowing EventTarget ([@tschaub](https://github.com/tschaub))
 * [#8439](https://github.com/openlayers/openlayers/pull/8439) - Fewer dots in types ([@tschaub](https://github.com/tschaub))
 * [#8441](https://github.com/openlayers/openlayers/pull/8441) - Fix loaded script for the example-verbatim examples ([@fredj](https://github.com/fredj))
 * [#8435](https://github.com/openlayers/openlayers/pull/8435) - Call setCoordinates on the point instance ([@fredj](https://github.com/fredj))
 * [#8428](https://github.com/openlayers/openlayers/pull/8428) - Type name on same line as type ([@tschaub](https://github.com/tschaub))
 * [#8422](https://github.com/openlayers/openlayers/pull/8422) - Improve JSDoc such that `ng build --prod` with angular/cli 6.0.8 succeeds again ([@jkoelewijn](https://github.com/jkoelewijn))
 * [#8396](https://github.com/openlayers/openlayers/pull/8396) - Fix ol.interaction.Draw~createRegularPolygon ([@iamplex](https://github.com/iamplex))
 * [#8420](https://github.com/openlayers/openlayers/pull/8420) - Keep function names when building examples ([@ahocevar](https://github.com/ahocevar))
 * [#8419](https://github.com/openlayers/openlayers/pull/8419) - Release v5.1.3 ([@tschaub](https://github.com/tschaub))
 * [#8417](https://github.com/openlayers/openlayers/pull/8417) - Minor doc updates ([@tschaub](https://github.com/tschaub))
 * [#8418](https://github.com/openlayers/openlayers/pull/8418) - Set api annotation on classdesc, not constructor ([@ahocevar](https://github.com/ahocevar))
 * [#8414](https://github.com/openlayers/openlayers/pull/8414) - Updates for 5.1.2 ([@tschaub](https://github.com/tschaub))
 * [#8413](https://github.com/openlayers/openlayers/pull/8413) - Remove extra curly in type ([@tschaub](https://github.com/tschaub))
 * [#8412](https://github.com/openlayers/openlayers/pull/8412) - Changes for 5.1.1. ([@tschaub](https://github.com/tschaub))


<details>
  <summary>Dependency Updates</summary>

 * [#8543](https://github.com/openlayers/openlayers/pull/8543) - Update rollup to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8541](https://github.com/openlayers/openlayers/pull/8541) - Update proj4 to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8542](https://github.com/openlayers/openlayers/pull/8542) - Update rollup-plugin-commonjs to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8533](https://github.com/openlayers/openlayers/pull/8533) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8530](https://github.com/openlayers/openlayers/pull/8530) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8522](https://github.com/openlayers/openlayers/pull/8522) - Update marked to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8505](https://github.com/openlayers/openlayers/pull/8505) - Update karma to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8501](https://github.com/openlayers/openlayers/pull/8501) - Update rollup-plugin-commonjs to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8495](https://github.com/openlayers/openlayers/pull/8495) - Update rollup to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8493](https://github.com/openlayers/openlayers/pull/8493) - Update clean-css-cli to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8491](https://github.com/openlayers/openlayers/pull/8491) - Update rollup to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8486](https://github.com/openlayers/openlayers/pull/8486) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8476](https://github.com/openlayers/openlayers/pull/8476) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8475](https://github.com/openlayers/openlayers/pull/8475) - Update clean-css-cli to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8469](https://github.com/openlayers/openlayers/pull/8469) - Update rollup to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8453](https://github.com/openlayers/openlayers/pull/8453) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8447](https://github.com/openlayers/openlayers/pull/8447) - Update rollup-plugin-commonjs to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#8426](https://github.com/openlayers/openlayers/pull/8426) - Update webpack to the latest version 🚀 ([@openlayers](https://github.com/openlayers))


</details>
