@## Color aliases

These variables are semantic aliases of our [colors](#colors).
They are used throughout Blueprint itself to ensure consistent color usage across components.

<table class="pt-table docs-color-aliases-table">
    <thead>
        <tr>
            <th></th>
            <th>Variable</th>
            <th>Description</th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td>
                <div class="docs-color-bubble alias-intent-primary"></div>
            </td>
            <td><code>$pt-intent-primary</code></td>
            <td>Primary intent color</td>
        </tr>
        <tr>
            <td>
                <div class="docs-color-bubble alias-intent-success"></div>
            </td>
            <td><code>$pt-intent-success</code></td>
            <td>Success intent color</td>
        </tr>
        <tr>
            <td>
                <div class="docs-color-bubble alias-intent-warning"></div>
            </td>
            <td><code>$pt-intent-warning</code></td>
            <td>Warning intent color</td>
        </tr>
        <tr>
            <td>
                <div class="docs-color-bubble alias-intent-danger"></div>
            </td>
            <td><code>$pt-intent-danger</code></td>
            <td>Danger intent color</td>
        </tr>
        <!---->
        <tr>
            <td>
                <div class="docs-color-bubble alias-app-background-color"></div>
            </td>
            <td><code>$pt-app-background-color</code></td>
            <td>Application background color</td>
        </tr>
        <tr>
            <td>
                <div class="docs-color-bubble alias-dark-app-background-color"></div>
            </td>
            <td><code>$pt-dark-app-background-color</code></td>
            <td>Dark theme application background color</td>
        </tr>
        <!---->
        <tr>
            <td>
                <div class="docs-color-bubble alias-text-color"></div>
            </td>
            <td><code>$pt-text-color</code></td>
            <td>Default text color</td>
        </tr>
        <tr>
            <td>
                <div class="docs-color-bubble alias-text-color-muted"></div>
            </td>
            <td><code>$pt-text-color-muted</code></td>
            <td>Muted text color</td>
        </tr>
        <tr>
            <td>
                <div class="docs-color-bubble alias-text-color-disabled"></div>
            </td>
            <td><code>$pt-text-color-disabled</code></td>
            <td>Disabled text color</td>
        </tr>
        <tr>
            <td>
                <div class="docs-color-bubble alias-heading-color"></div>
            </td>
            <td><code>$pt-heading-color</code></td>
            <td>Text color for headers</td>
        </tr>
        <tr>
            <td>
                <div class="docs-color-bubble alias-link-color"></div>
            </td>
            <td><code>$pt-link-color</code></td>
            <td>Text color for links</td>
        </tr>
        <tr>
            <td>
                <div class="docs-color-bubble alias-dark-text-color"></div>
            </td>
            <td><code>$pt-dark-text-color</code></td>
            <td>Dark theme default text color</td>
        </tr>
        <tr>
            <td>
                <div class="docs-color-bubble alias-dark-text-color-muted"></div>
            </td>
            <td><code>$pt-dark-text-color-muted</code></td>
            <td>Dark theme muted text color</td>
        </tr>
        <tr>
            <td>
                <div class="docs-color-bubble alias-dark-text-color-disabled"></div>
            </td>
            <td><code>$pt-dark-text-color-disabled</code></td>
            <td>Dark theme disabled text color</td>
        </tr>
        <tr>
            <td>
                <div class="docs-color-bubble alias-dark-heading-color"></div>
            </td>
            <td><code>$pt-dark-heading-color</code></td>
            <td>Dark theme text color for headers</td>
        </tr>
        <tr>
            <td>
                <div class="docs-color-bubble alias-dark-link-color"></div>
            </td>
            <td><code>$pt-dark-link-color</code></td>
            <td>Dark theme text color for links</td>
        </tr>
        <tr>
            <td>
                <div class="docs-color-bubble alias-text-selection-color"></div>
            </td>
            <td><code>$pt-text-selection-color</code></td>
            <td>Text selection color</td>
        </tr>
        <!---->
        <tr>
            <td>
                <div class="docs-color-bubble alias-icon-color"></div>
            </td>
            <td><code>$pt-icon-color</code></td>
            <td>Default icon color</td>
        </tr>
        <tr>
            <td>
                <div class="docs-color-bubble alias-icon-color-hover"></div>
            </td>
            <td><code>$pt-icon-color-hover</code></td>
            <td>Hovered icon color</td>
        </tr>
        <tr>
            <td>
                <div class="docs-color-bubble alias-icon-color-disabled"></div>
            </td>
            <td><code>$pt-icon-color-disabled</code></td>
            <td>Disabled icon color</td>
        </tr>
        <tr>
            <td>
                <div class="docs-color-bubble alias-icon-color-selected"></div>
            </td>
            <td><code>$pt-icon-color-selected</code></td>
            <td>Selected icon color</td>
        </tr>
        <tr>
            <td>
                <div class="docs-color-bubble alias-dark-icon-color"></div>
            </td>
            <td><code>$pt-dark-icon-color</code></td>
            <td>Dark theme default icon color</td>
        </tr>
        <tr>
            <td>
                <div class="docs-color-bubble alias-dark-icon-color-hover"></div>
            </td>
            <td><code>$pt-dark-icon-color-hover</code></td>
            <td>Dark theme hovered icon color</td>
        </tr>
        <tr>
            <td>
                <div class="docs-color-bubble alias-dark-icon-color-disabled"></div>
            </td>
            <td><code>$pt-dark-icon-color-disabled</code></td>
            <td>Dark theme disabled icon color</td>
        </tr>
        <tr>
            <td>
                <div class="docs-color-bubble alias-dark-icon-color-selected"></div>
            </td>
            <td><code>$pt-dark-icon-color-selected</code></td>
            <td>Dark theme selected icon color</td>
        </tr>
        <!---->
        <tr>
            <td>
                <div class="docs-color-bubble alias-divider-black"></div>
            </td>
            <td><code>$pt-divider-black</code></td>
            <td>Black divider color</td>
        </tr>
        <tr>
            <td>
                <div class="docs-color-bubble alias-dark-divider-black"></div>
            </td>
            <td><code>$pt-dark-divider-black</code></td>
            <td>Dark theme black divider color</td>
        </tr>
        <tr>
            <td>
                <div class="docs-color-bubble alias-dark-divider-white"></div>
            </td>
            <td><code>$pt-dark-divider-white</code></td>
            <td>Dark theme white divider color</td>
        </tr>
        <!---->
        <tr>
            <td>
                <div class="docs-color-bubble alias-code-text-color"></div>
            </td>
            <td><code>$pt-code-text-color</code></td>
            <td>Code text color</td>
        </tr>
        <tr>
            <td>
                <div class="docs-color-bubble alias-code-background-color"></div>
            </td>
            <td><code>$pt-code-background-color</code></td>
            <td>Code background color</td>
        </tr>
        <tr>
            <td>
                <div class="docs-color-bubble alias-dark-code-text-color"></div>
            </td>
            <td><code>$pt-dark-code-text-color</code></td>
            <td>Dark theme code text color</td>
        </tr>
        <tr>
            <td>
                <div class="docs-color-bubble alias-dark-code-background-color"></div>
            </td>
            <td><code>$pt-dark-code-background-color</code></td>
            <td>Dark theme code background color</td>
        </tr>
    </tbody>
</table>
