// @flow

/*::
import * as React from 'react'

export type Component = React.ComponentType<{}>

export type Adapter = {
  mount: (ElementSpec, mountPoint: Element, props: {}) => void,
  update: (ElementSpec, mountPoint: Element, props: {}) => void,
  unmount: (ElementSpec, mountPoint: Element) => void
}

export type PropertyMap = {
  [string]: ?string
}

export type ElementMap = {
  [string]: ElementSpec | Component
}

export type Defaults = {
  attributes?: Array<string>,
  quiet?: boolean,
  shadow?: boolean
}

export type ElementSpec = {
  component: Component,
  adapter?: Adapter,
  attributes?: Array<string>,
  quiet?: boolean,
  shadow?: boolean
}

export type ReactAdapter = Adapter

export type ElementEvents = {
  onMount: (source: Element, mountPoint: Element) => void,
  onUpdate: (source: Element, mountPoint: Element) => void,
  onUnmount: (source: Element, mountPoint: Element) => void
}
*/
