---
meta:
  title: Spacing Tokens
  description: Spacing tokens are used to provide consistent spacing between content in your app.
---

# Spacing Tokens

Spacing tokens are used to provide consistent spacing between content in your app.

| Token                   | Value          | Example                                                                                                         |
| ----------------------- | -------------- | --------------------------------------------------------------------------------------------------------------- |
| `--sl-spacing-3x-small` | 0.125rem (2px) | <div class="spacing-demo" style="width: var(--sl-spacing-3x-small); height: var(--sl-spacing-3x-small);"></div> |
| `--sl-spacing-2x-small` | 0.25rem (4px)  | <div class="spacing-demo" style="width: var(--sl-spacing-2x-small); height: var(--sl-spacing-2x-small);"></div> |
| `--sl-spacing-x-small`  | 0.5rem (8px)   | <div class="spacing-demo" style="width: var(--sl-spacing-x-small); height: var(--sl-spacing-x-small);"></div>   |
| `--sl-spacing-small`    | 0.75rem (12px) | <div class="spacing-demo" style="width: var(--sl-spacing-small); height: var(--sl-spacing-small);"></div>       |
| `--sl-spacing-medium`   | 1rem (16px)    | <div class="spacing-demo" style="width: var(--sl-spacing-medium); height: var(--sl-spacing-medium);"></div>     |
| `--sl-spacing-large`    | 1.25rem (20px) | <div class="spacing-demo" style="width: var(--sl-spacing-large); height: var(--sl-spacing-large);"></div>       |
| `--sl-spacing-x-large`  | 1.75rem (28px) | <div class="spacing-demo" style="width: var(--sl-spacing-x-large); height: var(--sl-spacing-x-large);"></div>   |
| `--sl-spacing-2x-large` | 2.25rem (36px) | <div class="spacing-demo" style="width: var(--sl-spacing-2x-large); height: var(--sl-spacing-2x-large);"></div> |
| `--sl-spacing-3x-large` | 3rem (48px)    | <div class="spacing-demo" style="width: var(--sl-spacing-3x-large); height: var(--sl-spacing-3x-large);"></div> |
| `--sl-spacing-4x-large` | 4.5rem (72px)  | <div class="spacing-demo" style="width: var(--sl-spacing-4x-large); height: var(--sl-spacing-4x-large);"></div> |
