---
meta:
  title: Community
  description: Shoelace has a growing community of designers and developers that are building amazing things with web components.
---

# Community

Shoelace has a growing community of designers and developers that are building amazing things with web components. We'd love for you to become a part of it!

Please be respectful of other users and remember that Shoelace is an open source project. We'll try to help when we can, but there's no guarantee we'll be able solve your problem. Please manage your expectations and don't forget to contribute back to the conversation when you can!

## Discussion Forum

The [discussion forum](https://github.com/shoelace-style/shoelace/discussions) is open to anyone with a GitHub account. This is the best place to:

- Ask for help
- Share ideas and get feedback
- Show the community what you're working on
- Learn more about the project, its values, and its roadmap

<sl-button variant="primary" href="https://github.com/shoelace-style/shoelace/discussions" target="_blank">
  <sl-icon name="github" slot="prefix"></sl-icon>
  Join the Discussion
</sl-button>

## Community Chat

The [community chat](https://discord.gg/mg8f26C) is open to the public and powered by [Discord](https://discord.com/). This is a good place to:

- Ask for help
- Share ideas and get feedback
- Show the community what you're working on
- Chat live with other designers, developers, and Shoelace fans

<sl-button variant="primary" href="https://discord.gg/mg8f26C" target="_blank">
  <sl-icon name="discord" slot="prefix"></sl-icon>
  Join the Chat
</sl-button>

## Stack Overflow

You can post questions on Stack Overflow using [the "shoelace" tag](https://stackoverflow.com/questions/tagged/shoelace). This is a public forum where talented developers answer questions. It's a great way to get help, but it is not maintained by the Shoelace author.

<sl-button variant="primary" href="https://stackoverflow.com/questions/ask?tags=shoelace" target="_blank">
  <sl-icon name="stack-overflow" slot="prefix"></sl-icon>
  Ask for Help
</sl-button>

## Twitter

Follow [@shoelace_style](https://twitter.com/shoelace_style) on Twitter for general updates and announcements about Shoelace. This is a great place to say "hi" or to share something you're working on. You're also welcome to follow [@claviska](https://twitter.com/claviska), the creator, for tweets about web components, web development, and life.

**Please avoid using Twitter for support questions.** The [discussion forum](https://github.com/shoelace-style/shoelace/discussions) is a much better place to share code snippets, screenshots, and other troubleshooting info. You'll have much better luck there, as more users will have a chance to help you.

<sl-button variant="primary" href="https://twitter.com/shoelace_style" target="_blank">
  <sl-icon name="twitter" slot="prefix"></sl-icon>
  Follow on Twitter
</sl-button>
