---
meta:
  title: Border Radius
  description: Border radius tokens are used to give sharp edges a more subtle, rounded effect.
---

# Border Radius Tokens

Border radius tokens are used to give sharp edges a more subtle, rounded effect. They use rem units so they scale with the base font size. The pixel values displayed are based on a 16px font size.

| Token                        | Value           | Example                                                                                                  |
| ---------------------------- | --------------- | -------------------------------------------------------------------------------------------------------- |
| `--sl-border-radius-small`   | 0.1875rem (3px) | <div class="border-radius-demo" style="border-radius: var(--sl-border-radius-small);"></div>             |
| `--sl-border-radius-medium`  | 0.25rem (4px)   | <div class="border-radius-demo" style="border-radius: var(--sl-border-radius-medium);"></div>            |
| `--sl-border-radius-large`   | 0.5rem (8px)    | <div class="border-radius-demo" style="border-radius: var(--sl-border-radius-large);"></div>             |
| `--sl-border-radius-x-large` | 1rem (16px)     | <div class="border-radius-demo" style="border-radius: var(--sl-border-radius-x-large);"></div>           |
| `--sl-border-radius-circle`  | 50%             | <div class="border-radius-demo" style="border-radius: var(--sl-border-radius-circle);"></div>            |
| `--sl-border-radius-pill`    | 9999px          | <div class="border-radius-demo" style="border-radius: var(--sl-border-radius-pill); width: 6rem;"></div> |
