# Examples

## Online
- [Counter](https://codesandbox.io/s/8no2n9k94l) Simple Counter
- [Simple Todos](https://codesandbox.io/s/lrm786ojqz) Todos with LocalStorage persistence
- [Simple Routing](https://codesandbox.io/s/jjp8m8nlz5) Use 'switch' control flow for simple routing
- [Scoreboard](https://codesandbox.io/s/solid-scoreboard-sjpje) Make use of hooks to do some simple transitions
- [Tic Tac Toe](https://playground.solidjs.com/?hash=1586517762&version=1.0.0) Simple Example of the classic game
- [Form Validation](https://codesandbox.io/s/solid-form-validation-2cdti) HTML 5 validators with custom async validation
- [CSS Animations](https://codesandbox.io/s/basic-css-transition-36rln?file=/index.js) Using Solid Transition Group
- [Styled Components](https://codesandbox.io/s/solid-styled-components-yv2t1) A simple example of creating Styled Components.
- [Styled JSX](https://codesandbox.io/s/solid-styled-jsx-xgx6b) A simple example of using Styled JSX with Solid.
- [Counter Context](https://codesandbox.io/s/counter-context-gur76) Implement a global store with Context API
- [Async Resource](https://codesandbox.io/s/2o4wmxj9zy) Ajax requests to SWAPI with Promise cancellation
- [Async Resource GraphQL](https://codesandbox.io/s/async-resource-graphql-r4rcx?file=/index.js) Simple resource for handling graphql request.
- [Suspense](https://codesandbox.io/s/5v67oym224) Various Async loading with Solid's Suspend control flow
- [Suspense Tabs](https://codesandbox.io/s/solid-suspense-tabs-vkgpj) Deferred loading spinners for smooth UX.
- [SuspenseList](https://codesandbox.io/s/solid-suspenselist-eorvk) Orchestrating multiple Suspense Components.
- [Redux Undoable Todos](https://codesandbox.io/s/pkjw38r8mj) Example from Redux site done with Solid.
- [Simple Todos Template Literals](https://codesandbox.io/s/jpm68z1q33) Simple Todos using Lit DOM Expressions
- [Simple Todos HyperScript](https://codesandbox.io/s/0vmjlmq94v) Simple Todos using Hyper DOM Expressions

## Demos
- [TodoMVC](https://github.com/solidjs/solid-todomvc) Classic TodoMVC example
- [Real World Demo](https://github.com/solidjs/solid-realworld) Real World Demo for Solid
- [Hacker News](https://github.com/solidjs/solid-hackernews) Hacker News Clone for Solid
- [Storybook](https://github.com/rturnq/storybook-solid) Solid with Storybook

## Benchmarks
- [JS Framework Benchmark](https://github.com/krausest/js-framework-benchmark/tree/master/frameworks/keyed/solid) The one and only
- [Sierpinski's Triangle Demo](https://github.com/ryansolid/solid-sierpinski-triangle-demo) Solid implementation of the React Fiber demo.
- [WebComponent Todos](https://github.com/shprink/web-components-todo/tree/main/solid) Showing off Solid Element
- [UIBench Benchmark](https://github.com/ryansolid/solid-uibench) a benchmark tests a variety of UI scenarios.
- [DBMon Benchmark](https://github.com/ryansolid/solid-dbmon) A benchmark testing ability of libraries to render unoptimized data.
