# Spectral v2/v3 to v4 Migration Guide

If you haven't written a custom ruleset or never used a config file, then it is unlikely the v4 breaking changes affect you, and you can upgrade your Spectral version right away.

Our docs have been updated, so you can always refer to them. To make the transition less painful,
this migration guide covers the most notable changes.

> Note: 3.0 version was a bit of a transition-version, without any significant changes, besides the config file we removed in 4.0.

### I have my own custom rulesets...

A couple of the properties in rules have changed:

1. `enabled` was replaced with `recommended`

Spectral v4 re-worked the general approach to rulesets. As a result, the `enabled` property is no longer needed. Following other linters such as ESLint, we decided that each ruleset should come with a recommended set of rules. If you happened to make use of `enabled`, all you need to do is to rename the property key to `recommended`. The semantics have not changed much, and therefore a plain extends will still pick up all recommended rules by default.

2. `summary` property is gone

We introduced a more powerful `message` property. It not only lets you define a static message, but also lets you compose them.

If you want to print the error thrown by the rule function, you can do so as follows:

```js
message: "{{error}}";
```

Printing description is just as straightforward:

```js
message: "{{description}}";
```

If you want the relevant property key to be printed instead:

```js
message: "{{property}}";
```

Keep in mind, `property` might be an empty string.

You can also compose a fancier message if you'd like to:

```js
message: "Errored at {{property}}... Error message is: {{error}}";
```

Let us know if there is any shorthand you'd like to see in the future.

A real-world example of the migration can be found [here](https://github.com/stoplightio/spectral/issues/367).

3. `jsonpath` is swapped with `jsonpath-plus`

There shouldn't be any significant differences, but `jsonpath-plus` does come with its own syntax for special selectors.
Please refer to their [docs](https://github.com/s3u/JSONPath#features) for the comprehensive list.

You can also take a look at changes we had to make [internally](https://github.com/stoplightio/spectral/pull/347/commits/c79691da636f76c5b0ab5c611779d6be16d32292).

### I use Spectral via CLI...

1. Config files are no longer supported

The config file (which was `spectral.yml` by default, or using the `--config` cli argument) was a combination of things that could all be done as CLI flags, and was meant to reduce how much you needed to type within the CLI.

Rather than using a separate config file to configure the CLI, in Spectral v4 you must pass the relevant CLI arguments in the CLI itself.

The important stuff has been replaced with looking for a default ruleset, called `.spectral.yml` (notice the `.` prefix) and loading a ruleset and skipping a rule would now look like this:

```yaml
extends: spectral:oas2 # we extend all recommended rules from spectral:oas2
rules:
  operation-operationId-unique: off
```

In the above example, all recommended rules from built-in OAS2 ruleset would be enabled, while the built in `operation-operationId-unique` rule would be disabled entirely.

> Note: You can still use `--skip-rule` flag via CLI, but we truly believe the ruleset approach is a way to go.

This change shouldn't hurt you much, as the CLI supports _all_ flags that the config file did, so no functionality will be missing.

Ruleset files are quite flexible in Spectral v4, see [docs](../getting-started/3-rulesets.md) for more info.

2. `--max-results` flag is removed

Most users wanted to see all errors and warnings, not just a few, so it wasn’t that useful.

### I use Spectral programmatically via API...

1. Import paths have changed

In 4.0 we significantly changed our release process, therefore, as a side affect, the project structure we submit to NPM is a bit different.

**Spectral v2/v3**:

```js
const { oas3Functions, rules: oas3Rules } = require("@stoplight/spectral/rulesets/oas3");
```

**Spectral v4**:

```js
const { oas3Functions, rules: oas3Rules } = require("@stoplight/spectral/dist/rulesets/oas3");
```

Note, the `dist` in between. This is the only difference. You'll need to apply the change to all other imports accordingly.
In future, we will simplify rulesets loading even further, so you won't need any of that.

More on that can be found [here](https://github.com/stoplightio/spectral/issues/366).

2. `json-ref-resolver` has been updated

If you ever provided a custom resolver, you might need to bump json-ref-resolver package to reflect the potential changes in interfaces we introduced.

Additionally, we suggest updating `@stoplight/yaml` and `@stoplight/json` if you happened to be using them.
