# Spectral v4 to v5 Migration Guide

Our docs have been updated, so you can always refer to them. To make the transition less painful,
this migration guide covers the most notable changes.

### I have my own custom rulesets...

1. oas2 and oas3 rulesets have been merged to oas

From now on, you don't need to worry about oas2 or oas3, you simply extend oas ruleset and Spectral will figure out which rules to apply based on given formats.

**Spectral v4**:

```json
{
  "extends": ["spectral:oas2", "spectral:oas3"]
}
```

**Spectral v5**:

```json
{
  "extends": ["spectral:oas"]
}
```

2. All rules are recommended by default now

Previously it wasn't quite clear that you need to make rule recommended in order to have it enabled by default.
We addressed it and right now you need to explicitly mark rule as unrecommended assuming you do want it to be so.

**Spectral v4**:

```json
{
  "rules": {
    "true-info-contact": {
      "message": "Info must contain Stoplight",
      "given": "$.info.contact",
      "then": {
        "function": "truthy"
      }
    }
  }
}
```

**Spectral v5**:

```json
{
  "rules": {
    "true-info-contact": {
      "message": "Info must contain Stoplight",
      "given": "$.info.contact",
      "recommended": false,
      "then": {
        "function": "truthy"
      }
    }
  }
}
```

3. `when` has been dropped

`when` wasn't particularly useful and we haven't seen any real-world usage of it, even internally in our own rulesets.
Since there is a way to write a rule avoiding `when` we decided to get rid of it to reduce complexity.

**Spectral v4**:

```json
{
  "rules": {
    "error-response-description": {
      "given": "$.responses[*]",
      "when": {
        "field": "@key",
        "pattern": "^4.*"
      },
      "then": {
        "field": "description",
        "function": "truthy"
      }
    }
  }
}
```

**Spectral v5**:

```json
{
  "rules": {
    "error-response-description": {
      "given": "$.responses.[?(@property >= 400 && @property < 500)]",
      "then": {
        "field": "description",
        "function": "truthy"
      }
    }
  }
}
```

### I use Spectral programmatically via API...

1. addFunctions and addRules have been removed

We strongly encourage everyone to write rulesets, therefore the new preferred way to load a ruleset is via `loadRuleset`.

**Spectral v4**:

```js
const { oas3Functions, rules: oas3Rules } = require("@stoplight/spectral/dist/rulesets/oas3");

const spectral = new Spectral();
spectral.addFunctions(oas3Functions);
spectral.addFunctions(oas3Rules);
spectral.run(myOpenApiDocument).then(results => {
  console.log("here are the results", results);
});
```

**Spectral v5**:

```js
const { Spectral } = require("@stoplight/spectral");

const spectral = new Spectral();
spectral
  .loadRuleset("spectral:oas")
  .then(() => spectral.run(myOpenApiDocument))
  .then(results => {
    console.log("here are the results", results);
  });
```

Alternatively, if your ruleset is stored in a plain JSON file, you can also consider using `setRuleset`, as follows

```js
const { Spectral } = require("@stoplight/spectral");
const ruleset = require("./my-ruleset.json");

const spectral = new Spectral();
spectral.setRuleset(ruleset);
spectral.run(myOpenApiDocument).then(results => {
  console.log("here are the results", results);
});
```
