'use strict';

const getUnitFromValueNode = require('../getUnitFromValueNode');
const valueParser = require('postcss-value-parser');

it('getUnitFromValueNode', () => {
	expect(getUnitFromValueNode()).toBeNull();
	expect(getUnitFromValueNode({})).toBeNull();
	expect(getUnitFromValueNode(valueParser('1.1s').nodes[0])).toBe('s');
	expect(getUnitFromValueNode(valueParser('1.1000s').nodes[0])).toBe('s');
	expect(getUnitFromValueNode(valueParser('1.1S').nodes[0])).toBe('S');
	expect(getUnitFromValueNode(valueParser('+1.1s').nodes[0])).toBe('s');
	expect(getUnitFromValueNode(valueParser('+1.1000s').nodes[0])).toBe('s');
	expect(getUnitFromValueNode(valueParser('-1.1s').nodes[0])).toBe('s');
	expect(getUnitFromValueNode(valueParser('-1.1000s').nodes[0])).toBe('s');
	expect(getUnitFromValueNode(valueParser('1.1e10s').nodes[0])).toBe('s');
	expect(getUnitFromValueNode(valueParser('+1.1e10s').nodes[0])).toBe('s');
	expect(getUnitFromValueNode(valueParser('-1.1e10s').nodes[0])).toBe('s');
	expect(getUnitFromValueNode(valueParser('1.1e+10s').nodes[0])).toBe('s');
	expect(getUnitFromValueNode(valueParser('1.1e-10s').nodes[0])).toBe('s');
	expect(getUnitFromValueNode(valueParser('+1.1e+10s').nodes[0])).toBe('s');
	expect(getUnitFromValueNode(valueParser('+1.1e-10s').nodes[0])).toBe('s');
	expect(getUnitFromValueNode(valueParser('-1.1e-10s').nodes[0])).toBe('s');
	expect(getUnitFromValueNode(valueParser('-1.1e+10s').nodes[0])).toBe('s');
	expect(getUnitFromValueNode(valueParser('1px').nodes[0])).toBe('px');
	expect(getUnitFromValueNode(valueParser('1pX').nodes[0])).toBe('pX');
	expect(getUnitFromValueNode(valueParser('1PX').nodes[0])).toBe('PX');
	expect(getUnitFromValueNode(valueParser('+1px').nodes[0])).toBe('px');
	expect(getUnitFromValueNode(valueParser('-1px').nodes[0])).toBe('px');
	expect(getUnitFromValueNode(valueParser('1e1px').nodes[0])).toBe('px');
	expect(getUnitFromValueNode(valueParser('+1e1px').nodes[0])).toBe('px');
	expect(getUnitFromValueNode(valueParser('-1e1px').nodes[0])).toBe('px');
	expect(getUnitFromValueNode(valueParser('1e-1px').nodes[0])).toBe('px');
	expect(getUnitFromValueNode(valueParser('1e+1px').nodes[0])).toBe('px');
	expect(getUnitFromValueNode(valueParser('+1e+1px').nodes[0])).toBe('px');
	expect(getUnitFromValueNode(valueParser('+1e-1px').nodes[0])).toBe('px');
	expect(getUnitFromValueNode(valueParser('-1e-1px').nodes[0])).toBe('px');
	expect(getUnitFromValueNode(valueParser('-1e+1px').nodes[0])).toBe('px');
	expect(getUnitFromValueNode(valueParser('.1s').nodes[0])).toBe('s');
	expect(getUnitFromValueNode(valueParser('+.1s').nodes[0])).toBe('s');
	expect(getUnitFromValueNode(valueParser('-.1s').nodes[0])).toBe('s');
	expect(getUnitFromValueNode(valueParser('+.1000s').nodes[0])).toBe('s');
	expect(getUnitFromValueNode(valueParser('-.1000s').nodes[0])).toBe('s');
	expect(getUnitFromValueNode(valueParser('.1e1s').nodes[0])).toBe('s');
	expect(getUnitFromValueNode(valueParser('+.1e1s').nodes[0])).toBe('s');
	expect(getUnitFromValueNode(valueParser('-.1e1s').nodes[0])).toBe('s');
	expect(getUnitFromValueNode(valueParser('.1e-1s').nodes[0])).toBe('s');
	expect(getUnitFromValueNode(valueParser('.1e+1s').nodes[0])).toBe('s');
	expect(getUnitFromValueNode(valueParser('+.1e+1s').nodes[0])).toBe('s');
	expect(getUnitFromValueNode(valueParser('+.1e-1s').nodes[0])).toBe('s');
	expect(getUnitFromValueNode(valueParser('-.1e-1s').nodes[0])).toBe('s');
	expect(getUnitFromValueNode(valueParser('-.1e+1s').nodes[0])).toBe('s');
	expect(getUnitFromValueNode(valueParser('100%').nodes[0])).toBe('%');
	expect(getUnitFromValueNode(valueParser('100').nodes[0])).toBe('');
	expect(getUnitFromValueNode(valueParser('0\\0').nodes[0])).toBe('');
	expect(getUnitFromValueNode(valueParser('10px\\9').nodes[0])).toBe('px');
	expect(getUnitFromValueNode(valueParser('6e-2px').nodes[0])).toBe('px');
	expect(getUnitFromValueNode(valueParser('.0').nodes[0])).toBe('');
	expect(getUnitFromValueNode(valueParser('+.0').nodes[0])).toBe('');
	expect(getUnitFromValueNode(valueParser('-.0').nodes[0])).toBe('');
	expect(getUnitFromValueNode(valueParser('.0e1').nodes[0])).toBe('');
	expect(getUnitFromValueNode(valueParser('+.0e1').nodes[0])).toBe('');
	expect(getUnitFromValueNode(valueParser('-.0e1').nodes[0])).toBe('');
	expect(getUnitFromValueNode(valueParser('#fff').nodes[0])).toBeNull();
	expect(getUnitFromValueNode(valueParser('#000').nodes[0])).toBeNull();
	expect(getUnitFromValueNode(valueParser('#zzzzzz').nodes[0])).toBeNull();
	expect(getUnitFromValueNode(valueParser('#F').nodes[0])).toBeNull();
	expect(getUnitFromValueNode(valueParser('#PX').nodes[0])).toBeNull();
	expect(getUnitFromValueNode(valueParser('"100"').nodes[0])).toBeNull();
	expect(getUnitFromValueNode(valueParser('"100px"').nodes[0])).toBeNull();
	expect(getUnitFromValueNode(valueParser(' ').nodes[0])).toBeNull();
	expect(getUnitFromValueNode(valueParser('/').nodes[0])).toBeNull();
	expect(getUnitFromValueNode(valueParser('+').nodes[0])).toBeNull();
	expect(getUnitFromValueNode(valueParser('word').nodes[0])).toBeNull();
	expect(getUnitFromValueNode(valueParser('px').nodes[0])).toBeNull();
	expect(getUnitFromValueNode(valueParser('url()').nodes[0])).toBeNull();
	expect(getUnitFromValueNode(valueParser('url()px').nodes[0])).toBeNull();
	expect(getUnitFromValueNode(valueParser('$variable').nodes[0])).toBeNull();
	expect(getUnitFromValueNode(valueParser('${$variable}').nodes[0])).toBeNull();
	expect(getUnitFromValueNode(valueParser('${$variable}px').nodes[0])).toBeNull();
	expect(getUnitFromValueNode(valueParser('${$variable}px').nodes[0])).toBeNull();
	expect(getUnitFromValueNode(valueParser('@variable').nodes[0])).toBeNull();
	expect(getUnitFromValueNode(valueParser('e1').nodes[0])).toBeNull();
	expect(getUnitFromValueNode(valueParser('wordPX').nodes[0])).toBeNull();
	expect(getUnitFromValueNode(valueParser('..0').nodes[0])).toBeNull();
});
