---
title: Overview
page_title: Overview | Kendo UI Accessibility Support
description: "Learn about the general requirements web applications have to meet to be accessible and the Accessibility support Kendo UI controls provide."
slug: overview_accessibility_support_kendoui
position: 1
---

# Accessibility Overview

In terms of web components, accessibility means that the websites and applications provide full control over their features by enabling users with disabilities to access them through assistive technologies such as screen readers.

Assistive technologies work well for the most basic and text-driven websites and applications. However, the Web is dynamically changing and is now well beyond the realm of text-based experiences. As a result, assistive technologies struggle to keep up.

Web developers can do a lot to bridge this gap between the current challenges which web applications pose to disabled users and the capabilities which assistive technologies support. By providing features, such as full keyboard support, high-contrast visual elements, and text-based equivalents of non-text elements, and by adhering to standards like [WAI-ARIA](https://www.w3.org/WAI/PF/aria-practices/), [WCAG 2.1](https://www.w3.org/TR/WCAG21/), and [Section 508](https://www.section508.gov), developers deliver completely accessible and rich Internet applications.

The Kendo UI for jQuery components are highly extensible and customizable. Depending on the level of customization applied, you may be introducing rendering that is not accessible. Therefore, it is recommended that web developers test any modifications and templates they create to ensure the components still meet the desired level of accessibility standards. Additionally, be mindful of components working with custom input (images, text, HTML content, and so on) and make sure your content is accessible, too.

## See Also

* [Section 508 Support in Kendo UI]({% slug section508_accessibility_support %})
* [Section 508 and WCAG 2.1 Compliance of Kendo UI Widgets]({% slug section508_wcag21_accessibility_support %})
* [WAI-ARIA Support in Kendo UI]({% slug wai_aria_accessibility_support %})
* [Keyboard Support in Kendo UI]({% slug keyboard_shortcuts_accessibility_support %})
* [Right-to-Left Language Support in Kendo UI]({% slug right_toleft_languages_accessibility_support %})
* [Working with the Kendo UI High-Contrast Theme]({% slug high_contrast_theme_accessibility_support %})
* [Five Tips for Accessible Charts with Kendo UI]({% slug charts_accessibility_support %})
