---
title: Section 508 and WCAG 2.1 Compliance
page_title: Section 508 and WCAG 2.1 Compliance | Kendo UI Accessibility Support
description: "Learn more about the Section 508 and WCAG 2.1 Accesibility support provided by Kendo UI controls."
slug: section508_wcag21_accessibility_support
position: 3
---

# Section 508 and WCAG 2.1 Compliance

The Kendo UI widgets follow the [W3C Web Content Accessibility Guidelines 2.1](https://www.w3.org/TR/WCAG/).

They set the standards for applications for providing accessible content. Depending on the number of guidelines that is followed when building an application, W3C defines three levels of accessibility conformance&mdash;A, AA, and AAA levels.

The Kendo UI components also conform to the technical standards set out in [Section 508 (Latest Amendment)](https://www.access-board.gov/the-board/laws/rehabilitation-act-of-1973#508) of the [Rehabilitation Act of 1973](https://legcounsel.house.gov/Comps/Rehabilitation%20Act%20Of%201973.pdf). They represent the law that requires all Federal Agencies to make their electronic and information technology accessible to people with disabilities. For detailed information on the accessibility features according to the Section 508 Web content standards Kendo UI delivers, refer to the article about [Section 508]({% slug section508_accessibility_support %}).

Applications built with components that adhere to these guidelines will not only be accessible to people with disabilities, but also to users of all kinds of devices and interfaces such as desktop browsers, voice browsers, mobile phones, automobile-based personal computers, and so on.

The following table lists the Section 508 and WCAG 2.1 compliance levels of support for the Kendo UI widgets. 

> The described level of compliance in the table below is achievable with the **HighContrast Less Theme.**

**Table 1: 508 and WCAG 2.1 compliance with Kendo UI widgets**

|Component |508|WCAG 2.1|Demo
|:---          |:---|:---  |:---
|ActionSheet   |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/actionsheet/index)
|AppBar	       |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/appbar/index)
|AutoComplete  |Yes |AA  |[Browse](https://demos.telerik.com/kendo-ui/autocomplete/index)
|BarCode	   |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/barcode/index)
|BottomNavigation |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/bottomnavigation/index)
|Breadcrumb	   |Yes |AA  |[Browse](https://demos.telerik.com/kendo-ui/breadcrumb/index)
|Button 	   |Yes |AA  |[Browse](https://demos.telerik.com/kendo-ui/button/index)
|ButtonGroup   |Yes |AA  |[Browse](https://demos.telerik.com/kendo-ui/buttongroup/index)
|Calendar	   |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/calendar/index)
|Captcha       |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/captcha/index)
|Charts        |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/chart-api/index)
|Chat          |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/chat/index)
|CheckBoxGroup |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/checkboxgroup/index)
|ContextMenu   |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/menu/context-menu)
|ComboBox      |Yes |AA  |[Browse](https://demos.telerik.com/kendo-ui/combobox/index)
|ColorPicker   |Yes |AA  |[Browse](https://demos.telerik.com/kendo-ui/colorpicker/index)
|DateInput	   |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/dateinput/index)
|DatePicker	   |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/datepicker/index)
|DateTimePicker|Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/datetimepicker/index)
|Diagram	   |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/diagram/index)
|Dialog	       |Yes |AA  |[Browse](https://demos.telerik.com/kendo-ui/dialog/index)
|Drawer	       |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/drawer/index)
|DropDownList  |Yes |AA  |[Browse](https://demos.telerik.com/kendo-ui/dropdownlist/index)
|DropDownTree* |Yes |AA  |[Browse](https://demos.telerik.com/kendo-ui/dropdowntree/index)
|Editor        |Yes |AA  |[Browse](https://demos.telerik.com/kendo-ui/editor/index)
|ExpansionPanel|Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/expansionpanel/index)
|FileManager   |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/filemanager/index)
|FloatingActionButton |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/floatingactionbutton/index)
|Form          |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/form/index)
|Gantt         |Yes |AA  |[Browse](https://demos.telerik.com/kendo-ui/gantt/index)
|Grid          |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/grid/index)
|ImageEditor   |Yes |AA  |[Browse](https://demos.telerik.com/kendo-ui/imageeditor/index)
|Loader        |Yes |AАA |[Browse](https://demos.telerik.com/kendo-ui/loader/index)
|LinearGauge   |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/linear-gauge/index)
|ListBox       |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/listbox/index)
|ListView	   |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/listview/index)
|Map	       |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/map/index)
|MaskedTextbox |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/maskedtextbox/index)
|Menu          |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/menu/index)
|MediaPlayer   |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/mediaplayer/index)
|MultiColumnComboBox |Yes |AA |[Browse](https://demos.telerik.com/kendo-ui/multicolumncombobox/index)
|MultiSelect   |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/multiselect/index)
|Notification  |Yes |AA  |[Browse](https://demos.telerik.com/kendo-ui/notification/index)
|NumericTextbox|Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/numerictextbox/index)
|OrgChart	   |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/orgchart/index)
|Pager         |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/pager/index)
|PanelBar	   |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/panelbar/index)
|PivotGrid	   |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/pivotgrid/index)
|PopOver	   |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/popover/index)
|QRCode	   	   |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/qrcode/index)
|RadialGauge   |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/radial-gauge/index)
|RadioButton   |Yes |AA  |[Browse](https://demos.telerik.com/kendo-ui/styling/radios)
|RadioGroup    |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/radiogroup/index)
|Responsive Panel |Yes |AA |[Browse](https://demos.telerik.com/kendo-ui/responsive-panel/index)
|ScrollView	   |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/scrollview/index)
|Scheduler	   |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/scheduler/index)
|Slider	       |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/slider/index)
|Sortable	   |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/sortable/index)
|Splitter      |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/splitter/index)
|Spreadsheet   |No  |-   |
|Stepper	   |Yes |AA  |[Browse](https://demos.telerik.com/kendo-ui/stepper/index)
|Switch        |Yes |AA  |[Browse](https://demos.telerik.com/kendo-ui/switch/index)
|TabStrip	   |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/tabstrip/index)
|TaskBoard	   |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/taskboard/index)
|TextArea	   |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/textarea/index)
|TextBox	   |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/textbox/index)
|TileLayout	   |Yes |AA  |[Browse](https://demos.telerik.com/kendo-ui/tilelayout/index)
|TimeLine	   |Yes |A   |[Browse](https://demos.telerik.com/kendo-ui/timeline/index)
|TimePicker	   |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/timepicker/index)
|ToolBar	   |Yes |AA  |[Browse](https://demos.telerik.com/kendo-ui/toolbar/index)
|Tooltip	   |Yes |AA  |[Browse](https://demos.telerik.com/kendo-ui/tooltip/index)
|TreeList	   |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/treelist/index)
|TreeView	   |Yes |AA  |[Browse](https://demos.telerik.com/kendo-ui/treeview/index)
|Upload 	   |Yes |AA  |[Browse](https://demos.telerik.com/kendo-ui/upload/index)
|Window 	   |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/window/index)
|Wizard		   |Yes |AAA |[Browse](https://demos.telerik.com/kendo-ui/wizard/index)

> The DropDownTree widget will be identified as not compliant to the WAI-ARIA spec when tested with static HTML analyzer if there is no selection in the widget and the `placeholder` configuration is not used. That is because the DropDownTree wrapper element, which has `role="listbox"` will not contain any `option` elements. That should be considered a known limitation in the widget. Detailed information on the scenario could be found in [this GitHub issue](https://github.com/telerik/kendo-ui-core/issues/6558#issuecomment-938449528).

## Special Considerations

Several Kendo UI widgets feature complex rendering which affects their accessibility standards support provisioned by Section 508.

### Label Element Support

Widgets, such as the ComboBox, MultiSelect, and NumericTextBox, hide their initial `input` or `select` element which breaks the [`label.for`](https://developer.mozilla.org/en/docs/Web/HTML/Element/label#attr-for) focus functionality on click. In general, the browser cannot focus hidden elements. This results in the inability of the `label` element to focus the corresponding widget.

**Solution** Place the widget inside the `label` element which in turn focuses the first visible element. Avoid using the `for` attribute because when it is applied to the `label` element, the respective widget does not focus. Instead, use the `aria-labelledby` attribute on the input to point to its wrapping `label` element:

```
  <label id="label">
    Amount:
    <input id="numerictextbox" aria-labelledby="label"/>
  </label>
  <script>
    $(function() {
      $("#numerictextbox").kendoNumericTextBox();
    });
  </script>
```

### Messages Support

Widgets, such as the Grid and Calendar, require additional configuration to enable them to successfully pass the Section 508 validation. Due to the fact that they render their content in tables, each table header element has to contain text. To achieve this behavior, use the [`messages.expandCollapseColumnHeader`](/api/javascript/ui/grid/configuration/messages.expandcollapsecolumnheader) and [`messages.weekColumnHeader`](/api/javascript/ui/calendar/configuration/messages.weekcolumnheader) configuration options.

The following example demonstrates how to specify a text for the expand (collapse) column.

```
	<div id="grid"></div>
	<script>
	$("#grid").kendoGrid({
	  columns: [
	    { field: "name" },
	    { field: "age" }
	  ],
	  dataSource: {
	    data: [
	      { name: "Jane Doe", age: 30, city: "London" },
	      { name: "John Doe", age: 33, city: "Berlin" }
	    ]
	  },
	  detailInit: function (e) {
	    e.detailCell.text("City: " + e.data.city);
	  },
	  height: 200,
	  messages: {
	    expandCollapseColumnHeader: "E/C"
	  }
	});
	</script>
```

The following example demonstrates how to specify a text for the week column header.

```
    <div id="calendar"></div>
    <script>
    $("#calendar").kendoCalendar({
        "weekNumber": true,
        "messages": {
            "weekColumnHeader": "W"
        }
     })
    </script>
```

## See Also

* [Overview of Accessibility Features in Kendo UI]({% slug overview_accessibility_support_kendoui %})
* [Section 508 Support in Kendo UI]({% slug section508_accessibility_support %})
* [WAI-ARIA Support in Kendo UI]({% slug wai_aria_accessibility_support %})
* [Keyboard Support in Kendo UI]({% slug keyboard_shortcuts_accessibility_support %})
* [Right-to-Left Language Support in Kendo UI]({% slug right_toleft_languages_accessibility_support %})
* [Working with the Kendo UI High-Contrast Theme]({% slug high_contrast_theme_accessibility_support %})
* [Five Tips for Accessible Charts with Kendo UI]({% slug charts_accessibility_support %})
