---
title: Visual Studio Support
page_title: Visual Studio for Windows Support
description: "Learn about the supported versions of Visual Studio for Windows while working with Progress Telerik UI for ASP.NET Core (aka MVC 6 or ASP.NET Core MVC)."
previous_url: /getting-started/prerequisites/visual-studio-support
slug: visualstudiosupport_core
position: 6
---

# Visual Studio Support

The table below describes the minimum required version of Visual Studio based on the target `.NET Core SDK` version.

| .NET CORE SDK     | VISUAL STUDIO                 | 
| :---------------- | :---------------------------- | 
| 5.0               | Visual Studio 2022, or Visual Studio 2019 version 16.8 or higher. |
| 3.1               | Visual Studio 2019 version 16.4 or higher. |
| 3.0               | Visual Studio 2019 version 16.3 or higher. |
| 2.2               | Visual Studio 2017 version 15.9 or higher. |
| 2.1               | Visual Studio 2017 version 15.7 or higher. |

## Dependencies and Requirements

To create .NET Core applications, you need to install the `.NET Core SDK`. Follow the instructions from the [official .NET Core documentation site](https://docs.microsoft.com/en-us/dotnet/core/install/sdk?pivots=os-windows).

For a full list of the `.NET Core` requirements, see [.NET Core dependencies and requirements](https://docs.microsoft.com/en-us/dotnet/core/install/dependencies?tabs=netcore31&pivots=os-windows).

## See Also

* [Web Browser Support by Telerik UI for ASP.NET Core]({% slug webbrowsersupport_core %})
* [PDF and Excel Export Support by Telerik UI for ASP.NET Core]({% slug exportsupport_core %})
* [Operation System Support by Telerik UI for ASP.NET Core]({% slug ossupport_core %})
* [Earlier Versions Support Policy by Telerik UI for ASP.NET Core]({% slug oldversionssupportpolicy_core %})
