---
title: Overview
page_title: jQuery Chart Documentation | Chart Types Overview
description: "Learn the basics when working with the chart types in the Kendo UI for jQuery suite."
previous_url: /controls/charts/chart-types/chart-types-compatibility
slug: overview_charttypes_charts
position: 1
---

{% if site.has_cta_panels == true %}
{% include cta-panel-small.html %}
{% endif %}

# Chart Types Overview

The Charts support a wide range of series types.

## Categorical Charts

[Categorical charts]({% slug htmlhelpers_categoricalcharts_aspnetcore %}) provide built-in support for displaying dates. The categories represent unique values which are not mathematically related to each other.

Examples of categorical charts are [Area]({% slug areacharts_widget %}), [Bar]({% slug bartypeofcharts_widget %}), [Box Plot]({% slug chart-types-box-plot %}), [Bullet]({% slug chart-types-bullet %}), and [Line Charts]({% slug linetypeoscharts_widget %}).

## Circular Charts

Circular charts are divided in slices representing statistical data, which proportionally corresponds to the quantity input of each slice. Circular charts are widely used in the business world and the mass media.

Examples of circular charts are [Pie Charts]({% slug pietypecharts_widget %}).

## Freeform Charts

Freeform charts adopt different forms and use variously structured portions to display data.

Examples of freeform charts are [Funnel Charts]({% slug funnelcharts_widget %}).

## Scatter Charts

[Scatter charts]({% slug scattercharts_widget %}) are suitable for displaying and comparing different sets of numerical values, for showing the relationships between the values of the data sets, and for plotting two-dimensional data as a series of XY coordinates.

Example of scatter charts are [Bubble Charts]({% slug bubblecharts_widget %}).

## Chart Types Compatibility

Your project might require you to use multiple Chart series types in a single Kendo UI Chart.

However, each Chart series has specifics of its own such as the number of values that define a single series data point, the field names that are supported by the series, or if a specific series has point markers. Also, not all series types can be combined in a single Chart plot area.

The main indicator for the Chart series compatibility is the type of axes the series use to display their values. For example, specific categorical series rely on a single category and a single value axis (Line, Bar, Area), XY series use x and y axes (Scatter, Scatter Line, Bubble), and so on. Another indicator for the Chart series compatibility is the direction of the series&mdash;for example, you cannot combine Column and Bar series, or Column and Vertical Line series. Some series have a specific layout that cannot be combined with any other Chart series type.

The following table lists the series types supported by the Chart together with their main properties and demonstrates the Chart series compatibility with each other.

| Series             | Values per Point | Field Names | Number of Series | Has Markers | Compatible Series Types |
| :---               | :---             | :---        | :---             | :---        | :---                    |
| [Area](https://demos.telerik.com/kendo-ui/area-charts/index) | 1 | [field](/api/javascript/dataviz/ui/chart/configuration/series.field), [categoryField](/api/javascript/dataviz/ui/chart/configuration/series.categoryfield), [errorLowField](/api/javascript/dataviz/ui/chart/configuration/series.errorlowfield), [errorHighField](/api/javascript/dataviz/ui/chart/configuration/series.errorhighfield), [noteTextField](/api/javascript/dataviz/ui/chart/configuration/series.notetextfield), [colorField](/api/javascript/dataviz/ui/chart/configuration/series.colorfield) (colors only the markers )	 | 1 or more | yes | Area, Column, Line, Bullet, Candlestick, Box Plot, Range Column, Range Area, Waterfall |
| [Bar](https://demos.telerik.com/kendo-ui/bar-charts/index) | 1 |  [field](/api/javascript/dataviz/ui/chart/configuration/series.field), [categoryField](/api/javascript/dataviz/ui/chart/configuration/series.categoryfield), [colorField](/api/javascript/dataviz/ui/chart/configuration/series.colorfield), [errorLowField](/api/javascript/dataviz/ui/chart/configuration/series.errorlowfield), [errorHighField](/api/javascript/dataviz/ui/chart/configuration/series.errorhighfield), [noteTextField](/api/javascript/dataviz/ui/chart/configuration/series.notetextfield) | 1 or more | no | Bar, Vertical Area, Vertical Line, Vertical Range Area  |
| [BoxPlot](https://demos.telerik.com/kendo-ui/box-plot-charts/index) | 7 | [q1Field](/api/javascript/dataviz/ui/chart/configuration/series.q1field), [q3Field](/api/javascript/dataviz/ui/chart/configuration/series.q3field), [lowerField](/api/javascript/dataviz/ui/chart/configuration/series.lowerfield), [upperField](/api/javascript/dataviz/ui/chart/configuration/series.upperfield), [medianField](/api/javascript/dataviz/ui/chart/configuration/series.medianfield), [meanField](/api/javascript/dataviz/ui/chart/configuration/series.meanfield), [outliersField](/api/javascript/dataviz/ui/chart/configuration/series.outliersfield), [colorField](/api/javascript/dataviz/ui/chart/configuration/series.colorfield) | 1 or more | no | Area, BoxPlot, Line, Range Area |
| [Bubble](https://demos.telerik.com/kendo-ui/bubble-charts/index) | 3 | [xField](/api/javascript/dataviz/ui/chart/configuration/series.xfield), [yField](/api/javascript/dataviz/ui/chart/configuration/series.yfield), [sizeField](/api/javascript/dataviz/ui/chart/configuration/series.sizefield), [categoryField](/api/javascript/dataviz/ui/chart/configuration/series.categoryfield), [colorField](/api/javascript/dataviz/ui/chart/configuration/series.colorfield), [xErrorLowField](/api/javascript/dataviz/ui/chart/configuration/series.xerrorlowfield), [xErrorHighField](/api/javascript/dataviz/ui/chart/configuration/series.xerrorhighfield), [yErrorLowField](/api/javascript/dataviz/ui/chart/configuration/series.yerrorlowfield), [yErrorHighField](/api/javascript/dataviz/ui/chart/configuration/series.yerrorhighfield), [noteTextField](/api/javascript/dataviz/ui/chart/configuration/series.notetextfield) | 1 or more | no | Bubble, Scatter, Scatter Line  |
| [Bullet](https://demos.telerik.com/kendo-ui/bullet-charts/index) | 2 | [currentField](/api/javascript/dataviz/ui/chart/configuration/series.currentfield), [targetField](/api/javascript/dataviz/ui/chart/configuration/series.targetfield), [categoryField](/api/javascript/dataviz/ui/chart/configuration/series.categoryfield), [colorField](/api/javascript/dataviz/ui/chart/configuration/series.colorfield), [noteTextField](/api/javascript/dataviz/ui/chart/configuration/series.notetextfield) | 1 or more | no | Vertical Area, Bullet, Vertical Line, Vertical Range Area  |
| [Candlestick](https://demos.telerik.com/kendo-ui/financial/index) | 4 | [openField](/api/javascript/dataviz/ui/chart/configuration/series.openfield), [closeField](/api/javascript/dataviz/ui/chart/configuration/series.closefield), [highField](/api/javascript/dataviz/ui/chart/configuration/series.highfield), [lowField](/api/javascript/dataviz/ui/chart/configuration/series.lowfield), [colorField](/api/javascript/dataviz/ui/chart/configuration/series.colorfield), [downColorField](/api/javascript/dataviz/ui/chart/configuration/series.downcolorfield) | 1 or more | no | Area, Candlestick, Line, Range Area  |
| [Column](https://demos.telerik.com/kendo-ui/bar-charts/column) | 1 |  [field](/api/javascript/dataviz/ui/chart/configuration/series.field), [categoryField](/api/javascript/dataviz/ui/chart/configuration/series.categoryfield), [colorField](/api/javascript/dataviz/ui/chart/configuration/series.colorfield), [errorLowField](/api/javascript/dataviz/ui/chart/configuration/series.errorlowfield), [errorHighField](/api/javascript/dataviz/ui/chart/configuration/series.errorhighfield), [noteTextField](/api/javascript/dataviz/ui/chart/configuration/series.notetextfield) | 1 or more | no | Area, Column, Line, Range Area  |
| [Donut](https://demos.telerik.com/kendo-ui/donut-charts/index) | 1 | [field](/api/javascript/dataviz/ui/chart/configuration/series.field), [categoryField](/api/javascript/dataviz/ui/chart/configuration/series.categoryfield), [explodeField](/api/javascript/dataviz/ui/chart/configuration/series.explodefield), [colorField](/api/javascript/dataviz/ui/chart/configuration/series.colorfield) | 1 or more | no | Donut |
| [Funnel](https://demos.telerik.com/kendo-ui/funnel-charts/index) | 1 | [field](/api/javascript/dataviz/ui/chart/configuration/series.field), [categoryField](/api/javascript/dataviz/ui/chart/configuration/series.categoryfield), [colorField](/api/javascript/dataviz/ui/chart/configuration/series.colorfield) | 1 | no | none |
| [Heatmap](https://demos.telerik.com/kendo-ui/heatmap/index) | 1 | [field](/api/javascript/dataviz/ui/chart/configuration/series.field), [xField](/api/javascript/dataviz/ui/chart/configuration/series.xfield), [yField](/api/javascript/dataviz/ui/chart/configuration/series.yfield) | 1 or more | yes | none |
| [Horizontal Waterfall](https://demos.telerik.com/kendo-ui/waterfall-charts/horizontal) | 1 | [field](/api/javascript/dataviz/ui/chart/configuration/series.field), [summaryField](/api/javascript/dataviz/ui/chart/configuration/series.summaryfield), [categoryField](/api/javascript/dataviz/ui/chart/configuration/series.categoryfield), [colorField](/api/javascript/dataviz/ui/chart/configuration/series.colorfield), [noteTextField](/api/javascript/dataviz/ui/chart/configuration/series.notetextfield) | 1 | no | Vertical Area, Vertical Line, Vertical Range Area |
| [Line](https://demos.telerik.com/kendo-ui/line-charts/index) | 1 | [field](/api/javascript/dataviz/ui/chart/configuration/series.field), [categoryField](/api/javascript/dataviz/ui/chart/configuration/series.categoryfield), [errorLowField](/api/javascript/dataviz/ui/chart/configuration/series.errorlowfield), [errorHighField](/api/javascript/dataviz/ui/chart/configuration/series.errorhighfield), [noteTextField](/api/javascript/dataviz/ui/chart/configuration/series.notetextfield), [colorField](/api/javascript/dataviz/ui/chart/configuration/series.colorfield) (colors only the markers ) | 1 or more | yes | Area, Column, Bullet, Candlestick, Box Plot, Range Column, Range Area, Waterfall |
| [Ohlc](https://demos.telerik.com/kendo-ui/financial/index) | 4 | [openField](/api/javascript/dataviz/ui/chart/configuration/series.openfield), [closeField](/api/javascript/dataviz/ui/chart/configuration/series.closefield), [highField](/api/javascript/dataviz/ui/chart/configuration/series.highfield), [lowField](/api/javascript/dataviz/ui/chart/configuration/series.lowfield), [colorField](/api/javascript/dataviz/ui/chart/configuration/series.colorfield), [downColorField](/api/javascript/dataviz/ui/chart/configuration/series.downcolorfield) | 1 or more | no | Area, Line, Ohlc, Range Area |
| [Pie](https://demos.telerik.com/kendo-ui/pie-charts/index) | 1 | [field](/api/javascript/dataviz/ui/chart/configuration/series.field), [categoryField](/api/javascript/dataviz/ui/chart/configuration/series.categoryfield), [explodeField](/api/javascript/dataviz/ui/chart/configuration/series.explodefield), [colorField](/api/javascript/dataviz/ui/chart/configuration/series.colorfield) | 1 | no | none |
| [Polar Area](https://demos.telerik.com/kendo-ui/polar-charts/polar-area) | 2 | [xField](/api/javascript/dataviz/ui/chart/configuration/series.xfield), [yField](/api/javascript/dataviz/ui/chart/configuration/series.yfield), [colorField](/api/javascript/dataviz/ui/chart/configuration/series.colorfield) (colors only the markers )  | 1 or more | yes | Polar Area, Polar Line, Polar Scatter |
| [Polar Line](https://demos.telerik.com/kendo-ui/polar-charts/index) | 2 | [xField](/api/javascript/dataviz/ui/chart/configuration/series.xfield), [yField](/api/javascript/dataviz/ui/chart/configuration/series.yfield), [colorField](/api/javascript/dataviz/ui/chart/configuration/series.colorfield) (colors only the markers )  | 1 or more | yes | Polar Area, Polar Line, Polar Scatter |
| [Polar Scatter](https://demos.telerik.com/kendo-ui/polar-charts/polar-scatter) | 2 | [xField](/api/javascript/dataviz/ui/chart/configuration/series.xfield), [yField](/api/javascript/dataviz/ui/chart/configuration/series.yfield), [colorField](/api/javascript/dataviz/ui/chart/configuration/series.colorfield) (colors only the markers )  | 1 or more | yes | Polar Area, Polar Line, Polar Scatter |
| [Radar Area](https://demos.telerik.com/kendo-ui/radar-charts/radar-area) | 1 |  [field](/api/javascript/dataviz/ui/chart/configuration/series.field), [categoryField](/api/javascript/dataviz/ui/chart/configuration/series.categoryfield), [colorField](/api/javascript/dataviz/ui/chart/configuration/series.colorfield) (colors only the markers ) | 1 or more | yes | Radar Area, Radar Column, Radar Line |
| [Radar Column](https://demos.telerik.com/kendo-ui/radar-charts/radar-column) | 1 |  [field](/api/javascript/dataviz/ui/chart/configuration/series.field), [categoryField](/api/javascript/dataviz/ui/chart/configuration/series.categoryfield) | 1 or more | no | Radar Area, Radar Column, Radar Line |
| [Radar Line](https://demos.telerik.com/kendo-ui/radar-charts/index) | 1 |  [field](/api/javascript/dataviz/ui/chart/configuration/series.field), [categoryField](/api/javascript/dataviz/ui/chart/configuration/series.categoryfield), [colorField](/api/javascript/dataviz/ui/chart/configuration/series.colorfield) (colors only the markers ) | 1 or more | yes | Radar Area, Radar Column, Radar Line |
| [Range Area](https://demos.telerik.com/kendo-ui/range-area-charts/index) | 2 | [fromField](/api/javascript/dataviz/ui/chart/configuration/series.fromfield), [toField](/api/javascript/dataviz/ui/chart/configuration/series.tofield), [categoryField](/api/javascript/dataviz/ui/chart/configuration/series.categoryfield), [colorField](/api/javascript/dataviz/ui/chart/configuration/series.colorfield) (colors only the markers ) | 1 or more | yes | Area, Box Plot, Bullet, Candlestick, Column, Line, Ohlc, Range Area, Range Column |
| [Range Bar](https://demos.telerik.com/kendo-ui/range-bar-charts/local-data-binding) | 2 | [fromField](/api/javascript/dataviz/ui/chart/configuration/series.fromfield), [toField](/api/javascript/dataviz/ui/chart/configuration/series.tofield), [categoryField](/api/javascript/dataviz/ui/chart/configuration/series.categoryfield), [noteTextField](/api/javascript/dataviz/ui/chart/configuration/series.notetextfield), [colorField](/api/javascript/dataviz/ui/chart/configuration/series.colorfield) | 1 or more | no | Range Bar, Vertical Area, Vertical Line, Vertical Range Area |
| [Range Column](https://demos.telerik.com/kendo-ui/range-bar-charts/index) | 2 | [fromField](/api/javascript/dataviz/ui/chart/configuration/series.fromfield), [toField](/api/javascript/dataviz/ui/chart/configuration/series.tofield), [categoryField](/api/javascript/dataviz/ui/chart/configuration/series.categoryfield), [noteTextField](/api/javascript/dataviz/ui/chart/configuration/series.notetextfield), [colorField](/api/javascript/dataviz/ui/chart/configuration/series.colorfield) | 1 or more | no | Area, Line, Range Area, Range Column |
| [Scatter](https://demos.telerik.com/kendo-ui/scatter-charts/index) | 2 | [xField](/api/javascript/dataviz/ui/chart/configuration/series.xfield), [yField](/api/javascript/dataviz/ui/chart/configuration/series.yfield), [colorField](/api/javascript/dataviz/ui/chart/configuration/series.colorfield), [noteTextField](/api/javascript/dataviz/ui/chart/configuration/series.notetextfield), [xErrorLowField](/api/javascript/dataviz/ui/chart/configuration/series.xerrorlowfield), [xErrorHighField](/api/javascript/dataviz/ui/chart/configuration/series.xerrorhighfield), [yErrorLowField](/api/javascript/dataviz/ui/chart/configuration/series.yerrorlowfield), [yErrorHighField](/api/javascript/dataviz/ui/chart/configuration/series.yerrorhighfield) | 1 or more | yes | Bubble, Scatter, Scatter Line |
| [Scatter Line](https://demos.telerik.com/kendo-ui/scatter-charts/scatter-line) | 2 | [xField](/api/javascript/dataviz/ui/chart/configuration/series.xfield), [yField](/api/javascript/dataviz/ui/chart/configuration/series.yfield), [noteTextField](/api/javascript/dataviz/ui/chart/configuration/series.notetextfield), [xErrorLowField](/api/javascript/dataviz/ui/chart/configuration/series.xerrorlowfield), [xErrorHighField](/api/javascript/dataviz/ui/chart/configuration/series.xerrorhighfield), [yErrorLowField](/api/javascript/dataviz/ui/chart/configuration/series.yerrorlowfield), [yErrorHighField](/api/javascript/dataviz/ui/chart/configuration/series.yerrorhighfield), [colorField](/api/javascript/dataviz/ui/chart/configuration/series.colorfield) (colors only the markers) | 1 or more | yes | Bubble, Scatter, Scatter Line |
| [Vertical Area](https://demos.telerik.com/kendo-ui/area-charts/index) | 1 | [field](/api/javascript/dataviz/ui/chart/configuration/series.field), [categoryField](/api/javascript/dataviz/ui/chart/configuration/series.categoryfield), [errorLowField](/api/javascript/dataviz/ui/chart/configuration/series.errorlowfield), [errorHighField](/api/javascript/dataviz/ui/chart/configuration/series.errorhighfield), [noteTextField](/api/javascript/dataviz/ui/chart/configuration/series.notetextfield), [colorField](/api/javascript/dataviz/ui/chart/configuration/series.colorfield) (colors only the markers )	 | 1 or more | yes | Bar, Bullet, Horizontal Waterfall, Range Bar, Vertical Range Area, Vertical Box Plot, Vertical Line |
| [Vertical Box Plot](https://demos.telerik.com/kendo-ui/box-plot-charts/vertical) | 7 | [q1Field](/api/javascript/dataviz/ui/chart/configuration/series.q1field), [q3Field](/api/javascript/dataviz/ui/chart/configuration/series.q3field), [lowerField](/api/javascript/dataviz/ui/chart/configuration/series.lowerfield), [upperField](/api/javascript/dataviz/ui/chart/configuration/series.upperfield), [medianField](/api/javascript/dataviz/ui/chart/configuration/series.medianfield), [meanField](/api/javascript/dataviz/ui/chart/configuration/series.meanfield), [outliersField](/api/javascript/dataviz/ui/chart/configuration/series.outliersfield), [colorField](/api/javascript/dataviz/ui/chart/configuration/series.colorfield) | 1 or more | no | Vertical Area, Vertical Box Plot, Vertical Line, Vertical Range Area |
| [Vertical Bullet](https://demos.telerik.com/kendo-ui/bullet-charts/local-data-binding) | 2 | [currentField](/api/javascript/dataviz/ui/chart/configuration/series.currentfield), [targetField](/api/javascript/dataviz/ui/chart/configuration/series.targetfield), [categoryField](/api/javascript/dataviz/ui/chart/configuration/series.categoryfield), [colorfield](/api/javascript/dataviz/ui/chart/configuration/series.colorfield), [noteTextField](/api/javascript/dataviz/ui/chart/configuration/series.notetextfield) | 1 or more | no | Area, Line, Range Area, Vertical Bullet |
| [Vertical Line](https://demos.telerik.com/kendo-ui/line-charts/index) | 1 | [field](/api/javascript/dataviz/ui/chart/configuration/series.field), [categoryField](/api/javascript/dataviz/ui/chart/configuration/series.categoryfield), [errorLowField](/api/javascript/dataviz/ui/chart/configuration/series.errorlowfield), [errorHighField](/api/javascript/dataviz/ui/chart/configuration/series.errorhighfield), [noteTextField](/api/javascript/dataviz/ui/chart/configuration/series.notetextfield), [colorField](/api/javascript/dataviz/ui/chart/configuration/series.colorfield) (colors only the markers ) | 1 or more | yes | Bar, Bullet, Horizontal Waterfall, Range Bar, Vertical Area, Vertical Box Plot, Vertical Line, Vertical Range Area |
| [Vertical Range Area](https://demos.telerik.com/kendo-ui/range-area-charts/index) | 2 | [fromField](/api/javascript/dataviz/ui/chart/configuration/series.fromfield), [toField](/api/javascript/dataviz/ui/chart/configuration/series.tofield), [categoryField](/api/javascript/dataviz/ui/chart/configuration/series.categoryfield), [colorField](/api/javascript/dataviz/ui/chart/configuration/series.colorfield) (colors only the markers ) | 1 or more | yes | Bar, Bullet, Horizontal Waterfall, Range Bar, Vertical Area, Vertical Box Plot, Vertical Range Area |
| [Waterfall](https://demos.telerik.com/kendo-ui/waterfall-charts/index) | 1 | [field](/api/javascript/dataviz/ui/chart/configuration/series.field), [summaryField](/api/javascript/dataviz/ui/chart/configuration/series.summaryfield), [categoryField](/api/javascript/dataviz/ui/chart/configuration/series.categoryfield), [colorField](/api/javascript/dataviz/ui/chart/configuration/series.colorfield), [noteTextField](/api/javascript/dataviz/ui/chart/configuration/series.notetextfield) | 1 | no | Area, Line, Waterfall |

## See Also

* [Using the API of the Chart (Demo)](https://demos.telerik.com/kendo-ui/chart-api/index)
* [JavaScript API Reference of the Chart](/api/javascript/dataviz/ui/chart)
